# Clean Architecture Deliberate Practice

Project for learning Clean Architecture concepts created by Robert. C. Martin

## Motivation

I want to learn if there is a way to develop web applications that are framework agnostic and based on what I know so far about Clean Architecture, that is one possible way of achieving it. Also, the Clean Architecture of Uncle Bob sounds to me like a very logical and natural approach for developing software, but I have doubts about how to implement it in the context of frontend development and when a stack is made of different programming languages. Therefore, my objective is to clarify these doubts and learn more in-depth the Clean Architecture concepts as formulated by Uncle Bob.

## Deliberate Practice

- **Build Practice Plans**:
  - Define clear goals and select learning materials
  - Create deadlines and milestones for the project
  - Estimate time required and come up with weekly schedules
- **Targetted Practice**: I will develop a sample web application that implements the Clean Architecture and has its view layer in React and in Vue.
- **Immediate Feedback**: I will write blog posts that summarize my learnings and practice.

## Performance Goals

The goals should be real, concrete things, instead of subjective values like "I want to understand...".

- **Immediate**: Read and summarize the book Clean Architecture
- **Short Term**: Write a blog post that explains with my own words the main concepts of the Clean Architecture.
- **Medium Term**: Create a web app in JavaScript/Typescript that implements the Clean Architecture principles. The web app will have a view layer in React and in Vue.
- **Long Term**: Learn how Clean Architecture could be applied to apps that use different programming languages for Backend and Frontend. (Review this).

## Project Goals

- **Outcome**:
  - Create a web app in React and Vue that implements the Clean Architecture
  - Clearly define with my own words the main concepts of the Clean Architecture
  - Write 15 posts to track progress
- **Curriculum**: see the [Planning Doc](PLANNING.MD)
- **Timeframe**: 2 months starting on the week of November 24th, 2020

## Project Milestones

- Read The Clean Architecture book
- Build a Web App in React and in Vue that implements the Clean Architecture
  - Write class diagrams
  - Write flow of control diagrams
  - Write data flow diagrams
- Write 15 reports, one for each week

### References

[Repository - robert8138/python-deliberate-practice](https://github.com/robert8138/python-deliberate-practice)

---

#### Disclaimer

I got the idea to start this project from [Robert Chang](https://medium.com/@rchang/how-i-build-learning-projects-part-i-54dbaad68961) and created this repo having [python-deliberate-practice](https://github.com/robert8138/python-deliberate-practice) as a model.