# Planning

## Schedule

- **Week 0**
  - Survey materials
- **Week 1**
  - [ ] The Clean Architecture chapters 1, 2, 3
  - [ ] [The Clean Architecture Blog Post by Uncle Bob](https://blog.cleancoder.com/uncle-bob/2012/08/13/the-clean-architecture.html)
  - [X] [Dependency Injection - Wikipedia](https://en.wikipedia.org/wiki/Dependency_inversion_principle)
  - [X] [45 - Clean Architecture](https://www.youtube.com/watch?v=ONj4zvLtmpA)
- **Week 2**
  - [ ] The Clean Architecture chapters 4, 5, 6
  - [ ] [Clean architecture for the rest of us](https://pusher.com/tutorials/clean-architecture-introduction)
  - [X] [The Principles of Clean Architecture by Uncle Bob Martin](https://www.youtube.com/watch?v=o_TH-Y78tt4)
- **Week 3**
  - The Clean Architecture chapters 6, 7, 9
  - [Making Architecture Matter - Martin Fowler Keynote](https://www.youtube.com/watch?v=DngAZyWMGR0)
  - [Explaining Clean Architecture](https://www.oncehub.com/blog/explaining-clean-architecture/)
- **Week 4**
  - The Clean Architecture chapters 9, 10, 11
  - [Robert C Martin - Clean Architecture and Design](https://www.youtube.com/watch?v=Nsjsiz2A9mg)
  - [Organizing App Logic with the Clean Architecture [with Examples]](https://khalilstemmler.com/articles/software-design-architecture/organizing-app-logic/)
- **Week 5**
  - The Clean Architecture chapters 12, 13, 14
  - [ITkonekt 2019 | Robert C. Martin (Uncle Bob), Clean Architecture and Design](https://www.youtube.com/watch?v=2dKZ-dWaCiU)
  - [Clean Architecture: Standing on the shoulders of giants](https://herbertograca.com/2017/09/28/clean-architecture-standing-on-the-shoulders-of-giants/)
  - Domain-centric Architecture module of [Clean Architecture: Patterns, Practices, and Principles](https://www.pluralsight.com/courses/clean-architecture-patterns-practices-principles)
- **Week 6**
  - The Clean Architecture chapters 15, 16, 17
  - [Clean Architecture with ASP.NET Core with Steve "Ardalis" Smith (2020-06-01)](https://www.youtube.com/watch?v=joNTQy-KXiU)
  - Application Layer module of [Clean Architecture: Patterns, Practices, and Principles](https://www.pluralsight.com/courses/clean-architecture-patterns-practices-principles)
- **Week 7**
  - The Clean Architecture chapters 18, 19, 20
  - [Robert C Martin - Clean Architecture](https://www.youtube.com/watch?v=Nltqi7ODZTM)
  - [Clean Architecture Is Screaming](https://dzone.com/articles/clean-architecture-is-screaming)
  - Commands and Queries module of [Clean Architecture: Patterns, Practices, and Principles](https://www.pluralsight.com/courses/clean-architecture-patterns-practices-principles)
- **Week 8**
  - The Clean Architecture chapters 21, 22, 23
  - [DevTernity 2019: Ian Cooper - The Clean Architecture](https://www.youtube.com/watch?v=SxJPQ5qXisw)
  - Functional Organization module of [Clean Architecture: Patterns, Practices, and Principles](https://www.pluralsight.com/courses/clean-architecture-patterns-practices-principles)
- **Week 9**
  - The Clean Architecture chapters 24, 25, 26
  - [A couple of thoughts on Clean Architecture](https://blog.sourced-bvba.be/article/2017/02/14/thoughts-on-clean-architecture/)
  - Microservices module of [Clean Architecture: Patterns, Practices, and Principles](https://www.pluralsight.com/courses/clean-architecture-patterns-practices-principles)
- **Week 10**
  - The Clean Architecture chapters 27, 29, 29
  - Testable Architecture module of [Clean Architecture: Patterns, Practices, and Principles](https://www.pluralsight.com/courses/clean-architecture-patterns-practices-principles)
- **Week 11**
  - The Clean Architecture chapters 30, 31, 32
  - Evolving Architecture module of [Clean Architecture: Patterns, Practices, and Principles](https://www.pluralsight.com/courses/clean-architecture-patterns-practices-principles)
  - [Clean architecture series - Part 1](https://dev.to/pereiren/clean-architecture-series-part-1-m64)
- **Week 12**
  - The Clean Architecture chapters 33 and 34
  - [Clean architecture series — Part 2](https://dev.to/pereiren/clean-architecture-series-part-2-49db)
  - [Clean architecture series — Part 3](https://dev.to/pereiren/clean-architecture-series-part-3-2795)
- **Week 13: Views against Clean Architecture**
  - [Clean Architecture: The Bad Parts](https://www.jamesmichaelhickey.com/clean-architecture/)
  - [Why I can't recommend Clean Architecture by Robert C Martin](https://dev.to/bosepchuk/why-i-cant-recommend-clean-architecture-by-robert-c-martin-ofd)
  - [Is "Clean Architecture" by Bob Martin a rule of thumb for all architectures or is it just one of the options?](https://softwareengineering.stackexchange.com/questions/371966/is-clean-architecture-by-bob-martin-a-rule-of-thumb-for-all-architectures-or-i)
- **Week 14: The Clean Architecture on the Frontend**
  - Research projects on GitHub that use the Clean Architecture
    - try to identify patterns from these projects on the integration with the view layer
    - Repositories:
      - [ivanpaulovich/clean-architecture-manga](https://github.com/ivanpaulovich/clean-architecture-manga)
      - [matthewrenze/clean-architecture-demo](https://github.com/matthewrenze/clean-architecture-demo)
      - [jbuget/nodejs-clean-architecture-app](https://github.com/jbuget/nodejs-clean-architecture-app)
      - [eduardomoroni/react-clean-architecture](https://github.com/eduardomoroni/react-clean-architecture)
      - [falsy/react-with-clean-architecture](https://github.com/falsy/react-with-clean-architecture)
      - [rmanguinho/clean-react](https://github.com/rmanguinho/clean-react)
  - [React: How to Apply Clean Architecture](https://www.youtube.com/watch?v=qOH2X5hciiA)
  
- **Week 15: The Clean Architecure applied**
  - Create a sample project that has backend, frontend, and that implements the Clean Architecture
  - [Using Clean Architecture for Microservice APIs in Node.js with MongoDB and Express](https://www.youtube.com/watch?v=CnailTcJV_U)
  - [Implementing the Clean Architecture](https://www.entropywins.wtf/blog/2016/11/24/implementing-the-clean-architecture/)
  - [Real Life Clean Architecture](https://www.slideshare.net/mattiabattiston/real-life-clean-architecture-61242830)

### Resources for review
https://khalilstemmler.com/articles/software-design-architecture/domain-driven-design-vs-clean-architecture/
https://confpad.io/2017-04-10-android-makers-2017/22-one-year-of-clean-architecture-the-good-the-bad-and-the-bob
https://rules.ssw.com.au/rules-to-better-clean-architecture
https://www.codingblocks.net/podcast/clean-architecture-keeping-your-options-open/
https://craftsmanshipcounts.com/clean-architecture-compare-critique-java/
https://www.packtpub.com/product/get-your-hands-dirty-on-clean-architecture/9781839211966
https://www.packtpub.com/product/get-your-hands-dirty-on-clean-architecture/9781839211966