# Summary

* [Introduction](intro/intro.md)
  * [History](intro/history.md)
  * [Toolchain](intro/overview.md)
  * [User Interface](intro/ui.md)
  * [r2con](intro/r2con.md)
  * [Contribute](intro/contribute.md)
* [Installation](install/intro.md)
  * [Building from Source](install/download.md)
  * [Portability in Mind](install/build.md)
  * [Windows builds](install/windows.md)
  * [Compiling for Android](install/android.md)
  * [Flatpak releases](install/flatpak.md)
  * [Snap releases](install/snap.md)
  * [Docker containers](install/docker.md)
  * [Troubleshooting](install/troubleshooting.md)
* [First Steps](first_steps/intro.md)
  * [Commandline](first_steps/commandline_flags.md)
  * [Command Syntax](first_steps/syntax.md)
  * [Math Expressions](first_steps/expressions.md)
  * [Debugger Session](first_steps/basic_debugger_session.md)
* [Programs](tools/intro.md)
  * [Rax2](tools/rax2/intro.md)
  * [Rafind2](tools/rafind2/intro.md)
  * [Rarun2](tools/rarun2/intro.md)
  * [r2pm](tools/r2pm/intro.md)
  * [Rabin2](tools/rabin2/intro.md)
    * [File Types](tools/rabin2/file_identification.md)
    * [Entrypoint](tools/rabin2/entrypoints.md)
    * [Imports](tools/rabin2/imports.md)
    * [Exports](tools/rabin2/exports.md)
    * [Symbols](tools/rabin2/symbols.md)
    * [Debug Symbols](tools/rabin2/debug_symbols.md)
    * [Libraries](tools/rabin2/libraries.md)
    * [Strings](tools/rabin2/strings.md)
    * [Sections](tools/rabin2/program_sections.md)
  * [Radiff2](tools/radiff2/intro.md)
    * [Data Diffing](tools/radiff2/datadiff.md)
    * [Comparing Code](tools/radiff2/codediff.md)
    * [Headers Diffing](tools/radiff2/bindiff.md)
    * [Binary Diffing](tools/radiff2/binary_diffing.md)
  * [Rasm2](tools/rasm2/intro.md)
    * [Assemble](tools/rasm2/assemble.md)
    * [Disassemble](tools/rasm2/disassemble.md)
    * [Configuration](tools/rasm2/config.md)
  * [Ragg2](tools/ragg2/ragg2.md)
    * [Language](tools/ragg2/lang.md)
    * [Encoders](tools/ragg2/encoders.md)
    * [Padding](tools/ragg2/padding.md)
  * [Rahash2](tools/rahash2/intro.md)
    * [Rahash Tool](tools/rahash2/rahash_tool.md)
    * [Encoding and Encryption](tools/rahash2/encode.md)
* [Configuration](config/intro.md)
  * [Files](config/files.md)
  * [Colors](config/colors.md)
  * [Settings](config/evars.md)
  * [IO](config/io.md)
* [Projects](projects/intro.md)
  * [Usage](projects/usage.md)
  * [Annotations](projects/annotations.md)
  * [Handmade Setup](projects/handmade.md)
  * [Versioning](projects/version.md)
  * [Challenges](projects/challenges.md)
* [Commandline](commandline/intro.md)
  * [Dietline](commandline/dietline.md)
  * [Seeking](commandline/seeking.md)
  * [Block Size](commandline/block_size.md)
  * [Sections](commandline/sections.md)
  * [Mapping Files](commandline/mapping_files.md)
  * [Print Modes](commandline/print_modes.md)
  * [Flags](commandline/flags.md)
  * [Write](commandline/write.md)
  * [Zoom](commandline/zoom.md)
  * [Yank/Paste](commandline/yank_paste.md)
  * [Comparing Bytes](commandline/comparing_bytes.md)
    * [Watching for Changes](commandline/cmp_watchers.md)
  * [SDB](commandline/sdb.md)
* [Visual Mode](visual/intro.md)
  * [Visual Disassembly](visual/visual_disassembly.md)
  * [Visual Assembler](visual/visual_assembler.md)
  * [Visual Configuration Editor](visual/visual_configuration_editor.md)
  * [Visual Menus](visual/visual_menus.md)
  * [Visual Panels](visual/visual_panels.md)
* [Searching](search/intro.md)
  * [Basic Searches](search/basic_searches.md)
  * [Configurating the Search](search/configurating_the_search.md)
  * [Pattern Search](search/pattern_search.md)
  * [Automation](search/automation.md)
  * [Backward Search](search/backward_search.md)
  * [Search in Assembly](search/search_in_assembly.md)
  * [Cryptographic Materials](search/searching_crypto.md)
* [Disassembling](arch/intro.md)
  * [Decompilers](arch/decompile.md)
  * [Metadata](arch/metadata.md)
  * [Architectures](arch/plugins.md)
  * [Notes on 8051](arch/8051.md)
* [Analysis](analysis/intro.md)
  * [Code Analysis](analysis/code_analysis.md)
  * [Variables](analysis/variables.md)
  * [Types](analysis/types.md)
  * [Calling Conventions](analysis/calling_conventions.md)
  * [Virtual Tables](analysis/vtables.md)
  * [Syscalls](analysis/syscalls.md)
  * [Signatures](signatures/zignatures.md)
  * [Graph commands](analysis/graphs.md)
* [Emulation](emulation/intro.md)
  * [Introduction to ESIL](emulation/esil.md)
  * [Computed Analysis](emulation/analysis.md)
* [Scripting](scripting/intro.md)
  * [R2JS](scripting/r2js.md)
  * [Loops](scripting/loops.md)
  * [Macros](scripting/macros.md)
  * [R2pipe](scripting/r2pipe.md)
  * [R2pipe2](scripting/r2pipe2.md)
* [Debugger](debugger/intro.md)
  * [Getting Started](debugger/getting_started.md)
  * [IDA, GDB or WinDBG](debugger/migration.md)
  * [Registers](debugger/registers.md)
  * [Memory Maps](debugger/memory_maps.md)
  * [Heap](debugger/heap.md)
  * [Signals](debugger/signals.md)
  * [Files](debugger/files.md)
  * [Reverse Debugging](debugger/revdebug.md)
  * [Windows Messages](debugger/windows_messages.md)
  * [Remote Access](debugger/remoting_capabilities.md)
    * [Remote GDB](debugger/remote_gdb.md)
    * [Remote WinDbg](debugger/windbg.md)
* [Plugins](plugins/intro.md)
  * [IO plugins](plugins/ioplugins.md)
  * [Asm plugins](plugins/dev-asm.md)
  * [Analysis plugins](plugins/dev-anal.md)
  * [Bin plugins](plugins/dev-bin.md)
  * [Charset plugins](plugins/dev-charset.md)
  * [R2JS plugins](plugins/r2js.md)
  * [Python plugins](plugins/python.md)
  * [Other plugins](plugins/dev-other.md)
  * [Troubleshooting](plugins/troubles.md)
  * [Testing](plugins/testing.md)
  * [Packaging](plugins/r2pm.md)
* [R2Frida](r2frida/intro.md)
  * [First Steps](r2frida/first_steps.md)
* [R2Yara](r2yara/intro.md)
* [Firmware Reversing](r2fwrev/intro.md)
  * [Setup](r2fwrev/setup.md)
  * [Memory](r2fwrev/memory.md)
  * [Devices](r2fwrev/devices.md)
* [Crackmes](crackmes/intro.md)
  * [IOLI](crackmes/ioli/intro.md)
    * [IOLI 0x00](crackmes/ioli/ioli_0x00.md)
    * [IOLI 0x01](crackmes/ioli/ioli_0x01.md)
    * [IOLI 0x02](crackmes/ioli/ioli_0x02.md)
    * [IOLI 0x03](crackmes/ioli/ioli_0x03.md)
    * [IOLI 0x04](crackmes/ioli/ioli_0x04.md)
    * [IOLI 0x05](crackmes/ioli/ioli_0x05.md)
    * [IOLI 0x06](crackmes/ioli/ioli_0x06.md)
    * [IOLI 0x07](crackmes/ioli/ioli_0x07.md)
    * [IOLI 0x08](crackmes/ioli/ioli_0x08.md)
    * [IOLI 0x09](crackmes/ioli/ioli_0x09.md)
  * [Avatao R3v3rs3 4](crackmes/avatao/intro.md)
    * [Using r2](crackmes/avatao/radare2.md)
    * [First Steps](crackmes/avatao/first_steps.md)
    * [Main](crackmes/avatao/main.md)
    * [The VM loop](crackmes/avatao/vmloop.md)
    * [Instruction Set](crackmes/avatao/instructionset.md)
    * [Bytecode](crackmes/avatao/bytecode.md)
    * [Outro](crackmes/avatao/outro.md)
  * [R2Wars](crackmes/r2wars/intro.md)
* [Reference Card](refcard/intro.md)
* [Acknowledgments](credits/credits.md)
