import { component$ } from '@builder.io/qwik'

export const FeaturedSection = component$(() => {
  return (
    <section>
      <div class="mx-auto max-w-8xl px-4 py-8 xl:px-3">
        <div class="flex flex-col items-center justify-center gap-2 lg:flex-row lg:gap-8">
          <div class="mx-auto mb-4 text-base tracking-tight lg:mx-0 lg:mb-0">Featured in:</div>
          <div class="flex flex-wrap items-center justify-center gap-8">
            <svg width="105" height="36" viewBox="0 0 105 36" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path
                d="M17.727 35.0829C27.2844 35.0829 35.0322 27.3351 35.0322 17.7778C35.0322 8.22043 27.2844 0.472656 17.727 0.472656C8.16966 0.472656 0.421875 8.22043 0.421875 17.7778C0.421875 27.3351 8.16966 35.0829 17.727 35.0829Z"
                fill="#6B7280"
              />
              <path
                d="M29.2706 17.7778C29.2706 16.3736 28.1351 15.2585 26.7513 15.2585C26.07 15.2585 25.4503 15.5268 24.996 15.9606C23.2616 14.7215 20.8866 13.9162 18.2433 13.8131L19.3996 8.40252L23.158 9.20779C23.1996 10.1578 23.9841 10.9219 24.9548 10.9219C25.946 10.9219 26.7513 10.1166 26.7513 9.12503C26.7513 8.13384 25.946 7.32857 24.9548 7.32857C24.2527 7.32857 23.633 7.7416 23.3439 8.34055L19.1521 7.45252C19.0281 7.43174 18.9042 7.45252 18.8214 7.51449C18.7183 7.57647 18.6563 7.67963 18.6359 7.80357L17.3552 13.8335C14.6708 13.9162 12.2546 14.7215 10.4993 15.9814C10.0266 15.5298 9.39775 15.2783 8.74404 15.2793C7.33982 15.2793 6.22469 16.4148 6.22469 17.7986C6.22469 18.831 6.84404 19.6982 7.71166 20.0908C7.67009 20.3384 7.64969 20.5863 7.64969 20.8549C7.64969 24.7369 12.1722 27.8968 17.7479 27.8968C23.3235 27.8968 27.846 24.7577 27.846 20.8549C27.846 20.607 27.8252 20.3384 27.7841 20.0908C28.6513 19.6982 29.2706 18.8102 29.2706 17.7778ZM11.9655 19.5743C11.9655 18.5831 12.7708 17.7778 13.7623 17.7778C14.7535 17.7778 15.5588 18.5831 15.5588 19.5743C15.5588 20.5655 14.7535 21.3711 13.7623 21.3711C12.7708 21.3915 11.9655 20.5655 11.9655 19.5743ZM22.0225 24.3447C20.7834 25.5838 18.4292 25.6665 17.7479 25.6665C17.0458 25.6665 14.6915 25.563 13.4729 24.3447C13.2873 24.1588 13.2873 23.8697 13.4729 23.6838C13.6588 23.4982 13.9479 23.4982 14.1338 23.6838C14.9187 24.4686 16.5708 24.7369 17.7479 24.7369C18.925 24.7369 20.5975 24.4686 21.3616 23.6838C21.5475 23.4982 21.8366 23.4982 22.0225 23.6838C22.1876 23.8697 22.1876 24.1588 22.0225 24.3447ZM21.6918 21.3915C20.7006 21.3915 19.8954 20.5862 19.8954 19.5951C19.8954 18.6039 20.7006 17.7986 21.6918 17.7986C22.6834 17.7986 23.4887 18.6039 23.4887 19.5951C23.4887 20.5655 22.6834 21.3915 21.6918 21.3915Z"
                fill="white"
              />
              <path
                d="M94.6727 14.2053C95.8817 14.2053 96.8618 13.2252 96.8618 12.0162C96.8618 10.8072 95.8817 9.82715 94.6727 9.82715C93.4638 9.82715 92.4837 10.8072 92.4837 12.0162C92.4837 13.2252 93.4638 14.2053 94.6727 14.2053Z"
                fill="#6B7280"
              />
              <path
                d="M63.4075 21.3503C64.4814 21.3503 65.1008 20.545 65.0596 19.7602C65.0392 19.3471 64.9976 19.0785 64.9564 18.8721C64.2955 16.0225 61.9828 13.9158 59.236 13.9158C55.9734 13.9158 53.3301 16.869 53.3301 20.5035C53.3301 24.1379 55.9734 27.0911 59.236 27.0911C61.2807 27.0911 62.7469 26.3478 63.8001 25.1707C64.3163 24.5925 64.2131 23.7045 63.5934 23.2707C63.0772 22.9196 62.4371 23.0436 61.9621 23.4358C61.5078 23.8285 60.6406 24.6129 59.236 24.6129C57.5843 24.6129 56.1801 23.1879 55.8702 21.3087H63.4075V21.3503ZM59.2156 16.4148C60.7022 16.4148 61.9828 17.5711 62.4578 19.1612H55.9734C56.4484 17.5507 57.7286 16.4148 59.2156 16.4148ZM53.454 15.2169C53.454 14.5975 52.9998 14.1017 52.4216 13.9986C50.6248 13.7303 48.9315 14.3908 47.9611 15.6095V15.444C47.9611 14.6799 47.3414 14.2053 46.722 14.2053C46.0403 14.2053 45.4829 14.7627 45.4829 15.444V25.5629C45.4829 26.2239 45.9783 26.802 46.6393 26.8432C47.3622 26.8844 47.9611 26.327 47.9611 25.6041V20.3795C47.9611 18.0669 49.6956 16.1669 52.091 16.4355H52.3389C52.9582 16.394 53.454 15.857 53.454 15.2169ZM95.9115 16.5387C95.9115 15.857 95.3541 15.2996 94.6728 15.2996C93.9911 15.2996 93.4337 15.857 93.4337 16.5387V25.6041C93.4337 26.2858 93.9911 26.8432 94.6728 26.8432C95.3541 26.8432 95.9115 26.2858 95.9115 25.6041V16.5387ZM77.4912 9.68276C77.4912 9.00106 76.9338 8.44368 76.2521 8.44368C75.5708 8.44368 75.0134 9.00106 75.0134 9.68276V15.1965C74.1666 14.3496 73.1134 13.9366 71.8535 13.9366C68.5909 13.9366 65.9476 16.8898 65.9476 20.5242C65.9476 24.1587 68.5909 27.1119 71.8535 27.1119C73.1134 27.1119 74.1873 26.6781 75.0338 25.8312C75.137 26.4098 75.6535 26.8432 76.2521 26.8432C76.9338 26.8432 77.4912 26.2858 77.4912 25.6041V9.68276ZM71.8743 24.6541C69.9743 24.6541 68.4462 22.8165 68.4462 20.5242C68.4462 18.2528 69.9743 16.394 71.8743 16.394C73.7743 16.394 75.3025 18.232 75.3025 20.5242C75.3025 22.8165 73.7535 24.6541 71.8743 24.6541ZM90.4186 9.68276C90.4186 9.00106 89.8612 8.44368 89.1795 8.44368C88.4982 8.44368 87.9404 9.00106 87.9404 9.68276V15.1965C87.094 14.3496 86.0408 13.9366 84.7809 13.9366C81.5183 13.9366 78.875 16.8898 78.875 20.5242C78.875 24.1587 81.5183 27.1119 84.7809 27.1119C86.0408 27.1119 87.1144 26.6781 87.9612 25.8312C88.0644 26.4098 88.5805 26.8432 89.1795 26.8432C89.8612 26.8432 90.4186 26.2858 90.4186 25.6041V9.68276ZM84.7809 24.6541C82.8809 24.6541 81.3531 22.8165 81.3531 20.5242C81.3531 18.2528 82.8809 16.394 84.7809 16.394C86.6809 16.394 88.2091 18.232 88.2091 20.5242C88.2091 22.8165 86.6809 24.6541 84.7809 24.6541ZM102.189 25.6249V16.4148H103.284C103.862 16.4148 104.378 15.9809 104.42 15.382C104.461 14.7419 103.945 14.2053 103.325 14.2053H102.189V12.4704C102.189 11.8095 101.694 11.2313 101.033 11.1901C100.31 11.149 99.7115 11.7063 99.7115 12.4292V14.2257H98.6787C98.1006 14.2257 97.5844 14.6595 97.5432 15.2584C97.5016 15.8986 98.0182 16.4355 98.6375 16.4355H99.6907V25.6457C99.6907 26.327 100.248 26.8844 100.93 26.8844C101.653 26.8432 102.189 26.3062 102.189 25.6249Z"
                fill="#6B7280"
              />
            </svg>
            <svg width="36" height="36" viewBox="0 0 36 36" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path
                d="M9.8811 14.0207C9.57556 13.7923 9.26923 13.6781 8.96369 13.6781H7.59032V21.905H8.96447C9.27002 21.905 9.57634 21.7908 9.88189 21.5624C10.1874 21.334 10.3402 20.9915 10.3402 20.534V15.0492C10.3394 14.5924 10.1859 14.2491 9.8811 14.0207ZM32.244 0.138184H3.87892C1.97321 0.138184 0.4266 1.68086 0.421875 3.58735V31.9682C0.4266 33.8747 1.97321 35.4174 3.87892 35.4174H32.244C34.1505 35.4174 35.6963 33.8747 35.701 31.9682V3.58735C35.6963 1.68086 34.1497 0.138184 32.244 0.138184ZM12.5648 20.5489C12.5648 22.0302 11.6506 24.2745 8.75658 24.2698H5.10266V11.2401H8.83375C11.6246 11.2401 12.5633 13.4813 12.564 14.9633L12.5648 20.5489ZM20.4932 13.5671H16.2975V16.5926H18.8623V18.9212H16.2975V21.9459H20.494V24.2745H15.5974C14.7186 24.2973 13.9878 23.6028 13.9658 22.7239V12.8718C13.9445 11.9937 14.6398 11.2645 15.5179 11.2425H20.494L20.4932 13.5671ZM28.6547 22.646C27.6152 25.0675 25.7528 24.5856 24.9188 22.646L21.8847 11.2433H24.4495L26.7891 20.1985L29.1177 11.2433H31.6833L28.6547 22.646Z"
                fill="#6B7280"
              />
            </svg>
            <svg width="153" height="36" viewBox="0 0 153 36" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path
                d="M36.257 17.7779C36.257 27.5959 28.2971 35.5558 18.4791 35.5558C8.65988 35.5558 0.701172 27.5959 0.701172 17.7779C0.701172 7.95871 8.66049 0 18.4791 0C28.2971 0 36.257 7.95932 36.257 17.7779Z"
                fill="#6B7280"
              />
              <path
                d="M20.8491 17.7779H15.8124V12.4445H20.8491C21.1993 12.4445 21.546 12.5135 21.8696 12.6475C22.1931 12.7815 22.4871 12.978 22.7347 13.2256C22.9823 13.4732 23.1788 13.7672 23.3128 14.0907C23.4468 14.4143 23.5158 14.761 23.5158 15.1112C23.5158 15.4614 23.4468 15.8082 23.3128 16.1317C23.1788 16.4553 22.9823 16.7492 22.7347 16.9969C22.4871 17.2445 22.1931 17.4409 21.8696 17.5749C21.546 17.7089 21.1993 17.7779 20.8491 17.7779ZM20.8491 8.88895H12.2568V26.6669H15.8124V21.3335H20.8491C24.2855 21.3335 27.0714 18.5476 27.0714 15.1112C27.0714 11.6748 24.2855 8.88895 20.8491 8.88895Z"
                fill="white"
              />
              <path
                d="M54.9329 15.6049C54.9329 14.6266 54.1814 14.0338 53.205 14.0338H50.5875V17.1577H53.2056C54.182 17.1577 54.9329 16.5649 54.9329 15.6049ZM48.1087 23.7035V11.8517H53.5533C56.0851 11.8517 57.4628 13.5626 57.4628 15.6049C57.4628 17.6296 56.0674 19.3399 53.5533 19.3399H50.5875V23.7035H48.1087ZM58.9718 23.7035V15.0632H61.1868V16.1977C61.7978 15.4645 62.8284 14.854 63.876 14.854V17.0179C63.7179 16.9832 63.5264 16.9662 63.2649 16.9662C62.5317 16.9662 61.5534 17.3845 61.1868 17.9269V23.7035H58.9718ZM71.3325 19.2699C71.3325 17.9609 70.5627 16.8264 69.1668 16.8264C67.7872 16.8264 67.0205 17.9609 67.0205 19.2705C67.0205 20.5966 67.7872 21.7311 69.1668 21.7311C70.5627 21.7311 71.3325 20.5966 71.3325 19.2699ZM64.7156 19.2699C64.7156 16.8793 66.3913 14.854 69.1668 14.854C71.9599 14.854 73.6356 16.8787 73.6356 19.2699C73.6356 21.6612 71.9599 23.7035 69.1668 23.7035C66.3913 23.7035 64.7156 21.6612 64.7156 19.2699ZM81.0945 20.7711V17.7864C80.7279 17.2271 79.9253 16.8264 79.1915 16.8264C77.9183 16.8264 77.0452 17.8211 77.0452 19.2705C77.0452 20.7358 77.9183 21.7311 79.1915 21.7311C79.9253 21.7311 80.7279 21.3304 81.0945 20.7711ZM81.0945 23.7035V22.4121C80.4306 23.2493 79.5241 23.7035 78.4935 23.7035C76.3819 23.7035 74.7586 22.0984 74.7586 19.2699C74.7586 16.5303 76.3473 14.854 78.4935 14.854C79.4882 14.854 80.4306 15.2736 81.0945 16.1454V11.8517H83.3283V23.7035H81.0945ZM91.2238 23.7035V22.4291C90.6486 23.0578 89.6363 23.7035 88.2568 23.7035C86.4072 23.7035 85.5347 22.6912 85.5347 21.0502V15.0632H87.7503V20.1777C87.7503 21.3475 88.3613 21.7311 89.3037 21.7311C90.1586 21.7311 90.8401 21.2599 91.2238 20.7705V15.0632H93.4406V23.7035H91.2238ZM95.1053 19.2699C95.1053 16.6872 96.9901 14.854 99.5741 14.854C101.302 14.854 102.349 15.6049 102.908 16.3728L101.458 17.7335C101.058 17.1401 100.447 16.8264 99.6786 16.8264C98.3344 16.8264 97.3926 17.804 97.3926 19.2705C97.3926 20.7358 98.3344 21.7311 99.6786 21.7311C100.447 21.7311 101.058 21.3821 101.458 20.8057L102.908 22.1677C102.349 22.9356 101.302 23.7035 99.5741 23.7035C96.9901 23.7035 95.1053 21.871 95.1053 19.2699ZM104.814 21.3821V17.0009H103.418V15.0632H104.814V12.7589H107.031V15.0632H108.74V17.0009H107.031V20.7887C107.031 21.3298 107.309 21.7311 107.798 21.7311C108.129 21.7311 108.445 21.6089 108.566 21.4697L109.038 23.1617C108.707 23.4597 108.113 23.7035 107.187 23.7035C105.634 23.7035 104.814 22.9009 104.814 21.3821ZM122.94 23.7035V18.589H117.441V23.7035H114.964V11.8517H117.441V16.4245H122.94V11.8523H125.435V23.7035H122.94ZM133.368 23.7035V22.4291C132.792 23.0578 131.78 23.7035 130.401 23.7035C128.551 23.7035 127.678 22.6912 127.678 21.0502V15.0632H129.894V20.1777C129.894 21.3475 130.505 21.7311 131.448 21.7311C132.303 21.7311 132.984 21.2599 133.368 20.7705V15.0632H135.585V23.7035H133.368ZM143.478 23.7035V18.3981C143.478 17.2283 142.869 16.827 141.925 16.827C141.052 16.827 140.39 17.3158 140.005 17.8047V23.7041H137.789V15.0632H140.005V16.1454C140.547 15.5174 141.594 14.854 142.955 14.854C144.823 14.854 145.713 15.901 145.713 17.5414V23.7035H143.478ZM148.354 21.3821V17.0009H146.959V15.0632H148.355V12.7589H150.572V15.0632H152.282V17.0009H150.572V20.7887C150.572 21.3298 150.85 21.7311 151.339 21.7311C151.671 21.7311 151.986 21.6089 152.108 21.4697L152.578 23.1617C152.248 23.4597 151.653 23.7035 150.728 23.7035C149.175 23.7035 148.354 22.9009 148.354 21.3821Z"
                fill="#6B7280"
              />
            </svg>
            <svg width="161" height="34" viewBox="0 0 161 34" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path d="M33.6816 0.226074H0.578125V33.3295H33.6816V0.226074Z" fill="#6B7280" />
              <path
                d="M16.0264 18.9847L10.2885 8.28125H12.9367L16.2471 15.0123C16.2471 15.1226 16.3574 15.233 16.4678 15.3433C16.5781 15.4537 16.5781 15.564 16.6885 15.7847L16.7988 15.895V16.0054C16.9092 16.2261 16.9092 16.3364 17.0195 16.5571C17.1298 16.6675 17.1299 16.8881 17.2402 16.9985C17.3505 16.6675 17.5712 16.4468 17.6816 16.0054C17.7919 15.6743 18.0126 15.3433 18.2333 15.0123L21.5436 8.28125H23.9712L18.2333 19.095V25.9364H16.0264V18.9847Z"
                fill="white"
              />
              <path
                d="M48.7988 6.62607C50.454 6.62607 51.8885 7.06745 52.9919 7.95021L51.8885 9.27435C50.8954 8.61228 49.9023 8.1709 48.6885 8.1709C46.8126 8.1709 45.3781 9.16401 44.6057 11.0399C44.1643 12.1433 43.9436 13.5778 43.9436 15.4537C43.9436 16.8881 44.1643 18.1019 44.4954 18.9847C45.3781 21.0812 46.8126 22.0743 49.0195 22.0743C50.2333 22.0743 51.3367 21.7433 52.3298 20.9709L53.4333 22.4054C51.9988 23.2881 50.454 23.7295 48.7988 23.7295C46.8126 23.7295 45.1574 22.9571 43.8333 21.3019C42.5092 19.7571 41.9574 17.6606 41.9574 15.1226C41.9574 12.5847 42.6195 10.5985 43.9436 8.94332C45.1574 7.50883 46.8126 6.62607 48.7988 6.62607Z"
                fill="#6B7280"
              />
              <path
                d="M55.0885 17.5502C55.0885 15.564 55.5299 14.0192 56.523 12.9157C57.5161 11.8123 58.7298 11.1502 60.2747 11.1502C62.0402 11.1502 63.4747 11.8123 64.4678 13.2468C65.2402 14.3502 65.5712 15.895 65.5712 17.7709C65.5712 19.9778 64.9092 21.7433 63.6954 22.8468C62.8126 23.6192 61.7092 24.0606 60.385 24.0606C58.7299 24.0606 57.5161 23.5088 56.523 22.295C55.5299 21.1916 55.0885 19.5364 55.0885 17.5502ZM62.8126 14.3502C62.2609 13.3571 61.4885 12.8054 60.2747 12.8054C59.0609 12.8054 58.2885 13.2468 57.7367 14.1295C57.2954 14.7916 57.185 15.895 57.185 17.3295C57.185 19.2054 57.4057 20.5295 57.9574 21.3019C58.5092 22.0744 59.2816 22.5157 60.385 22.5157C61.7092 22.5157 62.5919 21.8537 63.0333 20.6399C63.254 19.9778 63.3643 19.095 63.3643 17.9916C63.4747 16.3364 63.254 15.1226 62.8126 14.3502Z"
                fill="#6B7280"
              />
              <path
                d="M69.1023 14.5709C69.1023 13.3571 68.9919 12.364 68.6609 11.5916L70.5368 11.1502C70.8678 11.7019 70.9781 12.364 70.9781 12.9157V13.0261C71.4195 12.5847 71.8609 12.1433 72.5229 11.8123C73.2954 11.3709 73.9574 11.1502 74.6195 11.1502C75.6126 11.1502 76.4954 11.5916 77.0471 12.364C77.1574 12.5847 77.3781 12.9157 77.4885 13.1364C78.8126 11.8123 80.0264 11.1502 81.3505 11.1502C82.2333 11.1502 83.0057 11.4812 83.5574 12.033C84.1092 12.695 84.4402 13.4675 84.4402 14.3502V23.5088H82.454V14.4606C82.454 13.2468 81.9023 12.695 80.9092 12.695C80.3574 12.695 79.6954 12.9157 79.1436 13.3571C78.923 13.5778 78.4816 13.9088 77.9298 14.3502L77.7092 14.5709V23.5088H75.6126V14.9019C75.6126 14.1295 75.5023 13.5778 75.2816 13.3571C74.9505 13.0261 74.6195 12.9157 74.0678 12.9157C73.185 12.9157 72.1919 13.4675 70.9781 14.5709V23.6192H69.1023V14.5709Z"
                fill="#6B7280"
              />
              <path
                d="M87.8609 6.18469L89.8471 5.74332C90.0678 6.62607 90.1781 7.61918 90.1781 8.83297V11.5916C90.1781 12.2537 90.1781 12.695 90.1781 12.9157C91.2816 11.8123 92.4954 11.2606 93.7092 11.2606C95.1436 11.2606 96.3574 11.8123 97.1299 12.9157C98.0126 14.0192 98.454 15.564 98.454 17.4399C98.454 19.4261 98.0126 20.9709 97.1299 22.1847C96.2471 23.3985 95.0333 23.9502 93.5988 23.9502C92.9368 23.9502 92.385 23.8399 91.723 23.5088C91.0609 23.1778 90.6195 22.8468 90.2885 22.4054C90.1781 22.9571 90.0678 23.3985 89.9574 23.7295H88.0816C88.3023 23.1778 88.4126 22.1847 88.4126 20.6399V9.05366C88.3023 7.72952 88.1919 6.73642 87.8609 6.18469ZM91.0609 13.6881C90.7299 13.9088 90.3988 14.2399 90.1781 14.5709V20.8606C90.9505 21.8537 91.9436 22.295 93.1574 22.295C94.1505 22.295 94.923 21.964 95.3643 21.1916C95.9161 20.3088 96.2471 19.095 96.2471 17.3295C96.2471 15.7847 96.0264 14.6812 95.4747 14.0192C95.0333 13.3571 94.2609 13.0261 93.1574 13.0261C92.4954 12.9157 91.723 13.1364 91.0609 13.6881Z"
                fill="#6B7280"
              />
              <path
                d="M101.323 7.72952C101.323 7.28814 101.433 6.95711 101.764 6.62607C102.095 6.29504 102.426 6.18469 102.868 6.18469C103.309 6.18469 103.64 6.29504 103.971 6.62607C104.302 6.95711 104.413 7.28814 104.413 7.72952C104.413 8.1709 104.302 8.50194 103.971 8.83297C103.64 9.16401 103.309 9.27435 102.868 9.27435C102.426 9.27435 102.095 9.16401 101.764 8.83297C101.433 8.50194 101.323 8.1709 101.323 7.72952ZM101.764 23.6192V11.4812L103.751 11.1502V23.6192H101.764Z"
                fill="#6B7280"
              />
              <path
                d="M108.054 14.5709C108.054 13.6881 108.054 13.1364 107.944 12.9157C107.944 12.5847 107.723 12.2537 107.502 11.7019L109.378 11.1502C109.709 11.8123 109.82 12.364 109.82 13.0261C111.033 11.8123 112.357 11.1502 113.682 11.1502C114.344 11.1502 114.895 11.2606 115.447 11.5916C115.999 11.9226 116.44 12.364 116.661 12.9157C116.882 13.3571 116.992 13.7985 116.992 14.3502V23.6192H115.116V15.3433C115.116 14.3502 115.006 13.6881 114.675 13.3571C114.344 13.0261 113.902 12.8054 113.351 12.8054C112.909 12.8054 112.247 13.0261 111.585 13.3571C110.923 13.6881 110.371 14.1295 109.93 14.5709V23.6192H108.054V14.5709Z"
                fill="#6B7280"
              />
              <path
                d="M121.406 14.1295L120.413 12.8054C122.068 11.7019 123.723 11.1502 125.488 11.1502C127.254 11.1502 128.357 11.8123 128.909 13.0261C129.13 13.4675 129.13 14.1295 129.13 15.1226V15.7847L129.02 19.7571C129.02 19.8675 129.02 20.0881 129.02 20.3088C129.02 20.9709 129.02 21.4123 129.13 21.7433C129.24 22.1847 129.571 22.5157 130.013 22.7364L129.02 24.0606C128.137 23.7295 127.585 23.1778 127.364 22.295C126.261 23.3985 125.047 23.9502 123.833 23.9502C122.619 23.9502 121.626 23.6192 120.854 22.9571C120.192 22.4054 119.861 21.5226 119.861 20.4192C119.861 18.9847 120.413 17.9916 121.516 17.2192C122.619 16.4468 124.275 16.1157 126.261 16.1157C126.592 16.1157 126.813 16.1157 127.144 16.1157V15.233C127.144 14.2399 127.033 13.5778 126.702 13.3571C126.261 12.9157 125.82 12.695 125.047 12.695C124.385 12.695 123.613 12.9157 122.73 13.2468C122.399 13.4675 121.957 13.7985 121.406 14.1295ZM127.254 20.6399L127.364 17.4399C126.813 17.4399 126.482 17.4399 126.371 17.4399C124.606 17.4399 123.502 17.7709 122.84 18.433C122.399 18.8743 122.178 19.5364 122.178 20.4192C122.178 21.8537 122.84 22.6261 124.275 22.6261C125.599 22.5157 126.592 21.8537 127.254 20.6399Z"
                fill="#6B7280"
              />
              <path
                d="M135.419 11.4812H138.509L137.957 13.0261H135.419V20.8606C135.419 21.5226 135.53 21.964 135.751 22.295C135.971 22.5157 136.413 22.7364 136.964 22.7364C137.406 22.7364 137.847 22.6261 138.178 22.5157L138.399 23.7295C137.737 24.0606 137.075 24.1709 136.302 24.1709C134.426 24.1709 133.544 23.2881 133.544 21.4123V13.0261H131.888V11.4812H133.433V11.2606C133.433 11.0399 133.544 10.1571 133.654 8.72263V8.39159L135.64 7.95021C135.42 9.27435 135.419 10.4881 135.419 11.4812Z"
                fill="#6B7280"
              />
              <path
                d="M140.495 17.5502C140.495 15.564 140.937 14.0192 141.93 12.9157C142.813 11.8123 144.137 11.1502 145.682 11.1502C147.447 11.1502 148.882 11.8123 149.875 13.2468C150.647 14.3502 150.978 15.895 150.978 17.7709C150.978 19.9778 150.316 21.7433 149.102 22.8468C148.22 23.6192 147.116 24.0606 145.792 24.0606C144.137 24.0606 142.923 23.5088 141.93 22.295C141.047 21.1916 140.495 19.5364 140.495 17.5502ZM148.33 14.3502C147.778 13.3571 147.006 12.8054 145.792 12.8054C144.578 12.8054 143.806 13.2468 143.254 14.1295C142.813 14.7916 142.702 15.895 142.702 17.3295C142.702 19.2054 142.923 20.5295 143.475 21.3019C144.026 22.0744 144.799 22.5157 145.902 22.5157C147.226 22.5157 148.109 21.8537 148.551 20.6399C148.771 19.9778 148.882 19.095 148.882 17.9916C148.882 16.3364 148.661 15.1226 148.33 14.3502Z"
                fill="#6B7280"
              />
              <path
                d="M154.62 14.3502C154.62 13.2468 154.509 12.364 154.178 11.7019L156.054 11.1502C156.385 11.8123 156.495 12.364 156.495 13.0261V13.2468C157.488 11.9226 158.592 11.2606 159.916 11.2606C160.137 11.2606 160.357 11.2606 160.578 11.3709L159.806 13.4675C159.585 13.3571 159.364 13.3571 159.254 13.3571C158.813 13.3571 158.261 13.4675 157.82 13.7985C157.378 14.1295 156.937 14.4606 156.716 14.9019C156.606 15.233 156.495 15.6743 156.495 16.2261V23.8399H154.62V14.3502Z"
                fill="#6B7280"
              />
            </svg>
            <svg width="113" height="24" viewBox="0 0 113 24" fill="none" xmlns="http://www.w3.org/2000/svg">
              <path
                d="M33.6752 3.75529C33.2799 2.28706 32.1223 1.12941 30.6541 0.734118C27.9717 0 17.2423 0 17.2423 0C17.2423 0 6.51292 0 3.83057 0.705882C2.39057 1.10118 1.20469 2.28706 0.809397 3.75529C0.103516 6.43765 0.103516 12 0.103516 12C0.103516 12 0.103516 17.5906 0.809397 20.2447C1.20469 21.7129 2.36234 22.8706 3.83057 23.2659C6.54116 24 17.2423 24 17.2423 24C17.2423 24 27.9717 24 30.6541 23.2941C32.1223 22.8988 33.2799 21.7412 33.6752 20.2729C34.3811 17.5906 34.3811 12.0282 34.3811 12.0282C34.3811 12.0282 34.4094 6.43765 33.6752 3.75529Z"
                fill="#6B7280"
              />
              <path d="M13.8258 6.86114V17.1388L22.7483 11.9999L13.8258 6.86114Z" fill="white" />
              <path
                d="M55.0988 20.9223C54.4211 20.4706 53.9411 19.7647 53.6587 18.7765C53.3764 17.8165 53.2352 16.5176 53.2352 14.9365V12.7624C53.2352 11.153 53.4046 9.85413 53.7152 8.8659C54.054 7.87767 54.5623 7.17179 55.2399 6.72003C55.9458 6.26826 56.8493 6.04238 57.9787 6.04238C59.0799 6.04238 59.9835 6.26826 60.6611 6.72003C61.3387 7.17179 61.8187 7.9059 62.1293 8.8659C62.4399 9.8259 62.6093 11.1247 62.6093 12.7624V14.9365C62.6093 16.5459 62.4682 17.8165 62.1576 18.8047C61.847 19.7647 61.367 20.4988 60.6893 20.9506C60.0117 21.4023 59.0799 21.6282 57.9223 21.6282C56.7364 21.6 55.7764 21.3741 55.0988 20.9223ZM58.9105 18.5506C59.1082 18.0706 59.1929 17.2518 59.1929 16.1506V11.4635C59.1929 10.3906 59.1082 9.60002 58.9105 9.09178C58.7129 8.58355 58.4023 8.35767 57.9223 8.35767C57.4705 8.35767 57.1317 8.61178 56.9623 9.09178C56.7646 9.60002 56.6799 10.3906 56.6799 11.4635V16.1506C56.6799 17.2518 56.7646 18.0706 56.9623 18.5506C57.1317 19.0306 57.4705 19.2847 57.9505 19.2847C58.4023 19.2847 58.7129 19.0588 58.9105 18.5506Z"
                fill="#6B7280"
              />
              <path
                d="M107.221 15.7271C107.221 16.6871 107.249 17.4212 107.306 17.9012C107.362 18.3812 107.475 18.7482 107.673 18.9459C107.842 19.1718 108.125 19.2847 108.52 19.2847C109.028 19.2847 109.367 19.0871 109.564 18.6918C109.762 18.2965 109.847 17.6471 109.875 16.7153L112.783 16.8847C112.811 17.0259 112.811 17.1953 112.811 17.4212C112.811 18.8047 112.444 19.8494 111.682 20.5271C110.92 21.2047 109.847 21.5435 108.463 21.5435C106.797 21.5435 105.64 21.0071 104.962 19.9624C104.285 18.9177 103.946 17.3082 103.946 15.1059V12.48C103.946 10.2212 104.285 8.58353 104.99 7.53882C105.696 6.49412 106.882 5.98588 108.548 5.98588C109.706 5.98588 110.609 6.21176 111.23 6.63529C111.851 7.05882 112.275 7.73647 112.529 8.61176C112.783 9.51529 112.896 10.7576 112.896 12.3388V14.9082H107.221V15.7271ZM107.645 8.64C107.475 8.86588 107.362 9.20471 107.306 9.68471C107.249 10.1647 107.221 10.8988 107.221 11.8871V12.96H109.706V11.8871C109.706 10.9271 109.677 10.1929 109.621 9.68471C109.564 9.17647 109.423 8.83765 109.254 8.64C109.084 8.44235 108.802 8.32941 108.463 8.32941C108.068 8.30118 107.814 8.41412 107.645 8.64Z"
                fill="#6B7280"
              />
              <path
                d="M46.8539 14.6823L43.0139 0.762324H46.3739L47.7292 7.0588C48.0681 8.61174 48.3222 9.9388 48.4916 11.04H48.5763C48.6892 10.2494 48.9433 8.95056 49.3386 7.08703L50.7504 0.762324H54.1104L50.2139 14.6823V21.3459H46.8822V14.6823H46.8539Z"
                fill="#6B7280"
              />
              <path
                d="M73.5362 6.32471V21.3741H70.8821L70.5998 19.5388H70.5151C69.8092 20.9223 68.708 21.6282 67.268 21.6282C66.2798 21.6282 65.5457 21.2894 65.0657 20.64C64.5857 19.9906 64.3598 18.9741 64.3598 17.5623V6.32471H67.748V17.3647C67.748 18.0423 67.8327 18.5223 67.9739 18.8047C68.1151 19.087 68.3692 19.2282 68.708 19.2282C68.9904 19.2282 69.2727 19.1435 69.5551 18.9459C69.8374 18.7765 70.0351 18.5506 70.148 18.2682V6.32471H73.5362Z"
                fill="#6B7280"
              />
              <path
                d="M90.901 6.32471V21.3741H88.2469L87.9645 19.5388H87.8798C87.1739 20.9223 86.0727 21.6282 84.6327 21.6282C83.6445 21.6282 82.9104 21.2894 82.4304 20.64C81.9504 19.9906 81.7245 18.9741 81.7245 17.5623V6.32471H85.1127V17.3647C85.1127 18.0423 85.1974 18.5223 85.3386 18.8047C85.4798 19.087 85.7339 19.2282 86.0727 19.2282C86.3551 19.2282 86.6375 19.1435 86.9198 18.9459C87.2022 18.7765 87.3998 18.5506 87.5127 18.2682V6.32471H90.901Z"
                fill="#6B7280"
              />
              <path d="M82.7408 3.50115H79.3809V21.3459H76.0774V3.50115H72.7174V0.762324H82.7408V3.50115Z" fill="#6B7280" />
              <path
                d="M102.11 8.72471C101.913 7.76471 101.574 7.08706 101.122 6.66353C100.67 6.24 100.021 6.01412 99.2303 6.01412C98.6091 6.01412 98.0162 6.18353 97.4797 6.55059C96.9432 6.88941 96.5197 7.36941 96.2374 7.93412H96.2091V0H92.9338V21.3459H95.7291L96.0679 19.9341H96.1527C96.4068 20.4424 96.8021 20.8377 97.3385 21.1482C97.875 21.4306 98.4397 21.6 99.0891 21.6C100.247 21.6 101.066 21.0635 101.602 20.0188C102.139 18.9741 102.421 17.3082 102.421 15.0777V12.7059C102.393 10.9835 102.308 9.65647 102.11 8.72471ZM99.0044 14.8518C99.0044 15.9529 98.9479 16.8 98.8632 17.4212C98.7785 18.0424 98.6091 18.4941 98.4115 18.7482C98.1856 19.0024 97.9032 19.1435 97.5644 19.1435C97.2821 19.1435 97.0279 19.0871 96.8021 18.9459C96.5762 18.8047 96.3785 18.6071 96.2374 18.3529V9.82588C96.3503 9.43059 96.5479 9.09177 96.8303 8.80941C97.1126 8.5553 97.4232 8.41412 97.7338 8.41412C98.0726 8.41412 98.355 8.5553 98.5244 8.80941C98.7221 9.09177 98.835 9.54353 98.9197 10.1647C99.0044 10.8141 99.0326 11.7177 99.0326 12.8753V14.8518H99.0044Z"
                fill="#6B7280"
              />
            </svg>
          </div>
        </div>
      </div>
    </section>
  )
})
