import { component$ } from '@builder.io/qwik'
import { useDarkMode } from 'flowbite-qwik'

export const CheckedIcon = component$(() => {
  const { isDark } = useDarkMode()

  return (
    <>
      {isDark.value ? (
        <svg width="18" height="19" viewBox="0 0 18 19" fill="none" xmlns="http://www.w3.org/2000/svg">
          <rect y="0.273926" width="18" height="18" rx="9" fill="#374151" />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M13.6947 5.979C13.8259 6.11027 13.8996 6.28828 13.8996 6.4739C13.8996 6.65951 13.8259 6.83753 13.6947 6.9688L8.0947 12.5688C7.96343 12.7 7.78541 12.7737 7.5998 12.7737C7.41418 12.7737 7.23617 12.7 7.1049 12.5688L4.3049 9.7688C4.17739 9.63678 4.10683 9.45996 4.10842 9.27642C4.11002 9.09288 4.18364 8.91731 4.31342 8.78753C4.44321 8.65774 4.61878 8.58412 4.80232 8.58253C4.98585 8.58093 5.16268 8.65149 5.2947 8.779L7.5998 11.0841L12.7049 5.979C12.8362 5.84777 13.0142 5.77405 13.1998 5.77405C13.3854 5.77405 13.5634 5.84777 13.6947 5.979Z"
            fill="#8E5CE3"
          />
        </svg>
      ) : (
        <svg width="18" height="19" viewBox="0 0 18 19" fill="none" xmlns="http://www.w3.org/2000/svg">
          <rect y="0.718262" width="18" height="18" rx="9" fill="#EFEBFC" />
          <path
            fill-rule="evenodd"
            clip-rule="evenodd"
            d="M13.6947 6.42346C13.8259 6.55473 13.8996 6.73274 13.8996 6.91836C13.8996 7.10397 13.8259 7.28199 13.6947 7.41326L8.0947 13.0133C7.96343 13.1445 7.78541 13.2182 7.5998 13.2182C7.41418 13.2182 7.23617 13.1445 7.1049 13.0133L4.3049 10.2133C4.17739 10.0812 4.10683 9.90441 4.10842 9.72088C4.11002 9.53734 4.18364 9.36177 4.31342 9.23198C4.44321 9.1022 4.61878 9.02858 4.80232 9.02698C4.98585 9.02539 5.16268 9.09595 5.2947 9.22346L7.5998 11.5286L12.7049 6.42346C12.8362 6.29223 13.0142 6.21851 13.1998 6.21851C13.3854 6.21851 13.5634 6.29223 13.6947 6.42346Z"
            fill="#7A3BC6"
          />
        </svg>
      )}
    </>
  )
})
