#pragma warning disable SYSLIB0051 // 'Exception.Exception(SerializationInfo, StreamingContext)' is obsolete

#region License
/*
 * All content copyright Marko Lahma, unless otherwise indicated. All rights reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy
 * of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations
 * under the License.
 *
 */
#endregion

using System.Runtime.Serialization;
using System.Text;

namespace Quartz.Xml;

/// <summary>
/// Reports JobSchedulingDataProcessor validation exceptions.
/// </summary>
/// <author> <a href="mailto:bonhamcm@thirdeyeconsulting.com">Chris Bonham</a></author>
/// <author>Marko Lahma (.NET)</author>
[Serializable]
public sealed class ValidationException : Exception
{
    /// <summary>
    /// Gets the validation exceptions.
    /// </summary>
    /// <value>The validation exceptions.</value>
    public IReadOnlyList<Exception> ValidationExceptions { get; } = new List<Exception>();

    /// <summary>
    /// Returns the detail message string.
    /// </summary>
    public override string Message
    {
        get
        {
            if (ValidationExceptions.Count == 0)
            {
                return base.Message;
            }

            StringBuilder sb = new StringBuilder();

            foreach (Exception e in ValidationExceptions)
            {
                sb.AppendLine(e.Message);
            }

            return sb.ToString();
        }
    }

    /// <summary>
    /// Constructor for ValidationException.
    /// </summary>
    public ValidationException()
    {
    }

    /// <summary>
    /// Constructor for ValidationException.
    /// </summary>
    /// <param name="message">exception message.</param>
    public ValidationException(string message) : base(message)
    {
    }

    /// <summary>
    /// Constructor for ValidationException.
    /// </summary>
    /// <param name="errors">collection of validation exceptions.</param>
    public ValidationException(IEnumerable<Exception> errors) : this()
    {
        ValidationExceptions = new List<Exception>(errors).AsReadOnly();
    }

    /// <summary>
    /// Initializes a new instance of the <see cref="SchedulerException"/> class.
    /// </summary>
    /// <param name="info">The <see cref="SerializationInfo"></see> that holds the serialized object data about the exception being thrown.</param>
    /// <param name="context">The <see cref="System.Runtime.Serialization.StreamingContext"></see> that contains contextual information about the source or destination.</param>
    /// <exception cref="System.Runtime.Serialization.SerializationException">The class name is null or <see cref="System.Exception.HResult"></see> is zero (0). </exception>
    /// <exception cref="System.ArgumentNullException">The info parameter is null. </exception>
    private ValidationException(SerializationInfo info, StreamingContext context) : base(info, context)
    {
    }
}