﻿namespace Quartz;

/// <summary>
/// Attribute to use with public <see cref="TimeSpan" /> properties that
/// can be set with Quartz configuration. Attribute can be used to advice
/// parsing to use correct type of time span (milliseconds, seconds, minutes, hours)
/// as it may depend on property.
/// </summary>
/// <author>Marko Lahma (.NET)</author>
/// <seealso cref="TimeSpanParseRuleAttribute" />
[AttributeUsage(AttributeTargets.Property)]
internal sealed class TimeSpanParseRuleAttribute : Attribute
{
    /// <summary>
    /// Initializes a new instance of the <see cref="TimeSpanParseRuleAttribute"/> class.
    /// </summary>
    /// <param name="rule">The rule.</param>
    public TimeSpanParseRuleAttribute(TimeSpanParseRule rule)
    {
        Rule = rule;
    }

    /// <summary>
    /// Gets the rule.
    /// </summary>
    /// <value>The rule.</value>
    public TimeSpanParseRule Rule { get; }
}

/// <summary>
/// Possible parse rules for <see cref="TimeSpan" />s.
/// </summary>
public enum TimeSpanParseRule
{
    /// <summary>
    ///
    /// </summary>
    Milliseconds = 0,

    /// <summary>
    ///
    /// </summary>
    Seconds = 1,

    /// <summary>
    ///
    /// </summary>
    Minutes = 2,

    /// <summary>
    ///
    /// </summary>
    Hours = 3
}