﻿declare module "core-js" {
    var core: any;
    export default core
}

interface Map<K, V> {
    clear(): void;
    delete(key: K): boolean;
    forEach(callbackfn: (value: V, index: K, map: Map<K, V>) => void, thisArg?: any): void;
    get(key: K): V;
    has(key: K): boolean;
    set(key: K, value?: V): Map<K, V>;
    size: number;
}

interface MapConstructor {
    new <K, V>(): Map<K, V>;
    prototype: Map<any, any>;
}
declare var Map: MapConstructor;


declare module moment {
    interface Moment {
        dateString(): string;
        dateTimeString(): string;
    }
}

declare var bootbox: BootboxStatic;
declare module "bootbox" {
    export = bootbox;
}

declare var boostrap;
declare module "boostrap" {
    export = boostrap;
}

