USE [enter_db_name_here]
GO

IF EXISTS (SELECT * FROM dbo.sysobjects WHERE id = OBJECT_ID(N'[dbo].[QRTZ_JOB_HISTORY]') AND OBJECTPROPERTY(id, N'ISUSERTABLE') = 1)
DROP TABLE [dbo].[QRTZ_JOB_HISTORY]
GO

CREATE TABLE [dbo].[QRTZ_JOB_HISTORY] (
  [ENTRY_ID] [BIGINT] NOT NULL PRIMARY KEY IDENTITY,
  [SCHED_NAME] [NVARCHAR] (100)  NOT NULL ,
  [INSTANCE_NAME] [NVARCHAR] (200)  NOT NULL ,
  [TRIGGER_NAME] [NVARCHAR] (150)  NOT NULL ,
  [TRIGGER_GROUP] [NVARCHAR] (150)  NOT NULL ,
  [JOB_NAME] [NVARCHAR] (150)  NULL ,
  [JOB_GROUP] [NVARCHAR] (150)  NULL ,
  [FIRED_TIME] [BIGINT] NOT NULL ,
  [SCHED_TIME] [BIGINT] NOT NULL ,
  [RUN_TIME] [INT] NOT NULL ,
  [ERROR] [BIT] NOT NULL ,
  [ERROR_MESSAGE] [NVARCHAR](MAX) NULL
)
GO

CREATE INDEX IDX_QRTZ_FT_J_G ON QRTZ_JOB_HISTORY(SCHED_NAME,JOB_NAME,JOB_GROUP)
CREATE INDEX IDX_QRTZ_FT_JG ON QRTZ_JOB_HISTORY(SCHED_NAME,JOB_GROUP)
CREATE INDEX IDX_QRTZ_FT_T_G ON QRTZ_JOB_HISTORY(SCHED_NAME,TRIGGER_NAME,TRIGGER_GROUP)
CREATE INDEX IDX_QRTZ_FT_TG ON QRTZ_JOB_HISTORY(SCHED_NAME,TRIGGER_GROUP)
CREATE INDEX IDX_QRTZ_FT_E ON QRTZ_JOB_HISTORY(SCHED_NAME,ERROR)
GO
