---

title : Quartz.NET 3.4 Released
tags : [releases]
---

This release has Quartz jobs start executing only after application startup completes successfully, unless QuartzHostedServiceOptions are used to specify otherwise.
By default, this prevents jobs from running while the application is still starting, and it alleviates the need to use arbitrary start delays to achieve the effect manually.

Quartz.OpenTelemetry.Instrumentation has been marked obsolete as there's official contrib project on OpenTelemetry project side.

__FIXES__

* Fix for job type loading after version change (#1286)
* Fix StartDelayed delaying the start of other hosted services (#1314)
* Set NextFireTime of the replaced trigger relative to the old trigger's StartTime if the old trigger's PreviousFireTime is null (#1519)
* Include InvertTimeRange property in DailyCalendar.Clone (#1522)
* QuartzHealthCheck never recovers after detecting failure (#1496)
* Microsoft DI integration does not working with Microsoft.Extensions.Hosting v7 preview (#1544)

__IMPROVEMENTS__

* Jobs now start executing after application startup completes successfully (#1432)
* Support strongly-typed configuration of IDbProvider (#1312)
* Add MSSQL Script compatible with SQL 2014 and 2012 (#1337)
* Added usage of DisallowConcurrentExecutionAttribute for interfaces (#1345)
* Multiple performance improvements (#1351, #1355, #1354, #1353, #1356, #1358)
* Increase precision of SimpleTriggerImpl to ticks. (#1360)
* Switch from FAKE to NUKE (#1413)
* QuartzHostedService now has jobs start after application startup (#1449)
* QuartzHostedServiceOptions can let jobs be started as part of application startup, as before this version  (#1432)
* Add helper methods to setup Microsoft.Data.Sqlite (#1275)
* Quartz will scan job and trigger listeners from MS DI container automatically (#1561)

__BREAKING CHANGES__

* Quartz.OpenTelemetry.Instrumentation is now obsolete as there is contrib package [OpenTelemetry.Instrumentation.Quartz](https://github.com/open-telemetry/opentelemetry-dotnet-contrib/tree/main/src/OpenTelemetry.Instrumentation.Quartz) on OT side
* .NET Framework minimum version is 4.6.2 (previously 4.6.1) (#1549)

<Download />
