---

title : Quartz.NET 3.1 beta 1 Released
tags : [releases]
promote: false
---

## Quartz.NET 3.1 beta 1 Released

The wait is almost over, after more than two years of hiatus, Quartz.NET 3.1 beta 1 is here with exciting new features. This release concentrates on performance and bringing support to de facto Microsoft libraries like dependency injection and ASP.NET Core hosting.

### Support for ASP.NET Core Dependency Injection and Hosted Services

You can find the revisited packages as:

* [Quartz.Extensions.DependencyInjection](https://www.nuget.org/packages/Quartz.Extensions.DependencyInjection/) - Microsoft DI integration
* [Quartz.AspNetCore](https://www.nuget.org/packages/Quartz.AspNetCore) - ASP.NET Core integration

I would like to thank both [Facundo Glaeser](https://github.com/fglaeser) and [Lewis Zou](https://github.com/zlzforever) for working with the new integration packages and their logistics.

The best resource the see the new DI integration in progress is to head to [the example ASP.NET Core application](https://github.com/quartznet/quartznet/tree/master/src/Quartz.Examples.AspNetCore).

### Index and query performance improvements

A big change on the persistent store side is that now SQL queries use parametrized scheduler name, which allows database server to reuse query plans and use indexes more optimally. This will help especially clusters which have large number of nodes. The SQL server indexes were also revisited and their amount reduced by using smarter covering indexes.

See the [updated create index definition](https://github.com/quartznet/quartznet/blob/42af207fa815789936e8e4ce5ebd4516a23d7c72/database/tables/tables_sqlServer.sql#L349-L388) for more details.

There are also some minor bug fixes present.

### Known Issues

The documentation for the new integration features is still being worked on.

### GitHub Issues

__BREAKING CHANGES__

* minimum supported .NET Full Framework is now 4.6.1

__NEW FEATURE__

* Microsoft DI integration via package Quartz.Extensions.DependencyInjection (also allows briding to Microsoft Logging)
* ASP.NET Core / Hosting integration and health checks via revisited NuGet package Quartz.AspNetCore (thank you zlzforever for contributing the work)
* Introduced a config parameter `ClusterCheckinMisfireThreshold` (#692)
* Giving meaningful names to examples folders (#701)
* Added search patterns/sub directory search to directoty scanner job (#411, #708)
* Fluent interface for scheduler configuration (#791)
* Support every nth week in cron expression (#790)
* Enable SQLite job store provider for NetStandard (#802)
* Add configurable params for StdRowLockSemaphore for Failure obtaining db row lock
* SchedName added to queries as sql paramteter (#818)
* Server, example and test projects upgraded to user .NET Core 3.1
* Nullable reference type annotations have been enabled
* Symbols are now provided as a separate NuGet symbol package (snupkg)
* SQL Server indexes have been fine-tuned, redudancies were removed and you can follow the current scripts to update to latest version of them

__FIXES__

* Allow binary serialization for DirectoryScanJob data (#658)
* LibLog - Fixed NLog + Log4net callsite. Added support for NLog structured logging. Optimized Log4net-logger (#705)
* Upgrade LibLog to latest version (#749)
* RAMJobStore performance improvements (#718, #719, #720)
* General performance improvements (#725, #723, #727)
* GetTimeBefore() and GetFinalFireTime() should throw NotImplementedException instead of returning null (#731)
* Switch to official TimeZoneConverter NuGet package (#739)
* Remove invalid TimeSpanParseRule.Days (#782)
* Update tables_sqlServer.sql to follow current SQL syntax and structures (#787)
* Fix China Standard Time mapping in TimeZoneUtil.cs (#765)
* Release BLOCKED triggers in ReleaseAcquiredTrigger (#741 #800)
* DailyTimeIntervalTrigger failed to set endingDailyAfterCount = 1
* CronTrigger: cover all valid misfire policies, and provide a sensible default and logging when seeing an invalid one

<Download />
