---

title : Quartz.NET 3.0 Released
tags : [releases]
---

The wait is over, Quartz.NET 3.0 is here with .NET Core support and async/await!

A big thank you goes to [Mike Rousos](https://github.com/mjrousos) who really made it possible to get Quartz.NET working on .NET Core.
[Daniel Marbach](https://github.com/danielmarbach) also contributed a lot with ideas and code to async side.
And of course never forgetting the community members that have provided feedback and fixes.

Please see the [migration guide](/documentation/quartz-3.x/migration-guide.html).
  
__NEW FEATURE__

* Task based jobs with async/await support, internals work in async/await manner
* Support .NET Core / netstandard 2.0 and .NET Framework 4.5.2 and later
* Support for Microsoft.Data.Sqlite via provider name SQLite-Microsoft, the old provider SQLite also still works
* Added preliminary support for SQL Server Memory-Optimized tables and Quartz.Impl.AdoJobStore.UpdateLockRowSemaphoreMOT
* Common.Logging removed from dependencies
* C5 Collections removed from ILMerge process, no longer needed
* Add support for eager validation of job scheduling XML file on plugin start
* Add support for extra custom time zone resolver function in TimeZoneUtil

__BREAKING CHANGES__

* Jobs and plugins are now in a separate assemblies/NuGet packages Quartz.Jobs and Quartz.Plugins
* ADO.NET provider names have been simplified, the provider names are without version, e.g. SqlServer-20 => SqlServer
* API methods have been revisited to mainly use `IReadOnlyCollection<T>`, this hides both `HashSet<T>`s and `List<T>`s
* LibLog has been hidden as internal (ILog etc), like it was originally intended to be
* SimpleThreadPool is gone, old owned threads are gone
* Scheduler methods have been changed to be Task based, remember to await them
* IJob interface now returns a task
* Some IList properties have been changed to IReadOnlyList to properly reflect intent
* SQL Server CE support has been dropped
* DailyCalendar uses now datetimes for excluded dates and has ISet interface to access them
* IObjectSerializer has new method, void Initialize(), that has to be implemented
* IInterruptableJob removed in favor of context's CancellationToken

__KNOWN ISSUES__

* Issues with time zone ids between Windows and Linux, they use different ids for the same zone
* No remoting support for .NET Core

<Download />
