---

title :  Quartz.NET 3.0 Alpha 1 Released
tags : [releases]
---

This is the first alpha release from the long-awaited v3 branch. This is a big overhaul (and still in progress). Internals are being modernized whilst still trying to keep sane upgrade path.

A big thank you goes to [Mike Rousos](https://github.com/mjrousos) who really made it possible to get Quartz.NET working on .NET Core. [Daniel Marbach](https://github.com/danielmarbach) also contributed a lot with ideas and code to async side. And of course never forgetting the community members that have provided feedback and fixes.

Please see the [migration guide](/documentation/quartz-3.x/migration-guide.html) that is a work in progess.

**Use at your own risk, might not be that production ready yet**

What does alpha mean?

* All existing (and new) tests passing
* Cheese might still get moved, alpha means that APIs can change, features can come and go

**NEW FEATURE**

* Task based jobs with async/await support, internals work in async/await manner
* Support .NET Core / netstandard 1.3
* Separate NuGet package Quartz.Serialization.Json to enable JSON based AdoJobStore serialization (no binary serialization available in .NET  Core)
* Common.Logging removed from dependencies
* C5 Collections removed from ILMerge process, no longer needed

**BREAKING CHANGES**

* .NET 4.5/netstandard1.3 required
* SimpleThreadPool is gone, old owned threads are gone
* Scheduler methods have been changed to be Task based, remember to await them
* IJob interface now returns a task
* Some IList properties have been changed to IReadOnlyList to properly reflect intent
* SQL Server CE support has been dropped
* DailyCalendar uses now datetimes for excluded dates and has ISet interface to access them
* IObjectSerializer has new method, void Initialize(), that has to be implemented
* IInterruptableJob removed in favor of context's CancellationToken

**KNOWN ISSUES**

* Issues with time zone ids between Windows and Linux, they use different ids for the same zone
* No remoting support
* Documentation lacking

Check NuGet for pre-release packages.
