# > satoshi
Manipulate satoshi-related prices in Python 3, simple and sweet 💵 ₿🍬

<img src="img/ccover.png" align="center" />

#### Why complicate?

The idea behind this project is to provide Python programmers with a simple, light and intuitive package to manipulate satoshis.

This can be extremely useful on future/perpetual markets and crypto exchanges that don't automatically associate XBT balances to an USD value. With > satoshi you can use a single function to convert your satoshis to any fiat currency :)

No need to handle more requests and currency mangling in your code, simply use > satoshi and, therefore, [CryptoCompare's](https://www.cryptocompare.com) open API.

#### Installation

```bash
pip install satoshi
```

#### Usage

```python
include satoshi
satoshi.to_fiat(984223) # satoshi to usd
satoshi.to_fiat(18923, 'BRL') # satoshi to reais
```

Feel free to run example.py for a demo.

#### Notes

Project idealized while listening to [this](https://open.spotify.com/track/3X4dJnyoxhFbNw1bX8qas0?si=M4xhiD7vQyerQnMLxfuyfQ) song.

Feel free to become a collaborator.