ENTRY(_start)
 
/* Tell where the various sections of the object files will be put in the final
   kernel image. */
SECTIONS
{
	/* Begin putting sections at 1 MiB, a conventional place for kernels to be
	   loaded at by the bootloader. */
	. = 0x100000;
	PROVIDE(kstart = .);
	/* First put the multiboot header, as it is required to be put very early
	   early in the image or the bootloader won't recognize the file format.
	   Next we'll put the .text section. */
	.text ALIGN(4K):
	{
		*(.mboot)
		/*code = .; _code = .; __code = .;*/
        *(.text)
        /*. = ALIGN(4096);*/
	}
 
	/* Read-only data. */
	.data ALIGN(4K):
	{
	/*	data = .; _data = .; __data = .;*/
     *(.data)
     *(.rodata)
    /* . = ALIGN(4096);*/
	}
 

	/* Read-write data (uninitialized) and stack */
	.bss ALIGN(4K):
	{
		/*bss = .; _bss = .; __bss = .;*/
    *(.bss)
    /*. = ALIGN(4096);*/
	}
	PROVIDE(kend = .);
	/* The compiler may produce other sections, by default it will put them in
	   a segment with the same name. Simply add stuff here as needed. */
}