/*验证规则*/
var ui_rule={
    required:[/[^(^\s*)|(\s*$)]/,'{0}不能为空']
    ,int:[/^\d+$/,"请填写数字"]
    ,dot: [/^(\-|\+)?\d{1,10}(?:\.\d{0,2})?$/, "请输入数字"]
    ,letters:[/^[a-z]+$/i,"请填写字母"]
    ,date:[/^\d{4}-\d{2}-\d{2}$/,"请填写有效的日期，格式:yyyy-mm-dd"]
    ,time:[/^([01]\d|2[0-3])(:[0-5]\d){1,2}$/,"请填写有效的时间，00:00到23:59之间"]
    ,email:[/^[\w\+\-]+(\.[\w\+\-]+)*@[a-z\d\-]+(\.[a-z\d\-]+)*\.([a-z]{2,4})$/i,"请填写有效的邮箱"]
    ,url:[/^(https?|s?ftp):\/\/\S+$/i,"请填写有效的网址"]
    ,qq:[/^[1-9]\d{4,}$/,"请填写有效的QQ号"]
    ,idcard:[/^\d{6}(19|2\d)?\d{2}(0[1-9]|1[012])(0[1-9]|[12]\d|3[01])\d{3}(\d|X)?$/,"请填写正确的身份证号码"]
    ,tel:[/^(?:(?:0\d{2,3}[\- ]?[1-9]\d{6,7})|(?:[48]00[\- ]?[1-9]\d{6}))$/,"请填写有效的电话号码"]
    ,mobile:[/^1[3-9]\d{9}$/,"请填写有效的手机号"]
    ,zipcode:[/^\d{6}$/,"请检查邮政编码格式"]
    ,chinese:[/^[\u0391-\uFFE5]+$/,"请填写中文字符"]
    ,username:[/^[\u0391-\uFFE5\w\d]{3,12}$/,"请填写3-12位数字、字母、中文、下划线"]
    ,password:[/^[\S]{5,16}$/,"请填写5-16位字符，不能包含空格"]
};

/*语言包*/
var ui_lan={
	homepage:"设置首页失败，请手动设置！",
	favorite:"加入收藏失败，请使用Ctrl+D进行添加",
	ok:"确定",
	cancel:"取消",
	city:"请选择省市区",
	backtime:"秒后重发",
	over:'已结束',
	day:'天',
	hour:'时',
	minute:'分',
	second:'秒',
	checked:"请选择",
	length:"长度：",
	min:"不能小于：",
	max:"不能大于：",
	between:"请输入{1}至{2}之间的数值",
	match:"{1}与{2}不一致",
	total:'总数：',
	pre:'上一页',
	next:'下一页',
	home:'首页',
	last:'末页',
};