[![Build Status](https://travis-ci.org/qmetry/qaf.svg?branch=master)](https://travis-ci.org/qmetry/qaf)
[![License](https://img.shields.io/github/license/qmetry/qaf.svg)](http://www.opensource.org/licenses/mit-license.php)
[![Maven Central](https://maven-badges.herokuapp.com/maven-central/com.qmetry/qaf/badge.svg)](https://maven-badges.herokuapp.com/maven-central/com.qmetry/qaf)
[![GitHub tag](https://img.shields.io/github/tag/qmetry/qaf.svg)](https://github.com/qmetry/qaf/tags)
[![javadoc](https://javadoc.io/badge2/com.qmetry/qaf/javadoc.svg)](https://javadoc.io/doc/com.qmetry/qaf)
[![StackExchange]( https://img.shields.io/badge/questions-Stack_Overflow-lightgray.svg?maxAge=2592000)](http://stackoverflow.com/questions/tagged/qaf)
[![Users-group]( https://img.shields.io/badge/users-Group-blue.svg?maxAge=2592000)](https://groups.google.com/forum/#!forum/qaf-users)
[![Help]( https://img.shields.io/badge/help-Documentation-blue.svg?maxAge=2592000)](https://qmetry.github.io/qaf/)


# QMetry Automation Framework
  for web, mobileweb, mobile native and rest web-service functional test automation
  
  <a href="https://qmetry.github.io/qaf/" target="_blank">Online documentation</a> | <a href="https://github.com/qmetry/qaf-step-by-step-tutorial/wiki" target="_blank">Step-By-Step-Tutorial</a>
<h3>Support libraries:</h3>
<ul type="1">
	<li><a href="https://github.com/qmetry/qaf-support" target="_blank">qaf-support</a> - steps for web and mobile web</li>
	<li><a href="https://github.com/qmetry/qaf-support-mobile" target="_blank">qaf-support-mobile</a> - steps for and mobile native</li>
	<li><a href="https://github.com/qmetry/qaf-support-ws" target="_blank">qaf-support-ws</a> - request call repository support and steps for web services</li>
	<li><a href="https://github.com/qmetry/qaf-support-openapi" target="_blank">qaf-support-openapi</a> - auto generate request call repository and bdd from open api specification</li>
	<li><a href="https://github.com/qmetry/qaf-support-elasticsearch" target="_blank">qaf-support-elasticsearch</a> - elasticsearch integration for cross execution dashboard</li>
	<li><a href="https://github.com/qmetry/qaf-support-angular" target="_blank">qaf-support-angular</a> - custom locator stretegies specific to angularjs</li>
	<li><a href="https://github.com/qmetry/qaf-support-aem" target="_blank">qaf-support-aem</a> - aem support</li>
	<li><a href="https://github.com/qmetry/qaf-support-galen" target="_blank">qaf-support-galen</a> - galen framework support</li>
	<li><a href="https://github.com/qmetry/qaf-support-flutter" target="_blank">qaf-support-flutter</a> - flutter native app support</li>
	<li><a href="https://github.com/qmetry/qaf-cucumber" target="_blank">qaf-cucumber</a> - cucumber step with QAF BDD2 and/or cucumber runner support</li>
</ul>

<h3>Powerful Automation Platform for Test Authoring, Test Execution and Execution Analysis</h3>

QMetry Automation Framework provides a powerful and versatile platform to author Test Cases in Behavior Driven, Keyword Driven or Code Driven approach. It helps to significantly reduce costs involved in setting up Test Automation at any organization. It is a right tool for Web Platform, Mobile Platform (Native, Mobile Web, HTML5,etc) and Web Service test automation solution using Selenium and other related technologies. QMetry Automation Framework benefits any QA Team in developing highly maintainable and repeatable tests that utilize reusable test assets, proper modularity and semantic structure. Descriptive Reporting satisfies high-level as well as low-level (debugging) aspects.
<p>
		QMetry Automation Framework is designed to solve common industry
		problems related to testing complex web systems. The framework is best
		suited for writing Automated Web, Mobile Web and Mobile Native
		Application UI Tests simulate real user activities on the page. <br />

		The framework is built upon java and integrates TestNG,
		Selenium/Webdriver, Appium and Perfecto. Due to the framework's
		thorough design, test developer does not need to worry about common
		tasks such as thread safe browser session for running test in
		parallel, reporting or to incorporate result with test management
		tools. The tests run can be configured through standard testing
		configuration files, the test run filters and behavior can be changed
		within the config File. <br /> The architecture of the framework
		ensures a low cost of maintenance while supporting extensibility by:
</p>
<ul>
		<li>Abstracting the technical implementation away from the
			operational components</li>
		<li>Following accepted design patterns in creating the core
			functionalities within the framework.</li>
		<li>Providing an approach to develop highly maintainable and
			repeatable tests that utilize reusable test assets, proper modularity
			and semantic structure. Framework has readymade services for
			assertions, browser, reporting and data. Also, framework concept is
			based on page services so your page and related actions will be
			reusable from any test case. There is a good logging functionality
			and screen shot facility for assertions.</li>
</ul>
<h2>Features</h2>
	QMetry Automation Framework supports integrations with Test Management
	Platform (QMetry, Rally, ApTest, HP ALM, etc), Continuous Integration
	Systems (Jenkins, Bamboo, etc), Mobile Device Cloud Solutions
	(SauceLabs, Perfecto Mobile, etc).

<h3>QMetry Automation Framework Key Features</h3>

<h4>Test Authoring:</h4> 

<ul>
	<li>Behavior Driven Development (QAF BDD or Gherkin) </li>
	<li>Keyword Driven (Test case in CSV or EXCEL or XML)</li>
	<li>Code Driven Development (TestNG test)</li>
</ul>

<h4>Test Data Management:</h4> Data driven testing with external Test
		Data Support (CSV, JSON, XML, excel, database), locator repository, support for multiple
	locales and multiple environments 

<h4>Execution Reporting:</h4> Execution Dashboard, Detailed Analysis and Screenshot Capturing, Integrations with Test Management Tools, and more


<p>Some benefits of using the framework are:</p>
<ul type="square">
		<li>Less maintenance</li>
		<li>More reusability of code</li>
		<li>Reduced execution time</li>
		<li>Data-driven capability</li>
		<li>Easy configurable parallel execution</li>
		<li>Descriptive report</li>
		<li>Utility classes</li>
		<li>Test Results integration with test management tools like
			QMetry, Rally.</li>
		<li>Integration with Perfecto Mobile cloud, Sauce labs, Supports parallel execution</li>
		<li>Enabling testing across multiple platforms with or without
			selenium grid</li>
	</ul>

 
