:::{index} Shortcuts; IDE Shortcuts
:::

# Keyboard Shortcuts

The table below provides an overview of menu commands and associated keyboard shortcuts.
Further shortcuts are available in the editor (see [Editor shortcuts](editorshortcuts)). 
You can customize most IDE shortcuts using the [Customize IDE shortcuts](ideshortcuts) 
dialog.

| **Command / Action** | **Shortcut** | **Description of the Action** |
| --- | --- | --- |
| ***File Management*** | | |
| Close | Ctrl+F4 | Close active Document |
| Close All Files | Shift+Ctrl+F4 | Close All opened Documents |
| Exit | Alt+F4 | Exit this program |
| New | Ctrl+N | Create new file |
| Open.. | Ctrl+O | Open existing file |
| Save | Ctrl+S | Save active file |
| Save all |  | Save all opened files |
| Save As... |  | Save active file under a different name |
| Page Setup... |  | Setup page |
| Print Preview |  | Preview active file |
| Print... | Ctrl+P | Print active Document |
| ***Edit Commands*** | | |
| Comment out | Ctrl+Alt+. | Comment out a block of code |
| Copy | Ctrl+C | Copy selection to Clipboard |
| Cut | Ctrl+X | Cuts selection |
| Dedent block | Shift+Ctrl+U | Decrease the indentation of a block of code |
| Delete |  | Delete selection |
| Dos/Windows |  | Convert linebreaks to Windows format |
| Indent block | Shift+Ctrl+I | Increase the indentation of a block of code |
| Insert parameter | Shift+Ctrl+P | Insert a [parameter](parameters) |
| Insert modifier | Shift+Ctrl+M | Insert a [parameter modifier](parameters.md#parameter-modifiers) |
| Insert template | Ctrl+J | Insert a [code template](codetemplates) |
| Code completion | Ctrl+Space | Start [code completion](codecompletion) |
| Call tips | Shft+Ctrl+Space | Show a [call tip](codecompletion) |
| Mac |  | Convert linebreaks to Mac format |
| Paste | Ctrl+V | Paste Clipboard contents |
| Replace parameters | Shft+Ctrl+R | Replace parameters with their values |
| Redo | Shift+Ctrl+Z | Reverse the action of "Undo" |
| Select All | Ctrl+A | Select all text in the editor |
| Tabify |  | Convert spaces to tabs |
| Toggle comment | Ctrl + ^ | (Un)comment a block of code (toggle) |
| Uncomment | Ctrl+Alt+, | Reverse the action of "Comment out" |
| Undo | Ctrl+Z | Undo last action |
| Unix |  | Convert linebreaks to Unix format |
| UnTabify |  | Convert tabs to spaces |
| UTF-8 |  | Toggle the UTF-8 file format |
| ***Search Commands*** | | |
| Find... | Ctrl+F | Display the search dialog |
| Find Definition |  | Find the definition of the identifier under the caret |
| Find Function... | Ctrl+G | Display the Find Function Dialog |
| Find In Files... | Shift+Ctrl+F | Display the Find-In-Files dialog |
| Find Next | F3 | Repeat last search, searching forward |
| Find Next Identifier | Shift+Ctrl+Down | Find the next reference of the identifier containing the caret |
| Find Previous | Shift+F3 | Repeat last search, searching backwards |
| Find Previous Identifier | Shift+Ctrl+Up | Find the previous reference of the identifier containing the caret |
| Find References |  | Find references of the identifier under the caret |
| Go To Line.. | Alt-G | Go to a specific line of the code |
| Go To Syntax Error | Shift+Ctrl+E | Jump to the first syntax error |
| Matching Brace |  |  |
| Replace... | Ctrl+H | Display the "Replace Text" dialog |
| Highlight Search Text | Shift+Ctrl+H | Highlight all occurrences of the search text |
| ***Run Commands*** | | |
| Abort Debugging | Ctrl+Alt+F9 | Abort debugging session |
| Clear All Breakpoints |  | Clear all breakpoints in open files |
| Configure External Run |  | Configure the "External Run" command |
| Debug | F9 | Debug the active file |
| Debug Last Script | Shift+F9 | Debug last script |
| External Run | Alt+F9 | Run active file in an external Python interpreter |
| Run Last Script Externally | Shift+Alt+F9 | Run last script in an external Python interpreter |
| Import Module |  | Import the active file in the embedded Python interpreter |
| Run | Ctrl+F9 | Run active file without debugging |
| Run Last Script | Shift+Ctrl+F9 | Run last scirpt |
| Run to Cursor | F4 | Run using the debugger up to the cursor position |
| Step Into | F7 | Starts or resumes debugging by stepping into the next line of code |
| Step Over | F8 | Resumes debugging by stepping over the next line of code |
| Step Out | Shift+F8 | Resumes debugging by stepping out the current execution frame |
| Syntax Check |  | Perform a syntax check of the active file |
| Toggle Breakpoint | F5 | Toggles the breakpoint at the cursor position |
| Reinitialize Python | Ctrl+F2 | Reinitialize the remote Python engine |
| ***Tools Commands*** | | |
| Code Templates... |  | Configure [Code Templates](codetemplates) |
| Configure Tools... |  | Configure [External Tools](externaltools) |
| Custom Parameters... |  | Configure [Parameters](parameters) |
| Documentation |  | Show the HTML documentation for the active file |
| Disassembly |  | Show the disassembly of the active Python file |
| Editor Options... |  | Configure [Editor Options](editoroptions) |
| IDE Options... |  | Configure [IDE Options](ideoptions) |
| Python Path... |  | Configure the [Python path](pythonpath) |
| ***View Commands*** | | |
| Next Editor | Ctrl+TAB | Show the next editor |
| Previous Editor | Shift+Ctrl+TAB | Show the previous editor |
| Maximize editor | Alt+Z | Maximize editor window |
| Restore editor | Shift+Alt+Z | Restore maximized editor window |
| Main Menu | Shift+F10 | Show/Hide main menu |
| ***Navigation Commands*** | | |
| Editor | F12 | Activate the editor |
| Interpreter | Alt+Ctrl+I | Activate the Interpreter |
| Code Explorer | Alt+Ctrl+C | Activate the Code Explorer window |
| File Explorer | Alt+Ctrl+X | Activate the File Explorer |
| Unit Tests | Alt+Ctrl+U | Activate the Unit Tests window |
| Command Output | Alt+Ctrl+O | Activate the Command Output window |
| Regular Expressions | Alt+Ctrl+R | Show/hide the Regular Expressions window |
| Todo List | Alt+Ctrl+T | Activate the Todo list window |
| Breakpoints | Alt+Ctrl+B | Activate the Breakpoints window |
| Call Stack | Alt+Ctrl+S | Activate the Call Stack window |
| Messages | Alt+Ctrl+M | Activate the Call Stack window |
| Variables | Alt+Ctrl+V | Activate the Variables window |
| Watches | Alt+Ctrl+W | Activate the Watches window |
| ***Help Commands*** | | |
| About... |  | Shows the "About" dialog |
| Contents |  | Shows the help file table of contents |
| Editor Shortcuts |  | Shows editor shortcuts |
| External Tools |  | Shows help information about external tools |
| Parameters |  | Shows help information about parameters |
| Python Manuals |  | Shows Python help file |

