:::{index} Shortcuts; Editor Shortcuts
:::

# Editor Shortcuts

The following  table presents the editor commands and the default associated shortcuts. These 
shortcuts can be changed using [Editor  Options](editoroptions). 
For further IDE commands and keyboard shortcuts see [Keyboard  Shortcuts](keyboardshortcuts).


| **Command** | **Shortcut** | **Description** |
| --- | --- | --- |
| Block Indent | Shft+Ctrl+I | Indent selection |
| Block Unindent | Shft+Ctrl+U | Unindent selection |
| Clear All |  | Delete everything |
| Context Help | F1 | Context Sensitive Help |
| Copy | Ctrl+C     Ctrl+Ins | Copy selection to Clipboard |
| Copy Line Down | Shft+Alt+Down | Copy  line(s) down |
| Copy Line Up | Shft+Alt+Up | Copy  line(s) up |
| Cut | Ctrl+X     Shft+Del | Cuts selection |
| Delete BOL |  | Delete from cursor to beginning of line |
| Delete |  | Delete selection |
| Delete Char | Del | Delete next char |
| Delete EOL | Shft+Ctrl+Y | Delete from cursor to end of line |
| Delete Last Char | Bksp | Delete last char (i.e. backspace key) |
| Delete Last Word | Ctrl+Bksp | Delete from cursor to start of word |
| Delete Line | Ctrl+Y | Delete current line |
| Delete Word | Ctrl+T | Delete from cursor to end of word |
| Down | Down | Move cursor down one line |
| Editor Bottom | Ctrl+End | Move cursor to end of file |
| Editor Top | Ctrl+Home | Move cursor to start of file |
| Go To Marker i | Ctrl+i | Go to numbered bookmark i (i=0..9) |
| Insert Line | Ctrl+N | Break line at current position, leave caret |
| Insert Mode |  | Set editor mode to insert mode |
| Left | Left | Move cursor left one char |
| Line Break | Ctrl+M | Break line at current position, move caret to new line |
| Line End | End | Move cursor to end of line |
| Line Start | Home | Move cursor to beginning of line |
| Lower Case | Ctrl+K, Ctrl+L | Change word at cursor or selection to lower case |
| Match Bracket | Ctrl+] | Go to matching bracket |
| Select to Bracket | Shift+Ctrl+] | Go to matching bracket extending the selection |
| Move  Line Down | Alt+Down | Move  line(s) down |
| Move  Line Up | Alt+Up | Move  line(s) up |
| Overwrite mode |  | Set editor mode to overwrite mode |
| Page Bottom | Ctrl+PgDn | Move cursor to bottom of page |
| Page Down | PgDn | Move cursor down one page |
| Page Left |  | Move cursor left one page |
| Page Right |  | Move cursor right one page |
| Page Top | Ctrl+PgUp | Move cursor to top of page |
| Page Up | PgUp | Move cursor up one page |
| Paste | Ctrl+V     Shft+Insert | Paste Clipboard to current position |
| Redo | Shift+Ctrl+Z     Shft+Alt+BkSp | Perform redo if available |
| Right | Right | Move cursor right one char |
| Scroll Down | Ctrl+Down | Scroll down one line leaving cursor position unchanged |
| Scroll Left |  | Scroll left one char leaving cursor position unchanged |
| Scroll Right |  | Scroll right one char leaving cursor position unchanged |
| Scroll Up | Ctrl+Up | Scroll up one line leaving cursor position unchanged |
| Select Down |  | Extend selection one line down |
| Select Editor Bottom | Shft+Ctrl+End | Extend selection to the end of file |
| Select Editor Top | Shft+Ctrl+Home | Extend selection to the start of file |
| Select Left | Shft+Left | Extend selection one char left |
| Select Line End | Shft+End | Extend selection to the end of line |
| Select Line Start | Shft+Home | Extend selection to the start of line |
| Select Page Bottom | Shft+Ctrl+PgDn | Extend selection to the bottom of the page |
| Select Page Down | Shft+PgDn | Extend selection one page down |
| Select Page Left |  | Extend selection one page left |
| Select Page Right |  | Extend selection one page right |
| Select Page Top | Shft+Ctrl+PgUp | Extend selection to the top of the page |
| Select Page Up | Shft+PgUp | Extend selection one page up |
| Select Right | Shft+Right | Extend selection one char right |
| Select Up | Shft+Up | Extend selection one line up |
| Select Word | Ctrl+W | Select word at caret.  If pressed again, add next occurence to selections. |
| Select Word Left | Shft+Ctrl+Left | Extend selection one word to the left |
| Select Word Right | Shft+Ctrl+Right | Extend selection one word to the right |
| Select All | Ctrl+A | Select all text in the editor |
| Set Marker i | Shft+Ctrl+i | Set numbered bookmark i at the current position (i=0..9) |
| Shift Tab | Shft+Tab | Action dependent on [indentation options](editoroptions) |
| Tab | Tab | Insert tab or spaces depending on [editor options](editoroptions) |
| Title Case | Ctrl+K, Ctrl+T | Change word at cursor or selection to title case |
| Toggle Case |  | Toggle the case of the word at cursor or selection |
| Toggle Mode | Ins | Toggle insert/overwrite mode |
| Undo | Ctrl+Z     Alt+Bksp | Undo last action |
| Up | Up | Move cursor up one line |
| Upper Case | Ctrl+K, Ctrl+U | Change word at cursor   or selection to upper case |
| Word Left | Ctrl+Left | Move cursor left one word |
| Word Right | Ctrl+Right | Move cursor right one word |
| Zoom in | Alt+'+' | Increase the font size of the editor |
| Zoom out | Alt+'-' | Decrease the font size of the editor |
| Reset Zoom | Alt+Num 0 | Reset the font size of the editor to its default value |
| **Code folding shortcuts** | | |
| Fold All | Shft+Ctrl+- | Fold all ranges |
| Unfold All | Shft+Ctrl+/ | Unfold all ranges |
| Fold Nearest | Ctrl+/ | Fold nearest range |
| Unfold Nearest | Shft+Ctrl+/ | Unfold nearest range |
| Fold Regions |  | Fold all regions |
| Unfold Regions |  | Unfold all regions |
| Fold Level 1 | Ctrl+K Ctrl+1 | Fold top level ranges (level 1) |
| Unfold Level 1 | Shft+Ctrl+K  Shft+Ctrl+1 | Unfold top level ranges (level 1) |
| Fold Level 2 | Ctrl+K Ctrl+2 | Fold level 2 ranges |
| Unfold Level 2 | Shft+Ctrl+K  Shft+Ctrl+2 | Unfold level 2 ranges |
| Fold Level 3 | Ctrl+K Ctrl+3 | Fold level 3 ranges |
| Unfold Level 3 | Shft+Ctrl+K  Shft+Ctrl+3 | Unfold level 3 ranges |
| Fold Functions |  | Fold all functions (IDE command) |
| Unfold Functions |  | Unfold all functions (IDE command) |
| Fold Classes |  | Fold all classes (IDE command) |
| Unfold Classes |  | Unfold all classes (IDE command) |
| **Zooming** | | You can also zoom in/out using Ctrl+Mouse wheel |
| Zoom In | Alt+Num + | Increase editor and gutter font size |
| Zoom Out | Alt+Num - | Decrease editor and gutter font size |
| Zoom Resut | Alt+Num 0 | Restore original editor and gutter font size |
| **Multi-caret commands** | | |
| Cancel Selections | Esc | Cancel multiple carets and selections |
| Select Column Left | Shft+Alt+Left | Expand column selection left  |
| Select Column Right | Shft+Alt+Right | Expand column selection right  |
| Select Column Up | Shft+Alt+Up | Expand column selection up  |
| Select Column Down | Shft+Alt+Down | Expand column selection down  |
| Select Column Page Up | Shft+Alt+PgUp | Expand column selection a page up  |
| Select Column Page Down | Shft+Alt+PgDown | Expand column selection a page down  |
| Select Matching Text | Shft+Ctrl+W | Select all occurences of the currently selected text  |
| Carets At Line Ends | Alt+End | Add carets to line ends of the current selection  |
| **Other shortcuts available in the editor** | | |
| Code completion | Ctrl+Space | Start [code completion](codecompletion.md#code-completion) |
| Call tips | Shft+Ctrl+Space | Show a [call tip](codecompletion.md#call-tips) |
