# Introducing Pydantic Logfire

From the team behind Pydantic, **Logfire** is an observability platform built on the same belief as our open source library — that the most powerful tools can be easy to use.

## What sets Logfire apart

<div class="grid cards" markdown>

-   :rocket:{ .lg .middle } __Simplicity and Power__

    ---

    Logfire's dashboard is simple relative to the power it provides, ensuring your entire engineering team will actually use it. Time-to-first-log should be less than 5 minutes.

    [:octicons-arrow-right-24: Read more](simplicity.md)

-   :snake:{ .lg .middle } __Python-centric Insights__

    ---

    From rich display of **Python objects**, to **event-loop telemetry**, to **profiling Python code &amp; database queries**, Logfire gives you unparalleled visibility into your Python application's behavior.

    [:octicons-arrow-right-24: Read more](python-centric.md)

-   :simple-pydantic:{ .lg .middle } __Pydantic Integration__

    ---

    Understand the data flowing through your Pydantic models and get built-in analytics on validations.

    Pydantic Logfire helps you instrument your applications with less code, less time, and better understanding.

    [:octicons-arrow-right-24: Read more](pydantic.md)

-   :telescope:{ .lg .middle } __OpenTelemetry__

    ---

    Logfire is an opinionated wrapper around OpenTelemetry, allowing you to leverage existing tooling, infrastructure, and instrumentation for many common Python packages, and enabling support for virtually any language.

    [:octicons-arrow-right-24: Read more](opentelemetry.md)

-   :simple-instructure:{ .lg .middle } __Structured Data__

    ---

    Include your Python objects in Logfire calls (lists, dict, dataclasses, Pydantic models, DataFrames, and more), and it'll end up as structured data in our platform ready to be queried.

    [:octicons-arrow-right-24: Read more](sql.md)

-   :abacus:{ .lg .middle } __SQL__

    ---

    Query your data using standard SQL — all the control and (for many) nothing new to learn. Using SQL also means you can query your data with existing BI tools and database querying libraries.

    [:octicons-arrow-right-24: Read more](sql.md)

</div>


## Find the needle in a _stack trace_

We understand Python and its peculiarities. Pydantic Logfire was crafted by Python developers, for Python developers, addressing the unique challenges and opportunities of the Python environment. It's not just about having data; it's about having the *right* data, presented in ways that make sense for Python applications.

![Logfire FastAPI screenshot](../images/index/logfire-screenshot-fastapi-200.png)
