Welcome to the **Logfire** Onboarding Checklist! Whether you're starting a new project or integrating Logfire with an
existing application, this guide is intended to help you quickly instrument your code and start sending as much data to
Logfire with as little development effort as possible.

Once you've completed the checklist, you'll be collecting all the data necessary to monitor performance, identify and
fix bugs, analyze user behavior, and make data-driven decisions.

!!! note

    If you aren't familiar with traces and spans, start with the
    [Tracing with Spans](../../get-started/traces.md) page.

#### Logfire Onboarding Checklist

* [ ] **[Integrate Logfire](integrate.md)**: Fully integrate Logfire with your logging system and the packages you are
  using.

* [ ] **[Add Logfire manual tracing](add-manual-tracing.md)**: Enhance your tracing data by manually adding custom
  spans and logs to your code for more targeted data collection.

* [ ] **[Add Logfire auto-tracing](add-auto-tracing.md)**: Discover how to leverage Logfire's auto-tracing
  capabilities to automatically instrument your application with minimal code changes.

* [ ] **[Add Logfire metrics](add-metrics.md)**: Learn how to create and use metrics to track and measure important
  aspects of your application's performance and behavior.

We'll walk you through the checklist step by step, introducing relevant features and concepts as we go. While the main
focus of this guide is on getting data into Logfire so you can leverage it in the future, we'll also provide an
introduction to the Logfire Web UI and show you how to interact with the data you're generating.

!!! note

    For a more comprehensive walkthrough of the Logfire Web UI and its features, you may be interested in our
    [Logfire Web UI Guide](../web-ui/index.md).

Let's get started! :rocket:
