/* eslint-disable quote-props */
import type { BaseLanguage } from './en'

const data: BaseLanguage = {
  'app-name': 'Yank Note',
  'about': 'О проекте',
  'feedback': 'Поддержка',
  'slogan': 'Гибкий, расширяемый редактор Markdown, создан для повышения производительности.',
  'cancel': 'Отмена',
  'undo': 'Отменить',
  'ok': 'OK',
  'demo-tips': 'Некоторые функции недоступны в ДЕМО режиме.',
  'more': 'Ещё',
  'copied': 'Скопировано',
  'others': 'Другие',
  'insert-different-repo-doc': 'Документы не могут быть вставлены из другого репозитория',
  'need-clipboard-permission': 'Пожалуйста, предоставьте разрешения на использование буфера обмена',
  'click-to-copy': 'Нажмите, чтобы скопировать',
  'click-to-copy-link': 'Нажмите, чтобы скопировать ссылку',
  'copy-code': 'Скопировать код',
  'loading': 'Загрузка',
  'add-image': 'Добавить изображение',
  'upload-image': 'Загрузить изображение',
  'exit-presentation-msg': 'Нажмите клавишу Esc, чтобы выйти',
  'reload': 'Перезагрузить',
  'open-in-new-window': 'Новое окно',
  'view-figure': 'Посмотреть рисунок',
  'export': 'Экспорт',
  'no-password': 'Пароль не введён',
  'save': 'Сохранить',
  'close': 'Закрыть',
  'discard': 'Отказаться',
  'edit': 'Изменить',
  'outline': 'Конспект',
  'files': 'Файлы',
  'install-extension-tips': 'Пожалуйста, сначала установите и включите расширение "%s"',
  'not-support-mas': 'Yank Note загруженный из Mac Apple Store, не поддерживает это расширение.',
  'learn-more': 'Узнать больше',
  'default': 'По умолчанию',
  'print': 'Печать',
  'markdown-file': 'Markdown файл',
  'encrypted-markdown-file': 'Защищенный Markdown файл',
  'switch-repo-n': 'Переключиться на репозиторий [%s]',
  'switch-the-last-repo': 'Переключиться на последний репозиторий',
  'edit-or-generate-text-using-ai': 'Изменить или создать текс с помощью ИИ',
  'file-readonly-desc': 'Файл доступен только для чтения. Вы можете [переключиться в режим записи](%s) в системе, а затем [обновить](%s) документ для редактирования.',
  'can-not-edit-this-file-type': 'Невозможно редактировать данный тип файла',
  'read-only-mode-desc': 'В настоящее время приложение находится в режиме "только для чтения".',
  'trigger-suggestions': 'Подсказки триггера',
  'premium': {
    'confetti': 'Конфетти',
    'need-purchase': 'Для [%s] требуется премиум',
    'buy-license': 'Купить лицензию',
    'free': 'Бесплатно',
    'premium': 'Премиум',
    'upgrade': 'Перейти на премиум',
    'intro': {
      'intro': 'Описание',
      'current-plan': 'Текущий план',
      'included': 'Включено',
      'desc': 'Yank Note это проект с открытым исходным кодом, я постоянно развиваю его с 2018 года. На это уходят мои силы и деньги. Теперь доступна премиум-версия. Если вы хотите поддержать мое развитие или вам нужны дополнительные функции, вы можете купить лицензию.',
      'free-desc': 'Для большинства пользователей',
      'premium-desc': 'Дополнительные возможности',
      'free-list': 'Basic Editing\nGraphic Embedding\nRun Code Snippet\nHTML Applets\nEncryption\nTerminal Integration\nDocument History\nExtension',
      'premium-list': 'Basic Editing\nGraphic Embedding\nRun Code Snippet\nHTML Applets\nEncryption\nTerminal Integration\nDocument History (Advanced)\nExtension (More)\nMacro Replacement\nDark Mode',
    },
    'buy': {
      'buy': 'Купить',
    },
    'activation': {
      'license': 'Лицензия',
      'activation': 'Введите лицензию',
      'placeholder': 'Введите лицензию',
      'get-license': 'Получить лицензию',
      'info': 'Информация',
      'expired': 'Истекший срок действия',
      'expiring': 'Истекает через %s дней',
      'need-refresh': 'Необходимо обновить информацию об активации',
      'refresh': 'Обновить',
      'renewal': 'Обновление',
      'devices': 'Устройства',
      'this-machine': 'Это устройство',
      'unbind': 'Отвязать',
      'unbind-confirm': 'Вы уверены, что хотите отвязать "%s"?',
      'name': 'Имя: %s',
      'email': 'Email: %s',
      'expires': 'Истекает: %s',
      'plan': 'План: %s',
      'success': 'Успешно',
      'activating': 'Активация',
      'tips': 'Если у вас возникнут проблемы, пожалуйста, свяжитесь со мной',
      'tips-wechat': 'Wechat',
      'activation-tips': 'Перед активацией убедитесь, что у вас есть доступ к <a href="https://yank-note.com" target="_blank">https://yank-note.com</a>',
      'offline-activation': 'Оффлайн активация',
      'online-activation': 'Онлайн активация',
      'get-activation-token': 'Получить токен активации',
    },
  },
  'app': {
    'quit': 'Выход',
    'preferences': 'Настройки',
    'close-window': 'Закрыть окно',
    'toggle-fullscreen': 'Включить полноэкранный режим',
    'hide-main-window': 'Скрыть главное окно',
    'tray': {
      'open-main-window': 'Открыть главное окно',
      'open-in-browser': 'Открыть в браузере',
      'open-main-dir': 'Открыть папку',
      'preferences': 'Настройки',
      'start-at-login': 'Запускать при входе',
      'version': 'Версия %s',
      'quit': 'Выход',
      'dev': {
        'dev': 'Разработка',
        'port-prod': 'Prod порт (%s)',
        'port-dev': 'Dev порт (%s)',
        'reload': 'Перезагрузить',
        'dev-tool': 'Инструменты разработчика',
        'restart': 'Перезапустить',
        'force-quit': 'Принудительный выход',
      }
    },
    'updater': {
      'found-dialog': {
        'title': 'Yank Note - доступна новая версия',
        'desc': 'Текущая версия: %s\nНовая версия: %s',
        'buttons': {
          'download': 'Скачать',
          'view-changes': 'Посмотреть изменения',
          'download-and-view-changes': 'Скачать и посмотреть изменения',
          'cancel': 'Отмена',
          'ignore': 'Не спрашивать больше'
        }
      },
      'progress-bar': {
        'title': 'Yank Note - обновление',
        'detail': 'Загрузка %s',
        'failed': 'Не удалось загрузить: %s'
      },
      'failed-dialog': {
        'title': 'Yank Note - что-то пошло не так',
      },
      'install-dialog': {
        'title': 'Yank Note - загрузка завершена',
        'desc': 'Установить прямо сейчас?',
        'buttons': {
          'install': 'Установить',
          'delay': 'Установить позже',
        }
      },
      'no-newer-dialog': {
        'title': 'Yank Note - нет новых версий',
        'desc': 'У вас установлена самая последняя версия'
      }
    },
    'error': {
      'EADDRINUSE': 'Порт (%s) используется или не имеет достаточных разрешений, пожалуйста, настройте другой порт в настройках',
    },
  },
  'quit-check-dialog': {
    'title': 'Внимание',
    'desc': 'В документе есть несохраненные изменения. Вы действительно хотите выйти из документа без сохранения?',
    'buttons': {
      'cancel': 'Отмена',
      'discard': 'Сбросить изменения и выйти',
    },
  },
  'save-check-dialog': {
    'title': 'Внимание',
    'desc': 'Документ не был сохранен, хотите его сохранить?',
  },
  'change-setting-reload-main-widow-dialog': {
    'title': 'Внимание',
    'desc': 'Необходимо перезагрузить главное окно, чтобы некоторые настройки вступили в силу. Перезагрузить сейчас?',
  },
  'file-status': {
    'unsaved': 'Не сохранено',
    'saving': 'Сохранение',
    'saved': 'Сохранено',
    'save-failed': 'Не удалось сохранить!',
    'loaded': 'Загружено',
    'loading': 'Загрузка',
    'no-file': 'Нет открытого файла'
  },
  'modal': {
    'info': 'Информация',
    'input-placeholder': 'Пожалуйста, введите...',
  },
  'document': {
    'current-path': 'Текущий путь: %s',
    'invalid-filename': 'Имя файла не может содержать следующие символы: %s',
    'password-create': '[Создание] Пожалуйста, введите пароль',
    'password-save': '[Сохранение] Пожалуйста, введите пароль к файлу',
    'password-open': '[Открытие] Пожалуйста, введите пароль к файлу',
    'wrong-password': 'Неверный пароль',
    'file-transform-error': 'Зашифрованные и незашифрованные файлы не могут быть преобразованы друг в друга',
    'custom-extension': 'Пользовательское расширение',
    'create-dialog': {
      'title': 'Создать файл',
      'hint': 'Имя файл',
    },
    'create-dir-dialog': {
      'title': 'Создать папку',
      'hint': 'Имя папки',
    },
    'duplicate-dialog': {
      'title': 'Дублировать файл',
      'hint': 'Путь назначения',
    },
    'delete-dialog': {
      'title': 'Удалить файл',
      'content': 'Вы уверены, что хотите удалить %s?'
    },
    'move-dialog': {
      'title': 'Переместить/переименовать файл',
      'content': 'Новый путь'
    },
    'save-encrypted-file-dialog': {
      'title': 'Внимание',
      'content': 'Пароль не совпадает со старым паролем, сохранить с новым паролем?',
    },
    'switch-noent-dialog': {
      'title': 'Файл не найден',
      'content': 'Файл [%s] не найден, хотите его создать?',
    }
  },
  'status-bar': {
    'view': {
      'view': 'Вид',
      'xterm': 'Показать терминал',
      'preview': 'Предварительный просмотр',
      'editor': 'Показать редактор',
      'side-bar': 'Показать боковую панель',
      'word-wrap': 'Перенос снов',
      'typewriter-mode': 'Режим печатной машинки',
      'editor-preview-exclusive': 'Только режим редактора/просмотра',
    },
    'setting': 'Настройки',
    'repo': {
      'repo': 'Репозиторий: %s',
      'no-data': 'Нет репозитория',
    },
    'nav': {
      'nav': 'Навигация',
      'goto': 'Перейти',
      'reveal-current-file-in-sidebar': 'Показать текущий файл в боковой панели',
      'forward': 'Вперёд',
      'back': 'Назад',
    },
    'insert': {
      'insert': 'Вставка',
      'paste-rt': 'Вставить форматированный текст',
      'paste-img-base64': 'Вставить изображение',
    },
    'tool': {
      'tool': 'Утилиты',
      'convert-img-link': 'Скачать удалённое изображение',
      'macro-copy-markdown': 'Копировать Markdown после замены макроса',
      'copy-content': 'Копировать содержимое',
      'doc-history': 'История изменений',
      'share-preview': 'Поделиться',
      'print': 'Печать документа',
      'export': 'Экспорт документа',
    },
    'document-info': {
      'selected': 'Выделено',
      'lines': 'Строки',
      'chars': 'Знаки',
      'selections': 'Выделения',
    },
    'help': {
      'help': 'Помощь',
      'readme': 'Введение',
      'features': 'Функции',
      'shortcuts': 'Сочетания клавиш',
      'guide': 'Руководство',
      'plugin': 'Создать плагин'
    },
    'terminal': 'Терминал',
    'present': 'Презентация',
    'get': {
      'get-application': 'Скачать приложение',
    },
    'extension': {
      'extension-manager': 'Менеджер расширений',
    },
    'theme': {
      'tips': 'Тема: %s',
      'dark': 'Тёмная',
      'light': 'Светлая',
      'system': 'Системная',
    },
  },
  'view': {
    'outline': 'Конспект',
    'print': 'Печать',
  },
  'tree': {
    'db-click-refresh': 'Двойной клик, чтобы обновить',
    'add-repo': 'Добавить репозиторий',
    'add-repo-hint': 'Выберите место для хранения заметок',
    'created-at': 'Создан: %s',
    'updated-at': 'Обновлён: %s',
    'context-menu': {
      'mark': 'Отметить файл',
      'unmark': 'Снять отметку',
      'duplicate': 'Дублировать',
      'create-doc': 'Новый файл',
      'create-dir': 'Новая папка',
      'add-item': 'Добавить элемент',
      'rename': 'Переименовать/переместить',
      'delete': 'Удалить',
      'open-in-os': 'Открыть с помощью',
      'reveal-in-os': 'Показать в проводнике',
      'refresh': 'Обновить',
      'open-in-terminal': 'Открыть в терминале',
      'create-in-cd': 'Новый файл',
      'copy-name': 'Копировать имя',
      'copy-path': 'Копировать путь',
      'find-in-folder': 'Поиск в папке',
    },
    'toast': {
      'moved': '[%s] перемещён в [%s]',
      'copied': '[%s] скопирован в [%s]',
    },
    'sort': {
      'asc': 'по возрастанию',
      'desc': 'по убыванию',
      'by-name': 'Сортировать по имени (%s)',
      'by-mtime': 'Сортировать по изменённым (%s)',
      'by-birthtime': 'Сортировать по дате создания (%s)',
      'by-serial': 'Сортировать по серийному номеру (%s)',
    },
  },
  'tabs': {
    'close-others': 'Закрыть другие',
    'close-right': 'Закрыть справа',
    'close-left': 'Закрыть слева',
    'close-all': 'Закрыть все',
    'pin': 'Прикрепить',
    'unpin': 'Открепить',
    'search-tabs': 'Поиск вкладки',
    'new-tab': 'Новая вкладка',
  },
  'export-panel': {
    'export': 'Экспорт',
    'format': 'Формат',
    'pdf': {
      'orientation': 'Ориентация',
      'portrait': 'Портретная',
      'landscape': 'Ландшафтная',
      'size': 'Размер',
      'zoom': 'Увеличение',
      'use-browser': 'Будет использоваться функция печати через браузер.',
      'include-bg': 'Включить фон',
      'generate-document-outline': 'Создать конспект документа',
    },
    'use-html': 'Использовать отображаемый HTML',
    'use-markdown': 'Использовать исходный код разметки',
    'loading': 'Конвертация, пожалуйста, подождите...',
  },
  'title-bar': {
    'pin': 'Прикрепить',
    'minimize': 'Свернуть',
    'unmaximize': 'Вернуть',
    'maximize': 'Развернуть',
  },
  'setting-panel': {
    'setting': 'Настройка',
    'add': 'Добавить %s',
    'delete-warning': 'Вы уверены, что хотите удалить этот узел?',
    'error-choose-repo-path': 'Пожалуйста, выберите путь к репозиторию',
    'change-keyboard-shortcuts': 'Изменить сочетания клавиш',
    'tabs': {
      'repos': 'Репозитории',
      'appearance': 'Внешний вид',
      'editor': 'Редактор',
      'render': 'Отображение',
      'image': 'Изображения',
      'proxy': 'Прокси',
      'macros': 'Макросы',
      'other': 'Другое',
    },
    'schema': {
      'repos': {
        'repos': 'Репозитории',
        'repo': 'Репозиторий',
        'name': 'Имя',
        'name-placeholder': 'Имя',
        'path': 'Путь',
        'path-placeholder': 'Пожалуйста, выберите место хранения',
        'enable-indexing': 'Включить индексацию',
      },
      'editor': {
        'mouse-wheel-zoom': 'Масштабирование колёсиком мыши',
        'font-size': 'Размер шрифта',
        'tab-size': 'Размер табуляции',
        'ordered-list-completion': 'Упорядоченный список',
        'minimap': 'Мини-карта',
        'line-numbers': 'Номера строк',
        'enable-preview': 'Включить предпросмотр - открывать новые файлы с помощью временных вкладок, двойной клик по вкладке для изменения',
        'font-family': 'Семейство шрифтов',
        'font-ligatures': 'Шрифтовые лигатуры',
        'complete-emoji': 'Полный список эмодзи - введите : для отображения списка эмодзи',
        'todo-with-time': 'Добавлять время при проверке TODO',
        'suggest-on-trigger-characters': 'Подсказки при вводе - вы также можете использовать Ctrl+Space (в зависимости от сочетания клавиш) для запуска',
        'sticky-scroll-enabled': 'Включить липкую прокрутку - при прокрутке редактора заголовок документа фиксируется',
        'quick-suggestions': 'Быстрые предложения - предлагайте по мере ввода текста',
        'enable-ai-copilot-action': 'Включить AI Copilot - показать лампочку действия AI Copilot, если она доступна',
        'enable-trigger-suggest-bulb': 'Включить предложения триггера - показать лампочку предложения триггера, если она доступна',
      },
      'render': {
        'md-html': 'Включить HTML',
        'md-breaks': 'Преобразовать \\n в &lt;br&gt;',
        'md-linkify': 'Автоматическое преобразование текста, похожего на URL, в ссылки',
        'md-wiki-links': 'Включить Wiki ссылки - [[ссылка]]',
        'md-typographer': 'Включите некоторые языковые замены + улучшение кавычек',
        'md-sup': 'Включить надстрочный синтаксис: 29^th^',
        'md-sub': 'Включить подстрочный синтаксис: H~2~O',
        'md-emoji': 'Включите синтаксис эмодзи: :smile:',
        'multimd-multiline': 'Включить многострочный синтаксис [multimd]:',
        'multimd-rowspan': 'Включить синтаксис объединением рядов [multimd]:',
        'multimd-headerless': 'Включить синтаксис без заголовков [multimd]:',
        'multimd-multibody': 'Включить многокомпонентный синтаксис [multimd]:',
      },
      'view': {
        'default-previewer-max-width': 'Максимальная ширина окна предпросмотра',
        'default-previewer-max-width-desc': '≤ 100 означает процент, > 100 - пиксели',
      },
      'theme': 'Тема',
      'language': 'Язык',
      'custom-css': 'Пользовательский CSS',
      'assets-dir': 'Папка для изображений',
      'assets-desc': 'Относительный или абсолютный путь (в хранилище документов). Переменные: docName, docBasename, docSlug, docHash, date.',
      'assets': {
        'path-type': 'Тип пути',
      },
      'shell': 'Оболочка',
      'envs': 'Окружение',
      'auto-save': 'Автосохранение',
      'plantuml-api': 'PlantUML точка',
      'updater': {
        'source': 'Обновить источник',
      },
      'doc-history': {
        'number-limit': 'Версии сохранены',
      },
      'search': {
        'number-limit': 'Результаты поиска',
      },
      'server': {
        'host': 'Хост',
        'port': 'Порт',
        'port-desc': 'Необходимо перезапустить приложение.'
      },
      'tree': {
        'exclude': 'Исключить файлы',
      },
      'proxy': {
        'enabled': 'Включено',
        'server': 'Прокси сервер',
        'server-hint': '127.0.0.1:8080',
        'bypass-list': 'Cписок обходных адресов',
        'pac-url': 'PAC URL',
      },
      'macros': {
        'macros': 'Макросы',
        'match': 'Соответствие',
        'replace': 'Замена',
        'match-placeholder': '%foo%',
        'replace-placeholder': '%foo% -> BAR',
      },
      'hide-main-window-on-startup': 'Скрыть главное окно при запуске',
      'keep-running-after-closing-window': 'Продолжать работу после закрытия окна',
    }
  },
  'quick-open': {
    'input-placeholder': 'Введите...',
    'empty': 'Пусто',
    'files': 'Файлы',
    'marked': 'Отмеченные',
  },
  'editor': {
    'context-menu': {
      'paste-image': 'Вставить изображение',
      'paste-image-as-base64': 'Вставить изображение как Base64',
      'paste-rt-as-markdown': 'Вставить форматированный текст как Markdown',
      'add-attachment': 'Добавить вложение',
      'link-doc': 'Ссылка на документ',
      'link-file': 'Ссылка на файл',
      'insert-date': 'Вставить сегодняшнюю дату',
      'insert-time': 'Вставить текущее время',
      'reveal-line-in-preview': 'Показать строку в предпросмотре',
      'force-insert-new-line': 'Принудительная вставка новой строки',
      'force-insert-indent': 'Принудительная вставка отступа',
    },
    'switch-editor': 'Переключить редактор',
    'default-editor': 'Редактор по умолчанию',
    'action-label': {
      'reveal-current-file-in-os': 'Показать текущий файл',
      'refresh-current-document': 'Обновить текущий документ',
    },
  },
  'previewer': {
    'default-previewer': 'Предпросмотр по умолчанию',
    'switch-previewer': 'Переключить просмотрщик',
  },
  'picgo': {
    'setting': {
      'api-title': 'PicGo API',
      'api-desc': 'URL-адрес PicGo по умолчанию: http://127.0.0.1:36677/upload',
      'api-msg': 'Должен начинаться с http://',
      'paste-title': 'Вставить изображение с помощью PicGo'
    },
    'uploading': 'Загрузка',
    'upload-failed': 'Загрузка не удалась',
    'need-api': 'Сначала настройте PicGo API.',
    'upload-all-images': 'Загрузить все изображения',
  },
  'code-run': {
    'run': 'Запустить',
    'stop': 'Остановить',
    'run-in-xterm-tips': 'Запустить код в терминале, %s + клик не выходить',
    'run-in-xterm': 'Запустить в терминале',
    'running': 'Запуск...',
    'clear': 'Очистить',
  },
  'mind-map': {
    'zoom-in': 'Увеличить масштаб',
    'zoom-out': 'Уменьшить масштаб',
    'fit-height': 'Подходящая высота',
    'switch-layout': 'Компоновка',
    'switch-loose': 'Компактный/Свободный',
    'convert-error': 'Ошибка преобразования\n    1. Убедитесь, что в конспекте есть только один корневой элемент.\n    2. Убедитесь, что уровень конспекта правильный.',
  },
  'table-cell-edit': {
    'esc-to-cancel': 'Нажмите Esc для отмены',
    'db-click-edit': 'Двойной клик для редактирования',
    'canceled': 'Отменено',
    'edit-hint': 'Содержимое',
    'edit-title': 'Редактировать ячейку',
    'edit-error': 'Что-то не так',
    'limit-single-line': 'Редактирование только отдельных строк',
    'context-menu': {
      'edit': 'Изменить',
      'quick-edit': 'Выйти из режима редактирования',
      'sort-mode': 'Режим сортировки',
      'sort-asc': 'Сортировать по возрастанию',
      'sort-desc': 'Сортировка по убыванию',
      'align-left': 'Выравнивание по левому краю',
      'align-center': 'Выровнять по центру',
      'align-right': 'Выравнивание по правому краю',
      'align-normal': 'Выровнять нормаль',
      'add-row-above': 'Добавить строку выше',
      'add-row-below': 'Добавить строку ниже',
      'delete-row': 'Удалить строку',
      'add-col-left': 'Добавить столбец слева',
      'add-col-right': 'Добавить столбец справа',
      'delete-col': 'Удалить столбец',
    },
  },
  'markdown-link': {
    'convert-to-titled-link': 'Преобразование в ссылку с названием',
  },
  'custom-css': {
    'change-confirm': {
      'title': 'Внимание',
      'content': 'Изменение пользовательского CSS требует перезагрузки страницы. Вы хотите продолжить?',
    }
  },
  'control-center': {
    'control-center': 'Центр управления %s',
    'switch': {
      'side-bar': 'Боковая панель %s',
      'editor': 'Редактор %s',
      'view': 'Редактор %s',
      'sync-scroll': 'Синхронная прокрутка',
      'sync-rendering': 'Синхронное отображение',
      'word-wrap': 'Перенос слов %s',
      'typewriter-mode': 'Режим печатной машинки',
      'find-in-preview': 'Найти в предпросмотре %s',
    },
    'navigation': {
      'goto': 'Перейти %s',
      'forward': 'Вперёд %s',
      'back': 'Назад %s',
      'refresh': 'Обновить %s',
    }
  },
  'doc-history': {
    'clear': 'Очистить',
    'apply-version': 'Применить выбранную версию',
    'no-history': 'Нет истории',
    'content': 'Содержимое',
    'diff': 'Изменения',
    'history': 'История',
    'current': 'Текущий',
    'all': 'Все',
    'marked': 'Отмечено',
    'mark': 'Отметить',
    'unmark': 'Снять отметку',
    'delete': 'Удалить',
    'edit-message': 'Изменить сообщение',
    'delete-dialog': {
      'title': 'Удалить',
      'content': 'Вы уверены, что хотите удалить [%s]?',
    },
    'clear-dialog': {
      'title': 'Очистить',
      'content': 'Вы уверены, что хотите очистить неотмеченные версии?',
    },
    'mark-dialog': {
      'title': 'Отметить версию [%s]',
      'hint': 'Введите сообщение (необязательно)',
    },
    'content-too-long-alert': {
      'title': 'Предупреждение',
      'content': 'По соображениям производительности документы, содержащие более [%s] символов, не будут сохранять историю. Текущая длина документа [%s] символов.',
    },
  },
  'copy-content': {
    'options': 'Настройки: ',
    'type': 'Тип копии: ',
    'inline-style': 'Встроенный стиль',
    'include-style': 'Включить стиль',
    'inline-image': 'Встроенное локальное изображение',
    'upload-image': 'Загрузить локальное изображение',
    'highlight-code': 'Выделить код',
    'rt': 'Форматированный текст',
    'complete': 'Конвертация завершена, нажмите ОК, чтобы скопировать',
    'copy-tips': 'Если вам необходимо скопировать часть содержимого, сначала выделите его в области предпросмотра.',
    'copy-tips-selected': 'Копировать выбранное содержимое, %s символов.',
  },
  'share-preview': {
    'expire': 'Истекает',
    'tips': 'Сначала настройте хост "0.0.0.0" в настройках.',
  },
  'electron-zoom': {
    'zoom-in': 'Увеличить масштаб',
    'zoom-out': 'Уменьшить масштаб',
    'zoom-reset': 'Фактический размер',
  },
  'extension': {
    'extension-manager': 'Менеджер расширений',
    'all': 'Все',
    'installed': 'Установлено',
    'official': 'Официальный',
    'unofficial': 'Неофициальный',
    'unknown': 'Неизвестно',
    'author': 'Автор',
    'origin': 'Источник',
    'unpacked-size': 'Размер в распакованном виде',
    'latest-version': 'Последняя версия',
    'installed-version': 'Установленная версия',
    'homepage': 'Домашняя страница',
    'download': 'Скачать',
    'toast-loaded': 'Расширение загружено',
    'upgradable': 'Обновляемый',
    'incompatible': 'Несовместимо',
    'not-installed': 'Не установлено',
    'enabled': 'Включено',
    'disabled': 'Отключено',
    'reload-required': 'Требуется перезагрузка',
    'no-extension': 'Нет расширения',
    'reload': 'Перезагрузить',
    'install': 'Установить',
    'uninstall': 'Удалить',
    'installing': 'Установка',
    'uninstalling': 'Удаление',
    'upgrade': 'Обновить',
    'disable': 'Отключить',
    'enable': 'Включить',
    'uninstall-confirm': 'Вы уверены, что хотите удалить [%s]?',
    'registry': 'Реестр',
    'activation-time': 'Время активации',
    'requirement': 'Требование',
    'auto-upgrade': 'Автообновление',
    'unknown-origin-tips': 'Использование расширений из неизвестных источников может быть рискованным, вы все еще хотите включить их?',
    'extensions-auto-upgraded': 'Расширения были обновлены: %s шт.',
    'fetch-registry-failed': 'Не удалось загрузить реестр, пожалуйста, переключитесь на другой реестр или повторите попытку позже',
  },
  'get-started': {
    'get-started': 'Начать',
    'start': 'Начало',
    'help': 'Помощь',
    'recent': 'Последние',
  },
  'search-panel': {
    'search-files': 'Поиск файлов',
    'placeholder-search': 'Поиск',
    'for-history': '(⇅ для истории)',
    'files-to-include': 'Файлы для включения',
    'files-to-exclude': 'Файлы для исключения',
    'match-case': 'Регистр важен',
    'match-whole-word': 'Искать целое слово',
    'use-regex': 'Использовать регулярное выражение',
    'expand-all': 'Развернуть все',
    'collapse-all': 'Свернуть все',
  },
  'file-changed-alert': {
    'title': 'Файл изменен',
    'content': 'Файл был изменен на диске. Хотите перезагрузить его?',
    'reload': 'Перезагрузить',
  },
  'command-desc': {
    'base_find-in-repository': 'Найти содержимое в репозитории',
    'control-center_toggle': 'Показать/скрыть центр управления',
    'doc_show-history': 'Показать историю документа',
    'editor_toggle-wrap': 'Включить/выключить перенос слов',
    'file-tabs_close-current': 'Закрыть текущий файл',
    'file-tabs_search-tabs': 'Поиск вкладки',
    'file-tabs_show-welcome': 'Показать приветствие',
    'file-tabs_switch-left': 'Переключиться на левую вкладку',
    'file-tabs_switch-right': 'Переключиться на правую вкладку',
    'layout_toggle-editor': 'Показать/скрыть редактор',
    'layout_toggle-side': 'Показать/скрыть боковую панель',
    'layout_toggle-view': 'Показать/скрыть предпросмотр',
    'layout_toggle-xterm': 'Показать/скрыть терминал',
    'plugin_copy-content_copy-content': 'Показать панель копирования содержимого',
    'plugin_document-history-stack_back': 'Вернуться к предыдущему документу',
    'plugin_document-history-stack_forward': 'Перейти к следующему документу',
    'plugin_editor_focus-editor': 'Переключиться на редактор',
    'plugin_switch-todo_switch': 'Отметить/снять отметку с TODO (сначала необходимо выбрать содержимое в редакторе)',
    'plugin_view-links_view-document-links': 'Показать ссылки на документ',
    'view_enter-presentation': 'Войти в режим презентации',
    'workbench_show-quick-open': 'Показать быстрое открытие',
    'workbench_toggle-outline': 'Показать/скрыть конспект',
    'plugin_electron-zoom_zoom-in': 'Увеличить масштаб',
    'plugin_electron-zoom_zoom-out': 'Уменьшить масштаб',
    'plugin_electron-zoom_zoom-reset': 'Сбросить масштаб',
    'view_refresh': 'Обновить предпросмотр',
    'extension_show-manager': 'Показать менеджер расширений',
    'keyboard-shortcuts_show-manager': 'Показать сочетания клавиш',
    'plugin_image-localization_all': 'Скачать все удаленные изображения',
    'tree_refresh': 'Обновить дерево файлов',
    'plugin_status-bar-theme_switch': 'Переключить тему',
    'editor_rotate-custom-editors': 'Повернуть пользовательские редакторы',
    'view_show-find-in-preview-widget': 'Показать поиск в виджете предпросмотра',
    'tree_reveal-current-node': 'Показать текущий документ в дереве файлов',
  },
  'keyboard-shortcuts': {
    'workbench': 'Рабочее пространство',
    'editor': 'Редактор',
    'application': 'Приложение',
    'keyboard-shortcuts': 'Сочетания клавиш',
    'unavailable': 'Недоступно',
    'command': 'Команда',
    'keybinding': 'Привязка клавиш',
    'not-set': 'Не установлен',
    'clear': 'Очистить',
    'change': 'Сменить',
    'reset': 'Сбросить',
    'search': 'Поиск, "*" для отображения измененных',
    'empty': 'Нет результатов',
    'recorder': {
      'tip': 'Нажмите нужную комбинацию клавиш, а затем нажмите Enter, Esc для отмены.',
      'conflict-commands': 'Есть команды (%s шт.) с одинаковыми сочетаниями клавиш',
    },
    'conflict': 'Конфликт',
    'conflict-title': 'Конфликт привязки клавиш (%s)',
    'conflict-commands': 'Следующие команды имеют одинаковые сочетания клавиш:',
  },
  'find-in-preview': {
    'action-tips': {
      'prev': 'Предыдущее совпадение (Shift + Enter)',
      'next': 'Следующее совпадение (Enter)',
      'close': 'Закрыть (Esc)',
    },
    'results': '%s совпадений',
    'toast-no-more': 'Больше нет совпадений',
  },
  'view-context-menu': {
    'copy-image': 'Копировать изображение',
    'delete-image': 'Удалить изображение',
    'open-in-new-tab': 'Открыть в новой вкладке',
  },
  'index-status': {
    'switch-repository-html': 'Пожалуйста, <a href="javascript:void(0)" data-command="switch-repository">переключитесь на репозиторий [<strong>%s</strong>]</a>, чтобы использовать эту функцию.',
    'enable-indexing-html': 'Пожалуйста, <a href="javascript:void(0)" data-command="enable-indexing">включите индексацию для репозитория [<strong>%s</strong>]</a>, чтобы использовать эту функцию.',
    'indexing': 'Индексация...',
    'indexed': 'Индексировано',
  },
  'view-links': {
    'links': 'Ссылки',
    'back-links': 'Обратные ссылки',
    'no-result': 'Нет результатов',
    'links-in': 'Ссылки в “%s”',
    'back-links-for': 'Обратные ссылки для “%s”',
    're-index': 'Переиндексировать',
  },
}

export default data
