/* eslint-disable quote-props */

const data = {
  'app-name': 'Yank Note',
  'about': 'About',
  'feedback': 'Feedback',
  'slogan': 'A highly extensible Markdown editor, designed for productivity.',
  'cancel': 'Cancel',
  'undo': 'Undo',
  'ok': 'OK',
  'demo-tips': 'Some features are not available in DEMO mode.',
  'more': 'More',
  'copied': 'Copied',
  'others': 'Others',
  'insert-different-repo-doc': 'Documents from different repository cannot be inserted',
  'need-clipboard-permission': 'Please grant clipboard permissions',
  'click-to-copy': 'Click to copy',
  'click-to-copy-link': 'Click to copy link',
  'copy-code': 'Copy code',
  'loading': 'Loading',
  'add-image': 'Add Image',
  'upload-image': 'Upload Image',
  'exit-presentation-msg': 'Press the Esc key to exit',
  'reload': 'Reload',
  'open-in-new-window': 'New Window',
  'view-figure': 'View Figure',
  'export': 'Export',
  'no-password': 'No password was entered',
  'save': 'Save',
  'close': 'Close',
  'discard': 'Discard',
  'edit': 'Edit',
  'outline': 'Outline',
  'files': 'Files',
  'install-extension-tips': 'Please install and enable the "%s" extension first',
  'not-support-mas': 'Yank Note downloaded from the Mac Apple Store does not support this extension.',
  'learn-more': 'Learn More',
  'default': 'Default',
  'print': 'Print',
  'markdown-file': 'Markdown File',
  'encrypted-markdown-file': 'Encrypted Markdown File',
  'switch-repo-n': 'Switch to the repository [%s]',
  'switch-the-last-repo': 'Switch to the last repository',
  'edit-or-generate-text-using-ai': 'Edit or generate text using AI',
  'file-readonly-desc': 'The file is read-only. You can [change to writable](%s) in the system and then [refresh](%s) the document to edit.',
  'can-not-edit-this-file-type': 'Cannot edit this file type',
  'read-only-mode-desc': 'The application is currently in read-only mode and cannot be edited.',
  'trigger-suggestions': 'Trigger Suggestions',
  'premium': {
    'confetti': 'Confetti',
    'need-purchase': '[%s] Premium is required',
    'buy-license': 'Buy License',
    'free': 'Free',
    'premium': 'Premium',
    'upgrade': 'Upgrade to Premium',
    'intro': {
      'intro': 'Intro',
      'current-plan': 'Current Plan',
      'included': 'Included',
      'desc': 'Yank Note is open-source, I\'ve been constantly developing it since 2018. It takes my energy and money. Now a premium version is available. If you want to support my development or need advanced features, you can buy a license.',
      'free-desc': 'For most users',
      'premium-desc': 'More features',
      'free-list': 'Basic Editing\nGraphic Embedding\nRun Code Snippet\nHTML Applets\nEncryption\nTerminal Integration\nDocument History\nExtension',
      'premium-list': 'Basic Editing\nGraphic Embedding\nRun Code Snippet\nHTML Applets\nEncryption\nTerminal Integration\nDocument History (Advanced)\nExtension (More)\nMacro Replacement\nDark Mode',
    },
    'buy': {
      'buy': 'Buy',
    },
    'activation': {
      'license': 'License',
      'activation': 'Enter License',
      'placeholder': 'Enter license',
      'get-license': 'Get License',
      'info': 'Info',
      'expired': 'Expired',
      'expiring': 'Expiring in %s days',
      'need-refresh': 'Need to refresh activation information',
      'refresh': 'Refresh',
      'renewal': 'Renewal',
      'devices': 'Devices',
      'this-machine': 'This Machine',
      'unbind': 'Unbind',
      'unbind-confirm': 'Are you sure to unbind "%s"?',
      'name': 'Name: %s',
      'email': 'Email: %s',
      'expires': 'Expired at: %s',
      'plan': 'Plan: %s',
      'success': 'Success',
      'activating': 'Activating',
      'tips': 'If you have trouble, please contact me',
      'tips-wechat': 'Wechat',
      'activation-tips': 'Make sure your network can access <a href="https://yank-note.com" target="_blank">https://yank-note.com</a> before activating',
      'offline-activation': 'Offline Activation',
      'online-activation': 'Online Activation',
      'get-activation-token': 'Get Activation Token',
    },
  },
  'app': {
    'quit': 'Quit',
    'preferences': 'Preferences',
    'close-window': 'Close Window',
    'toggle-fullscreen': 'Toggle Full Screen',
    'hide-main-window': 'Hide Main Window',
    'tray': {
      'open-main-window': 'Open Main Window',
      'open-in-browser': 'Open in Browser',
      'open-main-dir': 'Open Main Dir',
      'preferences': 'Preferences',
      'start-at-login': 'Start at Login',
      'version': 'Version %s',
      'quit': 'Quit',
      'dev': {
        'dev': 'Develop',
        'port-prod': 'Prod Port (%s)',
        'port-dev': 'Dev port (%s)',
        'reload': 'Reload',
        'dev-tool': 'Develop Tool',
        'restart': 'Restart',
        'force-quit': 'Force Quit',
      }
    },
    'updater': {
      'found-dialog': {
        'title': 'Yank Note - Newer version was found',
        'desc': 'Current version: %s\nNewer version: %s',
        'buttons': {
          'download': 'Download',
          'view-changes': 'View Changes',
          'download-and-view-changes': 'Download and View Changes',
          'cancel': 'Cancel',
          'ignore': 'Don\'t Ask Again'
        }
      },
      'progress-bar': {
        'title': 'Yank Note - Download',
        'detail': 'Downloading %s',
        'failed': 'Download failed: %s'
      },
      'failed-dialog': {
        'title': 'Yank Note - Something went wrong',
      },
      'install-dialog': {
        'title': 'Yank Note - Download complete',
        'desc': 'Do you want to install it now?',
        'buttons': {
          'install': 'Install',
          'delay': 'Delay',
        }
      },
      'no-newer-dialog': {
        'title': 'Yank Note - No newer version',
        'desc': 'The current version is up-to-date'
      }
    },
    'error': {
      'EADDRINUSE': 'Port (%s) is in use or insufficient permissions, please configure another port in the settings',
    },
  },
  'quit-check-dialog': {
    'title': 'Attention',
    'desc': 'The document has unsaved changes. Do you really want to quit without saving?',
    'buttons': {
      'cancel': 'Cancel',
      'discard': 'Discard Changes and exit',
    },
  },
  'save-check-dialog': {
    'title': 'Attention',
    'desc': 'The document has not been saved, do you want to save it?',
  },
  'change-setting-reload-main-widow-dialog': {
    'title': 'Attention',
    'desc': 'Some settings need to reload the main window to take effect, do you want to reload now?',
  },
  'file-status': {
    'unsaved': 'Unsaved',
    'saving': 'Saving',
    'saved': 'Saved',
    'save-failed': 'Save Failed!',
    'loaded': 'Loaded',
    'loading': 'Loading',
    'no-file': 'No open file'
  },
  'modal': {
    'info': 'Info',
    'input-placeholder': 'Please input...',
  },
  'document': {
    'current-path': 'Current Path: %s',
    'invalid-filename': 'File name cannot contain the following characters: %s',
    'password-create': '[Create] Please enter a password',
    'password-save': '[Save] Please enter password of the file',
    'password-open': '[Open] Please enter password of the file',
    'wrong-password': 'Wrong Password',
    'file-transform-error': 'Encrypted and unencrypted files cannot be converted to each other',
    'custom-extension': 'Custom Extension',
    'create-dialog': {
      'title': 'Create a file',
      'hint': 'File name',
    },
    'create-dir-dialog': {
      'title': 'Create a Folder',
      'hint': 'Folder name',
    },
    'duplicate-dialog': {
      'title': 'Duplicate a File',
      'hint': 'Target path',
    },
    'delete-dialog': {
      'title': 'Delete a File',
      'content': 'Are you sure want to delete %s?'
    },
    'move-dialog': {
      'title': 'Move/Rename a File',
      'content': 'New path'
    },
    'save-encrypted-file-dialog': {
      'title': 'Attention',
      'content': 'The password doesn\'t match the old password, save it with the new password?',
    },
    'switch-noent-dialog': {
      'title': 'File Not Found',
      'content': 'File [%s] not found, do you want to create it?',
    }
  },
  'status-bar': {
    'view': {
      'view': 'View',
      'xterm': 'Show Terminal',
      'preview': 'Show Preview',
      'editor': 'Show Editor',
      'side-bar': 'Show Side Bar',
      'word-wrap': 'Word Wrap',
      'typewriter-mode': 'Typewriter Mode',
      'editor-preview-exclusive': 'Editor/Preview Exclusive',
    },
    'setting': 'Setting',
    'repo': {
      'repo': 'Repo: %s',
      'no-data': 'No Repo',
    },
    'nav': {
      'nav': 'Navigation',
      'goto': 'Goto',
      'reveal-current-file-in-sidebar': 'Reveal Current File in Sidebar',
      'forward': 'Forward',
      'back': 'Back',
    },
    'insert': {
      'insert': 'Insert',
      'paste-rt': 'Paste Rich Text',
      'paste-img-base64': 'Paste Image',
    },
    'tool': {
      'tool': 'Tool',
      'convert-img-link': 'Download Remote Image',
      'macro-copy-markdown': 'Copy Markdown after Macro Replacement',
      'copy-content': 'Copy Content',
      'doc-history': 'Document History',
      'share-preview': 'Share Preview',
      'print': 'Print Document',
      'export': 'Export Document',
    },
    'document-info': {
      'selected': 'Selected',
      'lines': 'Lines',
      'chars': 'Chars',
      'selections': 'Selections',
    },
    'help': {
      'help': 'Help',
      'readme': 'Introduction',
      'features': 'Features',
      'shortcuts': 'Shortcuts',
      'guide': 'Guide',
      'plugin': 'Create Plugin'
    },
    'terminal': 'Terminal',
    'present': 'Present',
    'get': {
      'get-application': 'Get Application',
    },
    'extension': {
      'extension-manager': 'Extension Manager',
    },
    'theme': {
      'tips': 'Theme: %s',
      'dark': 'Dark',
      'light': 'Light',
      'system': 'OS Default',
    },
  },
  'view': {
    'outline': 'Outline',
    'print': 'Print',
  },
  'tree': {
    'db-click-refresh': 'Double click to refresh',
    'add-repo': 'Add repository',
    'add-repo-hint': 'Choose a location to save your notes',
    'created-at': 'Created at: %s',
    'updated-at': 'Updated at: %s',
    'context-menu': {
      'mark': 'Mark File',
      'unmark': 'Unmark File',
      'duplicate': 'Duplicate',
      'create-doc': 'New File',
      'create-dir': 'New Folder',
      'add-item': 'Add Item',
      'rename': 'Rename / Move',
      'delete': 'Delete',
      'open-in-os': 'Open in OS',
      'reveal-in-os': 'Reveal in OS',
      'refresh': 'Refresh',
      'open-in-terminal': 'Open in Terminal',
      'create-in-cd': 'New File',
      'copy-name': 'Copy Name',
      'copy-path': 'Copy Path',
      'find-in-folder': 'Find in Folder',
    },
    'toast': {
      'moved': '[%s] Moved to [%s]',
      'copied': '[%s] Copied to [%s]',
    },
    'sort': {
      'asc': 'Ascending',
      'desc': 'Descending',
      'by-name': 'Sort by Name (%s)',
      'by-mtime': 'Sort by Modified (%s)',
      'by-birthtime': 'Sort by Created (%s)',
      'by-serial': 'Sort by Serial (%s)',
    },
  },
  'tabs': {
    'close-others': 'Close Others',
    'close-right': 'Close to the Right',
    'close-left': 'Close to the Left',
    'close-all': 'Close All',
    'pin': 'Pin',
    'unpin': 'Unpin',
    'search-tabs': 'Search tabs',
    'new-tab': 'New Tab',
  },
  'export-panel': {
    'export': 'Export',
    'format': 'Format',
    'pdf': {
      'orientation': 'Orientation',
      'portrait': 'Portrait',
      'landscape': 'Landscape',
      'size': 'Size',
      'zoom': 'Zoom',
      'use-browser': 'The browser printing feature will be used.',
      'include-bg': 'Include background',
      'generate-document-outline': 'Generate document outline',
    },
    'use-html': 'Use the rendered HTML source',
    'use-markdown': 'Use markdown source',
    'loading': 'Converting, please wait...',
  },
  'title-bar': {
    'pin': 'Pin',
    'minimize': 'Minimize',
    'unmaximize': 'Unmaximize',
    'maximize': 'Maximize',
  },
  'setting-panel': {
    'setting': 'Setting',
    'add': 'Add %s',
    'delete-warning': 'Are you sure you want to remove this node?',
    'error-choose-repo-path': 'Please choose repository path',
    'change-keyboard-shortcuts': 'Change Keyboard Shortcuts',
    'tabs': {
      'repos': 'Repositories',
      'appearance': 'Appearance',
      'editor': 'Editor',
      'render': 'Render',
      'image': 'Image',
      'proxy': 'Proxy',
      'macros': 'Macro',
      'other': 'Other',
    },
    'schema': {
      'repos': {
        'repos': 'Repositories',
        'repo': 'Repository',
        'name': 'Name',
        'name-placeholder': 'Name',
        'path': 'Path',
        'path-placeholder': 'Please select the storage location',
        'enable-indexing': 'Enable Indexing',
      },
      'editor': {
        'mouse-wheel-zoom': 'Mouse Wheel Zoom',
        'font-size': 'Font Size',
        'tab-size': 'Tab Size',
        'ordered-list-completion': 'Ordered List',
        'minimap': 'Minimap',
        'line-numbers': 'Line Numbers',
        'enable-preview': 'Enable Preview - Open new files using temporary tabs, double click the tab to change',
        'font-family': 'Font Family',
        'font-ligatures': 'Font Ligatures',
        'complete-emoji': 'Complete Emoji - Input : to display emoji list',
        'todo-with-time': 'Add time when checking todo',
        'suggest-on-trigger-characters': 'Suggest on trigger characters - You can also use Ctrl+Space (depending on the shortcuts) to trigger',
        'sticky-scroll-enabled': 'Enable Sticky Scroll - When the editor scrolls, the document title is fixed',
        'quick-suggestions': 'Quick Suggestions - Suggest as you type',
        'enable-ai-copilot-action': 'Enable the AI Copilot Action - Show the AI Copilot Action lightbulb when available',
        'enable-trigger-suggest-bulb': 'Enable Trigger Suggest Bulb - Show the Trigger Suggest Bulb lightbulb when available',
      },
      'render': {
        'md-html': 'Enable HTML',
        'md-breaks': 'Convert \\n to &lt;br&gt;',
        'md-linkify': 'Auto convert URL-like text to links',
        'md-wiki-links': 'Enable Wiki Links - [[link]]',
        'md-typographer': 'Enable some language-neutral replacement + quotes beautification',
        'md-sup': 'Enable sup syntax: 29^th^',
        'md-sub': 'Enable sub syntax: H~2~O',
        'md-emoji': 'Enable emoji syntax: :smile:',
        'multimd-multiline': '[markdown-it-multimd-table]: Enable multiline syntax',
        'multimd-rowspan': '[markdown-it-multimd-table]: Enable rowspan syntax',
        'multimd-headerless': '[markdown-it-multimd-table]: Enable headerless syntax',
        'multimd-multibody': '[markdown-it-multimd-table]: Enable multibody syntax',
      },
      'view': {
        'default-previewer-max-width': 'Previewer Max Width',
        'default-previewer-max-width-desc': '≤ 100 means percentage, > 100 means pixels',
      },
      'theme': 'Theme',
      'language': 'Language',
      'custom-css': 'Custom CSS',
      'assets-dir': 'Image Dir',
      'assets-desc': 'Relative or absolute path (in document repository). Variables: docName, docBasename, docSlug, docHash, date.',
      'assets': {
        'path-type': 'Path Type',
      },
      'shell': 'Shell',
      'envs': 'Environments',
      'auto-save': 'Auto Save',
      'plantuml-api': 'PlantUML Endpoint',
      'updater': {
        'source': 'Update Source',
      },
      'doc-history': {
        'number-limit': 'Versions Retained',
      },
      'search': {
        'number-limit': 'Search Max Results',
      },
      'server': {
        'host': 'Listen Host',
        'port': 'Listen Port',
        'port-desc': 'Need to restart the application.'
      },
      'tree': {
        'exclude': 'Exclude Files',
      },
      'proxy': {
        'enabled': 'Enabled',
        'server': 'Proxy Server',
        'server-hint': '127.0.0.1:8080',
        'bypass-list': 'Bypass List',
        'pac-url': 'PAC URL',
      },
      'macros': {
        'macros': 'Macros',
        'match': 'Match',
        'replace': 'Replace',
        'match-placeholder': '%foo%',
        'replace-placeholder': '%foo% -> BAR',
      },
      'hide-main-window-on-startup': 'Hide Main Window on Startup',
      'keep-running-after-closing-window': 'Keep Running after Closing Window',
    }
  },
  'quick-open': {
    'input-placeholder': 'Type characters...',
    'empty': 'Empty',
    'files': 'Files',
    'marked': 'Marked',
  },
  'editor': {
    'context-menu': {
      'paste-image': 'Paste Image',
      'paste-image-as-base64': 'Paste Image as Base64',
      'paste-rt-as-markdown': 'Paste Rich Text as Markdown',
      'add-attachment': 'Add Attachment',
      'link-doc': 'Link Document',
      'link-file': 'Link File',
      'insert-date': 'Insert Today\'s Date',
      'insert-time': 'Insert Current Time',
      'reveal-line-in-preview': 'Reveal Line in Preview',
      'force-insert-new-line': 'Force Insert New Line',
      'force-insert-indent': 'Force Insert Indent',
    },
    'switch-editor': 'Switch Editor',
    'default-editor': 'Default Editor',
    'action-label': {
      'reveal-current-file-in-os': 'Reveal Current File in OS',
      'refresh-current-document': 'Refresh Current Document',
    },
  },
  'previewer': {
    'default-previewer': 'Default Previewer',
    'switch-previewer': 'Switch Previewer',
  },
  'picgo': {
    'setting': {
      'api-title': 'PicGo Api',
      'api-desc': 'PicGo default URL: http://127.0.0.1:36677/upload',
      'api-msg': 'Must starts with http://',
      'paste-title': 'Paste image with PicGo'
    },
    'uploading': 'Uploading',
    'upload-failed': 'Upload Failed',
    'need-api': 'Please configure PicGo Api first.',
    'upload-all-images': 'Upload All Images',
  },
  'code-run': {
    'run': 'Run',
    'stop': 'Stop',
    'run-in-xterm-tips': 'Run code in terminal, %s + click do not exit',
    'run-in-xterm': 'Run in terminal',
    'running': 'Running...',
    'clear': 'Clear',
  },
  'mind-map': {
    'zoom-in': 'Zoom In',
    'zoom-out': 'Zoom Out',
    'fit-height': 'Fit',
    'switch-layout': 'Layout',
    'switch-loose': 'Compact/Loose',
    'convert-error': 'Conversion error\n    1. Please ensure that the outline has only one root item.\n    2. Please ensure that the outline level is correct.',
  },
  'table-cell-edit': {
    'esc-to-cancel': 'Press ESC to cancel',
    'db-click-edit': 'Double Click to Edit',
    'canceled': 'Canceled',
    'edit-hint': 'Content',
    'edit-title': 'Edit Cell',
    'edit-error': 'Something wrong',
    'limit-single-line': 'Editing only single lines',
    'context-menu': {
      'edit': 'Edit',
      'quick-edit': 'Quit Edit',
      'sort-mode': 'Sort Mode',
      'sort-asc': 'Sort ascending',
      'sort-desc': 'Sort descending',
      'align-left': 'Align Left',
      'align-center': 'Align Center',
      'align-right': 'Align Right',
      'align-normal': 'Align Normal',
      'add-row-above': 'Add Row Above',
      'add-row-below': 'Add Row Below',
      'delete-row': 'Delete Row',
      'add-col-left': 'Add Column Left',
      'add-col-right': 'Add Column Right',
      'delete-col': 'Delete Column',
    },
  },
  'markdown-link': {
    'convert-to-titled-link': 'Convert to Titled Link',
  },
  'custom-css': {
    'change-confirm': {
      'title': 'Attention',
      'content': 'Changing the custom CSS requires the page to be reloaded. Do you want to continue?',
    }
  },
  'control-center': {
    'control-center': 'Control Center %s',
    'switch': {
      'side-bar': 'Side Bar %s',
      'editor': 'Editor %s',
      'view': 'Editor %s',
      'sync-scroll': 'Synchronous Scrolling',
      'sync-rendering': 'Synchronous Rendering',
      'word-wrap': 'Word Wrap %s',
      'typewriter-mode': 'Typewriter Mode',
      'find-in-preview': 'Find in Preview %s',
    },
    'navigation': {
      'goto': 'Goto %s',
      'forward': 'Forward %s',
      'back': 'Back %s',
      'refresh': 'Refresh %s',
    }
  },
  'doc-history': {
    'clear': 'Clear',
    'apply-version': 'Apply Selected Version',
    'no-history': 'No History',
    'content': 'Content',
    'diff': 'Diff',
    'history': 'History',
    'current': 'Current',
    'all': 'All',
    'marked': 'Marked',
    'mark': 'Mark',
    'unmark': 'Unmark',
    'delete': 'Delete',
    'edit-message': 'Edit Message',
    'delete-dialog': {
      'title': 'Delete',
      'content': 'Are you sure want to delete [%s]?',
    },
    'clear-dialog': {
      'title': 'Clear',
      'content': 'Are you sure want to clear unmarked versions?',
    },
    'mark-dialog': {
      'title': 'Mark Version [%s]',
      'hint': 'Input some message (optional)',
    },
    'content-too-long-alert': {
      'title': 'Warning',
      'content': 'For performance reasons, documents with more than [%s] characters will not store history. The current document length is [%s] characters.',
    },
  },
  'copy-content': {
    'options': 'Options: ',
    'type': 'Copy Type: ',
    'inline-style': 'Inline Style',
    'include-style': 'Include Style',
    'inline-image': 'Inline Local Image',
    'upload-image': 'Upload Local Image',
    'highlight-code': 'Highlight Code',
    'rt': 'Rich Text',
    'complete': 'Conversion completed, click OK to copy',
    'copy-tips': 'If you need to copy part of the content, you need select it in the preview area first.',
    'copy-tips-selected': 'Copy selected content, %s characters.',
  },
  'share-preview': {
    'expire': 'Expire',
    'tips': 'Please configure the listening host "0.0.0.0" in the settings first',
  },
  'electron-zoom': {
    'zoom-in': 'Zoom In',
    'zoom-out': 'Zoom Out',
    'zoom-reset': 'Actual Size',
  },
  'extension': {
    'extension-manager': 'Extension Manager',
    'all': 'All',
    'installed': 'Installed',
    'official': 'Official',
    'unofficial': 'Unofficial',
    'unknown': 'Unknown',
    'author': 'Author',
    'origin': 'Origin',
    'unpacked-size': 'Unpacked Size',
    'latest-version': 'Latest Version',
    'installed-version': 'Installed Version',
    'homepage': 'Homepage',
    'download': 'Download',
    'toast-loaded': 'Extension Loaded',
    'upgradable': 'Upgradable',
    'incompatible': 'Incompatible',
    'not-installed': 'Not Installed',
    'enabled': 'Enabled',
    'disabled': 'Disabled',
    'reload-required': 'Reload Required',
    'no-extension': 'No Extension',
    'reload': 'Reload',
    'install': 'Install',
    'uninstall': 'Uninstall',
    'installing': 'Installing',
    'uninstalling': 'Uninstalling',
    'upgrade': 'Upgrade',
    'disable': 'Disable',
    'enable': 'Enable',
    'uninstall-confirm': 'Are you sure want to uninstall [%s]?',
    'registry': 'Registry',
    'activation-time': 'Activation Time',
    'requirement': 'Requirement',
    'auto-upgrade': 'Auto Upgrade',
    'unknown-origin-tips': 'Using extensions from unknown sources can be risky, still want to enable?',
    'extensions-auto-upgraded': '%s extensions have been upgraded',
    'fetch-registry-failed': 'Fetch registry failed, please switch to another registry or try again later',
  },
  'get-started': {
    'get-started': 'Get Started',
    'start': 'Start',
    'help': 'Help',
    'recent': 'Recent',
  },
  'search-panel': {
    'search-files': 'Search Files',
    'placeholder-search': 'Search',
    'for-history': '(⇅ for history)',
    'files-to-include': 'Files to include',
    'files-to-exclude': 'Files to exclude',
    'match-case': 'Match Case',
    'match-whole-word': 'Match Whole Word',
    'use-regex': 'Use Regular Expression',
    'expand-all': 'Expand All',
    'collapse-all': 'Collapse All',
  },
  'file-changed-alert': {
    'title': 'File Changed',
    'content': 'The file has been changed on disk, do you want to reload it?',
    'reload': 'Reload',
  },
  'command-desc': {
    'base_find-in-repository': 'Find Content in Repository',
    'control-center_toggle': 'Show / Hide Control Center',
    'doc_show-history': 'Show Document History',
    'editor_toggle-wrap': 'Enable / Disable Word Wrap',
    'file-tabs_close-current': 'Close Current File',
    'file-tabs_search-tabs': 'Search Tabs',
    'file-tabs_show-welcome': 'Show Welcome',
    'file-tabs_switch-left': 'Switch to Left Tab',
    'file-tabs_switch-right': 'Switch to Right Tab',
    'layout_toggle-editor': 'Show / Hide Editor',
    'layout_toggle-side': 'Show / Hide Side Bar',
    'layout_toggle-view': 'Show / Hide Preview',
    'layout_toggle-xterm': 'Show / Hide Terminal',
    'plugin_copy-content_copy-content': 'Show Copy Content Panel',
    'plugin_document-history-stack_back': 'Back to Previous Document',
    'plugin_document-history-stack_forward': 'Forward to Next Document',
    'plugin_editor_focus-editor': 'Focus Editor',
    'plugin_switch-todo_switch': 'Check / Uncheck Todo (need to select the content in the editor first)',
    'plugin_view-links_view-document-links': 'View Links of Current Document',
    'view_enter-presentation': 'Enter Presentation Mode',
    'workbench_show-quick-open': 'Show Quick Open',
    'workbench_toggle-outline': 'Show / Hide Outline',
    'plugin_electron-zoom_zoom-in': 'Zoom In',
    'plugin_electron-zoom_zoom-out': 'Zoom Out',
    'plugin_electron-zoom_zoom-reset': 'Reset Zoom',
    'view_refresh': 'Refresh Preview',
    'extension_show-manager': 'Show Extension Manager',
    'keyboard-shortcuts_show-manager': 'Show Keyboard Shortcuts',
    'plugin_image-localization_all': 'Download All Remote Images',
    'tree_refresh': 'Refresh File Tree',
    'plugin_status-bar-theme_switch': 'Switch Theme',
    'editor_rotate-custom-editors': 'Rotate Custom Editors',
    'view_show-find-in-preview-widget': 'Show Find in Preview Widget',
    'tree_reveal-current-node': 'Reveal Current Document in File Tree',
  },
  'keyboard-shortcuts': {
    'workbench': 'Workbench',
    'editor': 'Editor',
    'application': 'Application',
    'keyboard-shortcuts': 'Keyboard Shortcuts',
    'unavailable': 'Unavailable',
    'command': 'Command',
    'keybinding': 'Keybinding',
    'not-set': 'Not Set',
    'clear': 'Clear',
    'change': 'Change',
    'reset': 'Reset',
    'search': 'Search, "*" to show modified',
    'empty': 'No Result',
    'recorder': {
      'tip': 'Press desired key combination and then press ENTER, ESC to cancel.',
      'conflict-commands': '%s exists commands have the same keybinding',
    },
    'conflict': 'Conflict',
    'conflict-title': 'Conflict Keybinding (%s)',
    'conflict-commands': 'Following commands have the same keybindings:',
  },
  'find-in-preview': {
    'action-tips': {
      'prev': 'Previous Match (Shift + Enter)',
      'next': 'Next Match (Enter)',
      'close': 'Close (Esc)',
    },
    'results': '%s matches',
    'toast-no-more': 'No more matches',
  },
  'view-context-menu': {
    'copy-image': 'Copy Image',
    'delete-image': 'Delete Image',
    'open-in-new-tab': 'Open in New Tab',
  },
  'index-status': {
    'switch-repository-html': 'Please <a href="javascript:void(0)" data-command="switch-repository">Switch to the repository [<strong>%s</strong>]</a> to use this feature.',
    'enable-indexing-html': 'Please <a href="javascript:void(0)" data-command="enable-indexing">enable indexing for the repository [<strong>%s</strong>]</a> to use this feature.',
    'indexing': 'Indexing...',
    'indexed': 'Indexed',
  },
  'view-links': {
    'links': 'Links',
    'back-links': 'Back Links',
    'no-result': 'No Result',
    'links-in': 'Links in "%s"',
    'back-links-for': 'Back Links for "%s"',
    're-index': 'Re-index',
  },
}

export type BaseLanguage = typeof data

export default data
