import { extname } from '@fe/utils/path'
const extensions = [
  '.txt',
  '.gitignore',
  '.json',
  '.bowerrc',
  '.jshintrc',
  '.jscsrc',
  '.eslintrc',
  '.babelrc',
  '.bat',
  '.cmd',
  '.coffee',
  '.c',
  '.h',
  '.cpp',
  '.cc',
  '.cxx',
  '.hpp',
  '.hh',
  '.hxx',
  '.cs',
  '.csx',
  '.cake',
  '.css',
  '.dockerfile',
  '.fs',
  '.fsi',
  '.ml',
  '.mli',
  '.fsx',
  '.fsscript',
  '.go',
  '.handlebars',
  '.hbs',
  '.html',
  '.htm',
  '.shtml',
  '.xhtml',
  '.mdoc',
  '.jsp',
  '.asp',
  '.aspx',
  '.jshtm',
  '.ini',
  '.properties',
  '.gitconfig',
  '.java',
  '.jav',
  '.js',
  '.mjs',
  '.cjs',
  '.es6',
  '.jsx',
  '.kt',
  '.less',
  '.lua',
  '.md',
  '.markdown',
  '.mdown',
  '.mkdn',
  '.mkd',
  '.mdwn',
  '.mdtxt',
  '.mdtext',
  '.dax',
  '.msdax',
  '.m',
  '.pas',
  '.p',
  '.pp',
  '.php',
  '.php4',
  '.php5',
  '.phtml',
  '.ctp',
  '.dats',
  '.sats',
  '.hats',
  '.pq',
  '.pqm',
  '.ps1',
  '.psm1',
  '.psd1',
  '.jade',
  '.pug',
  '.py',
  '.rpy',
  '.pyw',
  '.cpy',
  '.gyp',
  '.gypi',
  '.r',
  '.rhistory',
  '.rprofile',
  '.rt',
  '.cshtml',
  '.redis',
  '.rb',
  '.rbx',
  '.rjs',
  '.gemspec',
  '.pp',
  '.rs',
  '.rlib',
  '.sb',
  '.scss',
  '.sol',
  '.sql',
  '.st',
  '.iecst',
  '.iecplc',
  '.lc3lib',
  '.swift',
  '.tcl',
  '.ts',
  '.mts',
  '.cts',
  '.tsx',
  '.vb',
  '.xml',
  '.dtd',
  '.ascx',
  '.csproj',
  '.config',
  '.wxi',
  '.wxl',
  '.wxs',
  '.xaml',
  '.svg',
  '.svgz',
  '.yaml',
  '.yml',
  '.scm',
  '.ss',
  '.sch',
  '.rkt',
  '.clj',
  '.cljs',
  '.cljc',
  '.edn',
  '.sh',
  '.bash',
  '.pl',
  '.azcli',
  '.cls',
  '.graphql',
  '.gql',
  '.bib',
  '.plantuml',
  '.dot',
  '.gv',
  '.puml',
]

const supported = (name: string) => {
  name = name.toLowerCase()
  const ext = extname(name) || (name.startsWith('.') ? name : '')
  return ext ? extensions.includes(ext) : false
}

export default {
  supported
}
