# Yank Note

**Гибкий, расширяемый** редактор Markdown, создан для повышения производительности. **[Скачать](https://github.com/purocean/yn/releases)** | **[Попробовать онлайн >>>](https://demo.yank-note.com/)**


[![Скачать](./help/mas_en.svg?.inline)](https://apps.apple.com/cn/app/yank-note/id1551528618) [Не рекомендуется](https://github.com/purocean/yn/issues/65#issuecomment-1065799677)

[English](./README.md) | [中文说明](./README_ZH-CN.md) | Русский

[toc]{level: [2]}

![Screenshot](./help/1.png)

## Особенности

- **Простота использования:** Используется ядро *Monaco*, оптимизированное для редактирования в формате Markdown, и возможности редактирования такие же, как у VSCode.
- **Мощный:** Поддержка контроля версий; в документ можно встраивать апплеты, запускаемые блоки кода, таблицы, PlantUML, Drawio, макрозамены и т.д.; поддержка автодополнения [OpenAI](https://openai.com).
- **Высокая совместимость:** Данные сохраняются в виде локальных файлов Markdown, а функции расширения реализованы в оригинальном синтаксисе Markdown, насколько это возможно.
- **Расширение плагинов:** Поддержка пользователей в написании собственных плагинов для расширения функциональности редактора.
- **Поддержка шифрования:** Используйте шифрование для сохранения приватных файлов, таких как номер счета, а пароль может быть установлен отдельно для каждого файла.

## Внимание

- Ради большей расширяемости Yank Note жертвует защитой безопасности (выполнение команд, произвольное чтение и запись файлов). Если вы хотите использовать его для открытия постороннего файла Markdown, ⚠️**убедитесь, что содержимое файла заслуживает доверия**⚠️.
- Шифрование и дешифрование зашифрованных файлов выполняется на клиентской стороне. Пожалуйста, **убедитесь, что вы помните свой пароль**. Если пароль утерян, его можно только взломать.

## Основнве функции

Более подробную информацию об использовании следующих функций см. в разделе [описание основных функций](./help/FEATURES.md)

- **Синхронная прокрутка:** область редактирования и область предварительного просмотра прокручиваются синхронно, а область предварительного просмотра можно прокручивать независимо
- **Конспект:** быстрый переход к соответствующему месту документа через конспект в области предварительного просмотра
- **Управление версиями:** поддержка истории документа
- **Шифрование:** файлы, заканчивающиеся на `.c.md`, обрабатываются как зашифрованные
- **Автосохранение:** автоматическое сохранение файлов после редактирования с напоминанием в строке заголовка для несохраненных файлов (зашифрованные документы не сохраняются автоматически)
- **Редактирование:** автоматическое заполнение списка
- **Вставка изображений:** вы можете быстро вставлять изображения из буфера обмена и вставлять их как файлы или Base64
- **Вложения:** вы можете добавлять вложения в документ и открывать их в операционной системе щелчком мыши
- **Выполнение кода:** поддержка запуска JavaScript, PHP, nodejs, Python, кода bash
- **Список задач:** поддержка отображения хода выполнения задач в документе. Щелкните, чтобы быстро переключить статус задачи
- **Быстрое открытие:** вы можете использовать сочетание клавиш для открытия панели переключения файлов, чтобы быстро открывать файлы, помеченные файлы и выполнять полнотекстовый поиск по содержимому файлов
- **Интегрированный терминал:** поддержка открытия терминала в редакторе для быстрого переключения текущего рабочего каталога
- **Katex:** поддержка выражений katex
- **Стили:** Markdown использует стили и функции GitHub
- **Репозиторий:** можно определить несколько расположений данных для организации документов
- **Преобразование внешних ссылок:** преобразование внешних ссылок или изображений Base64 в локальные изображения
- **Разрешение HTML:** вы можете использовать HTML-код непосредственно в документе или использовать сочетания клавиш для копирования и вставки HTML в Markdown
- **Экспорт в несколько форматов:** backend использует pandoc в качестве конвертера
- **TOC:** напишите `[toc]{type:** "ol", level:** [1,2,3]}` для генерации TOC (Table Of Content, оглавление), где вам нужно сгенерировать его
- **Изменить ячейку таблицы:** дважды щелкните ячейку таблицы для быстрого редактирования
- **Копирование ссылки на заголовок:** копирование пути ссылки на заголовок в буфер обмена для легкой вставки в другие файлы
- **Встроенные апплеты:** документ поддерживает встроенные HTML-аплеты
- **Встроенная графика PlantUML:** документ поддерживает встроенную графику plantUML
- **Встроенная графика drawio:** документ поддерживает встроенную графику drawio
- **Встроенная графика ECharts:** документ поддерживает встроенную графику Echarts
- **Встроенная графика Mermaid:** документ поддерживает встроенную графику Mermaid
- **Встроенные таблицы Luckysheet:** документ поддерживает встроенные таблицы Luckysheet
- **Mind map:** вложенный список может быть отображен в виде интеллект-карты
- **Запись атрибутов элемента:** любой атрибут элемента может быть настроен
- **Улучшение таблиц:** поддержка заголовка таблицы с несколькими строками текста, списка и других функций
- **Ссылка на документ:** поддержка ссылок на другие документы в документе и перехода друг к другу
- **Сноска:** поддержка написания сносок в документе
- **Пользовательский контейнер:** поддержка пользовательских контейнеров, аналогичных VuePress по умолчанию темы
- **Макросы:** поддержка встроенных выражений JavaScript для динамической замены содержимого документа
- **Служба хостинга изображений:** поддержка службы хостинга изображений [PicGo](https://picgo.github.io/PicGo-Doc/)
- **OpenAI:** поддержка автодополнения [OpenAI](https://openai.com)
- **Пользовательские плагины:** поддержка написания плагинов JavaScript для расширения функциональности редактора. Плагин находится в `home directory/plugins`. См. [руководство по разработке плагинов](./help/PLUGIN.md)

## Скриншоты

![Screenshot](./help/6.png)
![Screenshot](./help/7.png)
![Screenshot](./help/2.png)
![Screenshot](./help/3.png)
![Screenshot](./help/4.png)
![Screenshot](./help/5.png)

## Поддержка

Wechat Group

<img src="./help/qrcode-wechat.jpg?.inline" width="150">
