## 系统设计与构架 - 中文版


### System Design in Practice

| Product | Question |
| ---      | ---      |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580708936/web-guiguio/instagram.png" width="52" />  | [Designing Instagram or Pinterest](2016-02-13-crack-the-system-design-interview.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580708917/web-guiguio/uber.png" width="52" />| [Designing Uber](120-designing-uber.md) | |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709369/web-guiguio/facebook.png" width="52" />| [How Facebook Scale its Social Graph Store? TAO](49-facebook-tao.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709414/web-guiguio/netflix.png" width="52" />| [How Netflix Serves Viewing Data?](45-how-to-design-netflix-view-state-service.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709444/web-guiguio/stripe.png" width="52" />| [How to design robust and predictable APIs with idempotency?](43-how-to-design-robust-and-predictable-apis-with-idempotency.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709414/web-guiguio/netflix.png" width="52" />| [How to stream video over HTTP for mobile devices? HTTP Live Streaming (HLS)](38-how-to-stream-video-over-http.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709618/web-guiguio/confluent.png" width="52" />| [Designing a distributed logging system](61-what-is-apache-kafka.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709677/web-guiguio/twitter.png" width="52" />| [Designing a URL shortener](84-designing-a-url-shortener.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709990/web-guiguio/linkedin.png" width="52" />| [Designing a KV store with external storage](97-designing-a-kv-store-with-external-storage.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709823/web-guiguio/memcached.png" width="52" />| [Designing a distributed in-memory KV store or Memcached](174-designing-memcached.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709369/web-guiguio/facebook.png" width="52" />| [Designing Facebook photo storage](121-designing-facebook-photo-storage.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580710037/web-guiguio/robinhood.png" width="52" />| [Designing Stock Exchange](161-designing-stock-exchange.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580710037/web-guiguio/robinhood.png" width="52" />| [Designing Smart Notification of Stock Price Changes](162-designing-smart-notification-of-stock-price-changes.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580710085/web-guiguio/square.png" width="52" />| [Designing Square Cash or PayPal Money Transfer System](167-designing-paypal-money-transfer.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709444/web-guiguio/stripe.png" width="52" />| [Designing payment webhook](166-designing-payment-webhook.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580710137/web-guiguio/grafana.jpg" width="52" />| [Designing a metric system](168-designing-a-metric-system.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580710354/web-guiguio/tiktok.webp" width="52" />| [Designing a recommendation system](140-designing-a-recommendation-system.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580710222/web-guiguio/airbnb.png" width="52" />| [Designing Airbnb or a hotel booking system](177-designing-Airbnb-or-a-hotel-booking-system.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580710390/web-guiguio/lyft.png" width="52" />| [Lyft's Marketing Automation Platform -- Symphony](178-lyft-marketing-automation-symphony.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580709990/web-guiguio/linkedin.png" width="52" />| [Designing typeahead search or autocomplete](179-designing-typeahead-search-or-autocomplete.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580710529/web-guiguio/nginx.jpg" width="52" />| [Designing a Load Balancer or Dropbox Bandaid](182-designing-l7-load-balancer.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1580708917/web-guiguio/uber.png" width="52" />| [Fraud Detection with Semi-supervised Learning](136-fraud-detection-with-semi-supervised-learning.md) |
| <img src="https://res.cloudinary.com/dohtidfqh/image/upload/v1595029150/web-guiguio/favicon-32x32.png" width="52" />| [Designing Online Judge or Leetcode](https://tianpan.co/notes/243-designing-online-judge-or-leetcode) |

### System Design Theories

* [Introduction to Architecture](145-introduction-to-architecture.md)
* [How to scale a web service?](41-how-to-scale-a-web-service.md)
* [ACID vs BASE](2018-07-26-acid-vs-base.md)
* [Data Partition and Routing](2018-07-21-data-partition-and-routing.md)
* [Replica, Consistency, and CAP theorem](2018-07-24-replica-and-consistency.md)
* [Load Balancer Types](2018-07-23-load-balancer-types.md)
* [Concurrency Model](181-concurrency-models.md)
* [Improving availability with failover](85-improving-availability-with-failover.md)
* [Bloom Filter](68-bloom-filter.md)
* [Skiplist](69-skiplist.md)
* [B tree vs. B+ tree](2018-07-22-b-tree-vs-b-plus-tree.md)
* [Intro to Relational Database](80-relational-database.md)
* [4 Kinds of No-SQL](78-four-kinds-of-no-sql.md)
* [Key value cache](122-key-value-cache.md)
* [Stream and Batch Processing Frameworks](137-stream-and-batch-processing.md)
* [Cloud Design Patterns](2018-07-10-cloud-design-patterns.md)
* [Public API Choices](66-public-api-choices.md)
* [Lambda Architecture](83-lambda-architecture.md)
* [iOS Architecture Patterns Revisited](123-ios-architecture-patterns-revisited.md)
* [What can we communicate in soft skills interview?](63-soft-skills-interview.md)
* [Experience Deep Dive](2018-07-20-experience-deep-dive.md)
* [3 Programming Paradigms](11-three-programming-paradigms.md)
* [SOLID Design Principles](12-solid-design-principles.md)
