---
slug: 12-solid-design-principles
id: 12-solid-design-principles
title: "SOLID 设计原则"
date: 2018-08-13 18:07
comments: true
tags: [系统设计]
description: SOLID 是一组设计原则的首字母缩写，帮助软件工程师编写稳健的代码。S 代表单一职责原则，O 代表开放/封闭原则，L 代表里氏替换原则，I 代表接口隔离原则，D 代表依赖倒置原则。
references:
  - https://www.amazon.com/Clean-Architecture-Craftsmans-Software-Structure/dp/0134494164
---

SOLID 是一组设计原则的首字母缩写，帮助软件工程师在项目中编写稳健的代码。

1. S - **单一职责原则**。一个模块应该只对一个角色负责，一个模块只是一个功能和数据结构的内聚集合。

2. O - **开放/封闭原则**。软件工件应该对扩展开放，但对修改封闭。

3. L - **里氏替换原则**。通过接口和实现、泛型、子类化和鸭子类型来简化代码的继承。

4. I - **接口隔离原则**。将单一的庞大接口分割成更小的接口，以解耦模块。

5. D - **依赖倒置原则**。源代码的依赖关系与控制流相反。我们架构图中最明显的组织原则。
      1. 事物应该是稳定的具体，或者是过时的抽象，而不是 ==具体和不稳定==。
      2. 因此使用 ==抽象工厂== 来创建不稳定的具体对象（管理不希望的依赖关系）。产生接口的接口
      3. DIP 违规无法完全消除。大多数系统至少会包含一个这样的具体组件——这个组件通常被称为主组件。