---
slug: 11-three-programming-paradigms
id: 11-three-programming-paradigms
title: "三种编程范式"
date: 2018-08-12 02:31
comments: true
tags: [系统设计]
description: "结构化编程是一种对直接控制转移的约束。面向对象编程是一种对间接控制转移的约束。函数式编程是一种对变量赋值的约束。"
references:
  - https://www.amazon.com/Clean-Architecture-Craftsmans-Software-Structure/dp/0134494164
---

结构化编程 vs. 面向对象编程 vs. 函数式编程



1. 结构化编程是一种对直接控制转移的约束。
	1. 可测试性：软件就像科学：科学不是通过证明陈述为真来工作的，而是通过证明陈述为假来工作的。结构化编程迫使我们递归地将程序分解为一组小的可证明函数。



2. 面向对象编程是一种对间接控制转移的约束。
	1. 封装、继承、多态（指向函数的指针）并不是面向对象特有的。
	2. 但面向对象使多态的使用变得安全和方便。然后启用强大的==插件架构==与依赖反转
		1. 源代码依赖关系和控制流通常是相同的。然而，如果我们让它们都依赖于接口，依赖关系就会反转。
		2. 接口赋予独立部署的能力。例如，在部署Solidity智能合约时，导入和使用接口消耗的气体远远少于对整个实现进行操作。



3. 函数式编程：不可变性。是一种对变量赋值的约束。
	1. 为什么重要？所有的竞争条件、死锁条件和并发更新问题都是由于可变变量造成的。
	2. ==事件溯源==是一种策略，我们存储事务，而不是状态。当需要状态时，我们只需从时间的开始应用所有事务。