---
layout: post
title: "FinTech System Design"
date: 2021-05-21 16:40
comments: true
categories: System Design
language: en
abstract: abstract
references:
  - references
---

@[toc]

We will go through a series of building blocks of modern financial systems.

* Centralized Finance
  * Deposit Account
    * ACH
    * Wire
    * Check
  * Credit Card
    * PCI DSS
  * Electronic Payment Methods
    * NFC
    * QR Codes (https://www.w3.org/Payments/WG/)
      * https://www.w3.org/2020/10/21-wpwg-minutes.html#emvco
      * EMVCo QR code specifications and use cases https://www.w3.org/2020/Talks/emvco-qr-20201021.pdf
      * China Union Pay QR code use cases http://www.w3.org/2020/Talks/unionpay-qr-20201021.pptx
    * Open Banking
    * Web Monetization
    * Real-time Payments (RTP) and bill pay
    * Web https://www.w3.org/Payments/WG/
  * Digital Wallet
  * Loan
  * Fraud & Risk
  * Stock Exchange
  * Bookkeeping
  * Security & Compliance
* Decentralized Finance
  * Blockchain
  * Smart Contract
  * DApp
  * Digital Wallet
  * Cross-chain
  * Decentralized crypto exchanges
* Case study
  * Chinese DC/EP
  * Facebook Novi and Intermittence
  * Stripe and Aggregators
  * Plaid
  * Fact.co One-click
  * Transaction Fee and Bargaining Power
  * Apple Pay
    * https://whimsical.com/apple-pay-SZBkbYi4YvzpiTLgJPPRSt


# Centralized Finance

# Decentralized Finance

# Case Study

## Apple Pay

### Customer's Perspective

Goal

* faster and easier than cards and cash
* retailing-first
* privacy and security by design



### Developer's Perspective
