# Summary

* [Introduction](README.md)

### System Design in Practice

* [Design Pinterest](./en/2016-02-13-crack-the-system-design-interview.md)
* [Design Uber](./en/120-designing-uber.md)
* [Design Facebook Social Graph Store](./en/49-facebook-tao.md)
* [Design Netflix Viewing Data](./en/45-how-to-design-netflix-view-state-service.md)
* [Design idempotent APIs](./en/43-how-to-design-robust-and-predictable-apis-with-idempotency.md)
* [Design video streaming over HTTP](./en/38-how-to-stream-video-over-http.md)
* [What is Apache Kafka?](./en/61-what-is-apache-kafka.md)
* [Design a URL shortener](./en/84-designing-a-url-shortener.md)
* [Design a KV store with external storage](./en/97-designing-a-kv-store-with-external-storage.md)
* [Design a distributed in-memory KV store or Memcached](./en/174-designing-memcached.md)
* [Design Facebook photo storage](./en/121-designing-facebook-photo-storage.md)
* [Design Stock Exchange](./en/161-designing-stock-exchange.md)
* [Design Smart Notification of Stock Price Changes](./en/162-designing-smart-notification-of-stock-price-changes.md)
* [Design Square Cash or PayPal Money Transfer System](./en/167-designing-paypal-money-transfer.md)
* [Design payment webhook](./en/166-designing-payment-webhook.md)
* [Design a metric system](./en/168-designing-a-metric-system.md)
* [Design a recommendation system](./en/140-designing-a-recommendation-system.md)
* [Design Airbnb or a hotel booking system](./en/177-designing-Airbnb-or-a-hotel-booking-system.md)
* [Lyft's Marketing Automation Platform -- Symphony](./en/178-lyft-marketing-automation-symphony.md)
* [Design typeahead search or autocomplete](./en/179-designing-typeahead-search-or-autocomplete.md)
* [Design a Load Balancer or Dropbox Bandaid](./en/182-designing-l7-load-balancer.md)
* [Fraud Detection with Semi-supervised Learning](./en/136-fraud-detection-with-semi-supervised-learning.md)
* [Credit Card Processing System](./en/236-credit-card-processing-system.md)
* [Design Online Judge or Leetcode](./en/243-designing-online-judge-or-leetcode.md)
* [AuthN and AuthZ](./en/253-authn-authz-micro-services.md)
* [AuthZ 2022](./en/277-enterprise-authorization-2022.md)


## System Design Theories

* [Introduction to Architecture](./en/145-introduction-to-architecture.md)
* [How to scale a web service?](./en/41-how-to-scale-a-web-service.md)
* [ACID vs BASE](./en/2018-07-26-acid-vs-base.md)
* [Data Partition and Routing](./en/2018-07-21-data-partition-and-routing.md)
* [Replica, Consistency, and CAP theorem](./en/2018-07-24-replica-and-consistency.md)
* [Load Balancer Types](./en/2018-07-23-load-balancer-types.md)
* [Concurrency Model](./en/181-concurrency-models.md)
* [Improving availability with failover](./en/85-improving-availability-with-failover.md)
* [Bloom Filter](./en/68-bloom-filter.md)
* [Skiplist](./en/69-skiplist.md)
* [B tree vs. B+ tree](./en/2018-07-22-b-tree-vs-b-plus-tree.md)
* [Intro to Relational Database](./en/80-relational-database.md)
* [4 Kinds of No-SQL](./en/78-four-kinds-of-no-sql.md)
* [Key value cache](./en/122-key-value-cache.md)
* [Stream and Batch Processing Frameworks](./en/137-stream-and-batch-processing.md)
* [Cloud Design Patterns](./en/2018-07-10-cloud-design-patterns.md)
* [Public API Choices](./en/66-public-api-choices.md)
* [Lambda Architecture](./en/83-lambda-architecture.md)
* [iOS Architecture Patterns Revisited](./en/123-ios-architecture-patterns-revisited.md)
* [What can we communicate in soft skills interview?](./en/63-soft-skills-interview.md)
* [Experience Deep Dive](./en/2018-07-20-experience-deep-dive.md)
* [3 Programming Paradigms](./en/11-three-programming-paradigms.md)
* [SOLID Design Principles](./en/12-solid-design-principles.md)

## Effective Interview Prep

* Introduction to software engineer interview
* How to crack the coding interview, for real?
* How to communicate in the interview?
* Experience deep dive
* Culture fit
* Be a software engineer - a hero's journey
