# Welcome to the Prompt Studio documentation!

## What can I use Prompt Studio for?
Think of those tasks that you have to do everyday at work, they're a vital part of your job, yet so repetitive and time-consuming. Maybe you even tried ChatGPT to automate parts of it and you're starting to notice just how handy AI can be. If so, you're in the right place! With Prompt Studio, you can craft your unique AI-driven solution, all in natural language and in just text!  You meticulously design your [Recipe](concepts/recipe.md) once, embedding all the nuances of your business use case by combining [instructions](concepts/instructions.md) and Voilà! You have your own "app"! Do you want to share it with your colleagues? Click on [preview](concepts/preview.md) and generate a shareable UI which is a web application based on the logic you build in your recipe! This isn't just any application; it's your personalized tool, born from your specific needs and understanding of your daily challenges. Sharing the preview with your team is as simple as sending a link.
It gets even better! What if your team wants this AI solution to be part of a customer facing application that your company? Just click on "API" and let us do the work for you, within literally seconds, your AI solution is available through our API for the engineers in your team to integrate with the codebase of your company!



## Overview of functionalities in Prompt Studio

In Prompt Studio, you can start by creating your first [**recipe**](concepts/recipe.md) which would be a collection of AI instructions.

- Does your AI solution involve multiple steps? Chain your AI [**instructions**](concepts/instructions.md#chained-instructions-in-a-recipe) by simply referring with `/` to the output of the previous instruction. 

- Do you need to enrich the AI instruction with contextual data from [**files**](concepts/file.md)? Type "/", define your context name and upload your file. This will include the content of the file within the instruction and give more context to guide the LLM for better output.

- Do you want to share your AI solution with your colleagues or customers? Simply click on [**preview**](concepts/preview.md) to generate a user interface that you can share with your colleagues. 

- Does your engineering team need to integrate this AI solution with an application or your internal systems? Click on "API" and deploy your solution. This makes it available through Prompt Studio's API.

- We know that testing your AI instructions is an integral part of AI development, that's why we have the [**scenarios**](concepts/scenarios.md) page, where you can run your instructions across a large batch of inputs to test how your recipe performs in different scenarios.

You can find a summary of our features [here](concepts/features.md)


