---
slug: roadmap
title: Prompt Studio Roadmap
authors: [aure]
tags: [Prompt Studio, roadmap, update]
---

Over the past weeks, we have met with many of you and learned a lot about the problems you encounter when working with language models. All this helps guide us towards what Prompt Studio needs to become and what features we should provide to best help you in your daily tasks.

For most people, working with language models is a new thing and a lot of the workflows that involve language models are lacking from a useability point of view. Tedious copy pasting between different tools and manually iterating over prompts is far from what we imagine the AI powered future to be.

LLMs are incredibly powerful tools that are now at our disposal and can help us become more efficient but the user experience hasn't caught up with it yet.

This is why we are building Prompt Studio, **a collaborative prompt engineering platform for teams that work with LLMs**. We want to provide you with features that can help you interact, test and build tools to automate text generation for your specific use case.

## Our Roadmap

With new feature requests appearing every day, we now need to organize our roadmap accordingly. We are making it public so you know what we are working on and when we will implement the features you need.

You can [find our roadmap on github](https://github.com/orgs/pufflyai/projects/8/views/1). And as always, you are welcome to [make feature requests](https://github.com/pufflyai/prompt-studio-docs/discussions) and [get in touch](https://discord.gg/gJYXdW7s) on discord.

![roadmap](./roadmap.png)

## Our current tasks

These are the tasks at the top of our backlog. These are foundational changes that take some time to implement but are important things to get right from the start.

1. **Collaborative workspaces** work with your team, share your prompts, invite team members and manage roles. Most work nowadays is collaborative, prompt engineering is no different.
2. **Prompt Studio on Premise** keeping your company data on your own cloud was a common request. By making Prompt Studio cloud agnostic we are also one step closer to our vision of what an open source version of Prompt Studio should be.

Thank you for using Prompt Studio, and stay tuned for future updates!
