# PubNub Team Chat

[![Build Status](https://travis-ci.com/pubnub/typescript-ref-app-team-chat.svg?branch=master)](https://travis-ci.com/pubnub/typescript-ref-app-team-chat)

The team chat app demonstrates how to build a feature-rich chat and team collaboration application using [PubNub Chat](https://www.pubnub.com/docs/chat/quickstart). Learn how to manage users, join chat rooms, and send messages with PubNub. Learn how to build advanced features like profanity filtering, gifs, and link previews. You can download the project to run on your local machine, and explore the code to see how we built it.

Check out the [Team Chat Tutorial](https://pubnub.github.io/typescript-ref-app-team-chat/docs/introduction).

![alt text](team-chat-preview.png "Reference App")

The application demonstrates how to build a chat application using:

- PubNub
- TypeScript
- React
- Redux

## Requirements

- [Node.js](https://nodejs.org/en/)
- [PubNub Account](https://dashboard.pubnub.com/)

## Running the project

1. Clone the GitHub repository.

    ```bash
    git clone https://github.com/pubnub/typescript-ref-app-team-chat.git
    ```

1. Install the project.

    ```bash
    cd typescript-ref-app-team-chat
    npm install
    ```

1. Start the project. You'll be asked to enter your chat app keys from the [PubNub Dashboard](https://dashboard.pubnub.com/). Note that Objects should be enabled and a region should be selected on the key.

    ```bash
    npm start
    ```

    A web browser should automatically open [http://localhost:3000](http://localhost:3000), and you can explore your very own Team Chat app!

## Further Information

For more information, head over to [Team Chat Tutorial](https://pubnub.github.io/typescript-ref-app-team-chat/docs/introduction) and get started building chat today.

This project was bootstrapped with [Create React App](https://github.com/facebook/create-react-app). Special thanks to Martin Lagrange, Elvis Wolcott, and Mark Erikson.
