---
name: Issue
about: Report an issue
title: ""
labels:
assignees: ''

---
<!--
INSTRUCTIONS
============

Please read these instructions before submitting your issue.

If this is the first time you interact on this project, welcome to the community!
In this case, please give a bit of information on how you are using Hello ImGui (in which project, how long you have been using it, etc.).

Please check existing issues and discussions for similar reports before submitting a new one.


Describe the issue
------------------
Provide a clear and concise description of what the issue is. Include logs or code snippets if necessary. Also, please make sure that your issue's title reflects this concise description.


Version & Platform
------------------
Mention
- the version of Hello ImGui you are using (e.g., a version number or commit hash and/or date).
- the platform you are using (e.g., Windows 10, Linux, Mac, iOS, Android, emscripten).
- the language you are using: Python or C++: [e.g., Python 3.8, C++ 17]

If relevant, also include:
- Compiler (if applicable): [e.g., GCC 10.2, MSVC 2019]
- platform backend, e.g., SDL2, GLFW
- rendering backend, e.g., OpenGL, Vulkan, DirectX, Metal



Minimal reproducible example
----------------------------
Please, please do try to provide a minimal reproducible example that reproduces the issue, either in C++ or Python.
See:
    https://stackoverflow.com/help/minimal-reproducible-example

For C++, use a code block like this:
```cpp
// Your code here... (a compilable example, including the main function)
```

For Python, use a code block like this:
```python
# Your code here... (a runnable example)
```

Remove these instructions (between `<! --` and `-->`) once you have read them.

-->
