export const EASING = {
  LINEAR  : 'linear',
  EASE    : 'ease',
  EASE_IN: 'ease-in',
  EASE_OUT: 'ease-out',
  EASE_IN_OUT: 'ease-in-out',
  EASE_IN_CUBIC: 'ease-in-cubic',
  EASE_OUT_CUBIC: 'ease-out-cubic',
  EASE_IN_OUT_CUBIC: 'ease-in-out-cubic',
  EASE_IN_CIRC: 'ease-in-circ',
  EASE_OUT_CIRC: 'ease-out-circ',
  EASE_IN_OUT_CIRC: 'ease-in-out-circ',
  EASE_IN_EXPO: 'ease-in-expo',
  EASE_OUT_EXPO: 'ease-out-expo',
  EASE_IN_OUT_EXPO: 'ease-in-out-expo',
  EASE_IN_QUAD: 'ease-in-quad',
  EASE_OUT_QUAD: 'ease-out-quad',
  EASE_IN_OUT_QUAD: 'ease-in-out-quad',
  EASE_IN_QUART: 'ease-in-quart',
  EASE_OUT_QUART: 'ease-out-quart',
  EASE_IN_OUT_QUART: 'ease-in-out-quart',
  EASE_IN_QUINT: 'ease-in-quint',
  EASE_OUT_QUINT: 'ease-out-quint',
  EASE_IN_OUT_QUINT: 'ease-in-out-quint',
  EASE_IN_SINE: 'ease-in-sine',
  EASE_OUT_SINE: 'ease-out-sine',
  EASE_IN_OUT_SINE: 'ease-in-out-sine',
  EASE_IN_BACK: 'ease-in-back',
  EASE_OUT_BACK: 'ease-out-back',
  EASE_IN_OUT_BACK: 'ease-in-out-back'
} as const;

export const EASING_FUNCTIONS = {
  [EASING.LINEAR]: 'linear',
  [EASING.EASE]: 'cubic-bezier(0.25, 0.1, 0.25, 1)',
  [EASING.EASE_IN]: 'cubic-bezier(0.42, 0, 1, 1)',
  [EASING.EASE_OUT]: 'cubic-bezier(0, 0, 0.58, 1)',
  [EASING.EASE_IN_OUT]: 'cubic-bezier(0.42, 0, 0.58, 1)',
  [EASING.EASE_IN_CUBIC]: 'cubic-bezier(0.55, 0.055, 0.675, 0.19)',
  [EASING.EASE_OUT_CUBIC]: 'cubic-bezier(0.215, 0.61, 0.355, 1.0)',
  [EASING.EASE_IN_OUT_CUBIC]: 'cubic-bezier(0.645, 0.045, 0.355, 1.0)',
  [EASING.EASE_IN_CIRC]: 'cubic-bezier(0.6, 0.04, 0.98, 0.335)',
  [EASING.EASE_OUT_CIRC]: 'cubic-bezier(0.075, 0.82, 0.165, 1.0)',
  [EASING.EASE_IN_OUT_CIRC]: 'cubic-bezier(0.785, 0.135, 0.15, 0.86)',
  [EASING.EASE_IN_EXPO]: 'cubic-bezier(0.95, 0.05, 0.795, 0.035)',
  [EASING.EASE_OUT_EXPO]: 'cubic-bezier(0.19, 1.0, 0.22, 1.0)',
  [EASING.EASE_IN_OUT_EXPO]: 'cubic-bezier(1.0, 0.0, 0.0, 1.0)',
  [EASING.EASE_IN_QUAD]: 'cubic-bezier(0.55, 0.085, 0.68, 0.53)',
  [EASING.EASE_OUT_QUAD]: 'cubic-bezier(0.25, 0.46, 0.45, 0.94)',
  [EASING.EASE_IN_OUT_QUAD]: 'cubic-bezier(0.455, 0.03, 0.515, 0.955)',
  [EASING.EASE_IN_QUART]: 'cubic-bezier(0.895, 0.03, 0.685, 0.22)',
  [EASING.EASE_OUT_QUART]: 'cubic-bezier(0.165, 0.84, 0.44, 1.0)',
  [EASING.EASE_IN_OUT_QUART]: 'cubic-bezier(0.77, 0.0, 0.175, 1.0)',
  [EASING.EASE_IN_QUINT]: 'cubic-bezier(0.755, 0.05, 0.855, 0.06)',
  [EASING.EASE_OUT_QUINT]: 'cubic-bezier(0.23, 1.0, 0.32, 1.0)',
  [EASING.EASE_IN_OUT_QUINT]: 'cubic-bezier(0.86, 0.0, 0.07, 1.0)',
  [EASING.EASE_IN_SINE]: 'cubic-bezier(0.47, 0.0, 0.745, 0.715)',
  [EASING.EASE_OUT_SINE]: 'cubic-bezier(0.39, 0.575, 0.565, 1.0)',
  [EASING.EASE_IN_OUT_SINE]: 'cubic-bezier(0.445, 0.05, 0.55, 0.95)',
  [EASING.EASE_IN_BACK]: 'cubic-bezier(0.6, -0.28, 0.735, 0.045)',
  [EASING.EASE_OUT_BACK]: 'cubic-bezier(0.175, 0.885, 0.32, 1.275)',
  [EASING.EASE_IN_OUT_BACK]: 'cubic-bezier(0.68, -0.55, 0.265, 1.55)'
};

export type EasingType = typeof EASING[keyof typeof EASING];