import React from 'react';
import { useTheme } from 'styled-components';

const SunIcon: React.FC = () => {
  const theme = useTheme();
  return (
    <svg
      width="14"
      height="14"
      viewBox="0 0 14 14"
      fill={theme.icons.sunIcon}
      xmlns="http://www.w3.org/2000/svg"
    >
      <path
        d="M11.4545 7C11.4545 9.46018 9.46018 11.4545 7 11.4545C4.53982 11.4545 2.54545 9.46018 2.54545 7C2.54545 4.53982 4.53982 2.54545 7 2.54545C9.46018 2.54545 11.4545 4.53982 11.4545 7Z"
        fill={theme.icons.sunIcon}
      />
      <path
        d="M7.63636 0.636364C7.63636 0.987818 7.35145 1.27273 7 1.27273C6.64855 1.27273 6.36364 0.987818 6.36364 0.636364C6.36364 0.28491 6.64855 0 7 0C7.35145 0 7.63636 0.28491 7.63636 0.636364Z"
        fill={theme.icons.sunIcon}
      />
      <path
        d="M7.63636 13.3636C7.63636 13.7151 7.35145 14 7 14C6.64855 14 6.36364 13.7151 6.36364 13.3636C6.36364 13.0122 6.64855 12.7273 7 12.7273C7.35145 12.7273 7.63636 13.0122 7.63636 13.3636Z"
        fill={theme.icons.sunIcon}
      />
      <path
        d="M13.3636 7.63636C13.0122 7.63636 12.7273 7.35145 12.7273 7C12.7273 6.64855 13.0122 6.36364 13.3636 6.36364C13.7151 6.36364 14 6.64855 14 7C14 7.35145 13.7151 7.63636 13.3636 7.63636Z"
        fill={theme.icons.sunIcon}
      />
      <path
        d="M0.636364 7.63636C0.28491 7.63636 -1.53625e-08 7.35145 0 7C1.53625e-08 6.64855 0.28491 6.36364 0.636364 6.36364C0.987818 6.36364 1.27273 6.64855 1.27273 7C1.27273 7.35145 0.987818 7.63636 0.636364 7.63636Z"
        fill={theme.icons.sunIcon}
      />
      <path
        d="M11.9497 2.95018C11.7012 3.19869 11.2983 3.19869 11.0498 2.95018C10.8013 2.70166 10.8013 2.29874 11.0498 2.05022C11.2983 1.80171 11.7012 1.80171 11.9497 2.05022C12.1983 2.29874 12.1983 2.70166 11.9497 2.95018Z"
        fill={theme.icons.sunIcon}
      />
      <path
        d="M2.95021 11.9497C2.70169 12.1982 2.29877 12.1982 2.05025 11.9497C1.80174 11.7012 1.80174 11.2983 2.05025 11.0498C2.29877 10.8012 2.70169 10.8012 2.95021 11.0498C3.19872 11.2983 3.19872 11.7012 2.95021 11.9497Z"
        fill={theme.icons.sunIcon}
      />
      <path
        d="M11.0498 11.9497C10.8013 11.7012 10.8013 11.2983 11.0498 11.0498C11.2983 10.8012 11.7012 10.8012 11.9497 11.0498C12.1983 11.2983 12.1983 11.7012 11.9497 11.9497C11.7012 12.1982 11.2983 12.1982 11.0498 11.9497Z"
        fill={theme.icons.sunIcon}
      />
      <path
        d="M2.05025 2.95018C1.80174 2.70166 1.80174 2.29874 2.05025 2.05022C2.29877 1.80171 2.70169 1.80171 2.95021 2.05022C3.19872 2.29874 3.19872 2.70166 2.95021 2.95018C2.70169 3.19869 2.29877 3.19869 2.05025 2.95018Z"
        fill={theme.icons.sunIcon}
      />
    </svg>
  );
};

export default SunIcon;
