// Copyright 2024 The Prometheus Authors
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

//go:build windows

package flag

import (
	"github.com/alecthomas/kingpin/v2"
	"github.com/prometheus-community/windows_exporter/internal/log"
	"github.com/prometheus/common/promslog"
	"github.com/prometheus/common/promslog/flag"
)

// FileFlagName is the canonical flag name to configure the log file.
const FileFlagName = "log.file"

// FileFlagHelp is the help description for the log.file flag.
const FileFlagHelp = "Output file of log messages. One of [stdout, stderr, eventlog, <path to log file>]"

// AddFlags adds the flags used by this package to the Kingpin application.
// To use the default Kingpin application, call AddFlags(kingpin.CommandLine).
func AddFlags(a *kingpin.Application, config *log.Config) {
	config.Config = new(promslog.Config)
	flag.AddFlags(a, config.Config)

	if config.File == nil {
		config.File = &log.AllowedFile{}
	}

	a.Flag(FileFlagName, FileFlagHelp).Default(config.File.String()).SetValue(config.File)
}
