using Microsoft.AspNetCore.Builder;
using Microsoft.AspNetCore.Hosting;
using Microsoft.AspNetCore.Http;
using Microsoft.Extensions.Configuration;
using Microsoft.Extensions.DependencyInjection;
using Microsoft.Extensions.DependencyInjection.Extensions;
using Microsoft.Extensions.Hosting;
using ProgeSoftware.AspNetCore.Authentication.Static;
using System.Security.Claims;

namespace MvcSample
{
    public class Startup
    {
        public Startup(IConfiguration configuration)
        {
            Configuration = configuration;
        }

        public IConfiguration Configuration { get; }

        public void ConfigureServices(IServiceCollection services)
        {
            services
                .AddAuthentication(StaticAuthenticationDefaults.AuthenticationScheme)
                .AddStatic(options =>
                {
                    Configuration.GetSection("StaticAuthentication").Bind(options);
                });

            services
                .AddAuthorization(options =>
                {
                    options.AddPolicy(Permissions.IsAdmin, policy =>
                    {
                        policy.RequireClaim(ClaimTypes.Role, "Admin");
                    });
                    options.AddPolicy(Permissions.IsUser, policy =>
                    {
                        policy.RequireClaim(ClaimTypes.Role, "User");
                    });
                    options.AddPolicy(Permissions.IsAdminOrUser, policy =>
                    {
                        policy.RequireClaim(ClaimTypes.Role, "Admin", "User");
                    });
                });

            services
                .AddControllersWithViews();

            services
                .TryAddSingleton<IHttpContextAccessor, HttpContextAccessor>();
        }

        // This method gets called by the runtime. Use this method to configure the HTTP request pipeline.
        public void Configure(IApplicationBuilder app, IWebHostEnvironment env)
        {
            if (env.IsDevelopment())
            {
                app.UseDeveloperExceptionPage();
            }
            else
            {
                app.UseExceptionHandler("/Home/Error");
                app.UseHsts();
            }
            app.UseHttpsRedirection();
            app.UseStaticFiles();
            app.UseAuthentication();
            app.UseRouting();
            app.UseAuthorization();
            app.UseEndpoints(endpoints =>
            {
                endpoints.MapControllerRoute(
                    name: "default",
                    pattern: "{controller=Home}/{action=Index}/{id?}");
            });
        }
    }
}
