# Useful tutorials on software for ML

See https://software-carpentry.org/ for many useful tutorials.
We list a few more specific tutorials below, 
with a bias towards ones that focus on ML/ datascience. 

## Python

Below we list some excellent tutorials on Python.

|Link|Notes|
|-|----|
|[Dive into Python 3](https://www.diveinto.org/python3/table-of-contents.html)| Excellent free book by Mark Pilgrim|
|[Fluent Python: Clear, Concise, and Effective Programming](https://www.amazon.com/Fluent-Python-Concise-Effective-Programming/dp/1491946008)| Book by Luciano Ramalho|
[Whirlwind tour of Python](https://github.com/jakevdp/WhirlwindTourOfPython)  |by Jake Vanderplas|
|[Python Datascience Handbook](https://github.com/jakevdp/PythonDataScienceHandbook)| Excellent free book by Jake Vanderplas|
|[Datascience from scrtach](https://www.oreilly.com/library/view/data-science-from/9781492041122/)| Minimalistic Python implementations of standard ML methods |
|[Duke's BIOS821 course](http://people.duke.edu/~ccc14/bios-821-2017/index.html)| Intro to data analysis with Python |
|[Duke's STA663 course](http://people.duke.edu/~ccc14/sta-663-2019/)| Intro to statistical computing with Python |
|http://scipy-lectures.org/| Scipy tutorials |
|[Book on matplotlib](https://github.com/rougier/scientific-visualization-book) | Data visualization with Python |
|[JAX](https://github.com/google/jax)| Accelerated numpy plus autograd | 

## Code editors

In datascience / ML, it is common to use  <a href="https://jupyter.org/">Jupyter notebooks</a>
 or [Google colab](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/colab_intro.ipynb)
which mix code and results.
When developing larger software projects, it is often better to use an 
 IDE (interactive development environment),
 which keeps the code separate from the results.
 There are many IDEs, such as 
 <a href="https://github.com/jupyterlab/jupyterlab">JupyterLab</a>,
<a href="https://www.spyder-ide.org">Spyder</a>,
<a href="https://www.jetbrains.com/pycharm/">PyCharm</a>,
or <a href="https://code.visualstudio.com/">VS code</a>.
(The latter lets you edit locally on your laptop but run your code on a remote virtual machine,
such as <a href="https://github.com/probml/probml-notebooks/blob/main/markdown/gcp_ssh_vscode.md">Cloud TPU VM</a>.)




