# Various tutorials related to  "Probabilistic Machine Learning"


## Notebooks, etc

|Title|Language|Link|
-|-|-
|Overview of Python ML/DL software ecosystem|Various|[software.md](https://github.com/probml/pyprobml/tree/master/notebooks/tutorials/software.md)
|List of Python tutorials|Various|[python_tutorials.md](https://github.com/probml/pyprobml/tree/master/notebooks/tutorials/python_tutorials.md)
|Colab intro|Colab|[colab_intro.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/colab_intro.ipynb)
|Google Cloud Storage from Colab|Colab|[GCS_demo_v2.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/GCS_demo_v2.ipynb)
|Git Large File System from Colab|Colab|[git_lfs_colab_demo.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/git_ldfs_colab_demo.ipynb)
|Pandas intro|Pandas, Xarray|[pandas_intro.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/pandas_intro.ipynb)
|JAX intro|Jax|[jax_intro.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/jax_intro.ipynb)
|JAX: practical tips|Jax|[practical_jax_tips.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/practical_jax_tips.ipynb)
|JAX: other tutorials|Jax|[jax_tutorials](https://github.com/probml/pyprobml/tree/master/notebooks/tutorials/jax_tutorials.md)
|Haiku tutorial|Haiku, JAX|[haiku_intro.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/haiku_intro.ipynb)
|Text preprocessing|Jax|[text_preproc_jax.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/text_preproc_jax.ipynb)
|Minibatching datasets|TFDS,PyTorch|[datasets.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/datasets.ipynb)
|TFDS intro|TFDS|[tfds_intro.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/tfds_intro.ipynb)
|Einsums|JAX|[einsums.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/einsums.ipynb)
|Graphviz in colab|Python|[graphviz_demo.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/graphviz_demo.ipynb)
|Numpyro intro|Numpyro, JAX|[numpyro_intro.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/numpyro_intro.ipynb)
|Pyro intro|Pyro|[pyro_intro.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/pyro_intro.ipynb)
|Sklearn intro|Sklearn|[sklearn_intro.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/sklearn_intro.ipynb)
|TPUs in colab|Python|[tpu_colab_tutorial.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/tpu_colab_tutorial.ipynb)
|SSH tunnels in colab|Python|[ssh_tunnels_and_how_to_dig_them.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/tutorials/ssh_tunnels_and_how_to_dig_them.ipynb)


## Books, blogs, etc

|Title|Language|Link|
-|-|-
|Intro to ML using Scikit learn|Python|[Online book](https://inria.github.io/scikit-learn-mooc/)

