
# Chapter 15: Neural networks for sequences

## Figures

|Figure No. | Notebook | Figure |
|--|--|--|
| 15.1 | - | [Figure_15.1.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.1.png)<br/> |
| 15.2 | [rnn_jax.ipynb](rnn_jax.ipynb) | - |
| 15.3 | - | [Figure_15.3.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.3.png)<br/> |
| 15.4 | - | [Figure_15.4_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.4_A.png)<br/>[Figure_15.4_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.4_B.png)<br/> |
| 15.5 | - | [Figure_15.5_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.5_A.png)<br/>[Figure_15.5_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.5_B.png)<br/> |
| 15.6 | - | [Figure_15.6.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.6.png)<br/> |
| 15.7 | - | [Figure_15.7.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.7.png)<br/> |
| 15.8 | - | [Figure_15.8_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.8_A.png)<br/>[Figure_15.8_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.8_B.png)<br/> |
| 15.9 | - | [Figure_15.9.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.9.png)<br/> |
| 15.10 | - | [Figure_15.10.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.10.png)<br/> |
| 15.11 | - | [Figure_15.11.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.11.png)<br/> |
| 15.12 | - | [Figure_15.12_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.12_B.png)<br/>[Figure_15.12_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.12_A.png)<br/> |
| 15.13 | - | [Figure_15.13.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.13.png)<br/> |
| 15.14 | - | [Figure_15.14.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.14.png)<br/> |
| 15.15 | - | [Figure_15.15.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.15.png)<br/> |
| 15.16 | - | [Figure_15.16.pdf](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.16.pdf)<br/> |
| 15.17 | [kernel_regression_attention.ipynb](kernel_regression_attention.ipynb) | [Figure_15.17_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.17_B.png)<br/>[Figure_15.17_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.17_A.png)<br/> |
| 15.18 | - | [Figure_15.18.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.18.png)<br/> |
| 15.19 | - | [Figure_15.19_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.19_A.png)<br/>[Figure_15.19_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.19_B.png)<br/> |
| 15.20 | - | [Figure_15.20.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.20.png)<br/> |
| 15.21 | - | [Figure_15.21.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.21.png)<br/> |
| 15.22 | - | [Figure_15.22_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.22_A.png)<br/>[Figure_15.22_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.22_B.png)<br/> |
| 15.23 | - | [Figure_15.23.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.23.png)<br/> |
| 15.24 | - | [Figure_15.24.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.24.png)<br/> |
| 15.25 | [positional_encoding_jax.ipynb](positional_encoding_jax.ipynb) | [Figure_15.25_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.25_A.png)<br/>[Figure_15.25_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.25_B.png)<br/> |
| 15.26 | - | [Figure_15.26.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.26.png)<br/> |
| 15.27 | - | [Figure_15.27.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.27.png)<br/> |
| 15.28 | - | [Figure_15.28.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.28.png)<br/> |
| 15.29 | - | [Figure_15.29.pdf](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.29.pdf)<br/> |
| 15.30 | - | [Figure_15.30.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.30.png)<br/> |
| 15.31 | - | [Figure_15.31.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.31.png)<br/> |
| 15.32 | - | [Figure_15.32.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.32.png)<br/> |
| 15.33 | - | [Figure_15.33_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.33_B.png)<br/>[Figure_15.33_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.33_A.png)<br/> |
| 15.34 | - | [Figure_15.34.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.34.png)<br/> |
| 15.35 | - | [Figure_15.35_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.35_B.png)<br/>[Figure_15.35_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.35_A.png)<br/>[Figure_15.35_D.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.35_D.png)<br/>[Figure_15.35_C.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.35_C.png)<br/> |
| 15.36 | - | [Figure_15.36.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_15.36.png)<br/> |

## Supplementary material

|Title|Software|Link|
-|-|-
|RNN for character level generation (D2L 8.5)|PyTorch|[rnn_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/rnn_torch.ipynb)
|GRUs (D2L 9.1)|PyTorch|[gru_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/gru_torch.ipynb)
|LSTMs (D2L 9.2)|PyTorch|[lstm_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/lstm_torch.ipynb)
|NMT using RNN (D2L 9.7)|PyTorch|[nmt_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/nmt_torch.ipynb)
|Attention (D2L 10.3)|PyTorch|[attention_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/attention_torch.ipynb)
|NMT with RNN and attention (D2L 10.4)|PyTorch|[nmt_attention_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/nmt_attention_torch.ipynb)
|NMT using transformers (D2L 10.7)|PyTorch|[transformers_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/transformers_torch.ipynb)
|BERT (D2L 14.8)|PyTorch|[bert_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/bert_torch.ipynb)
|RNN for sentiment classification (D2L 15.2)|PyTorch|[rnn_sentiment_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/rnn_sentiment_torch.ipynb)
|1d CNN for sentiment classification (D2L 15.3)|PyTorch|[cnn1d_sentiment_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/cnn1d_sentiment_torch.ipynb)
|Entailment classification using MLP with attention (D2L 15.5)|PyTorch|[entailment_attention_mlp_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/15/entailment_attention_mlp_torch.ipynb)
|RNN for sentiment classification|TF2|[External](https://www.tensorflow.org/tutorials/text/text_classification_rnn)
|RNN for character level generation|TF2|[External](https://www.tensorflow.org/tutorials/text/text_generation)
|RNN for time series forecasting|TF2|[External](https://www.tensorflow.org/tutorials/structured_data/time_series)
|RNN for image captioning|TF2|[External](https://www.tensorflow.org/tutorials/text/image_captioning)
|NMT using RNN with attention|TF2|[External](https://www.tensorflow.org/tutorials/text/nmt_with_attention)
|NMT using transformers|TF2|[External](https://www.tensorflow.org/tutorials/text/transformer)