
# Chapter 14: Neural networks for images

## Figures

|Figure No. | Notebook | Figure |
|--|--|--|
| 14.1 | - | [Figure_14.1.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.1.png)<br/> |
| 14.2 | - | [Figure_14.2.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.2.png)<br/> |
| 14.3 | - | - |
| 14.4 | - | [Figure_14.4.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.4.png)<br/> |
| 14.5 | [conv2d_jax.ipynb](conv2d_jax.ipynb) | [Figure_14.5.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.5.png)<br/> |
| 14.6 | - | [Figure_14.6.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.6.png)<br/> |
| 14.7 | - | [Figure_14.7.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.7.png)<br/> |
| 14.8 | - | [Figure_14.8_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.8_A.png)<br/>[Figure_14.8_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.8_B.png)<br/> |
| 14.9 | [conv2d_jax.ipynb](conv2d_jax.ipynb) | [Figure_14.9.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.9.png)<br/> |
| 14.10 | - | [Figure_14.10.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.10.png)<br/> |
| 14.11 | - | [Figure_14.11.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.11.png)<br/> |
| 14.12 | - | [Figure_14.12.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.12.png)<br/> |
| 14.13 | - | [Figure_14.13.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.13.png)<br/> |
| 14.14 | - | [Figure_14.14.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.14.png)<br/> |
| 14.15 | - | [Figure_14.15.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.15.png)<br/> |
| 14.16 | - | [Figure_14.16_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.16_B.png)<br/>[Figure_14.16_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.16_A.png)<br/> |
| 14.17 | [cnn_mnist_tf.ipynb](cnn_mnist_tf.ipynb) | [Figure_14.17_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.17_B.png)<br/>[Figure_14.17_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.17_A.png)<br/> |
| 14.18 | - | [Figure_14.18.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.18.png)<br/> |
| 14.19 | - | [Figure_14.19.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.19.png)<br/> |
| 14.20 | - | [Figure_14.20.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.20.png)<br/> |
| 14.21 | - | [Figure_14.21.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.21.png)<br/> |
| 14.22 | - | [Figure_14.22_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.22_B.png)<br/>[Figure_14.22_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.22_A.png)<br/> |
| 14.23 | - | [Figure_14.23.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.23.png)<br/> |
| 14.24 | - | [Figure_14.24.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.24.png)<br/> |
| 14.25 | - | [Figure_14.25.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.25.png)<br/> |
| 14.26 | - | [Figure_14.26.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.26.png)<br/> |
| 14.27 | - | [Figure_14.27_A.jpg](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.27_A.jpg)<br/>[Figure_14.27_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.27_B.png)<br/> |
| 14.28 | - | [Figure_14.28.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.28.png)<br/> |
| 14.29 | - | [Figure_14.29.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.29.png)<br/> |
| 14.30 | - | [Figure_14.30.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.30.png)<br/> |
| 14.31 | - | [Figure_14.31.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.31.png)<br/> |
| 14.32 | - | [Figure_14.32.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.32.png)<br/> |
| 14.33 | - | [Figure_14.33.jpg](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.33.jpg)<br/> |
| 14.34 | - | [Figure_14.34_C.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.34_C.png)<br/>[Figure_14.34_A.jpg](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.34_A.jpg)<br/>[Figure_14.34_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.34_B.png)<br/> |
| 14.35 | - | [Figure_14.35.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.35.png)<br/> |
| 14.36 | - | [Figure_14.36.jpg](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.36.jpg)<br/> |
| 14.37 | - | [Figure_14.37_C.jpg](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.37_C.jpg)<br/>[Figure_14.37_B.jpg](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.37_B.jpg)<br/>[Figure_14.37_A.jpg](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.37_A.jpg)<br/> |
| 14.38 | - | [Figure_14.38_A.jpg](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.38_A.jpg)<br/>[Figure_14.38_C.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.38_C.png)<br/>[Figure_14.38_B.jpg](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.38_B.jpg)<br/> |
| 14.39 | - | [Figure_14.39_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.39_B.png)<br/>[Figure_14.39_C.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.39_C.png)<br/>[Figure_14.39_D.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.39_D.png)<br/>[Figure_14.39_F.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.39_F.png)<br/>[Figure_14.39_H.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.39_H.png)<br/>[Figure_14.39_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.39_A.png)<br/>[Figure_14.39_G.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.39_G.png)<br/>[Figure_14.39_E.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.39_E.png)<br/> |
| 14.40 | - | [Figure_14.40.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.40.png)<br/> |
| 14.41 | - | [Figure_14.41.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_14.41.png)<br/> |

## Supplementary material

|Title|Software|Link|
-|-|-
|Basics of (2d) convolution (D2L 6.2)|PyTorch|[conv2d_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/14/conv2d_torch.ipynb)
|CIFAR image classification with CNN|PyTorch|[cnn_cifar_pytorch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/14/cnn_cifar_pytorch.ipynb)
|LeNet (D2L 6.5)|PyTorch|[lenet_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/14/lenet_torch.ipynb)
|Batchnorm (D2L 7.5|PyTorch|[batchnorm_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/14/batchnorm_torch.ipynb)
|Residual networks (D2L 7.6)|PyTorch|[resnet_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/14/resnet_torch.ipynb)
|Resnets for CIFAR10|PyTorch Lightning|[cifar10_cnn_lightning.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/14/cifar10_cnn_lightning.ipynb)
|Dense nets (D2L 7.7)|PyTorch|[densenet_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/14/densenet_torch.ipynb)
|Multi-GPU training (D2L 12.5)|PyTorch|[d2lbook](https://colab.research.google.com/github/probml/probml-notebooks/blob/master/notebooks-d2l/multi_gpu_torch.ipynb)
|Image augmentation (D2L 13.1)|PyTorch|[image_augmentation_torch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/19/image_augmentation_torch.ipynb)
|Imagenet classifier|JAX/Flax|[External](https://colab.research.google.com/github/google/flax/blob/master/examples/imagenet/imagenet.ipynb)
|MNIST image classification using a CNN|TF2|[cnn_mnist_tf.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/14/cnn_mnist_tf.ipynb)
|Transfer learning for flower classification|TF2|[External](https://www.tensorflow.org/tutorials/images/transfer_learning_with_hub)
|Deep dream|TF2|[External](https://www.tensorflow.org/tutorials/generative/deepdream)
|Neural style transfer|TF2|[External](https://www.tensorflow.org/tutorials/generative/style_transfer))