
# Chapter 13: Neural networks for unstructured data

## Figures

|Figure No. | Notebook | Figure |
|--|--|--|
| 13.1 | [xor_heaviside.ipynb](xor_heaviside.ipynb) | - |
| 13.2 | [activation_fun_plot.ipynb](activation_fun_plot.ipynb) | - |
| 13.3 | - | [Figure_13.3.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.3.png)<br/> |
| 13.4 | [mlp_mnist_tf.ipynb](mlp_mnist_tf.ipynb) | [Figure_13.4_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.4_A.png)<br/>[Figure_13.4_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.4_B.png)<br/> |
| 13.5 | - | [Figure_13.5.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.5.png)<br/> |
| 13.6 | [mlp_1d_regression_hetero_tfp.ipynb](mlp_1d_regression_hetero_tfp.ipynb) | [Figure_13.6_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.6_B.png)<br/>[Figure_13.6_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.6_A.png)<br/> |
| 13.7 | - | [Figure_13.7_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.7_B.png)<br/>[Figure_13.7_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.7_A.png)<br/> |
| 13.8 | - | [Figure_13.8.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.8.png)<br/> |
| 13.9 | - | [Figure_13.9.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.9.png)<br/> |
| 13.10 | - | [Figure_13.10.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.10.png)<br/> |
| 13.11 | - | [Figure_13.11.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.11.png)<br/> |
| 13.12 | - | [Figure_13.12.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.12.png)<br/> |
| 13.13 | - | [Figure_13.13.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.13.png)<br/> |
| 13.14 | [activation_fun_deriv_jax.ipynb](activation_fun_deriv_jax.ipynb) | [Figure_13.14_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.14_A.png)<br/>[Figure_13.14_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.14_B.png)<br/> |
| 13.15 | - | [Figure_13.15_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.15_A.png)<br/>[Figure_13.15_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.15_B.png)<br/> |
| 13.16 | - | [Figure_13.16.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.16.png)<br/> |
| 13.17 | [sparse_mlp.ipynb](sparse_mlp.ipynb) | [Figure_13.17_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.17_B.png)<br/>[Figure_13.17_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.17_A.png)<br/> |
| 13.18 | - | [Figure_13.18_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.18_B.png)<br/>[Figure_13.18_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.18_A.png)<br/> |
| 13.19 | - | [Figure_13.19.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.19.png)<br/> |
| 13.20 | [sgd_minima_variance.ipynb](sgd_minima_variance.ipynb) | [Figure_13.20_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.20_A.png)<br/>[Figure_13.20_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.20_B.png)<br/> |
| 13.21 | [logregXorDemo.ipynb](logregXorDemo.ipynb) | - |
| 13.22 | [linregRbfDemo.ipynb](linregRbfDemo.ipynb) | - |
| 13.23 | [mixexpDemoOneToMany.ipynb](mixexpDemoOneToMany.ipynb) | - |
| 13.24 | - | [Figure_13.24.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.24.png)<br/> |
| 13.25 | - | [Figure_13.25.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_13.25.png)<br/> |

## Supplementary material

|Title|Software|Link|
-|-|-
|Intro to Flax/Jax|Jax, Flax|[flax_intro.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/13/flax_intro.ipynb)
|Intro to Tensorflow|TF2|[External](https://www.tensorflow.org/tutorials)
|Intro to PyTorch|PyTorch|[External](https://pytorch.org/tutorials/beginner/basics/intro.html)
|CIFAR image classification with MLP|PyTorch|[mlp_cifar_pytorch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/13/mlp_cifar_pytorch.ipynb)
|MNIST image classification with MLP|TF2|[mlp_mnist_tf.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/13/mlp_mnist_tf.ipynb)
|Dropout for an MLP|PyTorch|[Notebook](https://colab.research.google.com/github/probml/probml-notebooks/blob/master/notebooks/dropout_mlp_torch.ipynb)
|IMDB movie review sentiment classification|TF2|[mlp_imdb_tf.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/13/mlp_imdb_tf.ipynb)
|Hierarchical Bayes for BNNs|PyMC3|[bnn_hierarchical_pymc3.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/13/bnn_hierarchical_pymc3.ipynb)
|Hierarchical Bayes for BNNs|NumPyro|[bnn_hierarchical_numpyro.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/13/bnn_hierarchical_numpyro.ipynb)
|NYU course on deep learning (2020)|PyTorch|[External](https://atcold.github.io/pytorch-Deep-Learning)