
# Chapter 8: Optimization

## Figures

|Figure No. | Notebook | Figure |
|--|--|--|
| 8.1 | [fig_8_1.ipynb](fig_8_1.ipynb) | - |
| 8.2 | - | [Figure_8.2.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.2.png)<br/> |
| 8.3 | - | [Figure_8.3.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.3.png)<br/> |
| 8.4 | - | [Figure_8.4_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.4_B.png)<br/>[Figure_8.4_A.pdf](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.4_A.pdf)<br/> |
| 8.5 | - | [Figure_8.5_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.5_A.png)<br/>[Figure_8.5_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.5_B.png)<br/> |
| 8.6 | - | [Figure_8.6.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.6.png)<br/> |
| 8.7 | [smooth-vs-nonsmooth-1d.ipynb](smooth-vs-nonsmooth-1d.ipynb) | - |
| 8.8 | - | [Figure_8.8.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.8.png)<br/> |
| 8.9 | - | [Figure_8.9.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.9.png)<br/> |
| 8.10 | - | [Figure_8.10.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.10.png)<br/> |
| 8.11 | [steepestDescentDemo.ipynb](steepestDescentDemo.ipynb) | - |
| 8.12 | [lineSearchConditionNum.ipynb](lineSearchConditionNum.ipynb) | - |
| 8.13 | - | [Figure_8.13.pdf](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.13.pdf)<br/> |
| 8.14 | [fig_8_14.ipynb](fig_8_14.ipynb) | - |
| 8.15 | - | [Figure_8.15.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.15.png)<br/> |
| 8.16 | [lms_demo.ipynb](lms_demo.ipynb) | - |
| 8.17 | [lrschedule_tf.ipynb](lrschedule_tf.ipynb) | [Figure_8.17.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.17.png)<br/> |
| 8.18 | [learning_rate_plot.ipynb](learning_rate_plot.ipynb) | - |
| 8.19 | - | [Figure_8.19_B.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.19_B.png)<br/>[Figure_8.19_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.19_A.png)<br/> |
| 8.20 | - | [Figure_8.20_A.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.20_A.png)<br/> |
| 8.21 | - | [Figure_8.21.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.21.png)<br/> |
| 8.22 | - | [Figure_8.22.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.22.png)<br/> |
| 8.23 | [emLogLikelihoodMax.ipynb](emLogLikelihoodMax.ipynb) | - |
| 8.24 | - | [Figure_8.24.png](https://github.com/probml/pml-book/blob/main/book1-figures/Figure_8.24.png)<br/> |
| 8.25 | [mix_gauss_demo_faithful.ipynb](mix_gauss_demo_faithful.ipynb) | - |
| 8.26 | [fig_8_26.ipynb](fig_8_26.ipynb) | - |
| 8.27 | [gmm_lik_surface_plot.ipynb](gmm_lik_surface_plot.ipynb) | - |

## Supplementary material

|Title|Software|Link|
-|-|-
|Optimization using JAX|JAX|[opt_jax.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/08/opt_jax.ipynb)
|Optimization using Flax|JAX,Flax|[opt_flax.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/08/opt_flax.ipynb)
|Automatic differentiation with tensorflow|TF2|[autodiff_tf.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/08/autodiff_tf.ipynb)
|Automatic differentiation with JAX|JAX|[autodiff_jax.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/08/autodiff_jax.ipynb)
|Automatic differentiation with PyTorch|PyTorch|[autodiff_pytorch.ipynb](https://colab.research.google.com/github/probml/pyprobml/blob/master/notebooks/book1/08/autodiff_pytorch.ipynb)
|Comparison of different optimizers|PyTorch|[External](https://github.com/haven-ai/optimization-toolkit)