
# Guidelines for GSOC 2022 applicants


- Details on how to apply to GSOC (JAX/TF team) can be found 
[here](https://docs.google.com/document/d/1fLDLwIhnwDUz3uUV8RyUZiOlmTN9Uzy5ZuvI8iDDFf8/edit#).
- In your proposal, specify that you are applying to the project called ["JAX ML Textbook"](https://docs.google.com/document/d/1fLDLwIhnwDUz3uUV8RyUZiOlmTN9Uzy5ZuvI8iDDFf8/edit#heading=h.jb7eenqf2crq).
- Applications will open on Monday, April 4, 2022 at 18:00 UTC, and close on Tuesday, April 19, 2022 18:00 UTC. 
- Our project will run June-August (12 weeks), ~6 hours/day (any time zone).
- Candidates  should have commited at least 1 pull request to the [pyprobml repo](https://github.com/probml/pyprobml) before applying.
 You should add a link to your PR(s) in your   proposal/ application.
- Always follow [these coding and github guidelines](https://github.com/probml/pyprobml/blob/master/CONTRIBUTING.md).
- Your PR should solve one of the pyprobml issues tagged as GSOC. 
 The goal is to demonstrate your skills at coding and math, so please write correct, efficient and readable code. 
The best code may be merged into the main repo and linked to from the book.
If you have questions about an issue, please raise it in the github thread. (For example, some issues are quite large / high level,
and should be broken down into concrete subproblems  - feel free to share your proposed design doc before you dive in.)
- It is strongly recommended that applicants read relevant sections of my draft textbook,
 [Probabilistic Machine Learning: Advanced Topics](https://probml.github.io/pml-book/book2.html).
 If you find typos in the book, please raise an issue [here](https://github.com/probml/pml2-book).
If you find errors in the code, please raise an issue [here](https://github.com/probml/pyprobml).
- For some example projects from last summer's GSOC, see [here](https://probml.github.io/pml-book/gsoc/gsoc2021.html).
