AttackAnimationPointers:
	table_width 2
	dw PoundAnim
	dw KarateChopAnim
	dw DoubleSlapAnim
	dw CometPunchAnim
	dw MegaPunchAnim
	dw PayDayAnim
	dw FirePunchAnim
	dw IcePunchAnim
	dw ThunderPunchAnim
	dw ScratchAnim
	dw VicegripAnim
	dw GuillotineAnim
	dw RazorWindAnim
	dw SwordsDanceAnim
	dw CutAnim
	dw GustAnim
	dw WingAttackAnim
	dw WhirlwindAnim
	dw FlyAnim
	dw BindAnim
	dw SlamAnim
	dw VineWhipAnim
	dw StompAnim
	dw DoubleKickAnim
	dw MegaKickAnim
	dw JumpKickAnim
	dw RollingKickAnim
	dw SandAttackAnim
	dw HeadbuttAnim
	dw HornAttackAnim
	dw FuryAttackAnim
	dw HornDrillAnim
	dw TackleAnim
	dw BodySlamAnim
	dw WrapAnim
	dw TakeDownAnim
	dw ThrashAnim
	dw DoubleEdgeAnim
	dw TailWhipAnim
	dw PoisonStingAnim
	dw TwineedleAnim
	dw PinMissileAnim
	dw LeerAnim
	dw BiteAnim
	dw GrowlAnim
	dw RoarAnim
	dw SingAnim
	dw SupersonicAnim
	dw SonicBoomAnim
	dw DisableAnim
	dw AcidAnim
	dw EmberAnim
	dw FlamethrowerAnim
	dw MistAnim
	dw WaterGunAnim
	dw HydroPumpAnim
	dw SurfAnim
	dw IceBeamAnim
	dw BlizzardAnim
	dw PsyBeamAnim
	dw BubbleBeamAnim
	dw AuroraBeamAnim
	dw HyperBeamAnim
	dw PeckAnim
	dw DrillPeckAnim
	dw SubmissionAnim
	dw LowKickAnim
	dw CounterAnim
	dw SeismicTossAnim
	dw StrengthAnim
	dw AbsorbAnim
	dw MegaDrainAnim
	dw LeechSeedAnim
	dw GrowthAnim
	dw RazorLeafAnim
	dw SolarBeamAnim
	dw PoisonPowderAnim
	dw StunSporeAnim
	dw SleepPowderAnim
	dw PetalDanceAnim
	dw StringShotAnim
	dw DragonRageAnim
	dw FireSpinAnim
	dw ThunderShockAnim
	dw ThunderBoltAnim
	dw ThunderWaveAnim
	dw ThunderAnim
	dw RockThrowAnim
	dw EarthquakeAnim
	dw FissureAnim
	dw DigAnim
	dw ToxicAnim
	dw ConfusionAnim
	dw PsychicAnim
	dw HypnosisAnim
	dw MeditateAnim
	dw AgilityAnim
	dw QuickAttackAnim
	dw RageAnim
	dw TeleportAnim
	dw NightShadeAnim
	dw MimicAnim
	dw ScreechAnim
	dw DoubleTeamAnim
	dw RecoverAnim
	dw HardenAnim
	dw MinimizeAnim
	dw SmokeScreenAnim
	dw ConfuseRayAnim
	dw WithdrawAnim
	dw DefenseCurlAnim
	dw BarrierAnim
	dw LightScreenAnim
	dw HazeAnim
	dw ReflectAnim
	dw FocusEnergyAnim
	dw BideAnim
	dw MetronomeAnim
	dw MirrorMoveAnim
	dw SelfdestructAnim
	dw EggBombAnim
	dw LickAnim
	dw SmogAnim
	dw SludgeAnim
	dw BoneClubAnim
	dw FireBlastAnim
	dw WaterfallAnim
	dw ClampAnim
	dw SwiftAnim
	dw SkullBashAnim
	dw SpikeCannonAnim
	dw ConstrictAnim
	dw AmnesiaAnim
	dw KinesisAnim
	dw SoftboiledAnim
	dw HiJumpKickAnim
	dw GlareAnim
	dw DreamEaterAnim
	dw PoisonGasAnim
	dw BarrageAnim
	dw LeechLifeAnim
	dw LovelyKissAnim
	dw SkyAttackAnim
	dw TransformAnim
	dw BubbleAnim
	dw DizzyPunchAnim
	dw SporeAnim
	dw FlashAnim
	dw PsywaveAnim
	dw SplashAnim
	dw AcidArmorAnim
	dw CrabHammerAnim
	dw ExplosionAnim
	dw FurySwipesAnim
	dw BonemerangAnim
	dw RestAnim
	dw RockSlideAnim
	dw HyperFangAnim
	dw SharpenAnim
	dw ConversionAnim
	dw TriAttackAnim
	dw SuperFangAnim
	dw SlashAnim
	dw SubstituteAnim
	dw StruggleAnim
	assert_table_length NUM_ATTACKS
	dw ShowPicAnim
	dw EnemyFlashAnim
	dw PlayerFlashAnim
	dw EnemyHUDShakeAnim
	dw TradeBallDropAnim
	dw TradeBallAppear1Anim
	dw TradeBallAppear2Anim
	dw TradeBallPoofAnim
	dw XStatItemAnim
	dw XStatItemAnim
	dw ShrinkingSquareAnim
	dw ShrinkingSquareAnim
	dw XStatItemBlackAnim
	dw XStatItemBlackAnim
	dw ShrinkingSquareBlackAnim
	dw ShrinkingSquareBlackAnim
	dw UnusedAnim
	dw UnusedAnim
	dw ParalyzeAnim
	dw ParalyzeAnim
	dw PoisonAnim
	dw PoisonAnim
	dw SleepPlayerAnim
	dw SleepEnemyAnim
	dw ConfusedPlayerAnim
	dw ConfusedEnemyAnim
	dw SlideDownAnim
	dw BallTossAnim
	dw BallShakeAnim
	dw BallPoofAnim
	dw BallBlockAnim
	dw GreatTossAnim
	dw UltraTossAnim
	dw ShakeScreenAnim
	dw HidePicAnim
	dw ThrowRockAnim
	dw ThrowBaitAnim
	assert_table_length NUM_ATTACK_ANIMS

; each animation is a list of subanimations
; and/or special effects, terminated by -1

;\1: sound_id
;\2: special_effect_id or subanimation_id
; if \2 is a subanimation_id:
;\3: tileset_id
;\4: delay
MACRO battle_anim
	IF _NARG == 4
		db (\3 << 6) | \4
		db \1 - 1
		db \2
	ELSE
		db \2
		db \1 - 1
	ENDC
ENDM

; The 0 or 1 in the name of a subanim indicates whether to use tileset 0 or 1.
; "Both" indicates either can be used for different images using the same animation.

PoundAnim:
StruggleAnim:
	battle_anim POUND, SUBANIM_0_STAR_TWICE, 0, 8
	db -1 ; end

KarateChopAnim:
	battle_anim KARATE_CHOP, SUBANIM_0_STAR_DESCENDING, 0, 8
	db -1 ; end

DoubleSlapAnim:
	battle_anim DOUBLESLAP, SUBANIM_0_STAR_TWICE, 0, 5
	battle_anim DOUBLESLAP, SUBANIM_0_STAR_TWICE, 0, 5
	db -1 ; end

CometPunchAnim:
	battle_anim COMET_PUNCH, SUBANIM_0_STAR_THRICE, 0, 4
	battle_anim COMET_PUNCH, SUBANIM_0_STAR_THRICE, 0, 4
	db -1 ; end

MegaPunchAnim:
	battle_anim MEGA_PUNCH, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

PayDayAnim:
	battle_anim POUND, SUBANIM_0_STAR_TWICE, 0, 8
	battle_anim PAY_DAY, SUBANIM_0_COIN_BOUNCE, 0, 4
	db -1 ; end

FirePunchAnim:
	battle_anim FIRE_PUNCH, SUBANIM_0_STAR_THRICE, 0, 6
	battle_anim NO_MOVE, SUBANIM_1_FLAMES, 1, 6
	db -1 ; end

IcePunchAnim:
	battle_anim ICE_PUNCH, SUBANIM_0_STAR_THRICE, 0, 6
	battle_anim NO_MOVE, SUBANIM_0_ICE_RISE, 0, 16
	db -1 ; end

ThunderPunchAnim:
	battle_anim THUNDERPUNCH, SUBANIM_0_STAR_THRICE, 0, 6
	battle_anim NO_MOVE, SE_DARK_SCREEN_PALETTE
	battle_anim NO_MOVE, SUBANIM_1_LIGHTNING, 1, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

ScratchAnim:
	battle_anim SCRATCH, SUBANIM_0_SCRATCHES, 0, 6
	db -1 ; end

VicegripAnim:
	battle_anim VICEGRIP, SUBANIM_0_SLICE_BOTH_SIDES, 0, 8
	db -1 ; end

GuillotineAnim:
	battle_anim GUILLOTINE, SUBANIM_0_SLICE_BOTH_SIDES, 0, 6
	db -1 ; end

RazorWindAnim:
	battle_anim RAZOR_WIND, SUBANIM_0_SLICE, 0, 4
	db -1 ; end

SwordsDanceAnim:
	battle_anim SWORDS_DANCE, SUBANIM_1_SWORDS_CIRCLING, 1, 6
	battle_anim SWORDS_DANCE, SUBANIM_1_SWORDS_CIRCLING, 1, 6
	battle_anim SWORDS_DANCE, SUBANIM_1_SWORDS_CIRCLING, 1, 6
	db -1 ; end

CutAnim:
	battle_anim CUT, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SUBANIM_0_SLICE, 0, 4
	db -1 ; end

GustAnim:
	battle_anim GUST, SUBANIM_1_TORNADO, 1, 6
	battle_anim NO_MOVE, SUBANIM_0_STAR_THRICE, 0, 6
	db -1 ; end

WingAttackAnim:
	battle_anim WING_ATTACK, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

WhirlwindAnim:
	battle_anim WHIRLWIND, SUBANIM_1_TORNADO, 1, 6
	battle_anim NO_MOVE, SE_SLIDE_ENEMY_MON_OFF
	db -1 ; end

FlyAnim:
	battle_anim FLY, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	db -1 ; end

BindAnim:
	battle_anim BIND, SUBANIM_0_BIND, 0, 4
	battle_anim BIND, SUBANIM_0_BIND, 0, 4
	db -1 ; end

SlamAnim:
	battle_anim SLAM, SUBANIM_0_STAR_THRICE, 0, 6
	db -1 ; end

VineWhipAnim:
	battle_anim VINE_WHIP, SUBANIM_0_SLICE, 0, 1
	battle_anim NO_MOVE, SUBANIM_0_STAR_TWICE, 0, 8
	db -1 ; end

StompAnim:
	battle_anim STOMP, SUBANIM_1_STAR_BIG, 1, 8
	db -1 ; end

DoubleKickAnim:
	battle_anim DOUBLE_KICK, SUBANIM_0_STAR_TWICE, 0, 8
	battle_anim DOUBLE_KICK, SUBANIM_0_STAR_TWICE, 0, 8
	db -1 ; end

MegaKickAnim:
	battle_anim MEGA_KICK, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

JumpKickAnim:
	battle_anim JUMP_KICK, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

RollingKickAnim:
	battle_anim ROLLING_KICK, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

SandAttackAnim:
	battle_anim SAND_ATTACK, SUBANIM_1_SAND, 1, 6
	db -1 ; end

HeadbuttAnim:
	battle_anim HEADBUTT, SUBANIM_1_STAR_BIG, 1, 6
	db -1 ; end

HornAttackAnim:
	battle_anim HORN_ATTACK, SUBANIM_0_HORN_JAB_TWICE, 0, 6
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG, 1, 6
	db -1 ; end

FuryAttackAnim:
	battle_anim FURY_ATTACK, SUBANIM_0_HORN_JAB_THRICE, 0, 2
	battle_anim NO_MOVE, SUBANIM_0_HORN_JAB_THRICE, 0, 2
	db -1 ; end

HornDrillAnim:
	battle_anim HORN_DRILL, SUBANIM_1_STAR_BIG, 1, 2
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG, 1, 2
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG, 1, 2
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG, 1, 2
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG, 1, 2
	db -1 ; end

TackleAnim:
	battle_anim LEECH_SEED, SE_MOVE_MON_HORIZONTALLY
	battle_anim NO_MOVE, SE_RESET_MON_POSITION
	db -1 ; end

BodySlamAnim:
	battle_anim LEECH_SEED, SE_MOVE_MON_HORIZONTALLY
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_MON_POSITION
	db -1 ; end

WrapAnim:
	battle_anim WRAP, SUBANIM_0_BIND, 0, 4
	battle_anim WRAP, SUBANIM_0_BIND, 0, 4
	battle_anim WRAP, SUBANIM_0_BIND, 0, 4
	db -1 ; end

TakeDownAnim:
	battle_anim LEECH_SEED, SE_MOVE_MON_HORIZONTALLY
	battle_anim TAKE_DOWN, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_MON_POSITION
	db -1 ; end

ThrashAnim:
	battle_anim THRASH, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

DoubleEdgeAnim:
	battle_anim LEECH_SEED, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SUBANIM_0_CIRCLES_CENTERING, 0, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_MOVE_MON_HORIZONTALLY
	battle_anim DOUBLE_EDGE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_MON_POSITION
	db -1 ; end

TailWhipAnim:
	battle_anim AMNESIA, SE_MOVE_MON_HORIZONTALLY
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim AMNESIA, SE_RESET_MON_POSITION
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim AMNESIA, SE_MOVE_MON_HORIZONTALLY
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim AMNESIA, SE_RESET_MON_POSITION
	db -1 ; end

PoisonStingAnim:
	battle_anim POISON_STING, SUBANIM_0_STAR, 0, 6
	db -1 ; end

TwineedleAnim:
	battle_anim TWINEEDLE, SUBANIM_0_STAR_TWICE, 0, 5
	battle_anim TWINEEDLE, SUBANIM_0_STAR_TWICE, 0, 5
	db -1 ; end

PinMissileAnim:
	battle_anim PIN_MISSILE, SUBANIM_0_STAR_TWICE, 0, 3
	db -1 ; end

LeerAnim:
	battle_anim LEECH_SEED, SE_DARK_SCREEN_PALETTE
	battle_anim LEER, SE_DARK_SCREEN_FLASH
	battle_anim LEER, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

BiteAnim:
	battle_anim BITE, SUBANIM_0_STAR_THRICE, 0, 8
	db -1 ; end

GrowlAnim:
	battle_anim GROWL, SUBANIM_0_HEART_1_MUSIC, 1, 6
	db -1 ; end

RoarAnim:
	battle_anim ROAR, SUBANIM_1_SHOUT, 1, 6
	battle_anim ROAR, SUBANIM_1_SHOUT, 1, 6
	battle_anim ROAR, SUBANIM_1_SHOUT, 1, 6
	db -1 ; end

SingAnim:
	battle_anim SING, SUBANIM_0_HEART_1_MUSIC, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_MUSIC_CIRCLING_ENEMY, 1, 16
	battle_anim NO_MOVE, SUBANIM_1_MUSIC_CIRCLING_ENEMY, 1, 16
	db -1 ; end

SupersonicAnim:
	battle_anim SUPERSONIC, SUBANIM_0_SOUND_WAVE, 0, 6
	db -1 ; end

SonicBoomAnim:
	battle_anim ROAR, SUBANIM_1_SHOUT, 1, 6
	battle_anim ROAR, SUBANIM_1_SHOUT, 1, 6
	battle_anim GUST, SUBANIM_1_TORNADO, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG, 1, 6
	db -1 ; end

DisableAnim:
	battle_anim LEECH_SEED, SE_DARK_SCREEN_PALETTE
	battle_anim LEER, SE_DARK_SCREEN_FLASH
	battle_anim LEER, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

AcidAnim:
	battle_anim ACID, SUBANIM_1_BLOB_TOSS, 1, 6
	battle_anim ACID, SUBANIM_1_BLOB_DRIP_ENEMY, 1, 6
	db -1 ; end

EmberAnim:
	battle_anim EMBER, SUBANIM_1_FLAMES, 1, 6
	db -1 ; end

FlamethrowerAnim:
	battle_anim FLAMETHROWER, SUBANIM_1_FLAME_BEAM, 1, 6
	battle_anim FLAMETHROWER, SUBANIM_1_FLAME_COLUMN_1, 1, 6
	battle_anim FLAMETHROWER, SUBANIM_1_FLAME_COLUMN_2, 1, 6
	db -1 ; end

MistAnim:
	battle_anim NO_MOVE, SE_LIGHT_SCREEN_PALETTE
	battle_anim SURF, SE_WATER_DROPLETS_EVERYWHERE
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

WaterGunAnim:
	battle_anim WATER_GUN, SUBANIM_0_WATER_DROPLETS, 0, 6
	db -1 ; end

HydroPumpAnim:
	battle_anim HYDRO_PUMP, SUBANIM_0_WATER_COLUMNS, 0, 6
	battle_anim HYDRO_PUMP, SUBANIM_0_WATER_COLUMNS, 0, 6
	db -1 ; end

SurfAnim:
	battle_anim SURF, SE_WATER_DROPLETS_EVERYWHERE
	battle_anim HYDRO_PUMP, SUBANIM_0_WATER_COLUMNS, 0, 6
	db -1 ; end

IceBeamAnim:
	battle_anim ICE_BEAM, SUBANIM_0_BEAM, 0, 3
	battle_anim NO_MOVE, SUBANIM_0_ICE_RISE, 0, 16
	db -1 ; end

BlizzardAnim:
	battle_anim BLIZZARD, SUBANIM_0_ICE_FALL, 0, 4
	battle_anim HYDRO_PUMP, SUBANIM_0_ICE_FALL, 0, 4
	db -1 ; end

PsyBeamAnim:
	battle_anim PSYBEAM, SUBANIM_0_BEAM, 0, 3
	battle_anim NO_MOVE, SE_FLASH_SCREEN_LONG
	db -1 ; end

BubbleBeamAnim:
	battle_anim BUBBLEBEAM, SUBANIM_0_WATER_BUBBLES, 0, 18
	db -1 ; end

AuroraBeamAnim:
	battle_anim AURORA_BEAM, SUBANIM_0_BEAM, 0, 3
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	db -1 ; end

HyperBeamAnim:
	battle_anim LEECH_SEED, SE_DARK_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_SPIRAL_BALLS_INWARD
	battle_anim HYPER_BEAM, SUBANIM_0_BEAM, 0, 2
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim MEGA_PUNCH, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

PeckAnim:
	battle_anim PECK, SUBANIM_0_STAR_TWICE, 0, 8
	db -1 ; end

DrillPeckAnim:
	battle_anim DRILL_PECK, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

SubmissionAnim:
	battle_anim SUBMISSION, SE_SLIDE_MON_OFF
	battle_anim NO_MOVE, SUBANIM_0_STAR_TWICE, 0, 6
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	db -1 ; end

LowKickAnim:
	battle_anim LOW_KICK, SE_SLIDE_MON_OFF
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	db -1 ; end

CounterAnim:
	battle_anim COUNTER, SE_SLIDE_MON_OFF
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	db -1 ; end

SeismicTossAnim:
	battle_anim NO_MOVE, SE_BLINK_ENEMY_MON
	battle_anim BARRAGE, SUBANIM_1_SPHERE_BIG, 1, 1
	battle_anim NO_MOVE, SE_HIDE_ENEMY_MON_PIC
	battle_anim NO_MOVE, SE_SLIDE_MON_OFF
	battle_anim SEISMIC_TOSS, SUBANIM_1_SPHERE_BIG_RISE, 1, 2
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	battle_anim SEISMIC_TOSS, SUBANIM_1_SPHERE_BIG_FALL, 1, 1
	battle_anim NO_MOVE, SE_SHOW_ENEMY_MON_PIC
	battle_anim NO_MOVE, SE_SHAKE_SCREEN
	db -1 ; end

StrengthAnim:
	battle_anim LEECH_SEED, SE_MOVE_MON_HORIZONTALLY
	battle_anim NO_MOVE, SE_RESET_MON_POSITION
	battle_anim FIRE_PUNCH, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

AbsorbAnim:
	battle_anim ABSORB, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SUBANIM_0_CIRCLES_1_SQUARES_CENTERING_ENEMY, 0, 6
	battle_anim NO_MOVE, SUBANIM_0_CIRCLE_1_SQUARE_TOSS_BACK, 0, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

MegaDrainAnim:
	battle_anim MEGA_DRAIN, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SUBANIM_0_CIRCLES_1_SQUARES_CENTERING_ENEMY, 0, 6
	battle_anim NO_MOVE, SUBANIM_0_CIRCLE_1_SQUARE_TOSS_BACK, 0, 6
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

LeechSeedAnim:
	battle_anim LEECH_SEED, SUBANIM_1_SEED_TOSS, 1, 6
	battle_anim STUN_SPORE, SUBANIM_1_SEED_LAND, 1, 21
	db -1 ; end

GrowthAnim:
	battle_anim GROWTH, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_SPIRAL_BALLS_INWARD
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

RazorLeafAnim:
	battle_anim RAZOR_LEAF, SE_LEAVES_FALLING
	battle_anim SWIFT, SUBANIM_1_LEAVES_TOSS, 1, 1
	battle_anim RAZOR_WIND, SUBANIM_0_SLICE, 0, 1
	db -1 ; end

SolarBeamAnim:
	battle_anim SOLARBEAM, SUBANIM_0_BEAM, 0, 6
	battle_anim NO_MOVE, SUBANIM_0_STAR_TWICE, 0, 6
	db -1 ; end

PoisonPowderAnim:
	battle_anim POISONPOWDER, SUBANIM_0_CIRCLES_FALLING, 0, 6
	db -1 ; end

StunSporeAnim:
	battle_anim STUN_SPORE, SUBANIM_0_CIRCLES_FALLING, 0, 6
	db -1 ; end

SleepPowderAnim:
	battle_anim SLEEP_POWDER, SUBANIM_0_CIRCLES_FALLING, 0, 6
	db -1 ; end

PetalDanceAnim:
	battle_anim PETAL_DANCE, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_PETALS_FALLING
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

StringShotAnim:
	battle_anim STRING_SHOT, SUBANIM_0_STRING_SHOT, 0, 8
	db -1 ; end

DragonRageAnim:
	battle_anim DRAGON_RAGE, SUBANIM_1_FLAME_BEAM, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_FLAME_COLUMN_1, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_FLAME_COLUMN_2, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_FLAME_COLUMN_3, 1, 6
	db -1 ; end

FireSpinAnim:
	battle_anim FIRE_SPIN, SUBANIM_1_FLAME_COLUMN_1, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_FLAME_COLUMN_2, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_FLAME_COLUMN_3, 1, 6
	db -1 ; end

ThunderShockAnim:
	battle_anim THUNDERSHOCK, SUBANIM_1_LIGHTNING_BALL, 1, 2
	db -1 ; end

ThunderBoltAnim:
	battle_anim THUNDERBOLT, SUBANIM_1_LIGHTNING_BALL, 1, 1
	battle_anim THUNDERBOLT, SUBANIM_1_LIGHTNING_BALL, 1, 1
	db -1 ; end

ThunderWaveAnim:
	battle_anim THUNDER_WAVE, SUBANIM_1_LIGHTNING_BALL, 1, 2
	battle_anim NO_MOVE, SUBANIM_0_BIND, 0, 2
	battle_anim NO_MOVE, SUBANIM_0_BIND, 0, 4
	db -1 ; end

ThunderAnim:
	battle_anim THUNDER, SE_DARK_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SUBANIM_1_LIGHTNING, 1, 6
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim THUNDERBOLT, SUBANIM_1_LIGHTNING_BALL, 1, 2
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

RockThrowAnim:
	battle_anim ROCK_THROW, SUBANIM_0_ROCKS_FALL_ENEMY, 0, 4
	db -1 ; end

EarthquakeAnim:
	battle_anim EARTHQUAKE, SE_SHAKE_SCREEN
	battle_anim EARTHQUAKE, SE_SHAKE_SCREEN
	db -1 ; end

FissureAnim:
	battle_anim FISSURE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_SHAKE_SCREEN
	battle_anim FISSURE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_SHAKE_SCREEN
	db -1 ; end

DigAnim:
	battle_anim DIG, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	battle_anim NO_MOVE, SE_SLIDE_MON_UP
	db -1 ; end

ToxicAnim:
	battle_anim SURF, SE_WATER_DROPLETS_EVERYWHERE
	battle_anim TOXIC, SUBANIM_1_BLOB_DRIP_ENEMY, 1, 6
	db -1 ; end

ConfusionAnim:
	battle_anim CONFUSION, SE_FLASH_SCREEN_LONG
	db -1 ; end

PsychicAnim:
	battle_anim PSYCHIC_M, SE_FLASH_SCREEN_LONG
	battle_anim NO_MOVE, SE_WAVY_SCREEN
	db -1 ; end

HypnosisAnim:
	battle_anim HYPNOSIS, SE_FLASH_SCREEN_LONG
	db -1 ; end

MeditateAnim:
	battle_anim MEDITATE, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SUBANIM_0_CIRCLE_1_SQUARE_CLOSING, 1, 6
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

AgilityAnim:
	battle_anim AGILITY, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

QuickAttackAnim:
	battle_anim QUICK_ATTACK, SE_SLIDE_MON_OFF
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	db -1 ; end

RageAnim:
	battle_anim RAGE, SUBANIM_0_STAR_TWICE, 0, 6
	db -1 ; end

TeleportAnim:
	battle_anim TELEPORT, SE_SQUISH_MON_PIC
	battle_anim NO_MOVE, SE_SHOOT_BALLS_UPWARD
	db -1 ; end

NightShadeAnim:
	battle_anim CONFUSION, SE_FLASH_SCREEN_LONG
	battle_anim NO_MOVE, SE_WAVY_SCREEN
	db -1 ; end

MimicAnim:
	battle_anim MIMIC, SUBANIM_0_CIRCLES_1_SQUARES_CENTERING_ENEMY, 1, 6
	battle_anim MIMIC, SUBANIM_0_CIRCLE_1_SQUARE_TOSS_BACK, 1, 6
	db -1 ; end

ScreechAnim:
	battle_anim SCREECH, SUBANIM_0_HEART_1_MUSIC, 1, 6
	db -1 ; end

DoubleTeamAnim:
	battle_anim NO_MOVE, SE_DARK_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	battle_anim DOUBLE_TEAM, SE_SHAKE_BACK_AND_FORTH
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	battle_anim BARRIER, SUBANIM_1_BARRIER, 1, 6
	db -1 ; end

RecoverAnim:
	battle_anim RECOVER, SE_BLINK_MON
	battle_anim NO_MOVE, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_SPIRAL_BALLS_INWARD
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

HardenAnim:
	battle_anim HARDEN, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SUBANIM_0_CIRCLE_1_SQUARE_CLOSING, 1, 6
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

MinimizeAnim:
	battle_anim MINIMIZE, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_SPIRAL_BALLS_INWARD
	battle_anim NO_MOVE, SE_MINIMIZE_MON
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

SmokeScreenAnim:
	battle_anim SMOKESCREEN, SUBANIM_1_SAND, 1, 6
	battle_anim NO_MOVE, SUBANIM_0_BALL_POOF_ENEMY, 0, 4
	battle_anim NO_MOVE, SE_DARKEN_MON_PALETTE
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DARK_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_DARKEN_MON_PALETTE
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

ConfuseRayAnim:
	battle_anim CONFUSE_RAY, SE_DARK_SCREEN_PALETTE
	battle_anim NO_MOVE, SUBANIM_1_STAR_BIG_TOSS, 1, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

WithdrawAnim:
	battle_anim DEFENSE_CURL, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_SLIDE_MON_DOWN
	battle_anim NO_MOVE, SUBANIM_0_SHELL, 0, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	db -1 ; end

DefenseCurlAnim:
	battle_anim DEFENSE_CURL, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SUBANIM_0_CIRCLE_1_SQUARE_CLOSING, 0, 6
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

BarrierAnim:
	battle_anim BARRIER, SUBANIM_1_BARRIER, 1, 6
	battle_anim BARRIER, SUBANIM_1_BARRIER, 1, 6
	db -1 ; end

LightScreenAnim:
	battle_anim NO_MOVE, SE_LIGHT_SCREEN_PALETTE
	battle_anim LIGHT_SCREEN, SUBANIM_1_BARRIER, 1, 6
	battle_anim LIGHT_SCREEN, SUBANIM_1_BARRIER, 1, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

HazeAnim:
	battle_anim NO_MOVE, SE_DARKEN_MON_PALETTE
	battle_anim SURF, SE_WATER_DROPLETS_EVERYWHERE
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

ReflectAnim:
	battle_anim NO_MOVE, SE_DARK_SCREEN_PALETTE
	battle_anim REFLECT, SUBANIM_1_BARRIER, 1, 6
	battle_anim REFLECT, SUBANIM_1_BARRIER, 1, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

FocusEnergyAnim:
	battle_anim FOCUS_ENERGY, SE_SPIRAL_BALLS_INWARD
	db -1 ; end

BideAnim:
	battle_anim BIDE, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

MetronomeAnim:
	battle_anim AMNESIA, SE_MOVE_MON_HORIZONTALLY
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim AMNESIA, SE_RESET_MON_POSITION
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim AMNESIA, SE_MOVE_MON_HORIZONTALLY
	battle_anim NO_MOVE, SE_DELAY_ANIMATION_10
	battle_anim AMNESIA, SE_RESET_MON_POSITION
	db -1 ; end

MirrorMoveAnim:
	battle_anim MIRROR_MOVE, SUBANIM_0_STAR_TWICE, 0, 8
	db -1 ; end

SelfdestructAnim:
	battle_anim SELFDESTRUCT, SUBANIM_1_SELFDESTRUCT, 1, 3
	db -1 ; end

EggBombAnim:
	battle_anim EGG_BOMB, SUBANIM_1_CIRCLE_BLACK_TOSS, 1, 4
	battle_anim EGG_BOMB, SUBANIM_1_EXPLOSION_SMALL_ENEMY, 1, 4
	db -1 ; end

LickAnim:
	battle_anim SLUDGE, SUBANIM_1_BLOB_DRIP_ENEMY, 1, 6
	db -1 ; end

SmogAnim:
	battle_anim LEECH_SEED, SE_DARKEN_MON_PALETTE
	battle_anim SMOG, SUBANIM_1_CLOUD_TOSS, 1, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

SludgeAnim:
	battle_anim SLUDGE, SUBANIM_1_BLOB_TOSS, 1, 6
	battle_anim SLUDGE, SUBANIM_1_BLOB_DRIP_ENEMY, 1, 6
	db -1 ; end

BoneClubAnim:
	battle_anim BONE_CLUB, SUBANIM_0_STAR_THRICE, 0, 8
	db -1 ; end

FireBlastAnim:
	battle_anim FIRE_BLAST, SUBANIM_1_FLAME_BEAM, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_FLAME_STAR, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_FLAME_STAR, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_FLAME_COLUMN_1, 1, 6
	battle_anim NO_MOVE, SUBANIM_1_FLAME_COLUMN_2, 1, 6
	db -1 ; end

WaterfallAnim:
	battle_anim LEECH_SEED, SE_SLIDE_MON_DOWN
	battle_anim HYDRO_PUMP, SUBANIM_0_WATER_COLUMNS, 0, 6
	battle_anim NO_MOVE, SUBANIM_0_STAR_THRICE, 0, 8
	battle_anim NO_MOVE, SE_SLIDE_MON_UP
	db -1 ; end

ClampAnim:
	battle_anim CLAMP, SUBANIM_0_SLICE_BOTH_SIDES, 0, 8
	battle_anim CONSTRICT, SUBANIM_0_BIND, 0, 6
	battle_anim CONSTRICT, SUBANIM_0_BIND, 0, 6
	db -1 ; end

SwiftAnim:
	battle_anim SWIFT, SUBANIM_1_STARS_SMALL_TOSS, 1, 3
	db -1 ; end

SkullBashAnim:
	battle_anim SKULL_BASH, SUBANIM_1_STAR_BIG, 1, 6
	db -1 ; end

SpikeCannonAnim:
	battle_anim SPIKE_CANNON, SUBANIM_1_STAR_BIG_MOVING, 1, 4
	db -1 ; end

ConstrictAnim:
	battle_anim CONSTRICT, SUBANIM_0_BIND, 0, 6
	battle_anim CONSTRICT, SUBANIM_0_BIND, 0, 6
	battle_anim CONSTRICT, SUBANIM_0_BIND, 0, 6
	db -1 ; end

AmnesiaAnim:
	battle_anim AMNESIA, SUBANIM_0_STATUS_CONFUSED, 0, 8
	battle_anim AMNESIA, SUBANIM_0_STATUS_CONFUSED, 0, 8
	db -1 ; end

KinesisAnim:
	battle_anim KINESIS, SUBANIM_0_STAR_TWICE, 0, 8
	db -1 ; end

SoftboiledAnim:
	battle_anim LEECH_SEED, SE_SLIDE_MON_HALF_OFF
	battle_anim SOFTBOILED, SUBANIM_0_EGG_SHAKING, 0, 8
	battle_anim NO_MOVE, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_SPIRAL_BALLS_INWARD
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	db -1 ; end

HiJumpKickAnim:
	battle_anim HI_JUMP_KICK, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

GlareAnim:
	battle_anim LEECH_SEED, SE_DARK_SCREEN_PALETTE
	battle_anim GLARE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

DreamEaterAnim:
	battle_anim DREAM_EATER, SE_FLASH_SCREEN_LONG
	battle_anim DREAM_EATER, SE_DARK_SCREEN_PALETTE
	battle_anim DREAM_EATER, SUBANIM_0_STAR_THRICE, 0, 8
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

PoisonGasAnim:
	battle_anim POISON_GAS, SUBANIM_1_CLOUD_TOSS, 1, 6
	db -1 ; end

BarrageAnim:
	battle_anim BARRAGE, SUBANIM_1_CIRCLE_BLACK_TOSS, 1, 3
	battle_anim NO_MOVE, SUBANIM_0_STAR_HIGH, 0, 5
	db -1 ; end

LeechLifeAnim:
	battle_anim LEECH_LIFE, SUBANIM_0_STAR_THRICE, 0, 8
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SUBANIM_0_CIRCLES_1_SQUARES_CENTERING_ENEMY, 0, 6
	battle_anim NO_MOVE, SUBANIM_0_CIRCLE_1_SQUARE_TOSS_BACK, 0, 6
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	db -1 ; end

LovelyKissAnim:
	battle_anim LOVELY_KISS, SUBANIM_0_HEART_1_MUSIC, 0, 6
	db -1 ; end

SkyAttackAnim:
	battle_anim SKY_ATTACK, SE_SQUISH_MON_PIC
	battle_anim NO_MOVE, SE_SHOOT_BALLS_UPWARD
	battle_anim HI_JUMP_KICK, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	db -1 ; end

TransformAnim:
	battle_anim TRANSFORM, SUBANIM_0_CIRCLES_1_SQUARES_CENTERING_ENEMY, 1, 6
	battle_anim TRANSFORM, SUBANIM_0_CIRCLE_1_SQUARE_TOSS_BACK, 1, 4
	battle_anim NO_MOVE, SUBANIM_0_BALL_POOF, 0, 8
	battle_anim NO_MOVE, SE_TRANSFORM_MON
	db -1 ; end

BubbleAnim:
	battle_anim BUBBLE, SUBANIM_0_WATER_BUBBLES, 0, 22
	db -1 ; end

DizzyPunchAnim:
	battle_anim DIZZY_PUNCH, SUBANIM_0_BIRDIES_CIRCLING_ENEMY, 0, 6
	battle_anim DIZZY_PUNCH, SUBANIM_0_BIRDIES_CIRCLING_ENEMY, 0, 6
	battle_anim DIZZY_PUNCH, SUBANIM_0_BIRDIES_CIRCLING_ENEMY, 0, 6
	battle_anim DOUBLESLAP, SUBANIM_0_STAR_THRICE, 0, 6
	db -1 ; end

SporeAnim:
	battle_anim SPORE, SUBANIM_0_CIRCLES_FALLING, 0, 6
	db -1 ; end

FlashAnim:
	battle_anim LEECH_SEED, SE_LIGHT_SCREEN_PALETTE
	battle_anim GLARE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

PsywaveAnim:
	battle_anim SUPERSONIC, SUBANIM_0_SOUND_WAVE, 0, 6
	battle_anim CONFUSION, SE_WAVY_SCREEN
	db -1 ; end

SplashAnim:
	battle_anim SPLASH, SE_BOUNCE_UP_AND_DOWN
	db -1 ; end

AcidArmorAnim:
	battle_anim ACID_ARMOR, SE_SLIDE_MON_DOWN_AND_HIDE
	db -1 ; end

CrabHammerAnim:
	battle_anim CRABHAMMER, SUBANIM_1_STAR_BIG, 1, 6
	battle_anim NO_MOVE, SUBANIM_0_SLICE_BOTH_SIDES, 0, 6
	db -1 ; end

ExplosionAnim:
	battle_anim EXPLOSION, SUBANIM_1_SELFDESTRUCT, 1, 3
	db -1 ; end

FurySwipesAnim:
	battle_anim FURY_SWIPES, SUBANIM_0_SCRATCHES, 0, 4
	db -1 ; end

BonemerangAnim:
	battle_anim BONEMERANG, SUBANIM_0_STAR_THRICE, 0, 6
	db -1 ; end

RestAnim:
	battle_anim REST, SUBANIM_0_STATUS_SLEEP, 0, 16
	battle_anim REST, SUBANIM_0_STATUS_SLEEP, 0, 16
	db -1 ; end

RockSlideAnim:
	battle_anim ROCK_SLIDE, SUBANIM_0_ROCKS_LIFT, 0, 4
	battle_anim ROCK_SLIDE, SUBANIM_0_ROCKS_TOSS, 0, 3
	battle_anim HYPER_FANG, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	db -1 ; end

HyperFangAnim:
	battle_anim HYPER_FANG, SUBANIM_0_STAR_THRICE, 0, 6
	db -1 ; end

SharpenAnim:
	battle_anim SHARPEN, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SUBANIM_0_CIRCLE_1_SQUARE_CLOSING, 1, 6
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

ConversionAnim:
	battle_anim CONVERSION, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SUBANIM_0_CIRCLES_1_SQUARES_CENTERING_ENEMY, 1, 6
	battle_anim NO_MOVE, SUBANIM_0_CIRCLE_1_SQUARE_TOSS_BACK, 1, 6
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	db -1 ; end

TriAttackAnim:
	battle_anim TRI_ATTACK, SE_DARK_SCREEN_FLASH
	battle_anim NO_MOVE, SUBANIM_1_TRIANGLE_TOSS, 1, 6
	battle_anim NO_MOVE, SE_DARK_SCREEN_FLASH
	db -1 ; end

SuperFangAnim:
	battle_anim LEECH_SEED, SE_DARK_SCREEN_PALETTE
	battle_anim SUPER_FANG, SUBANIM_1_STAR_BIG_MOVING, 1, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

SlashAnim:
	battle_anim SLASH, SUBANIM_0_SCRATCHES, 0, 6
	db -1 ; end

SubstituteAnim:
	battle_anim SUBSTITUTE, SE_SLIDE_MON_OFF
	battle_anim NO_MOVE, SUBANIM_0_BALL_POOF, 0, 8
	battle_anim NO_MOVE, SE_SUBSTITUTE_MON
	db -1 ; end

BallTossAnim:
	battle_anim NO_MOVE, SUBANIM_0_BALL_TOSS_HIGH, 0, 3
	db -1 ; end

GreatTossAnim:
	battle_anim NO_MOVE, SUBANIM_0_BALL_TOSS_MIDDLE, 0, 3
	db -1 ; end

UltraTossAnim:
	battle_anim NO_MOVE, SUBANIM_0_BALL_TOSS_LOW, 0, 2
	db -1 ; end

BallShakeAnim:
	battle_anim NO_MOVE, SUBANIM_0_BALL_SHAKE_ENEMY, 0, 4
	db -1 ; end

BallPoofAnim:
	battle_anim NO_MOVE, SUBANIM_0_BALL_POOF_ENEMY, 0, 4
	db -1 ; end

ShowPicAnim:
	battle_anim NO_MOVE, SE_SHOW_ENEMY_MON_PIC
	db -1 ; end

HidePicAnim:
	battle_anim NO_MOVE, SE_HIDE_ENEMY_MON_PIC
	db -1 ; end

EnemyFlashAnim:
	battle_anim NO_MOVE, SE_SHOW_MON_PIC
	db -1 ; end

PlayerFlashAnim:
	battle_anim NO_MOVE, SE_FLASH_MON_PIC
	db -1 ; end

EnemyHUDShakeAnim:
	battle_anim NO_MOVE, SE_SHAKE_ENEMY_HUD
	db -1 ; end

TradeBallDropAnim:
	battle_anim NO_MOVE, SUBANIM_2_TRADE_BALL_DROP, 2, 6
	db -1 ; end

TradeBallAppear1Anim:
	battle_anim NO_MOVE, SUBANIM_2_TRADE_BALL_SHAKE, 2, 4
	db -1 ; end

TradeBallAppear2Anim:
	battle_anim NO_MOVE, SUBANIM_2_TRADE_BALL_APPEAR, 2, 6
	db -1 ; end

TradeBallPoofAnim:
	battle_anim NO_MOVE, SUBANIM_2_TRADE_BALL_POOF, 2, 6
	db -1 ; end

XStatItemAnim:
	battle_anim NO_MOVE, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_SPIRAL_BALLS_INWARD
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

ShrinkingSquareAnim:
	battle_anim NO_MOVE, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SUBANIM_0_CIRCLE_1_SQUARE_CLOSING, 1, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

XStatItemBlackAnim:
	battle_anim NO_MOVE, SE_DARKEN_MON_PALETTE
	battle_anim NO_MOVE, SE_SPIRAL_BALLS_INWARD
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

ShrinkingSquareBlackAnim:
	battle_anim NO_MOVE, SE_DARKEN_MON_PALETTE
	battle_anim NO_MOVE, SUBANIM_0_CIRCLE_1_SQUARE_CLOSING, 1, 6
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

UnusedAnim:
	battle_anim NO_MOVE, SE_LIGHT_SCREEN_PALETTE
	battle_anim NO_MOVE, SE_SHOOT_MANY_BALLS_UPWARD
	battle_anim NO_MOVE, SE_RESET_SCREEN_PALETTE
	db -1 ; end

ParalyzeAnim:
	battle_anim BIND, SUBANIM_0_STATUS_PARALYZED, 0, 4
	battle_anim BIND, SUBANIM_0_STATUS_PARALYZED, 0, 4
	db -1 ; end

PoisonAnim:
	battle_anim BIND, SUBANIM_0_STATUS_POISONED, 0, 8
	battle_anim BIND, SUBANIM_0_STATUS_POISONED, 0, 8
	db -1 ; end

SleepPlayerAnim:
	battle_anim REST, SUBANIM_0_STATUS_SLEEP, 0, 16
	battle_anim REST, SUBANIM_0_STATUS_SLEEP, 0, 16
	db -1 ; end

SleepEnemyAnim:
	battle_anim REST, SUBANIM_0_STATUS_SLEEP_ENEMY, 0, 16
	battle_anim REST, SUBANIM_0_STATUS_SLEEP_ENEMY, 0, 16
	db -1 ; end

ConfusedPlayerAnim:
	battle_anim AMNESIA, SUBANIM_0_STATUS_CONFUSED, 0, 8
	battle_anim AMNESIA, SUBANIM_0_STATUS_CONFUSED, 0, 8
	db -1 ; end

ConfusedEnemyAnim:
	battle_anim AMNESIA, SUBANIM_0_STATUS_CONFUSED_ENEMY, 0, 8
	battle_anim AMNESIA, SUBANIM_0_STATUS_CONFUSED_ENEMY, 0, 8
	db -1 ; end

BallBlockAnim:
	battle_anim NO_MOVE, SUBANIM_0_BALL_BLOCK, 0, 3
	db -1 ; end

SlideDownAnim:
	battle_anim DIG, SE_SLIDE_MON_DOWN
	db -1 ; end

ShakeScreenAnim:
	battle_anim NO_MOVE, SE_SHAKE_SCREEN
	db -1 ; end

ThrowRockAnim:
	battle_anim BARRAGE, SUBANIM_0_SAFARI_ROCK, 0, 3
	db -1 ; end

ThrowBaitAnim:
	battle_anim BARRAGE, SUBANIM_0_SAFARI_BAIT, 0, 3
	db -1 ; end
