#include "global.h"
#include "data2.h"
#include "constants/abilities.h"
#include "constants/items.h"
#include "constants/moves.h"
#include "constants/species.h"
#include "main.h"
#include "pokemon.h"
#include "random.h"
#include "overworld.h"
#include "sprite.h"
#include "string_util.h"
#include "trainer.h"
#include "text.h"
#include "ewram.h"
#include "util.h"

extern u16 gMoveToLearn;

static EWRAM_DATA u8 sLearningMoveTableID = 0;

u8 gPlayerPartyCount;
struct Pokemon gPlayerParty[6];
u8 gEnemyPartyCount;
struct Pokemon gEnemyParty[6];

const u16 gSpeciesToHoennPokedexNum[] = // Assigns all species to the Hoenn Dex Index (Summary No. for Hoenn Dex)
{
	         	                // SPECIES_NONE
	HOENN_DEX_BULBASAUR,       	// SPECIES_BULBASAUR
	HOENN_DEX_IVYSAUR,         	// SPECIES_IVYSAUR
	HOENN_DEX_VENUSAUR,        	// SPECIES_VENUSAUR
	HOENN_DEX_CHARMANDER,      	// SPECIES_CHARMANDER
	HOENN_DEX_CHARMELEON,      	// SPECIES_CHARMELEON
	HOENN_DEX_CHARIZARD,       	// SPECIES_CHARIZARD
	HOENN_DEX_SQUIRTLE,        	// SPECIES_SQUIRTLE
	HOENN_DEX_WARTORTLE,       	// SPECIES_WARTORTLE
	HOENN_DEX_BLASTOISE,       	// SPECIES_BLASTOISE
	HOENN_DEX_CATERPIE,        	// SPECIES_CATERPIE
	HOENN_DEX_METAPOD,         	// SPECIES_METAPOD
	HOENN_DEX_BUTTERFREE,      	// SPECIES_BUTTERFREE
	HOENN_DEX_WEEDLE,          	// SPECIES_WEEDLE
	HOENN_DEX_KAKUNA,          	// SPECIES_KAKUNA
	HOENN_DEX_BEEDRILL,        	// SPECIES_BEEDRILL
	HOENN_DEX_PIDGEY,          	// SPECIES_PIDGEY
	HOENN_DEX_PIDGEOTTO,       	// SPECIES_PIDGEOTTO
	HOENN_DEX_PIDGEOT,         	// SPECIES_PIDGEOT
	HOENN_DEX_RATTATA,         	// SPECIES_RATTATA
	HOENN_DEX_RATICATE,        	// SPECIES_RATICATE
	HOENN_DEX_SPEAROW,         	// SPECIES_SPEAROW
	HOENN_DEX_FEAROW,          	// SPECIES_FEAROW
	HOENN_DEX_EKANS,           	// SPECIES_EKANS
	HOENN_DEX_ARBOK,           	// SPECIES_ARBOK
	HOENN_DEX_PIKACHU,         	// SPECIES_PIKACHU
	HOENN_DEX_RAICHU,          	// SPECIES_RAICHU
	HOENN_DEX_SANDSHREW,       	// SPECIES_SANDSHREW
	HOENN_DEX_SANDSLASH,       	// SPECIES_SANDSLASH
	HOENN_DEX_NIDORAN_F,       	// SPECIES_NIDORAN_F
	HOENN_DEX_NIDORINA,        	// SPECIES_NIDORINA
	HOENN_DEX_NIDOQUEEN,       	// SPECIES_NIDOQUEEN
	HOENN_DEX_NIDORAN_M,       	// SPECIES_NIDORAN_M
	HOENN_DEX_NIDORINO,        	// SPECIES_NIDORINO
	HOENN_DEX_NIDOKING,        	// SPECIES_NIDOKING
	HOENN_DEX_CLEFAIRY,        	// SPECIES_CLEFAIRY
	HOENN_DEX_CLEFABLE,        	// SPECIES_CLEFABLE
	HOENN_DEX_VULPIX,          	// SPECIES_VULPIX
	HOENN_DEX_NINETALES,       	// SPECIES_NINETALES
	HOENN_DEX_JIGGLYPUFF,      	// SPECIES_JIGGLYPUFF
	HOENN_DEX_WIGGLYTUFF,      	// SPECIES_WIGGLYTUFF
	HOENN_DEX_ZUBAT,           	// SPECIES_ZUBAT
	HOENN_DEX_GOLBAT,          	// SPECIES_GOLBAT
	HOENN_DEX_ODDISH,          	// SPECIES_ODDISH
	HOENN_DEX_GLOOM,           	// SPECIES_GLOOM
	HOENN_DEX_VILEPLUME,       	// SPECIES_VILEPLUME
	HOENN_DEX_PARAS,           	// SPECIES_PARAS
	HOENN_DEX_PARASECT,        	// SPECIES_PARASECT
	HOENN_DEX_VENONAT,         	// SPECIES_VENONAT
	HOENN_DEX_VENOMOTH,        	// SPECIES_VENOMOTH
	HOENN_DEX_DIGLETT,         	// SPECIES_DIGLETT
	HOENN_DEX_DUGTRIO,         	// SPECIES_DUGTRIO
	HOENN_DEX_MEOWTH,          	// SPECIES_MEOWTH
	HOENN_DEX_PERSIAN,         	// SPECIES_PERSIAN
	HOENN_DEX_PSYDUCK,         	// SPECIES_PSYDUCK
	HOENN_DEX_GOLDUCK,         	// SPECIES_GOLDUCK
	HOENN_DEX_MANKEY,          	// SPECIES_MANKEY
	HOENN_DEX_PRIMEAPE,        	// SPECIES_PRIMEAPE
	HOENN_DEX_GROWLITHE,       	// SPECIES_GROWLITHE
	HOENN_DEX_ARCANINE,        	// SPECIES_ARCANINE
	HOENN_DEX_POLIWAG,         	// SPECIES_POLIWAG
	HOENN_DEX_POLIWHIRL,       	// SPECIES_POLIWHIRL
	HOENN_DEX_POLIWRATH,       	// SPECIES_POLIWRATH
	HOENN_DEX_ABRA,            	// SPECIES_ABRA
	HOENN_DEX_KADABRA,         	// SPECIES_KADABRA
	HOENN_DEX_ALAKAZAM,        	// SPECIES_ALAKAZAM
	HOENN_DEX_MACHOP,          	// SPECIES_MACHOP
	HOENN_DEX_MACHOKE,         	// SPECIES_MACHOKE
	HOENN_DEX_MACHAMP,         	// SPECIES_MACHAMP
	HOENN_DEX_BELLSPROUT,      	// SPECIES_BELLSPROUT
	HOENN_DEX_WEEPINBELL,      	// SPECIES_WEEPINBELL
	HOENN_DEX_VICTREEBEL,      	// SPECIES_VICTREEBEL
	HOENN_DEX_TENTACOOL,       	// SPECIES_TENTACOOL
	HOENN_DEX_TENTACRUEL,      	// SPECIES_TENTACRUEL
	HOENN_DEX_GEODUDE,         	// SPECIES_GEODUDE
	HOENN_DEX_GRAVELER,        	// SPECIES_GRAVELER
	HOENN_DEX_GOLEM,           	// SPECIES_GOLEM
	HOENN_DEX_PONYTA,          	// SPECIES_PONYTA
	HOENN_DEX_RAPIDASH,        	// SPECIES_RAPIDASH
	HOENN_DEX_SLOWPOKE,        	// SPECIES_SLOWPOKE
	HOENN_DEX_SLOWBRO,         	// SPECIES_SLOWBRO
	HOENN_DEX_MAGNEMITE,       	// SPECIES_MAGNEMITE
	HOENN_DEX_MAGNETON,        	// SPECIES_MAGNETON
	HOENN_DEX_FARFETCHD,       	// SPECIES_FARFETCHD
	HOENN_DEX_DODUO,           	// SPECIES_DODUO
	HOENN_DEX_DODRIO,          	// SPECIES_DODRIO
	HOENN_DEX_SEEL,            	// SPECIES_SEEL
	HOENN_DEX_DEWGONG,         	// SPECIES_DEWGONG
	HOENN_DEX_GRIMER,          	// SPECIES_GRIMER
	HOENN_DEX_MUK,             	// SPECIES_MUK
	HOENN_DEX_SHELLDER,        	// SPECIES_SHELLDER
	HOENN_DEX_CLOYSTER,        	// SPECIES_CLOYSTER
	HOENN_DEX_GASTLY,          	// SPECIES_GASTLY
	HOENN_DEX_HAUNTER,         	// SPECIES_HAUNTER
	HOENN_DEX_GENGAR,          	// SPECIES_GENGAR
	HOENN_DEX_ONIX,            	// SPECIES_ONIX
	HOENN_DEX_DROWZEE,         	// SPECIES_DROWZEE
	HOENN_DEX_HYPNO,           	// SPECIES_HYPNO
	HOENN_DEX_KRABBY,          	// SPECIES_KRABBY
	HOENN_DEX_KINGLER,         	// SPECIES_KINGLER
	HOENN_DEX_VOLTORB,         	// SPECIES_VOLTORB
	HOENN_DEX_ELECTRODE,       	// SPECIES_ELECTRODE
	HOENN_DEX_EXEGGCUTE,       	// SPECIES_EXEGGCUTE
	HOENN_DEX_EXEGGUTOR,       	// SPECIES_EXEGGUTOR
	HOENN_DEX_CUBONE,          	// SPECIES_CUBONE
	HOENN_DEX_MAROWAK,         	// SPECIES_MAROWAK
	HOENN_DEX_HITMONLEE,       	// SPECIES_HITMONLEE
	HOENN_DEX_HITMONCHAN,      	// SPECIES_HITMONCHAN
	HOENN_DEX_LICKITUNG,       	// SPECIES_LICKITUNG
	HOENN_DEX_KOFFING,         	// SPECIES_KOFFING
	HOENN_DEX_WEEZING,         	// SPECIES_WEEZING
	HOENN_DEX_RHYHORN,         	// SPECIES_RHYHORN
	HOENN_DEX_RHYDON,          	// SPECIES_RHYDON
	HOENN_DEX_CHANSEY,         	// SPECIES_CHANSEY
	HOENN_DEX_TANGELA,         	// SPECIES_TANGELA
	HOENN_DEX_KANGASKHAN,      	// SPECIES_KANGASKHAN
	HOENN_DEX_HORSEA,          	// SPECIES_HORSEA
	HOENN_DEX_SEADRA,          	// SPECIES_SEADRA
	HOENN_DEX_GOLDEEN,         	// SPECIES_GOLDEEN
	HOENN_DEX_SEAKING,         	// SPECIES_SEAKING
	HOENN_DEX_STARYU,          	// SPECIES_STARYU
	HOENN_DEX_STARMIE,         	// SPECIES_STARMIE
	HOENN_DEX_MR_MIME,         	// SPECIES_MR_MIME
	HOENN_DEX_SCYTHER,         	// SPECIES_SCYTHER
	HOENN_DEX_JYNX,            	// SPECIES_JYNX
	HOENN_DEX_ELECTABUZZ,      	// SPECIES_ELECTABUZZ
	HOENN_DEX_MAGMAR,          	// SPECIES_MAGMAR
	HOENN_DEX_PINSIR,          	// SPECIES_PINSIR
	HOENN_DEX_TAUROS,          	// SPECIES_TAUROS
	HOENN_DEX_MAGIKARP,        	// SPECIES_MAGIKARP
	HOENN_DEX_GYARADOS,        	// SPECIES_GYARADOS
	HOENN_DEX_LAPRAS,          	// SPECIES_LAPRAS
	HOENN_DEX_DITTO,           	// SPECIES_DITTO
	HOENN_DEX_EEVEE,           	// SPECIES_EEVEE
	HOENN_DEX_VAPOREON,        	// SPECIES_VAPOREON
	HOENN_DEX_JOLTEON,         	// SPECIES_JOLTEON
	HOENN_DEX_FLAREON,         	// SPECIES_FLAREON
	HOENN_DEX_PORYGON,         	// SPECIES_PORYGON
	HOENN_DEX_OMANYTE,         	// SPECIES_OMANYTE
	HOENN_DEX_OMASTAR,         	// SPECIES_OMASTAR
	HOENN_DEX_KABUTO,          	// SPECIES_KABUTO
	HOENN_DEX_KABUTOPS,        	// SPECIES_KABUTOPS
	HOENN_DEX_AERODACTYL,      	// SPECIES_AERODACTYL
	HOENN_DEX_SNORLAX,         	// SPECIES_SNORLAX
	HOENN_DEX_ARTICUNO,        	// SPECIES_ARTICUNO
	HOENN_DEX_ZAPDOS,          	// SPECIES_ZAPDOS
	HOENN_DEX_MOLTRES,         	// SPECIES_MOLTRES
	HOENN_DEX_DRATINI,         	// SPECIES_DRATINI
	HOENN_DEX_DRAGONAIR,       	// SPECIES_DRAGONAIR
	HOENN_DEX_DRAGONITE,       	// SPECIES_DRAGONITE
	HOENN_DEX_MEWTWO,          	// SPECIES_MEWTWO
	HOENN_DEX_MEW,             	// SPECIES_MEW
	HOENN_DEX_CHIKORITA,       	// SPECIES_CHIKORITA
	HOENN_DEX_BAYLEEF,         	// SPECIES_BAYLEEF
	HOENN_DEX_MEGANIUM,        	// SPECIES_MEGANIUM
	HOENN_DEX_CYNDAQUIL,       	// SPECIES_CYNDAQUIL
	HOENN_DEX_QUILAVA,         	// SPECIES_QUILAVA
	HOENN_DEX_TYPHLOSION,      	// SPECIES_TYPHLOSION
	HOENN_DEX_TOTODILE,        	// SPECIES_TOTODILE
	HOENN_DEX_CROCONAW,        	// SPECIES_CROCONAW
	HOENN_DEX_FERALIGATR,      	// SPECIES_FERALIGATR
	HOENN_DEX_SENTRET,         	// SPECIES_SENTRET
	HOENN_DEX_FURRET,          	// SPECIES_FURRET
	HOENN_DEX_HOOTHOOT,        	// SPECIES_HOOTHOOT
	HOENN_DEX_NOCTOWL,         	// SPECIES_NOCTOWL
	HOENN_DEX_LEDYBA,          	// SPECIES_LEDYBA
	HOENN_DEX_LEDIAN,          	// SPECIES_LEDIAN
	HOENN_DEX_SPINARAK,        	// SPECIES_SPINARAK
	HOENN_DEX_ARIADOS,         	// SPECIES_ARIADOS
	HOENN_DEX_CROBAT,          	// SPECIES_CROBAT
	HOENN_DEX_CHINCHOU,        	// SPECIES_CHINCHOU
	HOENN_DEX_LANTURN,         	// SPECIES_LANTURN
	HOENN_DEX_PICHU,           	// SPECIES_PICHU
	HOENN_DEX_CLEFFA,          	// SPECIES_CLEFFA
	HOENN_DEX_IGGLYBUFF,       	// SPECIES_IGGLYBUFF
	HOENN_DEX_TOGEPI,          	// SPECIES_TOGEPI
	HOENN_DEX_TOGETIC,         	// SPECIES_TOGETIC
	HOENN_DEX_NATU,            	// SPECIES_NATU
	HOENN_DEX_XATU,            	// SPECIES_XATU
	HOENN_DEX_MAREEP,          	// SPECIES_MAREEP
	HOENN_DEX_FLAAFFY,         	// SPECIES_FLAAFFY
	HOENN_DEX_AMPHAROS,        	// SPECIES_AMPHAROS
	HOENN_DEX_BELLOSSOM,       	// SPECIES_BELLOSSOM
	HOENN_DEX_MARILL,          	// SPECIES_MARILL
	HOENN_DEX_AZUMARILL,       	// SPECIES_AZUMARILL
	HOENN_DEX_SUDOWOODO,       	// SPECIES_SUDOWOODO
	HOENN_DEX_POLITOED,        	// SPECIES_POLITOED
	HOENN_DEX_HOPPIP,          	// SPECIES_HOPPIP
	HOENN_DEX_SKIPLOOM,        	// SPECIES_SKIPLOOM
	HOENN_DEX_JUMPLUFF,        	// SPECIES_JUMPLUFF
	HOENN_DEX_AIPOM,           	// SPECIES_AIPOM
	HOENN_DEX_SUNKERN,         	// SPECIES_SUNKERN
	HOENN_DEX_SUNFLORA,        	// SPECIES_SUNFLORA
	HOENN_DEX_YANMA,           	// SPECIES_YANMA
	HOENN_DEX_WOOPER,          	// SPECIES_WOOPER
	HOENN_DEX_QUAGSIRE,        	// SPECIES_QUAGSIRE
	HOENN_DEX_ESPEON,          	// SPECIES_ESPEON
	HOENN_DEX_UMBREON,         	// SPECIES_UMBREON
	HOENN_DEX_MURKROW,         	// SPECIES_MURKROW
	HOENN_DEX_SLOWKING,        	// SPECIES_SLOWKING
	HOENN_DEX_MISDREAVUS,      	// SPECIES_MISDREAVUS
	HOENN_DEX_UNOWN,           	// SPECIES_UNOWN
	HOENN_DEX_WOBBUFFET,       	// SPECIES_WOBBUFFET
	HOENN_DEX_GIRAFARIG,       	// SPECIES_GIRAFARIG
	HOENN_DEX_PINECO,          	// SPECIES_PINECO
	HOENN_DEX_FORRETRESS,      	// SPECIES_FORRETRESS
	HOENN_DEX_DUNSPARCE,       	// SPECIES_DUNSPARCE
	HOENN_DEX_GLIGAR,          	// SPECIES_GLIGAR
	HOENN_DEX_STEELIX,         	// SPECIES_STEELIX
	HOENN_DEX_SNUBBULL,        	// SPECIES_SNUBBULL
	HOENN_DEX_GRANBULL,        	// SPECIES_GRANBULL
	HOENN_DEX_QWILFISH,        	// SPECIES_QWILFISH
	HOENN_DEX_SCIZOR,          	// SPECIES_SCIZOR
	HOENN_DEX_SHUCKLE,         	// SPECIES_SHUCKLE
	HOENN_DEX_HERACROSS,       	// SPECIES_HERACROSS
	HOENN_DEX_SNEASEL,         	// SPECIES_SNEASEL
	HOENN_DEX_TEDDIURSA,       	// SPECIES_TEDDIURSA
	HOENN_DEX_URSARING,        	// SPECIES_URSARING
	HOENN_DEX_SLUGMA,          	// SPECIES_SLUGMA
	HOENN_DEX_MAGCARGO,        	// SPECIES_MAGCARGO
	HOENN_DEX_SWINUB,          	// SPECIES_SWINUB
	HOENN_DEX_PILOSWINE,       	// SPECIES_PILOSWINE
	HOENN_DEX_CORSOLA,         	// SPECIES_CORSOLA
	HOENN_DEX_REMORAID,        	// SPECIES_REMORAID
	HOENN_DEX_OCTILLERY,       	// SPECIES_OCTILLERY
	HOENN_DEX_DELIBIRD,        	// SPECIES_DELIBIRD
	HOENN_DEX_MANTINE,         	// SPECIES_MANTINE
	HOENN_DEX_SKARMORY,        	// SPECIES_SKARMORY
	HOENN_DEX_HOUNDOUR,        	// SPECIES_HOUNDOUR
	HOENN_DEX_HOUNDOOM,        	// SPECIES_HOUNDOOM
	HOENN_DEX_KINGDRA,         	// SPECIES_KINGDRA
	HOENN_DEX_PHANPY,          	// SPECIES_PHANPY
	HOENN_DEX_DONPHAN,         	// SPECIES_DONPHAN
	HOENN_DEX_PORYGON2,        	// SPECIES_PORYGON2
	HOENN_DEX_STANTLER,        	// SPECIES_STANTLER
	HOENN_DEX_SMEARGLE,        	// SPECIES_SMEARGLE
	HOENN_DEX_TYROGUE,         	// SPECIES_TYROGUE
	HOENN_DEX_HITMONTOP,       	// SPECIES_HITMONTOP
	HOENN_DEX_SMOOCHUM,        	// SPECIES_SMOOCHUM
	HOENN_DEX_ELEKID,          	// SPECIES_ELEKID
	HOENN_DEX_MAGBY,           	// SPECIES_MAGBY
	HOENN_DEX_MILTANK,         	// SPECIES_MILTANK
	HOENN_DEX_BLISSEY,         	// SPECIES_BLISSEY
	HOENN_DEX_RAIKOU,          	// SPECIES_RAIKOU
	HOENN_DEX_ENTEI,           	// SPECIES_ENTEI
	HOENN_DEX_SUICUNE,         	// SPECIES_SUICUNE
	HOENN_DEX_LARVITAR,        	// SPECIES_LARVITAR
	HOENN_DEX_PUPITAR,         	// SPECIES_PUPITAR
	HOENN_DEX_TYRANITAR,       	// SPECIES_TYRANITAR
	HOENN_DEX_LUGIA,           	// SPECIES_LUGIA
	HOENN_DEX_HO_OH,           	// SPECIES_HO-OH
	HOENN_DEX_CELEBI,          	// SPECIES_CELEBI
	HOENN_DEX_OLD_UNOWN_B,     	// SPECIES_OLD_UNOWN_B
	HOENN_DEX_OLD_UNOWN_C,     	// SPECIES_OLD_UNOWN_C
	HOENN_DEX_OLD_UNOWN_D,     	// SPECIES_OLD_UNOWN_D
	HOENN_DEX_OLD_UNOWN_E,     	// SPECIES_OLD_UNOWN_E
	HOENN_DEX_OLD_UNOWN_F,     	// SPECIES_OLD_UNOWN_F
	HOENN_DEX_OLD_UNOWN_G,     	// SPECIES_OLD_UNOWN_G
	HOENN_DEX_OLD_UNOWN_H,     	// SPECIES_OLD_UNOWN_H
	HOENN_DEX_OLD_UNOWN_I,     	// SPECIES_OLD_UNOWN_I
	HOENN_DEX_OLD_UNOWN_J,     	// SPECIES_OLD_UNOWN_J
	HOENN_DEX_OLD_UNOWN_K,     	// SPECIES_OLD_UNOWN_K
	HOENN_DEX_OLD_UNOWN_L,     	// SPECIES_OLD_UNOWN_L
	HOENN_DEX_OLD_UNOWN_M,     	// SPECIES_OLD_UNOWN_M
	HOENN_DEX_OLD_UNOWN_N,     	// SPECIES_OLD_UNOWN_N
	HOENN_DEX_OLD_UNOWN_O,     	// SPECIES_OLD_UNOWN_O
	HOENN_DEX_OLD_UNOWN_P,     	// SPECIES_OLD_UNOWN_P
	HOENN_DEX_OLD_UNOWN_Q,     	// SPECIES_OLD_UNOWN_Q
	HOENN_DEX_OLD_UNOWN_R,     	// SPECIES_OLD_UNOWN_R
	HOENN_DEX_OLD_UNOWN_S,     	// SPECIES_OLD_UNOWN_S
	HOENN_DEX_OLD_UNOWN_T,     	// SPECIES_OLD_UNOWN_T
	HOENN_DEX_OLD_UNOWN_U,     	// SPECIES_OLD_UNOWN_U
	HOENN_DEX_OLD_UNOWN_V,     	// SPECIES_OLD_UNOWN_V
	HOENN_DEX_OLD_UNOWN_W,     	// SPECIES_OLD_UNOWN_W
	HOENN_DEX_OLD_UNOWN_X,     	// SPECIES_OLD_UNOWN_X
	HOENN_DEX_OLD_UNOWN_Y,     	// SPECIES_OLD_UNOWN_Y
	HOENN_DEX_OLD_UNOWN_Z,     	// SPECIES_OLD_UNOWN_Z
	HOENN_DEX_TREECKO,         	// SPECIES_TREECKO
	HOENN_DEX_GROVYLE,         	// SPECIES_GROVYLE
	HOENN_DEX_SCEPTILE,        	// SPECIES_SCEPTILE
	HOENN_DEX_TORCHIC,         	// SPECIES_TORCHIC
	HOENN_DEX_COMBUSKEN,       	// SPECIES_COMBUSKEN
	HOENN_DEX_BLAZIKEN,        	// SPECIES_BLAZIKEN
	HOENN_DEX_MUDKIP,          	// SPECIES_MUDKIP
	HOENN_DEX_MARSHTOMP,       	// SPECIES_MARSHTOMP
	HOENN_DEX_SWAMPERT,        	// SPECIES_SWAMPERT
	HOENN_DEX_POOCHYENA,       	// SPECIES_POOCHYENA
	HOENN_DEX_MIGHTYENA,       	// SPECIES_MIGHTYENA
	HOENN_DEX_ZIGZAGOON,       	// SPECIES_ZIGZAGOON
	HOENN_DEX_LINOONE,         	// SPECIES_LINOONE
	HOENN_DEX_WURMPLE,         	// SPECIES_WURMPLE
	HOENN_DEX_SILCOON,         	// SPECIES_SILCOON
	HOENN_DEX_BEAUTIFLY,       	// SPECIES_BEAUTIFLY
	HOENN_DEX_CASCOON,         	// SPECIES_CASCOON
	HOENN_DEX_DUSTOX,          	// SPECIES_DUSTOX
	HOENN_DEX_LOTAD,           	// SPECIES_LOTAD
	HOENN_DEX_LOMBRE,          	// SPECIES_LOMBRE
	HOENN_DEX_LUDICOLO,        	// SPECIES_LUDICOLO
	HOENN_DEX_SEEDOT,          	// SPECIES_SEEDOT
	HOENN_DEX_NUZLEAF,         	// SPECIES_NUZLEAF
	HOENN_DEX_SHIFTRY,         	// SPECIES_SHIFTRY
	HOENN_DEX_NINCADA,         	// SPECIES_NINCADA
	HOENN_DEX_NINJASK,         	// SPECIES_NINJASK
	HOENN_DEX_SHEDINJA,        	// SPECIES_SHEDINJA
	HOENN_DEX_TAILLOW,         	// SPECIES_TAILLOW
	HOENN_DEX_SWELLOW,         	// SPECIES_SWELLOW
	HOENN_DEX_SHROOMISH,       	// SPECIES_SHROOMISH
	HOENN_DEX_BRELOOM,         	// SPECIES_BRELOOM
	HOENN_DEX_SPINDA,          	// SPECIES_SPINDA
	HOENN_DEX_WINGULL,         	// SPECIES_WINGULL
	HOENN_DEX_PELIPPER,        	// SPECIES_PELIPPER
	HOENN_DEX_SURSKIT,         	// SPECIES_SURSKIT
	HOENN_DEX_MASQUERAIN,      	// SPECIES_MASQUERAIN
	HOENN_DEX_WAILMER,         	// SPECIES_WAILMER
	HOENN_DEX_WAILORD,         	// SPECIES_WAILORD
	HOENN_DEX_SKITTY,          	// SPECIES_SKITTY
	HOENN_DEX_DELCATTY,        	// SPECIES_DELCATTY
	HOENN_DEX_KECLEON,         	// SPECIES_KECLEON
	HOENN_DEX_BALTOY,          	// SPECIES_BALTOY
	HOENN_DEX_CLAYDOL,         	// SPECIES_CLAYDOL
	HOENN_DEX_NOSEPASS,        	// SPECIES_NOSEPASS
	HOENN_DEX_TORKOAL,         	// SPECIES_TORKOAL
	HOENN_DEX_SABLEYE,         	// SPECIES_SABLEYE
	HOENN_DEX_BARBOACH,        	// SPECIES_BARBOACH
	HOENN_DEX_WHISCASH,        	// SPECIES_WHISCASH
	HOENN_DEX_LUVDISC,         	// SPECIES_LUVDISC
	HOENN_DEX_CORPHISH,        	// SPECIES_CORPHISH
	HOENN_DEX_CRAWDAUNT,       	// SPECIES_CRAWDAUNT
	HOENN_DEX_FEEBAS,          	// SPECIES_FEEBAS
	HOENN_DEX_MILOTIC,         	// SPECIES_MILOTIC
	HOENN_DEX_CARVANHA,        	// SPECIES_CARVANHA
	HOENN_DEX_SHARPEDO,        	// SPECIES_SHARPEDO
	HOENN_DEX_TRAPINCH,        	// SPECIES_TRAPINCH
	HOENN_DEX_VIBRAVA,         	// SPECIES_VIBRAVA
	HOENN_DEX_FLYGON,          	// SPECIES_FLYGON
	HOENN_DEX_MAKUHITA,        	// SPECIES_MAKUHITA
	HOENN_DEX_HARIYAMA,        	// SPECIES_HARIYAMA
	HOENN_DEX_ELECTRIKE,       	// SPECIES_ELECTRIKE
	HOENN_DEX_MANECTRIC,       	// SPECIES_MANECTRIC
	HOENN_DEX_NUMEL,           	// SPECIES_NUMEL
	HOENN_DEX_CAMERUPT,        	// SPECIES_CAMERUPT
	HOENN_DEX_SPHEAL,          	// SPECIES_SPHEAL
	HOENN_DEX_SEALEO,          	// SPECIES_SEALEO
	HOENN_DEX_WALREIN,         	// SPECIES_WALREIN
	HOENN_DEX_CACNEA,          	// SPECIES_CACNEA
	HOENN_DEX_CACTURNE,        	// SPECIES_CACTURNE
	HOENN_DEX_SNORUNT,         	// SPECIES_SNORUNT
	HOENN_DEX_GLALIE,          	// SPECIES_GLALIE
	HOENN_DEX_LUNATONE,        	// SPECIES_LUNATONE
	HOENN_DEX_SOLROCK,         	// SPECIES_SOLROCK
	HOENN_DEX_AZURILL,         	// SPECIES_AZURILL
	HOENN_DEX_SPOINK,          	// SPECIES_SPOINK
	HOENN_DEX_GRUMPIG,         	// SPECIES_GRUMPIG
	HOENN_DEX_PLUSLE,          	// SPECIES_PLUSLE
	HOENN_DEX_MINUN,           	// SPECIES_MINUN
	HOENN_DEX_MAWILE,          	// SPECIES_MAWILE
	HOENN_DEX_MEDITITE,        	// SPECIES_MEDITITE
	HOENN_DEX_MEDICHAM,        	// SPECIES_MEDICHAM
	HOENN_DEX_SWABLU,          	// SPECIES_SWABLU
	HOENN_DEX_ALTARIA,         	// SPECIES_ALTARIA
	HOENN_DEX_WYNAUT,          	// SPECIES_WYNAUT
	HOENN_DEX_DUSKULL,         	// SPECIES_DUSKULL
	HOENN_DEX_DUSCLOPS,        	// SPECIES_DUSCLOPS
	HOENN_DEX_ROSELIA,         	// SPECIES_ROSELIA
	HOENN_DEX_SLAKOTH,         	// SPECIES_SLAKOTH
	HOENN_DEX_VIGOROTH,        	// SPECIES_VIGOROTH
	HOENN_DEX_SLAKING,         	// SPECIES_SLAKING
	HOENN_DEX_GULPIN,          	// SPECIES_GULPIN
	HOENN_DEX_SWALOT,          	// SPECIES_SWALOT
	HOENN_DEX_TROPIUS,         	// SPECIES_TROPIUS
	HOENN_DEX_WHISMUR,         	// SPECIES_WHISMUR
	HOENN_DEX_LOUDRED,         	// SPECIES_LOUDRED
	HOENN_DEX_EXPLOUD,         	// SPECIES_EXPLOUD
	HOENN_DEX_CLAMPERL,        	// SPECIES_CLAMPERL
	HOENN_DEX_HUNTAIL,         	// SPECIES_HUNTAIL
	HOENN_DEX_GOREBYSS,        	// SPECIES_GOREBYSS
	HOENN_DEX_ABSOL,           	// SPECIES_ABSOL
	HOENN_DEX_SHUPPET,         	// SPECIES_SHUPPET
	HOENN_DEX_BANETTE,         	// SPECIES_BANETTE
	HOENN_DEX_SEVIPER,         	// SPECIES_SEVIPER
	HOENN_DEX_ZANGOOSE,        	// SPECIES_ZANGOOSE
	HOENN_DEX_RELICANTH,       	// SPECIES_RELICANTH
	HOENN_DEX_ARON,            	// SPECIES_ARON
	HOENN_DEX_LAIRON,          	// SPECIES_LAIRON
	HOENN_DEX_AGGRON,          	// SPECIES_AGGRON
	HOENN_DEX_CASTFORM,        	// SPECIES_CASTFORM
	HOENN_DEX_VOLBEAT,         	// SPECIES_VOLBEAT
	HOENN_DEX_ILLUMISE,        	// SPECIES_ILLUMISE
	HOENN_DEX_LILEEP,          	// SPECIES_LILEEP
	HOENN_DEX_CRADILY,         	// SPECIES_CRADILY
	HOENN_DEX_ANORITH,         	// SPECIES_ANORITH
	HOENN_DEX_ARMALDO,         	// SPECIES_ARMALDO
	HOENN_DEX_RALTS,           	// SPECIES_RALTS
	HOENN_DEX_KIRLIA,          	// SPECIES_KIRLIA
	HOENN_DEX_GARDEVOIR,       	// SPECIES_GARDEVOIR
	HOENN_DEX_BAGON,           	// SPECIES_BAGON
	HOENN_DEX_SHELGON,         	// SPECIES_SHELGON
	HOENN_DEX_SALAMENCE,       	// SPECIES_SALAMENCE
	HOENN_DEX_BELDUM,          	// SPECIES_BELDUM
	HOENN_DEX_METANG,          	// SPECIES_METANG
	HOENN_DEX_METAGROSS,       	// SPECIES_METAGROSS
	HOENN_DEX_REGIROCK,        	// SPECIES_REGIROCK
	HOENN_DEX_REGICE,          	// SPECIES_REGICE
	HOENN_DEX_REGISTEEL,       	// SPECIES_REGISTEEL
	HOENN_DEX_KYOGRE,          	// SPECIES_KYOGRE
	HOENN_DEX_GROUDON,         	// SPECIES_GROUDON
	HOENN_DEX_RAYQUAZA,        	// SPECIES_RAYQUAZA
	HOENN_DEX_LATIAS,          	// SPECIES_LATIAS
	HOENN_DEX_LATIOS,          	// SPECIES_LATIOS
	HOENN_DEX_JIRACHI,         	// SPECIES_JIRACHI
	HOENN_DEX_DEOXYS,          	// SPECIES_DEOXYS
	HOENN_DEX_CHIMECHO         	// SPECIES_CHIMECHO
};

const u16 gSpeciesToNationalPokedexNum[] = // Assigns all species to the National Dex Index (Summary No. for National Dex)
{
	         	                // SPECIES_NONE
	NATIONAL_DEX_BULBASAUR,       	// SPECIES_BULBASAUR
	NATIONAL_DEX_IVYSAUR,         	// SPECIES_IVYSAUR
	NATIONAL_DEX_VENUSAUR,        	// SPECIES_VENUSAUR
	NATIONAL_DEX_CHARMANDER,      	// SPECIES_CHARMANDER
	NATIONAL_DEX_CHARMELEON,      	// SPECIES_CHARMELEON
	NATIONAL_DEX_CHARIZARD,       	// SPECIES_CHARIZARD
	NATIONAL_DEX_SQUIRTLE,        	// SPECIES_SQUIRTLE
	NATIONAL_DEX_WARTORTLE,       	// SPECIES_WARTORTLE
	NATIONAL_DEX_BLASTOISE,       	// SPECIES_BLASTOISE
	NATIONAL_DEX_CATERPIE,        	// SPECIES_CATERPIE
	NATIONAL_DEX_METAPOD,         	// SPECIES_METAPOD
	NATIONAL_DEX_BUTTERFREE,      	// SPECIES_BUTTERFREE
	NATIONAL_DEX_WEEDLE,          	// SPECIES_WEEDLE
	NATIONAL_DEX_KAKUNA,          	// SPECIES_KAKUNA
	NATIONAL_DEX_BEEDRILL,        	// SPECIES_BEEDRILL
	NATIONAL_DEX_PIDGEY,          	// SPECIES_PIDGEY
	NATIONAL_DEX_PIDGEOTTO,       	// SPECIES_PIDGEOTTO
	NATIONAL_DEX_PIDGEOT,         	// SPECIES_PIDGEOT
	NATIONAL_DEX_RATTATA,         	// SPECIES_RATTATA
	NATIONAL_DEX_RATICATE,        	// SPECIES_RATICATE
	NATIONAL_DEX_SPEAROW,         	// SPECIES_SPEAROW
	NATIONAL_DEX_FEAROW,          	// SPECIES_FEAROW
	NATIONAL_DEX_EKANS,           	// SPECIES_EKANS
	NATIONAL_DEX_ARBOK,           	// SPECIES_ARBOK
	NATIONAL_DEX_PIKACHU,         	// SPECIES_PIKACHU
	NATIONAL_DEX_RAICHU,          	// SPECIES_RAICHU
	NATIONAL_DEX_SANDSHREW,       	// SPECIES_SANDSHREW
	NATIONAL_DEX_SANDSLASH,       	// SPECIES_SANDSLASH
	NATIONAL_DEX_NIDORAN_F,       	// SPECIES_NIDORAN_F
	NATIONAL_DEX_NIDORINA,        	// SPECIES_NIDORINA
	NATIONAL_DEX_NIDOQUEEN,       	// SPECIES_NIDOQUEEN
	NATIONAL_DEX_NIDORAN_M,       	// SPECIES_NIDORAN_M
	NATIONAL_DEX_NIDORINO,        	// SPECIES_NIDORINO
	NATIONAL_DEX_NIDOKING,        	// SPECIES_NIDOKING
	NATIONAL_DEX_CLEFAIRY,        	// SPECIES_CLEFAIRY
	NATIONAL_DEX_CLEFABLE,        	// SPECIES_CLEFABLE
	NATIONAL_DEX_VULPIX,          	// SPECIES_VULPIX
	NATIONAL_DEX_NINETALES,       	// SPECIES_NINETALES
	NATIONAL_DEX_JIGGLYPUFF,      	// SPECIES_JIGGLYPUFF
	NATIONAL_DEX_WIGGLYTUFF,      	// SPECIES_WIGGLYTUFF
	NATIONAL_DEX_ZUBAT,           	// SPECIES_ZUBAT
	NATIONAL_DEX_GOLBAT,          	// SPECIES_GOLBAT
	NATIONAL_DEX_ODDISH,          	// SPECIES_ODDISH
	NATIONAL_DEX_GLOOM,           	// SPECIES_GLOOM
	NATIONAL_DEX_VILEPLUME,       	// SPECIES_VILEPLUME
	NATIONAL_DEX_PARAS,           	// SPECIES_PARAS
	NATIONAL_DEX_PARASECT,        	// SPECIES_PARASECT
	NATIONAL_DEX_VENONAT,         	// SPECIES_VENONAT
	NATIONAL_DEX_VENOMOTH,        	// SPECIES_VENOMOTH
	NATIONAL_DEX_DIGLETT,         	// SPECIES_DIGLETT
	NATIONAL_DEX_DUGTRIO,         	// SPECIES_DUGTRIO
	NATIONAL_DEX_MEOWTH,          	// SPECIES_MEOWTH
	NATIONAL_DEX_PERSIAN,         	// SPECIES_PERSIAN
	NATIONAL_DEX_PSYDUCK,         	// SPECIES_PSYDUCK
	NATIONAL_DEX_GOLDUCK,         	// SPECIES_GOLDUCK
	NATIONAL_DEX_MANKEY,          	// SPECIES_MANKEY
	NATIONAL_DEX_PRIMEAPE,        	// SPECIES_PRIMEAPE
	NATIONAL_DEX_GROWLITHE,       	// SPECIES_GROWLITHE
	NATIONAL_DEX_ARCANINE,        	// SPECIES_ARCANINE
	NATIONAL_DEX_POLIWAG,         	// SPECIES_POLIWAG
	NATIONAL_DEX_POLIWHIRL,       	// SPECIES_POLIWHIRL
	NATIONAL_DEX_POLIWRATH,       	// SPECIES_POLIWRATH
	NATIONAL_DEX_ABRA,            	// SPECIES_ABRA
	NATIONAL_DEX_KADABRA,         	// SPECIES_KADABRA
	NATIONAL_DEX_ALAKAZAM,        	// SPECIES_ALAKAZAM
	NATIONAL_DEX_MACHOP,          	// SPECIES_MACHOP
	NATIONAL_DEX_MACHOKE,         	// SPECIES_MACHOKE
	NATIONAL_DEX_MACHAMP,         	// SPECIES_MACHAMP
	NATIONAL_DEX_BELLSPROUT,      	// SPECIES_BELLSPROUT
	NATIONAL_DEX_WEEPINBELL,      	// SPECIES_WEEPINBELL
	NATIONAL_DEX_VICTREEBEL,      	// SPECIES_VICTREEBEL
	NATIONAL_DEX_TENTACOOL,       	// SPECIES_TENTACOOL
	NATIONAL_DEX_TENTACRUEL,      	// SPECIES_TENTACRUEL
	NATIONAL_DEX_GEODUDE,         	// SPECIES_GEODUDE
	NATIONAL_DEX_GRAVELER,        	// SPECIES_GRAVELER
	NATIONAL_DEX_GOLEM,           	// SPECIES_GOLEM
	NATIONAL_DEX_PONYTA,          	// SPECIES_PONYTA
	NATIONAL_DEX_RAPIDASH,        	// SPECIES_RAPIDASH
	NATIONAL_DEX_SLOWPOKE,        	// SPECIES_SLOWPOKE
	NATIONAL_DEX_SLOWBRO,         	// SPECIES_SLOWBRO
	NATIONAL_DEX_MAGNEMITE,       	// SPECIES_MAGNEMITE
	NATIONAL_DEX_MAGNETON,        	// SPECIES_MAGNETON
	NATIONAL_DEX_FARFETCHD,       	// SPECIES_FARFETCHD
	NATIONAL_DEX_DODUO,           	// SPECIES_DODUO
	NATIONAL_DEX_DODRIO,          	// SPECIES_DODRIO
	NATIONAL_DEX_SEEL,            	// SPECIES_SEEL
	NATIONAL_DEX_DEWGONG,         	// SPECIES_DEWGONG
	NATIONAL_DEX_GRIMER,          	// SPECIES_GRIMER
	NATIONAL_DEX_MUK,             	// SPECIES_MUK
	NATIONAL_DEX_SHELLDER,        	// SPECIES_SHELLDER
	NATIONAL_DEX_CLOYSTER,        	// SPECIES_CLOYSTER
	NATIONAL_DEX_GASTLY,          	// SPECIES_GASTLY
	NATIONAL_DEX_HAUNTER,         	// SPECIES_HAUNTER
	NATIONAL_DEX_GENGAR,          	// SPECIES_GENGAR
	NATIONAL_DEX_ONIX,            	// SPECIES_ONIX
	NATIONAL_DEX_DROWZEE,         	// SPECIES_DROWZEE
	NATIONAL_DEX_HYPNO,           	// SPECIES_HYPNO
	NATIONAL_DEX_KRABBY,          	// SPECIES_KRABBY
	NATIONAL_DEX_KINGLER,         	// SPECIES_KINGLER
	NATIONAL_DEX_VOLTORB,         	// SPECIES_VOLTORB
	NATIONAL_DEX_ELECTRODE,       	// SPECIES_ELECTRODE
	NATIONAL_DEX_EXEGGCUTE,       	// SPECIES_EXEGGCUTE
	NATIONAL_DEX_EXEGGUTOR,       	// SPECIES_EXEGGUTOR
	NATIONAL_DEX_CUBONE,          	// SPECIES_CUBONE
	NATIONAL_DEX_MAROWAK,         	// SPECIES_MAROWAK
	NATIONAL_DEX_HITMONLEE,       	// SPECIES_HITMONLEE
	NATIONAL_DEX_HITMONCHAN,      	// SPECIES_HITMONCHAN
	NATIONAL_DEX_LICKITUNG,       	// SPECIES_LICKITUNG
	NATIONAL_DEX_KOFFING,         	// SPECIES_KOFFING
	NATIONAL_DEX_WEEZING,         	// SPECIES_WEEZING
	NATIONAL_DEX_RHYHORN,         	// SPECIES_RHYHORN
	NATIONAL_DEX_RHYDON,          	// SPECIES_RHYDON
	NATIONAL_DEX_CHANSEY,         	// SPECIES_CHANSEY
	NATIONAL_DEX_TANGELA,         	// SPECIES_TANGELA
	NATIONAL_DEX_KANGASKHAN,      	// SPECIES_KANGASKHAN
	NATIONAL_DEX_HORSEA,          	// SPECIES_HORSEA
	NATIONAL_DEX_SEADRA,          	// SPECIES_SEADRA
	NATIONAL_DEX_GOLDEEN,         	// SPECIES_GOLDEEN
	NATIONAL_DEX_SEAKING,         	// SPECIES_SEAKING
	NATIONAL_DEX_STARYU,          	// SPECIES_STARYU
	NATIONAL_DEX_STARMIE,         	// SPECIES_STARMIE
	NATIONAL_DEX_MR_MIME,         	// SPECIES_MR_MIME
	NATIONAL_DEX_SCYTHER,         	// SPECIES_SCYTHER
	NATIONAL_DEX_JYNX,            	// SPECIES_JYNX
	NATIONAL_DEX_ELECTABUZZ,      	// SPECIES_ELECTABUZZ
	NATIONAL_DEX_MAGMAR,          	// SPECIES_MAGMAR
	NATIONAL_DEX_PINSIR,          	// SPECIES_PINSIR
	NATIONAL_DEX_TAUROS,          	// SPECIES_TAUROS
	NATIONAL_DEX_MAGIKARP,        	// SPECIES_MAGIKARP
	NATIONAL_DEX_GYARADOS,        	// SPECIES_GYARADOS
	NATIONAL_DEX_LAPRAS,          	// SPECIES_LAPRAS
	NATIONAL_DEX_DITTO,           	// SPECIES_DITTO
	NATIONAL_DEX_EEVEE,           	// SPECIES_EEVEE
	NATIONAL_DEX_VAPOREON,        	// SPECIES_VAPOREON
	NATIONAL_DEX_JOLTEON,         	// SPECIES_JOLTEON
	NATIONAL_DEX_FLAREON,         	// SPECIES_FLAREON
	NATIONAL_DEX_PORYGON,         	// SPECIES_PORYGON
	NATIONAL_DEX_OMANYTE,         	// SPECIES_OMANYTE
	NATIONAL_DEX_OMASTAR,         	// SPECIES_OMASTAR
	NATIONAL_DEX_KABUTO,          	// SPECIES_KABUTO
	NATIONAL_DEX_KABUTOPS,        	// SPECIES_KABUTOPS
	NATIONAL_DEX_AERODACTYL,      	// SPECIES_AERODACTYL
	NATIONAL_DEX_SNORLAX,         	// SPECIES_SNORLAX
	NATIONAL_DEX_ARTICUNO,        	// SPECIES_ARTICUNO
	NATIONAL_DEX_ZAPDOS,          	// SPECIES_ZAPDOS
	NATIONAL_DEX_MOLTRES,         	// SPECIES_MOLTRES
	NATIONAL_DEX_DRATINI,         	// SPECIES_DRATINI
	NATIONAL_DEX_DRAGONAIR,       	// SPECIES_DRAGONAIR
	NATIONAL_DEX_DRAGONITE,       	// SPECIES_DRAGONITE
	NATIONAL_DEX_MEWTWO,          	// SPECIES_MEWTWO
	NATIONAL_DEX_MEW,             	// SPECIES_MEW
	NATIONAL_DEX_CHIKORITA,       	// SPECIES_CHIKORITA
	NATIONAL_DEX_BAYLEEF,         	// SPECIES_BAYLEEF
	NATIONAL_DEX_MEGANIUM,        	// SPECIES_MEGANIUM
	NATIONAL_DEX_CYNDAQUIL,       	// SPECIES_CYNDAQUIL
	NATIONAL_DEX_QUILAVA,         	// SPECIES_QUILAVA
	NATIONAL_DEX_TYPHLOSION,      	// SPECIES_TYPHLOSION
	NATIONAL_DEX_TOTODILE,        	// SPECIES_TOTODILE
	NATIONAL_DEX_CROCONAW,        	// SPECIES_CROCONAW
	NATIONAL_DEX_FERALIGATR,      	// SPECIES_FERALIGATR
	NATIONAL_DEX_SENTRET,         	// SPECIES_SENTRET
	NATIONAL_DEX_FURRET,          	// SPECIES_FURRET
	NATIONAL_DEX_HOOTHOOT,        	// SPECIES_HOOTHOOT
	NATIONAL_DEX_NOCTOWL,         	// SPECIES_NOCTOWL
	NATIONAL_DEX_LEDYBA,          	// SPECIES_LEDYBA
	NATIONAL_DEX_LEDIAN,          	// SPECIES_LEDIAN
	NATIONAL_DEX_SPINARAK,        	// SPECIES_SPINARAK
	NATIONAL_DEX_ARIADOS,         	// SPECIES_ARIADOS
	NATIONAL_DEX_CROBAT,          	// SPECIES_CROBAT
	NATIONAL_DEX_CHINCHOU,        	// SPECIES_CHINCHOU
	NATIONAL_DEX_LANTURN,         	// SPECIES_LANTURN
	NATIONAL_DEX_PICHU,           	// SPECIES_PICHU
	NATIONAL_DEX_CLEFFA,          	// SPECIES_CLEFFA
	NATIONAL_DEX_IGGLYBUFF,       	// SPECIES_IGGLYBUFF
	NATIONAL_DEX_TOGEPI,          	// SPECIES_TOGEPI
	NATIONAL_DEX_TOGETIC,         	// SPECIES_TOGETIC
	NATIONAL_DEX_NATU,            	// SPECIES_NATU
	NATIONAL_DEX_XATU,            	// SPECIES_XATU
	NATIONAL_DEX_MAREEP,          	// SPECIES_MAREEP
	NATIONAL_DEX_FLAAFFY,         	// SPECIES_FLAAFFY
	NATIONAL_DEX_AMPHAROS,        	// SPECIES_AMPHAROS
	NATIONAL_DEX_BELLOSSOM,       	// SPECIES_BELLOSSOM
	NATIONAL_DEX_MARILL,          	// SPECIES_MARILL
	NATIONAL_DEX_AZUMARILL,       	// SPECIES_AZUMARILL
	NATIONAL_DEX_SUDOWOODO,       	// SPECIES_SUDOWOODO
	NATIONAL_DEX_POLITOED,        	// SPECIES_POLITOED
	NATIONAL_DEX_HOPPIP,          	// SPECIES_HOPPIP
	NATIONAL_DEX_SKIPLOOM,        	// SPECIES_SKIPLOOM
	NATIONAL_DEX_JUMPLUFF,        	// SPECIES_JUMPLUFF
	NATIONAL_DEX_AIPOM,           	// SPECIES_AIPOM
	NATIONAL_DEX_SUNKERN,         	// SPECIES_SUNKERN
	NATIONAL_DEX_SUNFLORA,        	// SPECIES_SUNFLORA
	NATIONAL_DEX_YANMA,           	// SPECIES_YANMA
	NATIONAL_DEX_WOOPER,          	// SPECIES_WOOPER
	NATIONAL_DEX_QUAGSIRE,        	// SPECIES_QUAGSIRE
	NATIONAL_DEX_ESPEON,          	// SPECIES_ESPEON
	NATIONAL_DEX_UMBREON,         	// SPECIES_UMBREON
	NATIONAL_DEX_MURKROW,         	// SPECIES_MURKROW
	NATIONAL_DEX_SLOWKING,        	// SPECIES_SLOWKING
	NATIONAL_DEX_MISDREAVUS,      	// SPECIES_MISDREAVUS
	NATIONAL_DEX_UNOWN,           	// SPECIES_UNOWN
	NATIONAL_DEX_WOBBUFFET,       	// SPECIES_WOBBUFFET
	NATIONAL_DEX_GIRAFARIG,       	// SPECIES_GIRAFARIG
	NATIONAL_DEX_PINECO,          	// SPECIES_PINECO
	NATIONAL_DEX_FORRETRESS,      	// SPECIES_FORRETRESS
	NATIONAL_DEX_DUNSPARCE,       	// SPECIES_DUNSPARCE
	NATIONAL_DEX_GLIGAR,          	// SPECIES_GLIGAR
	NATIONAL_DEX_STEELIX,         	// SPECIES_STEELIX
	NATIONAL_DEX_SNUBBULL,        	// SPECIES_SNUBBULL
	NATIONAL_DEX_GRANBULL,        	// SPECIES_GRANBULL
	NATIONAL_DEX_QWILFISH,        	// SPECIES_QWILFISH
	NATIONAL_DEX_SCIZOR,          	// SPECIES_SCIZOR
	NATIONAL_DEX_SHUCKLE,         	// SPECIES_SHUCKLE
	NATIONAL_DEX_HERACROSS,       	// SPECIES_HERACROSS
	NATIONAL_DEX_SNEASEL,         	// SPECIES_SNEASEL
	NATIONAL_DEX_TEDDIURSA,       	// SPECIES_TEDDIURSA
	NATIONAL_DEX_URSARING,        	// SPECIES_URSARING
	NATIONAL_DEX_SLUGMA,          	// SPECIES_SLUGMA
	NATIONAL_DEX_MAGCARGO,        	// SPECIES_MAGCARGO
	NATIONAL_DEX_SWINUB,          	// SPECIES_SWINUB
	NATIONAL_DEX_PILOSWINE,       	// SPECIES_PILOSWINE
	NATIONAL_DEX_CORSOLA,         	// SPECIES_CORSOLA
	NATIONAL_DEX_REMORAID,        	// SPECIES_REMORAID
	NATIONAL_DEX_OCTILLERY,       	// SPECIES_OCTILLERY
	NATIONAL_DEX_DELIBIRD,        	// SPECIES_DELIBIRD
	NATIONAL_DEX_MANTINE,         	// SPECIES_MANTINE
	NATIONAL_DEX_SKARMORY,        	// SPECIES_SKARMORY
	NATIONAL_DEX_HOUNDOUR,        	// SPECIES_HOUNDOUR
	NATIONAL_DEX_HOUNDOOM,        	// SPECIES_HOUNDOOM
	NATIONAL_DEX_KINGDRA,         	// SPECIES_KINGDRA
	NATIONAL_DEX_PHANPY,          	// SPECIES_PHANPY
	NATIONAL_DEX_DONPHAN,         	// SPECIES_DONPHAN
	NATIONAL_DEX_PORYGON2,        	// SPECIES_PORYGON2
	NATIONAL_DEX_STANTLER,        	// SPECIES_STANTLER
	NATIONAL_DEX_SMEARGLE,        	// SPECIES_SMEARGLE
	NATIONAL_DEX_TYROGUE,         	// SPECIES_TYROGUE
	NATIONAL_DEX_HITMONTOP,       	// SPECIES_HITMONTOP
	NATIONAL_DEX_SMOOCHUM,        	// SPECIES_SMOOCHUM
	NATIONAL_DEX_ELEKID,          	// SPECIES_ELEKID
	NATIONAL_DEX_MAGBY,           	// SPECIES_MAGBY
	NATIONAL_DEX_MILTANK,         	// SPECIES_MILTANK
	NATIONAL_DEX_BLISSEY,         	// SPECIES_BLISSEY
	NATIONAL_DEX_RAIKOU,          	// SPECIES_RAIKOU
	NATIONAL_DEX_ENTEI,           	// SPECIES_ENTEI
	NATIONAL_DEX_SUICUNE,         	// SPECIES_SUICUNE
	NATIONAL_DEX_LARVITAR,        	// SPECIES_LARVITAR
	NATIONAL_DEX_PUPITAR,         	// SPECIES_PUPITAR
	NATIONAL_DEX_TYRANITAR,       	// SPECIES_TYRANITAR
	NATIONAL_DEX_LUGIA,           	// SPECIES_LUGIA
	NATIONAL_DEX_HO_OH,           	// SPECIES_HO-OH
	NATIONAL_DEX_CELEBI,          	// SPECIES_CELEBI
	NATIONAL_DEX_OLD_UNOWN_B,  	// SPECIES_OLD_UNOWN_B
	NATIONAL_DEX_OLD_UNOWN_C,  	// SPECIES_OLD_UNOWN_C
	NATIONAL_DEX_OLD_UNOWN_D,  	// SPECIES_OLD_UNOWN_D
	NATIONAL_DEX_OLD_UNOWN_E,  	// SPECIES_OLD_UNOWN_E
	NATIONAL_DEX_OLD_UNOWN_F,  	// SPECIES_OLD_UNOWN_F
	NATIONAL_DEX_OLD_UNOWN_G,  	// SPECIES_OLD_UNOWN_G
	NATIONAL_DEX_OLD_UNOWN_H,  	// SPECIES_OLD_UNOWN_H
	NATIONAL_DEX_OLD_UNOWN_I,  	// SPECIES_OLD_UNOWN_I
	NATIONAL_DEX_OLD_UNOWN_J,  	// SPECIES_OLD_UNOWN_J
	NATIONAL_DEX_OLD_UNOWN_K,  	// SPECIES_OLD_UNOWN_K
	NATIONAL_DEX_OLD_UNOWN_L,  	// SPECIES_OLD_UNOWN_L
	NATIONAL_DEX_OLD_UNOWN_M,  	// SPECIES_OLD_UNOWN_M
	NATIONAL_DEX_OLD_UNOWN_N,  	// SPECIES_OLD_UNOWN_N
	NATIONAL_DEX_OLD_UNOWN_O,  	// SPECIES_OLD_UNOWN_O
	NATIONAL_DEX_OLD_UNOWN_P,  	// SPECIES_OLD_UNOWN_P
	NATIONAL_DEX_OLD_UNOWN_Q,  	// SPECIES_OLD_UNOWN_Q
	NATIONAL_DEX_OLD_UNOWN_R,  	// SPECIES_OLD_UNOWN_R
	NATIONAL_DEX_OLD_UNOWN_S,  	// SPECIES_OLD_UNOWN_S
	NATIONAL_DEX_OLD_UNOWN_T,  	// SPECIES_OLD_UNOWN_T
	NATIONAL_DEX_OLD_UNOWN_U,  	// SPECIES_OLD_UNOWN_U
	NATIONAL_DEX_OLD_UNOWN_V,  	// SPECIES_OLD_UNOWN_V
	NATIONAL_DEX_OLD_UNOWN_W,  	// SPECIES_OLD_UNOWN_W
	NATIONAL_DEX_OLD_UNOWN_X,  	// SPECIES_OLD_UNOWN_X
	NATIONAL_DEX_OLD_UNOWN_Y,  	// SPECIES_OLD_UNOWN_Y
	NATIONAL_DEX_OLD_UNOWN_Z,  	// SPECIES_OLD_UNOWN_Z
	NATIONAL_DEX_TREECKO,         	// SPECIES_TREECKO
	NATIONAL_DEX_GROVYLE,         	// SPECIES_GROVYLE
	NATIONAL_DEX_SCEPTILE,        	// SPECIES_SCEPTILE
	NATIONAL_DEX_TORCHIC,         	// SPECIES_TORCHIC
	NATIONAL_DEX_COMBUSKEN,       	// SPECIES_COMBUSKEN
	NATIONAL_DEX_BLAZIKEN,        	// SPECIES_BLAZIKEN
	NATIONAL_DEX_MUDKIP,          	// SPECIES_MUDKIP
	NATIONAL_DEX_MARSHTOMP,       	// SPECIES_MARSHTOMP
	NATIONAL_DEX_SWAMPERT,        	// SPECIES_SWAMPERT
	NATIONAL_DEX_POOCHYENA,       	// SPECIES_POOCHYENA
	NATIONAL_DEX_MIGHTYENA,       	// SPECIES_MIGHTYENA
	NATIONAL_DEX_ZIGZAGOON,       	// SPECIES_ZIGZAGOON
	NATIONAL_DEX_LINOONE,         	// SPECIES_LINOONE
	NATIONAL_DEX_WURMPLE,         	// SPECIES_WURMPLE
	NATIONAL_DEX_SILCOON,         	// SPECIES_SILCOON
	NATIONAL_DEX_BEAUTIFLY,       	// SPECIES_BEAUTIFLY
	NATIONAL_DEX_CASCOON,         	// SPECIES_CASCOON
	NATIONAL_DEX_DUSTOX,          	// SPECIES_DUSTOX
	NATIONAL_DEX_LOTAD,           	// SPECIES_LOTAD
	NATIONAL_DEX_LOMBRE,          	// SPECIES_LOMBRE
	NATIONAL_DEX_LUDICOLO,        	// SPECIES_LUDICOLO
	NATIONAL_DEX_SEEDOT,          	// SPECIES_SEEDOT
	NATIONAL_DEX_NUZLEAF,         	// SPECIES_NUZLEAF
	NATIONAL_DEX_SHIFTRY,         	// SPECIES_SHIFTRY
	NATIONAL_DEX_NINCADA,         	// SPECIES_NINCADA
	NATIONAL_DEX_NINJASK,         	// SPECIES_NINJASK
	NATIONAL_DEX_SHEDINJA,        	// SPECIES_SHEDINJA
	NATIONAL_DEX_TAILLOW,         	// SPECIES_TAILLOW
	NATIONAL_DEX_SWELLOW,         	// SPECIES_SWELLOW
	NATIONAL_DEX_SHROOMISH,       	// SPECIES_SHROOMISH
	NATIONAL_DEX_BRELOOM,         	// SPECIES_BRELOOM
	NATIONAL_DEX_SPINDA,          	// SPECIES_SPINDA
	NATIONAL_DEX_WINGULL,         	// SPECIES_WINGULL
	NATIONAL_DEX_PELIPPER,        	// SPECIES_PELIPPER
	NATIONAL_DEX_SURSKIT,         	// SPECIES_SURSKIT
	NATIONAL_DEX_MASQUERAIN,      	// SPECIES_MASQUERAIN
	NATIONAL_DEX_WAILMER,         	// SPECIES_WAILMER
	NATIONAL_DEX_WAILORD,         	// SPECIES_WAILORD
	NATIONAL_DEX_SKITTY,          	// SPECIES_SKITTY
	NATIONAL_DEX_DELCATTY,        	// SPECIES_DELCATTY
	NATIONAL_DEX_KECLEON,         	// SPECIES_KECLEON
	NATIONAL_DEX_BALTOY,          	// SPECIES_BALTOY
	NATIONAL_DEX_CLAYDOL,         	// SPECIES_CLAYDOL
	NATIONAL_DEX_NOSEPASS,        	// SPECIES_NOSEPASS
	NATIONAL_DEX_TORKOAL,         	// SPECIES_TORKOAL
	NATIONAL_DEX_SABLEYE,         	// SPECIES_SABLEYE
	NATIONAL_DEX_BARBOACH,        	// SPECIES_BARBOACH
	NATIONAL_DEX_WHISCASH,        	// SPECIES_WHISCASH
	NATIONAL_DEX_LUVDISC,         	// SPECIES_LUVDISC
	NATIONAL_DEX_CORPHISH,        	// SPECIES_CORPHISH
	NATIONAL_DEX_CRAWDAUNT,       	// SPECIES_CRAWDAUNT
	NATIONAL_DEX_FEEBAS,          	// SPECIES_FEEBAS
	NATIONAL_DEX_MILOTIC,         	// SPECIES_MILOTIC
	NATIONAL_DEX_CARVANHA,        	// SPECIES_CARVANHA
	NATIONAL_DEX_SHARPEDO,        	// SPECIES_SHARPEDO
	NATIONAL_DEX_TRAPINCH,        	// SPECIES_TRAPINCH
	NATIONAL_DEX_VIBRAVA,         	// SPECIES_VIBRAVA
	NATIONAL_DEX_FLYGON,          	// SPECIES_FLYGON
	NATIONAL_DEX_MAKUHITA,        	// SPECIES_MAKUHITA
	NATIONAL_DEX_HARIYAMA,        	// SPECIES_HARIYAMA
	NATIONAL_DEX_ELECTRIKE,       	// SPECIES_ELECTRIKE
	NATIONAL_DEX_MANECTRIC,       	// SPECIES_MANECTRIC
	NATIONAL_DEX_NUMEL,           	// SPECIES_NUMEL
	NATIONAL_DEX_CAMERUPT,        	// SPECIES_CAMERUPT
	NATIONAL_DEX_SPHEAL,          	// SPECIES_SPHEAL
	NATIONAL_DEX_SEALEO,          	// SPECIES_SEALEO
	NATIONAL_DEX_WALREIN,         	// SPECIES_WALREIN
	NATIONAL_DEX_CACNEA,          	// SPECIES_CACNEA
	NATIONAL_DEX_CACTURNE,        	// SPECIES_CACTURNE
	NATIONAL_DEX_SNORUNT,         	// SPECIES_SNORUNT
	NATIONAL_DEX_GLALIE,          	// SPECIES_GLALIE
	NATIONAL_DEX_LUNATONE,        	// SPECIES_LUNATONE
	NATIONAL_DEX_SOLROCK,         	// SPECIES_SOLROCK
	NATIONAL_DEX_AZURILL,         	// SPECIES_AZURILL
	NATIONAL_DEX_SPOINK,          	// SPECIES_SPOINK
	NATIONAL_DEX_GRUMPIG,         	// SPECIES_GRUMPIG
	NATIONAL_DEX_PLUSLE,          	// SPECIES_PLUSLE
	NATIONAL_DEX_MINUN,           	// SPECIES_MINUN
	NATIONAL_DEX_MAWILE,          	// SPECIES_MAWILE
	NATIONAL_DEX_MEDITITE,        	// SPECIES_MEDITITE
	NATIONAL_DEX_MEDICHAM,        	// SPECIES_MEDICHAM
	NATIONAL_DEX_SWABLU,          	// SPECIES_SWABLU
	NATIONAL_DEX_ALTARIA,         	// SPECIES_ALTARIA
	NATIONAL_DEX_WYNAUT,          	// SPECIES_WYNAUT
	NATIONAL_DEX_DUSKULL,         	// SPECIES_DUSKULL
	NATIONAL_DEX_DUSCLOPS,        	// SPECIES_DUSCLOPS
	NATIONAL_DEX_ROSELIA,         	// SPECIES_ROSELIA
	NATIONAL_DEX_SLAKOTH,         	// SPECIES_SLAKOTH
	NATIONAL_DEX_VIGOROTH,        	// SPECIES_VIGOROTH
	NATIONAL_DEX_SLAKING,         	// SPECIES_SLAKING
	NATIONAL_DEX_GULPIN,          	// SPECIES_GULPIN
	NATIONAL_DEX_SWALOT,          	// SPECIES_SWALOT
	NATIONAL_DEX_TROPIUS,         	// SPECIES_TROPIUS
	NATIONAL_DEX_WHISMUR,         	// SPECIES_WHISMUR
	NATIONAL_DEX_LOUDRED,         	// SPECIES_LOUDRED
	NATIONAL_DEX_EXPLOUD,         	// SPECIES_EXPLOUD
	NATIONAL_DEX_CLAMPERL,        	// SPECIES_CLAMPERL
	NATIONAL_DEX_HUNTAIL,         	// SPECIES_HUNTAIL
	NATIONAL_DEX_GOREBYSS,        	// SPECIES_GOREBYSS
	NATIONAL_DEX_ABSOL,           	// SPECIES_ABSOL
	NATIONAL_DEX_SHUPPET,         	// SPECIES_SHUPPET
	NATIONAL_DEX_BANETTE,         	// SPECIES_BANETTE
	NATIONAL_DEX_SEVIPER,         	// SPECIES_SEVIPER
	NATIONAL_DEX_ZANGOOSE,        	// SPECIES_ZANGOOSE
	NATIONAL_DEX_RELICANTH,       	// SPECIES_RELICANTH
	NATIONAL_DEX_ARON,            	// SPECIES_ARON
	NATIONAL_DEX_LAIRON,          	// SPECIES_LAIRON
	NATIONAL_DEX_AGGRON,          	// SPECIES_AGGRON
	NATIONAL_DEX_CASTFORM,        	// SPECIES_CASTFORM
	NATIONAL_DEX_VOLBEAT,         	// SPECIES_VOLBEAT
	NATIONAL_DEX_ILLUMISE,        	// SPECIES_ILLUMISE
	NATIONAL_DEX_LILEEP,          	// SPECIES_LILEEP
	NATIONAL_DEX_CRADILY,         	// SPECIES_CRADILY
	NATIONAL_DEX_ANORITH,         	// SPECIES_ANORITH
	NATIONAL_DEX_ARMALDO,         	// SPECIES_ARMALDO
	NATIONAL_DEX_RALTS,           	// SPECIES_RALTS
	NATIONAL_DEX_KIRLIA,          	// SPECIES_KIRLIA
	NATIONAL_DEX_GARDEVOIR,       	// SPECIES_GARDEVOIR
	NATIONAL_DEX_BAGON,           	// SPECIES_BAGON
	NATIONAL_DEX_SHELGON,         	// SPECIES_SHELGON
	NATIONAL_DEX_SALAMENCE,       	// SPECIES_SALAMENCE
	NATIONAL_DEX_BELDUM,          	// SPECIES_BELDUM
	NATIONAL_DEX_METANG,          	// SPECIES_METANG
	NATIONAL_DEX_METAGROSS,       	// SPECIES_METAGROSS
	NATIONAL_DEX_REGIROCK,        	// SPECIES_REGIROCK
	NATIONAL_DEX_REGICE,          	// SPECIES_REGICE
	NATIONAL_DEX_REGISTEEL,       	// SPECIES_REGISTEEL
	NATIONAL_DEX_KYOGRE,          	// SPECIES_KYOGRE
	NATIONAL_DEX_GROUDON,         	// SPECIES_GROUDON
	NATIONAL_DEX_RAYQUAZA,        	// SPECIES_RAYQUAZA
	NATIONAL_DEX_LATIAS,          	// SPECIES_LATIAS
	NATIONAL_DEX_LATIOS,          	// SPECIES_LATIOS
	NATIONAL_DEX_JIRACHI,         	// SPECIES_JIRACHI
	NATIONAL_DEX_DEOXYS,          	// SPECIES_DEOXYS
	NATIONAL_DEX_CHIMECHO         	// SPECIES_CHIMECHO
};

const u16 gHoennToNationalOrder[] = // Assigns Hoenn Dex Pokémon (Using National Dex Index)
{
	         	                // 0
	NATIONAL_DEX_TREECKO,   	// HOENN_DEX_TREECKO
	NATIONAL_DEX_GROVYLE,   	// HOENN_DEX_GROVYLE
	NATIONAL_DEX_SCEPTILE,  	// HOENN_DEX_SCEPTILE
	NATIONAL_DEX_TORCHIC,   	// HOENN_DEX_TORCHIC
	NATIONAL_DEX_COMBUSKEN, 	// HOENN_DEX_COMBUSKEN
	NATIONAL_DEX_BLAZIKEN,  	// HOENN_DEX_BLAZIKEN
	NATIONAL_DEX_MUDKIP,    	// HOENN_DEX_MUDKIP
	NATIONAL_DEX_MARSHTOMP, 	// HOENN_DEX_MARSHTOMP
	NATIONAL_DEX_SWAMPERT,  	// HOENN_DEX_SWAMPERT	
	NATIONAL_DEX_POOCHYENA, 	// HOENN_DEX_POOCHYENA
	NATIONAL_DEX_MIGHTYENA, 	// HOENN_DEX_MIGHTYENA
	NATIONAL_DEX_ZIGZAGOON, 	// HOENN_DEX_ZIGZAGOON
	NATIONAL_DEX_LINOONE,   	// HOENN_DEX_LINOONE
	NATIONAL_DEX_WURMPLE,   	// HOENN_DEX_WURMPLE
	NATIONAL_DEX_SILCOON,   	// HOENN_DEX_SILCOON
	NATIONAL_DEX_BEAUTIFLY, 	// HOENN_DEX_BEAUTIFLY
	NATIONAL_DEX_CASCOON,   	// HOENN_DEX_CASCOON
	NATIONAL_DEX_DUSTOX,    	// HOENN_DEX_DUSTOX
	NATIONAL_DEX_LOTAD,     	// HOENN_DEX_LOTAD
	NATIONAL_DEX_LOMBRE,    	// HOENN_DEX_LOMBRE
	NATIONAL_DEX_LUDICOLO,  	// HOENN_DEX_LUDICOLO
	NATIONAL_DEX_SEEDOT,    	// HOENN_DEX_SEEDOT
	NATIONAL_DEX_NUZLEAF,   	// HOENN_DEX_NUZLEAF
	NATIONAL_DEX_SHIFTRY,   	// HOENN_DEX_SHIFTRY
	NATIONAL_DEX_TAILLOW,   	// HOENN_DEX_TAILLOW
	NATIONAL_DEX_SWELLOW,   	// HOENN_DEX_SWELLOW
	NATIONAL_DEX_WINGULL,   	// HOENN_DEX_WINGULL
	NATIONAL_DEX_PELIPPER,  	// HOENN_DEX_PELIPPER
	NATIONAL_DEX_RALTS,     	// HOENN_DEX_RALTS
	NATIONAL_DEX_KIRLIA,    	// HOENN_DEX_KIRLIA
	NATIONAL_DEX_GARDEVOIR, 	// HOENN_DEX_GARDEVOIR
	NATIONAL_DEX_SURSKIT,   	// HOENN_DEX_SURSKIT
	NATIONAL_DEX_MASQUERAIN,	// HOENN_DEX_MASQUERAIN
	NATIONAL_DEX_SHROOMISH, 	// HOENN_DEX_SHROOMISH
	NATIONAL_DEX_BRELOOM,   	// HOENN_DEX_BRELOOM
	NATIONAL_DEX_SLAKOTH,   	// HOENN_DEX_SLAKOTH
	NATIONAL_DEX_VIGOROTH,  	// HOENN_DEX_VIGOROTH
	NATIONAL_DEX_SLAKING,   	// HOENN_DEX_SLAKING
	NATIONAL_DEX_ABRA,       	// HOENN_DEX_ABRA
	NATIONAL_DEX_KADABRA,    	// HOENN_DEX_KADABRA
	NATIONAL_DEX_ALAKAZAM,   	// HOENN_DEX_ALAKAZAM
	NATIONAL_DEX_NINCADA,   	// HOENN_DEX_NINCADA
	NATIONAL_DEX_NINJASK,   	// HOENN_DEX_NINJASK
	NATIONAL_DEX_SHEDINJA,  	// HOENN_DEX_SHEDINJA
	NATIONAL_DEX_WHISMUR,   	// HOENN_DEX_WHISMUR
	NATIONAL_DEX_LOUDRED,   	// HOENN_DEX_LOUDRED
	NATIONAL_DEX_EXPLOUD,   	// HOENN_DEX_EXPLOUD
	NATIONAL_DEX_MAKUHITA,  	// HOENN_DEX_MAKUHITA
	NATIONAL_DEX_HARIYAMA,  	// HOENN_DEX_HARIYAMA
	NATIONAL_DEX_GOLDEEN,    	// HOENN_DEX_GOLDEEN
	NATIONAL_DEX_SEAKING,    	// HOENN_DEX_SEAKING
	NATIONAL_DEX_MAGIKARP,   	// HOENN_DEX_MAGIKARP
	NATIONAL_DEX_GYARADOS,   	// HOENN_DEX_GYARADOS
	NATIONAL_DEX_AZURILL,   	// HOENN_DEX_AZURILL
	NATIONAL_DEX_MARILL,     	// HOENN_DEX_MARILL
	NATIONAL_DEX_AZUMARILL,  	// HOENN_DEX_AZUMARILL
	NATIONAL_DEX_GEODUDE,    	// HOENN_DEX_GEODUDE
	NATIONAL_DEX_GRAVELER,   	// HOENN_DEX_GRAVELER
	NATIONAL_DEX_GOLEM,      	// HOENN_DEX_GOLEM
	NATIONAL_DEX_NOSEPASS,  	// HOENN_DEX_NOSEPASS
	NATIONAL_DEX_SKITTY,    	// HOENN_DEX_SKITTY
	NATIONAL_DEX_DELCATTY,  	// HOENN_DEX_DELCATTY
	NATIONAL_DEX_ZUBAT,      	// HOENN_DEX_ZUBAT
	NATIONAL_DEX_GOLBAT,     	// HOENN_DEX_GOLBAT
	NATIONAL_DEX_CROBAT,     	// HOENN_DEX_CROBAT
	NATIONAL_DEX_TENTACOOL,  	// HOENN_DEX_TENTACOOL
	NATIONAL_DEX_TENTACRUEL, 	// HOENN_DEX_TENTACRUEL
	NATIONAL_DEX_SABLEYE,   	// HOENN_DEX_SABLEYE
	NATIONAL_DEX_MAWILE,    	// HOENN_DEX_MAWILE
	NATIONAL_DEX_ARON,      	// HOENN_DEX_ARON
	NATIONAL_DEX_LAIRON,    	// HOENN_DEX_LAIRON
	NATIONAL_DEX_AGGRON,    	// HOENN_DEX_AGGRON
	NATIONAL_DEX_MACHOP,     	// HOENN_DEX_MACHOP
	NATIONAL_DEX_MACHOKE,    	// HOENN_DEX_MACHOKE
	NATIONAL_DEX_MACHAMP,    	// HOENN_DEX_MACHAMP
	NATIONAL_DEX_MEDITITE,  	// HOENN_DEX_MEDITITE
	NATIONAL_DEX_MEDICHAM,  	// HOENN_DEX_MEDICHAM
	NATIONAL_DEX_ELECTRIKE, 	// HOENN_DEX_ELECTRIKE
	NATIONAL_DEX_MANECTRIC, 	// HOENN_DEX_MANECTRIC
	NATIONAL_DEX_PLUSLE,    	// HOENN_DEX_PLUSLE
	NATIONAL_DEX_MINUN,     	// HOENN_DEX_MINUN
	NATIONAL_DEX_MAGNEMITE,  	// HOENN_DEX_MAGNEMITE
	NATIONAL_DEX_MAGNETON,   	// HOENN_DEX_MAGNETON
	NATIONAL_DEX_VOLTORB,    	// HOENN_DEX_VOLTORB
	NATIONAL_DEX_ELECTRODE,  	// HOENN_DEX_ELECTRODE
	NATIONAL_DEX_VOLBEAT,   	// HOENN_DEX_VOLBEAT
	NATIONAL_DEX_ILLUMISE,  	// HOENN_DEX_ILLUMISE
	NATIONAL_DEX_ODDISH,     	// HOENN_DEX_ODDISH
	NATIONAL_DEX_GLOOM,      	// HOENN_DEX_GLOOM
	NATIONAL_DEX_VILEPLUME,  	// HOENN_DEX_VILEPLUME
	NATIONAL_DEX_BELLOSSOM,  	// HOENN_DEX_BELLOSSOM
	NATIONAL_DEX_DODUO,      	// HOENN_DEX_DODUO
	NATIONAL_DEX_DODRIO,     	// HOENN_DEX_DODRIO
	NATIONAL_DEX_ROSELIA,   	// HOENN_DEX_ROSELIA
	NATIONAL_DEX_GULPIN,    	// HOENN_DEX_GULPIN
	NATIONAL_DEX_SWALOT,    	// HOENN_DEX_SWALOT
	NATIONAL_DEX_CARVANHA,  	// HOENN_DEX_CARVANHA
	NATIONAL_DEX_SHARPEDO,  	// HOENN_DEX_SHARPEDO
	NATIONAL_DEX_WAILMER,   	// HOENN_DEX_WAILMER
	NATIONAL_DEX_WAILORD,   	// HOENN_DEX_WAILORD
	NATIONAL_DEX_NUMEL,     	// HOENN_DEX_NUMEL
	NATIONAL_DEX_CAMERUPT,  	// HOENN_DEX_CAMERUPT
	NATIONAL_DEX_SLUGMA,     	// HOENN_DEX_SLUGMA
	NATIONAL_DEX_MAGCARGO,   	// HOENN_DEX_MAGCARGO
	NATIONAL_DEX_TORKOAL,   	// HOENN_DEX_TORKOAL
	NATIONAL_DEX_GRIMER,     	// HOENN_DEX_GRIMER
	NATIONAL_DEX_MUK,        	// HOENN_DEX_MUK
	NATIONAL_DEX_KOFFING,    	// HOENN_DEX_KOFFING
	NATIONAL_DEX_WEEZING,    	// HOENN_DEX_WEEZING
	NATIONAL_DEX_SPOINK,    	// HOENN_DEX_SPOINK
	NATIONAL_DEX_GRUMPIG,   	// HOENN_DEX_GRUMPIG
	NATIONAL_DEX_SANDSHREW,  	// HOENN_DEX_SANDSHREW
	NATIONAL_DEX_SANDSLASH,  	// HOENN_DEX_SANDSLASH
	NATIONAL_DEX_SPINDA,    	// HOENN_DEX_SPINDA
	NATIONAL_DEX_SKARMORY,   	// HOENN_DEX_SKARMORY
	NATIONAL_DEX_TRAPINCH,  	// HOENN_DEX_TRAPINCH
	NATIONAL_DEX_VIBRAVA,   	// HOENN_DEX_VIBRAVA
	NATIONAL_DEX_FLYGON,    	// HOENN_DEX_FLYGON
	NATIONAL_DEX_CACNEA,    	// HOENN_DEX_CACNEA
	NATIONAL_DEX_CACTURNE,  	// HOENN_DEX_CACTURNE
	NATIONAL_DEX_SWABLU,    	// HOENN_DEX_SWABLU
	NATIONAL_DEX_ALTARIA,   	// HOENN_DEX_ALTARIA
	NATIONAL_DEX_ZANGOOSE,  	// HOENN_DEX_ZANGOOSE
	NATIONAL_DEX_SEVIPER,   	// HOENN_DEX_SEVIPER
	NATIONAL_DEX_LUNATONE,  	// HOENN_DEX_LUNATONE
	NATIONAL_DEX_SOLROCK,   	// HOENN_DEX_SOLROCK
	NATIONAL_DEX_BARBOACH,  	// HOENN_DEX_BARBOACH
	NATIONAL_DEX_WHISCASH,  	// HOENN_DEX_WHISCASH
	NATIONAL_DEX_CORPHISH,  	// HOENN_DEX_CORPHISH
	NATIONAL_DEX_CRAWDAUNT, 	// HOENN_DEX_CRAWDAUNT
	NATIONAL_DEX_BALTOY,    	// HOENN_DEX_BALTOY
	NATIONAL_DEX_CLAYDOL,   	// HOENN_DEX_CLAYDOL
	NATIONAL_DEX_LILEEP,    	// HOENN_DEX_LILEEP
	NATIONAL_DEX_CRADILY,   	// HOENN_DEX_CRADILY
	NATIONAL_DEX_ANORITH,   	// HOENN_DEX_ANORITH
	NATIONAL_DEX_ARMALDO,   	// HOENN_DEX_ARMALDO
	NATIONAL_DEX_IGGLYBUFF, 	// HOENN_DEX_IGGLYBUFF
	NATIONAL_DEX_JIGGLYPUFF, 	// HOENN_DEX_JIGGLYPUFF
	NATIONAL_DEX_WIGGLYTUFF, 	// HOENN_DEX_WIGGLYTUFF
	NATIONAL_DEX_FEEBAS,    	// HOENN_DEX_FEEBAS
	NATIONAL_DEX_MILOTIC,   	// HOENN_DEX_MILOTIC
	NATIONAL_DEX_CASTFORM,  	// HOENN_DEX_CASTFORM
	NATIONAL_DEX_STARYU,     	// HOENN_DEX_STARYU
	NATIONAL_DEX_STARMIE,    	// HOENN_DEX_STARMIE
	NATIONAL_DEX_KECLEON,   	// HOENN_DEX_KECLEON
	NATIONAL_DEX_SHUPPET,   	// HOENN_DEX_SHUPPET
	NATIONAL_DEX_BANETTE,   	// HOENN_DEX_BANETTE
	NATIONAL_DEX_DUSKULL,   	// HOENN_DEX_DUSKULL
	NATIONAL_DEX_DUSCLOPS,  	// HOENN_DEX_DUSCLOPS
	NATIONAL_DEX_TROPIUS,   	// HOENN_DEX_TROPIUS
	NATIONAL_DEX_CHIMECHO,   	// HOENN_DEX_CHIMECHO
	NATIONAL_DEX_ABSOL,     	// HOENN_DEX_ABSOL
	NATIONAL_DEX_VULPIX,     	// HOENN_DEX_VULPIX
	NATIONAL_DEX_NINETALES,  	// HOENN_DEX_NINETALES
	NATIONAL_DEX_PICHU,       	// HOENN_DEX_PICHU
	NATIONAL_DEX_PIKACHU,    	// HOENN_DEX_PIKACHU
	NATIONAL_DEX_RAICHU,     	// HOENN_DEX_RAICHU
	NATIONAL_DEX_PSYDUCK,    	// HOENN_DEX_PSYDUCK
	NATIONAL_DEX_GOLDUCK,    	// HOENN_DEX_GOLDUCK
	NATIONAL_DEX_WYNAUT,    	// HOENN_DEX_WYNAUT
	NATIONAL_DEX_WOBBUFFET,  	// HOENN_DEX_WOBBUFFET
	NATIONAL_DEX_NATU,       	// HOENN_DEX_NATU
	NATIONAL_DEX_XATU,       	// HOENN_DEX_XATU
	NATIONAL_DEX_GIRAFARIG,  	// HOENN_DEX_GIRAFARIG
	NATIONAL_DEX_PHANPY,     	// HOENN_DEX_PHANPY
	NATIONAL_DEX_DONPHAN,    	// HOENN_DEX_DONPHAN
	NATIONAL_DEX_PINSIR,     	// HOENN_DEX_PINSIR
	NATIONAL_DEX_HERACROSS,  	// HOENN_DEX_HERACROSS
	NATIONAL_DEX_RHYHORN,    	// HOENN_DEX_RHYHORN
	NATIONAL_DEX_RHYDON,     	// HOENN_DEX_RHYDON
	NATIONAL_DEX_SNORUNT,   	// HOENN_DEX_SNORUNT
	NATIONAL_DEX_GLALIE,    	// HOENN_DEX_GLALIE
	NATIONAL_DEX_SPHEAL,    	// HOENN_DEX_SPHEAL
	NATIONAL_DEX_SEALEO,    	// HOENN_DEX_SEALEO
	NATIONAL_DEX_WALREIN,   	// HOENN_DEX_WALREIN
	NATIONAL_DEX_CLAMPERL,  	// HOENN_DEX_CLAMPERL
	NATIONAL_DEX_HUNTAIL,   	// HOENN_DEX_HUNTAIL
	NATIONAL_DEX_GOREBYSS,  	// HOENN_DEX_GOREBYSS
	NATIONAL_DEX_RELICANTH, 	// HOENN_DEX_RELICANTH
	NATIONAL_DEX_CORSOLA,   	// HOENN_DEX_CORSOLA
	NATIONAL_DEX_CHINCHOU,   	// HOENN_DEX_CHINCHOU
	NATIONAL_DEX_LANTURN,    	// HOENN_DEX_LANTURN
	NATIONAL_DEX_LUVDISC,   	// HOENN_DEX_LUVDISC
	NATIONAL_DEX_HORSEA,   		// HOENN_DEX_HORSEA
	NATIONAL_DEX_SEADRA,   		// HOENN_DEX_SEADRA
	NATIONAL_DEX_KINGDRA,   	// HOENN_DEX_KINGDRA
	NATIONAL_DEX_BAGON,     	// HOENN_DEX_BAGON
	NATIONAL_DEX_SHELGON,   	// HOENN_DEX_SHELGON
	NATIONAL_DEX_SALAMENCE, 	// HOENN_DEX_SALAMENCE
	NATIONAL_DEX_BELDUM,    	// HOENN_DEX_BELDUM
	NATIONAL_DEX_METANG,    	// HOENN_DEX_METANG
	NATIONAL_DEX_METAGROSS, 	// HOENN_DEX_METAGROSS
	NATIONAL_DEX_REGIROCK,  	// HOENN_DEX_REGIROCK
	NATIONAL_DEX_REGICE,    	// HOENN_DEX_REGICE
	NATIONAL_DEX_REGISTEEL, 	// HOENN_DEX_REGISTEEL
	NATIONAL_DEX_LATIAS,    	// HOENN_DEX_LATIAS
	NATIONAL_DEX_LATIOS,    	// HOENN_DEX_LATIOS
	NATIONAL_DEX_KYOGRE,    	// HOENN_DEX_KYOGRE
	NATIONAL_DEX_GROUDON,   	// HOENN_DEX_GROUDON
	NATIONAL_DEX_RAYQUAZA,  	// HOENN_DEX_RAYQUAZA
	NATIONAL_DEX_JIRACHI,   	// HOENN_DEX_JIRACHI
	NATIONAL_DEX_DEOXYS,    	// HOENN_DEX_DEOXYS
	NATIONAL_DEX_BULBASAUR,  	// HOENN_DEX_BULBASAUR - Pokémon from here onwards are UNSEEN in the Hoenn Dex.
	NATIONAL_DEX_IVYSAUR,    	// HOENN_DEX_IVYSAUR
	NATIONAL_DEX_VENUSAUR,   	// HOENN_DEX_VENUSAUR
	NATIONAL_DEX_CHARMANDER, 	// HOENN_DEX_CHARMANDER
	NATIONAL_DEX_CHARMELEON, 	// HOENN_DEX_CHARMELEON
	NATIONAL_DEX_CHARIZARD,  	// HOENN_DEX_CHARIZARD
	NATIONAL_DEX_SQUIRTLE,   	// HOENN_DEX_SQUIRTLE
	NATIONAL_DEX_WARTORTLE,  	// HOENN_DEX_WARTORTLE
	NATIONAL_DEX_BLASTOISE,  	// HOENN_DEX_BLASTOISE
	NATIONAL_DEX_CATERPIE,   	// HOENN_DEX_CATERPIE
	NATIONAL_DEX_METAPOD,    	// HOENN_DEX_METAPOD
	NATIONAL_DEX_BUTTERFREE, 	// HOENN_DEX_BUTTERFREE
	NATIONAL_DEX_WEEDLE,     	// HOENN_DEX_WEEDLE
	NATIONAL_DEX_KAKUNA,     	// HOENN_DEX_KAKUNA
	NATIONAL_DEX_BEEDRILL,   	// HOENN_DEX_BEEDRILL
	NATIONAL_DEX_PIDGEY,     	// HOENN_DEX_PIDGEY
	NATIONAL_DEX_PIDGEOTTO,  	// HOENN_DEX_PIDGEOTTO
	NATIONAL_DEX_PIDGEOT,    	// HOENN_DEX_PIDGEOT
	NATIONAL_DEX_RATTATA,    	// HOENN_DEX_RATTATA
	NATIONAL_DEX_RATICATE,   	// HOENN_DEX_RATICATE
	NATIONAL_DEX_SPEAROW,    	// HOENN_DEX_SPEAROW
	NATIONAL_DEX_FEAROW,     	// HOENN_DEX_FEAROW
	NATIONAL_DEX_EKANS,      	// HOENN_DEX_EKANS
	NATIONAL_DEX_ARBOK,      	// HOENN_DEX_ARBOK
	NATIONAL_DEX_NIDORAN_F,  	// HOENN_DEX_NIDORAN♀
	NATIONAL_DEX_NIDORINA,   	// HOENN_DEX_NIDORINA
	NATIONAL_DEX_NIDOQUEEN,  	// HOENN_DEX_NIDOQUEEN
	NATIONAL_DEX_NIDORAN_M,  	// HOENN_DEX_NIDORAN♂
	NATIONAL_DEX_NIDORINO,   	// HOENN_DEX_NIDORINO
	NATIONAL_DEX_NIDOKING,   	// HOENN_DEX_NIDOKING
	NATIONAL_DEX_CLEFAIRY,   	// HOENN_DEX_CLEFAIRY
	NATIONAL_DEX_CLEFABLE,   	// HOENN_DEX_CLEFABLE
	NATIONAL_DEX_PARAS,      	// HOENN_DEX_PARAS
	NATIONAL_DEX_PARASECT,   	// HOENN_DEX_PARASECT
	NATIONAL_DEX_VENONAT,    	// HOENN_DEX_VENONAT
	NATIONAL_DEX_VENOMOTH,   	// HOENN_DEX_VENOMOTH
	NATIONAL_DEX_DIGLETT,    	// HOENN_DEX_DIGLETT
	NATIONAL_DEX_DUGTRIO,    	// HOENN_DEX_DUGTRIO
	NATIONAL_DEX_MEOWTH,     	// HOENN_DEX_MEOWTH
	NATIONAL_DEX_PERSIAN,    	// HOENN_DEX_PERSIAN
	NATIONAL_DEX_MANKEY,     	// HOENN_DEX_MANKEY
	NATIONAL_DEX_PRIMEAPE,   	// HOENN_DEX_PRIMEAPE
	NATIONAL_DEX_GROWLITHE,  	// HOENN_DEX_GROWLITHE
	NATIONAL_DEX_ARCANINE,   	// HOENN_DEX_ARCANINE
	NATIONAL_DEX_POLIWAG,    	// HOENN_DEX_POLIWAG
	NATIONAL_DEX_POLIWHIRL,  	// HOENN_DEX_POLIWHIRL
	NATIONAL_DEX_POLIWRATH,  	// HOENN_DEX_POLIWRATH
	NATIONAL_DEX_BELLSPROUT, 	// HOENN_DEX_BELLSPROUT
	NATIONAL_DEX_WEEPINBELL, 	// HOENN_DEX_WEEPINBELL
	NATIONAL_DEX_VICTREEBEL, 	// HOENN_DEX_VICTREEBEL
	NATIONAL_DEX_PONYTA,     	// HOENN_DEX_PONYTA
	NATIONAL_DEX_RAPIDASH,   	// HOENN_DEX_RAPIDASH
	NATIONAL_DEX_SLOWPOKE,   	// HOENN_DEX_SLOWPOKE
	NATIONAL_DEX_SLOWBRO,    	// HOENN_DEX_SLOWBRO
	NATIONAL_DEX_FARFETCHD,  	// HOENN_DEX_FARFETCH'D
	NATIONAL_DEX_SEEL,       	// HOENN_DEX_SEEL
	NATIONAL_DEX_DEWGONG,    	// HOENN_DEX_DEWGONG
	NATIONAL_DEX_SHELLDER,   	// HOENN_DEX_SHELLDER
	NATIONAL_DEX_CLOYSTER,   	// HOENN_DEX_CLOYSTER
	NATIONAL_DEX_GASTLY,     	// HOENN_DEX_GASTLY
	NATIONAL_DEX_HAUNTER,    	// HOENN_DEX_HAUNTER
	NATIONAL_DEX_GENGAR,     	// HOENN_DEX_GENGAR
	NATIONAL_DEX_ONIX,       	// HOENN_DEX_ONIX
	NATIONAL_DEX_DROWZEE,    	// HOENN_DEX_DROWZEE
	NATIONAL_DEX_HYPNO,      	// HOENN_DEX_HYPNO
	NATIONAL_DEX_KRABBY,     	// HOENN_DEX_KRABBY
	NATIONAL_DEX_KINGLER,    	// HOENN_DEX_KINGLER
	NATIONAL_DEX_EXEGGCUTE,  	// HOENN_DEX_EXEGGCUTE
	NATIONAL_DEX_EXEGGUTOR,  	// HOENN_DEX_EXEGGUTOR
	NATIONAL_DEX_CUBONE,     	// HOENN_DEX_CUBONE
	NATIONAL_DEX_MAROWAK,    	// HOENN_DEX_MAROWAK
	NATIONAL_DEX_HITMONLEE,  	// HOENN_DEX_HITMONLEE
	NATIONAL_DEX_HITMONCHAN, 	// HOENN_DEX_HITMONCHAN
	NATIONAL_DEX_LICKITUNG,  	// HOENN_DEX_LICKITUNG
	NATIONAL_DEX_CHANSEY,    	// HOENN_DEX_CHANSEY
	NATIONAL_DEX_TANGELA,    	// HOENN_DEX_TANGELA
	NATIONAL_DEX_KANGASKHAN, 	// HOENN_DEX_KANGASKHAN
	NATIONAL_DEX_MR_MIME,    	// HOENN_DEX_MR. MIME
	NATIONAL_DEX_SCYTHER,    	// HOENN_DEX_SCYTHER
	NATIONAL_DEX_JYNX,       	// HOENN_DEX_JYNX
	NATIONAL_DEX_ELECTABUZZ, 	// HOENN_DEX_ELECTABUZZ
	NATIONAL_DEX_MAGMAR,     	// HOENN_DEX_MAGMAR
	NATIONAL_DEX_TAUROS,     	// HOENN_DEX_TAUROS
	NATIONAL_DEX_LAPRAS,     	// HOENN_DEX_LAPRAS
	NATIONAL_DEX_DITTO,      	// HOENN_DEX_DITTO
	NATIONAL_DEX_EEVEE,      	// HOENN_DEX_EEVEE
	NATIONAL_DEX_VAPOREON,   	// HOENN_DEX_VAPOREON
	NATIONAL_DEX_JOLTEON,    	// HOENN_DEX_JOLTEON
	NATIONAL_DEX_FLAREON,    	// HOENN_DEX_FLAREON
	NATIONAL_DEX_PORYGON,    	// HOENN_DEX_PORYGON
	NATIONAL_DEX_OMANYTE,    	// HOENN_DEX_OMANYTE
	NATIONAL_DEX_OMASTAR,    	// HOENN_DEX_OMASTAR
	NATIONAL_DEX_KABUTO,     	// HOENN_DEX_KABUTO
	NATIONAL_DEX_KABUTOPS,   	// HOENN_DEX_KABUTOPS
	NATIONAL_DEX_AERODACTYL, 	// HOENN_DEX_AERODACTYL
	NATIONAL_DEX_SNORLAX,    	// HOENN_DEX_SNORLAX
	NATIONAL_DEX_ARTICUNO,   	// HOENN_DEX_ARTICUNO
	NATIONAL_DEX_ZAPDOS,     	// HOENN_DEX_ZAPDOS
	NATIONAL_DEX_MOLTRES,    	// HOENN_DEX_MOLTRES
	NATIONAL_DEX_DRATINI,    	// HOENN_DEX_DRATINI
	NATIONAL_DEX_DRAGONAIR,  	// HOENN_DEX_DRAGONAIR
	NATIONAL_DEX_DRAGONITE,  	// HOENN_DEX_DRAGONITE
	NATIONAL_DEX_MEWTWO,     	// HOENN_DEX_MEWTWO
	NATIONAL_DEX_MEW,        	// HOENN_DEX_MEW
	NATIONAL_DEX_CHIKORITA,  	// HOENN_DEX_CHIKORITA
	NATIONAL_DEX_BAYLEEF,    	// HOENN_DEX_BAYLEEF
	NATIONAL_DEX_MEGANIUM,   	// HOENN_DEX_MEGANIUM
	NATIONAL_DEX_CYNDAQUIL,  	// HOENN_DEX_CYNDAQUIL
	NATIONAL_DEX_QUILAVA,    	// HOENN_DEX_QUILAVA
	NATIONAL_DEX_TYPHLOSION, 	// HOENN_DEX_TYPHLOSION
	NATIONAL_DEX_TOTODILE,   	// HOENN_DEX_TOTODILE
	NATIONAL_DEX_CROCONAW,   	// HOENN_DEX_CROCONAW
	NATIONAL_DEX_FERALIGATR, 	// HOENN_DEX_FERALIGATR
	NATIONAL_DEX_SENTRET,    	// HOENN_DEX_SENTRET
	NATIONAL_DEX_FURRET,     	// HOENN_DEX_FURRET
	NATIONAL_DEX_HOOTHOOT,   	// HOENN_DEX_HOOTHOOT
	NATIONAL_DEX_NOCTOWL,    	// HOENN_DEX_NOCTOWL
	NATIONAL_DEX_LEDYBA,     	// HOENN_DEX_LEDYBA
	NATIONAL_DEX_LEDIAN,     	// HOENN_DEX_LEDIAN
	NATIONAL_DEX_SPINARAK,   	// HOENN_DEX_SPINARAK
	NATIONAL_DEX_ARIADOS,    	// HOENN_DEX_ARIADOS
	NATIONAL_DEX_CLEFFA,     	// HOENN_DEX_CLEFFA
	NATIONAL_DEX_TOGEPI,     	// HOENN_DEX_TOGEPI
	NATIONAL_DEX_TOGETIC,    	// HOENN_DEX_TOGETIC
	NATIONAL_DEX_MAREEP,     	// HOENN_DEX_MAREEP
	NATIONAL_DEX_FLAAFFY,    	// HOENN_DEX_FLAAFFY
	NATIONAL_DEX_AMPHAROS,   	// HOENN_DEX_AMPHAROS
	NATIONAL_DEX_SUDOWOODO,  	// HOENN_DEX_SUDOWOODO
	NATIONAL_DEX_POLITOED,   	// HOENN_DEX_POLITOED
	NATIONAL_DEX_HOPPIP,     	// HOENN_DEX_HOPPIP
	NATIONAL_DEX_SKIPLOOM,   	// HOENN_DEX_SKIPLOOM
	NATIONAL_DEX_JUMPLUFF,   	// HOENN_DEX_JUMPLUFF
	NATIONAL_DEX_AIPOM,      	// HOENN_DEX_AIPOM
	NATIONAL_DEX_SUNKERN,    	// HOENN_DEX_SUNKERN
	NATIONAL_DEX_SUNFLORA,   	// HOENN_DEX_SUNFLORA
	NATIONAL_DEX_YANMA,      	// HOENN_DEX_YANMA
	NATIONAL_DEX_WOOPER,     	// HOENN_DEX_WOOPER
	NATIONAL_DEX_QUAGSIRE,   	// HOENN_DEX_QUAGSIRE
	NATIONAL_DEX_ESPEON,     	// HOENN_DEX_ESPEON
	NATIONAL_DEX_UMBREON,    	// HOENN_DEX_UMBREON
	NATIONAL_DEX_MURKROW,    	// HOENN_DEX_MURKROW
	NATIONAL_DEX_SLOWKING,   	// HOENN_DEX_SLOWKING
	NATIONAL_DEX_MISDREAVUS, 	// HOENN_DEX_MISDREAVUS
	NATIONAL_DEX_UNOWN,      	// HOENN_DEX_UNOWN
	NATIONAL_DEX_PINECO,     	// HOENN_DEX_PINECO
	NATIONAL_DEX_FORRETRESS, 	// HOENN_DEX_FORRETRESS
	NATIONAL_DEX_DUNSPARCE,  	// HOENN_DEX_DUNSPARCE
	NATIONAL_DEX_GLIGAR,     	// HOENN_DEX_GLIGAR
	NATIONAL_DEX_STEELIX,    	// HOENN_DEX_STEELIX
	NATIONAL_DEX_SNUBBULL,   	// HOENN_DEX_SNUBBULL
	NATIONAL_DEX_GRANBULL,   	// HOENN_DEX_GRANBULL
	NATIONAL_DEX_QWILFISH,   	// HOENN_DEX_QWILFISH
	NATIONAL_DEX_SCIZOR,     	// HOENN_DEX_SCIZOR
	NATIONAL_DEX_SHUCKLE,    	// HOENN_DEX_SHUCKLE
	NATIONAL_DEX_SNEASEL,    	// HOENN_DEX_SNEASEL
	NATIONAL_DEX_TEDDIURSA,  	// HOENN_DEX_TEDDIURSA
	NATIONAL_DEX_URSARING,   	// HOENN_DEX_URSARING
	NATIONAL_DEX_SWINUB,     	// HOENN_DEX_SWINUB
	NATIONAL_DEX_PILOSWINE,  	// HOENN_DEX_PILOSWINE
	NATIONAL_DEX_REMORAID,   	// HOENN_DEX_REMORAID
	NATIONAL_DEX_OCTILLERY,  	// HOENN_DEX_OCTILLERY
	NATIONAL_DEX_DELIBIRD,   	// HOENN_DEX_DELIBIRD
	NATIONAL_DEX_MANTINE,    	// HOENN_DEX_MANTINE
	NATIONAL_DEX_HOUNDOUR,   	// HOENN_DEX_HOUNDOUR
	NATIONAL_DEX_HOUNDOOM,   	// HOENN_DEX_HOUNDOOM
	NATIONAL_DEX_PORYGON2,    	// HOENN_DEX_PORYGON2
	NATIONAL_DEX_STANTLER,   	// HOENN_DEX_STANTLER
	NATIONAL_DEX_SMEARGLE,   	// HOENN_DEX_SMEARGLE
	NATIONAL_DEX_TYROGUE,    	// HOENN_DEX_TYROGUE
	NATIONAL_DEX_HITMONTOP,  	// HOENN_DEX_HITMONTOP
	NATIONAL_DEX_SMOOCHUM,   	// HOENN_DEX_SMOOCHUM
	NATIONAL_DEX_ELEKID,     	// HOENN_DEX_ELEKID
	NATIONAL_DEX_MAGBY,      	// HOENN_DEX_MAGBY
	NATIONAL_DEX_MILTANK,    	// HOENN_DEX_MILTANK
	NATIONAL_DEX_BLISSEY,    	// HOENN_DEX_BLISSEY
	NATIONAL_DEX_RAIKOU,     	// HOENN_DEX_RAIKOU
	NATIONAL_DEX_ENTEI,      	// HOENN_DEX_ENTEI
	NATIONAL_DEX_SUICUNE,    	// HOENN_DEX_SUICUNE
	NATIONAL_DEX_LARVITAR,   	// HOENN_DEX_LARVITAR
	NATIONAL_DEX_PUPITAR,    	// HOENN_DEX_PUPITAR
	NATIONAL_DEX_TYRANITAR,  	// HOENN_DEX_TYRANITAR
	NATIONAL_DEX_LUGIA,      	// HOENN_DEX_LUGIA
	NATIONAL_DEX_HO_OH,      	// HOENN_DEX_HO-OH
	NATIONAL_DEX_CELEBI,     	// HOENN_DEX_CELEBI
	NATIONAL_DEX_OLD_UNOWN_B,  	// HOENN_DEX_OLD_UNOWN_B
	NATIONAL_DEX_OLD_UNOWN_C,  	// HOENN_DEX_OLD_UNOWN_C
	NATIONAL_DEX_OLD_UNOWN_D,  	// HOENN_DEX_OLD_UNOWN_D
	NATIONAL_DEX_OLD_UNOWN_E,  	// HOENN_DEX_OLD_UNOWN_E
	NATIONAL_DEX_OLD_UNOWN_F,  	// HOENN_DEX_OLD_UNOWN_F
	NATIONAL_DEX_OLD_UNOWN_G,  	// HOENN_DEX_OLD_UNOWN_G
	NATIONAL_DEX_OLD_UNOWN_H,  	// HOENN_DEX_OLD_UNOWN_H
	NATIONAL_DEX_OLD_UNOWN_I,  	// HOENN_DEX_OLD_UNOWN_I
	NATIONAL_DEX_OLD_UNOWN_J,  	// HOENN_DEX_OLD_UNOWN_J
	NATIONAL_DEX_OLD_UNOWN_K,  	// HOENN_DEX_OLD_UNOWN_K
	NATIONAL_DEX_OLD_UNOWN_L,  	// HOENN_DEX_OLD_UNOWN_L
	NATIONAL_DEX_OLD_UNOWN_M,  	// HOENN_DEX_OLD_UNOWN_M
	NATIONAL_DEX_OLD_UNOWN_N,  	// HOENN_DEX_OLD_UNOWN_N
	NATIONAL_DEX_OLD_UNOWN_O,  	// HOENN_DEX_OLD_UNOWN_O
	NATIONAL_DEX_OLD_UNOWN_P,  	// HOENN_DEX_OLD_UNOWN_P
	NATIONAL_DEX_OLD_UNOWN_Q,  	// HOENN_DEX_OLD_UNOWN_Q
	NATIONAL_DEX_OLD_UNOWN_R,  	// HOENN_DEX_OLD_UNOWN_R
	NATIONAL_DEX_OLD_UNOWN_S,  	// HOENN_DEX_OLD_UNOWN_S
	NATIONAL_DEX_OLD_UNOWN_T,  	// HOENN_DEX_OLD_UNOWN_T
	NATIONAL_DEX_OLD_UNOWN_U,  	// HOENN_DEX_OLD_UNOWN_U
	NATIONAL_DEX_OLD_UNOWN_V,  	// HOENN_DEX_OLD_UNOWN_V
	NATIONAL_DEX_OLD_UNOWN_W,  	// HOENN_DEX_OLD_UNOWN_W
	NATIONAL_DEX_OLD_UNOWN_X,  	// HOENN_DEX_OLD_UNOWN_X
	NATIONAL_DEX_OLD_UNOWN_Y,  	// HOENN_DEX_OLD_UNOWN_Y
	NATIONAL_DEX_OLD_UNOWN_Z,  	// HOENN_DEX_OLD_UNOWN_Z
};

const struct SpindaSpot gSpindaSpotGraphics[] =
{
    {16, 14, INCBIN_U16("graphics/spinda_spots/spot_0.bin")},
    {40, 15, INCBIN_U16("graphics/spinda_spots/spot_1.bin")},
    {22, 32, INCBIN_U16("graphics/spinda_spots/spot_2.bin")},
    {34, 33, INCBIN_U16("graphics/spinda_spots/spot_3.bin")}
};

#include "data/pokemon/item_effects.h"

const s8 gNatureStatTable[][5] =
{
    // Atk Def Spd Sp.Atk Sp.Def
    {    0,  0,  0,     0,     0}, // Hardy
    {   +1, -1,  0,     0,     0}, // Lonely
    {   +1,  0, -1,     0,     0}, // Brave
    {   +1,  0,  0,    -1,     0}, // Adamant
    {   +1,  0,  0,     0,    -1}, // Naughty
    {   -1, +1,  0,     0,     0}, // Bold
    {    0,  0,  0,     0,     0}, // Docile
    {    0, +1, -1,     0,     0}, // Relaxed
    {    0, +1,  0,    -1,     0}, // Impish
    {    0, +1,  0,     0,    -1}, // Lax
    {   -1,  0, +1,     0,     0}, // Timid
    {    0, -1, +1,     0,     0}, // Hasty
    {    0,  0,  0,     0,     0}, // Serious
    {    0,  0, +1,    -1,     0}, // Jolly
    {    0,  0, +1,     0,    -1}, // Naive
    {   -1,  0,  0,    +1,     0}, // Modest
    {    0, -1,  0,    +1,     0}, // Mild
    {    0,  0, -1,    +1,     0}, // Quiet
    {    0,  0,  0,     0,     0}, // Bashful
    {    0,  0,  0,    +1,    -1}, // Rash
    {   -1,  0,  0,     0,    +1}, // Calm
    {    0, -1,  0,     0,    +1}, // Gentle
    {    0,  0, -1,     0,    +1}, // Sassy
    {    0,  0,  0,    -1,    +1}, // Careful
    {    0,  0,  0,     0,     0} // Quirky
};

#include "data/pokemon/tmhm_learnsets.h"
#include "data/pokemon/trainer_class_lookups.h"
#include "data/pokemon/cry_ids.h"
#include "data/pokemon/experience_tables.h"
#include "data/pokemon/base_stats.h"
#include "data/pokemon/level_up_learnsets.h"
#include "data/pokemon/evolution.h"
#include "data/pokemon/level_up_learnset_pointers.h"

void ZeroBoxMonData(struct BoxPokemon *boxMon)
{
    u8 *raw = (u8 *)boxMon;
    u32 i;
    for (i = 0; i < sizeof(struct BoxPokemon); i++)
        raw[i] = 0;
}

void ZeroMonData(struct Pokemon *mon)
{
    u32 arg;
    ZeroBoxMonData(&mon->box);
    arg = 0;
    SetMonData(mon, MON_DATA_STATUS, &arg);
    SetMonData(mon, MON_DATA_LEVEL, &arg);
    SetMonData(mon, MON_DATA_HP, &arg);
    SetMonData(mon, MON_DATA_MAX_HP, &arg);
    SetMonData(mon, MON_DATA_ATK, &arg);
    SetMonData(mon, MON_DATA_DEF, &arg);
    SetMonData(mon, MON_DATA_SPEED, &arg);
    SetMonData(mon, MON_DATA_SPATK, &arg);
    SetMonData(mon, MON_DATA_SPDEF, &arg);
    arg = 255;
    SetMonData(mon, MON_DATA_MAIL, &arg);
}

void ZeroPlayerPartyMons(void)
{
    s32 i;
    for (i = 0; i < 6; i++)
        ZeroMonData(&gPlayerParty[i]);
}

void ZeroEnemyPartyMons(void)
{
    s32 i;
    for (i = 0; i < 6; i++)
        ZeroMonData(&gEnemyParty[i]);
}

void CreateMon(struct Pokemon *mon, u16 species, u8 level, u8 fixedIV, u8 hasFixedPersonality, u32 fixedPersonality, u8 otIdType, u32 fixedOtId)
{
    u32 arg;

    ZeroMonData(mon);
    CreateBoxMon(&mon->box, species, level, fixedIV, hasFixedPersonality, fixedPersonality, otIdType, fixedOtId);
    SetMonData(mon, MON_DATA_LEVEL, &level);
    arg = 255;
    SetMonData(mon, MON_DATA_MAIL, &arg);
    CalculateMonStats(mon);
}

void CreateBoxMon(struct BoxPokemon *boxMon, u16 species, u8 level, u8 fixedIV, u8 hasFixedPersonality, u32 fixedPersonality, u8 otIdType, u32 fixedOtId)
{
    u8 speciesName[POKEMON_NAME_LENGTH + 1];
    u32 personality;
    u32 value;
    u16 checksum;

    ZeroBoxMonData(boxMon);

    if (hasFixedPersonality)
        personality = fixedPersonality;
    else
        personality = Random32();

    SetBoxMonData(boxMon, MON_DATA_PERSONALITY, &personality);

    //Determine original trainer ID
    if (otIdType == 2) //Pokemon cannot be shiny
    {
        u32 shinyValue;
        do
        {
            value = Random32();
            shinyValue = HIHALF(value) ^ LOHALF(value) ^ HIHALF(personality) ^ LOHALF(personality);
        } while (shinyValue < 8);
    }
    else if (otIdType == 1) //Pokemon has a preset OT ID
    {
        value = fixedOtId;
    }
    else //Player is the OT
    {
        value = gSaveBlock2.playerTrainerId[0]
              | (gSaveBlock2.playerTrainerId[1] << 8)
              | (gSaveBlock2.playerTrainerId[2] << 16)
              | (gSaveBlock2.playerTrainerId[3] << 24);
    }

    SetBoxMonData(boxMon, MON_DATA_OT_ID, &value);

    checksum = CalculateBoxMonChecksum(boxMon);
    SetBoxMonData(boxMon, MON_DATA_CHECKSUM, &checksum);
    EncryptBoxMon(boxMon);
    GetSpeciesName(speciesName, species);
    SetBoxMonData(boxMon, MON_DATA_NICKNAME, speciesName);
    SetBoxMonData(boxMon, MON_DATA_LANGUAGE, &gGameLanguage);
    SetBoxMonData(boxMon, MON_DATA_OT_NAME, gSaveBlock2.playerName);
    SetBoxMonData(boxMon, MON_DATA_SPECIES, &species);
    SetBoxMonData(boxMon, MON_DATA_EXP, &gExperienceTables[gBaseStats[species].growthRate][level]);
    SetBoxMonData(boxMon, MON_DATA_FRIENDSHIP, &gBaseStats[species].friendship);
    value = sav1_map_get_name();
    SetBoxMonData(boxMon, MON_DATA_MET_LOCATION, &value);
    SetBoxMonData(boxMon, MON_DATA_MET_LEVEL, &level);
    SetBoxMonData(boxMon, MON_DATA_MET_GAME, &gGameVersion);
    value = 4;
    SetBoxMonData(boxMon, MON_DATA_POKEBALL, &value);
    SetBoxMonData(boxMon, MON_DATA_OT_GENDER, &gSaveBlock2.playerGender);

    if (fixedIV < 32)
    {
        SetBoxMonData(boxMon, MON_DATA_HP_IV, &fixedIV);
        SetBoxMonData(boxMon, MON_DATA_ATK_IV, &fixedIV);
        SetBoxMonData(boxMon, MON_DATA_DEF_IV, &fixedIV);
        SetBoxMonData(boxMon, MON_DATA_SPEED_IV, &fixedIV);
        SetBoxMonData(boxMon, MON_DATA_SPATK_IV, &fixedIV);
        SetBoxMonData(boxMon, MON_DATA_SPDEF_IV, &fixedIV);
    }
    else
    {
        u32 iv;
        value = Random();

        iv = value & 0x1F;
        SetBoxMonData(boxMon, MON_DATA_HP_IV, &iv);
        iv = (value & 0x3E0) >> 5;
        SetBoxMonData(boxMon, MON_DATA_ATK_IV, &iv);
        iv = (value & 0x7C00) >> 10;
        SetBoxMonData(boxMon, MON_DATA_DEF_IV, &iv);

        value = Random();

        iv = value & 0x1F;
        SetBoxMonData(boxMon, MON_DATA_SPEED_IV, &iv);
        iv = (value & 0x3E0) >> 5;
        SetBoxMonData(boxMon, MON_DATA_SPATK_IV, &iv);
        iv = (value & 0x7C00) >> 10;
        SetBoxMonData(boxMon, MON_DATA_SPDEF_IV, &iv);
    }

    if (gBaseStats[species].ability2)
    {
        value = personality & 1;
        SetBoxMonData(boxMon, MON_DATA_ALT_ABILITY, &value);
    }

    GiveBoxMonInitialMoveset(boxMon);
}

void CreateMonWithNature(struct Pokemon *mon, u16 species, u8 level, u8 fixedIV, u8 nature)
{
    u32 personality;

    do
    {
        personality = Random32();
    }
    while (nature != GetNatureFromPersonality(personality));

    CreateMon(mon, species, level, fixedIV, 1, personality, 0, 0);
}

void CreateMonWithGenderNatureLetter(struct Pokemon *mon, u16 species, u8 level, u8 fixedIV, u8 gender, u8 nature, u8 unownLetter)
{
    u32 personality;

    if ((u8)(unownLetter - 1) < 28)
    {
        u16 actualLetter;

        do
        {
            personality = Random32();
            actualLetter = ((((personality & 0x3000000) >> 18) | ((personality & 0x30000) >> 12) | ((personality & 0x300) >> 6) | (personality & 0x3)) % 28);
        }
        while (nature != GetNatureFromPersonality(personality)
            || gender != GetGenderFromSpeciesAndPersonality(species, personality)
            || actualLetter != unownLetter - 1);
    }
    else
    {
        do
        {
            personality = Random32();
        }
        while (nature != GetNatureFromPersonality(personality)
            || gender != GetGenderFromSpeciesAndPersonality(species, personality));
    }

    CreateMon(mon, species, level, fixedIV, 1, personality, 0, 0);
}

// This is only used to create Wally's Ralts.
void CreateMaleMon(struct Pokemon *mon, u16 species, u8 level)
{
    u32 personality;
    u32 otId;

    do
    {
        otId = Random32();
        personality = Random32();
    }
    while (GetGenderFromSpeciesAndPersonality(species, personality) != MON_MALE);
    CreateMon(mon, species, level, 32, 1, personality, 1, otId);
}

void CreateMonWithIVsPersonality(struct Pokemon *mon, u16 species, u8 level, u32 ivs, u32 personality)
{
    CreateMon(mon, species, level, 0, 1, personality, 0, 0);
    SetMonData(mon, MON_DATA_IVS, &ivs);
    CalculateMonStats(mon);
}

void CreateMonWithIVsOTID(struct Pokemon *mon, u16 species, u8 level, u8 *ivs, u32 otId)
{
    CreateMon(mon, species, level, 0, 0, 0, 1, otId);
    SetMonData(mon, MON_DATA_HP_IV, &ivs[0]);
    SetMonData(mon, MON_DATA_ATK_IV, &ivs[1]);
    SetMonData(mon, MON_DATA_DEF_IV, &ivs[2]);
    SetMonData(mon, MON_DATA_SPEED_IV, &ivs[3]);
    SetMonData(mon, MON_DATA_SPATK_IV, &ivs[4]);
    SetMonData(mon, MON_DATA_SPDEF_IV, &ivs[5]);
    CalculateMonStats(mon);
}

void CreateMonWithEVSpread(struct Pokemon *mon, u16 species, u8 level, u8 fixedIV, u8 evSpread)
{
    s32 i;
    s32 statCount = 0;
    u16 evAmount;
    u8 temp;

    CreateMon(mon, species, level, fixedIV, 0, 0, 0, 0);

    temp = evSpread;

    for (i = 0; i < 6; i++)
    {
        if (temp & 1)
            statCount++;
        temp >>= 1;
    }

    evAmount = 510 / statCount;

    temp = 1;

    for (i = 0; i < 6; i++)
    {
        if (evSpread & temp)
            SetMonData(mon, MON_DATA_HP_EV + i, &evAmount);
        temp <<= 1;
    }

    CalculateMonStats(mon);
}

void sub_803ADE8(struct Pokemon *mon, struct UnknownPokemonStruct *src)
{
    s32 i;
    u8 nickname[POKEMON_NAME_LENGTH + 1];
    u8 language;
    u8 value;

    CreateMon(mon, src->species, src->level, 0, 1, src->personality, 1, src->otId);

    for (i = 0; i < 4; i++)
        SetMonMoveSlot(mon, src->moves[i], i);

    SetMonData(mon, MON_DATA_PP_BONUSES, &src->ppBonuses);
    SetMonData(mon, MON_DATA_HELD_ITEM, &src->heldItem);

    StringCopy(nickname, src->nickname);

    if (nickname[0] == 0xFC && nickname[1] == 0x15)
        language = LANGUAGE_JAPANESE;
    else
        language = GAME_LANGUAGE;

    SetMonData(mon, MON_DATA_LANGUAGE, &language);
    Text_StripExtCtrlCodes(nickname);
    SetMonData(mon, MON_DATA_NICKNAME, nickname);
    SetMonData(mon, MON_DATA_FRIENDSHIP, &src->friendship);
    SetMonData(mon, MON_DATA_HP_EV, &src->hpEV);
    SetMonData(mon, MON_DATA_ATK_EV, &src->attackEV);
    SetMonData(mon, MON_DATA_DEF_EV, &src->defenseEV);
    SetMonData(mon, MON_DATA_SPEED_EV, &src->speedEV);
    SetMonData(mon, MON_DATA_SPATK_EV, &src->spAttackEV);
    SetMonData(mon, MON_DATA_SPDEF_EV, &src->spDefenseEV);
    value = src->altAbility;
    SetMonData(mon, MON_DATA_ALT_ABILITY, &value);
    value = src->hpIV;
    SetMonData(mon, MON_DATA_HP_IV, &value);
    value = src->attackIV;
    SetMonData(mon, MON_DATA_ATK_IV, &value);
    value = src->defenseIV;
    SetMonData(mon, MON_DATA_DEF_IV, &value);
    value = src->speedIV;
    SetMonData(mon, MON_DATA_SPEED_IV, &value);
    value = src->spAttackIV;
    SetMonData(mon, MON_DATA_SPATK_IV, &value);
    value = src->spDefenseIV;
    SetMonData(mon, MON_DATA_SPDEF_IV, &value);
    CalculateMonStats(mon);
}

void sub_803AF78(struct Pokemon *mon, struct UnknownPokemonStruct *dest)
{
    s32 i;
    u16 heldItem;

    dest->species = GetMonData(mon, MON_DATA_SPECIES, NULL);
    heldItem = GetMonData(mon, MON_DATA_HELD_ITEM, NULL);

    if (heldItem == ITEM_ENIGMA_BERRY)
        heldItem = 0;

    dest->heldItem = heldItem;

    for (i = 0; i < 4; i++)
        dest->moves[i] = GetMonData(mon, MON_DATA_MOVE1 + i, NULL);

    dest->level = GetMonData(mon, MON_DATA_LEVEL, NULL);
    dest->ppBonuses = GetMonData(mon, MON_DATA_PP_BONUSES, NULL);
    dest->otId = GetMonData(mon, MON_DATA_OT_ID, NULL);
    dest->hpEV = GetMonData(mon, MON_DATA_HP_EV, NULL);
    dest->attackEV = GetMonData(mon, MON_DATA_ATK_EV, NULL);
    dest->defenseEV = GetMonData(mon, MON_DATA_DEF_EV, NULL);
    dest->speedEV = GetMonData(mon, MON_DATA_SPEED_EV, NULL);
    dest->spAttackEV = GetMonData(mon, MON_DATA_SPATK_EV, NULL);
    dest->spDefenseEV = GetMonData(mon, MON_DATA_SPDEF_EV, NULL);
    dest->friendship = GetMonData(mon, MON_DATA_FRIENDSHIP, NULL);
    dest->hpIV = GetMonData(mon, MON_DATA_HP_IV, NULL);
    dest->attackIV = GetMonData(mon, MON_DATA_ATK_IV, NULL);
    dest->defenseIV = GetMonData(mon, MON_DATA_DEF_IV, NULL);
    dest->speedIV  = GetMonData(mon, MON_DATA_SPEED_IV, NULL);
    dest->spAttackIV  = GetMonData(mon, MON_DATA_SPATK_IV, NULL);
    dest->spDefenseIV  = GetMonData(mon, MON_DATA_SPDEF_IV, NULL);
    dest->altAbility = GetMonData(mon, MON_DATA_ALT_ABILITY, NULL);
    dest->personality = GetMonData(mon, MON_DATA_PERSONALITY, NULL);
    GetMonData(mon, MON_DATA_NICKNAME, dest->nickname);
}

u16 CalculateBoxMonChecksum(struct BoxPokemon *boxMon)
{
    u16 checksum = 0;
    union PokemonSubstruct *substruct0 = GetSubstruct(boxMon, boxMon->personality, 0);
    union PokemonSubstruct *substruct1 = GetSubstruct(boxMon, boxMon->personality, 1);
    union PokemonSubstruct *substruct2 = GetSubstruct(boxMon, boxMon->personality, 2);
    union PokemonSubstruct *substruct3 = GetSubstruct(boxMon, boxMon->personality, 3);
    s32 i;

    for (i = 0; i < 6; i++)
        checksum += substruct0->raw[i];

    for (i = 0; i < 6; i++)
        checksum += substruct1->raw[i];

    for (i = 0; i < 6; i++)
        checksum += substruct2->raw[i];

    for (i = 0; i < 6; i++)
        checksum += substruct3->raw[i];

    return checksum;
}

#define CALC_STAT(base, iv, ev, statIndex, field)               \
{                                                               \
    u8 baseStat = gBaseStats[species].base;                     \
    s32 n = (((2 * baseStat + iv + ev / 4) * level) / 100) + 5; \
    u8 nature = GetNature(mon);                                 \
    n = nature_stat_mod(nature, n, statIndex);                  \
    SetMonData(mon, field, &n);                                 \
}

void CalculateMonStats(struct Pokemon *mon)
{
    s32 oldMaxHP = GetMonData(mon, MON_DATA_MAX_HP, NULL);
    s32 currentHP = GetMonData(mon, MON_DATA_HP, NULL);
    s32 hpIV = GetMonData(mon, MON_DATA_HP_IV, NULL);
    s32 hpEV = GetMonData(mon, MON_DATA_HP_EV, NULL);
    s32 attackIV = GetMonData(mon, MON_DATA_ATK_IV, NULL);
    s32 attackEV = GetMonData(mon, MON_DATA_ATK_EV, NULL);
    s32 defenseIV = GetMonData(mon, MON_DATA_DEF_IV, NULL);
    s32 defenseEV = GetMonData(mon, MON_DATA_DEF_EV, NULL);
    s32 speedIV = GetMonData(mon, MON_DATA_SPEED_IV, NULL);
    s32 speedEV = GetMonData(mon, MON_DATA_SPEED_EV, NULL);
    s32 spAttackIV = GetMonData(mon, MON_DATA_SPATK_IV, NULL);
    s32 spAttackEV = GetMonData(mon, MON_DATA_SPATK_EV, NULL);
    s32 spDefenseIV = GetMonData(mon, MON_DATA_SPDEF_IV, NULL);
    s32 spDefenseEV = GetMonData(mon, MON_DATA_SPDEF_EV, NULL);
    u16 species = GetMonData(mon, MON_DATA_SPECIES, NULL);
    s32 level = GetLevelFromMonExp(mon);
    s32 newMaxHP;

    SetMonData(mon, MON_DATA_LEVEL, &level);

    if (species == SPECIES_SHEDINJA)
    {
        newMaxHP = 1;
    }
    else
    {
        s32 n = 2 * gBaseStats[species].baseHP + hpIV;
        newMaxHP = (((n + hpEV / 4) * level) / 100) + level + 10;
    }

    gBattleStruct->levelUpHP = newMaxHP - oldMaxHP;
    if (gBattleStruct->levelUpHP == 0)
        gBattleStruct->levelUpHP = 1;

    SetMonData(mon, MON_DATA_MAX_HP, &newMaxHP);

    CALC_STAT(baseAttack, attackIV, attackEV, 1, MON_DATA_ATK)
    CALC_STAT(baseDefense, defenseIV, defenseEV, 2, MON_DATA_DEF)
    CALC_STAT(baseSpeed, speedIV, speedEV, 3, MON_DATA_SPEED)
    CALC_STAT(baseSpAttack, spAttackIV, spAttackEV, 4, MON_DATA_SPATK)
    CALC_STAT(baseSpDefense, spDefenseIV, spDefenseEV, 5, MON_DATA_SPDEF)

    if (species == SPECIES_SHEDINJA)
    {
        if (currentHP != 0 || oldMaxHP == 0)
            currentHP = 1;
        else
            return;
    }
    else
    {
        if (currentHP == 0 && oldMaxHP == 0)
            currentHP = newMaxHP;
        else if (currentHP != 0) {
            // BUG: currentHP is unintentionally able to become <= 0 after the instruction below.
            currentHP += newMaxHP - oldMaxHP;
            #ifdef BUGFIX
            if (currentHP <= 0)
                currentHP = 1;
            #endif
        }
        else
            return;
    }

    SetMonData(mon, MON_DATA_HP, &currentHP);
}

#if DEBUG
// TODO: check other revisions
#if !(ENGLISH && REVISION == 0)
void Nakamura_NakaGenderTest_RecalcStats(struct Pokemon *mon)
{
    s32 currentHP = GetMonData(mon, MON_DATA_HP, NULL);
    s32 hpIV = GetMonData(mon, MON_DATA_HP_IV, NULL);
    s32 hpEV = GetMonData(mon, MON_DATA_HP_EV, NULL);
    s32 attackIV = GetMonData(mon, MON_DATA_ATK_IV, NULL);
    s32 attackEV = GetMonData(mon, MON_DATA_ATK_EV, NULL);
    s32 defenseIV = GetMonData(mon, MON_DATA_DEF_IV, NULL);
    s32 defenseEV = GetMonData(mon, MON_DATA_DEF_EV, NULL);
    s32 speedIV = GetMonData(mon, MON_DATA_SPEED_IV, NULL);
    s32 speedEV = GetMonData(mon, MON_DATA_SPEED_EV, NULL);
    s32 spAttackIV = GetMonData(mon, MON_DATA_SPATK_IV, NULL);
    s32 spAttackEV = GetMonData(mon, MON_DATA_SPATK_EV, NULL);
    s32 spDefenseIV = GetMonData(mon, MON_DATA_SPDEF_IV, NULL);
    s32 spDefenseEV = GetMonData(mon, MON_DATA_SPDEF_EV, NULL);
    u16 species = GetMonData(mon, MON_DATA_SPECIES, NULL);
    s32 level = GetLevelFromMonExp(mon);
    s32 newMaxHP;

    SetMonData(mon, MON_DATA_LEVEL, &level);

    if (species == SPECIES_SHEDINJA)
    {
        newMaxHP = 1;
    }
    else
    {
        s32 n = 2 * gBaseStats[species].baseHP + hpIV;
        newMaxHP = (((n + hpEV / 4) * level) / 100) + level + 10;
    }

    SetMonData(mon, MON_DATA_MAX_HP, &newMaxHP);

    CALC_STAT(baseAttack, attackIV, attackEV, 1, MON_DATA_ATK)
    CALC_STAT(baseDefense, defenseIV, defenseEV, 2, MON_DATA_DEF)
    CALC_STAT(baseSpeed, speedIV, speedEV, 3, MON_DATA_SPEED)
    CALC_STAT(baseSpAttack, spAttackIV, spAttackEV, 4, MON_DATA_SPATK)
    CALC_STAT(baseSpDefense, spDefenseIV, spDefenseEV, 5, MON_DATA_SPDEF)

    if (newMaxHP < currentHP)
        currentHP = newMaxHP;

    SetMonData(mon, MON_DATA_HP, &currentHP);
}
#endif
#endif

void ExpandBoxMon(const struct BoxPokemon *src, struct Pokemon *dest)
{
    u32 value = 0;
    dest->box = *src;
    SetMonData(dest, MON_DATA_STATUS, &value);
    SetMonData(dest, MON_DATA_HP, &value);
    SetMonData(dest, MON_DATA_MAX_HP, &value);
    value = 255;
    SetMonData(dest, MON_DATA_MAIL, &value);
    CalculateMonStats(dest);
}

u8 GetLevelFromMonExp(struct Pokemon *mon)
{
    u16 species = GetMonData(mon, MON_DATA_SPECIES, NULL);
    u32 exp = GetMonData(mon, MON_DATA_EXP, NULL);
    s32 level = 1;

    while (level <= 100 && gExperienceTables[gBaseStats[species].growthRate][level] <= exp)
        level++;

    return level - 1;
}

u8 GetLevelFromBoxMonExp(struct BoxPokemon *boxMon)
{
    u16 species = GetBoxMonData(boxMon, MON_DATA_SPECIES, NULL);
    u32 exp = GetBoxMonData(boxMon, MON_DATA_EXP, NULL);
    s32 level = 1;

    while (level <= 100 && gExperienceTables[gBaseStats[species].growthRate][level] <= exp)
        level++;

    return level - 1;
}

u16 GiveMoveToMon(struct Pokemon *mon, u16 move)
{
    return GiveMoveToBoxMon(&mon->box, move);
}

u16 GiveMoveToBoxMon(struct BoxPokemon *boxMon, u16 move)
{
    s32 i;
    for (i = 0; i < 4; i++)
    {
        u16 existingMove = GetBoxMonData(boxMon, MON_DATA_MOVE1 + i, NULL);
        if (!existingMove)
        {
            SetBoxMonData(boxMon, MON_DATA_MOVE1 + i, &move);
            SetBoxMonData(boxMon, MON_DATA_PP1 + i, &gBattleMoves[move].pp);
            return move;
        }
        if (existingMove == move)
            return -2;
    }
    return -1;
}

u16 GiveMoveToBattleMon(struct BattlePokemon *mon, u16 move)
{
    s32 i;

    for (i = 0; i < 4; i++)
    {
        if (!mon->moves[i])
        {
            mon->moves[i] = move;
            mon->pp[i] = gBattleMoves[move].pp;
            return move;
        }
    }

    return -1;
}

void SetMonMoveSlot(struct Pokemon *mon, u16 move, u8 slot)
{
    SetMonData(mon, MON_DATA_MOVE1 + slot, &move);
    SetMonData(mon, MON_DATA_PP1 + slot, &gBattleMoves[move].pp);
}

void SetBattleMonMoveSlot(struct BattlePokemon *mon, u16 move, u8 slot)
{
    mon->moves[slot] = move;
    mon->pp[slot] = gBattleMoves[move].pp;
}

void GiveMonInitialMoveset(struct Pokemon *mon)
{
    GiveBoxMonInitialMoveset(&mon->box);
}

void GiveBoxMonInitialMoveset(struct BoxPokemon *boxMon)
{
    u16 species = GetBoxMonData(boxMon, MON_DATA_SPECIES, NULL);
    s32 level = GetLevelFromBoxMonExp(boxMon);
    s32 i;

    for (i = 0; gLevelUpLearnsets[species][i] != (u16)-1; i++)
    {
        u16 moveLevel;
        u16 move;

        moveLevel = (gLevelUpLearnsets[species][i] & 0xFE00);

        if (moveLevel > (level << 9))
            break;

        move = (gLevelUpLearnsets[species][i] & 0x1FF);

        if (GiveMoveToBoxMon(boxMon, move) == (u16)-1)
            DeleteFirstMoveAndGiveMoveToBoxMon(boxMon, move);
    }
}

u16 MonTryLearningNewMove(struct Pokemon *mon, bool8 firstMove)
{
    u32 retVal = 0;
    u16 species = GetMonData(mon, MON_DATA_SPECIES, NULL);
    u8 level = GetMonData(mon, MON_DATA_LEVEL, NULL);

    // since you can learn more than one move per level
    // the game needs to know whether you decided to
    // learn it or keep the old set to avoid asking
    // you to learn the same move over and over again
    if (firstMove)
    {
        sLearningMoveTableID = 0;

        while ((gLevelUpLearnsets[species][sLearningMoveTableID] & 0xFE00) != (level << 9))
        {
            sLearningMoveTableID++;
            if (gLevelUpLearnsets[species][sLearningMoveTableID] == 0xFFFF)
                return 0;
        }
    }

    if ((gLevelUpLearnsets[species][sLearningMoveTableID] & 0xFE00) == (level << 9))
    {
        gMoveToLearn = (gLevelUpLearnsets[species][sLearningMoveTableID] & 0x1FF);
        sLearningMoveTableID++;
        retVal = GiveMoveToMon(mon, gMoveToLearn);
    }

    return retVal;
}

void DeleteFirstMoveAndGiveMoveToMon(struct Pokemon *mon, u16 move)
{
    s32 i;
    u16 moves[4];
    u8 pp[4];
    u8 ppBonuses;

    for (i = 0; i < 3; i++)
    {
        moves[i] = GetMonData(mon, MON_DATA_MOVE2 + i, NULL);
        pp[i] = GetMonData(mon, MON_DATA_PP2 + i, NULL);
    }

    ppBonuses = GetMonData(mon, MON_DATA_PP_BONUSES, NULL);
    ppBonuses >>= 2;
    moves[3] = move;
    pp[3] = gBattleMoves[move].pp;

    for (i = 0; i < 4; i++)
    {
        SetMonData(mon, MON_DATA_MOVE1 + i, &moves[i]);
        SetMonData(mon, MON_DATA_PP1 + i, &pp[i]);
    }

    SetMonData(mon, MON_DATA_PP_BONUSES, &ppBonuses);
}

void DeleteFirstMoveAndGiveMoveToBoxMon(struct BoxPokemon *boxMon, u16 move)
{
    s32 i;
    u16 moves[4];
    u8 pp[4];
    u8 ppBonuses;

    for (i = 0; i < 3; i++)
    {
        moves[i] = GetBoxMonData(boxMon, MON_DATA_MOVE2 + i, NULL);
        pp[i] = GetBoxMonData(boxMon, MON_DATA_PP2 + i, NULL);
    }

    ppBonuses = GetBoxMonData(boxMon, MON_DATA_PP_BONUSES, NULL);
    ppBonuses >>= 2;
    moves[3] = move;
    pp[3] = gBattleMoves[move].pp;

    for (i = 0; i < 4; i++)
    {
        SetBoxMonData(boxMon, MON_DATA_MOVE1 + i, &moves[i]);
        SetBoxMonData(boxMon, MON_DATA_PP1 + i, &pp[i]);
    }

    SetBoxMonData(boxMon, MON_DATA_PP_BONUSES, &ppBonuses);
}
