//

//

#ifndef POKERUBY_LEVEL_UP_LEARNSETS_H
#define POKERUBY_LEVEL_UP_LEARNSETS_H

#define LEVEL_UP_MOVE(lvl, move) ((lvl << 9) | move)
#define LEVEL_UP_END 0xffff

const u16 gBulbasaurLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 4, MOVE_GROWL),
    LEVEL_UP_MOVE( 7, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(10, MOVE_VINE_WHIP),
    LEVEL_UP_MOVE(15, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(15, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(20, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE(25, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(32, MOVE_GROWTH),
    LEVEL_UP_MOVE(39, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE(46, MOVE_SOLAR_BEAM),
    LEVEL_UP_END
};

const u16 gIvysaurLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE( 4, MOVE_GROWL),
    LEVEL_UP_MOVE( 7, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(10, MOVE_VINE_WHIP),
    LEVEL_UP_MOVE(15, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(15, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(22, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE(29, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(38, MOVE_GROWTH),
    LEVEL_UP_MOVE(47, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE(56, MOVE_SOLAR_BEAM),
    LEVEL_UP_END
};

const u16 gVenusaurLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE( 1, MOVE_VINE_WHIP),
    LEVEL_UP_MOVE( 4, MOVE_GROWL),
    LEVEL_UP_MOVE( 7, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(10, MOVE_VINE_WHIP),
    LEVEL_UP_MOVE(15, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(15, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(22, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE(29, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(41, MOVE_GROWTH),
    LEVEL_UP_MOVE(53, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE(65, MOVE_SOLAR_BEAM),
    LEVEL_UP_END
};

const u16 gCharmanderLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 7, MOVE_EMBER),
    LEVEL_UP_MOVE(13, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(19, MOVE_RAGE),
    LEVEL_UP_MOVE(25, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(31, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(37, MOVE_SLASH),
    LEVEL_UP_MOVE(43, MOVE_DRAGON_RAGE),
    LEVEL_UP_MOVE(49, MOVE_FIRE_SPIN),
    LEVEL_UP_END
};

const u16 gCharmeleonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 7, MOVE_EMBER),
    LEVEL_UP_MOVE(13, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(20, MOVE_RAGE),
    LEVEL_UP_MOVE(27, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(34, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(41, MOVE_SLASH),
    LEVEL_UP_MOVE(48, MOVE_DRAGON_RAGE),
    LEVEL_UP_MOVE(55, MOVE_FIRE_SPIN),
    LEVEL_UP_END
};

const u16 gCharizardLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 1, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE( 7, MOVE_EMBER),
    LEVEL_UP_MOVE(13, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(20, MOVE_RAGE),
    LEVEL_UP_MOVE(27, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(34, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(36, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(44, MOVE_SLASH),
    LEVEL_UP_MOVE(54, MOVE_DRAGON_RAGE),
    LEVEL_UP_MOVE(64, MOVE_FIRE_SPIN),
    LEVEL_UP_END
};

const u16 gSquirtleLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 4, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 7, MOVE_BUBBLE),
    LEVEL_UP_MOVE(10, MOVE_WITHDRAW),
    LEVEL_UP_MOVE(13, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(18, MOVE_BITE),
    LEVEL_UP_MOVE(23, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE(28, MOVE_PROTECT),
    LEVEL_UP_MOVE(33, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(40, MOVE_SKULL_BASH),
    LEVEL_UP_MOVE(47, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gWartortleLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 4, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 7, MOVE_BUBBLE),
    LEVEL_UP_MOVE(10, MOVE_WITHDRAW),
    LEVEL_UP_MOVE(13, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(19, MOVE_BITE),
    LEVEL_UP_MOVE(25, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE(31, MOVE_PROTECT),
    LEVEL_UP_MOVE(37, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(45, MOVE_SKULL_BASH),
    LEVEL_UP_MOVE(53, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gBlastoiseLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 1, MOVE_WITHDRAW),
    LEVEL_UP_MOVE( 4, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 7, MOVE_BUBBLE),
    LEVEL_UP_MOVE(10, MOVE_WITHDRAW),
    LEVEL_UP_MOVE(13, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(19, MOVE_BITE),
    LEVEL_UP_MOVE(25, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE(31, MOVE_PROTECT),
    LEVEL_UP_MOVE(42, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(55, MOVE_SKULL_BASH),
    LEVEL_UP_MOVE(68, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gCaterpieLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_STRING_SHOT),
    LEVEL_UP_END
};

const u16 gMetapodLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_HARDEN),
    LEVEL_UP_END
};

const u16 gButterfreeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE(10, MOVE_CONFUSION),
    LEVEL_UP_MOVE(13, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(14, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(15, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(18, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(23, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(28, MOVE_GUST),
    LEVEL_UP_MOVE(34, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(40, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(47, MOVE_SILVER_WIND),
    LEVEL_UP_END
};

const u16 gWeedleLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE( 1, MOVE_STRING_SHOT),
    LEVEL_UP_END
};

const u16 gKakunaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_HARDEN),
    LEVEL_UP_END
};

const u16 gBeedrillLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(10, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(15, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(20, MOVE_TWINEEDLE),
    LEVEL_UP_MOVE(25, MOVE_RAGE),
    LEVEL_UP_MOVE(30, MOVE_PURSUIT),
    LEVEL_UP_MOVE(35, MOVE_PIN_MISSILE),
    LEVEL_UP_MOVE(40, MOVE_AGILITY),
    LEVEL_UP_MOVE(45, MOVE_ENDEAVOR),
    LEVEL_UP_END
};

const u16 gPidgeyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 5, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 9, MOVE_GUST),
    LEVEL_UP_MOVE(13, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(19, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(25, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(31, MOVE_FEATHER_DANCE),
    LEVEL_UP_MOVE(39, MOVE_AGILITY),
    LEVEL_UP_MOVE(47, MOVE_MIRROR_MOVE),
    LEVEL_UP_END
};

const u16 gPidgeottoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_GUST),
    LEVEL_UP_MOVE( 5, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 9, MOVE_GUST),
    LEVEL_UP_MOVE(13, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(20, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(27, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(34, MOVE_FEATHER_DANCE),
    LEVEL_UP_MOVE(43, MOVE_AGILITY),
    LEVEL_UP_MOVE(52, MOVE_MIRROR_MOVE),
    LEVEL_UP_END
};

const u16 gPidgeotLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_GUST),
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 5, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 9, MOVE_GUST),
    LEVEL_UP_MOVE(13, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(20, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(27, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(34, MOVE_FEATHER_DANCE),
    LEVEL_UP_MOVE(48, MOVE_AGILITY),
    LEVEL_UP_MOVE(62, MOVE_MIRROR_MOVE),
    LEVEL_UP_END
};

const u16 gRattataLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 7, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_HYPER_FANG),
    LEVEL_UP_MOVE(20, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(27, MOVE_PURSUIT),
    LEVEL_UP_MOVE(34, MOVE_SUPER_FANG),
    LEVEL_UP_MOVE(41, MOVE_ENDEAVOR),
    LEVEL_UP_END
};

const u16 gRaticateLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 7, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_HYPER_FANG),
    LEVEL_UP_MOVE(20, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(30, MOVE_PURSUIT),
    LEVEL_UP_MOVE(40, MOVE_SUPER_FANG),
    LEVEL_UP_MOVE(50, MOVE_ENDEAVOR),
    LEVEL_UP_END
};

const u16 gSpearowLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 7, MOVE_LEER),
    LEVEL_UP_MOVE(13, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(19, MOVE_PURSUIT),
    LEVEL_UP_MOVE(25, MOVE_AERIAL_ACE),
    LEVEL_UP_MOVE(31, MOVE_MIRROR_MOVE),
    LEVEL_UP_MOVE(37, MOVE_DRILL_PECK),
    LEVEL_UP_MOVE(43, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gFearowLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE( 7, MOVE_LEER),
    LEVEL_UP_MOVE(13, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(26, MOVE_PURSUIT),
    LEVEL_UP_MOVE(32, MOVE_MIRROR_MOVE),
    LEVEL_UP_MOVE(40, MOVE_DRILL_PECK),
    LEVEL_UP_MOVE(47, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gEkansLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WRAP),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 8, MOVE_POISON_STING),
    LEVEL_UP_MOVE(13, MOVE_BITE),
    LEVEL_UP_MOVE(20, MOVE_GLARE),
    LEVEL_UP_MOVE(25, MOVE_SCREECH),
    LEVEL_UP_MOVE(32, MOVE_ACID),
    LEVEL_UP_MOVE(37, MOVE_STOCKPILE),
    LEVEL_UP_MOVE(37, MOVE_SWALLOW),
    LEVEL_UP_MOVE(37, MOVE_SPIT_UP),
    LEVEL_UP_MOVE(44, MOVE_HAZE),
    LEVEL_UP_END
};

const u16 gArbokLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WRAP),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 8, MOVE_POISON_STING),
    LEVEL_UP_MOVE(13, MOVE_BITE),
    LEVEL_UP_MOVE(20, MOVE_GLARE),
    LEVEL_UP_MOVE(28, MOVE_SCREECH),
    LEVEL_UP_MOVE(38, MOVE_ACID),
    LEVEL_UP_MOVE(46, MOVE_STOCKPILE),
    LEVEL_UP_MOVE(46, MOVE_SWALLOW),
    LEVEL_UP_MOVE(46, MOVE_SPIT_UP),
    LEVEL_UP_MOVE(56, MOVE_HAZE),
    LEVEL_UP_END
};

const u16 gPikachuLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 6, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 8, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(11, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(15, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(20, MOVE_SLAM),
    LEVEL_UP_MOVE(26, MOVE_THUNDERBOLT),
    LEVEL_UP_MOVE(33, MOVE_AGILITY),
    LEVEL_UP_MOVE(41, MOVE_THUNDER),
    LEVEL_UP_MOVE(50, MOVE_LIGHT_SCREEN),
    LEVEL_UP_END
};

const u16 gRaichuLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_THUNDERBOLT),
    LEVEL_UP_END
};

const u16 gSandshrewLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 6, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(11, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(17, MOVE_POISON_STING),
    LEVEL_UP_MOVE(23, MOVE_SLASH),
    LEVEL_UP_MOVE(30, MOVE_SWIFT),
    LEVEL_UP_MOVE(37, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(45, MOVE_SAND_TOMB),
    LEVEL_UP_MOVE(53, MOVE_SANDSTORM),
    LEVEL_UP_END
};

const u16 gSandslashLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 1, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 6, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(11, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(17, MOVE_POISON_STING),
    LEVEL_UP_MOVE(24, MOVE_SLASH),
    LEVEL_UP_MOVE(33, MOVE_SWIFT),
    LEVEL_UP_MOVE(42, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(52, MOVE_SAND_TOMB),
    LEVEL_UP_MOVE(62, MOVE_SANDSTORM),
    LEVEL_UP_END
};

const u16 gNidoranFLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 8, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(12, MOVE_DOUBLE_KICK),
    LEVEL_UP_MOVE(17, MOVE_POISON_STING),
    LEVEL_UP_MOVE(20, MOVE_BITE),
    LEVEL_UP_MOVE(23, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(30, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(38, MOVE_FLATTER),
    LEVEL_UP_MOVE(47, MOVE_CRUNCH),
    LEVEL_UP_END
};

const u16 gNidorinaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 8, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(12, MOVE_DOUBLE_KICK),
    LEVEL_UP_MOVE(18, MOVE_POISON_STING),
    LEVEL_UP_MOVE(22, MOVE_BITE),
    LEVEL_UP_MOVE(26, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(34, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(43, MOVE_FLATTER),
    LEVEL_UP_MOVE(53, MOVE_CRUNCH),
    LEVEL_UP_END
};

const u16 gNidoqueenLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_KICK),
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE(23, MOVE_BODY_SLAM),
    LEVEL_UP_END
};

const u16 gNidoranMLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 8, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(12, MOVE_DOUBLE_KICK),
    LEVEL_UP_MOVE(17, MOVE_POISON_STING),
    LEVEL_UP_MOVE(20, MOVE_HORN_ATTACK),
    LEVEL_UP_MOVE(23, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(30, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(38, MOVE_FLATTER),
    LEVEL_UP_MOVE(47, MOVE_HORN_DRILL),
    LEVEL_UP_END
};

const u16 gNidorinoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 8, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(12, MOVE_DOUBLE_KICK),
    LEVEL_UP_MOVE(18, MOVE_POISON_STING),
    LEVEL_UP_MOVE(22, MOVE_HORN_ATTACK),
    LEVEL_UP_MOVE(26, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(34, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(43, MOVE_FLATTER),
    LEVEL_UP_MOVE(53, MOVE_HORN_DRILL),
    LEVEL_UP_END
};

const u16 gNidokingLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_KICK),
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE(23, MOVE_THRASH),
    LEVEL_UP_END
};

const u16 gClefairyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 5, MOVE_ENCORE),
    LEVEL_UP_MOVE( 9, MOVE_SING),
    LEVEL_UP_MOVE(13, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE(17, MOVE_FOLLOW_ME),
    LEVEL_UP_MOVE(21, MOVE_MINIMIZE),
    LEVEL_UP_MOVE(25, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(29, MOVE_METRONOME),
    LEVEL_UP_MOVE(33, MOVE_COSMIC_POWER),
    LEVEL_UP_MOVE(37, MOVE_MOONLIGHT),
    LEVEL_UP_MOVE(41, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(45, MOVE_METEOR_MASH),
    LEVEL_UP_END
};

const u16 gClefableLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SING),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE( 1, MOVE_MINIMIZE),
    LEVEL_UP_MOVE( 1, MOVE_METRONOME),
    LEVEL_UP_END
};

const u16 gVulpixLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 9, MOVE_ROAR),
    LEVEL_UP_MOVE(13, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(17, MOVE_WILL_O_WISP),
    LEVEL_UP_MOVE(21, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(25, MOVE_IMPRISON),
    LEVEL_UP_MOVE(29, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(33, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(37, MOVE_GRUDGE),
    LEVEL_UP_MOVE(41, MOVE_FIRE_SPIN),
    LEVEL_UP_END
};

const u16 gNinetalesLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE( 1, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(45, MOVE_FIRE_SPIN),
    LEVEL_UP_END
};

const u16 gJigglypuffLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SING),
    LEVEL_UP_MOVE( 4, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 9, MOVE_POUND),
    LEVEL_UP_MOVE(14, MOVE_DISABLE),
    LEVEL_UP_MOVE(19, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(24, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE(29, MOVE_REST),
    LEVEL_UP_MOVE(34, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(39, MOVE_MIMIC),
    LEVEL_UP_MOVE(44, MOVE_HYPER_VOICE),
    LEVEL_UP_MOVE(49, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gWigglytuffLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SING),
    LEVEL_UP_MOVE( 1, MOVE_DISABLE),
    LEVEL_UP_MOVE( 1, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_SLAP),
    LEVEL_UP_END
};

const u16 gZubatLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE( 6, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(11, MOVE_ASTONISH),
    LEVEL_UP_MOVE(16, MOVE_BITE),
    LEVEL_UP_MOVE(21, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(26, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(31, MOVE_AIR_CUTTER),
    LEVEL_UP_MOVE(36, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(41, MOVE_POISON_FANG),
    LEVEL_UP_MOVE(46, MOVE_HAZE),
    LEVEL_UP_END
};

const u16 gGolbatLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCREECH),
    LEVEL_UP_MOVE( 1, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE( 1, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 6, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(11, MOVE_ASTONISH),
    LEVEL_UP_MOVE(16, MOVE_BITE),
    LEVEL_UP_MOVE(21, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(28, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(35, MOVE_AIR_CUTTER),
    LEVEL_UP_MOVE(42, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(49, MOVE_POISON_FANG),
    LEVEL_UP_MOVE(56, MOVE_HAZE),
    LEVEL_UP_END
};

const u16 gOddishLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 7, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(14, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(16, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(18, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(23, MOVE_ACID),
    LEVEL_UP_MOVE(32, MOVE_MOONLIGHT),
    LEVEL_UP_MOVE(39, MOVE_PETAL_DANCE),
    LEVEL_UP_END
};

const u16 gGloomLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 1, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE( 1, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE( 7, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(14, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(16, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(18, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(24, MOVE_ACID),
    LEVEL_UP_MOVE(35, MOVE_MOONLIGHT),
    LEVEL_UP_MOVE(44, MOVE_PETAL_DANCE),
    LEVEL_UP_END
};

const u16 gVileplumeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 1, MOVE_AROMATHERAPY),
    LEVEL_UP_MOVE( 1, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE( 1, MOVE_MEGA_DRAIN),
    LEVEL_UP_MOVE(44, MOVE_PETAL_DANCE),
    LEVEL_UP_END
};

const u16 gParasLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 7, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(13, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(19, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE(25, MOVE_SPORE),
    LEVEL_UP_MOVE(31, MOVE_SLASH),
    LEVEL_UP_MOVE(37, MOVE_GROWTH),
    LEVEL_UP_MOVE(43, MOVE_GIGA_DRAIN),
    LEVEL_UP_MOVE(49, MOVE_AROMATHERAPY),
    LEVEL_UP_END
};

const u16 gParasectLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE( 1, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE( 7, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(13, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(19, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE(27, MOVE_SPORE),
    LEVEL_UP_MOVE(35, MOVE_SLASH),
    LEVEL_UP_MOVE(43, MOVE_GROWTH),
    LEVEL_UP_MOVE(51, MOVE_GIGA_DRAIN),
    LEVEL_UP_MOVE(59, MOVE_AROMATHERAPY),
    LEVEL_UP_END
};

const u16 gVenonatLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_DISABLE),
    LEVEL_UP_MOVE( 1, MOVE_FORESIGHT),
    LEVEL_UP_MOVE( 9, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(17, MOVE_CONFUSION),
    LEVEL_UP_MOVE(20, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(25, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE(28, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(33, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(36, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(41, MOVE_PSYCHIC),
    LEVEL_UP_END
};

const u16 gVenomothLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SILVER_WIND),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_DISABLE),
    LEVEL_UP_MOVE( 1, MOVE_FORESIGHT),
    LEVEL_UP_MOVE( 1, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE( 9, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(17, MOVE_CONFUSION),
    LEVEL_UP_MOVE(20, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(25, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE(28, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(31, MOVE_GUST),
    LEVEL_UP_MOVE(36, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(42, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(52, MOVE_PSYCHIC),
    LEVEL_UP_END
};

const u16 gDiglettLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 5, MOVE_GROWL),
    LEVEL_UP_MOVE( 9, MOVE_MAGNITUDE),
    LEVEL_UP_MOVE(17, MOVE_DIG),
    LEVEL_UP_MOVE(25, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(33, MOVE_SLASH),
    LEVEL_UP_MOVE(41, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(49, MOVE_FISSURE),
    LEVEL_UP_END
};

const u16 gDugtrioLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TRI_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 5, MOVE_GROWL),
    LEVEL_UP_MOVE( 9, MOVE_MAGNITUDE),
    LEVEL_UP_MOVE(17, MOVE_DIG),
    LEVEL_UP_MOVE(25, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(26, MOVE_SAND_TOMB),
    LEVEL_UP_MOVE(38, MOVE_SLASH),
    LEVEL_UP_MOVE(51, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(64, MOVE_FISSURE),
    LEVEL_UP_END
};

const u16 gMeowthLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE(11, MOVE_BITE),
    LEVEL_UP_MOVE(20, MOVE_PAY_DAY),
    LEVEL_UP_MOVE(28, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(35, MOVE_SCREECH),
    LEVEL_UP_MOVE(41, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(46, MOVE_SLASH),
    LEVEL_UP_MOVE(50, MOVE_FAKE_OUT),
    LEVEL_UP_END
};

const u16 gPersianLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE(11, MOVE_BITE),
    LEVEL_UP_MOVE(20, MOVE_PAY_DAY),
    LEVEL_UP_MOVE(29, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(38, MOVE_SCREECH),
    LEVEL_UP_MOVE(46, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(53, MOVE_SLASH),
    LEVEL_UP_MOVE(59, MOVE_FAKE_OUT),
    LEVEL_UP_END
};

const u16 gPsyduckLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(10, MOVE_DISABLE),
    LEVEL_UP_MOVE(16, MOVE_CONFUSION),
    LEVEL_UP_MOVE(23, MOVE_SCREECH),
    LEVEL_UP_MOVE(31, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(40, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(50, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gGolduckLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_DISABLE),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(10, MOVE_DISABLE),
    LEVEL_UP_MOVE(16, MOVE_CONFUSION),
    LEVEL_UP_MOVE(23, MOVE_SCREECH),
    LEVEL_UP_MOVE(31, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(44, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(58, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gMankeyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 9, MOVE_LOW_KICK),
    LEVEL_UP_MOVE(15, MOVE_KARATE_CHOP),
    LEVEL_UP_MOVE(21, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(27, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(33, MOVE_SEISMIC_TOSS),
    LEVEL_UP_MOVE(39, MOVE_CROSS_CHOP),
    LEVEL_UP_MOVE(45, MOVE_SCREECH),
    LEVEL_UP_MOVE(51, MOVE_THRASH),
    LEVEL_UP_END
};

const u16 gPrimeapeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_LOW_KICK),
    LEVEL_UP_MOVE( 1, MOVE_RAGE),
    LEVEL_UP_MOVE( 9, MOVE_LOW_KICK),
    LEVEL_UP_MOVE(15, MOVE_KARATE_CHOP),
    LEVEL_UP_MOVE(21, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(27, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(28, MOVE_RAGE),
    LEVEL_UP_MOVE(36, MOVE_SEISMIC_TOSS),
    LEVEL_UP_MOVE(45, MOVE_CROSS_CHOP),
    LEVEL_UP_MOVE(54, MOVE_SCREECH),
    LEVEL_UP_MOVE(63, MOVE_THRASH),
    LEVEL_UP_END
};

const u16 gGrowlitheLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_ROAR),
    LEVEL_UP_MOVE( 7, MOVE_EMBER),
    LEVEL_UP_MOVE(13, MOVE_LEER),
    LEVEL_UP_MOVE(19, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(25, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(31, MOVE_FLAME_WHEEL),
    LEVEL_UP_MOVE(37, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(43, MOVE_AGILITY),
    LEVEL_UP_MOVE(49, MOVE_FLAMETHROWER),
    LEVEL_UP_END
};

const u16 gArcanineLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_ROAR),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 1, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(49, MOVE_EXTREME_SPEED),
    LEVEL_UP_END
};

const u16 gPoliwagLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 7, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(13, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(19, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE(25, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(31, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(37, MOVE_BELLY_DRUM),
    LEVEL_UP_MOVE(43, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gPoliwhirlLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 1, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 7, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(13, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(19, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE(27, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(35, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(43, MOVE_BELLY_DRUM),
    LEVEL_UP_MOVE(51, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gPoliwrathLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE( 1, MOVE_SUBMISSION),
    LEVEL_UP_MOVE(35, MOVE_SUBMISSION),
    LEVEL_UP_MOVE(51, MOVE_MIND_READER),
    LEVEL_UP_END
};

const u16 gAbraLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TELEPORT),
    LEVEL_UP_END
};

const u16 gKadabraLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TELEPORT),
    LEVEL_UP_MOVE( 1, MOVE_KINESIS),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE(16, MOVE_CONFUSION),
    LEVEL_UP_MOVE(18, MOVE_DISABLE),
    LEVEL_UP_MOVE(21, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(23, MOVE_REFLECT),
    LEVEL_UP_MOVE(25, MOVE_RECOVER),
    LEVEL_UP_MOVE(30, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(33, MOVE_ROLE_PLAY),
    LEVEL_UP_MOVE(36, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(43, MOVE_TRICK),
    LEVEL_UP_END
};

const u16 gAlakazamLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TELEPORT),
    LEVEL_UP_MOVE( 1, MOVE_KINESIS),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE(16, MOVE_CONFUSION),
    LEVEL_UP_MOVE(18, MOVE_DISABLE),
    LEVEL_UP_MOVE(21, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(23, MOVE_REFLECT),
    LEVEL_UP_MOVE(25, MOVE_RECOVER),
    LEVEL_UP_MOVE(30, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(33, MOVE_CALM_MIND),
    LEVEL_UP_MOVE(36, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(43, MOVE_TRICK),
    LEVEL_UP_END
};

const u16 gMachopLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LOW_KICK),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 7, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(13, MOVE_KARATE_CHOP),
    LEVEL_UP_MOVE(19, MOVE_SEISMIC_TOSS),
    LEVEL_UP_MOVE(22, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(25, MOVE_REVENGE),
    LEVEL_UP_MOVE(31, MOVE_VITAL_THROW),
    LEVEL_UP_MOVE(37, MOVE_SUBMISSION),
    LEVEL_UP_MOVE(40, MOVE_CROSS_CHOP),
    LEVEL_UP_MOVE(43, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(49, MOVE_DYNAMIC_PUNCH),
    LEVEL_UP_END
};

const u16 gMachokeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LOW_KICK),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 7, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(13, MOVE_KARATE_CHOP),
    LEVEL_UP_MOVE(19, MOVE_SEISMIC_TOSS),
    LEVEL_UP_MOVE(22, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(25, MOVE_REVENGE),
    LEVEL_UP_MOVE(33, MOVE_VITAL_THROW),
    LEVEL_UP_MOVE(41, MOVE_SUBMISSION),
    LEVEL_UP_MOVE(46, MOVE_CROSS_CHOP),
    LEVEL_UP_MOVE(51, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(59, MOVE_DYNAMIC_PUNCH),
    LEVEL_UP_END
};

const u16 gMachampLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LOW_KICK),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 7, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(13, MOVE_KARATE_CHOP),
    LEVEL_UP_MOVE(19, MOVE_SEISMIC_TOSS),
    LEVEL_UP_MOVE(22, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(25, MOVE_REVENGE),
    LEVEL_UP_MOVE(33, MOVE_VITAL_THROW),
    LEVEL_UP_MOVE(41, MOVE_SUBMISSION),
    LEVEL_UP_MOVE(46, MOVE_CROSS_CHOP),
    LEVEL_UP_MOVE(51, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(59, MOVE_DYNAMIC_PUNCH),
    LEVEL_UP_END
};

const u16 gBellsproutLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_VINE_WHIP),
    LEVEL_UP_MOVE( 6, MOVE_GROWTH),
    LEVEL_UP_MOVE(11, MOVE_WRAP),
    LEVEL_UP_MOVE(15, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(17, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(19, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(23, MOVE_ACID),
    LEVEL_UP_MOVE(30, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(37, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE(45, MOVE_SLAM),
    LEVEL_UP_END
};

const u16 gWeepinbellLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_VINE_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_GROWTH),
    LEVEL_UP_MOVE( 1, MOVE_WRAP),
    LEVEL_UP_MOVE( 6, MOVE_GROWTH),
    LEVEL_UP_MOVE(11, MOVE_WRAP),
    LEVEL_UP_MOVE(15, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(17, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(19, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(24, MOVE_ACID),
    LEVEL_UP_MOVE(33, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(42, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE(54, MOVE_SLAM),
    LEVEL_UP_END
};

const u16 gVictreebelLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_VINE_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE( 1, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE( 1, MOVE_RAZOR_LEAF),
    LEVEL_UP_END
};

const u16 gTentacoolLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE( 6, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(12, MOVE_CONSTRICT),
    LEVEL_UP_MOVE(19, MOVE_ACID),
    LEVEL_UP_MOVE(25, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(30, MOVE_WRAP),
    LEVEL_UP_MOVE(36, MOVE_BARRIER),
    LEVEL_UP_MOVE(43, MOVE_SCREECH),
    LEVEL_UP_MOVE(49, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gTentacruelLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE( 1, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE( 1, MOVE_CONSTRICT),
    LEVEL_UP_MOVE( 6, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(12, MOVE_CONSTRICT),
    LEVEL_UP_MOVE(19, MOVE_ACID),
    LEVEL_UP_MOVE(25, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(30, MOVE_WRAP),
    LEVEL_UP_MOVE(38, MOVE_BARRIER),
    LEVEL_UP_MOVE(47, MOVE_SCREECH),
    LEVEL_UP_MOVE(55, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gGeodudeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 6, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(11, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(16, MOVE_MAGNITUDE),
    LEVEL_UP_MOVE(21, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(26, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(31, MOVE_ROCK_BLAST),
    LEVEL_UP_MOVE(36, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(41, MOVE_EXPLOSION),
    LEVEL_UP_MOVE(46, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gGravelerLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 1, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE( 1, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE( 6, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(11, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(16, MOVE_MAGNITUDE),
    LEVEL_UP_MOVE(21, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(29, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(37, MOVE_ROCK_BLAST),
    LEVEL_UP_MOVE(45, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(53, MOVE_EXPLOSION),
    LEVEL_UP_MOVE(62, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gGolemLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 1, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE( 1, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE( 6, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(11, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(16, MOVE_MAGNITUDE),
    LEVEL_UP_MOVE(21, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(29, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(37, MOVE_ROCK_BLAST),
    LEVEL_UP_MOVE(45, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(53, MOVE_EXPLOSION),
    LEVEL_UP_MOVE(62, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gPonytaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 5, MOVE_GROWL),
    LEVEL_UP_MOVE( 9, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(14, MOVE_EMBER),
    LEVEL_UP_MOVE(19, MOVE_STOMP),
    LEVEL_UP_MOVE(25, MOVE_FIRE_SPIN),
    LEVEL_UP_MOVE(31, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(38, MOVE_AGILITY),
    LEVEL_UP_MOVE(45, MOVE_BOUNCE),
    LEVEL_UP_MOVE(53, MOVE_FIRE_BLAST),
    LEVEL_UP_END
};

const u16 gRapidashLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 5, MOVE_GROWL),
    LEVEL_UP_MOVE( 9, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(14, MOVE_EMBER),
    LEVEL_UP_MOVE(19, MOVE_STOMP),
    LEVEL_UP_MOVE(25, MOVE_FIRE_SPIN),
    LEVEL_UP_MOVE(31, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(38, MOVE_AGILITY),
    LEVEL_UP_MOVE(40, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(50, MOVE_BOUNCE),
    LEVEL_UP_MOVE(63, MOVE_FIRE_BLAST),
    LEVEL_UP_END
};

const u16 gSlowpokeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CURSE),
    LEVEL_UP_MOVE( 1, MOVE_YAWN),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 6, MOVE_GROWL),
    LEVEL_UP_MOVE(15, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(20, MOVE_CONFUSION),
    LEVEL_UP_MOVE(29, MOVE_DISABLE),
    LEVEL_UP_MOVE(34, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(43, MOVE_AMNESIA),
    LEVEL_UP_MOVE(48, MOVE_PSYCHIC),
    LEVEL_UP_END
};

const u16 gSlowbroLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CURSE),
    LEVEL_UP_MOVE( 1, MOVE_YAWN),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 6, MOVE_GROWL),
    LEVEL_UP_MOVE(15, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(20, MOVE_CONFUSION),
    LEVEL_UP_MOVE(29, MOVE_DISABLE),
    LEVEL_UP_MOVE(34, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(37, MOVE_WITHDRAW),
    LEVEL_UP_MOVE(46, MOVE_AMNESIA),
    LEVEL_UP_MOVE(54, MOVE_PSYCHIC),
    LEVEL_UP_END
};

const u16 gMagnemiteLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_METAL_SOUND),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 6, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE(11, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(16, MOVE_SONIC_BOOM),
    LEVEL_UP_MOVE(21, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(26, MOVE_SPARK),
    LEVEL_UP_MOVE(32, MOVE_LOCK_ON),
    LEVEL_UP_MOVE(38, MOVE_SWIFT),
    LEVEL_UP_MOVE(44, MOVE_SCREECH),
    LEVEL_UP_MOVE(50, MOVE_ZAP_CANNON),
    LEVEL_UP_END
};

const u16 gMagnetonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_METAL_SOUND),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE( 1, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE( 6, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE(11, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(16, MOVE_SONIC_BOOM),
    LEVEL_UP_MOVE(21, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(26, MOVE_SPARK),
    LEVEL_UP_MOVE(35, MOVE_LOCK_ON),
    LEVEL_UP_MOVE(44, MOVE_TRI_ATTACK),
    LEVEL_UP_MOVE(53, MOVE_SCREECH),
    LEVEL_UP_MOVE(62, MOVE_ZAP_CANNON),
    LEVEL_UP_END
};

const u16 gFarfetchdLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 6, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(11, MOVE_LEER),
    LEVEL_UP_MOVE(16, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_KNOCK_OFF),
    LEVEL_UP_MOVE(26, MOVE_FURY_CUTTER),
    LEVEL_UP_MOVE(31, MOVE_SWORDS_DANCE),
    LEVEL_UP_MOVE(36, MOVE_AGILITY),
    LEVEL_UP_MOVE(41, MOVE_SLASH),
    LEVEL_UP_MOVE(46, MOVE_FALSE_SWIPE),
    LEVEL_UP_END
};

const u16 gDoduoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 9, MOVE_PURSUIT),
    LEVEL_UP_MOVE(13, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_TRI_ATTACK),
    LEVEL_UP_MOVE(25, MOVE_RAGE),
    LEVEL_UP_MOVE(33, MOVE_UPROAR),
    LEVEL_UP_MOVE(37, MOVE_DRILL_PECK),
    LEVEL_UP_MOVE(45, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gDodrioLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_PURSUIT),
    LEVEL_UP_MOVE( 1, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE( 9, MOVE_PURSUIT),
    LEVEL_UP_MOVE(13, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_TRI_ATTACK),
    LEVEL_UP_MOVE(25, MOVE_RAGE),
    LEVEL_UP_MOVE(38, MOVE_UPROAR),
    LEVEL_UP_MOVE(47, MOVE_DRILL_PECK),
    LEVEL_UP_MOVE(60, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gSeelLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HEADBUTT),
    LEVEL_UP_MOVE( 9, MOVE_GROWL),
    LEVEL_UP_MOVE(17, MOVE_ICY_WIND),
    LEVEL_UP_MOVE(21, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE(29, MOVE_REST),
    LEVEL_UP_MOVE(37, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(41, MOVE_ICE_BEAM),
    LEVEL_UP_MOVE(49, MOVE_SAFEGUARD),
    LEVEL_UP_END
};

const u16 gDewgongLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HEADBUTT),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_ICY_WIND),
    LEVEL_UP_MOVE( 1, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE( 9, MOVE_GROWL),
    LEVEL_UP_MOVE(17, MOVE_ICY_WIND),
    LEVEL_UP_MOVE(21, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE(29, MOVE_REST),
    LEVEL_UP_MOVE(34, MOVE_SHEER_COLD),
    LEVEL_UP_MOVE(42, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(51, MOVE_ICE_BEAM),
    LEVEL_UP_MOVE(64, MOVE_SAFEGUARD),
    LEVEL_UP_END
};

const u16 gGrimerLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_GAS),
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 4, MOVE_HARDEN),
    LEVEL_UP_MOVE( 8, MOVE_DISABLE),
    LEVEL_UP_MOVE(13, MOVE_SLUDGE),
    LEVEL_UP_MOVE(19, MOVE_MINIMIZE),
    LEVEL_UP_MOVE(26, MOVE_SCREECH),
    LEVEL_UP_MOVE(34, MOVE_ACID_ARMOR),
    LEVEL_UP_MOVE(43, MOVE_SLUDGE_BOMB),
    LEVEL_UP_MOVE(53, MOVE_MEMENTO),
    LEVEL_UP_END
};

const u16 gMukLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_GAS),
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 4, MOVE_HARDEN),
    LEVEL_UP_MOVE( 8, MOVE_DISABLE),
    LEVEL_UP_MOVE(13, MOVE_SLUDGE),
    LEVEL_UP_MOVE(19, MOVE_MINIMIZE),
    LEVEL_UP_MOVE(26, MOVE_SCREECH),
    LEVEL_UP_MOVE(34, MOVE_ACID_ARMOR),
    LEVEL_UP_MOVE(47, MOVE_SLUDGE_BOMB),
    LEVEL_UP_MOVE(61, MOVE_MEMENTO),
    LEVEL_UP_END
};

const u16 gShellderLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_WITHDRAW),
    LEVEL_UP_MOVE( 9, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(17, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE(25, MOVE_PROTECT),
    LEVEL_UP_MOVE(33, MOVE_LEER),
    LEVEL_UP_MOVE(41, MOVE_CLAMP),
    LEVEL_UP_MOVE(49, MOVE_ICE_BEAM),
    LEVEL_UP_END
};

const u16 gCloysterLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WITHDRAW),
    LEVEL_UP_MOVE( 1, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE( 1, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE( 1, MOVE_PROTECT),
    LEVEL_UP_MOVE(33, MOVE_SPIKES),
    LEVEL_UP_MOVE(41, MOVE_SPIKE_CANNON),
    LEVEL_UP_END
};

const u16 gGastlyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE( 1, MOVE_LICK),
    LEVEL_UP_MOVE( 8, MOVE_SPITE),
    LEVEL_UP_MOVE(13, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(16, MOVE_CURSE),
    LEVEL_UP_MOVE(21, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(28, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(33, MOVE_DREAM_EATER),
    LEVEL_UP_MOVE(36, MOVE_DESTINY_BOND),
    LEVEL_UP_END
};

const u16 gHaunterLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE( 1, MOVE_LICK),
    LEVEL_UP_MOVE( 1, MOVE_SPITE),
    LEVEL_UP_MOVE( 8, MOVE_SPITE),
    LEVEL_UP_MOVE(13, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(16, MOVE_CURSE),
    LEVEL_UP_MOVE(21, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(25, MOVE_SHADOW_PUNCH),
    LEVEL_UP_MOVE(31, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(39, MOVE_DREAM_EATER),
    LEVEL_UP_MOVE(48, MOVE_DESTINY_BOND),
    LEVEL_UP_END
};

const u16 gGengarLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE( 1, MOVE_LICK),
    LEVEL_UP_MOVE( 1, MOVE_SPITE),
    LEVEL_UP_MOVE( 8, MOVE_SPITE),
    LEVEL_UP_MOVE(13, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(16, MOVE_CURSE),
    LEVEL_UP_MOVE(21, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(25, MOVE_SHADOW_PUNCH),
    LEVEL_UP_MOVE(31, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(39, MOVE_DREAM_EATER),
    LEVEL_UP_MOVE(48, MOVE_DESTINY_BOND),
    LEVEL_UP_END
};

const u16 gOnixLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_SCREECH),
    LEVEL_UP_MOVE( 9, MOVE_BIND),
    LEVEL_UP_MOVE(13, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(21, MOVE_HARDEN),
    LEVEL_UP_MOVE(25, MOVE_RAGE),
    LEVEL_UP_MOVE(33, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(37, MOVE_SLAM),
    LEVEL_UP_MOVE(45, MOVE_IRON_TAIL),
    LEVEL_UP_MOVE(49, MOVE_SAND_TOMB),
    LEVEL_UP_MOVE(57, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gDrowzeeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(10, MOVE_DISABLE),
    LEVEL_UP_MOVE(18, MOVE_CONFUSION),
    LEVEL_UP_MOVE(25, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(31, MOVE_POISON_GAS),
    LEVEL_UP_MOVE(36, MOVE_MEDITATE),
    LEVEL_UP_MOVE(40, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(43, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(45, MOVE_FUTURE_SIGHT),
    LEVEL_UP_END
};

const u16 gHypnoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE( 1, MOVE_DISABLE),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE(10, MOVE_DISABLE),
    LEVEL_UP_MOVE(18, MOVE_CONFUSION),
    LEVEL_UP_MOVE(25, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(33, MOVE_POISON_GAS),
    LEVEL_UP_MOVE(40, MOVE_MEDITATE),
    LEVEL_UP_MOVE(49, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(55, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(60, MOVE_FUTURE_SIGHT),
    LEVEL_UP_END
};

const u16 gKrabbyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 5, MOVE_LEER),
    LEVEL_UP_MOVE(12, MOVE_VICE_GRIP),
    LEVEL_UP_MOVE(16, MOVE_HARDEN),
    LEVEL_UP_MOVE(23, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE(27, MOVE_STOMP),
    LEVEL_UP_MOVE(34, MOVE_GUILLOTINE),
    LEVEL_UP_MOVE(41, MOVE_PROTECT),
    LEVEL_UP_MOVE(45, MOVE_CRABHAMMER),
    LEVEL_UP_END
};

const u16 gKinglerLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_VICE_GRIP),
    LEVEL_UP_MOVE( 5, MOVE_LEER),
    LEVEL_UP_MOVE(12, MOVE_VICE_GRIP),
    LEVEL_UP_MOVE(16, MOVE_HARDEN),
    LEVEL_UP_MOVE(23, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE(27, MOVE_STOMP),
    LEVEL_UP_MOVE(38, MOVE_GUILLOTINE),
    LEVEL_UP_MOVE(49, MOVE_PROTECT),
    LEVEL_UP_MOVE(57, MOVE_CRABHAMMER),
    LEVEL_UP_END
};

const u16 gVoltorbLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CHARGE),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 8, MOVE_SCREECH),
    LEVEL_UP_MOVE(15, MOVE_SONIC_BOOM),
    LEVEL_UP_MOVE(21, MOVE_SPARK),
    LEVEL_UP_MOVE(27, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(32, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(37, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(42, MOVE_SWIFT),
    LEVEL_UP_MOVE(46, MOVE_EXPLOSION),
    LEVEL_UP_MOVE(49, MOVE_MIRROR_COAT),
    LEVEL_UP_END
};

const u16 gElectrodeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CHARGE),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_SCREECH),
    LEVEL_UP_MOVE( 1, MOVE_SONIC_BOOM),
    LEVEL_UP_MOVE( 8, MOVE_SCREECH),
    LEVEL_UP_MOVE(15, MOVE_SONIC_BOOM),
    LEVEL_UP_MOVE(21, MOVE_SPARK),
    LEVEL_UP_MOVE(27, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(34, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(41, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(48, MOVE_SWIFT),
    LEVEL_UP_MOVE(54, MOVE_EXPLOSION),
    LEVEL_UP_MOVE(59, MOVE_MIRROR_COAT),
    LEVEL_UP_END
};

const u16 gExeggcuteLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BARRAGE),
    LEVEL_UP_MOVE( 1, MOVE_UPROAR),
    LEVEL_UP_MOVE( 1, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE( 7, MOVE_REFLECT),
    LEVEL_UP_MOVE(13, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(19, MOVE_CONFUSION),
    LEVEL_UP_MOVE(25, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(31, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(37, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(43, MOVE_SOLAR_BEAM),
    LEVEL_UP_END
};

const u16 gExeggutorLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BARRAGE),
    LEVEL_UP_MOVE( 1, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE(19, MOVE_STOMP),
    LEVEL_UP_MOVE(31, MOVE_EGG_BOMB),
    LEVEL_UP_END
};

const u16 gCuboneLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 9, MOVE_BONE_CLUB),
    LEVEL_UP_MOVE(13, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(17, MOVE_LEER),
    LEVEL_UP_MOVE(21, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(25, MOVE_BONEMERANG),
    LEVEL_UP_MOVE(29, MOVE_RAGE),
    LEVEL_UP_MOVE(33, MOVE_FALSE_SWIPE),
    LEVEL_UP_MOVE(37, MOVE_THRASH),
    LEVEL_UP_MOVE(41, MOVE_BONE_RUSH),
    LEVEL_UP_MOVE(45, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gMarowakLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_BONE_CLUB),
    LEVEL_UP_MOVE( 1, MOVE_HEADBUTT),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 9, MOVE_BONE_CLUB),
    LEVEL_UP_MOVE(13, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(17, MOVE_LEER),
    LEVEL_UP_MOVE(21, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(25, MOVE_BONEMERANG),
    LEVEL_UP_MOVE(32, MOVE_RAGE),
    LEVEL_UP_MOVE(39, MOVE_FALSE_SWIPE),
    LEVEL_UP_MOVE(46, MOVE_THRASH),
    LEVEL_UP_MOVE(53, MOVE_BONE_RUSH),
    LEVEL_UP_MOVE(61, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gHitmonleeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_REVENGE),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_KICK),
    LEVEL_UP_MOVE( 6, MOVE_MEDITATE),
    LEVEL_UP_MOVE(11, MOVE_ROLLING_KICK),
    LEVEL_UP_MOVE(16, MOVE_JUMP_KICK),
    LEVEL_UP_MOVE(20, MOVE_BRICK_BREAK),
    LEVEL_UP_MOVE(21, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(26, MOVE_HI_JUMP_KICK),
    LEVEL_UP_MOVE(31, MOVE_MIND_READER),
    LEVEL_UP_MOVE(36, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(41, MOVE_ENDURE),
    LEVEL_UP_MOVE(46, MOVE_MEGA_KICK),
    LEVEL_UP_MOVE(51, MOVE_REVERSAL),
    LEVEL_UP_END
};

const u16 gHitmonchanLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_REVENGE),
    LEVEL_UP_MOVE( 1, MOVE_COMET_PUNCH),
    LEVEL_UP_MOVE( 7, MOVE_AGILITY),
    LEVEL_UP_MOVE(13, MOVE_PURSUIT),
    LEVEL_UP_MOVE(20, MOVE_MACH_PUNCH),
    LEVEL_UP_MOVE(26, MOVE_THUNDER_PUNCH),
    LEVEL_UP_MOVE(26, MOVE_ICE_PUNCH),
    LEVEL_UP_MOVE(26, MOVE_FIRE_PUNCH),
    LEVEL_UP_MOVE(32, MOVE_SKY_UPPERCUT),
    LEVEL_UP_MOVE(38, MOVE_MEGA_PUNCH),
    LEVEL_UP_MOVE(44, MOVE_DETECT),
    LEVEL_UP_MOVE(50, MOVE_COUNTER),
    LEVEL_UP_END
};

const u16 gLickitungLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LICK),
    LEVEL_UP_MOVE( 7, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(12, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(18, MOVE_KNOCK_OFF),
    LEVEL_UP_MOVE(23, MOVE_STOMP),
    LEVEL_UP_MOVE(29, MOVE_WRAP),
    LEVEL_UP_MOVE(34, MOVE_DISABLE),
    LEVEL_UP_MOVE(40, MOVE_SLAM),
    LEVEL_UP_MOVE(45, MOVE_SCREECH),
    LEVEL_UP_MOVE(51, MOVE_REFRESH),
    LEVEL_UP_END
};

const u16 gKoffingLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_GAS),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 9, MOVE_SMOG),
    LEVEL_UP_MOVE(17, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(21, MOVE_SLUDGE),
    LEVEL_UP_MOVE(25, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(33, MOVE_HAZE),
    LEVEL_UP_MOVE(41, MOVE_EXPLOSION),
    LEVEL_UP_MOVE(45, MOVE_DESTINY_BOND),
    LEVEL_UP_MOVE(49, MOVE_MEMENTO),
    LEVEL_UP_END
};

const u16 gWeezingLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_GAS),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_SMOG),
    LEVEL_UP_MOVE( 1, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE( 9, MOVE_SMOG),
    LEVEL_UP_MOVE(17, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(21, MOVE_SLUDGE),
    LEVEL_UP_MOVE(25, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(33, MOVE_HAZE),
    LEVEL_UP_MOVE(44, MOVE_EXPLOSION),
    LEVEL_UP_MOVE(51, MOVE_DESTINY_BOND),
    LEVEL_UP_MOVE(58, MOVE_MEMENTO),
    LEVEL_UP_END
};

const u16 gRhyhornLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HORN_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(10, MOVE_STOMP),
    LEVEL_UP_MOVE(15, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(24, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(29, MOVE_ROCK_BLAST),
    LEVEL_UP_MOVE(38, MOVE_HORN_DRILL),
    LEVEL_UP_MOVE(43, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(52, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(57, MOVE_MEGAHORN),
    LEVEL_UP_END
};

const u16 gRhydonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HORN_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_STOMP),
    LEVEL_UP_MOVE( 1, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(10, MOVE_STOMP),
    LEVEL_UP_MOVE(15, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(24, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(29, MOVE_ROCK_BLAST),
    LEVEL_UP_MOVE(38, MOVE_HORN_DRILL),
    LEVEL_UP_MOVE(46, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(58, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(66, MOVE_MEGAHORN),
    LEVEL_UP_END
};

const u16 gChanseyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 9, MOVE_REFRESH),
    LEVEL_UP_MOVE(13, MOVE_SOFT_BOILED),
    LEVEL_UP_MOVE(17, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE(23, MOVE_MINIMIZE),
    LEVEL_UP_MOVE(29, MOVE_SING),
    LEVEL_UP_MOVE(35, MOVE_EGG_BOMB),
    LEVEL_UP_MOVE(41, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(49, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(57, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gTangelaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_INGRAIN),
    LEVEL_UP_MOVE( 1, MOVE_CONSTRICT),
    LEVEL_UP_MOVE( 4, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(10, MOVE_ABSORB),
    LEVEL_UP_MOVE(13, MOVE_GROWTH),
    LEVEL_UP_MOVE(19, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(22, MOVE_VINE_WHIP),
    LEVEL_UP_MOVE(28, MOVE_BIND),
    LEVEL_UP_MOVE(31, MOVE_MEGA_DRAIN),
    LEVEL_UP_MOVE(37, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(40, MOVE_SLAM),
    LEVEL_UP_MOVE(46, MOVE_TICKLE),
    LEVEL_UP_END
};

const u16 gKangaskhanLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_COMET_PUNCH),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 7, MOVE_BITE),
    LEVEL_UP_MOVE(13, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(19, MOVE_FAKE_OUT),
    LEVEL_UP_MOVE(25, MOVE_MEGA_PUNCH),
    LEVEL_UP_MOVE(31, MOVE_RAGE),
    LEVEL_UP_MOVE(37, MOVE_ENDURE),
    LEVEL_UP_MOVE(43, MOVE_DIZZY_PUNCH),
    LEVEL_UP_MOVE(49, MOVE_REVERSAL),
    LEVEL_UP_END
};

const u16 gHorseaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 8, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(15, MOVE_LEER),
    LEVEL_UP_MOVE(22, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(29, MOVE_TWISTER),
    LEVEL_UP_MOVE(36, MOVE_AGILITY),
    LEVEL_UP_MOVE(43, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(50, MOVE_DRAGON_DANCE),
    LEVEL_UP_END
};

const u16 gSeadraLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 1, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 8, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(15, MOVE_LEER),
    LEVEL_UP_MOVE(22, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(29, MOVE_TWISTER),
    LEVEL_UP_MOVE(40, MOVE_AGILITY),
    LEVEL_UP_MOVE(51, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(62, MOVE_DRAGON_DANCE),
    LEVEL_UP_END
};

const u16 gGoldeenLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE(10, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(15, MOVE_HORN_ATTACK),
    LEVEL_UP_MOVE(24, MOVE_FLAIL),
    LEVEL_UP_MOVE(29, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(38, MOVE_WATERFALL),
    LEVEL_UP_MOVE(43, MOVE_HORN_DRILL),
    LEVEL_UP_MOVE(52, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gSeakingLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE( 1, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(10, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(15, MOVE_HORN_ATTACK),
    LEVEL_UP_MOVE(24, MOVE_FLAIL),
    LEVEL_UP_MOVE(29, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(41, MOVE_WATERFALL),
    LEVEL_UP_MOVE(49, MOVE_HORN_DRILL),
    LEVEL_UP_MOVE(61, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gStaryuLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 6, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(10, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE(15, MOVE_RECOVER),
    LEVEL_UP_MOVE(19, MOVE_CAMOUFLAGE),
    LEVEL_UP_MOVE(24, MOVE_SWIFT),
    LEVEL_UP_MOVE(28, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(33, MOVE_MINIMIZE),
    LEVEL_UP_MOVE(37, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(42, MOVE_COSMIC_POWER),
    LEVEL_UP_MOVE(46, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gStarmieLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE( 1, MOVE_RECOVER),
    LEVEL_UP_MOVE( 1, MOVE_SWIFT),
    LEVEL_UP_MOVE(33, MOVE_CONFUSE_RAY),
    LEVEL_UP_END
};

const u16 gMrmimeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BARRIER),
    LEVEL_UP_MOVE( 5, MOVE_CONFUSION),
    LEVEL_UP_MOVE( 9, MOVE_SUBSTITUTE),
    LEVEL_UP_MOVE(13, MOVE_MEDITATE),
    LEVEL_UP_MOVE(17, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE(21, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(21, MOVE_REFLECT),
    LEVEL_UP_MOVE(25, MOVE_ENCORE),
    LEVEL_UP_MOVE(29, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(33, MOVE_RECYCLE),
    LEVEL_UP_MOVE(37, MOVE_TRICK),
    LEVEL_UP_MOVE(41, MOVE_ROLE_PLAY),
    LEVEL_UP_MOVE(45, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(49, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(53, MOVE_SAFEGUARD),
    LEVEL_UP_END
};

const u16 gScytherLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 6, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(11, MOVE_PURSUIT),
    LEVEL_UP_MOVE(16, MOVE_FALSE_SWIPE),
    LEVEL_UP_MOVE(21, MOVE_AGILITY),
    LEVEL_UP_MOVE(26, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(31, MOVE_SLASH),
    LEVEL_UP_MOVE(36, MOVE_SWORDS_DANCE),
    LEVEL_UP_MOVE(41, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(46, MOVE_FURY_CUTTER),
    LEVEL_UP_END
};

const u16 gJynxLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_LICK),
    LEVEL_UP_MOVE( 1, MOVE_LOVELY_KISS),
    LEVEL_UP_MOVE( 1, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE( 9, MOVE_LOVELY_KISS),
    LEVEL_UP_MOVE(13, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE(21, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE(25, MOVE_ICE_PUNCH),
    LEVEL_UP_MOVE(35, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(41, MOVE_FAKE_TEARS),
    LEVEL_UP_MOVE(51, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(57, MOVE_PERISH_SONG),
    LEVEL_UP_MOVE(67, MOVE_BLIZZARD),
    LEVEL_UP_END
};

const u16 gElectabuzzLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_PUNCH),
    LEVEL_UP_MOVE( 9, MOVE_THUNDER_PUNCH),
    LEVEL_UP_MOVE(17, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(25, MOVE_SWIFT),
    LEVEL_UP_MOVE(36, MOVE_SCREECH),
    LEVEL_UP_MOVE(47, MOVE_THUNDERBOLT),
    LEVEL_UP_MOVE(58, MOVE_THUNDER),
    LEVEL_UP_END
};

const u16 gMagmarLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_SMOG),
    LEVEL_UP_MOVE( 1, MOVE_FIRE_PUNCH),
    LEVEL_UP_MOVE( 7, MOVE_LEER),
    LEVEL_UP_MOVE(13, MOVE_SMOG),
    LEVEL_UP_MOVE(19, MOVE_FIRE_PUNCH),
    LEVEL_UP_MOVE(25, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(33, MOVE_SUNNY_DAY),
    LEVEL_UP_MOVE(41, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(49, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(57, MOVE_FIRE_BLAST),
    LEVEL_UP_END
};

const u16 gPinsirLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_VICE_GRIP),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 7, MOVE_BIND),
    LEVEL_UP_MOVE(13, MOVE_SEISMIC_TOSS),
    LEVEL_UP_MOVE(19, MOVE_HARDEN),
    LEVEL_UP_MOVE(25, MOVE_REVENGE),
    LEVEL_UP_MOVE(31, MOVE_BRICK_BREAK),
    LEVEL_UP_MOVE(37, MOVE_GUILLOTINE),
    LEVEL_UP_MOVE(43, MOVE_SUBMISSION),
    LEVEL_UP_MOVE(49, MOVE_SWORDS_DANCE),
    LEVEL_UP_END
};

const u16 gTaurosLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 4, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 8, MOVE_RAGE),
    LEVEL_UP_MOVE(13, MOVE_HORN_ATTACK),
    LEVEL_UP_MOVE(19, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(26, MOVE_PURSUIT),
    LEVEL_UP_MOVE(34, MOVE_REST),
    LEVEL_UP_MOVE(43, MOVE_THRASH),
    LEVEL_UP_MOVE(53, MOVE_TAKE_DOWN),
    LEVEL_UP_END
};

const u16 gMagikarpLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE(15, MOVE_TACKLE),
    LEVEL_UP_MOVE(30, MOVE_FLAIL),
    LEVEL_UP_END
};

const u16 gGyaradosLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_THRASH),
    LEVEL_UP_MOVE(20, MOVE_BITE),
    LEVEL_UP_MOVE(25, MOVE_DRAGON_RAGE),
    LEVEL_UP_MOVE(30, MOVE_LEER),
    LEVEL_UP_MOVE(35, MOVE_TWISTER),
    LEVEL_UP_MOVE(40, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(45, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(50, MOVE_DRAGON_DANCE),
    LEVEL_UP_MOVE(55, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gLaprasLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_SING),
    LEVEL_UP_MOVE( 7, MOVE_MIST),
    LEVEL_UP_MOVE(13, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(19, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(25, MOVE_PERISH_SONG),
    LEVEL_UP_MOVE(31, MOVE_ICE_BEAM),
    LEVEL_UP_MOVE(37, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(43, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(49, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(55, MOVE_SHEER_COLD),
    LEVEL_UP_END
};

const u16 gDittoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TRANSFORM),
    LEVEL_UP_END
};

const u16 gEeveeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE( 8, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(16, MOVE_GROWL),
    LEVEL_UP_MOVE(23, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(30, MOVE_BITE),
    LEVEL_UP_MOVE(36, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(42, MOVE_TAKE_DOWN),
    LEVEL_UP_END
};

const u16 gVaporeonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE( 8, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(16, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(23, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(30, MOVE_BITE),
    LEVEL_UP_MOVE(36, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE(42, MOVE_HAZE),
    LEVEL_UP_MOVE(47, MOVE_ACID_ARMOR),
    LEVEL_UP_MOVE(52, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gJolteonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE( 8, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(16, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE(23, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(30, MOVE_DOUBLE_KICK),
    LEVEL_UP_MOVE(36, MOVE_PIN_MISSILE),
    LEVEL_UP_MOVE(42, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(47, MOVE_AGILITY),
    LEVEL_UP_MOVE(52, MOVE_THUNDER),
    LEVEL_UP_END
};

const u16 gFlareonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE( 8, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(16, MOVE_EMBER),
    LEVEL_UP_MOVE(23, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(30, MOVE_BITE),
    LEVEL_UP_MOVE(36, MOVE_FIRE_SPIN),
    LEVEL_UP_MOVE(42, MOVE_SMOG),
    LEVEL_UP_MOVE(47, MOVE_LEER),
    LEVEL_UP_MOVE(52, MOVE_FLAMETHROWER),
    LEVEL_UP_END
};

const u16 gPorygonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CONVERSION_2),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_CONVERSION),
    LEVEL_UP_MOVE( 9, MOVE_AGILITY),
    LEVEL_UP_MOVE(12, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(20, MOVE_RECOVER),
    LEVEL_UP_MOVE(24, MOVE_SHARPEN),
    LEVEL_UP_MOVE(32, MOVE_LOCK_ON),
    LEVEL_UP_MOVE(36, MOVE_TRI_ATTACK),
    LEVEL_UP_MOVE(44, MOVE_RECYCLE),
    LEVEL_UP_MOVE(48, MOVE_ZAP_CANNON),
    LEVEL_UP_END
};

const u16 gOmanyteLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CONSTRICT),
    LEVEL_UP_MOVE( 1, MOVE_WITHDRAW),
    LEVEL_UP_MOVE(13, MOVE_BITE),
    LEVEL_UP_MOVE(19, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(25, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE(31, MOVE_LEER),
    LEVEL_UP_MOVE(37, MOVE_PROTECT),
    LEVEL_UP_MOVE(43, MOVE_TICKLE),
    LEVEL_UP_MOVE(49, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(55, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gOmastarLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CONSTRICT),
    LEVEL_UP_MOVE( 1, MOVE_WITHDRAW),
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE(13, MOVE_BITE),
    LEVEL_UP_MOVE(19, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(25, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE(31, MOVE_LEER),
    LEVEL_UP_MOVE(37, MOVE_PROTECT),
    LEVEL_UP_MOVE(40, MOVE_SPIKE_CANNON),
    LEVEL_UP_MOVE(46, MOVE_TICKLE),
    LEVEL_UP_MOVE(55, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(65, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gKabutoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE(13, MOVE_ABSORB),
    LEVEL_UP_MOVE(19, MOVE_LEER),
    LEVEL_UP_MOVE(25, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE(31, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(37, MOVE_ENDURE),
    LEVEL_UP_MOVE(43, MOVE_METAL_SOUND),
    LEVEL_UP_MOVE(49, MOVE_MEGA_DRAIN),
    LEVEL_UP_MOVE(55, MOVE_ANCIENT_POWER),
    LEVEL_UP_END
};

const u16 gKabutopsLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE(13, MOVE_ABSORB),
    LEVEL_UP_MOVE(19, MOVE_LEER),
    LEVEL_UP_MOVE(25, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE(31, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(37, MOVE_ENDURE),
    LEVEL_UP_MOVE(40, MOVE_SLASH),
    LEVEL_UP_MOVE(46, MOVE_METAL_SOUND),
    LEVEL_UP_MOVE(55, MOVE_MEGA_DRAIN),
    LEVEL_UP_MOVE(65, MOVE_ANCIENT_POWER),
    LEVEL_UP_END
};

const u16 gAerodactylLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE( 8, MOVE_AGILITY),
    LEVEL_UP_MOVE(15, MOVE_BITE),
    LEVEL_UP_MOVE(22, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(29, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(36, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(43, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(50, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gSnorlaxLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 6, MOVE_AMNESIA),
    LEVEL_UP_MOVE(10, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(15, MOVE_BELLY_DRUM),
    LEVEL_UP_MOVE(19, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(24, MOVE_YAWN),
    LEVEL_UP_MOVE(28, MOVE_REST),
    LEVEL_UP_MOVE(28, MOVE_SNORE),
    LEVEL_UP_MOVE(33, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(37, MOVE_BLOCK),
    LEVEL_UP_MOVE(42, MOVE_COVET),
    LEVEL_UP_MOVE(46, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(51, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gArticunoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GUST),
    LEVEL_UP_MOVE( 1, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE(13, MOVE_MIST),
    LEVEL_UP_MOVE(25, MOVE_AGILITY),
    LEVEL_UP_MOVE(37, MOVE_MIND_READER),
    LEVEL_UP_MOVE(49, MOVE_ICE_BEAM),
    LEVEL_UP_MOVE(61, MOVE_REFLECT),
    LEVEL_UP_MOVE(73, MOVE_BLIZZARD),
    LEVEL_UP_MOVE(85, MOVE_SHEER_COLD),
    LEVEL_UP_END
};

const u16 gZapdosLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE(13, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(25, MOVE_AGILITY),
    LEVEL_UP_MOVE(37, MOVE_DETECT),
    LEVEL_UP_MOVE(49, MOVE_DRILL_PECK),
    LEVEL_UP_MOVE(61, MOVE_CHARGE),
    LEVEL_UP_MOVE(73, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(85, MOVE_THUNDER),
    LEVEL_UP_END
};

const u16 gMoltresLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE(13, MOVE_FIRE_SPIN),
    LEVEL_UP_MOVE(25, MOVE_AGILITY),
    LEVEL_UP_MOVE(37, MOVE_ENDURE),
    LEVEL_UP_MOVE(49, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(61, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(73, MOVE_HEAT_WAVE),
    LEVEL_UP_MOVE(85, MOVE_SKY_ATTACK),
    LEVEL_UP_END
};

const u16 gDratiniLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WRAP),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 8, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(15, MOVE_TWISTER),
    LEVEL_UP_MOVE(22, MOVE_DRAGON_RAGE),
    LEVEL_UP_MOVE(29, MOVE_SLAM),
    LEVEL_UP_MOVE(36, MOVE_AGILITY),
    LEVEL_UP_MOVE(43, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(50, MOVE_OUTRAGE),
    LEVEL_UP_MOVE(57, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gDragonairLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WRAP),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE( 1, MOVE_TWISTER),
    LEVEL_UP_MOVE( 8, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(15, MOVE_TWISTER),
    LEVEL_UP_MOVE(22, MOVE_DRAGON_RAGE),
    LEVEL_UP_MOVE(29, MOVE_SLAM),
    LEVEL_UP_MOVE(38, MOVE_AGILITY),
    LEVEL_UP_MOVE(47, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(56, MOVE_OUTRAGE),
    LEVEL_UP_MOVE(65, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gDragoniteLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WRAP),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE( 1, MOVE_TWISTER),
    LEVEL_UP_MOVE( 8, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(15, MOVE_TWISTER),
    LEVEL_UP_MOVE(22, MOVE_DRAGON_RAGE),
    LEVEL_UP_MOVE(29, MOVE_SLAM),
    LEVEL_UP_MOVE(38, MOVE_AGILITY),
    LEVEL_UP_MOVE(47, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(55, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(61, MOVE_OUTRAGE),
    LEVEL_UP_MOVE(75, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gMewtwoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE( 1, MOVE_DISABLE),
    LEVEL_UP_MOVE(11, MOVE_BARRIER),
    LEVEL_UP_MOVE(22, MOVE_SWIFT),
    LEVEL_UP_MOVE(33, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(44, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(55, MOVE_MIST),
    LEVEL_UP_MOVE(66, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(77, MOVE_AMNESIA),
    LEVEL_UP_MOVE(88, MOVE_RECOVER),
    LEVEL_UP_MOVE(99, MOVE_SAFEGUARD),
    LEVEL_UP_END
};

const u16 gMewLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE(10, MOVE_TRANSFORM),
    LEVEL_UP_MOVE(20, MOVE_MEGA_PUNCH),
    LEVEL_UP_MOVE(30, MOVE_METRONOME),
    LEVEL_UP_MOVE(40, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(50, MOVE_ANCIENT_POWER),
    LEVEL_UP_END
};

const u16 gChikoritaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 8, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE(12, MOVE_REFLECT),
    LEVEL_UP_MOVE(15, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(22, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE(29, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(36, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(43, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(50, MOVE_SOLAR_BEAM),
    LEVEL_UP_END
};

const u16 gBayleefLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE( 1, MOVE_REFLECT),
    LEVEL_UP_MOVE( 8, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE(12, MOVE_REFLECT),
    LEVEL_UP_MOVE(15, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(23, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE(31, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(39, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(47, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(55, MOVE_SOLAR_BEAM),
    LEVEL_UP_END
};

const u16 gMeganiumLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE( 1, MOVE_REFLECT),
    LEVEL_UP_MOVE( 8, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE(12, MOVE_REFLECT),
    LEVEL_UP_MOVE(15, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(23, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE(31, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(41, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(51, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(61, MOVE_SOLAR_BEAM),
    LEVEL_UP_END
};

const u16 gCyndaquilLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 6, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(12, MOVE_EMBER),
    LEVEL_UP_MOVE(19, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(27, MOVE_FLAME_WHEEL),
    LEVEL_UP_MOVE(36, MOVE_SWIFT),
    LEVEL_UP_MOVE(46, MOVE_FLAMETHROWER),
    LEVEL_UP_END
};

const u16 gQuilavaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE( 6, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(12, MOVE_EMBER),
    LEVEL_UP_MOVE(21, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(31, MOVE_FLAME_WHEEL),
    LEVEL_UP_MOVE(42, MOVE_SWIFT),
    LEVEL_UP_MOVE(54, MOVE_FLAMETHROWER),
    LEVEL_UP_END
};

const u16 gTyphlosionLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 6, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(12, MOVE_EMBER),
    LEVEL_UP_MOVE(21, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(31, MOVE_FLAME_WHEEL),
    LEVEL_UP_MOVE(45, MOVE_SWIFT),
    LEVEL_UP_MOVE(60, MOVE_FLAMETHROWER),
    LEVEL_UP_END
};

const u16 gTotodileLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 7, MOVE_RAGE),
    LEVEL_UP_MOVE(13, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(20, MOVE_BITE),
    LEVEL_UP_MOVE(27, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(35, MOVE_SLASH),
    LEVEL_UP_MOVE(43, MOVE_SCREECH),
    LEVEL_UP_MOVE(52, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gCroconawLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_RAGE),
    LEVEL_UP_MOVE( 7, MOVE_RAGE),
    LEVEL_UP_MOVE(13, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(21, MOVE_BITE),
    LEVEL_UP_MOVE(28, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(37, MOVE_SLASH),
    LEVEL_UP_MOVE(45, MOVE_SCREECH),
    LEVEL_UP_MOVE(55, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gFeraligatrLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_RAGE),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 7, MOVE_RAGE),
    LEVEL_UP_MOVE(13, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(21, MOVE_BITE),
    LEVEL_UP_MOVE(28, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(38, MOVE_SLASH),
    LEVEL_UP_MOVE(47, MOVE_SCREECH),
    LEVEL_UP_MOVE(58, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gSentretLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 4, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 7, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(12, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(17, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(24, MOVE_SLAM),
    LEVEL_UP_MOVE(31, MOVE_FOLLOW_ME),
    LEVEL_UP_MOVE(40, MOVE_REST),
    LEVEL_UP_MOVE(49, MOVE_AMNESIA),
    LEVEL_UP_END
};

const u16 gFurretLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 4, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 7, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(12, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(19, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(28, MOVE_SLAM),
    LEVEL_UP_MOVE(37, MOVE_FOLLOW_ME),
    LEVEL_UP_MOVE(48, MOVE_REST),
    LEVEL_UP_MOVE(59, MOVE_AMNESIA),
    LEVEL_UP_END
};

const u16 gHoothootLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 6, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(11, MOVE_PECK),
    LEVEL_UP_MOVE(16, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(22, MOVE_REFLECT),
    LEVEL_UP_MOVE(28, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(34, MOVE_CONFUSION),
    LEVEL_UP_MOVE(48, MOVE_DREAM_EATER),
    LEVEL_UP_END
};

const u16 gNoctowlLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_FORESIGHT),
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 6, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(11, MOVE_PECK),
    LEVEL_UP_MOVE(16, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(25, MOVE_REFLECT),
    LEVEL_UP_MOVE(33, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(41, MOVE_CONFUSION),
    LEVEL_UP_MOVE(57, MOVE_DREAM_EATER),
    LEVEL_UP_END
};

const u16 gLedybaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 8, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(15, MOVE_COMET_PUNCH),
    LEVEL_UP_MOVE(22, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(22, MOVE_REFLECT),
    LEVEL_UP_MOVE(22, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(29, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(36, MOVE_SWIFT),
    LEVEL_UP_MOVE(43, MOVE_AGILITY),
    LEVEL_UP_MOVE(50, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gLedianLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE( 8, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(15, MOVE_COMET_PUNCH),
    LEVEL_UP_MOVE(24, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(24, MOVE_REFLECT),
    LEVEL_UP_MOVE(24, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(33, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(42, MOVE_SWIFT),
    LEVEL_UP_MOVE(51, MOVE_AGILITY),
    LEVEL_UP_MOVE(60, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gSpinarakLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE( 1, MOVE_STRING_SHOT),
    LEVEL_UP_MOVE( 6, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(11, MOVE_CONSTRICT),
    LEVEL_UP_MOVE(17, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(23, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE(30, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(37, MOVE_SPIDER_WEB),
    LEVEL_UP_MOVE(45, MOVE_AGILITY),
    LEVEL_UP_MOVE(53, MOVE_PSYCHIC),
    LEVEL_UP_END
};

const u16 gAriadosLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE( 1, MOVE_STRING_SHOT),
    LEVEL_UP_MOVE( 1, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE( 1, MOVE_CONSTRICT),
    LEVEL_UP_MOVE( 6, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(11, MOVE_CONSTRICT),
    LEVEL_UP_MOVE(17, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(25, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE(34, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(43, MOVE_SPIDER_WEB),
    LEVEL_UP_MOVE(53, MOVE_AGILITY),
    LEVEL_UP_MOVE(63, MOVE_PSYCHIC),
    LEVEL_UP_END
};

const u16 gCrobatLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCREECH),
    LEVEL_UP_MOVE( 1, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE( 1, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 6, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(11, MOVE_ASTONISH),
    LEVEL_UP_MOVE(16, MOVE_BITE),
    LEVEL_UP_MOVE(21, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(28, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(35, MOVE_AIR_CUTTER),
    LEVEL_UP_MOVE(42, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(49, MOVE_POISON_FANG),
    LEVEL_UP_MOVE(56, MOVE_HAZE),
    LEVEL_UP_END
};

const u16 gChinchouLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE( 5, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(13, MOVE_FLAIL),
    LEVEL_UP_MOVE(17, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(25, MOVE_SPARK),
    LEVEL_UP_MOVE(29, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(37, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(41, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(49, MOVE_CHARGE),
    LEVEL_UP_END
};

const u16 gLanturnLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE( 1, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE( 5, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(13, MOVE_FLAIL),
    LEVEL_UP_MOVE(17, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(25, MOVE_SPARK),
    LEVEL_UP_MOVE(32, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(43, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(50, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(61, MOVE_CHARGE),
    LEVEL_UP_END
};

const u16 gPichuLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE( 1, MOVE_CHARM),
    LEVEL_UP_MOVE( 6, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 8, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(11, MOVE_SWEET_KISS),
    LEVEL_UP_END
};

const u16 gCleffaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_CHARM),
    LEVEL_UP_MOVE( 4, MOVE_ENCORE),
    LEVEL_UP_MOVE( 8, MOVE_SING),
    LEVEL_UP_MOVE(13, MOVE_SWEET_KISS),
    LEVEL_UP_END
};

const u16 gIgglybuffLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SING),
    LEVEL_UP_MOVE( 1, MOVE_CHARM),
    LEVEL_UP_MOVE( 4, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 9, MOVE_POUND),
    LEVEL_UP_MOVE(14, MOVE_SWEET_KISS),
    LEVEL_UP_END
};

const u16 gTogepiLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_CHARM),
    LEVEL_UP_MOVE( 6, MOVE_METRONOME),
    LEVEL_UP_MOVE(11, MOVE_SWEET_KISS),
    LEVEL_UP_MOVE(16, MOVE_YAWN),
    LEVEL_UP_MOVE(21, MOVE_ENCORE),
    LEVEL_UP_MOVE(26, MOVE_FOLLOW_ME),
    LEVEL_UP_MOVE(31, MOVE_WISH),
    LEVEL_UP_MOVE(36, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(41, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gTogeticLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_CHARM),
    LEVEL_UP_MOVE( 6, MOVE_METRONOME),
    LEVEL_UP_MOVE(11, MOVE_SWEET_KISS),
    LEVEL_UP_MOVE(16, MOVE_YAWN),
    LEVEL_UP_MOVE(21, MOVE_ENCORE),
    LEVEL_UP_MOVE(26, MOVE_FOLLOW_ME),
    LEVEL_UP_MOVE(31, MOVE_WISH),
    LEVEL_UP_MOVE(36, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(41, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gNatuLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE(10, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(20, MOVE_TELEPORT),
    LEVEL_UP_MOVE(30, MOVE_WISH),
    LEVEL_UP_MOVE(30, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(40, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(50, MOVE_PSYCHIC),
    LEVEL_UP_END
};

const u16 gXatuLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE(10, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(20, MOVE_TELEPORT),
    LEVEL_UP_MOVE(35, MOVE_WISH),
    LEVEL_UP_MOVE(35, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(50, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(65, MOVE_PSYCHIC),
    LEVEL_UP_END
};

const u16 gMareepLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 9, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE(16, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(23, MOVE_COTTON_SPORE),
    LEVEL_UP_MOVE(30, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(37, MOVE_THUNDER),
    LEVEL_UP_END
};

const u16 gFlaaffyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE( 9, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE(18, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(27, MOVE_COTTON_SPORE),
    LEVEL_UP_MOVE(36, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(45, MOVE_THUNDER),
    LEVEL_UP_END
};

const u16 gAmpharosLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE( 9, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE(18, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(27, MOVE_COTTON_SPORE),
    LEVEL_UP_MOVE(30, MOVE_THUNDER_PUNCH),
    LEVEL_UP_MOVE(42, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(57, MOVE_THUNDER),
    LEVEL_UP_END
};

const u16 gBellossomLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 1, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE( 1, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE( 1, MOVE_MAGICAL_LEAF),
    LEVEL_UP_MOVE(44, MOVE_PETAL_DANCE),
    LEVEL_UP_MOVE(55, MOVE_SOLAR_BEAM),
    LEVEL_UP_END
};

const u16 gMarillLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 3, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 6, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(10, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(15, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(21, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(28, MOVE_DOUBLE_EDGE),
    LEVEL_UP_MOVE(36, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(45, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gAzumarillLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 3, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE( 6, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(10, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(15, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(24, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(34, MOVE_DOUBLE_EDGE),
    LEVEL_UP_MOVE(45, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(57, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gSudowoodoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE( 1, MOVE_MIMIC),
    LEVEL_UP_MOVE( 9, MOVE_FLAIL),
    LEVEL_UP_MOVE(17, MOVE_LOW_KICK),
    LEVEL_UP_MOVE(25, MOVE_ROCK_SLIDE),
    LEVEL_UP_MOVE(33, MOVE_BLOCK),
    LEVEL_UP_MOVE(41, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(49, MOVE_SLAM),
    LEVEL_UP_MOVE(57, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gPolitoedLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE( 1, MOVE_PERISH_SONG),
    LEVEL_UP_MOVE(35, MOVE_PERISH_SONG),
    LEVEL_UP_MOVE(51, MOVE_SWAGGER),
    LEVEL_UP_END
};

const u16 gHoppipLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE( 5, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(10, MOVE_TACKLE),
    LEVEL_UP_MOVE(13, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(15, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(17, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(20, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(25, MOVE_COTTON_SPORE),
    LEVEL_UP_MOVE(30, MOVE_MEGA_DRAIN),
    LEVEL_UP_END
};

const u16 gSkiploomLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE( 1, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 5, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(10, MOVE_TACKLE),
    LEVEL_UP_MOVE(13, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(15, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(17, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(22, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(29, MOVE_COTTON_SPORE),
    LEVEL_UP_MOVE(36, MOVE_MEGA_DRAIN),
    LEVEL_UP_END
};

const u16 gJumpluffLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE( 1, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 5, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(10, MOVE_TACKLE),
    LEVEL_UP_MOVE(13, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(15, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(17, MOVE_SLEEP_POWDER),
    LEVEL_UP_MOVE(22, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(33, MOVE_COTTON_SPORE),
    LEVEL_UP_MOVE(44, MOVE_MEGA_DRAIN),
    LEVEL_UP_END
};

const u16 gAipomLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 6, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_ASTONISH),
    LEVEL_UP_MOVE(18, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(25, MOVE_TICKLE),
    LEVEL_UP_MOVE(31, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(38, MOVE_SWIFT),
    LEVEL_UP_MOVE(43, MOVE_SCREECH),
    LEVEL_UP_MOVE(50, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gSunkernLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 6, MOVE_GROWTH),
    LEVEL_UP_MOVE(13, MOVE_MEGA_DRAIN),
    LEVEL_UP_MOVE(18, MOVE_INGRAIN),
    LEVEL_UP_MOVE(25, MOVE_ENDEAVOR),
    LEVEL_UP_MOVE(30, MOVE_SUNNY_DAY),
    LEVEL_UP_MOVE(37, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE(42, MOVE_GIGA_DRAIN),
    LEVEL_UP_END
};

const u16 gSunfloraLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 6, MOVE_GROWTH),
    LEVEL_UP_MOVE(13, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE(18, MOVE_INGRAIN),
    LEVEL_UP_MOVE(25, MOVE_BULLET_SEED),
    LEVEL_UP_MOVE(30, MOVE_SUNNY_DAY),
    LEVEL_UP_MOVE(37, MOVE_PETAL_DANCE),
    LEVEL_UP_MOVE(42, MOVE_SOLAR_BEAM),
    LEVEL_UP_END
};

const u16 gYanmaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_FORESIGHT),
    LEVEL_UP_MOVE( 7, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(19, MOVE_SONIC_BOOM),
    LEVEL_UP_MOVE(25, MOVE_DETECT),
    LEVEL_UP_MOVE(31, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(37, MOVE_UPROAR),
    LEVEL_UP_MOVE(43, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(49, MOVE_SCREECH),
    LEVEL_UP_END
};

const u16 gWooperLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(11, MOVE_SLAM),
    LEVEL_UP_MOVE(16, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE(21, MOVE_AMNESIA),
    LEVEL_UP_MOVE(31, MOVE_YAWN),
    LEVEL_UP_MOVE(36, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(41, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(51, MOVE_MIST),
    LEVEL_UP_MOVE(51, MOVE_HAZE),
    LEVEL_UP_END
};

const u16 gQuagsireLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(11, MOVE_SLAM),
    LEVEL_UP_MOVE(16, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE(23, MOVE_AMNESIA),
    LEVEL_UP_MOVE(35, MOVE_YAWN),
    LEVEL_UP_MOVE(42, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(49, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(61, MOVE_MIST),
    LEVEL_UP_MOVE(61, MOVE_HAZE),
    LEVEL_UP_END
};

const u16 gEspeonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE( 8, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(16, MOVE_CONFUSION),
    LEVEL_UP_MOVE(23, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(30, MOVE_SWIFT),
    LEVEL_UP_MOVE(36, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(42, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(47, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(52, MOVE_MORNING_SUN),
    LEVEL_UP_END
};

const u16 gUmbreonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE( 8, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(16, MOVE_PURSUIT),
    LEVEL_UP_MOVE(23, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(30, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(36, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(42, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(47, MOVE_SCREECH),
    LEVEL_UP_MOVE(52, MOVE_MOONLIGHT),
    LEVEL_UP_END
};

const u16 gMurkrowLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 9, MOVE_ASTONISH),
    LEVEL_UP_MOVE(14, MOVE_PURSUIT),
    LEVEL_UP_MOVE(22, MOVE_HAZE),
    LEVEL_UP_MOVE(27, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(35, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(40, MOVE_TAUNT),
    LEVEL_UP_MOVE(48, MOVE_MEAN_LOOK),
    LEVEL_UP_END
};

const u16 gSlowkingLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CURSE),
    LEVEL_UP_MOVE( 1, MOVE_YAWN),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 6, MOVE_GROWL),
    LEVEL_UP_MOVE(15, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(20, MOVE_CONFUSION),
    LEVEL_UP_MOVE(29, MOVE_DISABLE),
    LEVEL_UP_MOVE(34, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(43, MOVE_SWAGGER),
    LEVEL_UP_MOVE(48, MOVE_PSYCHIC),
    LEVEL_UP_END
};

const u16 gMisdreavusLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_PSYWAVE),
    LEVEL_UP_MOVE( 6, MOVE_SPITE),
    LEVEL_UP_MOVE(11, MOVE_ASTONISH),
    LEVEL_UP_MOVE(17, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(23, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(30, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(37, MOVE_PAIN_SPLIT),
    LEVEL_UP_MOVE(45, MOVE_PERISH_SONG),
    LEVEL_UP_MOVE(53, MOVE_GRUDGE),
    LEVEL_UP_END
};

const u16 gUnownLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HIDDEN_POWER),
    LEVEL_UP_END
};

const u16 gWobbuffetLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_COUNTER),
    LEVEL_UP_MOVE( 1, MOVE_MIRROR_COAT),
    LEVEL_UP_MOVE( 1, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE( 1, MOVE_DESTINY_BOND),
    LEVEL_UP_END
};

const u16 gGirafarigLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 7, MOVE_ASTONISH),
    LEVEL_UP_MOVE(13, MOVE_CONFUSION),
    LEVEL_UP_MOVE(19, MOVE_STOMP),
    LEVEL_UP_MOVE(25, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(31, MOVE_AGILITY),
    LEVEL_UP_MOVE(37, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(43, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(49, MOVE_CRUNCH),
    LEVEL_UP_END
};

const u16 gPinecoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_PROTECT),
    LEVEL_UP_MOVE( 8, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(15, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(22, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE(29, MOVE_BIDE),
    LEVEL_UP_MOVE(36, MOVE_EXPLOSION),
    LEVEL_UP_MOVE(43, MOVE_SPIKES),
    LEVEL_UP_MOVE(50, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gForretressLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_PROTECT),
    LEVEL_UP_MOVE( 1, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE( 8, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(15, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(22, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE(29, MOVE_BIDE),
    LEVEL_UP_MOVE(39, MOVE_EXPLOSION),
    LEVEL_UP_MOVE(49, MOVE_SPIKES),
    LEVEL_UP_MOVE(59, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gDunsparceLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_RAGE),
    LEVEL_UP_MOVE( 4, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(11, MOVE_YAWN),
    LEVEL_UP_MOVE(14, MOVE_GLARE),
    LEVEL_UP_MOVE(21, MOVE_SPITE),
    LEVEL_UP_MOVE(24, MOVE_PURSUIT),
    LEVEL_UP_MOVE(31, MOVE_SCREECH),
    LEVEL_UP_MOVE(34, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(41, MOVE_ENDEAVOR),
    LEVEL_UP_END
};

const u16 gGligarLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE( 6, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_HARDEN),
    LEVEL_UP_MOVE(20, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(28, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(36, MOVE_SLASH),
    LEVEL_UP_MOVE(44, MOVE_SCREECH),
    LEVEL_UP_MOVE(52, MOVE_GUILLOTINE),
    LEVEL_UP_END
};

const u16 gSteelixLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_SCREECH),
    LEVEL_UP_MOVE( 9, MOVE_BIND),
    LEVEL_UP_MOVE(13, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(21, MOVE_HARDEN),
    LEVEL_UP_MOVE(25, MOVE_RAGE),
    LEVEL_UP_MOVE(33, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(37, MOVE_SLAM),
    LEVEL_UP_MOVE(45, MOVE_IRON_TAIL),
    LEVEL_UP_MOVE(49, MOVE_CRUNCH),
    LEVEL_UP_MOVE(57, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gSnubbullLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE( 4, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 8, MOVE_CHARM),
    LEVEL_UP_MOVE(13, MOVE_BITE),
    LEVEL_UP_MOVE(19, MOVE_LICK),
    LEVEL_UP_MOVE(26, MOVE_ROAR),
    LEVEL_UP_MOVE(34, MOVE_RAGE),
    LEVEL_UP_MOVE(43, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(53, MOVE_CRUNCH),
    LEVEL_UP_END
};

const u16 gGranbullLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE( 4, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 8, MOVE_CHARM),
    LEVEL_UP_MOVE(13, MOVE_BITE),
    LEVEL_UP_MOVE(19, MOVE_LICK),
    LEVEL_UP_MOVE(28, MOVE_ROAR),
    LEVEL_UP_MOVE(38, MOVE_RAGE),
    LEVEL_UP_MOVE(49, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(61, MOVE_CRUNCH),
    LEVEL_UP_END
};

const u16 gQwilfishLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPIKES),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE(10, MOVE_HARDEN),
    LEVEL_UP_MOVE(10, MOVE_MINIMIZE),
    LEVEL_UP_MOVE(19, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(28, MOVE_PIN_MISSILE),
    LEVEL_UP_MOVE(37, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(46, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gScizorLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 6, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(11, MOVE_PURSUIT),
    LEVEL_UP_MOVE(16, MOVE_FALSE_SWIPE),
    LEVEL_UP_MOVE(21, MOVE_AGILITY),
    LEVEL_UP_MOVE(26, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE(31, MOVE_SLASH),
    LEVEL_UP_MOVE(36, MOVE_SWORDS_DANCE),
    LEVEL_UP_MOVE(41, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(46, MOVE_FURY_CUTTER),
    LEVEL_UP_END
};

const u16 gShuckleLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CONSTRICT),
    LEVEL_UP_MOVE( 1, MOVE_WITHDRAW),
    LEVEL_UP_MOVE( 9, MOVE_WRAP),
    LEVEL_UP_MOVE(14, MOVE_ENCORE),
    LEVEL_UP_MOVE(23, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(28, MOVE_BIDE),
    LEVEL_UP_MOVE(37, MOVE_REST),
    LEVEL_UP_END
};

const u16 gHeracrossLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 6, MOVE_HORN_ATTACK),
    LEVEL_UP_MOVE(11, MOVE_ENDURE),
    LEVEL_UP_MOVE(17, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(23, MOVE_BRICK_BREAK),
    LEVEL_UP_MOVE(30, MOVE_COUNTER),
    LEVEL_UP_MOVE(37, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(45, MOVE_REVERSAL),
    LEVEL_UP_MOVE(53, MOVE_MEGAHORN),
    LEVEL_UP_END
};

const u16 gSneaselLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_TAUNT),
    LEVEL_UP_MOVE( 8, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(15, MOVE_SCREECH),
    LEVEL_UP_MOVE(22, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(29, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(36, MOVE_AGILITY),
    LEVEL_UP_MOVE(43, MOVE_ICY_WIND),
    LEVEL_UP_MOVE(50, MOVE_SLASH),
    LEVEL_UP_MOVE(57, MOVE_BEAT_UP),
    LEVEL_UP_MOVE(64, MOVE_METAL_CLAW),
    LEVEL_UP_END
};

const u16 gTeddiursaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 7, MOVE_LICK),
    LEVEL_UP_MOVE(13, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(19, MOVE_FAKE_TEARS),
    LEVEL_UP_MOVE(25, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(31, MOVE_REST),
    LEVEL_UP_MOVE(37, MOVE_SLASH),
    LEVEL_UP_MOVE(43, MOVE_SNORE),
    LEVEL_UP_MOVE(49, MOVE_THRASH),
    LEVEL_UP_END
};

const u16 gUrsaringLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_LICK),
    LEVEL_UP_MOVE( 1, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE( 7, MOVE_LICK),
    LEVEL_UP_MOVE(13, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(19, MOVE_FAKE_TEARS),
    LEVEL_UP_MOVE(25, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(31, MOVE_REST),
    LEVEL_UP_MOVE(37, MOVE_SLASH),
    LEVEL_UP_MOVE(43, MOVE_SNORE),
    LEVEL_UP_MOVE(49, MOVE_THRASH),
    LEVEL_UP_END
};

const u16 gSlugmaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_YAWN),
    LEVEL_UP_MOVE( 1, MOVE_SMOG),
    LEVEL_UP_MOVE( 8, MOVE_EMBER),
    LEVEL_UP_MOVE(15, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(22, MOVE_HARDEN),
    LEVEL_UP_MOVE(29, MOVE_AMNESIA),
    LEVEL_UP_MOVE(36, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(43, MOVE_ROCK_SLIDE),
    LEVEL_UP_MOVE(50, MOVE_BODY_SLAM),
    LEVEL_UP_END
};

const u16 gMagcargoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_YAWN),
    LEVEL_UP_MOVE( 1, MOVE_SMOG),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 1, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE( 8, MOVE_EMBER),
    LEVEL_UP_MOVE(15, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(22, MOVE_HARDEN),
    LEVEL_UP_MOVE(29, MOVE_AMNESIA),
    LEVEL_UP_MOVE(36, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(48, MOVE_ROCK_SLIDE),
    LEVEL_UP_MOVE(60, MOVE_BODY_SLAM),
    LEVEL_UP_END
};

const u16 gSwinubLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(10, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE(19, MOVE_ENDURE),
    LEVEL_UP_MOVE(28, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(37, MOVE_MIST),
    LEVEL_UP_MOVE(46, MOVE_BLIZZARD),
    LEVEL_UP_MOVE(55, MOVE_AMNESIA),
    LEVEL_UP_END
};

const u16 gPiloswineLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HORN_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE( 1, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE( 1, MOVE_ENDURE),
    LEVEL_UP_MOVE(10, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE(19, MOVE_ENDURE),
    LEVEL_UP_MOVE(28, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(33, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(42, MOVE_MIST),
    LEVEL_UP_MOVE(56, MOVE_BLIZZARD),
    LEVEL_UP_MOVE(70, MOVE_AMNESIA),
    LEVEL_UP_END
};

const u16 gCorsolaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 6, MOVE_HARDEN),
    LEVEL_UP_MOVE(12, MOVE_BUBBLE),
    LEVEL_UP_MOVE(17, MOVE_RECOVER),
    LEVEL_UP_MOVE(17, MOVE_REFRESH),
    LEVEL_UP_MOVE(23, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(28, MOVE_SPIKE_CANNON),
    LEVEL_UP_MOVE(34, MOVE_ROCK_BLAST),
    LEVEL_UP_MOVE(39, MOVE_MIRROR_COAT),
    LEVEL_UP_MOVE(45, MOVE_ANCIENT_POWER),
    LEVEL_UP_END
};

const u16 gRemoraidLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(11, MOVE_LOCK_ON),
    LEVEL_UP_MOVE(22, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(22, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE(22, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(33, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(44, MOVE_ICE_BEAM),
    LEVEL_UP_MOVE(55, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gOctilleryLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(11, MOVE_CONSTRICT),
    LEVEL_UP_MOVE(22, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(22, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE(22, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(25, MOVE_OCTAZOOKA),
    LEVEL_UP_MOVE(38, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(54, MOVE_ICE_BEAM),
    LEVEL_UP_MOVE(70, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gDelibirdLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PRESENT),
    LEVEL_UP_END
};

const u16 gMantineLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 8, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(15, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(22, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(29, MOVE_AGILITY),
    LEVEL_UP_MOVE(36, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(43, MOVE_WATER_PULSE),
    LEVEL_UP_MOVE(50, MOVE_CONFUSE_RAY),
    LEVEL_UP_END
};

const u16 gSkarmoryLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE(10, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_SWIFT),
    LEVEL_UP_MOVE(16, MOVE_AGILITY),
    LEVEL_UP_MOVE(26, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(29, MOVE_AIR_CUTTER),
    LEVEL_UP_MOVE(32, MOVE_STEEL_WING),
    LEVEL_UP_MOVE(42, MOVE_SPIKES),
    LEVEL_UP_MOVE(45, MOVE_METAL_SOUND),
    LEVEL_UP_END
};

const u16 gHoundourLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 7, MOVE_HOWL),
    LEVEL_UP_MOVE(13, MOVE_SMOG),
    LEVEL_UP_MOVE(19, MOVE_ROAR),
    LEVEL_UP_MOVE(25, MOVE_BITE),
    LEVEL_UP_MOVE(31, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(37, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(43, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(49, MOVE_CRUNCH),
    LEVEL_UP_END
};

const u16 gHoundoomLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 1, MOVE_HOWL),
    LEVEL_UP_MOVE( 7, MOVE_HOWL),
    LEVEL_UP_MOVE(13, MOVE_SMOG),
    LEVEL_UP_MOVE(19, MOVE_ROAR),
    LEVEL_UP_MOVE(27, MOVE_BITE),
    LEVEL_UP_MOVE(35, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(43, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(51, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(59, MOVE_CRUNCH),
    LEVEL_UP_END
};

const u16 gKingdraLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 1, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 8, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(15, MOVE_LEER),
    LEVEL_UP_MOVE(22, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(29, MOVE_TWISTER),
    LEVEL_UP_MOVE(40, MOVE_AGILITY),
    LEVEL_UP_MOVE(51, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(62, MOVE_DRAGON_DANCE),
    LEVEL_UP_END
};

const u16 gPhanpyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 9, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(17, MOVE_FLAIL),
    LEVEL_UP_MOVE(25, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(33, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(41, MOVE_ENDURE),
    LEVEL_UP_MOVE(49, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gDonphanLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE( 1, MOVE_HORN_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 9, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(17, MOVE_FLAIL),
    LEVEL_UP_MOVE(25, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(33, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(41, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE(49, MOVE_EARTHQUAKE),
    LEVEL_UP_END
};

const u16 gPorygon2LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CONVERSION_2),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_CONVERSION),
    LEVEL_UP_MOVE( 9, MOVE_AGILITY),
    LEVEL_UP_MOVE(12, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(20, MOVE_RECOVER),
    LEVEL_UP_MOVE(24, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(32, MOVE_LOCK_ON),
    LEVEL_UP_MOVE(36, MOVE_TRI_ATTACK),
    LEVEL_UP_MOVE(44, MOVE_RECYCLE),
    LEVEL_UP_MOVE(48, MOVE_ZAP_CANNON),
    LEVEL_UP_END
};

const u16 gStantlerLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 7, MOVE_LEER),
    LEVEL_UP_MOVE(13, MOVE_ASTONISH),
    LEVEL_UP_MOVE(19, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(25, MOVE_STOMP),
    LEVEL_UP_MOVE(31, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(37, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(43, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(49, MOVE_CALM_MIND),
    LEVEL_UP_END
};

const u16 gSmeargleLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SKETCH),
    LEVEL_UP_MOVE(11, MOVE_SKETCH),
    LEVEL_UP_MOVE(21, MOVE_SKETCH),
    LEVEL_UP_MOVE(31, MOVE_SKETCH),
    LEVEL_UP_MOVE(41, MOVE_SKETCH),
    LEVEL_UP_MOVE(51, MOVE_SKETCH),
    LEVEL_UP_MOVE(61, MOVE_SKETCH),
    LEVEL_UP_MOVE(71, MOVE_SKETCH),
    LEVEL_UP_MOVE(81, MOVE_SKETCH),
    LEVEL_UP_MOVE(91, MOVE_SKETCH),
    LEVEL_UP_END
};

const u16 gTyrogueLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gHitmontopLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_REVENGE),
    LEVEL_UP_MOVE( 1, MOVE_ROLLING_KICK),
    LEVEL_UP_MOVE( 7, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(13, MOVE_PURSUIT),
    LEVEL_UP_MOVE(19, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(20, MOVE_TRIPLE_KICK),
    LEVEL_UP_MOVE(25, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE(31, MOVE_COUNTER),
    LEVEL_UP_MOVE(37, MOVE_AGILITY),
    LEVEL_UP_MOVE(43, MOVE_DETECT),
    LEVEL_UP_MOVE(49, MOVE_ENDEAVOR),
    LEVEL_UP_END
};

const u16 gSmoochumLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_LICK),
    LEVEL_UP_MOVE( 9, MOVE_SWEET_KISS),
    LEVEL_UP_MOVE(13, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE(21, MOVE_CONFUSION),
    LEVEL_UP_MOVE(25, MOVE_SING),
    LEVEL_UP_MOVE(33, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(37, MOVE_FAKE_TEARS),
    LEVEL_UP_MOVE(45, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(49, MOVE_PERISH_SONG),
    LEVEL_UP_MOVE(57, MOVE_BLIZZARD),
    LEVEL_UP_END
};

const u16 gElekidLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 9, MOVE_THUNDER_PUNCH),
    LEVEL_UP_MOVE(17, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(25, MOVE_SWIFT),
    LEVEL_UP_MOVE(33, MOVE_SCREECH),
    LEVEL_UP_MOVE(41, MOVE_THUNDERBOLT),
    LEVEL_UP_MOVE(49, MOVE_THUNDER),
    LEVEL_UP_END
};

const u16 gMagbyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 7, MOVE_LEER),
    LEVEL_UP_MOVE(13, MOVE_SMOG),
    LEVEL_UP_MOVE(19, MOVE_FIRE_PUNCH),
    LEVEL_UP_MOVE(25, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(31, MOVE_SUNNY_DAY),
    LEVEL_UP_MOVE(37, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(43, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(49, MOVE_FIRE_BLAST),
    LEVEL_UP_END
};

const u16 gMiltankLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 4, MOVE_GROWL),
    LEVEL_UP_MOVE( 8, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(13, MOVE_STOMP),
    LEVEL_UP_MOVE(19, MOVE_MILK_DRINK),
    LEVEL_UP_MOVE(26, MOVE_BIDE),
    LEVEL_UP_MOVE(34, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(43, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(53, MOVE_HEAL_BELL),
    LEVEL_UP_END
};

const u16 gBlisseyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 4, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 7, MOVE_REFRESH),
    LEVEL_UP_MOVE(10, MOVE_SOFT_BOILED),
    LEVEL_UP_MOVE(13, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE(18, MOVE_MINIMIZE),
    LEVEL_UP_MOVE(23, MOVE_SING),
    LEVEL_UP_MOVE(28, MOVE_EGG_BOMB),
    LEVEL_UP_MOVE(33, MOVE_DEFENSE_CURL),
    LEVEL_UP_MOVE(40, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(47, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gRaikouLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE(11, MOVE_THUNDER_SHOCK),
    LEVEL_UP_MOVE(21, MOVE_ROAR),
    LEVEL_UP_MOVE(31, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(41, MOVE_SPARK),
    LEVEL_UP_MOVE(51, MOVE_REFLECT),
    LEVEL_UP_MOVE(61, MOVE_CRUNCH),
    LEVEL_UP_MOVE(71, MOVE_THUNDER),
    LEVEL_UP_MOVE(81, MOVE_CALM_MIND),
    LEVEL_UP_END
};

const u16 gEnteiLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE(11, MOVE_EMBER),
    LEVEL_UP_MOVE(21, MOVE_ROAR),
    LEVEL_UP_MOVE(31, MOVE_FIRE_SPIN),
    LEVEL_UP_MOVE(41, MOVE_STOMP),
    LEVEL_UP_MOVE(51, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(61, MOVE_SWAGGER),
    LEVEL_UP_MOVE(71, MOVE_FIRE_BLAST),
    LEVEL_UP_MOVE(81, MOVE_CALM_MIND),
    LEVEL_UP_END
};

const u16 gSuicuneLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE(11, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(21, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(31, MOVE_GUST),
    LEVEL_UP_MOVE(41, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE(51, MOVE_MIST),
    LEVEL_UP_MOVE(61, MOVE_MIRROR_COAT),
    LEVEL_UP_MOVE(71, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(81, MOVE_CALM_MIND),
    LEVEL_UP_END
};

const u16 gLarvitarLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 8, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(15, MOVE_SCREECH),
    LEVEL_UP_MOVE(22, MOVE_ROCK_SLIDE),
    LEVEL_UP_MOVE(29, MOVE_THRASH),
    LEVEL_UP_MOVE(36, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(43, MOVE_CRUNCH),
    LEVEL_UP_MOVE(50, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(57, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gPupitarLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_SANDSTORM),
    LEVEL_UP_MOVE( 1, MOVE_SCREECH),
    LEVEL_UP_MOVE( 8, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(15, MOVE_SCREECH),
    LEVEL_UP_MOVE(22, MOVE_ROCK_SLIDE),
    LEVEL_UP_MOVE(29, MOVE_THRASH),
    LEVEL_UP_MOVE(38, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(47, MOVE_CRUNCH),
    LEVEL_UP_MOVE(56, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(65, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gTyranitarLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_SANDSTORM),
    LEVEL_UP_MOVE( 1, MOVE_SCREECH),
    LEVEL_UP_MOVE( 8, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(15, MOVE_SCREECH),
    LEVEL_UP_MOVE(22, MOVE_ROCK_SLIDE),
    LEVEL_UP_MOVE(29, MOVE_THRASH),
    LEVEL_UP_MOVE(38, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(47, MOVE_CRUNCH),
    LEVEL_UP_MOVE(61, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(75, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gLugiaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(11, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(22, MOVE_GUST),
    LEVEL_UP_MOVE(33, MOVE_RECOVER),
    LEVEL_UP_MOVE(44, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(55, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(66, MOVE_SWIFT),
    LEVEL_UP_MOVE(77, MOVE_AEROBLAST),
    LEVEL_UP_MOVE(88, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(99, MOVE_FUTURE_SIGHT),
    LEVEL_UP_END
};

const u16 gHoOhLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(11, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(22, MOVE_GUST),
    LEVEL_UP_MOVE(33, MOVE_RECOVER),
    LEVEL_UP_MOVE(44, MOVE_FIRE_BLAST),
    LEVEL_UP_MOVE(55, MOVE_SUNNY_DAY),
    LEVEL_UP_MOVE(66, MOVE_SWIFT),
    LEVEL_UP_MOVE(77, MOVE_SACRED_FIRE),
    LEVEL_UP_MOVE(88, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(99, MOVE_FUTURE_SIGHT),
    LEVEL_UP_END
};

const u16 gCelebiLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE( 1, MOVE_RECOVER),
    LEVEL_UP_MOVE( 1, MOVE_HEAL_BELL),
    LEVEL_UP_MOVE(10, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(20, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(30, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(40, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(50, MOVE_PERISH_SONG),
    LEVEL_UP_END
};

const u16 gSpecies252LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies253LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies254LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies255LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies256LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies257LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies258LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies259LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies260LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies261LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies262LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies263LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies264LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies265LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies266LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies267LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies268LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies269LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies270LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies271LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies272LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies273LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies274LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies275LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gSpecies276LevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_END
};

const u16 gTreeckoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 6, MOVE_ABSORB),
    LEVEL_UP_MOVE(11, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(16, MOVE_PURSUIT),
    LEVEL_UP_MOVE(21, MOVE_SCREECH),
    LEVEL_UP_MOVE(26, MOVE_MEGA_DRAIN),
    LEVEL_UP_MOVE(31, MOVE_AGILITY),
    LEVEL_UP_MOVE(36, MOVE_SLAM),
    LEVEL_UP_MOVE(41, MOVE_DETECT),
    LEVEL_UP_MOVE(46, MOVE_GIGA_DRAIN),
    LEVEL_UP_END
};

const u16 gGrovyleLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 6, MOVE_ABSORB),
    LEVEL_UP_MOVE(11, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(16, MOVE_FURY_CUTTER),
    LEVEL_UP_MOVE(17, MOVE_PURSUIT),
    LEVEL_UP_MOVE(23, MOVE_SCREECH),
    LEVEL_UP_MOVE(29, MOVE_LEAF_BLADE),
    LEVEL_UP_MOVE(35, MOVE_AGILITY),
    LEVEL_UP_MOVE(41, MOVE_SLAM),
    LEVEL_UP_MOVE(47, MOVE_DETECT),
    LEVEL_UP_MOVE(53, MOVE_FALSE_SWIPE),
    LEVEL_UP_END
};

const u16 gSceptileLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 6, MOVE_ABSORB),
    LEVEL_UP_MOVE(11, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(16, MOVE_FURY_CUTTER),
    LEVEL_UP_MOVE(17, MOVE_PURSUIT),
    LEVEL_UP_MOVE(23, MOVE_SCREECH),
    LEVEL_UP_MOVE(29, MOVE_LEAF_BLADE),
    LEVEL_UP_MOVE(35, MOVE_AGILITY),
    LEVEL_UP_MOVE(43, MOVE_SLAM),
    LEVEL_UP_MOVE(51, MOVE_DETECT),
    LEVEL_UP_MOVE(59, MOVE_FALSE_SWIPE),
    LEVEL_UP_END
};

const u16 gTorchicLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 7, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(10, MOVE_EMBER),
    LEVEL_UP_MOVE(16, MOVE_PECK),
    LEVEL_UP_MOVE(19, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(25, MOVE_FIRE_SPIN),
    LEVEL_UP_MOVE(28, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(34, MOVE_SLASH),
    LEVEL_UP_MOVE(37, MOVE_MIRROR_MOVE),
    LEVEL_UP_MOVE(43, MOVE_FLAMETHROWER),
    LEVEL_UP_END
};

const u16 gCombuskenLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 7, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(13, MOVE_EMBER),
    LEVEL_UP_MOVE(16, MOVE_DOUBLE_KICK),
    LEVEL_UP_MOVE(17, MOVE_PECK),
    LEVEL_UP_MOVE(21, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(28, MOVE_BULK_UP),
    LEVEL_UP_MOVE(32, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(39, MOVE_SLASH),
    LEVEL_UP_MOVE(43, MOVE_MIRROR_MOVE),
    LEVEL_UP_MOVE(50, MOVE_SKY_UPPERCUT),
    LEVEL_UP_END
};

const u16 gBlazikenLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_FIRE_PUNCH),
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 7, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(13, MOVE_EMBER),
    LEVEL_UP_MOVE(16, MOVE_DOUBLE_KICK),
    LEVEL_UP_MOVE(17, MOVE_PECK),
    LEVEL_UP_MOVE(21, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(28, MOVE_BULK_UP),
    LEVEL_UP_MOVE(32, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(36, MOVE_BLAZE_KICK),
    LEVEL_UP_MOVE(42, MOVE_SLASH),
    LEVEL_UP_MOVE(49, MOVE_MIRROR_MOVE),
    LEVEL_UP_MOVE(59, MOVE_SKY_UPPERCUT),
    LEVEL_UP_END
};

const u16 gMudkipLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 6, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(10, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(15, MOVE_BIDE),
    LEVEL_UP_MOVE(19, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(24, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(28, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(33, MOVE_WHIRLPOOL),
    LEVEL_UP_MOVE(37, MOVE_PROTECT),
    LEVEL_UP_MOVE(42, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(46, MOVE_ENDEAVOR),
    LEVEL_UP_END
};

const u16 gMarshtompLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 6, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(10, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(15, MOVE_BIDE),
    LEVEL_UP_MOVE(16, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE(20, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(25, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(31, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(37, MOVE_MUDDY_WATER),
    LEVEL_UP_MOVE(42, MOVE_PROTECT),
    LEVEL_UP_MOVE(46, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(53, MOVE_ENDEAVOR),
    LEVEL_UP_END
};

const u16 gSwampertLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 6, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(10, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(15, MOVE_BIDE),
    LEVEL_UP_MOVE(16, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE(20, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(25, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(31, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(39, MOVE_MUDDY_WATER),
    LEVEL_UP_MOVE(46, MOVE_PROTECT),
    LEVEL_UP_MOVE(52, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(61, MOVE_ENDEAVOR),
    LEVEL_UP_END
};

const u16 gPoochyenaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 5, MOVE_HOWL),
    LEVEL_UP_MOVE( 9, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_BITE),
    LEVEL_UP_MOVE(17, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(21, MOVE_ROAR),
    LEVEL_UP_MOVE(25, MOVE_SWAGGER),
    LEVEL_UP_MOVE(29, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(33, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(37, MOVE_TAUNT),
    LEVEL_UP_MOVE(41, MOVE_CRUNCH),
    LEVEL_UP_MOVE(45, MOVE_THIEF),
    LEVEL_UP_END
};

const u16 gMightyenaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_HOWL),
    LEVEL_UP_MOVE( 1, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 5, MOVE_HOWL),
    LEVEL_UP_MOVE( 9, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_BITE),
    LEVEL_UP_MOVE(17, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(22, MOVE_ROAR),
    LEVEL_UP_MOVE(27, MOVE_SWAGGER),
    LEVEL_UP_MOVE(32, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(37, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(42, MOVE_TAUNT),
    LEVEL_UP_MOVE(47, MOVE_CRUNCH),
    LEVEL_UP_MOVE(52, MOVE_THIEF),
    LEVEL_UP_END
};

const u16 gZigzagoonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 9, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(13, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(17, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(21, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(25, MOVE_PIN_MISSILE),
    LEVEL_UP_MOVE(29, MOVE_COVET),
    LEVEL_UP_MOVE(33, MOVE_FLAIL),
    LEVEL_UP_MOVE(37, MOVE_REST),
    LEVEL_UP_MOVE(41, MOVE_BELLY_DRUM),
    LEVEL_UP_END
};

const u16 gLinooneLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_HEADBUTT),
    LEVEL_UP_MOVE( 5, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 9, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(13, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(17, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(23, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(29, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(35, MOVE_COVET),
    LEVEL_UP_MOVE(41, MOVE_SLASH),
    LEVEL_UP_MOVE(47, MOVE_REST),
    LEVEL_UP_MOVE(53, MOVE_BELLY_DRUM),
    LEVEL_UP_END
};

const u16 gWurmpleLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_STRING_SHOT),
    LEVEL_UP_MOVE( 5, MOVE_POISON_STING),
    LEVEL_UP_END
};

const u16 gSilcoonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_HARDEN),
    LEVEL_UP_END
};

const u16 gBeautiflyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE(10, MOVE_ABSORB),
    LEVEL_UP_MOVE(13, MOVE_GUST),
    LEVEL_UP_MOVE(17, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(20, MOVE_MORNING_SUN),
    LEVEL_UP_MOVE(24, MOVE_MEGA_DRAIN),
    LEVEL_UP_MOVE(27, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(31, MOVE_ATTRACT),
    LEVEL_UP_MOVE(34, MOVE_SILVER_WIND),
    LEVEL_UP_MOVE(38, MOVE_GIGA_DRAIN),
    LEVEL_UP_END
};

const u16 gCascoonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_HARDEN),
    LEVEL_UP_END
};

const u16 gDustoxLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE(10, MOVE_CONFUSION),
    LEVEL_UP_MOVE(13, MOVE_GUST),
    LEVEL_UP_MOVE(17, MOVE_PROTECT),
    LEVEL_UP_MOVE(20, MOVE_MOONLIGHT),
    LEVEL_UP_MOVE(24, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(27, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(31, MOVE_LIGHT_SCREEN),
    LEVEL_UP_MOVE(34, MOVE_SILVER_WIND),
    LEVEL_UP_MOVE(38, MOVE_TOXIC),
    LEVEL_UP_END
};

const u16 gLotadLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 3, MOVE_GROWL),
    LEVEL_UP_MOVE( 7, MOVE_ABSORB),
    LEVEL_UP_MOVE(13, MOVE_NATURE_POWER),
    LEVEL_UP_MOVE(21, MOVE_MIST),
    LEVEL_UP_MOVE(31, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(43, MOVE_MEGA_DRAIN),
    LEVEL_UP_END
};

const u16 gLombreLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 3, MOVE_GROWL),
    LEVEL_UP_MOVE( 7, MOVE_ABSORB),
    LEVEL_UP_MOVE(13, MOVE_NATURE_POWER),
    LEVEL_UP_MOVE(19, MOVE_FAKE_OUT),
    LEVEL_UP_MOVE(25, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(31, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE(37, MOVE_THIEF),
    LEVEL_UP_MOVE(43, MOVE_UPROAR),
    LEVEL_UP_MOVE(49, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gLudicoloLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 1, MOVE_NATURE_POWER),
    LEVEL_UP_END
};

const u16 gSeedotLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BIDE),
    LEVEL_UP_MOVE( 3, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_GROWTH),
    LEVEL_UP_MOVE(13, MOVE_NATURE_POWER),
    LEVEL_UP_MOVE(21, MOVE_SYNTHESIS),
    LEVEL_UP_MOVE(31, MOVE_SUNNY_DAY),
    LEVEL_UP_MOVE(43, MOVE_EXPLOSION),
    LEVEL_UP_END
};

const u16 gNuzleafLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 3, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_GROWTH),
    LEVEL_UP_MOVE(13, MOVE_NATURE_POWER),
    LEVEL_UP_MOVE(19, MOVE_FAKE_OUT),
    LEVEL_UP_MOVE(25, MOVE_TORMENT),
    LEVEL_UP_MOVE(31, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(37, MOVE_RAZOR_WIND),
    LEVEL_UP_MOVE(43, MOVE_SWAGGER),
    LEVEL_UP_MOVE(49, MOVE_EXTRASENSORY),
    LEVEL_UP_END
};

const u16 gShiftryLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 1, MOVE_GROWTH),
    LEVEL_UP_MOVE( 1, MOVE_NATURE_POWER),
    LEVEL_UP_END
};

const u16 gNincadaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 5, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE( 9, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(14, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(19, MOVE_MIND_READER),
    LEVEL_UP_MOVE(25, MOVE_FALSE_SWIPE),
    LEVEL_UP_MOVE(31, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(38, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE(45, MOVE_DIG),
    LEVEL_UP_END
};

const u16 gNinjaskLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 1, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE( 1, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 5, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE( 9, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(14, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(19, MOVE_MIND_READER),
    LEVEL_UP_MOVE(20, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(20, MOVE_FURY_CUTTER),
    LEVEL_UP_MOVE(20, MOVE_SCREECH),
    LEVEL_UP_MOVE(25, MOVE_SWORDS_DANCE),
    LEVEL_UP_MOVE(31, MOVE_SLASH),
    LEVEL_UP_MOVE(38, MOVE_AGILITY),
    LEVEL_UP_MOVE(45, MOVE_BATON_PASS),
    LEVEL_UP_END
};

const u16 gShedinjaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 5, MOVE_LEECH_LIFE),
    LEVEL_UP_MOVE( 9, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(14, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(19, MOVE_MIND_READER),
    LEVEL_UP_MOVE(25, MOVE_SPITE),
    LEVEL_UP_MOVE(31, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(38, MOVE_SHADOW_BALL),
    LEVEL_UP_MOVE(45, MOVE_GRUDGE),
    LEVEL_UP_END
};

const u16 gTaillowLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 4, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 8, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(19, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(26, MOVE_ENDEAVOR),
    LEVEL_UP_MOVE(34, MOVE_AERIAL_ACE),
    LEVEL_UP_MOVE(43, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gSwellowLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 4, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 8, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(19, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(28, MOVE_ENDEAVOR),
    LEVEL_UP_MOVE(38, MOVE_AERIAL_ACE),
    LEVEL_UP_MOVE(49, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gShroomishLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 4, MOVE_TACKLE),
    LEVEL_UP_MOVE( 7, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(10, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(16, MOVE_MEGA_DRAIN),
    LEVEL_UP_MOVE(22, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(28, MOVE_POISON_POWDER),
    LEVEL_UP_MOVE(36, MOVE_GROWTH),
    LEVEL_UP_MOVE(45, MOVE_GIGA_DRAIN),
    LEVEL_UP_MOVE(54, MOVE_SPORE),
    LEVEL_UP_END
};

const u16 gBreloomLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE( 1, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE( 4, MOVE_TACKLE),
    LEVEL_UP_MOVE( 7, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(10, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(16, MOVE_MEGA_DRAIN),
    LEVEL_UP_MOVE(22, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(23, MOVE_MACH_PUNCH),
    LEVEL_UP_MOVE(28, MOVE_COUNTER),
    LEVEL_UP_MOVE(36, MOVE_SKY_UPPERCUT),
    LEVEL_UP_MOVE(45, MOVE_MIND_READER),
    LEVEL_UP_MOVE(54, MOVE_DYNAMIC_PUNCH),
    LEVEL_UP_END
};

const u16 gSpindaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 5, MOVE_UPROAR),
    LEVEL_UP_MOVE(12, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(16, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(23, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(27, MOVE_DIZZY_PUNCH),
    LEVEL_UP_MOVE(34, MOVE_TEETER_DANCE),
    LEVEL_UP_MOVE(38, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(45, MOVE_DOUBLE_EDGE),
    LEVEL_UP_MOVE(49, MOVE_FLAIL),
    LEVEL_UP_MOVE(56, MOVE_THRASH),
    LEVEL_UP_END
};

const u16 gWingullLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 7, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(13, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_MIST),
    LEVEL_UP_MOVE(31, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(43, MOVE_PURSUIT),
    LEVEL_UP_MOVE(55, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gPelipperLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE( 1, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE( 3, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 7, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(13, MOVE_WING_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_MIST),
    LEVEL_UP_MOVE(25, MOVE_PROTECT),
    LEVEL_UP_MOVE(33, MOVE_STOCKPILE),
    LEVEL_UP_MOVE(33, MOVE_SWALLOW),
    LEVEL_UP_MOVE(47, MOVE_SPIT_UP),
    LEVEL_UP_MOVE(61, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gSurskitLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 7, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(19, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE(25, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(31, MOVE_AGILITY),
    LEVEL_UP_MOVE(37, MOVE_MIST),
    LEVEL_UP_MOVE(37, MOVE_HAZE),
    LEVEL_UP_END
};

const u16 gMasquerainLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 1, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE( 1, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE( 7, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(19, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE(26, MOVE_GUST),
    LEVEL_UP_MOVE(33, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(40, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(47, MOVE_SILVER_WIND),
    LEVEL_UP_MOVE(53, MOVE_WHIRLWIND),
    LEVEL_UP_END
};

const u16 gWailmerLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE( 5, MOVE_GROWL),
    LEVEL_UP_MOVE(10, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(14, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(19, MOVE_WHIRLPOOL),
    LEVEL_UP_MOVE(23, MOVE_ASTONISH),
    LEVEL_UP_MOVE(28, MOVE_WATER_PULSE),
    LEVEL_UP_MOVE(32, MOVE_MIST),
    LEVEL_UP_MOVE(37, MOVE_REST),
    LEVEL_UP_MOVE(41, MOVE_WATER_SPOUT),
    LEVEL_UP_MOVE(46, MOVE_AMNESIA),
    LEVEL_UP_MOVE(50, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gWailordLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_ROLLOUT),
    LEVEL_UP_MOVE( 5, MOVE_GROWL),
    LEVEL_UP_MOVE(10, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(14, MOVE_ROLLOUT),
    LEVEL_UP_MOVE(19, MOVE_WHIRLPOOL),
    LEVEL_UP_MOVE(23, MOVE_ASTONISH),
    LEVEL_UP_MOVE(28, MOVE_WATER_PULSE),
    LEVEL_UP_MOVE(32, MOVE_MIST),
    LEVEL_UP_MOVE(37, MOVE_REST),
    LEVEL_UP_MOVE(44, MOVE_WATER_SPOUT),
    LEVEL_UP_MOVE(52, MOVE_AMNESIA),
    LEVEL_UP_MOVE(59, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gSkittyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 3, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 7, MOVE_ATTRACT),
    LEVEL_UP_MOVE(13, MOVE_SING),
    LEVEL_UP_MOVE(15, MOVE_DOUBLE_SLAP),
    LEVEL_UP_MOVE(19, MOVE_ASSIST),
    LEVEL_UP_MOVE(25, MOVE_CHARM),
    LEVEL_UP_MOVE(27, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(31, MOVE_COVET),
    LEVEL_UP_MOVE(37, MOVE_HEAL_BELL),
    LEVEL_UP_MOVE(39, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gDelcattyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_ATTRACT),
    LEVEL_UP_MOVE( 1, MOVE_SING),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_SLAP),
    LEVEL_UP_END
};

const u16 gKecleonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_THIEF),
    LEVEL_UP_MOVE( 1, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 1, MOVE_LICK),
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 4, MOVE_BIND),
    LEVEL_UP_MOVE( 7, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(12, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(17, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(24, MOVE_SCREECH),
    LEVEL_UP_MOVE(31, MOVE_SLASH),
    LEVEL_UP_MOVE(40, MOVE_SUBSTITUTE),
    LEVEL_UP_MOVE(49, MOVE_ANCIENT_POWER),
    LEVEL_UP_END
};

const u16 gBaltoyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE( 3, MOVE_HARDEN),
    LEVEL_UP_MOVE( 5, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE( 7, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(11, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(15, MOVE_ROCK_TOMB),
    LEVEL_UP_MOVE(19, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(25, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(31, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(37, MOVE_COSMIC_POWER),
    LEVEL_UP_MOVE(45, MOVE_EXPLOSION),
    LEVEL_UP_END
};

const u16 gClaydolLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TELEPORT),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 1, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE( 3, MOVE_HARDEN),
    LEVEL_UP_MOVE( 5, MOVE_RAPID_SPIN),
    LEVEL_UP_MOVE( 7, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(11, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(15, MOVE_ROCK_TOMB),
    LEVEL_UP_MOVE(19, MOVE_SELF_DESTRUCT),
    LEVEL_UP_MOVE(25, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(31, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(36, MOVE_HYPER_BEAM),
    LEVEL_UP_MOVE(42, MOVE_COSMIC_POWER),
    LEVEL_UP_MOVE(55, MOVE_EXPLOSION),
    LEVEL_UP_END
};

const u16 gNosepassLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 7, MOVE_HARDEN),
    LEVEL_UP_MOVE(13, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(16, MOVE_BLOCK),
    LEVEL_UP_MOVE(22, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(28, MOVE_ROCK_SLIDE),
    LEVEL_UP_MOVE(31, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(37, MOVE_REST),
    LEVEL_UP_MOVE(43, MOVE_ZAP_CANNON),
    LEVEL_UP_MOVE(46, MOVE_LOCK_ON),
    LEVEL_UP_END
};

const u16 gTorkoalLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 4, MOVE_SMOG),
    LEVEL_UP_MOVE( 7, MOVE_CURSE),
    LEVEL_UP_MOVE(14, MOVE_SMOKESCREEN),
    LEVEL_UP_MOVE(17, MOVE_FIRE_SPIN),
    LEVEL_UP_MOVE(20, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(27, MOVE_PROTECT),
    LEVEL_UP_MOVE(30, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(33, MOVE_IRON_DEFENSE),
    LEVEL_UP_MOVE(40, MOVE_AMNESIA),
    LEVEL_UP_MOVE(43, MOVE_FLAIL),
    LEVEL_UP_MOVE(46, MOVE_HEAT_WAVE),
    LEVEL_UP_END
};

const u16 gSableyeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 5, MOVE_FORESIGHT),
    LEVEL_UP_MOVE( 9, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(13, MOVE_ASTONISH),
    LEVEL_UP_MOVE(17, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(21, MOVE_FAKE_OUT),
    LEVEL_UP_MOVE(25, MOVE_DETECT),
    LEVEL_UP_MOVE(29, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(33, MOVE_KNOCK_OFF),
    LEVEL_UP_MOVE(37, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(41, MOVE_SHADOW_BALL),
    LEVEL_UP_MOVE(45, MOVE_MEAN_LOOK),
    LEVEL_UP_END
};

const u16 gBarboachLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE( 6, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE( 6, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE(11, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(16, MOVE_MAGNITUDE),
    LEVEL_UP_MOVE(21, MOVE_AMNESIA),
    LEVEL_UP_MOVE(26, MOVE_REST),
    LEVEL_UP_MOVE(26, MOVE_SNORE),
    LEVEL_UP_MOVE(31, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(36, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(41, MOVE_FISSURE),
    LEVEL_UP_END
};

const u16 gWhiscashLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TICKLE),
    LEVEL_UP_MOVE( 1, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE( 1, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE( 1, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE( 6, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE( 6, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE(11, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(16, MOVE_MAGNITUDE),
    LEVEL_UP_MOVE(21, MOVE_AMNESIA),
    LEVEL_UP_MOVE(26, MOVE_REST),
    LEVEL_UP_MOVE(26, MOVE_SNORE),
    LEVEL_UP_MOVE(36, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(46, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(56, MOVE_FISSURE),
    LEVEL_UP_END
};

const u16 gLuvdiscLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 4, MOVE_CHARM),
    LEVEL_UP_MOVE(12, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(16, MOVE_AGILITY),
    LEVEL_UP_MOVE(24, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(28, MOVE_ATTRACT),
    LEVEL_UP_MOVE(36, MOVE_SWEET_KISS),
    LEVEL_UP_MOVE(40, MOVE_FLAIL),
    LEVEL_UP_MOVE(48, MOVE_SAFEGUARD),
    LEVEL_UP_END
};

const u16 gCorphishLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 7, MOVE_HARDEN),
    LEVEL_UP_MOVE(10, MOVE_VICE_GRIP),
    LEVEL_UP_MOVE(13, MOVE_LEER),
    LEVEL_UP_MOVE(20, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(23, MOVE_PROTECT),
    LEVEL_UP_MOVE(26, MOVE_KNOCK_OFF),
    LEVEL_UP_MOVE(32, MOVE_TAUNT),
    LEVEL_UP_MOVE(35, MOVE_CRABHAMMER),
    LEVEL_UP_MOVE(38, MOVE_SWORDS_DANCE),
    LEVEL_UP_MOVE(44, MOVE_GUILLOTINE),
    LEVEL_UP_END
};

const u16 gCrawdauntLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BUBBLE),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 1, MOVE_VICE_GRIP),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 7, MOVE_HARDEN),
    LEVEL_UP_MOVE(10, MOVE_VICE_GRIP),
    LEVEL_UP_MOVE(13, MOVE_LEER),
    LEVEL_UP_MOVE(20, MOVE_BUBBLE_BEAM),
    LEVEL_UP_MOVE(23, MOVE_PROTECT),
    LEVEL_UP_MOVE(26, MOVE_KNOCK_OFF),
    LEVEL_UP_MOVE(34, MOVE_TAUNT),
    LEVEL_UP_MOVE(39, MOVE_CRABHAMMER),
    LEVEL_UP_MOVE(44, MOVE_SWORDS_DANCE),
    LEVEL_UP_MOVE(52, MOVE_GUILLOTINE),
    LEVEL_UP_END
};

const u16 gFeebasLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE(15, MOVE_TACKLE),
    LEVEL_UP_MOVE(30, MOVE_FLAIL),
    LEVEL_UP_END
};

const u16 gMiloticLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 5, MOVE_WRAP),
    LEVEL_UP_MOVE(10, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE(15, MOVE_REFRESH),
    LEVEL_UP_MOVE(20, MOVE_WATER_PULSE),
    LEVEL_UP_MOVE(25, MOVE_TWISTER),
    LEVEL_UP_MOVE(30, MOVE_RECOVER),
    LEVEL_UP_MOVE(35, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(40, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(45, MOVE_ATTRACT),
    LEVEL_UP_MOVE(50, MOVE_SAFEGUARD),
    LEVEL_UP_END
};

const u16 gCarvanhaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 7, MOVE_RAGE),
    LEVEL_UP_MOVE(13, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(16, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(22, MOVE_CRUNCH),
    LEVEL_UP_MOVE(28, MOVE_SCREECH),
    LEVEL_UP_MOVE(31, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(37, MOVE_SWAGGER),
    LEVEL_UP_MOVE(43, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gSharpedoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_RAGE),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 7, MOVE_RAGE),
    LEVEL_UP_MOVE(13, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(16, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(22, MOVE_CRUNCH),
    LEVEL_UP_MOVE(28, MOVE_SCREECH),
    LEVEL_UP_MOVE(33, MOVE_SLASH),
    LEVEL_UP_MOVE(38, MOVE_TAUNT),
    LEVEL_UP_MOVE(43, MOVE_SWAGGER),
    LEVEL_UP_MOVE(48, MOVE_SKULL_BASH),
    LEVEL_UP_MOVE(53, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gTrapinchLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 9, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(17, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(25, MOVE_SAND_TOMB),
    LEVEL_UP_MOVE(33, MOVE_CRUNCH),
    LEVEL_UP_MOVE(41, MOVE_DIG),
    LEVEL_UP_MOVE(49, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(57, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gVibravaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_SAND_TOMB),
    LEVEL_UP_MOVE( 9, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(17, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(25, MOVE_SAND_TOMB),
    LEVEL_UP_MOVE(33, MOVE_CRUNCH),
    LEVEL_UP_MOVE(35, MOVE_DRAGON_BREATH),
    LEVEL_UP_MOVE(41, MOVE_SCREECH),
    LEVEL_UP_MOVE(49, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(57, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gFlygonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_SAND_TOMB),
    LEVEL_UP_MOVE( 9, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(17, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(25, MOVE_SAND_TOMB),
    LEVEL_UP_MOVE(33, MOVE_CRUNCH),
    LEVEL_UP_MOVE(35, MOVE_DRAGON_BREATH),
    LEVEL_UP_MOVE(41, MOVE_SCREECH),
    LEVEL_UP_MOVE(53, MOVE_SANDSTORM),
    LEVEL_UP_MOVE(65, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gMakuhitaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 4, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(10, MOVE_ARM_THRUST),
    LEVEL_UP_MOVE(13, MOVE_VITAL_THROW),
    LEVEL_UP_MOVE(19, MOVE_FAKE_OUT),
    LEVEL_UP_MOVE(22, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(28, MOVE_KNOCK_OFF),
    LEVEL_UP_MOVE(31, MOVE_SMELLING_SALT),
    LEVEL_UP_MOVE(37, MOVE_BELLY_DRUM),
    LEVEL_UP_MOVE(40, MOVE_ENDURE),
    LEVEL_UP_MOVE(46, MOVE_SEISMIC_TOSS),
    LEVEL_UP_MOVE(49, MOVE_REVERSAL),
    LEVEL_UP_END
};

const u16 gHariyamaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 1, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE( 1, MOVE_ARM_THRUST),
    LEVEL_UP_MOVE( 4, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(10, MOVE_ARM_THRUST),
    LEVEL_UP_MOVE(13, MOVE_VITAL_THROW),
    LEVEL_UP_MOVE(19, MOVE_FAKE_OUT),
    LEVEL_UP_MOVE(22, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(29, MOVE_KNOCK_OFF),
    LEVEL_UP_MOVE(33, MOVE_SMELLING_SALT),
    LEVEL_UP_MOVE(40, MOVE_BELLY_DRUM),
    LEVEL_UP_MOVE(44, MOVE_ENDURE),
    LEVEL_UP_MOVE(51, MOVE_SEISMIC_TOSS),
    LEVEL_UP_MOVE(55, MOVE_REVERSAL),
    LEVEL_UP_END
};

const u16 gElectrikeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 4, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE( 9, MOVE_LEER),
    LEVEL_UP_MOVE(12, MOVE_HOWL),
    LEVEL_UP_MOVE(17, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(20, MOVE_SPARK),
    LEVEL_UP_MOVE(25, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(28, MOVE_ROAR),
    LEVEL_UP_MOVE(33, MOVE_BITE),
    LEVEL_UP_MOVE(36, MOVE_THUNDER),
    LEVEL_UP_MOVE(41, MOVE_CHARGE),
    LEVEL_UP_END
};

const u16 gManectricLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_HOWL),
    LEVEL_UP_MOVE( 4, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE( 9, MOVE_LEER),
    LEVEL_UP_MOVE(12, MOVE_HOWL),
    LEVEL_UP_MOVE(17, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(20, MOVE_SPARK),
    LEVEL_UP_MOVE(25, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(31, MOVE_ROAR),
    LEVEL_UP_MOVE(39, MOVE_BITE),
    LEVEL_UP_MOVE(45, MOVE_THUNDER),
    LEVEL_UP_MOVE(53, MOVE_CHARGE),
    LEVEL_UP_END
};

const u16 gNumelLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE(11, MOVE_EMBER),
    LEVEL_UP_MOVE(19, MOVE_MAGNITUDE),
    LEVEL_UP_MOVE(25, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(29, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(31, MOVE_AMNESIA),
    LEVEL_UP_MOVE(35, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(41, MOVE_FLAMETHROWER),
    LEVEL_UP_MOVE(49, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gCameruptLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_EMBER),
    LEVEL_UP_MOVE( 1, MOVE_MAGNITUDE),
    LEVEL_UP_MOVE(11, MOVE_EMBER),
    LEVEL_UP_MOVE(19, MOVE_MAGNITUDE),
    LEVEL_UP_MOVE(25, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(29, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(31, MOVE_AMNESIA),
    LEVEL_UP_MOVE(33, MOVE_ROCK_SLIDE),
    LEVEL_UP_MOVE(37, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(45, MOVE_ERUPTION),
    LEVEL_UP_MOVE(55, MOVE_FISSURE),
    LEVEL_UP_END
};

const u16 gSphealLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 7, MOVE_ENCORE),
    LEVEL_UP_MOVE(13, MOVE_ICE_BALL),
    LEVEL_UP_MOVE(19, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(25, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE(31, MOVE_HAIL),
    LEVEL_UP_MOVE(37, MOVE_REST),
    LEVEL_UP_MOVE(37, MOVE_SNORE),
    LEVEL_UP_MOVE(43, MOVE_BLIZZARD),
    LEVEL_UP_MOVE(49, MOVE_SHEER_COLD),
    LEVEL_UP_END
};

const u16 gSealeoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_ENCORE),
    LEVEL_UP_MOVE( 7, MOVE_ENCORE),
    LEVEL_UP_MOVE(13, MOVE_ICE_BALL),
    LEVEL_UP_MOVE(19, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(25, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE(31, MOVE_HAIL),
    LEVEL_UP_MOVE(39, MOVE_REST),
    LEVEL_UP_MOVE(39, MOVE_SNORE),
    LEVEL_UP_MOVE(47, MOVE_BLIZZARD),
    LEVEL_UP_MOVE(55, MOVE_SHEER_COLD),
    LEVEL_UP_END
};

const u16 gWalreinLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_ENCORE),
    LEVEL_UP_MOVE( 7, MOVE_ENCORE),
    LEVEL_UP_MOVE(13, MOVE_ICE_BALL),
    LEVEL_UP_MOVE(19, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(25, MOVE_AURORA_BEAM),
    LEVEL_UP_MOVE(31, MOVE_HAIL),
    LEVEL_UP_MOVE(39, MOVE_REST),
    LEVEL_UP_MOVE(39, MOVE_SNORE),
    LEVEL_UP_MOVE(50, MOVE_BLIZZARD),
    LEVEL_UP_MOVE(61, MOVE_SHEER_COLD),
    LEVEL_UP_END
};

const u16 gCacneaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 5, MOVE_ABSORB),
    LEVEL_UP_MOVE( 9, MOVE_GROWTH),
    LEVEL_UP_MOVE(13, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(17, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_PIN_MISSILE),
    LEVEL_UP_MOVE(25, MOVE_INGRAIN),
    LEVEL_UP_MOVE(29, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(33, MOVE_SPIKES),
    LEVEL_UP_MOVE(37, MOVE_NEEDLE_ARM),
    LEVEL_UP_MOVE(41, MOVE_COTTON_SPORE),
    LEVEL_UP_MOVE(45, MOVE_SANDSTORM),
    LEVEL_UP_END
};

const u16 gCacturneLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POISON_STING),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 1, MOVE_GROWTH),
    LEVEL_UP_MOVE( 5, MOVE_ABSORB),
    LEVEL_UP_MOVE( 9, MOVE_GROWTH),
    LEVEL_UP_MOVE(13, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(17, MOVE_SAND_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_PIN_MISSILE),
    LEVEL_UP_MOVE(25, MOVE_INGRAIN),
    LEVEL_UP_MOVE(29, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(35, MOVE_SPIKES),
    LEVEL_UP_MOVE(41, MOVE_NEEDLE_ARM),
    LEVEL_UP_MOVE(47, MOVE_COTTON_SPORE),
    LEVEL_UP_MOVE(53, MOVE_SANDSTORM),
    LEVEL_UP_END
};

const u16 gSnoruntLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 7, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(10, MOVE_BITE),
    LEVEL_UP_MOVE(16, MOVE_ICY_WIND),
    LEVEL_UP_MOVE(19, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(25, MOVE_PROTECT),
    LEVEL_UP_MOVE(28, MOVE_CRUNCH),
    LEVEL_UP_MOVE(34, MOVE_ICE_BEAM),
    LEVEL_UP_MOVE(37, MOVE_HAIL),
    LEVEL_UP_MOVE(43, MOVE_BLIZZARD),
    LEVEL_UP_END
};

const u16 gGlalieLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 7, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(10, MOVE_BITE),
    LEVEL_UP_MOVE(16, MOVE_ICY_WIND),
    LEVEL_UP_MOVE(19, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(25, MOVE_PROTECT),
    LEVEL_UP_MOVE(28, MOVE_CRUNCH),
    LEVEL_UP_MOVE(34, MOVE_ICE_BEAM),
    LEVEL_UP_MOVE(42, MOVE_HAIL),
    LEVEL_UP_MOVE(53, MOVE_BLIZZARD),
    LEVEL_UP_MOVE(61, MOVE_SHEER_COLD),
    LEVEL_UP_END
};

const u16 gLunatoneLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_CONFUSION),
    LEVEL_UP_MOVE(13, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(19, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(25, MOVE_PSYWAVE),
    LEVEL_UP_MOVE(31, MOVE_COSMIC_POWER),
    LEVEL_UP_MOVE(37, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(43, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(49, MOVE_EXPLOSION),
    LEVEL_UP_END
};

const u16 gSolrockLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_CONFUSION),
    LEVEL_UP_MOVE(13, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(19, MOVE_FIRE_SPIN),
    LEVEL_UP_MOVE(25, MOVE_PSYWAVE),
    LEVEL_UP_MOVE(31, MOVE_COSMIC_POWER),
    LEVEL_UP_MOVE(37, MOVE_ROCK_SLIDE),
    LEVEL_UP_MOVE(43, MOVE_SOLAR_BEAM),
    LEVEL_UP_MOVE(49, MOVE_EXPLOSION),
    LEVEL_UP_END
};

const u16 gAzurillLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE( 3, MOVE_CHARM),
    LEVEL_UP_MOVE( 6, MOVE_TAIL_WHIP),
    LEVEL_UP_MOVE(10, MOVE_BUBBLE),
    LEVEL_UP_MOVE(15, MOVE_SLAM),
    LEVEL_UP_MOVE(21, MOVE_WATER_GUN),
    LEVEL_UP_END
};

const u16 gSpoinkLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE( 7, MOVE_PSYWAVE),
    LEVEL_UP_MOVE(10, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(16, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(19, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(25, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(28, MOVE_MAGIC_COAT),
    LEVEL_UP_MOVE(34, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(37, MOVE_REST),
    LEVEL_UP_MOVE(37, MOVE_SNORE),
    LEVEL_UP_MOVE(43, MOVE_BOUNCE),
    LEVEL_UP_END
};

const u16 gGrumpigLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE( 1, MOVE_PSYWAVE),
    LEVEL_UP_MOVE( 1, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE( 1, MOVE_PSYBEAM),
    LEVEL_UP_MOVE( 7, MOVE_PSYWAVE),
    LEVEL_UP_MOVE(10, MOVE_ODOR_SLEUTH),
    LEVEL_UP_MOVE(16, MOVE_PSYBEAM),
    LEVEL_UP_MOVE(19, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(25, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(28, MOVE_MAGIC_COAT),
    LEVEL_UP_MOVE(37, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(43, MOVE_REST),
    LEVEL_UP_MOVE(43, MOVE_SNORE),
    LEVEL_UP_MOVE(55, MOVE_BOUNCE),
    LEVEL_UP_END
};

const u16 gPlusleLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 4, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(10, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(19, MOVE_SPARK),
    LEVEL_UP_MOVE(22, MOVE_ENCORE),
    LEVEL_UP_MOVE(28, MOVE_FAKE_TEARS),
    LEVEL_UP_MOVE(31, MOVE_CHARGE),
    LEVEL_UP_MOVE(37, MOVE_THUNDER),
    LEVEL_UP_MOVE(40, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(47, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gMinunLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 4, MOVE_THUNDER_WAVE),
    LEVEL_UP_MOVE(10, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(13, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(19, MOVE_SPARK),
    LEVEL_UP_MOVE(22, MOVE_ENCORE),
    LEVEL_UP_MOVE(28, MOVE_CHARM),
    LEVEL_UP_MOVE(31, MOVE_CHARGE),
    LEVEL_UP_MOVE(37, MOVE_THUNDER),
    LEVEL_UP_MOVE(40, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(47, MOVE_AGILITY),
    LEVEL_UP_END
};

const u16 gMawileLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 6, MOVE_FAKE_TEARS),
    LEVEL_UP_MOVE(11, MOVE_BITE),
    LEVEL_UP_MOVE(16, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(21, MOVE_VICE_GRIP),
    LEVEL_UP_MOVE(26, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(31, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(36, MOVE_CRUNCH),
    LEVEL_UP_MOVE(41, MOVE_IRON_DEFENSE),
    LEVEL_UP_MOVE(46, MOVE_STOCKPILE),
    LEVEL_UP_MOVE(46, MOVE_SWALLOW),
    LEVEL_UP_MOVE(46, MOVE_SPIT_UP),
    LEVEL_UP_END
};

const u16 gMedititeLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BIDE),
    LEVEL_UP_MOVE( 4, MOVE_MEDITATE),
    LEVEL_UP_MOVE( 9, MOVE_CONFUSION),
    LEVEL_UP_MOVE(12, MOVE_DETECT),
    LEVEL_UP_MOVE(18, MOVE_HIDDEN_POWER),
    LEVEL_UP_MOVE(22, MOVE_MIND_READER),
    LEVEL_UP_MOVE(28, MOVE_CALM_MIND),
    LEVEL_UP_MOVE(32, MOVE_HI_JUMP_KICK),
    LEVEL_UP_MOVE(38, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(42, MOVE_REVERSAL),
    LEVEL_UP_MOVE(48, MOVE_RECOVER),
    LEVEL_UP_END
};

const u16 gMedichamLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_FIRE_PUNCH),
    LEVEL_UP_MOVE( 1, MOVE_THUNDER_PUNCH),
    LEVEL_UP_MOVE( 1, MOVE_ICE_PUNCH),
    LEVEL_UP_MOVE( 1, MOVE_BIDE),
    LEVEL_UP_MOVE( 1, MOVE_MEDITATE),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE( 1, MOVE_DETECT),
    LEVEL_UP_MOVE( 4, MOVE_MEDITATE),
    LEVEL_UP_MOVE( 9, MOVE_CONFUSION),
    LEVEL_UP_MOVE(12, MOVE_DETECT),
    LEVEL_UP_MOVE(18, MOVE_HIDDEN_POWER),
    LEVEL_UP_MOVE(22, MOVE_MIND_READER),
    LEVEL_UP_MOVE(28, MOVE_CALM_MIND),
    LEVEL_UP_MOVE(32, MOVE_HI_JUMP_KICK),
    LEVEL_UP_MOVE(40, MOVE_PSYCH_UP),
    LEVEL_UP_MOVE(46, MOVE_REVERSAL),
    LEVEL_UP_MOVE(54, MOVE_RECOVER),
    LEVEL_UP_END
};

const u16 gSwabluLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 8, MOVE_ASTONISH),
    LEVEL_UP_MOVE(11, MOVE_SING),
    LEVEL_UP_MOVE(18, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(28, MOVE_MIST),
    LEVEL_UP_MOVE(31, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(38, MOVE_MIRROR_MOVE),
    LEVEL_UP_MOVE(41, MOVE_REFRESH),
    LEVEL_UP_MOVE(48, MOVE_PERISH_SONG),
    LEVEL_UP_END
};

const u16 gAltariaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PECK),
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 1, MOVE_SING),
    LEVEL_UP_MOVE( 8, MOVE_ASTONISH),
    LEVEL_UP_MOVE(11, MOVE_SING),
    LEVEL_UP_MOVE(18, MOVE_FURY_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(28, MOVE_MIST),
    LEVEL_UP_MOVE(31, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(35, MOVE_DRAGON_BREATH),
    LEVEL_UP_MOVE(40, MOVE_DRAGON_DANCE),
    LEVEL_UP_MOVE(45, MOVE_REFRESH),
    LEVEL_UP_MOVE(54, MOVE_PERISH_SONG),
    LEVEL_UP_MOVE(59, MOVE_SKY_ATTACK),
    LEVEL_UP_END
};

const u16 gWynautLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SPLASH),
    LEVEL_UP_MOVE( 1, MOVE_CHARM),
    LEVEL_UP_MOVE( 1, MOVE_ENCORE),
    LEVEL_UP_MOVE(15, MOVE_COUNTER),
    LEVEL_UP_MOVE(15, MOVE_MIRROR_COAT),
    LEVEL_UP_MOVE(15, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(15, MOVE_DESTINY_BOND),
    LEVEL_UP_END
};

const u16 gDuskullLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE( 5, MOVE_DISABLE),
    LEVEL_UP_MOVE(12, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(16, MOVE_ASTONISH),
    LEVEL_UP_MOVE(23, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(27, MOVE_PURSUIT),
    LEVEL_UP_MOVE(34, MOVE_CURSE),
    LEVEL_UP_MOVE(38, MOVE_WILL_O_WISP),
    LEVEL_UP_MOVE(45, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(49, MOVE_FUTURE_SIGHT),
    LEVEL_UP_END
};

const u16 gDusclopsLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_BIND),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE( 1, MOVE_DISABLE),
    LEVEL_UP_MOVE( 5, MOVE_DISABLE),
    LEVEL_UP_MOVE(12, MOVE_FORESIGHT),
    LEVEL_UP_MOVE(16, MOVE_ASTONISH),
    LEVEL_UP_MOVE(23, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(27, MOVE_PURSUIT),
    LEVEL_UP_MOVE(34, MOVE_CURSE),
    LEVEL_UP_MOVE(37, MOVE_SHADOW_PUNCH),
    LEVEL_UP_MOVE(41, MOVE_WILL_O_WISP),
    LEVEL_UP_MOVE(51, MOVE_MEAN_LOOK),
    LEVEL_UP_MOVE(58, MOVE_FUTURE_SIGHT),
    LEVEL_UP_END
};

const u16 gRoseliaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ABSORB),
    LEVEL_UP_MOVE( 5, MOVE_GROWTH),
    LEVEL_UP_MOVE( 9, MOVE_POISON_STING),
    LEVEL_UP_MOVE(13, MOVE_STUN_SPORE),
    LEVEL_UP_MOVE(17, MOVE_MEGA_DRAIN),
    LEVEL_UP_MOVE(21, MOVE_LEECH_SEED),
    LEVEL_UP_MOVE(25, MOVE_MAGICAL_LEAF),
    LEVEL_UP_MOVE(29, MOVE_GRASS_WHISTLE),
    LEVEL_UP_MOVE(33, MOVE_GIGA_DRAIN),
    LEVEL_UP_MOVE(37, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(41, MOVE_INGRAIN),
    LEVEL_UP_MOVE(45, MOVE_TOXIC),
    LEVEL_UP_MOVE(49, MOVE_PETAL_DANCE),
    LEVEL_UP_MOVE(53, MOVE_AROMATHERAPY),
    LEVEL_UP_MOVE(57, MOVE_SYNTHESIS),
    LEVEL_UP_END
};

const u16 gSlakothLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_YAWN),
    LEVEL_UP_MOVE( 7, MOVE_ENCORE),
    LEVEL_UP_MOVE(13, MOVE_SLACK_OFF),
    LEVEL_UP_MOVE(19, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(25, MOVE_AMNESIA),
    LEVEL_UP_MOVE(31, MOVE_COVET),
    LEVEL_UP_MOVE(37, MOVE_COUNTER),
    LEVEL_UP_MOVE(43, MOVE_FLAIL),
    LEVEL_UP_END
};

const u16 gVigorothLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE( 1, MOVE_ENCORE),
    LEVEL_UP_MOVE( 1, MOVE_UPROAR),
    LEVEL_UP_MOVE( 7, MOVE_ENCORE),
    LEVEL_UP_MOVE(13, MOVE_UPROAR),
    LEVEL_UP_MOVE(19, MOVE_FURY_SWIPES),
    LEVEL_UP_MOVE(25, MOVE_ENDURE),
    LEVEL_UP_MOVE(31, MOVE_SLASH),
    LEVEL_UP_MOVE(37, MOVE_COUNTER),
    LEVEL_UP_MOVE(43, MOVE_FOCUS_PUNCH),
    LEVEL_UP_MOVE(49, MOVE_REVERSAL),
    LEVEL_UP_END
};

const u16 gSlakingLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_YAWN),
    LEVEL_UP_MOVE( 1, MOVE_ENCORE),
    LEVEL_UP_MOVE( 1, MOVE_SLACK_OFF),
    LEVEL_UP_MOVE( 7, MOVE_ENCORE),
    LEVEL_UP_MOVE(13, MOVE_SLACK_OFF),
    LEVEL_UP_MOVE(19, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(25, MOVE_AMNESIA),
    LEVEL_UP_MOVE(31, MOVE_COVET),
    LEVEL_UP_MOVE(36, MOVE_SWAGGER),
    LEVEL_UP_MOVE(37, MOVE_COUNTER),
    LEVEL_UP_MOVE(43, MOVE_FLAIL),
    LEVEL_UP_END
};

const u16 gGulpinLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 6, MOVE_YAWN),
    LEVEL_UP_MOVE( 9, MOVE_POISON_GAS),
    LEVEL_UP_MOVE(14, MOVE_SLUDGE),
    LEVEL_UP_MOVE(17, MOVE_AMNESIA),
    LEVEL_UP_MOVE(23, MOVE_ENCORE),
    LEVEL_UP_MOVE(28, MOVE_TOXIC),
    LEVEL_UP_MOVE(34, MOVE_STOCKPILE),
    LEVEL_UP_MOVE(34, MOVE_SPIT_UP),
    LEVEL_UP_MOVE(34, MOVE_SWALLOW),
    LEVEL_UP_MOVE(39, MOVE_SLUDGE_BOMB),
    LEVEL_UP_END
};

const u16 gSwalotLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_YAWN),
    LEVEL_UP_MOVE( 1, MOVE_POISON_GAS),
    LEVEL_UP_MOVE( 1, MOVE_SLUDGE),
    LEVEL_UP_MOVE( 6, MOVE_YAWN),
    LEVEL_UP_MOVE( 9, MOVE_POISON_GAS),
    LEVEL_UP_MOVE(14, MOVE_SLUDGE),
    LEVEL_UP_MOVE(17, MOVE_AMNESIA),
    LEVEL_UP_MOVE(23, MOVE_ENCORE),
    LEVEL_UP_MOVE(26, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(31, MOVE_TOXIC),
    LEVEL_UP_MOVE(40, MOVE_STOCKPILE),
    LEVEL_UP_MOVE(40, MOVE_SPIT_UP),
    LEVEL_UP_MOVE(40, MOVE_SWALLOW),
    LEVEL_UP_MOVE(48, MOVE_SLUDGE_BOMB),
    LEVEL_UP_END
};

const u16 gTropiusLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_GUST),
    LEVEL_UP_MOVE( 7, MOVE_GROWTH),
    LEVEL_UP_MOVE(11, MOVE_RAZOR_LEAF),
    LEVEL_UP_MOVE(17, MOVE_STOMP),
    LEVEL_UP_MOVE(21, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE(27, MOVE_WHIRLWIND),
    LEVEL_UP_MOVE(31, MOVE_MAGICAL_LEAF),
    LEVEL_UP_MOVE(37, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(41, MOVE_SOLAR_BEAM),
    LEVEL_UP_MOVE(47, MOVE_SYNTHESIS),
    LEVEL_UP_END
};

const u16 gWhismurLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 5, MOVE_UPROAR),
    LEVEL_UP_MOVE(11, MOVE_ASTONISH),
    LEVEL_UP_MOVE(15, MOVE_HOWL),
    LEVEL_UP_MOVE(21, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(25, MOVE_STOMP),
    LEVEL_UP_MOVE(31, MOVE_SCREECH),
    LEVEL_UP_MOVE(35, MOVE_ROAR),
    LEVEL_UP_MOVE(41, MOVE_REST),
    LEVEL_UP_MOVE(41, MOVE_SLEEP_TALK),
    LEVEL_UP_MOVE(45, MOVE_HYPER_VOICE),
    LEVEL_UP_END
};

const u16 gLoudredLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_UPROAR),
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 1, MOVE_HOWL),
    LEVEL_UP_MOVE( 5, MOVE_UPROAR),
    LEVEL_UP_MOVE(11, MOVE_ASTONISH),
    LEVEL_UP_MOVE(15, MOVE_HOWL),
    LEVEL_UP_MOVE(23, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(29, MOVE_STOMP),
    LEVEL_UP_MOVE(37, MOVE_SCREECH),
    LEVEL_UP_MOVE(43, MOVE_ROAR),
    LEVEL_UP_MOVE(51, MOVE_REST),
    LEVEL_UP_MOVE(51, MOVE_SLEEP_TALK),
    LEVEL_UP_MOVE(57, MOVE_HYPER_VOICE),
    LEVEL_UP_END
};

const u16 gExploudLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_POUND),
    LEVEL_UP_MOVE( 1, MOVE_UPROAR),
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 1, MOVE_HOWL),
    LEVEL_UP_MOVE( 5, MOVE_UPROAR),
    LEVEL_UP_MOVE(11, MOVE_ASTONISH),
    LEVEL_UP_MOVE(15, MOVE_HOWL),
    LEVEL_UP_MOVE(23, MOVE_SUPERSONIC),
    LEVEL_UP_MOVE(29, MOVE_STOMP),
    LEVEL_UP_MOVE(37, MOVE_SCREECH),
    LEVEL_UP_MOVE(40, MOVE_HYPER_BEAM),
    LEVEL_UP_MOVE(45, MOVE_ROAR),
    LEVEL_UP_MOVE(55, MOVE_REST),
    LEVEL_UP_MOVE(55, MOVE_SLEEP_TALK),
    LEVEL_UP_MOVE(63, MOVE_HYPER_VOICE),
    LEVEL_UP_END
};

const u16 gClamperlLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_CLAMP),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 1, MOVE_WHIRLPOOL),
    LEVEL_UP_MOVE( 1, MOVE_IRON_DEFENSE),
    LEVEL_UP_END
};

const u16 gHuntailLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WHIRLPOOL),
    LEVEL_UP_MOVE( 8, MOVE_BITE),
    LEVEL_UP_MOVE(15, MOVE_SCREECH),
    LEVEL_UP_MOVE(22, MOVE_WATER_PULSE),
    LEVEL_UP_MOVE(29, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(36, MOVE_CRUNCH),
    LEVEL_UP_MOVE(43, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(50, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gGorebyssLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WHIRLPOOL),
    LEVEL_UP_MOVE( 8, MOVE_CONFUSION),
    LEVEL_UP_MOVE(15, MOVE_AGILITY),
    LEVEL_UP_MOVE(22, MOVE_WATER_PULSE),
    LEVEL_UP_MOVE(29, MOVE_AMNESIA),
    LEVEL_UP_MOVE(36, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(43, MOVE_BATON_PASS),
    LEVEL_UP_MOVE(50, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gAbsolLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 5, MOVE_LEER),
    LEVEL_UP_MOVE( 9, MOVE_TAUNT),
    LEVEL_UP_MOVE(13, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(17, MOVE_RAZOR_WIND),
    LEVEL_UP_MOVE(21, MOVE_BITE),
    LEVEL_UP_MOVE(26, MOVE_SWORDS_DANCE),
    LEVEL_UP_MOVE(31, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(36, MOVE_SLASH),
    LEVEL_UP_MOVE(41, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(46, MOVE_PERISH_SONG),
    LEVEL_UP_END
};

const u16 gShuppetLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_KNOCK_OFF),
    LEVEL_UP_MOVE( 8, MOVE_SCREECH),
    LEVEL_UP_MOVE(13, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(20, MOVE_CURSE),
    LEVEL_UP_MOVE(25, MOVE_SPITE),
    LEVEL_UP_MOVE(32, MOVE_WILL_O_WISP),
    LEVEL_UP_MOVE(37, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(44, MOVE_SHADOW_BALL),
    LEVEL_UP_MOVE(49, MOVE_SNATCH),
    LEVEL_UP_MOVE(56, MOVE_GRUDGE),
    LEVEL_UP_END
};

const u16 gBanetteLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_KNOCK_OFF),
    LEVEL_UP_MOVE( 1, MOVE_SCREECH),
    LEVEL_UP_MOVE( 1, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE( 1, MOVE_CURSE),
    LEVEL_UP_MOVE( 8, MOVE_SCREECH),
    LEVEL_UP_MOVE(13, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(20, MOVE_CURSE),
    LEVEL_UP_MOVE(25, MOVE_SPITE),
    LEVEL_UP_MOVE(32, MOVE_WILL_O_WISP),
    LEVEL_UP_MOVE(39, MOVE_FAINT_ATTACK),
    LEVEL_UP_MOVE(48, MOVE_SHADOW_BALL),
    LEVEL_UP_MOVE(55, MOVE_SNATCH),
    LEVEL_UP_MOVE(64, MOVE_GRUDGE),
    LEVEL_UP_END
};

const u16 gSeviperLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WRAP),
    LEVEL_UP_MOVE( 7, MOVE_LICK),
    LEVEL_UP_MOVE(10, MOVE_BITE),
    LEVEL_UP_MOVE(16, MOVE_POISON_TAIL),
    LEVEL_UP_MOVE(19, MOVE_SCREECH),
    LEVEL_UP_MOVE(25, MOVE_GLARE),
    LEVEL_UP_MOVE(28, MOVE_CRUNCH),
    LEVEL_UP_MOVE(34, MOVE_POISON_FANG),
    LEVEL_UP_MOVE(37, MOVE_SWAGGER),
    LEVEL_UP_MOVE(43, MOVE_HAZE),
    LEVEL_UP_END
};

const u16 gZangooseLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 4, MOVE_LEER),
    LEVEL_UP_MOVE( 7, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(10, MOVE_SWORDS_DANCE),
    LEVEL_UP_MOVE(13, MOVE_FURY_CUTTER),
    LEVEL_UP_MOVE(19, MOVE_SLASH),
    LEVEL_UP_MOVE(25, MOVE_PURSUIT),
    LEVEL_UP_MOVE(31, MOVE_CRUSH_CLAW),
    LEVEL_UP_MOVE(37, MOVE_TAUNT),
    LEVEL_UP_MOVE(46, MOVE_DETECT),
    LEVEL_UP_MOVE(55, MOVE_FALSE_SWIPE),
    LEVEL_UP_END
};

const u16 gRelicanthLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 8, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(15, MOVE_ROCK_TOMB),
    LEVEL_UP_MOVE(22, MOVE_YAWN),
    LEVEL_UP_MOVE(29, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(36, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(43, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(50, MOVE_REST),
    LEVEL_UP_MOVE(57, MOVE_DOUBLE_EDGE),
    LEVEL_UP_MOVE(64, MOVE_HYDRO_PUMP),
    LEVEL_UP_END
};

const u16 gAronLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 4, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(10, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(13, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE(17, MOVE_IRON_DEFENSE),
    LEVEL_UP_MOVE(21, MOVE_ROAR),
    LEVEL_UP_MOVE(25, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(29, MOVE_IRON_TAIL),
    LEVEL_UP_MOVE(34, MOVE_PROTECT),
    LEVEL_UP_MOVE(39, MOVE_METAL_SOUND),
    LEVEL_UP_MOVE(44, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gLaironLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 1, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE( 1, MOVE_HEADBUTT),
    LEVEL_UP_MOVE( 4, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(10, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(13, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE(17, MOVE_IRON_DEFENSE),
    LEVEL_UP_MOVE(21, MOVE_ROAR),
    LEVEL_UP_MOVE(25, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(29, MOVE_IRON_TAIL),
    LEVEL_UP_MOVE(37, MOVE_PROTECT),
    LEVEL_UP_MOVE(45, MOVE_METAL_SOUND),
    LEVEL_UP_MOVE(53, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gAggronLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 1, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE( 1, MOVE_HEADBUTT),
    LEVEL_UP_MOVE( 4, MOVE_HARDEN),
    LEVEL_UP_MOVE( 7, MOVE_MUD_SLAP),
    LEVEL_UP_MOVE(10, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(13, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE(17, MOVE_IRON_DEFENSE),
    LEVEL_UP_MOVE(21, MOVE_ROAR),
    LEVEL_UP_MOVE(25, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(29, MOVE_IRON_TAIL),
    LEVEL_UP_MOVE(37, MOVE_PROTECT),
    LEVEL_UP_MOVE(50, MOVE_METAL_SOUND),
    LEVEL_UP_MOVE(63, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gCastformLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE(10, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(10, MOVE_EMBER),
    LEVEL_UP_MOVE(10, MOVE_POWDER_SNOW),
    LEVEL_UP_MOVE(20, MOVE_RAIN_DANCE),
    LEVEL_UP_MOVE(20, MOVE_SUNNY_DAY),
    LEVEL_UP_MOVE(20, MOVE_HAIL),
    LEVEL_UP_MOVE(30, MOVE_WEATHER_BALL),
    LEVEL_UP_END
};

const u16 gVolbeatLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 5, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE( 9, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(13, MOVE_MOONLIGHT),
    LEVEL_UP_MOVE(17, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_TAIL_GLOW),
    LEVEL_UP_MOVE(25, MOVE_SIGNAL_BEAM),
    LEVEL_UP_MOVE(29, MOVE_PROTECT),
    LEVEL_UP_MOVE(33, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(37, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gIllumiseLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TACKLE),
    LEVEL_UP_MOVE( 5, MOVE_SWEET_SCENT),
    LEVEL_UP_MOVE( 9, MOVE_CHARM),
    LEVEL_UP_MOVE(13, MOVE_MOONLIGHT),
    LEVEL_UP_MOVE(17, MOVE_QUICK_ATTACK),
    LEVEL_UP_MOVE(21, MOVE_WISH),
    LEVEL_UP_MOVE(25, MOVE_ENCORE),
    LEVEL_UP_MOVE(29, MOVE_FLATTER),
    LEVEL_UP_MOVE(33, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(37, MOVE_COVET),
    LEVEL_UP_END
};

const u16 gLileepLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 8, MOVE_CONSTRICT),
    LEVEL_UP_MOVE(15, MOVE_ACID),
    LEVEL_UP_MOVE(22, MOVE_INGRAIN),
    LEVEL_UP_MOVE(29, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(36, MOVE_AMNESIA),
    LEVEL_UP_MOVE(43, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(50, MOVE_STOCKPILE),
    LEVEL_UP_MOVE(50, MOVE_SPIT_UP),
    LEVEL_UP_MOVE(50, MOVE_SWALLOW),
    LEVEL_UP_END
};

const u16 gCradilyLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_ASTONISH),
    LEVEL_UP_MOVE( 1, MOVE_CONSTRICT),
    LEVEL_UP_MOVE( 1, MOVE_ACID),
    LEVEL_UP_MOVE( 1, MOVE_INGRAIN),
    LEVEL_UP_MOVE( 8, MOVE_CONSTRICT),
    LEVEL_UP_MOVE(15, MOVE_ACID),
    LEVEL_UP_MOVE(22, MOVE_INGRAIN),
    LEVEL_UP_MOVE(29, MOVE_CONFUSE_RAY),
    LEVEL_UP_MOVE(36, MOVE_AMNESIA),
    LEVEL_UP_MOVE(48, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(60, MOVE_STOCKPILE),
    LEVEL_UP_MOVE(60, MOVE_SPIT_UP),
    LEVEL_UP_MOVE(60, MOVE_SWALLOW),
    LEVEL_UP_END
};

const u16 gAnorithLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 7, MOVE_HARDEN),
    LEVEL_UP_MOVE(13, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(19, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(25, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE(31, MOVE_PROTECT),
    LEVEL_UP_MOVE(37, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(43, MOVE_FURY_CUTTER),
    LEVEL_UP_MOVE(49, MOVE_SLASH),
    LEVEL_UP_MOVE(55, MOVE_ROCK_BLAST),
    LEVEL_UP_END
};

const u16 gArmaldoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_SCRATCH),
    LEVEL_UP_MOVE( 1, MOVE_HARDEN),
    LEVEL_UP_MOVE( 1, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE( 1, MOVE_WATER_GUN),
    LEVEL_UP_MOVE( 7, MOVE_HARDEN),
    LEVEL_UP_MOVE(13, MOVE_MUD_SPORT),
    LEVEL_UP_MOVE(19, MOVE_WATER_GUN),
    LEVEL_UP_MOVE(25, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE(31, MOVE_PROTECT),
    LEVEL_UP_MOVE(37, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(46, MOVE_FURY_CUTTER),
    LEVEL_UP_MOVE(55, MOVE_SLASH),
    LEVEL_UP_MOVE(64, MOVE_ROCK_BLAST),
    LEVEL_UP_END
};

const u16 gRaltsLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 6, MOVE_CONFUSION),
    LEVEL_UP_MOVE(11, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(16, MOVE_TELEPORT),
    LEVEL_UP_MOVE(21, MOVE_CALM_MIND),
    LEVEL_UP_MOVE(26, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(31, MOVE_IMPRISON),
    LEVEL_UP_MOVE(36, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(41, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(46, MOVE_DREAM_EATER),
    LEVEL_UP_END
};

const u16 gKirliaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE( 1, MOVE_TELEPORT),
    LEVEL_UP_MOVE( 6, MOVE_CONFUSION),
    LEVEL_UP_MOVE(11, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(16, MOVE_TELEPORT),
    LEVEL_UP_MOVE(21, MOVE_CALM_MIND),
    LEVEL_UP_MOVE(26, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(33, MOVE_IMPRISON),
    LEVEL_UP_MOVE(40, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(47, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(54, MOVE_DREAM_EATER),
    LEVEL_UP_END
};

const u16 gGardevoirLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_GROWL),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE( 1, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE( 1, MOVE_TELEPORT),
    LEVEL_UP_MOVE( 6, MOVE_CONFUSION),
    LEVEL_UP_MOVE(11, MOVE_DOUBLE_TEAM),
    LEVEL_UP_MOVE(16, MOVE_TELEPORT),
    LEVEL_UP_MOVE(21, MOVE_CALM_MIND),
    LEVEL_UP_MOVE(26, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(33, MOVE_IMPRISON),
    LEVEL_UP_MOVE(42, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(51, MOVE_HYPNOSIS),
    LEVEL_UP_MOVE(60, MOVE_DREAM_EATER),
    LEVEL_UP_END
};

const u16 gBagonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_RAGE),
    LEVEL_UP_MOVE( 5, MOVE_BITE),
    LEVEL_UP_MOVE( 9, MOVE_LEER),
    LEVEL_UP_MOVE(17, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(21, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(25, MOVE_EMBER),
    LEVEL_UP_MOVE(33, MOVE_DRAGON_BREATH),
    LEVEL_UP_MOVE(37, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(41, MOVE_CRUNCH),
    LEVEL_UP_MOVE(49, MOVE_DRAGON_CLAW),
    LEVEL_UP_MOVE(53, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gShelgonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_RAGE),
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_HEADBUTT),
    LEVEL_UP_MOVE( 5, MOVE_BITE),
    LEVEL_UP_MOVE( 9, MOVE_LEER),
    LEVEL_UP_MOVE(17, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(21, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(25, MOVE_EMBER),
    LEVEL_UP_MOVE(30, MOVE_PROTECT),
    LEVEL_UP_MOVE(38, MOVE_DRAGON_BREATH),
    LEVEL_UP_MOVE(47, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(56, MOVE_CRUNCH),
    LEVEL_UP_MOVE(69, MOVE_DRAGON_CLAW),
    LEVEL_UP_MOVE(78, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gSalamenceLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_RAGE),
    LEVEL_UP_MOVE( 1, MOVE_BITE),
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_HEADBUTT),
    LEVEL_UP_MOVE( 5, MOVE_BITE),
    LEVEL_UP_MOVE( 9, MOVE_LEER),
    LEVEL_UP_MOVE(17, MOVE_HEADBUTT),
    LEVEL_UP_MOVE(21, MOVE_FOCUS_ENERGY),
    LEVEL_UP_MOVE(25, MOVE_EMBER),
    LEVEL_UP_MOVE(30, MOVE_PROTECT),
    LEVEL_UP_MOVE(38, MOVE_DRAGON_BREATH),
    LEVEL_UP_MOVE(47, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(50, MOVE_FLY),
    LEVEL_UP_MOVE(61, MOVE_CRUNCH),
    LEVEL_UP_MOVE(79, MOVE_DRAGON_CLAW),
    LEVEL_UP_MOVE(93, MOVE_DOUBLE_EDGE),
    LEVEL_UP_END
};

const u16 gBeldumLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TAKE_DOWN),
    LEVEL_UP_END
};

const u16 gMetangLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(20, MOVE_CONFUSION),
    LEVEL_UP_MOVE(20, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE(26, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(32, MOVE_PURSUIT),
    LEVEL_UP_MOVE(38, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(44, MOVE_IRON_DEFENSE),
    LEVEL_UP_MOVE(50, MOVE_METEOR_MASH),
    LEVEL_UP_MOVE(56, MOVE_AGILITY),
    LEVEL_UP_MOVE(62, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gMetagrossLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE( 1, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE( 1, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(20, MOVE_CONFUSION),
    LEVEL_UP_MOVE(20, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE(26, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(32, MOVE_PURSUIT),
    LEVEL_UP_MOVE(38, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(44, MOVE_IRON_DEFENSE),
    LEVEL_UP_MOVE(55, MOVE_METEOR_MASH),
    LEVEL_UP_MOVE(66, MOVE_AGILITY),
    LEVEL_UP_MOVE(77, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gRegirockLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_EXPLOSION),
    LEVEL_UP_MOVE( 9, MOVE_ROCK_THROW),
    LEVEL_UP_MOVE(17, MOVE_CURSE),
    LEVEL_UP_MOVE(25, MOVE_SUPERPOWER),
    LEVEL_UP_MOVE(33, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(41, MOVE_IRON_DEFENSE),
    LEVEL_UP_MOVE(49, MOVE_ZAP_CANNON),
    LEVEL_UP_MOVE(57, MOVE_LOCK_ON),
    LEVEL_UP_MOVE(65, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gRegiceLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_EXPLOSION),
    LEVEL_UP_MOVE( 9, MOVE_ICY_WIND),
    LEVEL_UP_MOVE(17, MOVE_CURSE),
    LEVEL_UP_MOVE(25, MOVE_SUPERPOWER),
    LEVEL_UP_MOVE(33, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(41, MOVE_AMNESIA),
    LEVEL_UP_MOVE(49, MOVE_ZAP_CANNON),
    LEVEL_UP_MOVE(57, MOVE_LOCK_ON),
    LEVEL_UP_MOVE(65, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gRegisteelLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_EXPLOSION),
    LEVEL_UP_MOVE( 9, MOVE_METAL_CLAW),
    LEVEL_UP_MOVE(17, MOVE_CURSE),
    LEVEL_UP_MOVE(25, MOVE_SUPERPOWER),
    LEVEL_UP_MOVE(33, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(41, MOVE_IRON_DEFENSE),
    LEVEL_UP_MOVE(41, MOVE_AMNESIA),
    LEVEL_UP_MOVE(49, MOVE_ZAP_CANNON),
    LEVEL_UP_MOVE(57, MOVE_LOCK_ON),
    LEVEL_UP_MOVE(65, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gKyogreLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WATER_PULSE),
    LEVEL_UP_MOVE( 5, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(15, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(20, MOVE_BODY_SLAM),
    LEVEL_UP_MOVE(30, MOVE_CALM_MIND),
    LEVEL_UP_MOVE(35, MOVE_ICE_BEAM),
    LEVEL_UP_MOVE(45, MOVE_HYDRO_PUMP),
    LEVEL_UP_MOVE(50, MOVE_REST),
    LEVEL_UP_MOVE(60, MOVE_SHEER_COLD),
    LEVEL_UP_MOVE(65, MOVE_DOUBLE_EDGE),
    LEVEL_UP_MOVE(75, MOVE_WATER_SPOUT),
    LEVEL_UP_END
};

const u16 gGroudonLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_MUD_SHOT),
    LEVEL_UP_MOVE( 5, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(15, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(20, MOVE_SLASH),
    LEVEL_UP_MOVE(30, MOVE_BULK_UP),
    LEVEL_UP_MOVE(35, MOVE_EARTHQUAKE),
    LEVEL_UP_MOVE(45, MOVE_FIRE_BLAST),
    LEVEL_UP_MOVE(50, MOVE_REST),
    LEVEL_UP_MOVE(60, MOVE_FISSURE),
    LEVEL_UP_MOVE(65, MOVE_SOLAR_BEAM),
    LEVEL_UP_MOVE(75, MOVE_ERUPTION),
    LEVEL_UP_END
};

const u16 gRayquazaLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_TWISTER),
    LEVEL_UP_MOVE( 5, MOVE_SCARY_FACE),
    LEVEL_UP_MOVE(15, MOVE_ANCIENT_POWER),
    LEVEL_UP_MOVE(20, MOVE_DRAGON_CLAW),
    LEVEL_UP_MOVE(30, MOVE_DRAGON_DANCE),
    LEVEL_UP_MOVE(35, MOVE_CRUNCH),
    LEVEL_UP_MOVE(45, MOVE_FLY),
    LEVEL_UP_MOVE(50, MOVE_REST),
    LEVEL_UP_MOVE(60, MOVE_EXTREME_SPEED),
    LEVEL_UP_MOVE(65, MOVE_OUTRAGE),
    LEVEL_UP_MOVE(75, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gLatiasLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PSYWAVE),
    LEVEL_UP_MOVE( 5, MOVE_WISH),
    LEVEL_UP_MOVE(10, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(15, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(20, MOVE_DRAGON_BREATH),
    LEVEL_UP_MOVE(25, MOVE_WATER_SPORT),
    LEVEL_UP_MOVE(30, MOVE_REFRESH),
    LEVEL_UP_MOVE(35, MOVE_MIST_BALL),
    LEVEL_UP_MOVE(40, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(45, MOVE_RECOVER),
    LEVEL_UP_MOVE(50, MOVE_CHARM),
    LEVEL_UP_END
};

const u16 gLatiosLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_PSYWAVE),
    LEVEL_UP_MOVE( 5, MOVE_MEMENTO),
    LEVEL_UP_MOVE(10, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(15, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(20, MOVE_DRAGON_BREATH),
    LEVEL_UP_MOVE(25, MOVE_PROTECT),
    LEVEL_UP_MOVE(30, MOVE_REFRESH),
    LEVEL_UP_MOVE(35, MOVE_LUSTER_PURGE),
    LEVEL_UP_MOVE(40, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(45, MOVE_RECOVER),
    LEVEL_UP_MOVE(50, MOVE_DRAGON_DANCE),
    LEVEL_UP_END
};

const u16 gJirachiLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WISH),
    LEVEL_UP_MOVE( 1, MOVE_CONFUSION),
    LEVEL_UP_MOVE( 5, MOVE_REST),
    LEVEL_UP_MOVE(10, MOVE_SWIFT),
    LEVEL_UP_MOVE(15, MOVE_HELPING_HAND),
    LEVEL_UP_MOVE(20, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(25, MOVE_REFRESH),
    LEVEL_UP_MOVE(30, MOVE_REST),
    LEVEL_UP_MOVE(35, MOVE_DOUBLE_EDGE),
    LEVEL_UP_MOVE(40, MOVE_FUTURE_SIGHT),
    LEVEL_UP_MOVE(45, MOVE_COSMIC_POWER),
    LEVEL_UP_MOVE(50, MOVE_DOOM_DESIRE),
    LEVEL_UP_END
};

const u16 gDeoxysLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_LEER),
    LEVEL_UP_MOVE( 1, MOVE_WRAP),
    LEVEL_UP_MOVE( 5, MOVE_NIGHT_SHADE),
    LEVEL_UP_MOVE(10, MOVE_TELEPORT),
    LEVEL_UP_MOVE(15, MOVE_KNOCK_OFF),
    LEVEL_UP_MOVE(20, MOVE_PURSUIT),
    LEVEL_UP_MOVE(25, MOVE_PSYCHIC),
    LEVEL_UP_MOVE(30, MOVE_SNATCH),
    LEVEL_UP_MOVE(35, MOVE_COSMIC_POWER),
    LEVEL_UP_MOVE(40, MOVE_RECOVER),
    LEVEL_UP_MOVE(45, MOVE_PSYCHO_BOOST),
    LEVEL_UP_MOVE(50, MOVE_HYPER_BEAM),
    LEVEL_UP_END
};

const u16 gChimechoLevelUpLearnset[] = {
    LEVEL_UP_MOVE( 1, MOVE_WRAP),
    LEVEL_UP_MOVE( 6, MOVE_GROWL),
    LEVEL_UP_MOVE( 9, MOVE_ASTONISH),
    LEVEL_UP_MOVE(14, MOVE_CONFUSION),
    LEVEL_UP_MOVE(17, MOVE_TAKE_DOWN),
    LEVEL_UP_MOVE(22, MOVE_UPROAR),
    LEVEL_UP_MOVE(25, MOVE_YAWN),
    LEVEL_UP_MOVE(30, MOVE_PSYWAVE),
    LEVEL_UP_MOVE(33, MOVE_DOUBLE_EDGE),
    LEVEL_UP_MOVE(38, MOVE_HEAL_BELL),
    LEVEL_UP_MOVE(41, MOVE_SAFEGUARD),
    LEVEL_UP_MOVE(46, MOVE_PSYCHIC),
    LEVEL_UP_END
};

#endif //POKERUBY_LEVEL_UP_LEARNSETS_H
