#define GET_POINT_OFFSET_DL(bits)  (((bits) >> 0) & 1)
#define GET_POINT_COLOR_TYPE(bits) (((bits) >> 1) & 3)
#define GET_POINT_DELTA(bits)      (((bits) >> 3) & 7)

#define PT(x, y, delta, colorType, offsetDownLeft) x, y, (delta << 3) | (colorType << 1) | offsetDownLeft

static const u8 sPointillismPoints[][3] = {
    PT( 0, 29, 3, 2, FALSE),
    PT(14, 30, 3, 1,  TRUE),
    PT( 0,  1, 6, 1, FALSE),
    PT(46, 30, 6, 3,  TRUE),
    PT(10, 34, 3, 3,  TRUE),
    PT( 5, 38, 5, 3, FALSE),
    PT(18, 23, 3, 3, FALSE),
    PT(26,  3, 2, 0,  TRUE),
    PT( 5, 17, 3, 0, FALSE),
    PT( 5, 39, 5, 3,  TRUE),
    PT(26, 63, 2, 1, FALSE),
    PT(34, 63, 2, 3, FALSE),
    PT(43, 47, 5, 3, FALSE),
    PT(17,  2, 5, 2,  TRUE),
    PT(35, 13, 5, 0, FALSE),
    PT(23, 12, 3, 0,  TRUE),
    PT(47, 14, 2, 1,  TRUE),
    PT(48, 24, 4, 0, FALSE),
    PT(45, 40, 4, 1, FALSE),
    PT( 1,  3, 3, 0,  TRUE),
    PT(14, 42, 5, 1,  TRUE),
    PT(34, 21, 4, 2,  TRUE),
    PT(34, 10, 4, 3, FALSE),
    PT(57,  6, 4, 1,  TRUE),
    PT(22,  7, 5, 3,  TRUE),
    PT(34, 58, 3, 1,  TRUE),
    PT(59, 54, 6, 2,  TRUE),
    PT(10, 43, 4, 2, FALSE),
    PT(54,  9, 2, 1, FALSE),
    PT(28, 47, 4, 1,  TRUE),
    PT(46, 56, 5, 2, FALSE),
    PT( 5, 42, 4, 0, FALSE),
    PT( 7, 20, 6, 1, FALSE),
    PT(49,  8, 2, 3,  TRUE),
    PT(26, 36, 5, 2,  TRUE),
    PT(34, 10, 2, 3, FALSE),
    PT(27, 38, 5, 1,  TRUE),
    PT(41, 22, 2, 0,  TRUE),
    PT(53,  8, 2, 2, FALSE),
    PT(30,  8, 2, 2, FALSE),
    PT( 5, 49, 2, 2, FALSE),
    PT(56, 49, 2, 3,  TRUE),
    PT(52, 51, 2, 1, FALSE),
    PT(17,  9, 3, 3,  TRUE),
    PT(40, 61, 6, 1, FALSE),
    PT(53,  3, 3, 3, FALSE),
    PT(60, 43, 5, 3, FALSE),
    PT(16,  1, 2, 3,  TRUE),
    PT( 3, 62, 4, 1, FALSE),
    PT(23, 24, 6, 2, FALSE),
    PT( 8, 41, 3, 0,  TRUE),
    PT( 3, 36, 5, 0, FALSE),
    PT(61, 51, 5, 3,  TRUE),
    PT(49, 36, 3, 0,  TRUE),
    PT(27, 24, 4, 3, FALSE),
    PT( 7, 13, 4, 2,  TRUE),
    PT(45, 63, 2, 1, FALSE),
    PT(47, 21, 4, 2,  TRUE),
    PT(41, 15, 2, 1, FALSE),
    PT( 7, 44, 2, 1, FALSE),
    PT(44, 11, 4, 3, FALSE),
    PT(18, 26, 2, 3, FALSE),
    PT( 0, 11, 5, 3,  TRUE),
    PT(22, 53, 4, 2, FALSE),
    PT(31, 28, 4, 1, FALSE),
    PT(41, 51, 4, 3,  TRUE),
    PT(59, 48, 2, 3,  TRUE),
    PT(17,  6, 6, 2,  TRUE),
    PT(62, 49, 5, 3,  TRUE),
    PT(17, 58, 4, 2,  TRUE),
    PT(42,  2, 3, 0,  TRUE),
    PT(51, 24, 6, 2,  TRUE),
    PT(42, 32, 4, 0,  TRUE),
    PT(46, 50, 3, 1,  TRUE),
    PT(59, 31, 4, 1,  TRUE),
    PT(57, 41, 5, 1, FALSE),
    PT(46, 49, 5, 0,  TRUE),
    PT(42, 14, 5, 2,  TRUE),
    PT(45,  0, 3, 3,  TRUE),
    PT(56, 40, 3, 1,  TRUE),
    PT(20, 59, 5, 1,  TRUE),
    PT(46,  4, 4, 3, FALSE),
    PT(54, 48, 2, 0,  TRUE),
    PT(59, 33, 5, 2,  TRUE),
    PT(43, 63, 3, 1,  TRUE),
    PT(32, 19, 6, 0,  TRUE),
    PT(51, 12, 6, 0, FALSE),
    PT(34, 43, 5, 1,  TRUE),
    PT(22,  2, 3, 3, FALSE),
    PT(28, 18, 3, 2, FALSE),
    PT(15, 60, 6, 3, FALSE),
    PT(56, 16, 5, 2,  TRUE),
    PT(24, 47, 5, 2,  TRUE),
    PT(53, 59, 2, 0,  TRUE),
    PT(55, 49, 2, 1,  TRUE),
    PT(19, 61, 5, 3,  TRUE),
    PT(30, 44, 6, 1,  TRUE),
    PT(46, 55, 2, 1, FALSE),
    PT(60, 31, 6, 1,  TRUE),
    PT(50, 42, 4, 3,  TRUE),
    PT(13, 59, 3, 2, FALSE),
    PT(53, 42, 4, 3,  TRUE),
    PT( 9, 61, 4, 3,  TRUE),
    PT(18, 11, 3, 0, FALSE),
    PT(12, 21, 3, 2,  TRUE),
    PT(32,  1, 3, 2, FALSE),
    PT( 8, 59, 3, 2, FALSE),
    PT(18, 55, 6, 1,  TRUE),
    PT(21,  3, 5, 2, FALSE),
    PT(42, 59, 6, 0,  TRUE),
    PT(15,  4, 6, 2,  TRUE),
    PT( 8, 23, 6, 1,  TRUE),
    PT(56, 61, 5, 1, FALSE),
    PT(47, 53, 2, 3, FALSE),
    PT(16, 53, 2, 3, FALSE),
    PT(35, 19, 5, 2, FALSE),
    PT(47,  6, 4, 0, FALSE),
    PT(39, 58, 4, 2, FALSE),
    PT( 0, 28, 5, 1, FALSE),
    PT( 3, 57, 3, 2,  TRUE),
    PT(40,  7, 3, 1, FALSE),
    PT(32, 10, 6, 3,  TRUE),
    PT( 7, 53, 5, 2,  TRUE),
    PT(21, 47, 5, 2, FALSE),
    PT(16, 44, 4, 1,  TRUE),
    PT(63, 41, 2, 2, FALSE),
    PT(42, 33, 6, 3, FALSE),
    PT(52, 26, 5, 2, FALSE),
    PT(28, 61, 6, 1,  TRUE),
    PT(56, 43, 4, 1, FALSE),
    PT(53, 40, 3, 3,  TRUE),
    PT(61, 15, 3, 2, FALSE),
    PT(30, 62, 3, 1,  TRUE),
    PT(12, 62, 3, 3,  TRUE),
    PT(43, 49, 5, 2, FALSE),
    PT(50, 57, 2, 0,  TRUE),
    PT( 5,  9, 2, 0,  TRUE),
    PT( 4, 56, 5, 1, FALSE),
    PT(50,  0, 2, 3, FALSE),
    PT(19, 11, 6, 0,  TRUE),
    PT(52, 42, 2, 1,  TRUE),
    PT(44, 34, 4, 0,  TRUE),
    PT(57, 47, 2, 2,  TRUE),
    PT(55, 40, 3, 3, FALSE),
    PT( 7, 59, 5, 2,  TRUE),
    PT(17,  3, 5, 0, FALSE),
    PT(45, 48, 3, 3, FALSE),
    PT(49, 17, 2, 0,  TRUE),
    PT(35,  1, 3, 3, FALSE),
    PT(61, 49, 6, 2, FALSE),
    PT(28,  2, 6, 2, FALSE),
    PT(33, 14, 4, 2,  TRUE),
    PT(61,  7, 2, 3,  TRUE),
    PT(51, 21, 2, 0, FALSE),
    PT(41, 50, 6, 1, FALSE),
    PT(24, 31, 6, 0, FALSE),
    PT(45, 59, 6, 0, FALSE),
    PT(39, 62, 2, 3, FALSE),
    PT(49, 21, 2, 1, FALSE),
    PT(48, 37, 2, 3,  TRUE),
    PT(51,  6, 6, 2, FALSE),
    PT( 0, 41, 3, 0, FALSE),
    PT(60,  3, 2, 1, FALSE),
    PT(44, 12, 2, 0,  TRUE),
    PT( 9, 48, 6, 0, FALSE),
    PT(16, 14, 2, 0,  TRUE),
    PT(39, 22, 3, 1,  TRUE),
    PT(12, 59, 5, 3, FALSE),
    PT(43, 51, 3, 3, FALSE),
    PT(19, 45, 5, 2,  TRUE),
    PT(17, 36, 5, 0,  TRUE),
    PT(52, 62, 5, 1,  TRUE),
    PT(36, 30, 4, 0,  TRUE),
    PT(39, 26, 5, 2,  TRUE),
    PT( 4, 57, 2, 3, FALSE),
    PT(62, 51, 4, 3, FALSE),
    PT(27, 46, 4, 2,  TRUE),
    PT(12,  6, 3, 0,  TRUE),
    PT(37, 25, 3, 0, FALSE),
    PT(29, 51, 6, 1,  TRUE),
    PT(29, 40, 5, 2,  TRUE),
    PT(28, 16, 5, 1, FALSE),
    PT(31, 53, 3, 3, FALSE),
    PT(52,  2, 2, 0, FALSE),
    PT(43, 58, 2, 2, FALSE),
    PT(13, 11, 2, 2,  TRUE),
    PT(12, 44, 2, 0, FALSE),
    PT(55, 58, 3, 0,  TRUE),
    PT( 6, 19, 2, 3,  TRUE),
    PT(36, 16, 4, 2,  TRUE),
    PT(36,  4, 3, 3, FALSE),
    PT( 0, 53, 6, 2, FALSE),
    PT(58,  0, 6, 3,  TRUE),
    PT(60,  7, 3, 1, FALSE),
    PT(43, 40, 6, 3, FALSE),
    PT(52, 57, 5, 3,  TRUE),
    PT(40,  9, 3, 3,  TRUE),
    PT(56, 49, 6, 0, FALSE),
    PT(22, 37, 6, 0,  TRUE),
    PT(24, 40, 6, 0,  TRUE),
    PT(24, 12, 4, 1, FALSE),
    PT( 6, 57, 5, 2,  TRUE),
    PT(61, 32, 4, 2, FALSE),
    PT(46, 39, 4, 0,  TRUE),
    PT(62, 24, 3, 0, FALSE),
    PT(21, 60, 4, 2, FALSE),
    PT( 6, 27, 4, 3, FALSE),
    PT(21, 14, 4, 1, FALSE),
    PT(10, 13, 3, 3,  TRUE),
    PT(24, 22, 6, 2, FALSE),
    PT(16, 40, 4, 0,  TRUE),
    PT(32, 17, 2, 0,  TRUE),
    PT(54, 50, 2, 2,  TRUE),
    PT(59, 46, 4, 2, FALSE),
    PT(31, 45, 2, 1, FALSE),
    PT(54, 46, 4, 0, FALSE),
    PT(11, 23, 6, 1,  TRUE),
    PT(38,  3, 3, 3,  TRUE),
    PT( 8, 25, 6, 0,  TRUE),
    PT(42, 24, 4, 2,  TRUE),
    PT(53, 45, 5, 2,  TRUE),
    PT(48, 56, 3, 0, FALSE),
    PT(28, 37, 2, 2, FALSE),
    PT(28, 34, 5, 0, FALSE),
    PT( 8, 35, 4, 0,  TRUE),
    PT(38, 30, 6, 0, FALSE),
    PT(25, 15, 2, 2,  TRUE),
    PT(16, 47, 4, 1, FALSE),
    PT(18,  2, 4, 2,  TRUE),
    PT(60,  1, 3, 2,  TRUE),
    PT(14, 20, 3, 0, FALSE),
    PT(13, 24, 2, 3,  TRUE),
    PT(34, 11, 6, 0,  TRUE),
    PT(19, 52, 4, 0,  TRUE),
    PT(15, 45, 6, 3, FALSE),
    PT(57, 31, 4, 2,  TRUE),
    PT(24, 16, 3, 3,  TRUE),
    PT(45, 32, 4, 0, FALSE),
    PT(25, 11, 6, 0,  TRUE),
    PT(51, 19, 2, 2, FALSE),
    PT(46, 17, 4, 0,  TRUE),
    PT(45, 10, 6, 3,  TRUE),
    PT( 7, 21, 3, 1,  TRUE),
    PT(50,  4, 6, 1, FALSE),
    PT( 6, 24, 3, 1,  TRUE),
    PT(19, 36, 2, 1, FALSE),
    PT(54, 34, 2, 3, FALSE),
    PT(29, 41, 3, 2, FALSE),
    PT(53, 23, 4, 0,  TRUE),
    PT(54, 23, 5, 1,  TRUE),
    PT(53, 50, 3, 0,  TRUE),
    PT(42, 15, 5, 3, FALSE),
    PT(16,  0, 6, 2, FALSE),
    PT( 2, 14, 5, 0, FALSE),
    PT(49, 50, 6, 1, FALSE),
    PT(59,  5, 4, 0, FALSE),
    PT(54, 38, 2, 1, FALSE),
    PT(52,  6, 6, 2, FALSE),
    PT(30, 49, 6, 1, FALSE),
    PT(53,  5, 6, 2, FALSE),
    PT(30, 19, 2, 2,  TRUE),
    PT(21, 20, 5, 2, FALSE),
    PT(41, 28, 3, 0, FALSE),
    PT(36, 36, 2, 1, FALSE),
    PT(34, 41, 3, 0, FALSE),
    PT(52, 54, 6, 0, FALSE),
    PT(30,  1, 4, 1,  TRUE),
    PT(12, 60, 4, 2, FALSE),
    PT(10, 61, 2, 3, FALSE),
    PT(39, 30, 4, 1,  TRUE),
    PT(21,  2, 2, 1, FALSE),
    PT(17, 25, 5, 1, FALSE),
    PT(29, 49, 2, 2,  TRUE),
    PT( 3, 59, 5, 1, FALSE),
    PT(33, 25, 5, 2, FALSE),
    PT(10, 35, 2, 0,  TRUE),
    PT(37, 17, 3, 1, FALSE),
    PT(26, 10, 6, 2, FALSE),
    PT(59, 11, 6, 1,  TRUE),
    PT(33, 11, 6, 3,  TRUE),
    PT( 1, 49, 5, 0, FALSE),
    PT(53, 29, 4, 3,  TRUE),
    PT(44, 48, 6, 0,  TRUE),
    PT(46, 57, 5, 2,  TRUE),
    PT(48,  5, 5, 2, FALSE),
    PT(18, 42, 5, 1,  TRUE),
    PT(57, 34, 4, 0, FALSE),
    PT(21, 52, 3, 2, FALSE),
    PT(28,  1, 2, 2,  TRUE),
    PT(32, 22, 4, 1, FALSE),
    PT(19,  4, 3, 0, FALSE),
    PT(30, 19, 2, 0, FALSE),
    PT(37, 51, 2, 2,  TRUE),
    PT(57,  3, 6, 0,  TRUE),
    PT(63, 54, 3, 0, FALSE),
    PT(20, 35, 2, 0, FALSE),
    PT(47, 30, 3, 3,  TRUE),
    PT(31, 23, 5, 2, FALSE),
    PT( 2, 22, 6, 0,  TRUE),
    PT(32, 24, 6, 0, FALSE),
    PT(46, 24, 6, 3,  TRUE),
    PT(59, 14, 6, 0, FALSE),
    PT(16, 57, 4, 2, FALSE),
    PT(38, 57, 3, 3, FALSE),
    PT(48, 38, 5, 3, FALSE),
    PT(18,  1, 2, 2, FALSE),
    PT(55, 42, 5, 3, FALSE),
    PT(33,  6, 3, 2,  TRUE),
    PT(42, 22, 6, 1, FALSE),
    PT( 9, 56, 3, 2, FALSE),
    PT( 7, 34, 2, 3,  TRUE),
    PT(59, 45, 2, 2,  TRUE),
    PT( 7, 30, 5, 3, FALSE),
    PT(27, 46, 3, 2,  TRUE),
    PT( 4,  9, 6, 0, FALSE),
    PT(48, 45, 6, 3,  TRUE),
    PT(45, 52, 4, 2, FALSE),
    PT(24, 36, 4, 2,  TRUE),
    PT(14, 45, 4, 3, FALSE),
    PT(35, 10, 2, 3, FALSE),
    PT(18, 45, 2, 0,  TRUE),
    PT(33, 40, 5, 3, FALSE),
    PT(15,  1, 4, 0,  TRUE),
    PT( 1, 49, 2, 1, FALSE),
    PT(63, 27, 3, 3, FALSE),
    PT(33, 37, 5, 1,  TRUE),
    PT(38, 24, 2, 1,  TRUE),
    PT(21, 45, 6, 2, FALSE),
    PT(35, 33, 6, 3, FALSE),
    PT(14, 46, 3, 2, FALSE),
    PT(20, 34, 3, 2, FALSE),
    PT(44, 11, 5, 0, FALSE),
    PT(26, 24, 4, 0,  TRUE),
    PT(33,  7, 3, 1, FALSE),
    PT(36, 38, 5, 0,  TRUE),
    PT(43, 10, 6, 2, FALSE),
    PT(62, 39, 6, 1,  TRUE),
    PT(18, 52, 3, 1,  TRUE),
    PT(31,  1, 5, 1, FALSE),
    PT(46,  6, 4, 1,  TRUE),
    PT(47, 31, 2, 2, FALSE),
    PT(24,  6, 4, 3, FALSE),
    PT(49, 31, 5, 1,  TRUE),
    PT(34, 38, 5, 3, FALSE),
    PT(30, 21, 2, 3, FALSE),
    PT(32, 34, 5, 0, FALSE),
    PT(21, 55, 2, 1, FALSE),
    PT(37,  4, 5, 2, FALSE),
    PT(31,  4, 5, 3, FALSE),
    PT(12, 19, 3, 0, FALSE),
    PT( 7, 11, 6, 3, FALSE),
    PT(29, 28, 5, 1, FALSE),
    PT(48, 34, 3, 2, FALSE),
    PT(46, 18, 5, 3,  TRUE),
    PT(43, 33, 3, 3, FALSE),
    PT(22, 56, 6, 0, FALSE),
    PT( 4,  2, 2, 3, FALSE),
    PT( 5, 20, 4, 0, FALSE),
    PT(56, 60, 6, 1,  TRUE),
    PT(33, 27, 5, 3,  TRUE),
    PT(20, 42, 4, 3,  TRUE),
    PT(56, 20, 3, 1,  TRUE),
    PT(43, 31, 5, 1,  TRUE),
    PT(41, 43, 4, 2,  TRUE),
    PT(39, 54, 4, 0,  TRUE),
    PT(17, 34, 3, 1,  TRUE),
    PT(41,  3, 3, 1,  TRUE),
    PT(24, 36, 5, 0, FALSE),
    PT(33, 45, 6, 3, FALSE),
    PT(60, 44, 4, 2, FALSE),
    PT(51, 23, 3, 3,  TRUE),
    PT(42, 58, 4, 0,  TRUE),
    PT(10, 35, 6, 3,  TRUE),
    PT( 0, 11, 4, 0,  TRUE),
    PT(17, 56, 3, 0,  TRUE),
    PT(15, 14, 3, 2, FALSE),
    PT(31, 15, 6, 3,  TRUE),
    PT(60, 16, 6, 3,  TRUE),
    PT(56, 49, 6, 2,  TRUE),
    PT( 7, 21, 5, 0, FALSE),
    PT(30, 46, 3, 0,  TRUE),
    PT(38, 16, 6, 1,  TRUE),
    PT(61, 53, 5, 3,  TRUE),
    PT(58,  4, 6, 2, FALSE),
    PT(13, 24, 3, 1, FALSE),
    PT( 1, 45, 2, 2,  TRUE),
    PT(61, 26, 2, 3,  TRUE),
    PT(23, 63, 6, 1, FALSE),
    PT(11, 33, 2, 0,  TRUE),
    PT(30, 38, 5, 1,  TRUE),
    PT(13, 25, 4, 2, FALSE),
    PT(46,  4, 3, 1,  TRUE),
    PT(27, 51, 4, 0, FALSE),
    PT(21, 33, 3, 2,  TRUE),
    PT(31,  4, 4, 0,  TRUE),
    PT(15, 18, 3, 3,  TRUE),
    PT(45, 42, 6, 1, FALSE),
    PT( 3, 55, 3, 3,  TRUE),
    PT(53,  7, 4, 3,  TRUE),
    PT(36, 31, 6, 0,  TRUE),
    PT(47, 48, 2, 2,  TRUE),
    PT( 6,  0, 4, 2, FALSE),
    PT(11, 34, 3, 1, FALSE),
    PT(12, 59, 5, 0,  TRUE),
    PT(20, 26, 2, 3,  TRUE),
    PT(55, 32, 4, 2,  TRUE),
    PT(63, 38, 6, 3,  TRUE),
    PT(58, 62, 2, 0, FALSE),
    PT(34,  4, 2, 0,  TRUE),
    PT(40, 18, 3, 2, FALSE),
    PT( 3, 46, 5, 3, FALSE),
    PT(14, 56, 5, 0, FALSE),
    PT( 1, 41, 4, 1, FALSE),
    PT(30, 51, 3, 0,  TRUE),
    PT( 6, 33, 4, 3,  TRUE),
    PT(51, 25, 3, 1, FALSE),
    PT( 2,  5, 2, 3,  TRUE),
    PT(17, 17, 5, 2, FALSE),
    PT(31, 38, 3, 3, FALSE),
    PT(57, 31, 5, 0, FALSE),
    PT(46, 47, 2, 1, FALSE),
    PT(34, 52, 2, 1,  TRUE),
    PT(59, 38, 5, 3,  TRUE),
    PT(52,  0, 2, 2, FALSE),
    PT(16, 49, 2, 0,  TRUE),
    PT(29, 45, 5, 1, FALSE),
    PT( 8,  8, 6, 3,  TRUE),
    PT(21, 24, 6, 2, FALSE),
    PT( 4, 43, 4, 2, FALSE),
    PT(47, 30, 4, 3,  TRUE),
    PT(34, 42, 4, 2, FALSE),
    PT( 7, 20, 4, 2,  TRUE),
    PT( 1, 39, 3, 0,  TRUE),
    PT(41, 10, 5, 0,  TRUE),
    PT(61, 28, 5, 3,  TRUE),
    PT(13, 31, 3, 2, FALSE),
    PT(36, 61, 6, 1, FALSE),
    PT(54, 29, 4, 2, FALSE),
    PT(20, 33, 2, 3, FALSE),
    PT(26, 13, 5, 0,  TRUE),
    PT(63, 43, 5, 1, FALSE),
    PT(26, 62, 6, 2,  TRUE),
    PT(17, 40, 3, 0, FALSE),
    PT(50,  5, 2, 2,  TRUE),
    PT(33, 46, 6, 2, FALSE),
    PT(45, 20, 5, 1, FALSE),
    PT(60,  8, 6, 3,  TRUE),
    PT(63, 52, 3, 3, FALSE),
    PT(39, 36, 3, 2, FALSE),
    PT(22, 22, 6, 1,  TRUE),
    PT(41, 59, 3, 0,  TRUE),
    PT(54, 47, 3, 2, FALSE),
    PT( 3, 37, 5, 2, FALSE),
    PT(11, 22, 6, 3, FALSE),
    PT(28, 29, 3, 1,  TRUE),
    PT(44, 39, 3, 1,  TRUE),
    PT(11, 31, 5, 1,  TRUE),
    PT( 8, 16, 4, 3,  TRUE),
    PT(63, 37, 5, 3,  TRUE),
    PT(51, 19, 3, 3,  TRUE),
    PT( 4, 49, 6, 3,  TRUE),
    PT(14, 47, 2, 1, FALSE),
    PT( 8, 35, 4, 0, FALSE),
    PT(58, 26, 3, 3, FALSE),
    PT(47, 11, 3, 3,  TRUE),
    PT(30, 32, 3, 0,  TRUE),
    PT(35, 59, 2, 2, FALSE),
    PT(37,  0, 4, 3,  TRUE),
    PT(20,  4, 4, 2,  TRUE),
    PT(54, 26, 5, 1,  TRUE),
    PT(39, 33, 2, 2,  TRUE),
    PT(40, 19, 5, 2, FALSE),
    PT(14, 60, 6, 2,  TRUE),
    PT(12, 45, 5, 1,  TRUE),
    PT(55, 22, 2, 2,  TRUE),
    PT(41, 21, 3, 2,  TRUE),
    PT(23, 52, 6, 3, FALSE),
    PT( 9, 10, 6, 0,  TRUE),
    PT(55, 34, 5, 0, FALSE),
    PT(23, 43, 6, 2,  TRUE),
    PT(20, 43, 2, 1, FALSE),
    PT( 8, 19, 3, 3,  TRUE),
    PT(49, 19, 5, 0, FALSE),
    PT( 6,  7, 6, 2,  TRUE),
    PT(35, 58, 5, 0,  TRUE),
    PT(15, 36, 5, 3, FALSE),
    PT( 7, 53, 4, 3, FALSE),
    PT(14, 18, 2, 2,  TRUE),
    PT(35, 51, 5, 2, FALSE),
    PT(14, 33, 4, 3, FALSE),
    PT(28, 18, 4, 2,  TRUE),
    PT(35, 29, 5, 3,  TRUE),
    PT( 4, 53, 6, 1,  TRUE),
    PT(22,  1, 4, 2, FALSE),
    PT(61, 44, 5, 3, FALSE),
    PT(53, 10, 4, 2,  TRUE),
    PT(17, 19, 4, 2,  TRUE),
    PT(27, 27, 2, 2,  TRUE),
    PT(21, 57, 2, 0, FALSE),
    PT(11, 53, 4, 2, FALSE),
    PT(58, 39, 6, 0, FALSE),
    PT(46, 47, 2, 2,  TRUE),
    PT(16, 31, 6, 2,  TRUE),
    PT(27, 40, 6, 2,  TRUE),
    PT(38, 48, 6, 3,  TRUE),
    PT(52, 55, 5, 1,  TRUE),
    PT(15, 48, 5, 0,  TRUE),
    PT(46, 63, 5, 1,  TRUE),
    PT(56, 52, 5, 1,  TRUE),
    PT(43, 47, 4, 2,  TRUE),
    PT(13, 40, 5, 1, FALSE),
    PT(51, 24, 2, 0, FALSE),
    PT(33, 18, 2, 0,  TRUE),
    PT(31, 34, 6, 2, FALSE),
    PT(17, 37, 4, 1,  TRUE),
    PT(33, 63, 2, 0,  TRUE),
    PT(38, 39, 4, 2,  TRUE),
    PT(40, 54, 2, 1, FALSE),
    PT(21, 38, 6, 1, FALSE),
    PT(17, 24, 4, 2, FALSE),
    PT(50, 37, 6, 3,  TRUE),
    PT(39, 58, 6, 1,  TRUE),
    PT(53,  7, 3, 2, FALSE),
    PT(26, 14, 5, 1, FALSE),
    PT(30, 47, 3, 3,  TRUE),
    PT( 0, 46, 4, 0,  TRUE),
    PT(27, 60, 2, 2, FALSE),
    PT(47, 58, 5, 3,  TRUE),
    PT(62, 56, 2, 2,  TRUE),
    PT(26, 19, 5, 3,  TRUE),
    PT(41, 13, 5, 3,  TRUE),
    PT(55, 23, 3, 0, FALSE),
    PT(48, 28, 6, 2,  TRUE),
    PT(21, 52, 2, 2, FALSE),
    PT(40, 17, 5, 2, FALSE),
    PT(44, 37, 5, 1, FALSE),
    PT(32, 63, 5, 0, FALSE),
    PT(12, 52, 3, 1,  TRUE),
    PT(48, 46, 4, 2,  TRUE),
    PT(55, 28, 4, 2, FALSE),
    PT(31, 37, 4, 3, FALSE),
    PT(12, 25, 6, 2, FALSE),
    PT(24, 16, 6, 2,  TRUE),
    PT(10, 19, 2, 0,  TRUE),
    PT(37, 19, 4, 0, FALSE),
    PT(19, 25, 2, 0,  TRUE),
    PT(32, 40, 3, 2,  TRUE),
    PT(62, 48, 3, 1,  TRUE),
    PT(35, 36, 4, 0,  TRUE),
    PT(13, 35, 4, 1,  TRUE),
    PT(29, 40, 5, 3, FALSE),
    PT(45, 18, 3, 3,  TRUE),
    PT(14, 46, 5, 1,  TRUE),
    PT(11, 49, 6, 1, FALSE),
    PT(36, 60, 5, 2, FALSE),
    PT(19, 60, 2, 1, FALSE),
    PT(40, 22, 5, 1, FALSE),
    PT( 5, 12, 6, 1, FALSE),
    PT(57, 11, 6, 1, FALSE),
    PT(33,  4, 2, 2, FALSE),
    PT(16, 49, 6, 1, FALSE),
    PT(18, 31, 4, 1,  TRUE),
    PT(57, 46, 5, 3, FALSE),
    PT(34, 61, 4, 3,  TRUE),
    PT(12, 30, 3, 0, FALSE),
    PT(37,  0, 2, 3,  TRUE),
    PT( 6, 49, 2, 2, FALSE),
    PT(19, 33, 3, 1, FALSE),
    PT(20, 32, 6, 2,  TRUE),
    PT(10, 59, 4, 2,  TRUE),
    PT(51,  8, 5, 0, FALSE),
    PT(61,  2, 6, 1,  TRUE),
    PT(35,  0, 2, 1,  TRUE),
    PT(34, 33, 5, 0, FALSE),
    PT(48, 20, 5, 3, FALSE),
    PT(20, 50, 6, 3, FALSE),
    PT(57, 35, 3, 3, FALSE),
    PT(28, 17, 6, 0, FALSE),
    PT(55, 22, 6, 0, FALSE),
    PT(21, 49, 3, 3,  TRUE),
    PT(52, 40, 5, 2, FALSE),
    PT(53,  5, 5, 0,  TRUE),
    PT(55, 51, 5, 1, FALSE),
    PT(28, 23, 5, 3, FALSE),
    PT(16,  6, 2, 3, FALSE),
    PT(50, 31, 5, 3,  TRUE),
    PT( 0, 41, 3, 3, FALSE),
    PT( 4,  1, 2, 3, FALSE),
    PT(59, 35, 3, 3, FALSE),
    PT(27, 52, 5, 1, FALSE),
    PT(48, 17, 5, 1,  TRUE),
    PT( 3,  0, 3, 3,  TRUE),
    PT(29, 55, 3, 1, FALSE),
    PT(58, 24, 4, 2,  TRUE),
    PT(28, 22, 5, 2, FALSE),
    PT( 4, 63, 6, 1,  TRUE),
    PT(38, 35, 5, 2,  TRUE),
    PT(21, 44, 4, 3,  TRUE),
    PT( 2, 53, 4, 3,  TRUE),
    PT( 7, 53, 6, 1,  TRUE),
    PT(26, 12, 2, 0, FALSE),
    PT(40, 38, 5, 2, FALSE),
    PT(47, 54, 2, 3, FALSE),
    PT(55, 11, 4, 3,  TRUE),
    PT(27, 61, 3, 0, FALSE),
    PT(39, 31, 4, 0, FALSE),
    PT(43, 42, 6, 1,  TRUE),
    PT(11, 15, 4, 0, FALSE),
    PT(53, 60, 5, 3,  TRUE),
    PT(51, 33, 2, 2,  TRUE),
    PT(45, 38, 6, 2, FALSE),
    PT(31, 26, 4, 0,  TRUE),
    PT(47, 44, 5, 1, FALSE),
    PT(26, 50, 3, 1, FALSE),
    PT(59, 63, 4, 0,  TRUE),
    PT(19, 63, 2, 1,  TRUE),
    PT(15, 36, 4, 1, FALSE),
    PT(20, 27, 2, 0, FALSE),
    PT(33,  6, 5, 0, FALSE),
    PT(37, 52, 2, 0, FALSE),
    PT(46, 14, 2, 2, FALSE),
    PT(60, 62, 4, 2,  TRUE),
    PT(22,  6, 6, 0, FALSE),
    PT(11,  4, 3, 3,  TRUE),
    PT(62,  2, 4, 2, FALSE),
    PT(12, 23, 4, 2,  TRUE),
    PT(43, 60, 5, 2,  TRUE),
    PT(21, 54, 6, 1,  TRUE),
    PT(24, 35, 5, 1, FALSE),
    PT(29, 16, 5, 1, FALSE),
    PT(53, 23, 5, 0, FALSE),
    PT( 0, 55, 4, 2, FALSE),
    PT(10, 59, 2, 2,  TRUE),
    PT(29, 11, 3, 3,  TRUE),
    PT(60, 49, 4, 2,  TRUE),
    PT(29, 15, 3, 2,  TRUE),
    PT(32, 19, 6, 2, FALSE),
    PT(17, 43, 5, 3, FALSE),
    PT(35, 12, 5, 3, FALSE),
    PT(36,  2, 2, 2, FALSE),
    PT(49, 22, 3, 0,  TRUE),
    PT(14, 35, 6, 2,  TRUE),
    PT(26, 16, 2, 3, FALSE),
    PT(20,  4, 3, 0,  TRUE),
    PT(45, 39, 6, 3,  TRUE),
    PT(51,  2, 6, 0,  TRUE),
    PT( 2,  4, 2, 3, FALSE),
    PT(13, 34, 4, 2,  TRUE),
    PT(37,  0, 2, 3, FALSE),
    PT(42, 63, 4, 3, FALSE),
    PT(32, 12, 2, 1, FALSE),
    PT(47, 46, 6, 2,  TRUE),
    PT(27, 13, 4, 1, FALSE),
    PT(30,  1, 6, 2, FALSE),
    PT( 5, 34, 4, 0,  TRUE),
    PT(52, 42, 6, 1, FALSE),
    PT(11,  9, 3, 2,  TRUE),
    PT(63, 50, 5, 3,  TRUE),
    PT(61, 24, 5, 2,  TRUE),
    PT(11, 56, 6, 3, FALSE),
    PT(57, 23, 5, 0, FALSE),
    PT(52,  4, 4, 2, FALSE),
    PT(54, 14, 5, 1, FALSE),
    PT(56,  1, 2, 2, FALSE),
    PT(60, 36, 4, 1, FALSE),
    PT(33,  3, 3, 0, FALSE),
    PT(50, 47, 2, 1, FALSE),
    PT(41, 36, 6, 0,  TRUE),
    PT(10, 59, 2, 1, FALSE),
    PT(26, 28, 4, 0, FALSE),
    PT(48, 49, 3, 1,  TRUE),
    PT(26, 33, 2, 0, FALSE),
    PT( 5, 41, 2, 0, FALSE),
    PT(38, 45, 2, 1,  TRUE),
    PT(22, 12, 3, 2,  TRUE),
    PT(43,  6, 3, 1,  TRUE),
    PT( 6, 18, 2, 2, FALSE),
    PT(56, 15, 6, 2,  TRUE),
    PT(35, 58, 5, 2, FALSE),
    PT( 0, 25, 6, 1,  TRUE),
    PT(41, 20, 5, 2,  TRUE),
    PT(42, 33, 5, 0,  TRUE),
    PT(20, 49, 2, 2, FALSE),
    PT(26,  6, 3, 3, FALSE),
    PT(24, 27, 5, 0, FALSE),
    PT(59, 22, 5, 0,  TRUE),
    PT(21, 30, 2, 1, FALSE),
    PT(52, 10, 2, 2, FALSE),
    PT(27,  5, 4, 3,  TRUE),
    PT(11,  1, 4, 3, FALSE),
    PT(42, 34, 6, 2,  TRUE),
    PT(33, 32, 3, 0, FALSE),
    PT(32, 55, 2, 3,  TRUE),
    PT(20, 31, 2, 0,  TRUE),
    PT(29, 17, 4, 2,  TRUE),
    PT(36, 43, 5, 3,  TRUE),
    PT( 7, 63, 3, 3,  TRUE),
    PT(44, 37, 4, 2,  TRUE),
    PT(42, 41, 3, 0, FALSE),
    PT(17, 36, 5, 0, FALSE),
    PT(49, 44, 5, 1, FALSE),
    PT(57, 11, 4, 3, FALSE),
    PT(40, 16, 4, 3, FALSE),
    PT(34,  6, 2, 3, FALSE),
    PT( 9, 44, 2, 1,  TRUE),
    PT(52, 25, 2, 2,  TRUE),
    PT(58, 18, 4, 0,  TRUE),
    PT(29, 56, 4, 1,  TRUE),
    PT(18, 37, 4, 2, FALSE),
    PT(33, 48, 2, 1, FALSE),
    PT(55, 26, 2, 1, FALSE),
    PT(36, 59, 4, 2,  TRUE),
    PT(50, 21, 4, 1,  TRUE),
    PT(13, 26, 2, 0, FALSE),
    PT(22, 46, 4, 3, FALSE),
    PT(29, 20, 2, 3, FALSE),
    PT(62, 46, 3, 3,  TRUE),
    PT(10, 22, 2, 0, FALSE),
    PT(29, 48, 5, 1,  TRUE),
    PT( 4, 58, 3, 0,  TRUE),
    PT( 8, 45, 5, 3, FALSE),
    PT(40, 30, 6, 1,  TRUE),
    PT(10, 18, 5, 3, FALSE),
    PT(13,  3, 5, 3,  TRUE),
    PT(38, 58, 3, 3, FALSE),
    PT(53, 59, 5, 1, FALSE),
    PT( 3, 26, 3, 0, FALSE),
    PT(63, 11, 4, 3,  TRUE),
    PT( 4,  5, 6, 2, FALSE),
    PT(54, 11, 4, 3,  TRUE),
    PT(59, 23, 2, 0,  TRUE),
    PT(13, 39, 4, 3, FALSE),
    PT(44, 31, 4, 0, FALSE),
    PT(38, 16, 4, 0, FALSE),
    PT(37, 35, 5, 2,  TRUE),
    PT(55,  9, 2, 1,  TRUE),
    PT(20, 23, 5, 2,  TRUE),
    PT(46, 61, 4, 1,  TRUE),
    PT(29, 26, 3, 3,  TRUE),
    PT(33, 51, 5, 3, FALSE),
    PT(40, 23, 2, 1,  TRUE),
    PT(38, 60, 6, 3, FALSE),
    PT(20, 26, 6, 1,  TRUE),
    PT(50, 32, 5, 1,  TRUE),
    PT(25, 62, 4, 0, FALSE),
    PT(12,  2, 5, 2,  TRUE),
    PT(60, 60, 5, 1, FALSE),
    PT(48, 48, 5, 0, FALSE),
    PT(37, 63, 3, 3, FALSE),
    PT( 3, 23, 3, 3, FALSE),
    PT(53, 17, 3, 2, FALSE),
    PT(27, 20, 5, 1, FALSE),
    PT(40, 58, 4, 1,  TRUE),
    PT(14, 31, 2, 1, FALSE),
    PT(54, 33, 4, 0, FALSE),
    PT( 7, 59, 2, 0, FALSE),
    PT(35, 25, 6, 2, FALSE),
    PT(13, 46, 3, 0, FALSE),
    PT(63, 32, 4, 2,  TRUE),
    PT(62, 59, 2, 2,  TRUE),
    PT(11, 46, 2, 1, FALSE),
    PT(55, 11, 4, 1,  TRUE),
    PT(61, 50, 3, 3,  TRUE),
    PT(22,  3, 4, 3,  TRUE),
    PT(20, 12, 4, 0,  TRUE),
    PT(24,  3, 6, 0, FALSE),
    PT(62, 33, 2, 1,  TRUE),
    PT(15,  0, 6, 1, FALSE),
    PT(63, 35, 2, 3, FALSE),
    PT(14, 49, 3, 2,  TRUE),
    PT(24, 28, 3, 2,  TRUE),
    PT(48, 14, 3, 3, FALSE),
    PT(33, 32, 4, 1,  TRUE),
    PT(63, 12, 3, 3, FALSE),
    PT(20, 51, 4, 1, FALSE),
    PT(34, 33, 2, 2,  TRUE),
    PT(54,  5, 3, 3, FALSE),
    PT(29, 49, 2, 2, FALSE),
    PT(32, 17, 6, 3,  TRUE),
    PT(13, 51, 3, 0,  TRUE),
    PT(37,  5, 6, 3, FALSE),
    PT(30, 49, 4, 0, FALSE),
    PT(53, 58, 5, 3,  TRUE),
    PT(50, 47, 6, 0, FALSE),
    PT(20, 35, 5, 2,  TRUE),
    PT(53, 30, 5, 0,  TRUE),
    PT( 5,  5, 3, 1,  TRUE),
    PT( 9, 31, 4, 3, FALSE),
    PT(47, 11, 2, 2,  TRUE),
    PT(21, 17, 2, 1,  TRUE),
    PT(41, 27, 3, 0, FALSE),
    PT(28, 19, 6, 2,  TRUE),
    PT(52, 49, 4, 1,  TRUE),
    PT(39, 63, 5, 3,  TRUE),
    PT( 9, 48, 3, 0,  TRUE),
    PT(35, 18, 6, 2, FALSE),
    PT( 2, 42, 4, 0,  TRUE),
    PT( 9, 60, 3, 2,  TRUE),
    PT(12,  2, 2, 0, FALSE),
    PT(34,  5, 2, 3,  TRUE),
    PT(34,  8, 3, 1,  TRUE),
    PT(10, 15, 2, 2,  TRUE),
    PT( 2, 17, 2, 1,  TRUE),
    PT( 1, 33, 4, 1, FALSE),
    PT(22, 57, 6, 1,  TRUE),
    PT(36, 56, 6, 2, FALSE),
    PT(15, 30, 5, 1,  TRUE),
    PT(43, 21, 2, 2,  TRUE),
    PT(32, 34, 5, 3, FALSE),
    PT(58, 63, 6, 0,  TRUE),
    PT(26, 39, 5, 1,  TRUE),
    PT(41, 52, 2, 2, FALSE),
    PT(22, 57, 5, 3,  TRUE),
    PT(19, 62, 2, 3, FALSE),
    PT(54, 33, 6, 0, FALSE),
    PT( 0, 36, 5, 1,  TRUE),
    PT(36, 33, 6, 0, FALSE),
    PT(21, 49, 2, 1,  TRUE),
    PT(16, 55, 4, 2, FALSE),
    PT( 8,  7, 4, 1,  TRUE),
    PT(33,  9, 4, 2,  TRUE),
    PT( 5, 60, 6, 1, FALSE),
    PT(25,  3, 4, 2,  TRUE),
    PT(15, 41, 5, 1,  TRUE),
    PT(22,  7, 2, 1,  TRUE),
    PT(62, 61, 4, 2,  TRUE),
    PT(54, 11, 5, 0, FALSE),
    PT(46, 43, 2, 3, FALSE),
    PT(12, 49, 2, 0,  TRUE),
    PT(48, 19, 5, 2,  TRUE),
    PT(38, 62, 6, 3,  TRUE),
    PT(41, 47, 5, 3, FALSE),
    PT(21, 61, 2, 3,  TRUE),
    PT(28, 46, 4, 0,  TRUE),
    PT(51, 47, 2, 0, FALSE),
    PT(13,  5, 3, 2,  TRUE),
    PT(28, 26, 2, 1, FALSE),
    PT(14, 24, 6, 3,  TRUE),
    PT(27, 17, 2, 2, FALSE),
    PT( 6, 20, 4, 0,  TRUE),
    PT(49, 14, 4, 3,  TRUE),
    PT(26,  3, 2, 0, FALSE),
    PT( 0, 52, 6, 0,  TRUE),
    PT(63, 11, 3, 2,  TRUE),
    PT(15, 18, 3, 3,  TRUE),
    PT(26, 21, 2, 0, FALSE),
    PT(15,  0, 4, 2, FALSE),
    PT(62, 10, 5, 1, FALSE),
    PT(48, 43, 4, 2, FALSE),
    PT(38, 49, 2, 0, FALSE),
    PT(45, 47, 5, 3,  TRUE),
    PT(63, 12, 2, 1,  TRUE),
    PT(18, 11, 2, 3, FALSE),
    PT(21,  7, 3, 3,  TRUE),
    PT(40, 16, 6, 1, FALSE),
    PT(15, 23, 2, 2,  TRUE),
    PT(11, 39, 6, 1,  TRUE),
    PT(52, 29, 2, 0, FALSE),
    PT(28, 58, 2, 1, FALSE),
    PT(44, 39, 6, 3,  TRUE),
    PT(10, 26, 6, 1, FALSE),
    PT( 5, 31, 4, 0,  TRUE),
    PT(36, 13, 3, 3,  TRUE),
    PT(28, 23, 4, 2, FALSE),
    PT(47, 59, 6, 1, FALSE),
    PT(59, 37, 2, 0, FALSE),
    PT( 3, 47, 4, 0,  TRUE),
    PT(12, 16, 4, 1,  TRUE),
    PT(14, 58, 5, 2, FALSE),
    PT(51,  3, 5, 2, FALSE),
    PT(18,  6, 3, 2, FALSE),
    PT(42, 55, 6, 0, FALSE),
    PT(63,  1, 3, 3, FALSE),
    PT(53, 22, 6, 3,  TRUE),
    PT(44, 50, 6, 2,  TRUE),
    PT( 5, 17, 4, 1, FALSE),
    PT(41,  9, 4, 0, FALSE),
    PT(43, 13, 3, 3,  TRUE),
    PT(24, 13, 4, 0, FALSE),
    PT(35, 57, 2, 3, FALSE),
    PT(15, 58, 3, 0, FALSE),
    PT(33, 53, 5, 1,  TRUE),
    PT(54, 38, 5, 1,  TRUE),
    PT(35,  5, 5, 3,  TRUE),
    PT(27,  8, 2, 3,  TRUE),
    PT(62,  9, 2, 3, FALSE),
    PT(45, 58, 6, 3,  TRUE),
    PT(21, 53, 6, 2,  TRUE),
    PT(41, 10, 2, 1, FALSE),
    PT( 2, 57, 3, 3,  TRUE),
    PT(20, 52, 6, 1,  TRUE),
    PT(23, 29, 3, 0, FALSE),
    PT(22, 29, 3, 1, FALSE),
    PT( 1, 57, 4, 1, FALSE),
    PT(30, 39, 6, 3, FALSE),
    PT(50, 20, 4, 3, FALSE),
    PT(10, 57, 6, 3, FALSE),
    PT(31, 13, 3, 3, FALSE),
    PT(11, 10, 3, 0,  TRUE),
    PT(53, 29, 6, 2, FALSE),
    PT( 3, 18, 2, 3, FALSE),
    PT(12, 19, 5, 3, FALSE),
    PT(12, 52, 3, 3, FALSE),
    PT(16, 20, 3, 3, FALSE),
    PT(35, 50, 4, 3,  TRUE),
    PT( 2, 16, 5, 0,  TRUE),
    PT(53, 24, 6, 1,  TRUE),
    PT(51, 29, 3, 1, FALSE),
    PT(60, 21, 4, 1,  TRUE),
    PT(62, 63, 4, 1, FALSE),
    PT(42,  2, 5, 2, FALSE),
    PT(40, 10, 5, 3,  TRUE),
    PT(26,  6, 6, 2,  TRUE),
    PT(60, 23, 5, 1,  TRUE),
    PT( 3, 18, 2, 3,  TRUE),
    PT(47, 10, 4, 3, FALSE),
    PT(18, 56, 2, 0,  TRUE),
    PT(54, 27, 4, 1,  TRUE),
    PT( 1, 57, 6, 2,  TRUE),
    PT(25, 25, 2, 3,  TRUE),
    PT( 9, 40, 4, 1, FALSE),
    PT(30, 39, 5, 2, FALSE),
    PT(53, 51, 5, 2, FALSE),
    PT(39, 37, 6, 0,  TRUE),
    PT( 6, 49, 5, 2,  TRUE),
    PT(26, 57, 5, 0, FALSE),
    PT(45,  4, 3, 3, FALSE),
    PT(36, 62, 3, 2, FALSE),
    PT(60, 48, 3, 1,  TRUE),
    PT(63, 62, 6, 3,  TRUE),
    PT(34, 54, 2, 0,  TRUE),
    PT( 0,  1, 3, 2, FALSE),
    PT(18, 26, 2, 0, FALSE),
    PT(18, 30, 5, 2, FALSE),
    PT(31, 18, 5, 1, FALSE),
    PT(47,  6, 3, 0,  TRUE),
    PT(53, 26, 3, 0, FALSE),
    PT(59,  9, 6, 3, FALSE),
    PT(52, 29, 2, 1,  TRUE),
    PT( 2,  7, 2, 0, FALSE),
    PT(32, 47, 3, 2,  TRUE),
    PT(11,  3, 6, 1,  TRUE),
    PT(28, 22, 6, 0,  TRUE),
    PT( 5, 19, 3, 1,  TRUE),
    PT(41,  6, 2, 1,  TRUE),
    PT(48, 45, 6, 3, FALSE),
    PT(42, 45, 5, 2, FALSE),
    PT(25, 52, 3, 2, FALSE),
    PT(15, 21, 2, 1, FALSE),
    PT(54, 21, 5, 2, FALSE),
    PT(58,  6, 3, 2, FALSE),
    PT(18, 29, 4, 3, FALSE),
    PT( 3, 56, 3, 2,  TRUE),
    PT( 1,  1, 5, 2,  TRUE),
    PT(23, 46, 2, 0, FALSE),
    PT(20, 23, 3, 2, FALSE),
    PT(52, 15, 5, 0, FALSE),
    PT( 9, 55, 3, 1,  TRUE),
    PT(40, 29, 4, 3, FALSE),
    PT(41, 45, 6, 3, FALSE),
    PT(30, 23, 5, 0, FALSE),
    PT(21, 15, 3, 2, FALSE),
    PT(32, 45, 2, 0, FALSE),
    PT(39, 22, 5, 3, FALSE),
    PT(20,  9, 2, 1, FALSE),
    PT(59, 61, 4, 0,  TRUE),
    PT(37, 26, 5, 2, FALSE),
    PT( 0, 34, 6, 3, FALSE),
    PT(13, 48, 2, 0, FALSE),
    PT(23, 25, 3, 1,  TRUE),
    PT( 0, 59, 4, 0,  TRUE),
    PT(42, 40, 6, 2, FALSE),
    PT(45, 15, 2, 3, FALSE),
    PT(10, 48, 5, 0, FALSE),
    PT( 6,  0, 4, 2,  TRUE),
    PT(49, 46, 5, 1, FALSE),
    PT(20, 51, 5, 0, FALSE),
    PT(54, 16, 5, 3, FALSE),
    PT( 5, 46, 3, 0,  TRUE),
    PT(25, 26, 2, 2,  TRUE),
    PT(44, 20, 2, 3,  TRUE),
    PT(55, 15, 2, 1,  TRUE),
    PT(50, 23, 3, 1,  TRUE),
    PT(57, 24, 6, 1, FALSE),
    PT(46, 50, 3, 3, FALSE),
    PT(36, 29, 6, 0,  TRUE),
    PT(18, 29, 5, 1,  TRUE),
    PT(20, 12, 4, 3,  TRUE),
    PT(54, 46, 6, 1, FALSE),
    PT( 6, 10, 3, 1, FALSE),
    PT(40, 40, 4, 0, FALSE),
    PT(58, 58, 2, 3,  TRUE),
    PT( 8, 39, 6, 3, FALSE),
    PT(24, 26, 2, 0, FALSE),
    PT(30, 38, 3, 1,  TRUE),
    PT(31, 51, 3, 3,  TRUE),
    PT(33, 23, 5, 3,  TRUE),
    PT( 1,  8, 4, 0, FALSE),
    PT(53,  3, 3, 0,  TRUE),
    PT(59,  2, 4, 0, FALSE),
    PT( 2, 45, 4, 1,  TRUE),
    PT(14, 23, 6, 1, FALSE),
    PT(49, 41, 2, 0,  TRUE),
    PT(34, 23, 4, 1, FALSE),
    PT(58, 44, 4, 1,  TRUE),
    PT(52, 32, 3, 0, FALSE),
    PT( 0, 58, 4, 1, FALSE),
    PT(37, 51, 4, 0,  TRUE),
    PT(51,  4, 4, 3,  TRUE),
    PT( 4, 24, 6, 1, FALSE),
    PT(44, 12, 5, 3,  TRUE),
    PT(40, 20, 5, 2, FALSE),
    PT(63, 48, 5, 1,  TRUE),
    PT(48, 33, 3, 2,  TRUE),
    PT( 1, 37, 6, 1, FALSE),
    PT( 5, 35, 6, 2, FALSE),
    PT(36, 16, 6, 0, FALSE),
    PT(61, 20, 3, 1,  TRUE),
    PT(63, 56, 5, 3,  TRUE),
    PT(34, 27, 6, 1, FALSE),
    PT(37,  7, 6, 3,  TRUE),
    PT(10, 12, 3, 2,  TRUE),
    PT( 3, 30, 3, 1, FALSE),
    PT(15, 60, 2, 1, FALSE),
    PT(17, 24, 3, 2,  TRUE),
    PT( 0, 53, 5, 3,  TRUE),
    PT(50, 24, 2, 2, FALSE),
    PT(35, 48, 3, 1,  TRUE),
    PT(17, 61, 2, 1, FALSE),
    PT(26, 22, 6, 2,  TRUE),
    PT(40,  5, 4, 2, FALSE),
    PT(23, 61, 6, 3,  TRUE),
    PT(46,  9, 5, 3, FALSE),
    PT(24, 29, 2, 3,  TRUE),
    PT(32, 31, 3, 0, FALSE),
    PT(35, 44, 5, 3,  TRUE),
    PT(32, 63, 2, 3, FALSE),
    PT(63, 41, 5, 3, FALSE),
    PT(35, 59, 5, 0,  TRUE),
    PT(24, 57, 2, 1,  TRUE),
    PT(30, 50, 6, 2,  TRUE),
    PT(20, 29, 5, 1, FALSE),
    PT(53,  1, 3, 2,  TRUE),
    PT(62, 59, 3, 3, FALSE),
    PT(34, 30, 2, 3, FALSE),
    PT(24, 34, 2, 1, FALSE),
    PT(62, 41, 6, 1,  TRUE),
    PT(47, 20, 3, 0,  TRUE),
    PT(59,  7, 2, 2,  TRUE),
    PT( 6, 61, 5, 0,  TRUE),
    PT(53, 55, 4, 1,  TRUE),
    PT(52, 29, 5, 2,  TRUE),
    PT(24, 18, 3, 1,  TRUE),
    PT(11, 19, 4, 2, FALSE),
    PT(19, 56, 3, 2, FALSE),
    PT(31, 11, 3, 1,  TRUE),
    PT(19, 33, 3, 2, FALSE),
    PT( 6, 57, 6, 1, FALSE),
    PT(55, 61, 4, 3, FALSE),
    PT(41, 38, 2, 2,  TRUE),
    PT(60, 51, 4, 3,  TRUE),
    PT( 0,  1, 5, 3, FALSE),
    PT(21, 24, 6, 0,  TRUE),
    PT(13, 44, 2, 1,  TRUE),
    PT(39, 59, 4, 0, FALSE),
    PT(45,  1, 4, 3, FALSE),
    PT(35, 21, 6, 0, FALSE),
    PT(36,  0, 2, 3,  TRUE),
    PT(55, 63, 6, 1,  TRUE),
    PT(37, 36, 6, 0,  TRUE),
    PT( 6, 59, 6, 3,  TRUE),
    PT( 3, 24, 3, 1, FALSE),
    PT(44, 52, 2, 2, FALSE),
    PT(29, 54, 3, 0, FALSE),
    PT(58,  4, 4, 1,  TRUE),
    PT(18, 38, 2, 2,  TRUE),
    PT(43, 25, 3, 1, FALSE),
    PT(41, 44, 6, 3, FALSE),
    PT( 1, 25, 3, 2,  TRUE),
    PT(47,  6, 5, 1,  TRUE),
    PT(12, 18, 4, 3, FALSE),
    PT(54, 50, 3, 2,  TRUE),
    PT(13, 18, 5, 0, FALSE),
    PT( 3, 40, 2, 1,  TRUE),
    PT(41,  6, 2, 3,  TRUE),
    PT( 3, 56, 4, 0,  TRUE),
    PT(48, 44, 2, 0, FALSE),
    PT(34,  0, 5, 0, FALSE),
    PT(36, 59, 3, 2, FALSE),
    PT(32, 62, 2, 1,  TRUE),
    PT( 2, 12, 3, 0,  TRUE),
    PT(41, 44, 3, 1, FALSE),
    PT(57, 48, 4, 1, FALSE),
    PT(42, 31, 4, 1, FALSE),
    PT(20, 52, 5, 2, FALSE),
    PT(20, 37, 3, 1,  TRUE),
    PT( 6, 59, 2, 2,  TRUE),
    PT( 6, 28, 2, 1,  TRUE),
    PT(21,  3, 3, 0, FALSE),
    PT(30, 42, 3, 1,  TRUE),
    PT(23, 37, 5, 3,  TRUE),
    PT(28, 41, 5, 3, FALSE),
    PT( 2, 50, 3, 3, FALSE),
    PT(29, 40, 6, 2,  TRUE),
    PT(54,  3, 6, 2, FALSE),
    PT(22, 61, 5, 1, FALSE),
    PT(18, 13, 2, 1,  TRUE),
    PT(29, 45, 4, 0,  TRUE),
    PT(50, 23, 5, 3, FALSE),
    PT(26, 21, 4, 3, FALSE),
    PT(34, 47, 2, 2,  TRUE),
    PT(60, 14, 4, 0, FALSE),
    PT(47, 39, 2, 1,  TRUE),
    PT( 4,  9, 6, 1, FALSE),
    PT(30,  1, 6, 2, FALSE),
    PT( 6, 22, 3, 3, FALSE),
    PT(46, 27, 3, 2, FALSE),
    PT(40, 19, 5, 1, FALSE),
    PT(48, 52, 2, 1, FALSE),
    PT(18, 50, 3, 0, FALSE),
    PT(29, 29, 6, 2,  TRUE),
    PT( 7, 28, 2, 3, FALSE),
    PT(45, 61, 6, 2,  TRUE),
    PT(28, 27, 4, 2, FALSE),
    PT(33, 45, 3, 3, FALSE),
    PT(16,  9, 2, 2, FALSE),
    PT(61, 17, 2, 1, FALSE),
    PT(37,  2, 4, 3, FALSE),
    PT(35,  2, 3, 0,  TRUE),
    PT(25,  5, 2, 2, FALSE),
    PT(11, 33, 3, 1, FALSE),
    PT( 9,  2, 5, 2, FALSE),
    PT(24, 40, 5, 2,  TRUE),
    PT(30, 16, 2, 1, FALSE),
    PT(46, 24, 5, 3, FALSE),
    PT(31,  2, 5, 2, FALSE),
    PT(20, 23, 4, 2, FALSE),
    PT(57,  8, 6, 1, FALSE),
    PT(22, 20, 4, 1, FALSE),
    PT(22, 40, 4, 0,  TRUE),
    PT(17, 16, 5, 2, FALSE),
    PT(35, 54, 5, 1,  TRUE),
    PT(57, 33, 4, 3, FALSE),
    PT(14,  6, 5, 2,  TRUE),
    PT(60, 62, 4, 3, FALSE),
    PT(42, 27, 3, 3,  TRUE),
    PT( 0, 60, 6, 1,  TRUE),
    PT(53, 63, 2, 2, FALSE),
    PT( 0, 11, 2, 0, FALSE),
    PT(52, 60, 2, 3,  TRUE),
    PT(45,  7, 3, 3,  TRUE),
    PT(36, 57, 4, 3,  TRUE),
    PT(22,  0, 3, 2,  TRUE),
    PT(51, 43, 3, 3, FALSE),
    PT(15,  8, 6, 0,  TRUE),
    PT(58,  9, 2, 1,  TRUE),
    PT(12, 33, 3, 2, FALSE),
    PT(42, 23, 6, 2, FALSE),
    PT(41, 39, 2, 0, FALSE),
    PT(55, 27, 3, 0, FALSE),
    PT(21,  8, 5, 3,  TRUE),
    PT(31, 22, 2, 1, FALSE),
    PT(31, 40, 6, 2, FALSE),
    PT(28, 32, 4, 1, FALSE),
    PT(18,  1, 2, 1, FALSE),
    PT(33, 49, 2, 0, FALSE),
    PT(34, 38, 3, 3, FALSE),
    PT( 1, 61, 2, 0,  TRUE),
    PT(30, 39, 4, 2,  TRUE),
    PT(61, 48, 4, 2, FALSE),
    PT(29, 17, 4, 1, FALSE),
    PT(54, 48, 2, 3, FALSE),
    PT(31, 62, 5, 1, FALSE),
    PT(60, 39, 3, 1,  TRUE),
    PT(31, 41, 2, 0, FALSE),
    PT(30,  5, 5, 1, FALSE),
    PT(10, 16, 2, 2, FALSE),
    PT(31,  0, 5, 3, FALSE),
    PT(11, 59, 3, 0, FALSE),
    PT(10, 57, 6, 0, FALSE),
    PT(55, 11, 3, 3,  TRUE),
    PT(29, 10, 5, 0,  TRUE),
    PT(62, 28, 6, 1,  TRUE),
    PT(19, 46, 5, 0, FALSE),
    PT(39, 27, 3, 3, FALSE),
    PT(29,  2, 3, 2, FALSE),
    PT( 1, 37, 2, 2, FALSE),
    PT(58, 16, 3, 2, FALSE),
    PT(18,  5, 5, 1, FALSE),
    PT(48, 32, 4, 3, FALSE),
    PT(47, 46, 5, 3, FALSE),
    PT( 3,  7, 4, 2, FALSE),
    PT(54,  4, 5, 1,  TRUE),
    PT(17, 37, 5, 2,  TRUE),
    PT(40, 14, 5, 3, FALSE),
    PT(15, 29, 2, 2,  TRUE),
    PT(28, 40, 6, 0, FALSE),
    PT(31, 35, 4, 3, FALSE),
    PT(54, 18, 6, 3,  TRUE),
    PT(58, 49, 2, 0, FALSE),
    PT(44, 44, 5, 3,  TRUE),
    PT(26, 13, 2, 2,  TRUE),
    PT(63, 60, 6, 1, FALSE),
    PT(53, 28, 2, 3, FALSE),
    PT(51, 22, 5, 0, FALSE),
    PT(29, 63, 4, 0,  TRUE),
    PT(44, 62, 5, 1,  TRUE),
    PT(36, 35, 5, 3,  TRUE),
    PT(50, 21, 5, 1, FALSE),
    PT(27, 16, 6, 2,  TRUE),
    PT(24, 55, 2, 0, FALSE),
    PT(59, 30, 2, 0,  TRUE),
    PT(43, 22, 4, 2, FALSE),
    PT(29, 22, 4, 3, FALSE),
    PT(60, 45, 2, 0,  TRUE),
    PT(21, 40, 5, 0, FALSE),
    PT(39, 39, 4, 3,  TRUE),
    PT(59, 58, 2, 3, FALSE),
    PT(26, 12, 3, 1, FALSE),
    PT(21,  8, 4, 2,  TRUE),
    PT(11, 16, 4, 1, FALSE),
    PT(26, 62, 2, 3,  TRUE),
    PT(40, 31, 3, 3, FALSE),
    PT( 1, 30, 3, 3, FALSE),
    PT(28, 47, 2, 0, FALSE),
    PT(37, 11, 6, 2, FALSE),
    PT(62, 12, 3, 1, FALSE),
    PT(27, 16, 5, 1, FALSE),
    PT(15, 20, 2, 3,  TRUE),
    PT(15, 63, 2, 3,  TRUE),
    PT( 3, 21, 3, 3,  TRUE),
    PT( 2, 54, 2, 3,  TRUE),
    PT(21, 29, 3, 0, FALSE),
    PT( 8, 54, 2, 0, FALSE),
    PT(20, 13, 5, 1,  TRUE),
    PT(10,  5, 3, 2,  TRUE),
    PT(38, 18, 3, 3, FALSE),
    PT(62, 24, 3, 0,  TRUE),
    PT(54, 24, 6, 3,  TRUE),
    PT(23, 57, 5, 3, FALSE),
    PT(13,  4, 3, 0,  TRUE),
    PT(22, 34, 2, 2,  TRUE),
    PT(62, 38, 3, 3,  TRUE),
    PT( 0,  6, 2, 3,  TRUE),
    PT(51, 34, 3, 2,  TRUE),
    PT(43, 57, 5, 1,  TRUE),
    PT(62, 49, 3, 2, FALSE),
    PT(34, 63, 2, 1,  TRUE),
    PT(48, 28, 6, 0,  TRUE),
    PT( 7, 43, 2, 2, FALSE),
    PT(50, 53, 3, 3, FALSE),
    PT( 2,  7, 4, 0, FALSE),
    PT(15, 59, 2, 0,  TRUE),
    PT(32,  7, 2, 1, FALSE),
    PT(42, 48, 3, 2,  TRUE),
    PT(40, 56, 6, 3, FALSE),
    PT(32,  1, 2, 3,  TRUE),
    PT(21, 32, 4, 0,  TRUE),
    PT(58, 27, 3, 3, FALSE),
    PT(56, 18, 4, 2, FALSE),
    PT( 3, 62, 3, 3,  TRUE),
    PT(41, 29, 2, 1,  TRUE),
    PT(32, 39, 3, 0,  TRUE),
    PT(18, 37, 4, 0, FALSE),
    PT(50, 51, 5, 1,  TRUE),
    PT(63,  5, 6, 0,  TRUE),
    PT(53, 60, 5, 2,  TRUE),
    PT(45,  2, 5, 3, FALSE),
    PT(16, 42, 2, 3, FALSE),
    PT(23,  8, 6, 0,  TRUE),
    PT(23, 46, 5, 1,  TRUE),
    PT(48, 30, 2, 2,  TRUE),
    PT(49, 21, 4, 3, FALSE),
    PT( 8, 16, 6, 1,  TRUE),
    PT(21,  1, 4, 3,  TRUE),
    PT(18,  7, 5, 3,  TRUE),
    PT(41, 39, 6, 2, FALSE),
    PT(63,  8, 6, 0,  TRUE),
    PT(28, 32, 3, 1, FALSE),
    PT(51, 12, 2, 1,  TRUE),
    PT(24, 49, 4, 2, FALSE),
    PT(55, 45, 5, 3, FALSE),
    PT(33, 24, 4, 2, FALSE),
    PT(58, 39, 6, 0,  TRUE),
    PT(53, 62, 6, 0, FALSE),
    PT(58, 20, 6, 1,  TRUE),
    PT(15, 26, 5, 2,  TRUE),
    PT(48, 46, 2, 0,  TRUE),
    PT(26, 49, 3, 2,  TRUE),
    PT(23, 60, 3, 0, FALSE),
    PT(51, 49, 4, 1,  TRUE),
    PT(29, 57, 5, 2,  TRUE),
    PT(16, 29, 5, 3,  TRUE),
    PT(36, 21, 3, 2, FALSE),
    PT(37,  1, 5, 1,  TRUE),
    PT(34, 22, 5, 3, FALSE),
    PT(27, 37, 6, 2,  TRUE),
    PT(55, 16, 4, 3, FALSE),
    PT(57,  1, 6, 3, FALSE),
    PT(23, 43, 2, 2, FALSE),
    PT( 9, 22, 2, 3,  TRUE),
    PT(32, 40, 4, 1,  TRUE),
    PT(38, 58, 4, 3, FALSE),
    PT(39, 42, 4, 2, FALSE),
    PT(54,  2, 5, 2, FALSE),
    PT(41, 48, 6, 2,  TRUE),
    PT(54,  1, 3, 3,  TRUE),
    PT(40, 59, 3, 2,  TRUE),
    PT(35, 30, 5, 2,  TRUE),
    PT(17, 30, 5, 2, FALSE),
    PT(47, 50, 3, 0,  TRUE),
    PT(63, 38, 6, 0,  TRUE),
    PT(56, 30, 2, 3,  TRUE),
    PT( 5, 24, 5, 3, FALSE),
    PT( 0, 46, 2, 1, FALSE),
    PT(52, 63, 6, 2, FALSE),
    PT(22, 16, 5, 0,  TRUE),
    PT(32, 61, 6, 3, FALSE),
    PT(47, 22, 4, 2,  TRUE),
    PT(18, 23, 2, 0, FALSE),
    PT(33, 55, 6, 2,  TRUE),
    PT(37, 55, 5, 2,  TRUE),
    PT( 1,  8, 4, 3,  TRUE),
    PT( 3, 31, 5, 0,  TRUE),
    PT(13, 42, 2, 3, FALSE),
    PT(58, 63, 6, 1,  TRUE),
    PT(43, 25, 3, 2,  TRUE),
    PT(42, 31, 5, 0,  TRUE),
    PT(40, 44, 2, 0, FALSE),
    PT(40, 48, 2, 0, FALSE),
    PT(57, 20, 3, 1,  TRUE),
    PT( 0, 24, 4, 0,  TRUE),
    PT(40, 12, 6, 3,  TRUE),
    PT(17, 16, 2, 0,  TRUE),
    PT(60, 51, 6, 1, FALSE),
    PT(51, 54, 3, 1, FALSE),
    PT(54,  0, 3, 2, FALSE),
    PT(49, 27, 3, 2,  TRUE),
    PT(56, 29, 2, 0, FALSE),
    PT(60, 57, 4, 3,  TRUE),
    PT(58, 63, 2, 2, FALSE),
    PT(25, 18, 2, 2, FALSE),
    PT(13, 31, 3, 0, FALSE),
    PT( 0, 37, 3, 0, FALSE),
    PT(40, 28, 6, 1, FALSE),
    PT(39,  3, 3, 1, FALSE),
    PT(38, 45, 5, 1, FALSE),
    PT(41, 40, 4, 3,  TRUE),
    PT(10, 42, 3, 0, FALSE),
    PT(10, 26, 6, 0, FALSE),
    PT(32, 26, 5, 3, FALSE),
    PT( 6, 11, 3, 2,  TRUE),
    PT(15, 12, 3, 2, FALSE),
    PT(53, 40, 3, 2, FALSE),
    PT(61, 22, 4, 1,  TRUE),
    PT(33, 28, 6, 0,  TRUE),
    PT(20, 28, 5, 3, FALSE),
    PT(34, 50, 6, 2,  TRUE),
    PT( 9, 41, 6, 0, FALSE),
    PT(32, 26, 2, 0, FALSE),
    PT(49, 63, 5, 2, FALSE),
    PT(10, 61, 6, 3,  TRUE),
    PT(11, 46, 5, 2,  TRUE),
    PT(31, 34, 6, 0,  TRUE),
    PT( 6,  7, 5, 0,  TRUE),
    PT(34, 23, 5, 2,  TRUE),
    PT(48, 17, 3, 0, FALSE),
    PT(12, 25, 2, 2,  TRUE),
    PT( 7, 10, 6, 2, FALSE),
    PT(24, 41, 4, 3,  TRUE),
    PT(51, 12, 6, 0, FALSE),
    PT( 3, 26, 6, 3,  TRUE),
    PT( 6,  1, 5, 2,  TRUE),
    PT(15, 59, 5, 1,  TRUE),
    PT(17, 31, 6, 3,  TRUE),
    PT(43, 33, 6, 3, FALSE),
    PT(63, 35, 2, 3,  TRUE),
    PT(23,  7, 5, 1,  TRUE),
    PT(43, 14, 6, 0, FALSE),
    PT(17, 57, 3, 2,  TRUE),
    PT(41,  3, 6, 1,  TRUE),
    PT(48,  3, 5, 3,  TRUE),
    PT(60, 32, 4, 3, FALSE),
    PT( 3, 34, 2, 2, FALSE),
    PT(58, 40, 6, 2,  TRUE),
    PT( 1, 40, 5, 1,  TRUE),
    PT(62, 21, 3, 0, FALSE),
    PT(48,  7, 2, 3,  TRUE),
    PT(59, 44, 6, 0, FALSE),
    PT(21,  7, 5, 2, FALSE),
    PT(23, 39, 3, 2,  TRUE),
    PT(63, 30, 6, 1,  TRUE),
    PT(13, 23, 2, 0, FALSE),
    PT(21, 14, 6, 0, FALSE),
    PT( 9,  5, 6, 0, FALSE),
    PT(45, 32, 2, 2,  TRUE),
    PT(60, 61, 6, 0, FALSE),
    PT(12, 23, 3, 2, FALSE),
    PT(26, 13, 4, 2,  TRUE),
    PT(43, 43, 5, 1, FALSE),
    PT( 2, 22, 5, 2,  TRUE),
    PT(23, 49, 2, 3,  TRUE),
    PT( 0,  8, 2, 1,  TRUE),
    PT(55, 53, 4, 0,  TRUE),
    PT(30, 28, 3, 3,  TRUE),
    PT(43, 50, 3, 2, FALSE),
    PT(16, 42, 2, 3, FALSE),
    PT(58, 51, 6, 0,  TRUE),
    PT(23, 43, 5, 1, FALSE),
    PT(12, 61, 2, 0,  TRUE),
    PT(40, 10, 6, 0, FALSE),
    PT(35, 10, 4, 3, FALSE),
    PT(10, 20, 4, 2, FALSE),
    PT(11, 15, 6, 0, FALSE),
    PT(27, 30, 5, 0,  TRUE),
    PT( 2, 53, 5, 0, FALSE),
    PT(59,  2, 2, 2, FALSE),
    PT( 0, 15, 6, 2,  TRUE),
    PT(28, 60, 5, 3, FALSE),
    PT(40, 56, 3, 0,  TRUE),
    PT(27, 17, 2, 1, FALSE),
    PT( 9, 22, 2, 0, FALSE),
    PT(46, 13, 4, 0, FALSE),
    PT(61,  4, 6, 1, FALSE),
    PT(22, 44, 4, 2,  TRUE),
    PT( 2, 61, 3, 0, FALSE),
    PT(11, 19, 3, 2, FALSE),
    PT(34, 42, 3, 2, FALSE),
    PT(32, 39, 4, 1, FALSE),
    PT( 5, 38, 4, 1, FALSE),
    PT(18, 29, 5, 2, FALSE),
    PT( 8,  5, 5, 3, FALSE),
    PT(63, 28, 2, 3,  TRUE),
    PT(36, 13, 6, 1,  TRUE),
    PT(54,  8, 4, 2, FALSE),
    PT(16, 34, 5, 0,  TRUE),
    PT(28, 10, 2, 0,  TRUE),
    PT(37, 15, 2, 0, FALSE),
    PT(36, 56, 5, 3,  TRUE),
    PT(37, 50, 3, 3, FALSE),
    PT( 6, 42, 5, 0,  TRUE),
    PT(62, 58, 5, 0, FALSE),
    PT(52, 23, 6, 1,  TRUE),
    PT(24, 51, 2, 3,  TRUE),
    PT( 7, 20, 3, 3,  TRUE),
    PT(17, 23, 4, 0, FALSE),
    PT(19, 14, 2, 2, FALSE),
    PT(59, 28, 2, 1, FALSE),
    PT(42, 19, 6, 3,  TRUE),
    PT(42, 53, 6, 1, FALSE),
    PT(48,  2, 4, 2,  TRUE),
    PT( 0,  7, 3, 3,  TRUE),
    PT(12,  4, 5, 2, FALSE),
    PT(55, 55, 6, 0, FALSE),
    PT(37, 18, 4, 2,  TRUE),
    PT(18, 34, 4, 0,  TRUE),
    PT(34, 53, 6, 1,  TRUE),
    PT( 7, 32, 5, 2,  TRUE),
    PT(39, 14, 6, 0, FALSE),
    PT(52, 25, 3, 1, FALSE),
    PT(10, 60, 4, 2,  TRUE),
    PT( 7, 29, 5, 1,  TRUE),
    PT(49, 58, 2, 1, FALSE),
    PT(26, 61, 6, 3,  TRUE),
    PT(22, 21, 2, 3, FALSE),
    PT(57, 19, 2, 2,  TRUE),
    PT(45,  3, 5, 3, FALSE),
    PT( 6, 57, 5, 2, FALSE),
    PT(22,  0, 2, 1,  TRUE),
    PT(53, 42, 6, 2,  TRUE),
    PT(36,  1, 3, 0, FALSE),
    PT(36, 55, 5, 0, FALSE),
    PT(37, 27, 6, 2, FALSE),
    PT(37, 25, 2, 3,  TRUE),
    PT(39, 47, 3, 1,  TRUE),
    PT(39, 13, 2, 0, FALSE),
    PT(54, 60, 6, 0, FALSE),
    PT(60, 51, 4, 1,  TRUE),
    PT(62, 39, 3, 3, FALSE),
    PT(37, 45, 5, 0,  TRUE),
    PT(31, 18, 4, 0,  TRUE),
    PT(55, 50, 3, 3,  TRUE),
    PT(17, 33, 6, 2,  TRUE),
    PT(48, 12, 3, 0,  TRUE),
    PT(37, 61, 4, 3, FALSE),
    PT(23,  2, 3, 2,  TRUE),
    PT(20, 46, 2, 0,  TRUE),
    PT(56, 19, 6, 0, FALSE),
    PT(10, 43, 4, 0, FALSE),
    PT(30, 16, 2, 2,  TRUE),
    PT(55, 48, 5, 3, FALSE),
    PT(30,  4, 5, 2, FALSE),
    PT(20, 52, 3, 0,  TRUE),
    PT( 8, 20, 3, 0, FALSE),
    PT(14, 28, 6, 0, FALSE),
    PT(26, 46, 3, 1,  TRUE),
    PT(31, 57, 6, 0,  TRUE),
    PT(12, 28, 5, 0, FALSE),
    PT(62, 51, 4, 1,  TRUE),
    PT(15, 19, 2, 3, FALSE),
    PT(37, 57, 5, 3,  TRUE),
    PT(20, 27, 3, 1, FALSE),
    PT(40, 62, 4, 0,  TRUE),
    PT(45, 25, 2, 0,  TRUE),
    PT(12, 52, 6, 1, FALSE),
    PT(57, 49, 3, 0,  TRUE),
    PT(26,  8, 6, 2, FALSE),
    PT( 9, 47, 2, 0,  TRUE),
    PT(48,  4, 3, 2, FALSE),
    PT( 2, 59, 3, 1,  TRUE),
    PT(51, 33, 6, 1,  TRUE),
    PT(56,  2, 3, 1, FALSE),
    PT(49, 56, 6, 1, FALSE),
    PT(31, 29, 2, 3, FALSE),
    PT(23, 16, 3, 1,  TRUE),
    PT(50, 32, 2, 3,  TRUE),
    PT( 0, 51, 2, 1, FALSE),
    PT(33, 15, 4, 3,  TRUE),
    PT(20, 25, 4, 3,  TRUE),
    PT(36, 44, 6, 3,  TRUE),
    PT(37,  5, 5, 3,  TRUE),
    PT(61, 37, 2, 0,  TRUE),
    PT(18, 48, 3, 1, FALSE),
    PT(22,  3, 3, 1, FALSE),
    PT(20,  9, 2, 1,  TRUE),
    PT( 2, 35, 4, 1, FALSE),
    PT( 1, 60, 2, 0, FALSE),
    PT(63, 45, 4, 1,  TRUE),
    PT(49, 63, 4, 1,  TRUE),
    PT(23,  0, 6, 1,  TRUE),
    PT(63, 15, 5, 3,  TRUE),
    PT(38,  7, 2, 2,  TRUE),
    PT(33, 43, 5, 1, FALSE),
    PT(56, 57, 3, 3, FALSE),
    PT( 9, 37, 5, 1,  TRUE),
    PT(59, 48, 4, 2,  TRUE),
    PT(18, 45, 2, 1,  TRUE),
    PT(50, 25, 5, 0, FALSE),
    PT(36, 28, 5, 2,  TRUE),
    PT(53, 50, 4, 3, FALSE),
    PT(13, 35, 3, 3, FALSE),
    PT(29,  7, 4, 0,  TRUE),
    PT(11, 52, 2, 3,  TRUE),
    PT(45, 50, 6, 1, FALSE),
    PT(58, 60, 6, 2,  TRUE),
    PT(26, 16, 6, 1,  TRUE),
    PT(26,  7, 4, 1, FALSE),
    PT(59, 27, 5, 1, FALSE),
    PT(51, 31, 4, 3, FALSE),
    PT(14, 53, 3, 1, FALSE),
    PT(59, 10, 3, 2, FALSE),
    PT(17,  7, 2, 0,  TRUE),
    PT(13, 60, 5, 2,  TRUE),
    PT(30, 55, 5, 0,  TRUE),
    PT(17,  5, 2, 1, FALSE),
    PT(21, 47, 3, 2, FALSE),
    PT(36, 49, 2, 3, FALSE),
    PT(43, 33, 3, 1,  TRUE),
    PT(35, 16, 6, 0,  TRUE),
    PT( 2, 20, 5, 0,  TRUE),
    PT(38, 32, 2, 3, FALSE),
    PT(16, 23, 2, 0, FALSE),
    PT(11, 15, 6, 1,  TRUE),
    PT( 1, 46, 2, 2, FALSE),
    PT(33, 14, 6, 3,  TRUE),
    PT(26, 29, 5, 3,  TRUE),
    PT(30, 48, 4, 2, FALSE),
    PT( 4, 20, 5, 2,  TRUE),
    PT(17,  0, 6, 0, FALSE),
    PT( 8, 42, 3, 2,  TRUE),
    PT(29, 34, 4, 0,  TRUE),
    PT(36, 44, 6, 3,  TRUE),
    PT(36, 17, 2, 1, FALSE),
    PT( 4, 46, 5, 0, FALSE),
    PT(29, 24, 4, 1,  TRUE),
    PT(60, 22, 2, 3, FALSE),
    PT(16, 23, 6, 0,  TRUE),
    PT(32, 33, 2, 1, FALSE),
    PT(51, 62, 6, 2, FALSE),
    PT( 6, 19, 2, 1,  TRUE),
    PT(23, 56, 5, 1,  TRUE),
    PT(20, 13, 2, 2,  TRUE),
    PT(36, 59, 5, 1,  TRUE),
    PT(52, 59, 3, 3, FALSE),
    PT(24,  7, 6, 2, FALSE),
    PT(55, 29, 3, 3,  TRUE),
    PT(11, 41, 4, 0, FALSE),
    PT(18, 30, 3, 2,  TRUE),
    PT(26, 36, 4, 2, FALSE),
    PT(61, 40, 4, 2, FALSE),
    PT(11, 18, 6, 1,  TRUE),
    PT(27, 58, 4, 1, FALSE),
    PT(20, 19, 5, 1, FALSE),
    PT(49, 56, 2, 2,  TRUE),
    PT(55, 43, 5, 3, FALSE),
    PT(25, 30, 5, 2, FALSE),
    PT(63, 27, 5, 1, FALSE),
    PT(51, 31, 6, 1,  TRUE),
    PT(63, 21, 5, 0,  TRUE),
    PT( 1, 30, 3, 0, FALSE),
    PT(31, 34, 3, 0,  TRUE),
    PT(51, 60, 6, 2, FALSE),
    PT(30, 18, 4, 1, FALSE),
    PT(13, 55, 5, 2, FALSE),
    PT(15,  8, 6, 0,  TRUE),
    PT(46,  9, 6, 3, FALSE),
    PT( 1,  5, 3, 3, FALSE),
    PT(28,  4, 3, 3, FALSE),
    PT(12,  1, 3, 2, FALSE),
    PT(41, 40, 5, 3,  TRUE),
    PT(57, 45, 2, 2, FALSE),
    PT( 9, 34, 6, 3, FALSE),
    PT( 4, 55, 6, 3,  TRUE),
    PT(45, 47, 6, 2,  TRUE),
    PT(36, 35, 3, 1,  TRUE),
    PT( 8, 32, 6, 1, FALSE),
    PT(32, 31, 6, 2, FALSE),
    PT( 2, 49, 3, 0,  TRUE),
    PT(24, 19, 6, 3, FALSE),
    PT( 6, 43, 3, 3, FALSE),
    PT(14, 27, 2, 0, FALSE),
    PT(47, 14, 3, 2, FALSE),
    PT(17, 56, 2, 1,  TRUE),
    PT( 1, 55, 3, 0,  TRUE),
    PT(20, 17, 4, 3, FALSE),
    PT(49, 61, 6, 1,  TRUE),
    PT(29, 27, 6, 2, FALSE),
    PT(37, 49, 5, 3,  TRUE),
    PT(17, 10, 5, 3,  TRUE),
    PT(57, 23, 3, 1,  TRUE),
    PT( 5, 14, 2, 1,  TRUE),
    PT(41, 37, 4, 1, FALSE),
    PT(21, 13, 4, 0, FALSE),
    PT(43, 39, 4, 0,  TRUE),
    PT(62, 36, 4, 3,  TRUE),
    PT(42, 43, 2, 3, FALSE),
    PT(36, 61, 2, 2,  TRUE),
    PT(21, 48, 6, 0,  TRUE),
    PT(15, 51, 4, 2, FALSE),
    PT( 6, 22, 2, 1,  TRUE),
    PT( 6, 49, 2, 0, FALSE),
    PT(46, 63, 2, 0, FALSE),
    PT( 5, 13, 5, 3,  TRUE),
    PT(60, 31, 3, 0,  TRUE),
    PT(18, 19, 4, 2, FALSE),
    PT(15, 51, 6, 3, FALSE),
    PT(21, 59, 6, 1,  TRUE),
    PT( 3, 15, 5, 1, FALSE),
    PT(59, 60, 5, 2, FALSE),
    PT(54,  9, 5, 0,  TRUE),
    PT(17, 59, 4, 3,  TRUE),
    PT(40, 43, 6, 0,  TRUE),
    PT(26, 14, 5, 3,  TRUE),
    PT(57, 44, 6, 0,  TRUE),
    PT(14, 60, 6, 2,  TRUE),
    PT(44, 36, 6, 1,  TRUE),
    PT(61, 17, 5, 1,  TRUE),
    PT( 7, 60, 6, 3,  TRUE),
    PT(20, 24, 2, 1,  TRUE),
    PT(29, 63, 5, 3, FALSE),
    PT(48, 18, 4, 2,  TRUE),
    PT(38, 29, 2, 0,  TRUE),
    PT( 7, 17, 3, 3, FALSE),
    PT(52,  1, 2, 0,  TRUE),
    PT(11, 57, 4, 0,  TRUE),
    PT(41,  2, 5, 0,  TRUE),
    PT(21, 16, 3, 1, FALSE),
    PT(48, 31, 6, 2,  TRUE),
    PT(60, 43, 5, 1, FALSE),
    PT(48, 59, 6, 3, FALSE),
    PT(32, 26, 4, 1,  TRUE),
    PT(50, 36, 5, 1,  TRUE),
    PT(21, 32, 3, 2, FALSE),
    PT(37, 61, 6, 3, FALSE),
    PT(45, 20, 6, 0,  TRUE),
    PT(24, 35, 2, 3,  TRUE),
    PT(24,  5, 2, 1,  TRUE),
    PT(52, 48, 6, 3,  TRUE),
    PT(14, 57, 4, 1,  TRUE),
    PT(29, 31, 2, 3,  TRUE),
    PT( 1, 21, 5, 3,  TRUE),
    PT(11, 62, 3, 1,  TRUE),
    PT(13, 25, 5, 3, FALSE),
    PT(49, 56, 3, 2, FALSE),
    PT(21, 52, 2, 2,  TRUE),
    PT(19, 25, 5, 0,  TRUE),
    PT(25, 20, 4, 3,  TRUE),
    PT(21, 24, 4, 1,  TRUE),
    PT(41, 12, 4, 3,  TRUE),
    PT(45, 14, 2, 3,  TRUE),
    PT(52, 24, 2, 0, FALSE),
    PT(59, 30, 5, 0,  TRUE),
    PT(52, 44, 4, 1, FALSE),
    PT(49,  8, 2, 1,  TRUE),
    PT(29, 24, 3, 1, FALSE),
    PT(28, 11, 5, 1, FALSE),
    PT(25, 30, 3, 1, FALSE),
    PT(35, 39, 2, 3,  TRUE),
    PT(59, 14, 6, 3,  TRUE),
    PT(25, 43, 2, 3, FALSE),
    PT(47,  8, 4, 0,  TRUE),
    PT(55,  2, 4, 0, FALSE),
    PT(11, 50, 6, 0, FALSE),
    PT(22,  5, 6, 0, FALSE),
    PT(19,  5, 3, 1, FALSE),
    PT( 7, 57, 3, 0,  TRUE),
    PT(12, 59, 5, 1, FALSE),
    PT(21,  5, 6, 0, FALSE),
    PT(48,  5, 3, 0,  TRUE),
    PT(19,  0, 2, 1, FALSE),
    PT(39, 22, 5, 1, FALSE),
    PT(15, 40, 4, 3,  TRUE),
    PT(12, 35, 5, 3,  TRUE),
    PT(57, 40, 5, 1, FALSE),
    PT(36, 37, 3, 3,  TRUE),
    PT(24, 41, 2, 2, FALSE),
    PT(22,  5, 3, 1, FALSE),
    PT(53, 47, 4, 3, FALSE),
    PT(10, 58, 5, 0,  TRUE),
    PT(52, 44, 6, 3, FALSE),
    PT(46, 58, 2, 2,  TRUE),
    PT(26, 10, 5, 2,  TRUE),
    PT(22, 20, 5, 3, FALSE),
    PT(53, 40, 5, 1, FALSE),
    PT(53, 15, 2, 0,  TRUE),
    PT(17, 50, 3, 0,  TRUE),
    PT(32, 26, 5, 0, FALSE),
    PT(23, 26, 5, 0, FALSE),
    PT(22, 51, 4, 2,  TRUE),
    PT(19, 44, 5, 0,  TRUE),
    PT( 9, 22, 6, 1,  TRUE),
    PT(29, 39, 4, 3, FALSE),
    PT(21, 12, 5, 3,  TRUE),
    PT(34, 28, 3, 0,  TRUE),
    PT(41, 51, 2, 0, FALSE),
    PT(45, 17, 3, 1,  TRUE),
    PT(22, 25, 5, 3, FALSE),
    PT(13, 12, 5, 0, FALSE),
    PT(55, 58, 6, 2, FALSE),
    PT(42, 29, 6, 3,  TRUE),
    PT(48, 10, 6, 3, FALSE),
    PT(36, 57, 3, 1,  TRUE),
    PT(57, 10, 6, 1, FALSE),
    PT(17,  3, 5, 2,  TRUE),
    PT(50, 29, 6, 0, FALSE),
    PT(56, 30, 4, 3,  TRUE),
    PT(46, 23, 3, 0, FALSE),
    PT(22, 23, 5, 1, FALSE),
    PT(54, 59, 6, 0,  TRUE),
    PT(23,  4, 3, 0,  TRUE),
    PT(58, 37, 5, 2,  TRUE),
    PT( 0, 54, 4, 3,  TRUE),
    PT(37, 18, 6, 1,  TRUE),
    PT( 6, 10, 2, 2, FALSE),
    PT(17,  5, 5, 3,  TRUE),
    PT( 3, 53, 5, 3,  TRUE),
    PT(11, 52, 5, 0,  TRUE),
    PT( 0, 49, 2, 1,  TRUE),
    PT(39, 15, 3, 2, FALSE),
    PT(29,  6, 5, 2,  TRUE),
    PT(28, 48, 4, 3,  TRUE),
    PT(47, 42, 4, 3,  TRUE),
    PT(22, 32, 6, 0,  TRUE),
    PT(51, 43, 5, 1,  TRUE),
    PT( 5, 48, 6, 3, FALSE),
    PT(41, 35, 6, 2,  TRUE),
    PT(16, 22, 5, 3,  TRUE),
    PT(45, 32, 5, 0,  TRUE),
    PT(55, 19, 4, 2, FALSE),
    PT(45, 14, 4, 2,  TRUE),
    PT( 8, 10, 3, 0, FALSE),
    PT(15,  3, 3, 1,  TRUE),
    PT(49, 12, 6, 3,  TRUE),
    PT(30, 52, 6, 0,  TRUE),
    PT(27, 14, 4, 2,  TRUE),
    PT(26,  7, 6, 2, FALSE),
    PT(13, 60, 6, 1,  TRUE),
    PT( 0, 58, 6, 3, FALSE),
    PT( 4, 39, 2, 1, FALSE),
    PT(35, 24, 4, 2, FALSE),
    PT(13, 11, 3, 0, FALSE),
    PT(49, 50, 6, 3,  TRUE),
    PT( 0, 13, 4, 0,  TRUE),
    PT(50, 16, 2, 1, FALSE),
    PT(38, 13, 3, 0,  TRUE),
    PT(41, 36, 5, 1,  TRUE),
    PT(61, 33, 3, 3,  TRUE),
    PT(30, 27, 5, 0, FALSE),
    PT(13, 18, 5, 0, FALSE),
    PT(53, 30, 4, 1,  TRUE),
    PT(10, 46, 4, 1, FALSE),
    PT(39, 39, 6, 2,  TRUE),
    PT( 1, 14, 4, 0, FALSE),
    PT(49, 57, 5, 0,  TRUE),
    PT(59, 36, 6, 3, FALSE),
    PT(20, 16, 6, 1,  TRUE),
    PT(24, 44, 4, 3, FALSE),
    PT( 4, 45, 2, 2,  TRUE),
    PT(26, 17, 6, 3,  TRUE),
    PT(15, 11, 2, 2, FALSE),
    PT(14, 44, 5, 2, FALSE),
    PT(33, 23, 5, 2, FALSE),
    PT(22, 33, 6, 2,  TRUE),
    PT(62, 16, 2, 0, FALSE),
    PT(10,  5, 3, 3, FALSE),
    PT(59,  9, 2, 1,  TRUE),
    PT(38, 24, 3, 3, FALSE),
    PT(35, 12, 3, 1, FALSE),
    PT(51, 55, 3, 3,  TRUE),
    PT( 9, 18, 6, 2,  TRUE),
    PT(61, 13, 2, 2,  TRUE),
    PT(54,  6, 4, 2, FALSE),
    PT(51, 48, 5, 0,  TRUE),
    PT(59, 15, 5, 0, FALSE),
    PT(52, 42, 5, 2, FALSE),
    PT( 2, 18, 6, 2,  TRUE),
    PT( 9, 34, 6, 0,  TRUE),
    PT(59, 49, 3, 2, FALSE),
    PT(51, 34, 4, 3,  TRUE),
    PT(61, 52, 2, 2,  TRUE),
    PT(20, 34, 5, 0, FALSE),
    PT(40, 16, 3, 3, FALSE),
    PT(33, 49, 2, 0, FALSE),
    PT(45, 22, 4, 0,  TRUE),
    PT(30,  5, 6, 1,  TRUE),
    PT(15, 48, 6, 0,  TRUE),
    PT(14, 26, 6, 2,  TRUE),
    PT(56, 46, 5, 0, FALSE),
    PT(38, 55, 3, 3, FALSE),
    PT(43, 19, 6, 1,  TRUE),
    PT(31, 30, 6, 3,  TRUE),
    PT(10, 40, 4, 2, FALSE),
    PT(50, 28, 3, 1, FALSE),
    PT(31, 63, 3, 0,  TRUE),
    PT(57, 57, 5, 0,  TRUE),
    PT(44, 27, 2, 2, FALSE),
    PT(21, 42, 2, 3,  TRUE),
    PT(50, 15, 4, 0,  TRUE),
    PT(48, 33, 3, 0, FALSE),
    PT(35, 42, 4, 3,  TRUE),
    PT(61,  7, 2, 0, FALSE),
    PT(11, 63, 5, 3,  TRUE),
    PT(49,  2, 5, 3, FALSE),
    PT( 8, 57, 5, 3,  TRUE),
    PT(63, 32, 3, 0, FALSE),
    PT(45, 52, 2, 0,  TRUE),
    PT(46, 52, 2, 0, FALSE),
    PT(38, 18, 4, 1,  TRUE),
    PT(37, 10, 6, 3,  TRUE),
    PT(52,  9, 4, 2,  TRUE),
    PT(10, 62, 2, 3, FALSE),
    PT(26, 23, 2, 0,  TRUE),
    PT(56, 28, 4, 0, FALSE),
    PT(17, 33, 4, 3, FALSE),
    PT( 5, 15, 3, 0, FALSE),
    PT(38, 43, 6, 1, FALSE),
    PT(10, 12, 2, 3, FALSE),
    PT( 3, 41, 3, 2,  TRUE),
    PT(41, 59, 4, 1,  TRUE),
    PT(22, 27, 5, 0,  TRUE),
    PT( 7,  9, 2, 3,  TRUE),
    PT(23, 44, 3, 2, FALSE),
    PT(53, 51, 6, 0, FALSE),
    PT(23, 18, 3, 3, FALSE),
    PT(61, 26, 5, 1,  TRUE),
    PT(33, 29, 2, 0, FALSE),
    PT(10,  8, 2, 3,  TRUE),
    PT(20, 60, 6, 3, FALSE),
    PT(40, 54, 6, 3, FALSE),
    PT(59, 32, 3, 1,  TRUE),
    PT(19, 34, 3, 2,  TRUE),
    PT(19, 58, 2, 2,  TRUE),
    PT( 2, 35, 5, 2, FALSE),
    PT(62, 25, 2, 2, FALSE),
    PT(57, 60, 3, 1, FALSE),
    PT(16,  8, 3, 3, FALSE),
    PT(10, 19, 5, 0,  TRUE),
    PT(63, 56, 5, 2, FALSE),
    PT( 7, 35, 3, 3,  TRUE),
    PT(25, 42, 4, 2, FALSE),
    PT(20, 60, 3, 3,  TRUE),
    PT(13,  4, 6, 3,  TRUE),
    PT(26, 47, 5, 0, FALSE),
    PT(42, 29, 3, 3, FALSE),
    PT(17, 55, 5, 0,  TRUE),
    PT(40, 39, 2, 1, FALSE),
    PT(13,  0, 4, 3, FALSE),
    PT(10, 60, 4, 3, FALSE),
    PT(31, 28, 6, 1,  TRUE),
    PT( 4, 58, 5, 2, FALSE),
    PT(36, 61, 5, 1,  TRUE),
    PT(38, 49, 5, 3,  TRUE),
    PT(19, 28, 4, 0,  TRUE),
    PT(62, 18, 4, 1,  TRUE),
    PT(54, 10, 3, 1, FALSE),
    PT(45, 30, 3, 0,  TRUE),
    PT( 5, 31, 3, 1,  TRUE),
    PT(30, 10, 3, 3,  TRUE),
    PT(32,  8, 4, 2, FALSE),
    PT(44, 12, 6, 1,  TRUE),
    PT(29, 31, 2, 0,  TRUE),
    PT(14, 18, 2, 0, FALSE),
    PT(39, 18, 3, 0,  TRUE),
    PT(42, 19, 6, 0,  TRUE),
    PT(28,  4, 6, 0, FALSE),
    PT(26, 56, 3, 3,  TRUE),
    PT(44, 53, 4, 2,  TRUE),
    PT( 7, 11, 6, 1,  TRUE),
    PT(45,  2, 3, 1, FALSE),
    PT(42, 53, 6, 2,  TRUE),
    PT(22, 47, 2, 2, FALSE),
    PT(17, 49, 6, 1,  TRUE),
    PT(44, 49, 3, 3, FALSE),
    PT(60, 58, 4, 3,  TRUE),
    PT(60, 43, 2, 1, FALSE),
    PT(39, 29, 2, 1, FALSE),
    PT(54, 44, 5, 1,  TRUE),
    PT(37, 59, 6, 2,  TRUE),
    PT(18, 61, 4, 3,  TRUE),
    PT(19, 35, 3, 0,  TRUE),
    PT(51, 44, 4, 3, FALSE),
    PT( 9, 60, 2, 1, FALSE),
    PT(21, 26, 4, 1,  TRUE),
    PT(33,  7, 3, 1, FALSE),
    PT(34, 37, 4, 0, FALSE),
    PT(25, 27, 5, 2, FALSE),
    PT(58, 25, 6, 2,  TRUE),
    PT( 5, 38, 3, 2,  TRUE),
    PT(35, 34, 4, 2,  TRUE),
    PT(14, 30, 2, 0,  TRUE),
    PT(19, 48, 2, 1, FALSE),
    PT(44, 34, 4, 2,  TRUE),
    PT(10, 29, 3, 0, FALSE),
    PT(35, 62, 3, 2,  TRUE),
    PT( 2, 40, 4, 2,  TRUE),
    PT(33, 14, 4, 0, FALSE),
    PT(33, 34, 6, 3,  TRUE),
    PT(24, 51, 4, 3,  TRUE),
    PT(35, 35, 6, 0,  TRUE),
    PT(36, 26, 3, 1, FALSE),
    PT(62, 37, 4, 2, FALSE),
    PT(36,  1, 3, 0, FALSE),
    PT(52, 16, 4, 1, FALSE),
    PT( 7,  0, 6, 3,  TRUE),
    PT( 6, 32, 4, 0, FALSE),
    PT(58,  2, 5, 1,  TRUE),
    PT( 7, 44, 5, 2, FALSE),
    PT( 9, 47, 5, 1, FALSE),
    PT( 1, 50, 5, 2, FALSE),
    PT( 0, 53, 2, 1,  TRUE),
    PT(43, 60, 3, 3,  TRUE),
    PT(54, 55, 3, 3, FALSE),
    PT(32, 53, 3, 2,  TRUE),
    PT(12,  7, 6, 1,  TRUE),
    PT(22,  8, 2, 1, FALSE),
    PT(63, 54, 2, 0,  TRUE),
    PT(11, 31, 5, 2,  TRUE),
    PT(33, 32, 6, 1,  TRUE),
    PT(23, 26, 5, 3, FALSE),
    PT(22,  1, 5, 3,  TRUE),
    PT(47, 28, 6, 2, FALSE),
    PT(41, 49, 5, 3, FALSE),
    PT(59, 56, 6, 0,  TRUE),
    PT(13, 22, 2, 1, FALSE),
    PT( 7, 41, 4, 2, FALSE),
    PT(51, 60, 6, 2, FALSE),
    PT(62, 30, 3, 0, FALSE),
    PT(48,  2, 6, 2, FALSE),
    PT(42, 52, 3, 1,  TRUE),
    PT(46, 35, 3, 0, FALSE),
    PT(52,  0, 3, 3,  TRUE),
    PT(32, 14, 5, 0, FALSE),
    PT(21, 51, 6, 3,  TRUE),
    PT(39, 53, 4, 1,  TRUE),
    PT(55, 62, 2, 0,  TRUE),
    PT(50, 46, 6, 3, FALSE),
    PT(58,  2, 5, 1,  TRUE),
    PT( 0, 54, 3, 2,  TRUE),
    PT(19, 41, 2, 3, FALSE),
    PT( 8, 43, 6, 3,  TRUE),
    PT( 8,  2, 4, 3,  TRUE),
    PT(50, 45, 6, 2, FALSE),
    PT(48, 54, 5, 0,  TRUE),
    PT(46, 16, 2, 1, FALSE),
    PT(60, 46, 5, 1, FALSE),
    PT( 4, 51, 6, 0, FALSE),
    PT(63,  1, 4, 1, FALSE),
    PT(55, 20, 3, 2,  TRUE),
    PT(39,  0, 5, 3,  TRUE),
    PT(12, 57, 4, 3, FALSE),
    PT(39,  4, 4, 0,  TRUE),
    PT(25,  8, 3, 2,  TRUE),
    PT( 1,  4, 3, 3, FALSE),
    PT(39, 27, 5, 1,  TRUE),
    PT(49, 23, 3, 3,  TRUE),
    PT( 7,  1, 5, 2,  TRUE),
    PT(46, 59, 3, 3,  TRUE),
    PT(52, 36, 6, 0,  TRUE),
    PT(50, 43, 4, 2, FALSE),
    PT(14,  7, 3, 3, FALSE),
    PT(15, 51, 2, 0, FALSE),
    PT(22, 33, 6, 1, FALSE),
    PT(57,  2, 3, 1, FALSE),
    PT(51, 61, 4, 1, FALSE),
    PT(12, 37, 3, 1, FALSE),
    PT(41, 41, 5, 0, FALSE),
    PT(58, 50, 4, 3, FALSE),
    PT(11, 19, 4, 1, FALSE),
    PT(31, 15, 3, 2, FALSE),
    PT( 4, 44, 4, 0, FALSE),
    PT(57, 26, 3, 1,  TRUE),
    PT(26, 42, 3, 3,  TRUE),
    PT(36, 19, 3, 1, FALSE),
    PT(49, 59, 6, 1,  TRUE),
    PT(57, 35, 5, 0, FALSE),
    PT(49,  7, 6, 0,  TRUE),
    PT(31, 16, 4, 0, FALSE),
    PT(41, 23, 6, 1, FALSE),
    PT(38, 59, 5, 2,  TRUE),
    PT( 2, 60, 3, 2, FALSE),
    PT(14,  0, 4, 0, FALSE),
    PT(20, 62, 6, 3,  TRUE),
    PT( 1, 15, 5, 2,  TRUE),
    PT( 6, 18, 4, 3,  TRUE),
    PT(48, 19, 3, 0,  TRUE),
    PT( 0, 51, 5, 1, FALSE),
    PT(12,  7, 4, 3,  TRUE),
    PT(17, 58, 3, 2, FALSE),
    PT(21, 10, 2, 1,  TRUE),
    PT(31, 13, 5, 1, FALSE),
    PT(55,  7, 5, 1, FALSE),
    PT(52, 53, 6, 2, FALSE),
    PT(40, 22, 4, 3,  TRUE),
    PT( 6,  2, 6, 3, FALSE),
    PT( 9, 35, 6, 0, FALSE),
    PT(20,  2, 5, 0, FALSE),
    PT(57, 50, 6, 2, FALSE),
    PT(36, 53, 2, 1, FALSE),
    PT(18, 34, 4, 3, FALSE),
    PT( 9,  7, 6, 1,  TRUE),
    PT(15, 62, 3, 3, FALSE),
    PT( 0, 60, 6, 1,  TRUE),
    PT(16, 55, 2, 2, FALSE),
    PT(58,  3, 4, 2,  TRUE),
    PT(45, 30, 4, 2, FALSE),
    PT(54, 54, 4, 3, FALSE),
    PT(31, 60, 3, 1, FALSE),
    PT(55, 51, 4, 2,  TRUE),
    PT(35, 19, 3, 3,  TRUE),
    PT(51, 13, 2, 1,  TRUE),
    PT(37, 48, 3, 3, FALSE),
    PT(23,  3, 3, 0, FALSE),
    PT(24, 24, 2, 2, FALSE),
    PT(48,  7, 4, 1, FALSE),
    PT(62, 51, 4, 0,  TRUE),
    PT(20, 55, 2, 3, FALSE),
    PT(22,  0, 2, 1, FALSE),
    PT(44, 18, 5, 3,  TRUE),
    PT(37, 63, 3, 3, FALSE),
    PT(36, 25, 2, 3, FALSE),
    PT(22, 15, 6, 2,  TRUE),
    PT(45, 16, 2, 0,  TRUE),
    PT(36, 42, 5, 0, FALSE),
    PT(25, 37, 5, 3, FALSE),
    PT(12, 22, 3, 3,  TRUE),
    PT(56, 33, 6, 3, FALSE),
    PT(61, 26, 5, 3,  TRUE),
    PT(59, 50, 2, 1, FALSE),
    PT(54, 19, 5, 0,  TRUE),
    PT(14, 48, 6, 0,  TRUE),
    PT(25,  7, 5, 3,  TRUE),
    PT(37, 35, 5, 0, FALSE),
    PT(32,  8, 5, 0,  TRUE),
    PT(42,  0, 6, 0, FALSE),
    PT(48, 56, 4, 1,  TRUE),
    PT(30, 15, 3, 3,  TRUE),
    PT(59, 27, 6, 0, FALSE),
    PT(58, 55, 5, 3,  TRUE),
    PT(57, 55, 6, 2,  TRUE),
    PT(57, 45, 5, 3,  TRUE),
    PT(31, 46, 3, 3, FALSE),
    PT(26, 43, 3, 3, FALSE),
    PT(20, 23, 4, 0, FALSE),
    PT(47,  3, 2, 0,  TRUE),
    PT(29,  0, 6, 0, FALSE),
    PT(23, 43, 3, 2,  TRUE),
    PT(53, 40, 4, 2,  TRUE),
    PT(59, 15, 2, 0,  TRUE),
    PT( 9,  4, 5, 3, FALSE),
    PT(35, 17, 3, 3, FALSE),
    PT(19, 55, 3, 3, FALSE),
    PT(55, 55, 3, 3, FALSE),
    PT( 7,  1, 6, 1, FALSE),
    PT(20,  6, 6, 1, FALSE),
    PT(17, 12, 5, 3, FALSE),
    PT(54, 46, 4, 2, FALSE),
    PT(21, 42, 3, 2, FALSE),
    PT(34, 21, 6, 2, FALSE),
    PT(44, 30, 6, 2,  TRUE),
    PT(34, 39, 6, 1,  TRUE),
    PT(25, 63, 5, 2,  TRUE),
    PT(33, 51, 2, 2,  TRUE),
    PT(38, 26, 2, 0,  TRUE),
    PT(22, 62, 2, 1, FALSE),
    PT(43, 36, 2, 2,  TRUE),
    PT(60, 15, 5, 2,  TRUE),
    PT(49, 21, 6, 3, FALSE),
    PT(63, 36, 3, 2,  TRUE),
    PT(37,  1, 6, 3,  TRUE),
    PT(51, 22, 3, 1, FALSE),
    PT(31, 14, 2, 0, FALSE),
    PT(47, 11, 2, 1, FALSE),
    PT(42, 26, 4, 2,  TRUE),
    PT(23, 10, 6, 2,  TRUE),
    PT( 9, 40, 6, 2,  TRUE),
    PT( 2, 19, 6, 3, FALSE),
    PT(52, 47, 2, 3,  TRUE),
    PT( 3,  4, 6, 0,  TRUE),
    PT(62, 38, 2, 0,  TRUE),
    PT(53, 51, 6, 0,  TRUE),
    PT(34, 23, 4, 1,  TRUE),
    PT(29,  5, 5, 1,  TRUE),
    PT(46, 39, 4, 0, FALSE),
    PT( 3, 43, 3, 2,  TRUE),
    PT( 1, 25, 3, 3, FALSE),
    PT(14,  5, 3, 0, FALSE),
    PT(22, 37, 2, 3,  TRUE),
    PT( 2, 40, 3, 0, FALSE),
    PT(25, 11, 4, 2, FALSE),
    PT(62, 53, 2, 3, FALSE),
    PT(46, 41, 4, 2,  TRUE),
    PT(62, 56, 3, 3, FALSE),
    PT(58, 47, 2, 1, FALSE),
    PT(20, 23, 5, 2,  TRUE),
    PT(17, 18, 6, 0, FALSE),
    PT(21, 49, 3, 0, FALSE),
    PT( 8, 11, 5, 0,  TRUE),
    PT(45,  0, 6, 1,  TRUE),
    PT(44,  6, 3, 1, FALSE),
    PT(20, 28, 5, 3, FALSE),
    PT( 4,  8, 2, 1, FALSE),
    PT(27, 43, 5, 2,  TRUE),
    PT(42, 55, 6, 1,  TRUE),
    PT(16, 39, 5, 2, FALSE),
    PT(29, 14, 6, 2, FALSE),
    PT(32,  2, 2, 1, FALSE),
    PT(30, 26, 5, 3, FALSE),
    PT( 7, 11, 2, 0, FALSE),
    PT(54, 30, 6, 1,  TRUE),
    PT(43, 40, 3, 1,  TRUE),
    PT(49, 37, 3, 3,  TRUE),
    PT(56, 58, 5, 3,  TRUE),
    PT(57, 48, 5, 3,  TRUE),
    PT(18,  9, 2, 2, FALSE),
    PT(14,  8, 3, 0,  TRUE),
    PT( 0, 13, 5, 2, FALSE),
    PT(27, 14, 6, 2, FALSE),
    PT(17, 37, 2, 2,  TRUE),
    PT(12, 45, 4, 3, FALSE),
    PT(54, 44, 2, 3, FALSE),
    PT(49, 49, 5, 2, FALSE),
    PT( 3, 26, 2, 3, FALSE),
    PT(28, 50, 2, 2, FALSE),
    PT(10, 62, 6, 3, FALSE),
    PT(51, 27, 4, 3,  TRUE),
    PT(31, 50, 3, 0, FALSE),
    PT(51, 38, 6, 1,  TRUE),
    PT(26, 19, 3, 1, FALSE),
    PT(15, 52, 3, 2, FALSE),
    PT(53, 44, 5, 3,  TRUE),
    PT(56,  3, 3, 0, FALSE),
    PT(21, 15, 4, 3,  TRUE),
    PT(49, 41, 4, 0, FALSE),
    PT(40, 14, 5, 0, FALSE),
    PT(49, 44, 5, 3, FALSE),
    PT(21, 25, 3, 1,  TRUE),
    PT(16,  3, 5, 3,  TRUE),
    PT(46, 42, 6, 1, FALSE),
    PT(42, 39, 3, 1,  TRUE),
    PT(54,  4, 3, 3, FALSE),
    PT(59,  4, 4, 0,  TRUE),
    PT( 7, 47, 3, 0,  TRUE),
    PT(39, 29, 3, 2,  TRUE),
    PT(60, 61, 5, 3, FALSE),
    PT(37,  8, 6, 1, FALSE),
    PT(59, 52, 5, 1, FALSE),
    PT(12, 16, 2, 1,  TRUE),
    PT(37, 53, 3, 1, FALSE),
    PT(47, 25, 5, 0, FALSE),
    PT(23,  0, 5, 1,  TRUE),
    PT(10, 28, 2, 3,  TRUE),
    PT(10, 17, 3, 1,  TRUE),
    PT(53, 19, 6, 3,  TRUE),
    PT(41, 28, 5, 0, FALSE),
    PT(12, 49, 6, 2,  TRUE),
    PT(60, 16, 3, 1, FALSE),
    PT(27, 58, 5, 2,  TRUE),
    PT(58, 28, 3, 0, FALSE),
    PT(34, 16, 5, 2,  TRUE),
    PT(28, 60, 2, 1, FALSE),
    PT(23, 24, 5, 1, FALSE),
    PT(11, 43, 5, 3,  TRUE),
    PT(45,  4, 5, 3, FALSE),
    PT(60, 19, 4, 1,  TRUE),
    PT( 1, 28, 5, 3, FALSE),
    PT(20, 22, 4, 1, FALSE),
    PT(12, 36, 2, 1,  TRUE),
    PT(53, 55, 6, 2, FALSE),
    PT(27, 48, 3, 3, FALSE),
    PT(58, 28, 4, 0, FALSE),
    PT( 6,  6, 6, 3, FALSE),
    PT( 9, 21, 3, 1, FALSE),
    PT(27, 26, 4, 3,  TRUE),
    PT(15, 51, 6, 2,  TRUE),
    PT(55,  6, 4, 1,  TRUE),
    PT(58, 18, 3, 2,  TRUE),
    PT( 0, 22, 5, 0,  TRUE),
    PT(14, 29, 6, 2,  TRUE),
    PT(63, 56, 2, 3, FALSE),
    PT(42, 60, 6, 2, FALSE),
    PT(19, 50, 2, 0, FALSE),
    PT(23, 44, 6, 3,  TRUE),
    PT(41, 42, 3, 3, FALSE),
    PT(53, 47, 5, 2,  TRUE),
    PT(60, 42, 2, 0,  TRUE),
    PT(40, 19, 4, 0,  TRUE),
    PT(25, 30, 6, 2, FALSE),
    PT(12,  6, 5, 2,  TRUE),
    PT( 9,  4, 3, 2, FALSE),
    PT(29, 47, 4, 3, FALSE),
    PT(57,  7, 2, 3, FALSE),
    PT(20,  4, 5, 2,  TRUE),
    PT(58, 47, 5, 3, FALSE),
    PT(41, 21, 6, 2,  TRUE),
    PT(36,  2, 6, 3, FALSE),
    PT(63,  2, 3, 1, FALSE),
    PT(15, 24, 4, 2, FALSE),
    PT(22, 29, 3, 0,  TRUE),
    PT(20, 22, 2, 0, FALSE),
    PT(41, 27, 2, 1,  TRUE),
    PT(21, 14, 3, 0,  TRUE),
    PT(58, 46, 5, 1,  TRUE),
    PT( 8, 48, 2, 2,  TRUE),
    PT(53, 22, 6, 0, FALSE),
    PT(46, 24, 6, 2,  TRUE),
    PT(59, 11, 3, 2, FALSE),
    PT(58, 24, 2, 1,  TRUE),
    PT(41, 19, 3, 3, FALSE),
    PT(32, 19, 4, 3,  TRUE),
    PT( 4, 29, 6, 2, FALSE),
    PT( 0, 56, 3, 0,  TRUE),
    PT( 8, 57, 6, 1, FALSE),
    PT(32, 16, 4, 3, FALSE),
    PT( 8,  2, 5, 0, FALSE),
    PT(63, 15, 2, 3, FALSE),
    PT(48, 31, 3, 0,  TRUE),
    PT(32, 45, 2, 0, FALSE),
    PT(56, 23, 3, 2, FALSE),
    PT(24, 49, 4, 3,  TRUE),
    PT(51, 56, 6, 0, FALSE),
    PT(22, 51, 4, 1,  TRUE),
    PT( 0,  1, 6, 3, FALSE),
    PT(13,  2, 4, 1,  TRUE),
    PT(57,  4, 3, 3,  TRUE),
    PT(14, 48, 4, 2, FALSE),
    PT( 6,  1, 5, 2, FALSE),
    PT(52, 51, 6, 2,  TRUE),
    PT(22, 52, 5, 3, FALSE),
    PT(50, 22, 4, 2, FALSE),
    PT(38, 57, 6, 2, FALSE),
    PT(31, 60, 3, 2,  TRUE),
    PT(40, 29, 6, 3,  TRUE),
    PT(23, 21, 5, 1,  TRUE),
    PT(39, 57, 6, 0, FALSE),
    PT(11, 27, 3, 0, FALSE),
    PT(53, 32, 5, 2,  TRUE),
    PT(11, 53, 3, 2, FALSE),
    PT( 3, 14, 4, 0,  TRUE),
    PT( 6, 12, 4, 0, FALSE),
    PT( 2, 24, 6, 2, FALSE),
    PT(30, 54, 5, 2,  TRUE),
    PT(22, 12, 3, 0,  TRUE),
    PT(37,  9, 5, 2, FALSE),
    PT(55,  5, 5, 3, FALSE),
    PT(46, 43, 5, 2, FALSE),
    PT(36, 26, 2, 2, FALSE),
    PT(39,  4, 2, 0, FALSE),
    PT(50, 56, 6, 1,  TRUE),
    PT(55, 21, 6, 2,  TRUE),
    PT(17, 63, 3, 2,  TRUE),
    PT(35, 35, 3, 3,  TRUE),
    PT(41, 63, 3, 2,  TRUE),
    PT(26, 60, 5, 1,  TRUE),
    PT(27, 44, 5, 2, FALSE),
    PT(56, 59, 6, 3, FALSE),
    PT( 4, 19, 6, 1,  TRUE),
    PT(44, 20, 2, 1, FALSE),
    PT(26,  9, 3, 1,  TRUE),
    PT(54, 17, 4, 2, FALSE),
    PT(58, 63, 2, 0,  TRUE),
    PT( 1, 14, 5, 1,  TRUE),
    PT(59,  3, 5, 1, FALSE),
    PT( 8, 13, 5, 1,  TRUE),
    PT(43, 19, 4, 3,  TRUE),
    PT(58, 60, 3, 2, FALSE),
    PT(58, 21, 5, 1, FALSE),
    PT(36,  0, 2, 3,  TRUE),
    PT(62, 10, 2, 2,  TRUE),
    PT(12, 41, 5, 2,  TRUE),
    PT(31, 21, 6, 0, FALSE),
    PT(53, 24, 3, 0,  TRUE),
    PT(61, 55, 6, 3,  TRUE),
    PT(18, 56, 3, 1,  TRUE),
    PT(59,  2, 4, 0, FALSE),
    PT( 8, 33, 3, 0,  TRUE),
    PT(46, 54, 3, 2,  TRUE),
    PT(21, 61, 4, 2, FALSE),
    PT(34, 12, 4, 3,  TRUE),
    PT(54, 63, 6, 1,  TRUE),
    PT(51, 18, 2, 0,  TRUE),
    PT(26, 25, 3, 3,  TRUE),
    PT(43, 36, 2, 1, FALSE),
    PT(17, 42, 3, 0, FALSE),
    PT(37, 50, 5, 1, FALSE),
    PT(44, 26, 2, 1, FALSE),
    PT(38,  6, 2, 0, FALSE),
    PT(17, 41, 6, 1,  TRUE),
    PT(44,  9, 2, 2, FALSE),
    PT(43, 18, 5, 1,  TRUE),
    PT(29,  3, 4, 2, FALSE),
    PT( 0, 18, 2, 2,  TRUE),
    PT(34, 61, 4, 3, FALSE),
    PT(21, 55, 3, 1, FALSE),
    PT(15, 18, 6, 3,  TRUE),
    PT(36,  1, 3, 0, FALSE),
    PT(42, 23, 2, 1,  TRUE),
    PT(20, 59, 5, 0,  TRUE),
    PT(42, 25, 6, 1, FALSE),
    PT(45, 23, 2, 3,  TRUE),
    PT(11, 44, 6, 1,  TRUE),
    PT( 7, 45, 6, 2, FALSE),
    PT( 7, 56, 3, 2,  TRUE),
    PT(31, 54, 4, 1, FALSE),
    PT(17, 10, 2, 3,  TRUE),
    PT(20, 17, 2, 1,  TRUE),
    PT(42, 23, 4, 2,  TRUE),
    PT( 1, 58, 3, 2, FALSE),
    PT(38, 39, 6, 0, FALSE),
    PT(45, 59, 6, 2,  TRUE),
    PT(58, 48, 6, 2, FALSE),
    PT( 6, 58, 3, 2, FALSE),
    PT(45,  5, 2, 1,  TRUE),
    PT(33, 50, 2, 1, FALSE),
    PT(62, 30, 5, 2, FALSE),
    PT(58, 63, 5, 2,  TRUE),
    PT(32, 42, 6, 2, FALSE),
    PT(38,  3, 3, 1, FALSE),
    PT(25, 39, 5, 3, FALSE),
    PT(49,  4, 4, 3, FALSE),
    PT(42, 63, 6, 0, FALSE),
    PT(37, 35, 5, 1, FALSE),
    PT( 8,  8, 6, 2,  TRUE),
    PT(44, 48, 3, 3, FALSE),
    PT( 8,  5, 3, 0, FALSE),
    PT( 6,  9, 5, 2,  TRUE),
    PT(25,  0, 4, 3,  TRUE),
    PT(13, 16, 3, 0,  TRUE),
    PT(28,  0, 2, 1,  TRUE),
    PT(61, 11, 4, 2, FALSE),
    PT(46, 31, 2, 3, FALSE),
    PT(61, 24, 6, 2, FALSE),
    PT(18, 30, 2, 2,  TRUE),
    PT(21, 57, 4, 2,  TRUE),
    PT(51, 15, 2, 3,  TRUE),
    PT(26, 28, 3, 1,  TRUE),
    PT(55, 41, 3, 1,  TRUE),
    PT(59, 56, 2, 1, FALSE),
    PT(29, 34, 6, 2, FALSE),
    PT(38, 10, 6, 0,  TRUE),
    PT(22, 45, 2, 1,  TRUE),
    PT(13, 32, 4, 3,  TRUE),
    PT(36, 29, 2, 3, FALSE),
    PT(46, 43, 3, 0, FALSE),
    PT(22, 42, 3, 1,  TRUE),
    PT(36, 23, 6, 3, FALSE),
    PT( 2,  5, 5, 1,  TRUE),
    PT(55, 26, 2, 3,  TRUE),
    PT(17, 61, 5, 2, FALSE),
    PT(30, 47, 4, 1, FALSE),
    PT(44, 41, 3, 1, FALSE),
    PT(47,  4, 4, 2,  TRUE),
    PT(54, 12, 6, 2,  TRUE),
    PT(48, 62, 2, 1, FALSE),
    PT(17, 48, 6, 3,  TRUE),
    PT(18, 33, 5, 3, FALSE),
    PT(33, 48, 2, 3,  TRUE),
    PT(44, 61, 4, 2, FALSE),
    PT(17, 35, 2, 2, FALSE),
    PT(26, 50, 2, 3,  TRUE),
    PT(57, 39, 3, 0, FALSE),
    PT(15, 36, 3, 0,  TRUE),
    PT( 0, 61, 6, 3,  TRUE),
    PT(44, 60, 3, 2, FALSE),
    PT(11, 57, 4, 1,  TRUE),
    PT(14,  4, 3, 3,  TRUE),
    PT(28, 49, 2, 2, FALSE),
    PT( 0,  4, 2, 2,  TRUE),
    PT(38, 42, 5, 1, FALSE),
    PT(32, 37, 5, 1, FALSE),
    PT(11, 60, 6, 1,  TRUE),
    PT(17, 11, 5, 3, FALSE),
    PT(55, 34, 5, 3, FALSE),
    PT(14, 34, 4, 3, FALSE),
    PT(24, 45, 4, 3,  TRUE),
    PT( 6, 12, 3, 2, FALSE),
    PT(38, 24, 5, 3,  TRUE),
    PT(58,  1, 5, 1, FALSE),
    PT(47, 49, 6, 2, FALSE),
    PT(31, 52, 3, 1, FALSE),
    PT(49,  5, 2, 0, FALSE),
    PT(46, 23, 6, 2, FALSE),
    PT(24, 34, 4, 1,  TRUE),
    PT(35, 33, 6, 1, FALSE),
    PT( 7,  8, 4, 1, FALSE),
    PT(38, 28, 4, 1, FALSE),
    PT(49, 18, 5, 3,  TRUE),
    PT( 8, 31, 2, 0, FALSE),
    PT(39, 21, 5, 1, FALSE),
    PT(31, 11, 4, 3, FALSE),
    PT(47, 20, 6, 2,  TRUE),
    PT(36, 31, 4, 3, FALSE),
    PT(59, 35, 6, 1,  TRUE),
    PT(32, 62, 5, 2,  TRUE),
    PT(23, 12, 2, 2,  TRUE),
    PT(19, 57, 3, 1, FALSE),
    PT(48, 20, 4, 2,  TRUE),
    PT( 9,  7, 2, 3,  TRUE),
    PT(56, 56, 3, 3,  TRUE),
    PT(41, 36, 4, 3,  TRUE),
    PT(23, 39, 5, 0, FALSE),
    PT(27, 18, 5, 1, FALSE),
    PT(43, 61, 5, 2,  TRUE),
    PT(25, 52, 3, 2, FALSE),
    PT( 1, 29, 2, 0, FALSE),
    PT( 8, 57, 2, 0,  TRUE),
    PT(14, 54, 3, 1,  TRUE),
    PT(38, 19, 2, 0, FALSE),
    PT(22, 40, 3, 3, FALSE),
    PT(60, 40, 2, 3,  TRUE),
    PT(62, 57, 6, 2, FALSE),
    PT(10,  3, 5, 3, FALSE),
    PT(55, 26, 2, 1,  TRUE),
    PT(43, 51, 4, 3, FALSE),
    PT(19, 44, 4, 0,  TRUE),
    PT(37, 20, 2, 0, FALSE),
    PT(22, 11, 6, 2,  TRUE),
    PT(29, 53, 6, 1,  TRUE),
    PT(33,  8, 6, 1,  TRUE),
    PT(40, 33, 3, 1, FALSE),
    PT(18, 12, 3, 1,  TRUE),
    PT(54, 42, 3, 0,  TRUE),
    PT(44, 43, 4, 1,  TRUE),
    PT( 1, 15, 4, 3, FALSE),
    PT(23, 12, 3, 0, FALSE),
    PT( 9, 15, 2, 0,  TRUE),
    PT(43, 36, 3, 2, FALSE),
    PT( 9,  9, 2, 2,  TRUE),
    PT(54,  8, 2, 1,  TRUE),
    PT(32, 57, 4, 0,  TRUE),
    PT( 0, 58, 3, 3,  TRUE),
    PT(43, 54, 6, 0,  TRUE),
    PT( 2, 55, 2, 1,  TRUE),
    PT( 4, 52, 6, 2,  TRUE),
    PT(55, 61, 3, 1, FALSE),
    PT(23, 61, 2, 1,  TRUE),
    PT(43, 54, 5, 3,  TRUE),
    PT(19, 30, 2, 1,  TRUE),
    PT(62, 17, 6, 1,  TRUE),
    PT(39, 58, 5, 2,  TRUE),
    PT(30, 49, 3, 1, FALSE),
    PT( 3,  3, 5, 2,  TRUE),
    PT(37, 55, 3, 3,  TRUE),
    PT(17,  1, 4, 1, FALSE),
    PT(28, 18, 2, 3,  TRUE),
    PT(48, 58, 6, 0, FALSE),
    PT(23, 29, 5, 0,  TRUE),
    PT(14, 19, 4, 3,  TRUE),
    PT(26, 46, 4, 2, FALSE),
    PT(45,  0, 3, 2, FALSE),
    PT(23, 40, 3, 2,  TRUE),
    PT( 9, 31, 5, 3, FALSE),
    PT(26, 45, 4, 3, FALSE),
    PT(10, 19, 6, 1, FALSE),
    PT(62,  0, 4, 3,  TRUE),
    PT(11, 59, 6, 0, FALSE),
    PT( 8, 58, 5, 2,  TRUE),
    PT(34, 18, 3, 3, FALSE),
    PT(52, 29, 5, 1,  TRUE),
    PT(38, 34, 6, 2,  TRUE),
    PT(23, 44, 2, 3,  TRUE),
    PT(41, 19, 5, 2,  TRUE),
    PT(45, 16, 2, 0, FALSE),
    PT(32, 49, 4, 1,  TRUE),
    PT(30, 51, 3, 0, FALSE),
    PT(51,  6, 5, 2,  TRUE),
    PT(38, 20, 4, 3,  TRUE),
    PT(34, 29, 5, 1, FALSE),
    PT(45,  6, 3, 0, FALSE),
    PT( 7,  9, 5, 3, FALSE),
    PT(33, 21, 5, 3, FALSE),
    PT(33, 56, 4, 1,  TRUE),
    PT(53, 11, 6, 2, FALSE),
    PT(36, 11, 4, 1, FALSE),
    PT(30,  1, 2, 3,  TRUE),
    PT(11, 36, 2, 0,  TRUE),
    PT(23,  7, 4, 0, FALSE),
    PT(20, 37, 6, 1, FALSE),
    PT(26, 14, 5, 3,  TRUE),
    PT(53, 23, 3, 3,  TRUE),
    PT(12,  8, 4, 0,  TRUE),
    PT(48, 53, 3, 3,  TRUE),
    PT(12, 11, 4, 0, FALSE),
    PT( 4, 16, 2, 0,  TRUE),
    PT(53, 17, 3, 3, FALSE),
    PT(51, 61, 2, 3, FALSE),
    PT(30, 43, 3, 2,  TRUE),
    PT(26, 25, 2, 0, FALSE),
    PT( 4,  6, 4, 1, FALSE),
    PT( 3, 61, 4, 2, FALSE),
    PT(42, 14, 6, 2,  TRUE),
    PT( 3, 62, 2, 3,  TRUE),
    PT(11, 24, 6, 3, FALSE),
    PT(61, 13, 4, 3, FALSE),
    PT(53, 18, 4, 0, FALSE),
    PT(31, 13, 2, 3, FALSE),
    PT(35, 50, 3, 1, FALSE),
    PT( 0, 61, 4, 3, FALSE),
    PT(48, 25, 6, 3, FALSE),
    PT(18, 14, 4, 1,  TRUE),
    PT( 1, 35, 5, 0, FALSE),
    PT(59, 49, 2, 0,  TRUE),
    PT(45, 28, 6, 3, FALSE),
    PT(42,  5, 2, 3, FALSE),
    PT(20, 14, 6, 0, FALSE),
    PT(58, 55, 3, 0,  TRUE),
    PT(31, 48, 4, 2,  TRUE),
    PT(16, 38, 5, 3,  TRUE),
    PT(34, 17, 3, 3,  TRUE),
    PT(46, 43, 3, 3, FALSE),
    PT(22, 22, 4, 0,  TRUE),
    PT(50, 24, 6, 2,  TRUE),
    PT(35, 50, 3, 1, FALSE),
    PT(61, 13, 3, 0,  TRUE),
    PT(57,  9, 4, 1,  TRUE),
    PT(48, 46, 4, 2, FALSE),
    PT(30, 15, 4, 2, FALSE),
    PT( 9, 33, 6, 0,  TRUE),
    PT( 5,  3, 2, 0,  TRUE),
    PT( 5, 34, 5, 1, FALSE),
    PT( 3,  7, 6, 3,  TRUE),
    PT( 4,  8, 2, 1,  TRUE),
    PT( 5, 16, 6, 2, FALSE),
    PT(55, 20, 5, 0,  TRUE),
    PT(10, 36, 6, 1, FALSE),
    PT(52, 30, 3, 1,  TRUE),
    PT(18, 23, 5, 3, FALSE),
    PT( 1,  2, 2, 1,  TRUE),
    PT(10, 12, 2, 0,  TRUE),
    PT( 2, 20, 2, 1,  TRUE),
    PT(13, 37, 4, 1,  TRUE),
    PT( 0,  7, 3, 1, FALSE),
    PT(28, 40, 6, 2,  TRUE),
    PT( 8, 14, 5, 2, FALSE),
    PT(27, 60, 2, 2,  TRUE),
    PT(28, 25, 3, 2,  TRUE),
    PT(50, 19, 3, 1, FALSE),
    PT(28,  0, 6, 3,  TRUE),
    PT(34, 27, 6, 2,  TRUE),
    PT(57, 62, 2, 2, FALSE),
    PT(50,  6, 6, 0,  TRUE),
    PT(23,  5, 5, 1,  TRUE),
    PT( 1, 15, 4, 0, FALSE),
    PT(30, 15, 6, 2, FALSE),
    PT(24,  3, 3, 3,  TRUE),
    PT(43,  0, 2, 2, FALSE),
    PT(21, 58, 6, 0, FALSE),
    PT(37, 48, 4, 0,  TRUE),
    PT(11,  0, 6, 3,  TRUE),
    PT(36, 55, 3, 2,  TRUE),
    PT(41, 33, 2, 3, FALSE),
    PT(36, 15, 5, 2, FALSE),
    PT(62, 21, 6, 3, FALSE),
    PT(60, 45, 4, 1,  TRUE),
    PT(61, 60, 2, 3,  TRUE),
    PT(26, 28, 2, 1,  TRUE),
    PT(10, 41, 4, 1, FALSE),
    PT(37, 63, 4, 3, FALSE),
    PT(59, 57, 5, 3,  TRUE),
    PT(29,  8, 2, 3, FALSE),
    PT(11, 25, 2, 2, FALSE),
    PT(18,  1, 5, 2, FALSE),
    PT(53, 17, 5, 1, FALSE),
    PT( 2,  0, 2, 1,  TRUE),
    PT(57, 42, 6, 2,  TRUE),
    PT( 7, 26, 2, 0,  TRUE),
    PT(36, 14, 3, 3, FALSE),
    PT(14, 44, 2, 2,  TRUE),
    PT( 8, 49, 3, 1,  TRUE),
    PT(33, 29, 4, 3, FALSE),
    PT(29, 28, 5, 1, FALSE),
    PT(29, 36, 2, 1,  TRUE),
    PT( 1,  0, 3, 0, FALSE),
    PT(40, 42, 6, 3,  TRUE),
    PT(21, 15, 2, 1,  TRUE),
    PT(16, 50, 6, 3, FALSE),
    PT(34, 19, 6, 0,  TRUE),
    PT(19,  5, 3, 3, FALSE),
    PT(23, 53, 6, 2,  TRUE),
    PT(59, 14, 4, 2, FALSE),
    PT(53, 58, 3, 2,  TRUE),
    PT(27, 54, 3, 1,  TRUE),
    PT( 3, 29, 4, 2, FALSE),
    PT(15, 22, 6, 0, FALSE),
    PT(45,  9, 4, 2,  TRUE),
    PT( 5, 33, 2, 1,  TRUE),
    PT(10, 39, 6, 3, FALSE),
    PT( 4, 13, 3, 2, FALSE),
    PT( 6, 62, 4, 0,  TRUE),
    PT(42, 39, 6, 1,  TRUE),
    PT(40, 14, 2, 2,  TRUE),
    PT(11, 23, 3, 2,  TRUE),
    PT(29, 50, 5, 2,  TRUE),
    PT( 8, 61, 5, 0,  TRUE),
    PT(33, 50, 2, 3,  TRUE),
    PT(51, 49, 4, 1, FALSE),
    PT(14,  3, 4, 0,  TRUE),
    PT(13, 11, 2, 3, FALSE),
    PT(62, 42, 5, 3, FALSE),
    PT(25, 54, 5, 1, FALSE),
    PT(13,  0, 2, 2, FALSE),
    PT(34,  7, 6, 3, FALSE),
    PT(10,  9, 2, 2,  TRUE),
    PT(20, 16, 4, 1, FALSE),
    PT( 7, 22, 5, 2, FALSE),
    PT(54, 19, 2, 2,  TRUE),
    PT( 9, 47, 3, 1,  TRUE),
    PT(32, 59, 5, 3, FALSE),
    PT(58, 58, 2, 3, FALSE),
    PT(13, 21, 5, 1, FALSE),
    PT(57, 19, 5, 1,  TRUE),
    PT(11,  1, 5, 1, FALSE),
    PT(19, 23, 3, 3, FALSE),
    PT( 8, 23, 3, 3, FALSE),
    PT(12, 15, 6, 2, FALSE),
    PT(31, 49, 2, 1, FALSE),
    PT( 7, 58, 3, 2,  TRUE),
    PT(53, 30, 2, 1, FALSE),
    PT(36, 44, 2, 2,  TRUE),
    PT(14, 33, 3, 0,  TRUE),
    PT(52, 59, 6, 1,  TRUE),
    PT(25, 15, 5, 0, FALSE),
    PT(16, 47, 5, 3, FALSE),
    PT(35, 39, 6, 0,  TRUE),
    PT(57, 46, 3, 0, FALSE),
    PT(60, 63, 4, 2, FALSE),
    PT( 7, 35, 6, 0, FALSE),
    PT(40, 19, 6, 2,  TRUE),
    PT(19, 10, 2, 0, FALSE),
    PT(53, 25, 6, 1,  TRUE),
    PT(35, 40, 5, 0,  TRUE),
    PT(19, 47, 3, 1, FALSE),
    PT(58, 25, 2, 2, FALSE),
    PT(55, 54, 4, 3, FALSE),
    PT(32, 59, 2, 2,  TRUE),
    PT(55, 57, 2, 0, FALSE),
    PT(60, 33, 6, 2, FALSE),
    PT(28, 56, 6, 0, FALSE),
    PT(21,  7, 4, 3, FALSE),
    PT(39, 33, 3, 0,  TRUE),
    PT(24, 17, 4, 1,  TRUE),
    PT(48, 40, 6, 3,  TRUE),
    PT(50, 45, 3, 3,  TRUE),
    PT(44, 63, 6, 0, FALSE),
    PT(29, 47, 4, 3, FALSE),
    PT( 1, 17, 3, 2, FALSE),
    PT(59, 15, 2, 1, FALSE),
    PT(42, 23, 4, 3,  TRUE),
    PT( 5,  0, 3, 1,  TRUE),
    PT(37, 28, 6, 1, FALSE),
    PT( 4, 34, 5, 2,  TRUE),
    PT(16, 15, 4, 2,  TRUE),
    PT(13, 57, 6, 0, FALSE),
    PT(11, 46, 4, 3,  TRUE),
    PT(45, 52, 2, 2,  TRUE),
    PT(62, 48, 6, 3, FALSE),
    PT(22, 38, 5, 1, FALSE),
    PT( 5, 63, 5, 1,  TRUE),
    PT(32, 59, 5, 3, FALSE),
    PT(59, 28, 5, 3,  TRUE),
    PT( 1, 24, 2, 3, FALSE),
    PT(22, 61, 2, 0, FALSE),
    PT(10, 31, 3, 0, FALSE),
    PT(23, 15, 4, 1, FALSE),
    PT( 6, 19, 2, 0,  TRUE),
    PT(56, 33, 2, 3,  TRUE),
    PT(23, 10, 6, 3,  TRUE),
    PT(28, 25, 6, 0, FALSE),
    PT(22, 56, 6, 0,  TRUE),
    PT(48, 16, 6, 3, FALSE),
    PT(49, 47, 4, 3, FALSE),
    PT(60, 27, 4, 1,  TRUE),
    PT(51, 47, 3, 0,  TRUE),
    PT(22, 53, 4, 2,  TRUE),
    PT(58, 24, 3, 3,  TRUE),
    PT(55,  1, 3, 3, FALSE),
    PT(13, 24, 2, 1, FALSE),
    PT(31, 28, 3, 1,  TRUE),
    PT( 7, 52, 5, 2,  TRUE),
    PT(11, 63, 6, 1,  TRUE),
    PT(30, 52, 3, 2,  TRUE),
    PT(44, 19, 5, 2, FALSE),
    PT(32, 32, 2, 1,  TRUE),
    PT(32, 15, 6, 0,  TRUE),
    PT( 8, 15, 4, 2, FALSE),
    PT(24, 61, 3, 2, FALSE),
    PT(54, 52, 4, 3,  TRUE),
    PT(51, 42, 4, 2,  TRUE),
    PT(45, 48, 4, 3, FALSE),
    PT(61, 55, 4, 3, FALSE),
    PT(37, 17, 2, 0,  TRUE),
    PT( 3,  5, 3, 0, FALSE),
    PT(16,  4, 5, 0,  TRUE),
    PT( 7, 46, 6, 3, FALSE),
    PT(42, 41, 2, 2,  TRUE),
    PT(58, 14, 6, 1,  TRUE),
    PT(42,  6, 5, 0,  TRUE),
    PT(61,  1, 5, 0,  TRUE),
    PT(39, 14, 2, 3, FALSE),
    PT(29, 40, 3, 1,  TRUE),
    PT(16, 51, 5, 1,  TRUE),
    PT(12, 20, 3, 2,  TRUE),
    PT(21, 63, 4, 2,  TRUE),
    PT(55, 35, 3, 3, FALSE),
    PT( 4, 44, 3, 2, FALSE),
    PT(21, 52, 5, 1, FALSE),
    PT( 9, 47, 2, 2,  TRUE),
    PT( 2, 63, 2, 2, FALSE),
    PT(25, 44, 6, 1,  TRUE),
    PT(57, 50, 4, 0, FALSE),
    PT(42, 24, 6, 1, FALSE),
    PT(23, 35, 4, 0,  TRUE),
    PT(11, 45, 4, 2,  TRUE),
    PT(36, 58, 5, 2,  TRUE),
    PT(49, 63, 6, 2, FALSE),
    PT(24, 25, 4, 2, FALSE),
    PT(30, 21, 3, 1, FALSE),
    PT(23, 51, 5, 1,  TRUE),
    PT(35,  9, 4, 3, FALSE),
    PT(27, 13, 2, 2,  TRUE),
    PT(54, 38, 5, 0, FALSE),
    PT(58, 28, 2, 2, FALSE),
    PT(12, 62, 2, 0, FALSE),
    PT(24,  6, 6, 2,  TRUE),
    PT(55, 38, 6, 3, FALSE),
    PT(33, 38, 2, 3,  TRUE),
    PT(61, 28, 5, 2, FALSE),
    PT(22, 37, 3, 2,  TRUE),
    PT(30, 11, 3, 3, FALSE),
    PT(29, 13, 6, 1, FALSE),
    PT( 8, 31, 3, 1,  TRUE),
    PT(18, 28, 2, 1, FALSE),
    PT(32, 42, 5, 0, FALSE),
    PT( 6, 59, 6, 2,  TRUE),
    PT(57, 14, 3, 3, FALSE),
    PT(49, 48, 5, 0, FALSE),
    PT( 2, 33, 2, 2, FALSE),
    PT( 6, 30, 5, 0,  TRUE),
    PT(22,  9, 3, 2, FALSE),
    PT(39, 50, 5, 2,  TRUE),
    PT(57,  3, 4, 3,  TRUE),
    PT(41,  9, 3, 3, FALSE),
    PT(27, 17, 3, 2, FALSE),
    PT(40, 58, 5, 2, FALSE),
    PT( 3,  3, 3, 0, FALSE),
    PT(35,  9, 5, 3,  TRUE),
    PT(48, 23, 4, 1,  TRUE),
    PT(15, 37, 6, 1,  TRUE),
    PT( 6, 36, 6, 3,  TRUE),
    PT(34,  9, 6, 1,  TRUE),
    PT(44,  9, 5, 1, FALSE),
    PT(12, 18, 5, 1, FALSE),
    PT(40, 32, 2, 0, FALSE),
    PT(21, 41, 6, 1,  TRUE),
    PT(15, 26, 2, 1,  TRUE),
    PT(19, 24, 6, 3, FALSE),
    PT(46, 22, 2, 1,  TRUE),
    PT(60, 26, 2, 2,  TRUE),
    PT(58, 17, 6, 1, FALSE),
    PT( 2, 10, 5, 2, FALSE),
    PT(25, 57, 2, 0,  TRUE),
    PT(49, 62, 3, 2,  TRUE),
    PT(50, 20, 6, 1, FALSE),
    PT(18, 46, 6, 2, FALSE),
    PT(62, 54, 4, 1,  TRUE),
    PT(55, 62, 2, 2,  TRUE),
    PT(21, 53, 6, 2, FALSE),
    PT( 1, 58, 5, 2, FALSE),
    PT(38, 37, 4, 1, FALSE),
    PT( 1, 43, 6, 3,  TRUE),
    PT(28, 61, 6, 1,  TRUE),
    PT(62, 16, 3, 2, FALSE),
    PT(38, 51, 3, 0,  TRUE),
    PT( 5, 25, 2, 3,  TRUE),
    PT(18, 56, 3, 2, FALSE),
    PT(21, 60, 6, 1, FALSE),
    PT(63, 15, 6, 3,  TRUE),
    PT( 2, 57, 6, 1, FALSE),
    PT(19,  0, 3, 2,  TRUE),
    PT(29, 44, 2, 0, FALSE),
    PT(57, 19, 6, 0,  TRUE),
    PT(15, 55, 3, 0,  TRUE),
    PT( 9, 13, 5, 1, FALSE),
    PT(32, 47, 6, 1, FALSE),
    PT(59, 52, 4, 1, FALSE),
    PT(38, 20, 2, 0, FALSE),
    PT(36, 61, 4, 1, FALSE),
    PT(11, 49, 4, 1,  TRUE),
    PT(47, 45, 5, 1, FALSE),
    PT(48,  4, 6, 2,  TRUE),
    PT(25, 32, 5, 1, FALSE),
    PT(22, 54, 6, 3,  TRUE),
    PT(20, 40, 6, 3,  TRUE),
    PT(17, 11, 4, 3,  TRUE),
    PT(29,  6, 5, 0,  TRUE),
    PT(53, 22, 5, 3, FALSE),
    PT(36, 46, 5, 0,  TRUE),
    PT(54, 20, 5, 1, FALSE),
    PT(33, 12, 3, 3,  TRUE),
    PT(63, 57, 3, 0,  TRUE),
    PT(39, 16, 5, 1, FALSE),
    PT(30, 18, 6, 2, FALSE),
    PT(16, 36, 6, 2, FALSE),
    PT(29, 19, 3, 2,  TRUE),
    PT(23, 22, 6, 3,  TRUE),
    PT(39, 27, 4, 3,  TRUE),
    PT( 7, 36, 4, 0,  TRUE),
    PT(55, 33, 2, 0,  TRUE),
    PT(55, 40, 4, 2, FALSE),
    PT(25,  2, 3, 2, FALSE),
    PT(20, 18, 3, 2,  TRUE),
    PT(27, 36, 5, 3, FALSE),
    PT(46, 58, 2, 2,  TRUE),
    PT(55, 52, 4, 0,  TRUE),
    PT(51, 45, 5, 0,  TRUE),
    PT(47, 30, 6, 2, FALSE),
    PT(41, 60, 2, 1, FALSE),
    PT( 5, 21, 4, 0, FALSE),
    PT( 5, 62, 3, 0,  TRUE),
    PT(24, 11, 6, 0, FALSE),
    PT(47,  2, 4, 3,  TRUE),
    PT(20, 28, 6, 2, FALSE),
    PT(18, 32, 6, 0, FALSE),
    PT(43, 34, 3, 1,  TRUE),
    PT( 6, 49, 5, 0, FALSE),
    PT(21, 45, 2, 1, FALSE),
    PT( 1, 14, 2, 1,  TRUE),
    PT(19, 12, 5, 0, FALSE),
    PT( 7, 42, 2, 2, FALSE),
    PT(29, 54, 2, 2, FALSE),
    PT(21, 43, 4, 3, FALSE),
    PT( 3, 37, 2, 2,  TRUE),
    PT(62, 59, 4, 0, FALSE),
    PT(53, 12, 4, 2,  TRUE),
    PT(43, 22, 6, 2,  TRUE),
    PT(30, 49, 5, 2, FALSE),
    PT( 6,  3, 5, 0,  TRUE),
    PT(36,  7, 3, 3,  TRUE),
    PT(50, 47, 3, 0,  TRUE),
    PT(37, 33, 6, 0,  TRUE),
    PT(34, 38, 3, 2,  TRUE),
    PT( 0, 27, 3, 0, FALSE),
    PT(42, 36, 6, 0,  TRUE),
    PT(32,  6, 5, 3,  TRUE),
    PT(30, 50, 4, 3, FALSE),
    PT(50, 57, 2, 1, FALSE),
    PT(32,  1, 3, 0,  TRUE),
    PT(15, 21, 2, 2,  TRUE),
    PT(39, 16, 5, 3, FALSE),
    PT( 9, 37, 3, 0,  TRUE),
    PT(41, 55, 6, 0, FALSE),
    PT(19, 28, 3, 2,  TRUE),
    PT(41, 45, 4, 3, FALSE),
    PT( 2, 26, 2, 3, FALSE),
    PT(29, 43, 3, 2, FALSE),
    PT(24,  4, 6, 2, FALSE),
    PT(40, 42, 4, 0,  TRUE),
    PT(21, 27, 5, 3, FALSE),
    PT(22,  1, 2, 0, FALSE),
    PT( 5,  9, 2, 2, FALSE),
    PT(34,  3, 4, 1, FALSE),
    PT( 2, 27, 6, 2, FALSE),
    PT(41, 42, 4, 1,  TRUE),
    PT(38, 54, 2, 1,  TRUE),
    PT(35, 61, 3, 1, FALSE),
    PT(29, 16, 4, 2, FALSE),
    PT(37, 43, 6, 3,  TRUE),
    PT(25, 36, 4, 3, FALSE),
    PT(40, 19, 2, 3, FALSE),
    PT(23, 20, 3, 0,  TRUE),
    PT(11, 47, 4, 2,  TRUE),
    PT(55, 52, 6, 3,  TRUE),
    PT(57, 33, 3, 1,  TRUE),
    PT(15, 61, 5, 2,  TRUE),
    PT(13, 16, 4, 0, FALSE),
    PT( 5, 11, 5, 2,  TRUE),
    PT( 1, 18, 4, 2, FALSE),
    PT(24, 61, 6, 1, FALSE),
    PT( 9, 33, 4, 3, FALSE),
    PT(26, 14, 3, 3,  TRUE),
    PT(48,  6, 3, 3,  TRUE),
    PT(11, 60, 5, 0,  TRUE),
    PT( 7, 62, 4, 3,  TRUE),
    PT(19, 30, 3, 1, FALSE),
    PT(19,  7, 4, 1,  TRUE),
    PT(16, 52, 3, 3, FALSE),
    PT(50, 23, 4, 1,  TRUE),
    PT(53, 22, 6, 0,  TRUE),
    PT(50, 46, 3, 1,  TRUE),
    PT(40, 14, 4, 1, FALSE),
    PT(20, 58, 4, 1,  TRUE),
    PT(34,  3, 5, 0,  TRUE),
    PT(42, 16, 4, 0, FALSE),
    PT(62, 60, 4, 3,  TRUE),
    PT(22, 32, 2, 1, FALSE),
    PT(63, 36, 6, 0,  TRUE),
    PT(13, 46, 6, 1, FALSE),
    PT(47, 23, 5, 2,  TRUE),
    PT(54, 59, 2, 3,  TRUE),
    PT(36, 35, 3, 0, FALSE),
    PT(55, 29, 2, 1,  TRUE),
    PT(23, 58, 3, 1, FALSE),
    PT(10, 61, 3, 3, FALSE),
    PT( 5, 18, 2, 3, FALSE),
    PT(51, 50, 4, 2,  TRUE),
    PT(29, 31, 5, 0,  TRUE),
    PT(52, 44, 4, 3, FALSE),
    PT(32, 41, 6, 2,  TRUE),
    PT(14, 50, 2, 3,  TRUE),
    PT( 1, 57, 5, 2,  TRUE),
    PT(39, 36, 4, 1,  TRUE),
    PT(40, 63, 3, 0, FALSE),
    PT(57, 56, 4, 2,  TRUE),
    PT(35, 17, 2, 0,  TRUE),
    PT(25, 44, 5, 0,  TRUE),
    PT(48,  8, 5, 0, FALSE),
    PT(37, 39, 3, 2,  TRUE),
    PT(23, 37, 4, 0,  TRUE),
    PT( 9, 61, 2, 3, FALSE),
    PT(27, 15, 5, 2, FALSE),
    PT(27, 18, 4, 1, FALSE),
    PT(40, 62, 4, 3, FALSE),
    PT(52, 16, 3, 1,  TRUE),
    PT( 2, 52, 2, 2,  TRUE),
    PT(26, 41, 3, 0,  TRUE),
    PT(41, 17, 6, 0,  TRUE),
    PT(18, 39, 2, 3,  TRUE),
    PT(39, 39, 5, 3,  TRUE),
    PT(52, 39, 4, 2, FALSE),
    PT( 3, 25, 6, 3, FALSE),
    PT(23, 29, 6, 1,  TRUE),
    PT(25, 37, 3, 1, FALSE),
    PT(43, 57, 2, 1,  TRUE),
    PT(59, 51, 3, 2,  TRUE),
    PT(39, 49, 6, 2, FALSE),
    PT(40, 51, 6, 3,  TRUE),
    PT( 9, 48, 3, 1,  TRUE),
    PT( 3, 58, 4, 3,  TRUE),
    PT(25, 17, 3, 3,  TRUE),
    PT(11, 26, 6, 2, FALSE),
    PT(61, 42, 2, 2,  TRUE),
    PT( 4, 36, 6, 3, FALSE),
    PT(48, 35, 6, 0, FALSE),
    PT(15, 34, 3, 1,  TRUE),
    PT(61, 61, 4, 2, FALSE),
    PT(41, 29, 2, 1, FALSE),
    PT(22, 25, 5, 3, FALSE),
    PT( 3, 18, 2, 3,  TRUE),
    PT(24, 37, 6, 1,  TRUE),
    PT(47, 35, 3, 1, FALSE),
    PT(26, 53, 4, 3,  TRUE),
    PT(33, 38, 3, 0,  TRUE),
    PT(27, 48, 3, 0, FALSE),
    PT(43, 34, 5, 2,  TRUE),
    PT(44, 26, 6, 2, FALSE),
    PT(62, 18, 3, 0,  TRUE),
    PT(40, 39, 2, 2,  TRUE),
    PT(27, 17, 2, 1, FALSE),
    PT(23, 21, 2, 0, FALSE),
    PT(52, 55, 4, 2,  TRUE),
    PT(18, 63, 2, 2,  TRUE),
    PT(49, 13, 6, 3,  TRUE),
    PT(62, 42, 5, 2,  TRUE),
    PT(15, 36, 4, 2, FALSE),
    PT(60, 63, 3, 3,  TRUE),
    PT(29, 52, 2, 3,  TRUE),
    PT(26, 35, 3, 3,  TRUE),
    PT(55, 15, 2, 0, FALSE),
    PT(50, 52, 6, 2,  TRUE),
    PT(25,  5, 4, 1, FALSE),
    PT(51, 22, 6, 2, FALSE),
    PT(30, 20, 3, 3, FALSE),
    PT( 8, 19, 5, 0,  TRUE),
    PT(58, 55, 6, 0, FALSE),
    PT(29, 54, 2, 2,  TRUE),
    PT(41, 46, 3, 2,  TRUE),
    PT(50, 46, 4, 1,  TRUE),
    PT(53, 23, 3, 2, FALSE),
    PT(54, 29, 2, 1,  TRUE),
    PT(35, 52, 6, 2, FALSE),
    PT(36, 26, 6, 3,  TRUE),
    PT(47, 38, 5, 3, FALSE),
    PT(30, 23, 3, 1, FALSE),
    PT(31, 21, 3, 3,  TRUE),
    PT(43, 31, 3, 0,  TRUE),
    PT(10, 51, 3, 1, FALSE),
    PT(53, 49, 4, 2, FALSE),
    PT(45, 23, 5, 2, FALSE),
    PT(12, 33, 6, 3, FALSE),
    PT(44, 53, 6, 2,  TRUE),
    PT(27,  3, 4, 3,  TRUE),
    PT( 1, 13, 3, 2,  TRUE),
    PT(28, 14, 2, 0,  TRUE),
    PT(17, 43, 2, 0, FALSE),
    PT(37, 59, 4, 0, FALSE),
    PT(31, 23, 3, 0,  TRUE),
    PT(32,  8, 6, 3, FALSE),
    PT(19, 56, 3, 0,  TRUE),
    PT(27, 43, 4, 2, FALSE),
    PT(11, 31, 5, 0,  TRUE),
    PT(39, 21, 5, 2, FALSE),
    PT(55, 57, 2, 0, FALSE),
    PT(58, 21, 5, 3, FALSE),
    PT(47, 17, 6, 3, FALSE),
    PT(36,  4, 4, 0, FALSE),
    PT(59, 42, 6, 2,  TRUE),
    PT(39, 53, 6, 2, FALSE),
    PT(13, 27, 4, 0, FALSE),
    PT(16, 34, 6, 3,  TRUE),
    PT(31, 56, 4, 3,  TRUE),
    PT(49, 15, 5, 0, FALSE),
    PT(40, 37, 2, 2,  TRUE),
    PT( 0, 29, 4, 2,  TRUE),
    PT(49, 40, 5, 0, FALSE),
    PT(11, 58, 3, 2,  TRUE),
    PT(45, 19, 3, 1,  TRUE),
    PT( 3, 55, 5, 3, FALSE),
    PT(29, 40, 3, 0,  TRUE),
    PT( 8, 45, 4, 1, FALSE),
    PT(39, 57, 6, 1, FALSE),
    PT(63, 47, 3, 2,  TRUE),
    PT(51, 52, 5, 0, FALSE),
    PT(24,  8, 6, 0,  TRUE),
    PT(35, 31, 2, 1,  TRUE),
    PT(13, 44, 4, 1,  TRUE),
    PT(58, 45, 3, 1, FALSE),
    PT( 2, 37, 2, 1,  TRUE),
    PT(32, 54, 6, 2, FALSE),
    PT(18, 43, 5, 2,  TRUE),
    PT(53, 53, 6, 2, FALSE),
    PT(35, 32, 4, 0,  TRUE),
    PT(58, 25, 3, 1,  TRUE),
    PT(31, 43, 3, 0,  TRUE),
    PT(53, 14, 3, 0,  TRUE),
    PT(38, 36, 6, 3,  TRUE),
    PT(24,  8, 2, 0, FALSE),
    PT(12, 22, 5, 2,  TRUE),
    PT(31, 52, 4, 0,  TRUE),
    PT( 5, 56, 3, 0,  TRUE),
    PT(20, 33, 4, 2, FALSE),
    PT(17, 49, 2, 2, FALSE),
    PT(62, 56, 5, 0,  TRUE),
    PT(63,  8, 4, 2,  TRUE),
    PT(42, 31, 4, 2,  TRUE),
    PT(37,  6, 5, 0, FALSE),
    PT(11, 30, 2, 2, FALSE),
    PT(26, 56, 4, 1, FALSE),
    PT(36, 24, 5, 0,  TRUE),
    PT(26, 17, 4, 0, FALSE),
    PT(59, 58, 3, 3, FALSE),
    PT(28, 38, 3, 1, FALSE),
    PT( 5, 50, 3, 0,  TRUE),
    PT(57, 42, 6, 0,  TRUE),
    PT( 9,  7, 4, 2,  TRUE),
    PT( 5, 62, 2, 3, FALSE),
    PT(52, 38, 2, 2, FALSE),
    PT(27, 50, 4, 3, FALSE),
    PT( 5,  8, 6, 3,  TRUE),
    PT(15,  3, 4, 0, FALSE),
    PT(42, 57, 6, 0,  TRUE),
    PT( 8,  1, 3, 3, FALSE),
    PT(29, 35, 6, 0,  TRUE),
    PT(40, 27, 5, 0, FALSE),
    PT(30, 55, 2, 2, FALSE),
    PT(19, 14, 5, 0, FALSE),
    PT(42, 59, 6, 3,  TRUE),
    PT(47, 28, 5, 0, FALSE),
    PT(48, 48, 3, 1, FALSE),
    PT(54, 31, 2, 3, FALSE),
    PT(62, 13, 2, 2,  TRUE),
    PT(46, 22, 3, 0, FALSE),
    PT(21, 55, 4, 0, FALSE),
    PT(42, 51, 6, 0, FALSE),
    PT(43, 14, 4, 2,  TRUE),
    PT(24, 32, 2, 3, FALSE),
    PT( 2, 25, 4, 2,  TRUE),
    PT(10, 46, 6, 0, FALSE),
    PT(22,  3, 2, 0,  TRUE),
    PT( 4, 39, 4, 2,  TRUE),
    PT(27, 28, 4, 0,  TRUE),
    PT(41,  4, 4, 3,  TRUE),
    PT(61, 32, 3, 3, FALSE),
    PT(40, 51, 6, 0,  TRUE),
    PT(30, 57, 2, 0, FALSE),
    PT(49, 41, 3, 3, FALSE),
    PT( 6, 37, 5, 0, FALSE),
    PT(25, 59, 2, 1, FALSE),
    PT(11, 27, 3, 2, FALSE),
    PT(62, 55, 4, 0, FALSE),
    PT(10, 55, 6, 1,  TRUE),
    PT( 2, 44, 4, 2,  TRUE),
    PT(21, 24, 2, 2, FALSE),
    PT(59, 32, 3, 2, FALSE),
    PT(34, 59, 3, 2, FALSE),
    PT(36, 52, 6, 2,  TRUE),
    PT(15, 47, 6, 0,  TRUE),
    PT(59, 23, 6, 2,  TRUE),
    PT(48, 57, 6, 3,  TRUE),
    PT(13, 21, 2, 0,  TRUE),
    PT(16,  3, 3, 3, FALSE),
    PT(26, 57, 6, 1,  TRUE),
    PT(47, 46, 5, 0, FALSE),
    PT(28, 40, 6, 3, FALSE),
    PT(40, 24, 3, 3,  TRUE),
    PT(21,  1, 6, 0, FALSE),
    PT(62, 50, 5, 0, FALSE),
    PT(52, 47, 4, 1,  TRUE),
    PT( 7, 12, 6, 3, FALSE),
    PT(40, 44, 6, 2, FALSE),
    PT(42, 12, 3, 3,  TRUE),
    PT(63, 32, 2, 1,  TRUE),
    PT(43, 23, 4, 3,  TRUE),
    PT(40, 41, 5, 1, FALSE),
    PT(60, 19, 6, 3, FALSE),
    PT(38, 45, 5, 1, FALSE),
    PT(10,  6, 3, 3, FALSE),
    PT(32,  4, 3, 1, FALSE),
    PT( 2,  7, 6, 2,  TRUE),
    PT(14, 24, 6, 0, FALSE),
    PT( 0, 52, 6, 2, FALSE),
    PT(47, 20, 6, 3,  TRUE),
    PT(33, 48, 3, 3,  TRUE),
    PT(21, 55, 3, 1,  TRUE),
    PT(58, 11, 6, 1, FALSE),
    PT(34, 34, 4, 0,  TRUE),
    PT(27, 53, 4, 1,  TRUE),
    PT(13,  3, 3, 2, FALSE),
    PT(35, 59, 2, 1,  TRUE),
    PT(14, 29, 3, 3,  TRUE),
    PT(29, 63, 5, 3, FALSE),
    PT(57, 39, 5, 3, FALSE),
    PT(15, 56, 4, 0, FALSE),
    PT(49, 60, 6, 2,  TRUE),
    PT(11, 15, 5, 3, FALSE),
    PT( 6,  6, 5, 0, FALSE),
    PT(37, 57, 4, 1,  TRUE),
    PT(10, 50, 2, 2,  TRUE),
    PT(15, 29, 4, 2,  TRUE),
    PT(12, 13, 6, 2, FALSE),
    PT(18, 46, 4, 0,  TRUE),
    PT(54, 24, 3, 3,  TRUE),
    PT(31, 52, 3, 1,  TRUE),
    PT( 5, 58, 6, 3, FALSE),
    PT(43,  1, 2, 3,  TRUE),
    PT(14, 22, 5, 1,  TRUE),
    PT(14, 11, 4, 3, FALSE),
    PT(13, 45, 2, 0, FALSE),
    PT(33, 17, 4, 3,  TRUE),
    PT(61, 19, 6, 1, FALSE),
    PT(21, 37, 5, 1, FALSE),
    PT(27, 45, 6, 2,  TRUE),
    PT(44, 43, 4, 3, FALSE),
    PT(38, 31, 4, 0, FALSE),
    PT(34, 43, 2, 1, FALSE),
    PT(63, 61, 4, 3,  TRUE),
    PT(48, 10, 6, 3, FALSE),
    PT(53, 31, 2, 3,  TRUE),
    PT(33,  8, 5, 0,  TRUE),
    PT(29, 32, 6, 1,  TRUE),
    PT(52, 17, 2, 3, FALSE),
    PT( 5, 56, 5, 2,  TRUE),
};

#undef PT
