#ifndef GUARD_DATA_BARD_MUSIC_MOVES_H
#define GUARD_DATA_BARD_MUSIC_MOVES_H

#if ENGLISH
const struct BardSound gBardSounds_Moves1[][6] = {
    { // THUNDERBOLT
        {0x2A}, {0x30}, {0x1A}, {0xFF}, {0xFF}, {0xFF}
    }, { // IRON_TAIL
        {0x12}, {0x1B}, {0x05}, {0x33}, {0xFF}, {0xFF}
    }, { // ICE_BALL
        {0x12}, {0x1B}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // YAWN
        {0x1B}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // LOVELY_KISS
        {0x2C}, {0x2C}, {0x0C}, {0x11}, {0x33}, {0xFF}
    }, { // NIGHTMARE
        {0x12}, {0x05}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MORNING_SUN
        {0x1A}, {0x0E}, {0x2C}, {0x33}, {0xFF}, {0xFF}
    }, { // VITAL_THROW
        {0x12}, {0x24}, {0x18}, {0x33}, {0xFF}, {0xFF}
    }, { // DIG
        {0x11}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // THRASH
        {0x30}, {0x02}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SWEET_SCENT
        {0x0E}, {0x0B}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // CHARM
        {0x15}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // RAIN_DANCE
        {0x03}, {0x00}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // CONFUSE_RAY
        {0x1B}, {0x2D}, {0x03}, {0x33}, {0xFF}, {0xFF}
    }, { // HAIL
        {0x05}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // AROMATHERAPY
        {0x2A}, {0x18}, {0x2C}, {0x00}, {0x1B}, {0x0E}
    }, { // BUBBLE
        {0x2C}, {0x24}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ENCORE
        {0x1B}, {0x18}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // CUT
        {0x2A}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // RAGE
        {0x03}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SUPER_FANG
        {0x27}, {0x30}, {0x01}, {0x33}, {0xFF}, {0xFF}
    }, { // PAIN_SPLIT
        {0x03}, {0x0F}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // TORMENT
        {0x18}, {0x09}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // STRING_SHOT
        {0x32}, {0x0C}, {0x1B}, {0xFF}, {0xFF}, {0xFF}
    }, { // SWAGGER
        {0x02}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SNORE
        {0x18}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // HEAL_BELL
        {0x0E}, {0x0A}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // SCREECH
        {0x30}, {0x0D}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROCK_THROW
        {0x1B}, {0x18}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROCK_SMASH
        {0x1B}, {0x00}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROCK_SLIDE
        {0x1B}, {0x12}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // WEATHER_BALL
        {0x09}, {0x30}, {0x1B}, {0x33}, {0xFF}, {0xFF}
    }, { // WHIRLPOOL
        {0x30}, {0x27}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FAKE_TEARS
        {0x03}, {0x0E}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SING
        {0x0C}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPITE
        {0x12}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // AIR_CUTTER
        {0x05}, {0x2A}, {0x30}, {0x33}, {0xFF}, {0xFF}
    }, { // AEROBLAST
        {0x05}, {0x18}, {0x00}, {0x33}, {0xFF}, {0xFF}
    }, { // SMOKESCREEN
        {0x1A}, {0x0E}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // PURSUIT
        {0x30}, {0x27}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // DOUBLE_SLAP
        {0x2A}, {0x0A}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // MIRROR_MOVE
        {0x0C}, {0x32}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // OVERHEAT
        {0x18}, {0x30}, {0x0C}, {0xFF}, {0xFF}, {0xFF}
    }, { // AURORA_BEAM
        {0x1B}, {0x1A}, {0x2C}, {0x0C}, {0x33}, {0xFF}
    }, { // MEMENTO
        {0x2A}, {0x09}, {0x18}, {0xFF}, {0xFF}, {0xFF}
    }, { // OCTAZOOKA
        {0x1B}, {0x2C}, {0x28}, {0x2C}, {0xFF}, {0xFF}
    }, { // FLATTER
        {0x00}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ASTONISH
        {0x2A}, {0x1B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // WILL_O_WISP
        {0x11}, {0x18}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // RETURN
        {0x0C}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // GRUDGE
        {0x2B}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // STRENGTH
        {0x32}, {0x03}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // COUNTER
        {0x21}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FLAME_WHEEL
        {0x03}, {0x0E}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // FLAMETHROWER
        {0x00}, {0x1A}, {0x30}, {0xFF}, {0xFF}, {0xFF}
    }, { // ODOR_SLEUTH
        {0x18}, {0x30}, {0x27}, {0x33}, {0xFF}, {0xFF}
    }, { // SHARPEN
        {0x1B}, {0x09}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // DOUBLE_TEAM
        {0x2C}, {0x2C}, {0x0C}, {0xFF}, {0xFF}, {0xFF}
    }, { // GUST
        {0x2C}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // HARDEN
        {0x1B}, {0x09}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // DISABLE
        {0x11}, {0x03}, {0x24}, {0xFF}, {0xFF}, {0xFF}
    }, { // RAZOR_WIND
        {0x05}, {0x30}, {0x0F}, {0x33}, {0xFF}, {0xFF}
    }, { // BIDE
        {0x0B}, {0x32}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // CRUNCH
        {0x30}, {0x2A}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // BITE
        {0x12}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // THUNDER
        {0x2A}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // THUNDER_PUNCH
        {0x2A}, {0x30}, {0x2C}, {0xFF}, {0xFF}, {0xFF}
    }, { // ENDEAVOR
        {0x09}, {0x09}, {0x30}, {0xFF}, {0xFF}, {0xFF}
    }, { // FACADE
        {0x2C}, {0x1B}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // KARATE_CHOP
        {0x2C}, {0x1D}, {0x0E}, {0x1D}, {0xFF}, {0xFF}
    }, { // CLAMP
        {0x00}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // WITHDRAW
        {0x11}, {0x1B}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // CONSTRICT
        {0x1B}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // BRICK_BREAK
        {0x11}, {0x05}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROCK_TOMB
        {0x1B}, {0x27}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FOCUS_ENERGY
        {0x1A}, {0x2C}, {0x0B}, {0x30}, {0x0C}, {0xFF}
    }, { // FOCUS_PUNCH
        {0x18}, {0x2C}, {0x2C}, {0xFF}, {0xFF}, {0xFF}
    }, { // GIGA_DRAIN
        {0x11}, {0x2A}, {0x03}, {0x33}, {0xFF}, {0xFF}
    }, { // REVERSAL
        {0x0C}, {0x30}, {0x24}, {0xFF}, {0xFF}, {0xFF}
    }, { // SMELLING_SALT
        {0x09}, {0x0C}, {0x1B}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPORE
        {0x1A}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // LEECH_LIFE
        {0x0C}, {0x12}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // SLASH
        {0x00}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SILVER_WIND
        {0x11}, {0x30}, {0x0F}, {0xFF}, {0xFF}, {0xFF}
    }, { // METAL_SOUND
        {0x09}, {0x1B}, {0x21}, {0xFF}, {0xFF}, {0xFF}
    }, { // GRASS_WHISTLE
        {0x00}, {0x11}, {0x24}, {0xFF}, {0xFF}, {0xFF}
    }, { // TICKLE
        {0x11}, {0x24}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPIDER_WEB
        {0x12}, {0x30}, {0x09}, {0xFF}, {0xFF}, {0xFF}
    }, { // CRABHAMMER
        {0x02}, {0x00}, {0x30}, {0x33}, {0xFF}, {0xFF}
    }, { // HAZE
        {0x03}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MEAN_LOOK
        {0x0C}, {0x24}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // CROSS_CHOP
        {0x1B}, {0x1D}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // OUTRAGE
        {0x21}, {0x03}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // LOW_KICK
        {0x18}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ANCIENT_POWER
        {0x03}, {0x0C}, {0x21}, {0x32}, {0x33}, {0xFF}
    }, { // SYNTHESIS
        {0x0F}, {0x2A}, {0x0F}, {0xFF}, {0xFF}, {0xFF}
    }, { // AGILITY
        {0x2A}, {0x11}, {0x11}, {0x0E}, {0xFF}, {0xFF}
    }, { // RAPID_SPIN
        {0x00}, {0x0F}, {0x0F}, {0xFF}, {0xFF}, {0xFF}
    }, { // ICY_WIND
        {0x12}, {0x0C}, {0x0F}, {0xFF}, {0xFF}, {0xFF}
    }, { // MIND_READER
        {0x12}, {0x0C}, {0x30}, {0xFF}, {0xFF}, {0xFF}
    }, { // COSMIC_POWER
        {0x1B}, {0x11}, {0x21}, {0x30}, {0xFF}, {0xFF}
    }, { // SKY_ATTACK
        {0x12}, {0x2A}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // POWDER_SNOW
        {0x21}, {0x30}, {0x18}, {0xFF}, {0xFF}, {0xFF}
    }, { // FOLLOW_ME
        {0x15}, {0x18}, {0x0C}, {0x33}, {0xFF}, {0xFF}
    }, { // METEOR_MASH
        {0x0C}, {0x0C}, {0x18}, {0x00}, {0x33}, {0x33}
    }, { // ENDURE
        {0x09}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROLLOUT
        {0x1A}, {0x21}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SCARY_FACE
        {0x03}, {0x0C}, {0x03}, {0xFF}, {0xFF}, {0xFF}
    }, { // PSYBEAM
        {0x12}, {0x0C}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // PSYWAVE
        {0x12}, {0x03}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // PSYCHIC
        {0x12}, {0x0F}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // HYPNOSIS
        {0x11}, {0x18}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // UPROAR
        {0x2C}, {0x1A}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // WATER_SPOUT
        {0x1B}, {0x30}, {0x21}, {0xFF}, {0xFF}, {0xFF}
    }, { // SIGNAL_BEAM
        {0x11}, {0x1B}, {0x0C}, {0x33}, {0xFF}, {0xFF}
    }, { // PSYCH_UP
        {0x12}, {0x2A}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SUBMISSION
        {0x2A}, {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // RECOVER
        {0x0C}, {0x2C}, {0x30}, {0xFF}, {0xFF}, {0xFF}
    }, { // EARTHQUAKE
        {0x30}, {0x05}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // NATURE_POWER
        {0x03}, {0x30}, {0x21}, {0x30}, {0xFF}, {0xFF}
    }, { // LICK
        {0x11}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FLAIL
        {0x05}, {0x2A}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // TAIL_WHIP
        {0x05}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SELF_DESTRUCT
        {0x09}, {0x0C}, {0x2A}, {0x33}, {0xFF}, {0xFF}
    }, { // STUN_SPORE
        {0x2C}, {0x1A}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // BIND
        {0x14}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SHADOW_PUNCH
        {0x00}, {0x18}, {0x2C}, {0xFF}, {0xFF}, {0xFF}
    }, { // SHADOW_BALL
        {0x00}, {0x18}, {0x1B}, {0xFF}, {0xFF}, {0xFF}
    }, { // CHARGE
        {0x1B}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MIST
        {0x11}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FISSURE
        {0x11}, {0x32}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // EXTREME_SPEED
        {0x09}, {0x0C}, {0x0C}, {0x33}, {0xFF}, {0xFF}
    }, { // EXTRASENSORY
        {0x09}, {0x2A}, {0x09}, {0x18}, {0x0C}, {0xFF}
    }, { // SAFEGUARD
        {0x03}, {0x1B}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // ABSORB
        {0x2A}, {0x1A}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SKY_UPPERCUT
        {0x12}, {0x2C}, {0x30}, {0x2A}, {0xFF}, {0xFF}
    }, { // SKILL_SWAP
        {0x11}, {0x1B}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SKETCH
        {0x09}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // HEADBUTT
        {0x09}, {0x2A}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // DOUBLE_EDGE
        {0x2C}, {0x24}, {0x0A}, {0xFF}, {0xFF}, {0xFF}
    }, { // SANDSTORM
        {0x00}, {0x1A}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SAND_ATTACK
        {0x00}, {0x2A}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // SAND_TOMB
        {0x00}, {0x27}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPARK
        {0x1B}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SWIFT
        {0x11}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // KINESIS
        {0x0F}, {0x0C}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // SMOG
        {0x1B}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // GROWTH
        {0x30}, {0x18}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SACRED_FIRE
        {0x03}, {0x11}, {0x12}, {0x30}, {0x33}, {0xFF}
    }, { // SHEER_COLD
        {0x0E}, {0x30}, {0x18}, {0xFF}, {0xFF}, {0xFF}
    }, { // SOLAR_BEAM
        {0x18}, {0x30}, {0x0C}, {0x33}, {0xFF}, {0xFF}
    }, { // SONIC_BOOM
        {0x1B}, {0x11}, {0x27}, {0x33}, {0xFF}, {0xFF}
    }, { // FLY
        {0x12}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }
};

const struct BardSound gBardSounds_Moves2[][6] = {
    { // TACKLE
        {0x00}, {0x24}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // EXPLOSION
        {0x09}, {0x18}, {0x2C}, {0x33}, {0x33}, {0xFF}
    }, { // DIVE
        {0x12}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FIRE_BLAST
        {0x12}, {0x30}, {0x00}, {0x33}, {0xFF}, {0xFF}
    }, { // WATERFALL
        {0x1D}, {0x30}, {0x1D}, {0x33}, {0xFF}, {0xFF}
    }, { // MUDDY_WATER
        {0x2A}, {0x0C}, {0x1B}, {0x30}, {0xFF}, {0xFF}
    }, { // STOCKPILE
        {0x1B}, {0x14}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SLAM
        {0x00}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // TWISTER
        {0x11}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // BULLET_SEED
        {0x2A}, {0x09}, {0x0C}, {0x33}, {0xFF}, {0xFF}
    }, { // TWINEEDLE
        {0x0F}, {0x0C}, {0x24}, {0xFF}, {0xFF}, {0xFF}
    }, { // SOFT_BOILED
        {0x1B}, {0x1E}, {0x0B}, {0x33}, {0xFF}, {0xFF}
    }, { // EGG_BOMB
        {0x09}, {0x1B}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FAINT_ATTACK
        {0x03}, {0x2A}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // BARRAGE
        {0x30}, {0x1B}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MINIMIZE
        {0x0F}, {0x0F}, {0x12}, {0x33}, {0xFF}, {0xFF}
    }, { // SEISMIC_TOSS
        {0x12}, {0x11}, {0x1B}, {0x33}, {0xFF}, {0xFF}
    }, { // SUPERSONIC
        {0x27}, {0x30}, {0x1B}, {0x11}, {0xFF}, {0xFF}
    }, { // TAUNT
        {0x1B}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MOONLIGHT
        {0x27}, {0x12}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // PECK
        {0x09}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ARM_THRUST
        {0x1B}, {0x2C}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // HORN_ATTACK
        {0x18}, {0x2A}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // HORN_DRILL
        {0x18}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // WING_ATTACK
        {0x0C}, {0x2A}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // AERIAL_ACE
        {0x03}, {0x0C}, {0x2A}, {0x03}, {0xFF}, {0xFF}
    }, { // SWORDS_DANCE
        {0x1A}, {0x30}, {0x01}, {0x33}, {0xFF}, {0xFF}
    }, { // VINE_WHIP
        {0x12}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // CONVERSION
        {0x2A}, {0x30}, {0x2C}, {0x33}, {0xFF}, {0xFF}
    }, { // CONVERSION_2
        {0x2A}, {0x30}, {0x2C}, {0x27}, {0x33}, {0xFF}
    }, { // HELPING_HAND
        {0x09}, {0x0C}, {0x00}, {0x33}, {0xFF}, {0xFF}
    }, { // IRON_DEFENSE
        {0x12}, {0x1B}, {0x0C}, {0x09}, {0xFF}, {0xFF}
    }, { // TELEPORT
        {0x09}, {0x0C}, {0x1A}, {0x33}, {0xFF}, {0xFF}
    }, { // THUNDER_SHOCK
        {0x2A}, {0x30}, {0x1B}, {0xFF}, {0xFF}, {0xFF}
    }, { // SHOCK_WAVE
        {0x1B}, {0x03}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // QUICK_ATTACK
        {0x27}, {0x11}, {0x2A}, {0x00}, {0xFF}, {0xFF}
    }, { // SWEET_KISS
        {0x0E}, {0x11}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // THUNDER_WAVE
        {0x2A}, {0x30}, {0x05}, {0x33}, {0xFF}, {0xFF}
    }, { // ZAP_CANNON
        {0x00}, {0x01}, {0x2C}, {0x33}, {0xFF}, {0xFF}
    }, { // BLOCK
        {0x1B}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // HOWL
        {0x21}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // POISON_GAS
        {0x1E}, {0x1B}, {0x00}, {0x33}, {0xFF}, {0xFF}
    }, { // TOXIC
        {0x1B}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // POISON_FANG
        {0x1E}, {0x2A}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // POISON_POWDER
        {0x1E}, {0x2C}, {0x21}, {0x30}, {0xFF}, {0xFF}
    }, { // POISON_STING
        {0x1E}, {0x2C}, {0x0E}, {0x33}, {0xFF}, {0xFF}
    }, { // SPIKE_CANNON
        {0x14}, {0x00}, {0x1D}, {0xFF}, {0xFF}, {0xFF}
    }, { // ACID_ARMOR
        {0x00}, {0x11}, {0x1B}, {0x30}, {0xFF}, {0xFF}
    }, { // TAKE_DOWN
        {0x03}, {0x23}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // JUMP_KICK
        {0x2C}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // BOUNCE
        {0x21}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // HI_JUMP_KICK
        {0x12}, {0x2C}, {0x11}, {0x33}, {0xFF}, {0xFF}
    }, { // TRI_ATTACK
        {0x12}, {0x2A}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // DRAGON_CLAW
        {0x00}, {0x1B}, {0x1D}, {0xFF}, {0xFF}, {0xFF}
    }, { // TRICK
        {0x11}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // TRIPLE_KICK
        {0x11}, {0x24}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // DRILL_PECK
        {0x11}, {0x0B}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MUD_SPORT
        {0x2A}, {0x18}, {0x30}, {0xFF}, {0xFF}, {0xFF}
    }, { // MUD_SLAP
        {0x2C}, {0x00}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // THIEF
        {0x0C}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // AMNESIA
        {0x02}, {0x0E}, {0x2C}, {0x33}, {0xFF}, {0xFF}
    }, { // NIGHT_SHADE
        {0x12}, {0x05}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // GROWL
        {0x21}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SLACK_OFF
        {0x00}, {0x1B}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SURF
        {0x30}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROLE_PLAY
        {0x18}, {0x03}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // NEEDLE_ARM
        {0x0C}, {0x2A}, {0x1D}, {0xFF}, {0xFF}, {0xFF}
    }, { // DOUBLE_KICK
        {0x2A}, {0x2C}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // SUNNY_DAY
        {0x2A}, {0x0E}, {0x05}, {0xFF}, {0xFF}, {0xFF}
    }, { // LEER
        {0x0E}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // WISH
        {0x0F}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FAKE_OUT
        {0x03}, {0x21}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SLEEP_TALK
        {0x0E}, {0x1D}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // PAY_DAY
        {0x05}, {0x05}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ASSIST
        {0x2A}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // HEAT_WAVE
        {0x0C}, {0x03}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SLEEP_POWDER
        {0x0C}, {0x21}, {0x30}, {0xFF}, {0xFF}, {0xFF}
    }, { // REST
        {0x09}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // INGRAIN
        {0x0F}, {0x03}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // CONFUSION
        {0x2C}, {0x29}, {0x2C}, {0x33}, {0xFF}, {0xFF}
    }, { // BODY_SLAM
        {0x1D}, {0x0C}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // SWALLOW
        {0x1B}, {0x18}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // CURSE
        {0x30}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // HYDRO_PUMP
        {0x12}, {0x18}, {0x2A}, {0xFF}, {0xFF}, {0xFF}
    }, { // HYPER_VOICE
        {0x12}, {0x30}, {0x1E}, {0xFF}, {0xFF}, {0xFF}
    }, { // HYPER_BEAM
        {0x12}, {0x30}, {0x0C}, {0x33}, {0xFF}, {0xFF}
    }, { // SUPERPOWER
        {0x27}, {0x30}, {0x21}, {0x30}, {0xFF}, {0xFF}
    }, { // STEEL_WING
        {0x0E}, {0x0D}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPIT_UP
        {0x11}, {0x2A}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // DYNAMIC_PUNCH
        {0x12}, {0x00}, {0x11}, {0x2C}, {0xFF}, {0xFF}
    }, { // GUILLOTINE
        {0x0C}, {0x2C}, {0x0E}, {0x33}, {0xFF}, {0xFF}
    }, { // VICE_GRIP
        {0x14}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // KNOCK_OFF
        {0x1B}, {0x1D}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // POUND
        {0x21}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // RAZOR_LEAF
        {0x05}, {0x30}, {0x0C}, {0xFF}, {0xFF}, {0xFF}
    }, { // BATON_PASS
        {0x2A}, {0x1B}, {0x00}, {0x33}, {0xFF}, {0xFF}
    }, { // PETAL_DANCE
        {0x09}, {0x2C}, {0x02}, {0x33}, {0xFF}, {0xFF}
    }, { // SPLASH
        {0x00}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // BUBBLE_BEAM
        {0x2A}, {0x24}, {0x0C}, {0x33}, {0xFF}, {0xFF}
    }, { // BELLY_DRUM
        {0x09}, {0x0C}, {0x2A}, {0x33}, {0xFF}, {0xFF}
    }, { // BARRIER
        {0x05}, {0x0E}, {0x30}, {0xFF}, {0xFF}, {0xFF}
    }, { // LIGHT_SCREEN
        {0x12}, {0x0C}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // SCRATCH
        {0x00}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // HYPER_FANG
        {0x12}, {0x30}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // EMBER
        {0x09}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SECRET_POWER
        {0x0C}, {0x09}, {0x21}, {0x30}, {0xFF}, {0xFF}
    }, { // DIZZY_PUNCH
        {0x11}, {0x0E}, {0x2C}, {0xFF}, {0xFF}, {0xFF}
    }, { // BULK_UP
        {0x2C}, {0x2C}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // IMPRISON
        {0x0F}, {0x0F}, {0x2C}, {0x33}, {0xFF}, {0xFF}
    }, { // FEATHER_DANCE
        {0x09}, {0x30}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // WHIRLWIND
        {0x2C}, {0x1D}, {0x0E}, {0x1D}, {0xFF}, {0xFF}
    }, { // BEAT_UP
        {0x0C}, {0x2C}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // BLIZZARD
        {0x0F}, {0x32}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // STOMP
        {0x1D}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FLASH
        {0x00}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // TEETER_DANCE
        {0x0C}, {0x30}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // CRUSH_CLAW
        {0x2C}, {0x1B}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // BLAZE_KICK
        {0x05}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // PRESENT
        {0x09}, {0x09}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ERUPTION
        {0x0C}, {0x2C}, {0x1D}, {0x33}, {0xFF}, {0xFF}
    }, { // SLUDGE
        {0x2C}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SLUDGE_BOMB
        {0x2B}, {0x1B}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // GLARE
        {0x05}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // TRANSFORM
        {0x00}, {0x1A}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // POISON_TAIL
        {0x1E}, {0x2C}, {0x05}, {0x33}, {0xFF}, {0xFF}
    }, { // ROAR
        {0x1A}, {0x30}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // BONE_RUSH
        {0x18}, {0x2C}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // CAMOUFLAGE
        {0x00}, {0x18}, {0x1B}, {0x33}, {0xFF}, {0xFF}
    }, { // COVET
        {0x2A}, {0x09}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // TAIL_GLOW
        {0x04}, {0x1A}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // BONE_CLUB
        {0x18}, {0x2C}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // BONEMERANG
        {0x18}, {0x30}, {0x00}, {0x33}, {0xFF}, {0xFF}
    }, { // FIRE_SPIN
        {0x12}, {0x30}, {0x0F}, {0x33}, {0xFF}, {0xFF}
    }, { // FIRE_PUNCH
        {0x12}, {0x30}, {0x2A}, {0xFF}, {0xFF}, {0xFF}
    }, { // PERISH_SONG
        {0x09}, {0x11}, {0x1B}, {0x33}, {0xFF}, {0xFF}
    }, { // WRAP
        {0x00}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPIKES
        {0x12}, {0x33}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MAGNITUDE
        {0x00}, {0x0F}, {0x27}, {0xFF}, {0xFF}, {0xFF}
    }, { // MAGICAL_LEAF
        {0x00}, {0x11}, {0x24}, {0x0C}, {0x33}, {0xFF}
    }, { // MAGIC_COAT
        {0x00}, {0x11}, {0x18}, {0xFF}, {0xFF}, {0xFF}
    }, { // MUD_SHOT
        {0x2C}, {0x1D}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MACH_PUNCH
        {0x1B}, {0x2C}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // PROTECT
        {0x18}, {0x09}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // DEFENSE_CURL
        {0x0E}, {0x0B}, {0x32}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROLLING_KICK
        {0x18}, {0x0C}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // SUBSTITUTE
        {0x2A}, {0x11}, {0x27}, {0xFF}, {0xFF}, {0xFF}
    }, { // DETECT
        {0x0C}, {0x09}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // PIN_MISSILE
        {0x0F}, {0x11}, {0x24}, {0xFF}, {0xFF}, {0xFF}
    }, { // WATER_SPORT
        {0x1B}, {0x30}, {0x1A}, {0x33}, {0xFF}, {0xFF}
    }, { // WATER_GUN
        {0x1D}, {0x32}, {0x2C}, {0xFF}, {0xFF}, {0xFF}
    }, { // MIST_BALL
        {0x11}, {0x1B}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // WATER_PULSE
        {0x1B}, {0x30}, {0x2C}, {0x33}, {0xFF}, {0xFF}
    }, { // FURY_ATTACK
        {0x30}, {0x0C}, {0x2A}, {0x02}, {0xFF}, {0xFF}
    }, { // FURY_SWIPES
        {0x30}, {0x0C}, {0x12}, {0x33}, {0xFF}, {0xFF}
    }, { // DESTINY_BOND
        {0x09}, {0x0F}, {0x0C}, {0x1B}, {0xFF}, {0xFF}
    }, { // FALSE_SWIPE
        {0x1B}, {0x12}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FORESIGHT
        {0x1A}, {0x14}, {0x33}, {0x33}, {0xFF}, {0xFF}
    }, { // MIRROR_COAT
        {0x09}, {0x30}, {0x18}, {0xFF}, {0xFF}, {0xFF}
    }, { // FUTURE_SIGHT
        {0x27}, {0x30}, {0x12}, {0x33}, {0xFF}, {0xFF}
    }, { // MILK_DRINK
        {0x11}, {0x0E}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // CALM_MIND
        {0x1B}, {0x12}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MEGA_DRAIN
        {0x03}, {0x2C}, {0x03}, {0x33}, {0xFF}, {0xFF}
    }, { // MEGA_KICK
        {0x03}, {0x2A}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // MEGA_PUNCH
        {0x03}, {0x2A}, {0x2C}, {0xFF}, {0xFF}, {0xFF}
    }, { // MEGAHORN
        {0x03}, {0x2A}, {0x1A}, {0x33}, {0xFF}, {0xFF}
    }, { // HIDDEN_POWER
        {0x0F}, {0x09}, {0x21}, {0x30}, {0xFF}, {0xFF}
    }, { // METAL_CLAW
        {0x09}, {0x24}, {0x1B}, {0x33}, {0xFF}, {0xFF}
    }, { // ATTRACT
        {0x2A}, {0x00}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MIMIC
        {0x11}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FRUSTRATION
        {0x2C}, {0x03}, {0x1B}, {0x33}, {0xFF}, {0xFF}
    }, { // LEECH_SEED
        {0x0C}, {0x0E}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // METRONOME
        {0x09}, {0x18}, {0x18}, {0xFF}, {0xFF}, {0xFF}
    }, { // DREAM_EATER
        {0x0E}, {0x0C}, {0x30}, {0x33}, {0xFF}, {0xFF}
    }, { // ACID
        {0x00}, {0x11}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // MEDITATE
        {0x09}, {0x11}, {0x03}, {0x33}, {0xFF}, {0xFF}
    }, { // SNATCH
        {0x00}, {0xFF}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // LUSTER_PURGE
        {0x2A}, {0x30}, {0x32}, {0xFF}, {0xFF}, {0xFF}
    }, { // LEAF_BLADE
        {0x0C}, {0x05}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // RECYCLE
        {0x0C}, {0x12}, {0x24}, {0xFF}, {0xFF}, {0xFF}
    }, { // REFLECT
        {0x0C}, {0x09}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // REFRESH
        {0x0C}, {0x09}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // REVENGE
        {0x0C}, {0x09}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // DRAGON_RAGE
        {0x00}, {0x1B}, {0x05}, {0x33}, {0x33}, {0xFF}
    }, { // DRAGON_BREATH
        {0x00}, {0x1B}, {0x0B}, {0x33}, {0x33}, {0xFF}
    }, { // DRAGON_DANCE
        {0x00}, {0x1B}, {0x00}, {0x33}, {0xFF}, {0xFF}
    }, { // ICE_PUNCH
        {0x2C}, {0x1D}, {0x0E}, {0x1D}, {0xFF}, {0xFF}
    }, { // ICE_BEAM
        {0x12}, {0x0C}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // FURY_CUTTER
        {0x30}, {0x0C}, {0x2A}, {0x30}, {0xFF}, {0xFF}
    }, { // COMET_PUNCH
        {0x1D}, {0x0B}, {0x2C}, {0x33}, {0xFF}, {0xFF}
    }, { // SKULL_BASH
        {0x2A}, {0x33}, {0x00}, {0xFF}, {0xFF}, {0xFF}
    }, { // LOCK_ON
        {0x1B}, {0x1D}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROCK_BLAST
        {0x1B}, {0x00}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }, { // COTTON_SPORE
        {0x1D}, {0x1D}, {0x1A}, {0x33}, {0xFF}, {0xFF}
    }, { // STRUGGLE
        {0x2A}, {0x24}, {0x33}, {0xFF}, {0xFF}, {0xFF}
    }
};
#elif GERMAN
const struct BardSound gBardSounds_Moves1[][6] = {
    { // THUNDERBOLT
        {0x1A}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // IRON_TAIL
        {0x0B}, {0x0B}, {0x0B}, {0x11}, {0xFF}, {0xFF}
    }, { // ICE_BALL
        {0x1A}, {0x0B}, {0x29}, {0x0B}, {0xFF}, {0xFF}
    }, { // YAWN
        {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // LOVELY_KISS
        {0x1A}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // NIGHTMARE
        {0x02}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // MORNING_SUN
        {0x1A}, {0x0B}, {0x02}, {0x29}, {0x0B}, {0xFF}
    }, { // VITAL_THROW
        {0x11}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // DIG
        {0x02}, {0x29}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // THRASH
        {0x29}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SWEET_SCENT
        {0x1A}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // CHARM
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // RAIN_DANCE
        {0x0B}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // CONFUSE_RAY
        {0x1A}, {0x29}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // HAIL
        {0x02}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // AROMATHERAPY
        {0x02}, {0x1A}, {0x02}, {0x29}, {0xFF}, {0xFF}
    }, { // BUBBLE
        {0x29}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // ENCORE
        {0x29}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // CUT
        {0x0B}, {0x0B}, {0x11}, {0x0B}, {0xFF}, {0xFF}
    }, { // RAGE
        {0x02}, {0x0B}, {0x0B}, {0x11}, {0xFF}, {0xFF}
    }, { // SUPER_FANG
        {0x29}, {0x0B}, {0x02}, {0x02}, {0xFF}, {0xFF}
    }, { // PAIN_SPLIT
        {0x0B}, {0x11}, {0x0B}, {0x11}, {0x0B}, {0xFF}
    }, { // TORMENT
        {0x1A}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // STRING_SHOT
        {0x02}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // SWAGGER
        {0x02}, {0x0B}, {0x0B}, {0x0B}, {0x11}, {0xFF}
    }, { // SNORE
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // HEAL_BELL
        {0x11}, {0x02}, {0x1A}, {0x0B}, {0xFF}, {0xFF}
    }, { // SCREECH
        {0x0B}, {0x11}, {0x0B}, {0x0B}, {0x11}, {0xFF}
    }, { // ROCK_THROW
        {0x0B}, {0x11}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROCK_SMASH
        {0x0B}, {0x11}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // ROCK_SLIDE
        {0x0B}, {0x11}, {0x02}, {0x0B}, {0xFF}, {0xFF}
    }, { // WEATHER_BALL
        {0x0B}, {0x0B}, {0x1A}, {0x1A}, {0x1A}, {0x0B}
    }, { // WHIRLPOOL
        {0x11}, {0x29}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // FAKE_TEARS
        {0x29}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // SING
        {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPITE
        {0x1A}, {0xFF}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // AIR_CUTTER
        {0x11}, {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // AEROBLAST
        {0x29}, {0x1A}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SMOKESCREEN
        {0x02}, {0x29}, {0x1A}, {0x0B}, {0xFF}, {0xFF}
    }, { // PURSUIT
        {0x0B}, {0x1A}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // DOUBLE_SLAP
        {0x29}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // MIRROR_MOVE
        {0x11}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // OVERHEAT
        {0x11}, {0x0B}, {0x1A}, {0x0B}, {0xFF}, {0xFF}
    }, { // AURORA_BEAM
        {0x02}, {0x29}, {0x1A}, {0x02}, {0x02}, {0xFF}
    }, { // MEMENTO
        {0x0B}, {0x0B}, {0x1A}, {0x1A}, {0x11}, {0xFF}
    }, { // OCTAZOOKA
        {0x1A}, {0x02}, {0x29}, {0x29}, {0x02}, {0xFF}
    }, { // FLATTER
        {0x0B}, {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // ASTONISH
        {0x0B}, {0x02}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // WILL_O_WISP
        {0x11}, {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // RETURN
        {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // GRUDGE
        {0x02}, {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // STRENGTH
        {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // COUNTER
        {0x1A}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // FLAME_WHEEL
        {0x02}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // FLAMETHROWER
        {0x02}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // ODOR_SLEUTH
        {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SHARPEN
        {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // DOUBLE_TEAM
        {0x1A}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // GUST
        {0x11}, {0x1A}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // HARDEN
        {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // DISABLE
        {0x02}, {0x29}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // RAZOR_WIND
        {0x11}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // BIDE
        {0x0B}, {0x02}, {0x29}, {0x0B}, {0xFF}, {0xFF}
    }, { // CRUNCH
        {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // BITE
        {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // THUNDER
        {0x1A}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // THUNDER_PUNCH
        {0x1A}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // ENDEAVOR
        {0x1A}, {0x11}, {0x29}, {0x02}, {0x11}, {0x1A}
    }, { // FACADE
        {0x02}, {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // KARATE_CHOP
        {0x02}, {0x02}, {0x0B}, {0x02}, {0xFF}, {0xFF}
    }, { // CLAMP
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // WITHDRAW
        {0x02}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // CONSTRICT
        {0x29}, {0x02}, {0x0B}, {0x29}, {0xFF}, {0xFF}
    }, { // BRICK_BREAK
        {0x29}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROCK_TOMB
        {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // FOCUS_ENERGY
        {0x0B}, {0x0B}, {0x11}, {0x1A}, {0x29}, {0xFF}
    }, { // FOCUS_PUNCH
        {0x02}, {0x29}, {0x0B}, {0x02}, {0xFF}, {0xFF}
    }, { // GIGA_DRAIN
        {0x11}, {0x02}, {0x02}, {0x29}, {0x0B}, {0xFF}
    }, { // REVERSAL
        {0x0B}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // SMELLING_SALT
        {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPORE
        {0x11}, {0x1A}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // LEECH_LIFE
        {0x29}, {0x02}, {0x29}, {0x0B}, {0xFF}, {0xFF}
    }, { // SLASH
        {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SILVER_WIND
        {0x11}, {0x0B}, {0x02}, {0x29}, {0xFF}, {0xFF}
    }, { // METAL_SOUND
        {0x0B}, {0x02}, {0x02}, {0x29}, {0xFF}, {0xFF}
    }, { // GRASS_WHISTLE
        {0x02}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // TICKLE
        {0x02}, {0x02}, {0x1A}, {0x0B}, {0xFF}, {0xFF}
    }, { // SPIDER_WEB
        {0x11}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // CRABHAMMER
        {0x02}, {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // HAZE
        {0x29}, {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // MEAN_LOOK
        {0x1A}, {0x1A}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // CROSS_CHOP
        {0x0B}, {0x29}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // OUTRAGE
        {0x29}, {0x02}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // LOW_KICK
        {0x29}, {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // ANCIENT_POWER
        {0x02}, {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // SYNTHESIS
        {0x11}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // AGILITY
        {0x02}, {0x11}, {0x11}, {0x0B}, {0xFF}, {0xFF}
    }, { // RAPID_SPIN
        {0x29}, {0x1A}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // ICY_WIND
        {0x0B}, {0x11}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // MIND_READER
        {0x11}, {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // COSMIC_POWER
        {0x1A}, {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // SKY_ATTACK
        {0x11}, {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // POWDER_SNOW
        {0x29}, {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // FOLLOW_ME
        {0x1A}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // METEOR_MASH
        {0x0B}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // ENDURE
        {0x02}, {0x29}, {0x02}, {0x29}, {0xFF}, {0xFF}
    }, { // ROLLOUT
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SCARY_FACE
        {0x11}, {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // PSYBEAM
        {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // PSYWAVE
        {0x11}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // PSYCHIC
        {0x11}, {0x1A}, {0x11}, {0x0B}, {0x0B}, {0xFF}
    }, { // HYPNOSIS
        {0x11}, {0x1A}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // UPROAR
        {0x02}, {0x29}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // WATER_SPOUT
        {0x1A}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // SIGNAL_BEAM
        {0x02}, {0x0B}, {0x0B}, {0x29}, {0x0B}, {0xFF}
    }, { // PSYCH_UP
        {0x11}, {0x1A}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // SUBMISSION
        {0x11}, {0x0B}, {0x1A}, {0x0B}, {0xFF}, {0xFF}
    }, { // RECOVER
        {0x0B}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // EARTHQUAKE
        {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // NATURE_POWER
        {0x02}, {0x29}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // LICK
        {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // FLAIL
        {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // TAIL_WHIP
        {0x29}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // SELF_DESTRUCT
        {0x11}, {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // STUN_SPORE
        {0x02}, {0x0B}, {0x1A}, {0x0B}, {0xFF}, {0xFF}
    }, { // BIND
        {0x02}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // SHADOW_PUNCH
        {0x11}, {0x0B}, {0x02}, {0x29}, {0xFF}, {0xFF}
    }, { // SHADOW_BALL
        {0x29}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // CHARGE
        {0x02}, {0x0B}, {0x1A}, {0x02}, {0xFF}, {0xFF}
    }, { // MIST
        {0x0B}, {0x11}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // FISSURE
        {0x0B}, {0x1A}, {0x11}, {0x29}, {0xFF}, {0xFF}
    }, { // EXTREME_SPEED
        {0x29}, {0x1A}, {0x0B}, {0x1A}, {0xFF}, {0xFF}
    }, { // EXTRASENSORY
        {0x1A}, {0x0B}, {0x0B}, {0x1A}, {0xFF}, {0xFF}
    }, { // SAFEGUARD
        {0x1A}, {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // ABSORB
        {0x02}, {0x1A}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // SKY_UPPERCUT
        {0x11}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // SKILL_SWAP
        {0x0B}, {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // SKETCH
        {0x02}, {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // HEADBUTT
        {0x1A}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // DOUBLE_EDGE
        {0x11}, {0x11}, {0x1A}, {0x02}, {0x0B}, {0xFF}
    }, { // SANDSTORM
        {0x02}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SAND_ATTACK
        {0x02}, {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // SAND_TOMB
        {0x02}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPARK
        {0x29}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // SWIFT
        {0x0B}, {0x02}, {0x29}, {0x0B}, {0xFF}, {0xFF}
    }, { // KINESIS
        {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SMOG
        {0x1A}, {0xFF}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // GROWTH
        {0x02}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SACRED_FIRE
        {0x0B}, {0x29}, {0x0B}, {0x0B}, {0x29}, {0x0B}
    }, { // SHEER_COLD
        {0x0B}, {0x11}, {0x0B}, {0x0B}, {0x0B}, {0xFF}
    }, { // SOLAR_BEAM
        {0x1A}, {0x02}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // SONIC_BOOM
        {0x29}, {0x02}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // FLY
        {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }
};

const struct BardSound gBardSounds_Moves2[][6] = {
    { // TACKLE
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // EXPLOSION
        {0x0B}, {0x1A}, {0x11}, {0x1A}, {0xFF}, {0xFF}
    }, { // DIVE
        {0x02}, {0x29}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // FIRE_BLAST
        {0x0B}, {0x29}, {0x0B}, {0x29}, {0xFF}, {0xFF}
    }, { // WATERFALL
        {0x02}, {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // MUDDY_WATER
        {0x0B}, {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // STOCKPILE
        {0x1A}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SLAM
        {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // TWISTER
        {0x11}, {0x1A}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // BULLET_SEED
        {0x29}, {0x0B}, {0x02}, {0x02}, {0xFF}, {0xFF}
    }, { // TWINEEDLE
        {0x29}, {0x1A}, {0x02}, {0x0B}, {0xFF}, {0xFF}
    }, { // SOFT_BOILED
        {0x0B}, {0x11}, {0x0B}, {0x11}, {0xFF}, {0xFF}
    }, { // EGG_BOMB
        {0x0B}, {0x11}, {0x0B}, {0x1A}, {0x0B}, {0xFF}
    }, { // FAINT_ATTACK
        {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // BARRAGE
        {0x02}, {0x02}, {0x1A}, {0xFF}, {0xFF}, {0xFF}
    }, { // MINIMIZE
        {0x1A}, {0x11}, {0x02}, {0x1A}, {0xFF}, {0xFF}
    }, { // SEISMIC_TOSS
        {0x0B}, {0x1A}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // SUPERSONIC
        {0x29}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // TAUNT
        {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // MOONLIGHT
        {0x1A}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // PECK
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // ARM_THRUST
        {0x02}, {0x1A}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // HORN_ATTACK
        {0x1A}, {0x02}, {0x02}, {0x0B}, {0xFF}, {0xFF}
    }, { // HORN_DRILL
        {0x1A}, {0x1A}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // WING_ATTACK
        {0x11}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // AERIAL_ACE
        {0x02}, {0x0B}, {0x1A}, {0x02}, {0xFF}, {0xFF}
    }, { // SWORDS_DANCE
        {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // VINE_WHIP
        {0x02}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // CONVERSION
        {0x29}, {0x02}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // CONVERSION_2
        {0x29}, {0x02}, {0x29}, {0x0B}, {0x11}, {0xFF}
    }, { // HELPING_HAND
        {0x0B}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // IRON_DEFENSE
        {0x0B}, {0x11}, {0x0B}, {0x02}, {0x0B}, {0xFF}
    }, { // TELEPORT
        {0x0B}, {0x0B}, {0x1A}, {0xFF}, {0xFF}, {0xFF}
    }, { // THUNDER_SHOCK
        {0x1A}, {0x0B}, {0x1A}, {0xFF}, {0xFF}, {0xFF}
    }, { // SHOCK_WAVE
        {0x1A}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // QUICK_ATTACK
        {0x29}, {0x29}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // SWEET_KISS
        {0x11}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // THUNDER_WAVE
        {0x1A}, {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // ZAP_CANNON
        {0x11}, {0x02}, {0x1A}, {0x0B}, {0xFF}, {0xFF}
    }, { // BLOCK
        {0x11}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // HOWL
        {0x02}, {0x29}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // POISON_GAS
        {0x11}, {0x1A}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // TOXIC
        {0x1A}, {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // POISON_FANG
        {0x11}, {0x02}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // POISON_POWDER
        {0x11}, {0x29}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // POISON_STING
        {0x11}, {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPIKE_CANNON
        {0x1A}, {0x02}, {0x1A}, {0x0B}, {0xFF}, {0xFF}
    }, { // ACID_ARMOR
        {0x0B}, {0x29}, {0x0B}, {0x02}, {0x0B}, {0xFF}
    }, { // TAKE_DOWN
        {0x1A}, {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // JUMP_KICK
        {0x29}, {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // BOUNCE
        {0x29}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // HI_JUMP_KICK
        {0x29}, {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // TRI_ATTACK
        {0x11}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // DRAGON_CLAW
        {0x02}, {0x0B}, {0x02}, {0x29}, {0x0B}, {0xFF}
    }, { // TRICK
        {0x11}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // TRIPLE_KICK
        {0x0B}, {0x11}, {0x02}, {0x11}, {0xFF}, {0xFF}
    }, { // DRILL_PECK
        {0x1A}, {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // MUD_SPORT
        {0x0B}, {0x29}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // MUD_SLAP
        {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // THIEF
        {0x02}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // AMNESIA
        {0x02}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // NIGHT_SHADE
        {0x02}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // GROWL
        {0x0B}, {0x29}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // SLACK_OFF
        {0x02}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // SURF
        {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROLE_PLAY
        {0x1A}, {0x0B}, {0x02}, {0x29}, {0xFF}, {0xFF}
    }, { // NEEDLE_ARM
        {0x11}, {0x0B}, {0x02}, {0x0B}, {0xFF}, {0xFF}
    }, { // DOUBLE_KICK
        {0x1A}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // SUNNY_DAY
        {0x1A}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // LEER
        {0x11}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // WISH
        {0x29}, {0x02}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // FAKE_OUT
        {0x1A}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // SLEEP_TALK
        {0x02}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // PAY_DAY
        {0x02}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // ASSIST
        {0x29}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // HEAT_WAVE
        {0x11}, {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // SLEEP_POWDER
        {0x02}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // REST
        {0x0B}, {0x1A}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // INGRAIN
        {0x0B}, {0x29}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // CONFUSION
        {0x1A}, {0x29}, {0x11}, {0x1A}, {0xFF}, {0xFF}
    }, { // BODY_SLAM
        {0x1A}, {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // SWALLOW
        {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // CURSE
        {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // HYDRO_PUMP
        {0x11}, {0x1A}, {0x29}, {0x0B}, {0xFF}, {0xFF}
    }, { // HYPER_VOICE
        {0x02}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // HYPER_BEAM
        {0x11}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // SUPERPOWER
        {0x02}, {0x1A}, {0x1A}, {0xFF}, {0xFF}, {0xFF}
    }, { // STEEL_WING
        {0x02}, {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPIT_UP
        {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // DYNAMIC_PUNCH
        {0x29}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // GUILLOTINE
        {0x11}, {0x1A}, {0x11}, {0x0B}, {0xFF}, {0xFF}
    }, { // VICE_GRIP
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // KNOCK_OFF
        {0x02}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // POUND
        {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // RAZOR_LEAF
        {0x02}, {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // BATON_PASS
        {0x02}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // PETAL_DANCE
        {0x0B}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPLASH
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // BUBBLE_BEAM
        {0x29}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // BELLY_DRUM
        {0x02}, {0x29}, {0x1A}, {0x0B}, {0xFF}, {0xFF}
    }, { // BARRIER
        {0x02}, {0x11}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // LIGHT_SCREEN
        {0x11}, {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SCRATCH
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // HYPER_FANG
        {0x11}, {0x0B}, {0x02}, {0x02}, {0xFF}, {0xFF}
    }, { // EMBER
        {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SECRET_POWER
        {0x0B}, {0x0B}, {0x11}, {0x02}, {0x29}, {0x0B}
    }, { // DIZZY_PUNCH
        {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // BULK_UP
        {0x1A}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // IMPRISON
        {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // FEATHER_DANCE
        {0x02}, {0x29}, {0x0B}, {0x0B}, {0x11}, {0x0B}
    }, { // WHIRLWIND
        {0x11}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // BEAT_UP
        {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // BLIZZARD
        {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // STOMP
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // FLASH
        {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // TEETER_DANCE
        {0x02}, {0x29}, {0x0B}, {0x02}, {0xFF}, {0xFF}
    }, { // CRUSH_CLAW
        {0x0B}, {0x02}, {0x02}, {0x29}, {0x0B}, {0xFF}
    }, { // BLAZE_KICK
        {0x0B}, {0x29}, {0x0B}, {0x0B}, {0x0B}, {0xFF}
    }, { // PRESENT
        {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // ERUPTION
        {0x0B}, {0x29}, {0x11}, {0x1A}, {0xFF}, {0xFF}
    }, { // SLUDGE
        {0x02}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SLUDGE_BOMB
        {0x02}, {0x1A}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // GLARE
        {0x11}, {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // TRANSFORM
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // POISON_TAIL
        {0x11}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROAR
        {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // BONE_RUSH
        {0x1A}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // CAMOUFLAGE
        {0x02}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // COVET
        {0x0B}, {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // TAIL_GLOW
        {0x0B}, {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // BONE_CLUB
        {0x1A}, {0x0B}, {0x0B}, {0x29}, {0x0B}, {0xFF}
    }, { // BONEMERANG
        {0x1A}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // FIRE_SPIN
        {0x0B}, {0x29}, {0x0B}, {0x11}, {0x0B}, {0xFF}
    }, { // FIRE_PUNCH
        {0x0B}, {0x29}, {0x0B}, {0x02}, {0xFF}, {0xFF}
    }, { // PERISH_SONG
        {0x02}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // WRAP
        {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // SPIKES
        {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // MAGNITUDE
        {0x11}, {0x0B}, {0x11}, {0x0B}, {0xFF}, {0xFF}
    }, { // MAGICAL_LEAF
        {0x02}, {0x29}, {0x0B}, {0x02}, {0xFF}, {0xFF}
    }, { // MAGIC_COAT
        {0x02}, {0x11}, {0x02}, {0x0B}, {0xFF}, {0xFF}
    }, { // MUD_SHOT
        {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // MACH_PUNCH
        {0x0B}, {0x1A}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // PROTECT
        {0x29}, {0x11}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // DEFENSE_CURL
        {0x0B}, {0x11}, {0x11}, {0x0B}, {0xFF}, {0xFF}
    }, { // ROLLING_KICK
        {0x0B}, {0x0B}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // SUBSTITUTE
        {0x0B}, {0x0B}, {0x02}, {0x1A}, {0xFF}, {0xFF}
    }, { // DETECT
        {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // PIN_MISSILE
        {0x02}, {0x0B}, {0x02}, {0x0B}, {0x0B}, {0xFF}
    }, { // WATER_SPORT
        {0x02}, {0x02}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // WATER_GUN
        {0x02}, {0x02}, {0x02}, {0x0B}, {0xFF}, {0xFF}
    }, { // MIST_BALL
        {0x0B}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // WATER_PULSE
        {0x02}, {0x02}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // FURY_ATTACK
        {0x29}, {0x11}, {0x0B}, {0x02}, {0xFF}, {0xFF}
    }, { // FURY_SWIPES
        {0x02}, {0x29}, {0x11}, {0x0B}, {0xFF}, {0xFF}
    }, { // DESTINY_BOND
        {0x02}, {0x02}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // FALSE_SWIPE
        {0x29}, {0x02}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // FORESIGHT
        {0x0B}, {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // MIRROR_COAT
        {0x11}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // FUTURE_SIGHT
        {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // MILK_DRINK
        {0x11}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // CALM_MIND
        {0x0B}, {0x02}, {0x0B}, {0x29}, {0xFF}, {0xFF}
    }, { // MEGA_DRAIN
        {0x0B}, {0x02}, {0x02}, {0x29}, {0x0B}, {0xFF}
    }, { // MEGA_KICK
        {0x0B}, {0x02}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // MEGA_PUNCH
        {0x0B}, {0x02}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // MEGAHORN
        {0x11}, {0x0B}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // HIDDEN_POWER
        {0x02}, {0x0B}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // METAL_CLAW
        {0x0B}, {0x02}, {0x02}, {0x29}, {0x0B}, {0xFF}
    }, { // ATTRACT
        {0x02}, {0x11}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // MIMIC
        {0x11}, {0x11}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // FRUSTRATION
        {0x29}, {0x02}, {0x11}, {0x1A}, {0xFF}, {0xFF}
    }, { // LEECH_SEED
        {0x0B}, {0x0B}, {0x02}, {0x0B}, {0xFF}, {0xFF}
    }, { // METRONOME
        {0x0B}, {0x1A}, {0x1A}, {0xFF}, {0xFF}, {0xFF}
    }, { // DREAM_EATER
        {0x02}, {0x29}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // ACID
        {0x0B}, {0x29}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // MEDITATE
        {0x0B}, {0x11}, {0x02}, {0x11}, {0x1A}, {0xFF}
    }, { // SNATCH
        {0x11}, {0x0B}, {0x02}, {0x0B}, {0xFF}, {0xFF}
    }, { // LUSTER_PURGE
        {0x0B}, {0x11}, {0x0B}, {0x0B}, {0xFF}, {0xFF}
    }, { // LEAF_BLADE
        {0x02}, {0x29}, {0x11}, {0x0B}, {0xFF}, {0xFF}
    }, { // RECYCLE
        {0x02}, {0x29}, {0x0B}, {0x0B}, {0x11}, {0x29}
    }, { // REFLECT
        {0x0B}, {0x0B}, {0x1A}, {0xFF}, {0xFF}, {0xFF}
    }, { // REFRESH
        {0x0B}, {0x11}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // REVENGE
        {0x0B}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // DRAGON_RAGE
        {0x02}, {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}
    }, { // DRAGON_BREATH
        {0x0B}, {0x29}, {0x1A}, {0x0B}, {0xFF}, {0xFF}
    }, { // DRAGON_DANCE
        {0x02}, {0x0B}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // ICE_PUNCH
        {0x0B}, {0x11}, {0x11}, {0xFF}, {0xFF}, {0xFF}
    }, { // ICE_BEAM
        {0x0B}, {0x11}, {0x02}, {0xFF}, {0xFF}, {0xFF}
    }, { // FURY_CUTTER
        {0x1A}, {0x11}, {0x0B}, {0xFF}, {0xFF}, {0xFF}
    }, { // COMET_PUNCH
        {0x1A}, {0x0B}, {0x0B}, {0x11}, {0xFF}, {0xFF}
    }, { // SKULL_BASH
        {0x0B}, {0x0B}, {0x29}, {0x0B}, {0xFF}, {0xFF}
    }, { // LOCK_ON
        {0x11}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // ROCK_BLAST
        {0x0B}, {0x29}, {0xFF}, {0xFF}, {0xFF}, {0xFF}
    }, { // COTTON_SPORE
        {0x02}, {0x29}, {0x1A}, {0x02}, {0x02}, {0xFF}
    }, { // STRUGGLE
        {0x0B}, {0x0B}, {0x11}, {0x0B}, {0xFF}, {0xFF}
    }
};
#endif // ENGLISH/GERMAN

#endif //GUARD_DATA_BARD_MUSIC_MOVES_H
